# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .risk_level import RiskLevel

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TransactionRiskScoringResult(pydantic.BaseModel):
    trs_score: float = pydantic.Field(alias="trsScore", description="Transaction risk scoring score")
    trs_risk_level: RiskLevel = pydantic.Field(alias="trsRiskLevel")
    origin_user_cra_risk_score: typing.Optional[float] = pydantic.Field(
        alias="originUserCraRiskScore", description="Origin user's CRA risk score"
    )
    destination_user_cra_risk_score: typing.Optional[float] = pydantic.Field(
        alias="destinationUserCraRiskScore", description="Destination user's CRA risk score"
    )
    origin_user_cra_risk_level: typing.Optional[RiskLevel] = pydantic.Field(alias="originUserCraRiskLevel")
    destination_user_cra_risk_level: typing.Optional[RiskLevel] = pydantic.Field(alias="destinationUserCraRiskLevel")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
