from unittest.mock import patch
import json
from tests.utils import fixtures_path, fake_new_emission

from hestia_earth.models.stehfestBouwman2006.noxToAirAllOrigins import TERM_ID, run, _get_value, _should_run

class_path = f"hestia_earth.models.stehfestBouwman2006.{TERM_ID}"
fixtures_folder = f"{fixtures_path}/stehfestBouwman2006/{TERM_ID}"


@patch(f"{class_path}.residue_nitrogen", return_value=0)
@patch(f"{class_path}._most_relevant_measurement_value", return_value=[])
def test_should_run(mock_most_relevant_measurement_value, *args):
    # no measurements => no run
    cycle = {'inputs': [], 'measurements': []}
    should_run, *args = _should_run(cycle)
    assert not should_run

    # with measurements => no run
    mock_most_relevant_measurement_value.return_value = [10]
    cycle['measurements'] = [{}]
    should_run, *args = _should_run(cycle)
    assert not should_run

    # with kg N inputs => run
    cycle['inputs'] = [{
        'term': {
            'units': 'kg N'
        },
        'value': [100]
    }]
    should_run, *args = _should_run(cycle)
    assert should_run


def test_get_value():
    ecoClimateZone = '5'
    nitrogenContent = 100
    N_total = 7
    assert _get_value(ecoClimateZone, nitrogenContent, N_total) == 0.08456876974469733


@patch(f"{class_path}._new_emission", side_effect=fake_new_emission)
def test_run(*args):
    with open(f"{fixtures_folder}/cycle.jsonld", encoding='utf-8') as f:
        cycle = json.load(f)

    with open(f"{fixtures_folder}/result.jsonld", encoding='utf-8') as f:
        expected = json.load(f)

    value = run(cycle)
    assert value == expected
