# This is an automatically generated R code. Don't edit.
# Generated by 
# /home/sokol/.local/bin/influx_s --pref e_coli --pref e_coli_growth --pref ../prl_exp/mtf/e_coli_glc1-6n
# at Thu Dec 12 16:57:46 2024.

# Copyright 2011-2024, INRAE/INSA/CNRS, France.
    
# working dir
dirw="/home/sokol/sysbio/dev/ftbl2sys/influx_si/test/ok/mtf"

# result dir
dirres="/home/sokol/sysbio/dev/ftbl2sys/influx_si/test/ok/mtf/e_coli_growth_res"
write_res=nchar(dirres) > 0L

# installation dir (where influx_si/R/*.R live)
dirr="/home/sokol/sysbio/dev/ftbl2sys/influx_si/R"
# short base name of the FTBL (withount '.ftbl')
baseshort="e_coli_growth"

if (nchar(dirres)) {
    fcerr=file(file.path(dirres, sprintf("%s.err", baseshort)), "ab")
    fclog=file(file.path(dirres, sprintf("%s.log", baseshort)), "ab")
} else {
    fcerr=base::stderr()
    fclog=base::stdout()
}
if (options()$warn == 0)
    options(warn=1)
options(digits.secs=2)

case_i=FALSE

source(file.path(dirr, "libs.R"), echo=FALSE)

# define matprod for simple_triplet_matrix
`%stm%` = slam::matprod_simple_triplet_matrix

# default options
version=FALSE
noopt=FALSE
noscale=FALSE
meth="nlsic"
fullsys=FALSE
emu=FALSE
irand=FALSE
sens=""
cupx=0.999
cupn=1.e3
cupp=1.e5
clownr=0
cinout=0
clowp=1.e-8
np=0
ln=FALSE
tikhreg=FALSE
sln=FALSE
lim=FALSE
zc=-.Machine$double.xmax
ffguess=FALSE
fdfit=FALSE
addnoise=FALSE
fseries=""
iseries=""
seed=-.Machine$integer.max
excl_outliers=FALSE
TIMEIT=FALSE
prof=FALSE
time_order="1"
wkvh=FALSE
parR=FALSE
tol=1.e-10

# get runtime arguments
help='==SUPPRESS=='
version='==SUPPRESS=='
TIMEIT=TRUE
parR=TRUE

# synonymous
myver=version
optimize=!noopt
methods=trimws(strsplit(meth, ",")[[1L]])
sensitive=sens
least_norm=ln
initrand=irand

vernum="7.2.1.90"

# sanity check for command line parameters
if (substring(sensitive, 1, 3)=="mc=") {
   # read the mc iteration number
   nmc=as.integer(substring(sensitive, 4))
   sensitive="mc"
} else if (sensitive=="mc") {
   nmc=10
} else if (nchar(sensitive) > 0L) {
   stop_mes("Option '--sens SENS' got unknown argument SENS '", sensitive,"'\n",
      "Expected 'mc[=N]' where optional N is a number of Monter-Carlo iterations", file=fcerr)
}
# cupx==0 means no upper limit => cupx=1
cupx=ifelse(cupx, cupx, 1)
if (cupx < 0 || cupx > 1) {
   stop_mes("Option '--cupx N' must have N in the interval [0,1]\n",
      "Instead, the value ", cupx, " is given.", file=fcerr)
}
if (cinout < 0) {
   stop_mes("Option '--cinout N' must have N non negative\n",
      "Instead, the value ", cinout, " is given.", file=fcerr)
}
# minimization method
validmethods=c("BFGS", "Nelder-Mead", "SANN", "ipopt", "nlsic", "pso")
if (! all(igood <- (methods %in% validmethods))) {
   cat(paste("***Warning: optimization methods ", paste0(methods[!igood], collapse=", "), " are not implemented. 'nlsic' is used instead."), "\n", sep="", file=fclog)
   methods[!igood]="nlsic"
}
if ("ipopt" %in% methods) {
   installed=suppressPackageStartupMessages(library(ipoptr, logical.return=TRUE))
   if (!installed) {
      stop_mes("An optimization method ipopt is requested but not available in this R installation", file=fcerr)
   }
}
if (least_norm && sln) {
   stop_mes("Options --ln and --sln cannot be activated simultaniously.", file=fcerr)
}

avaco=try(detectCores(), silent=TRUE)
if (inherits(avaco, "try-error")) {
   avaco=NULL
}
if (np > 0L && np < 1L) {
   np=round(avaco*np)
} else if (np >= 1L) {
   np=round(np)
} else {
   np=avaco
}
if (is.null(np) || np <= 0L) {
   np=1L
}
if (sensitive=="mc") {
   np=min(np, nmc)
}
options(mc.cores=np)

if (least_norm+tikhreg+lim > 1) {
   stop_mes("Options --ln, --lim and --tikhreg cannot be activated simultaneously. Use only one of them at a time.", file=fcerr)
}
lsi_fun=lsi
if (least_norm || sln) {
   lsi_fun=lsi_ln
} else if (tikhreg) {
   lsi_fun=lsi_reg
} else if (lim) {
   suppressPackageStartupMessages(library(limSolve));
   lsi_fun=lsi_lim
}
if (zc==-.Machine$double.xmax) {
   # no zero scrossing to apply
   zerocross=F
} else {
   if (zc < 0.) {
      stop_mes("Zero crossing value ZC must be non negative, instead ", zc, " is given.", file=fcerr)
   }
   zerocross=T
}
if (seed==-.Machine$integer.max) {
   # no seed to apply
   set_seed=F
} else {
   set_seed=T
   set.seed(seed)
}
time_order=gsub("\\s", "", time_order) # remove spaces if any
if (!(time_order %in% c("1", "2", "1,2"))) {
   stop_mes("time_order must be '1', '2' or '1,2'. Instead got '", time_order, "'", file=fcerr)
}
opts=commandArgs()
# end command line argument proceeding

# get some cumomer tools
source(file.path(dirr, "opt_cumo_tools.R"))
#loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))

lab_resid=cumo_resid
lab_sim=param2fl_x
jx_f=new.env()
    control_ftbl=list(`default`=list(`maxit`=50))
if (TIMEIT) {
   cat("rinit   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# R profiling
if (prof)
   Rprof(file.path(dirw, sprintf("%s.Rprof", baseshort)))

nm_list=list()
nb_f=list()

if (TIMEIT) {
   cat("r_flux  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# fwd-rev flux names
nm_fwrv=c("fwd.CO2upt", "fwd.Cit_gr", "fwd.Fru6P_gr", "fwd.FruBP_gr", "fwd.Glc6P_gr", "fwd.Glucupt", "fwd.Glucupt_1",
"fwd.Glucupt_U", "fwd.Gnt6P_gr", "fwd.HR1", "fwd.HR2", "fwd.HR3", "fwd.HR4", "fwd.HR5", "fwd.Mal_gr", "fwd.PEP_gr",
"fwd.PGA_gr", "fwd.Rib5P_gr", "fwd.Rub5P_gr", "fwd.Suc_gr", "fwd.Xul5P_gr", "fwd.akgdh", "fwd.ald", "fwd.bs_DHAP",
"fwd.bs_accoa", "fwd.bs_akg", "fwd.bs_e4p", "fwd.bs_fru6P", "fwd.bs_glc6P", "fwd.bs_oaa", "fwd.bs_pep", "fwd.bs_pga",
"fwd.bs_pyr", "fwd.bs_rib5P", "fwd.citsynth", "fwd.edd", "fwd.eno", "fwd.fum_a", "fwd.fum_b", "fwd.gnd", "fwd.idh",
"fwd.maldh", "fwd.out_Ac", "fwd.out_co2", "fwd.pdh", "fwd.pfk", "fwd.pgi", "fwd.pgk", "fwd.ppc", "fwd.pyk", "fwd.rib",
"fwd.xul", "fwd.zwf", "rev.CO2upt", "rev.Cit_gr", "rev.Fru6P_gr", "rev.FruBP_gr", "rev.Glc6P_gr", "rev.Glucupt",
"rev.Glucupt_1", "rev.Glucupt_U", "rev.Gnt6P_gr", "rev.HR1", "rev.HR2", "rev.HR3", "rev.HR4", "rev.HR5", "rev.Mal_gr",
"rev.PEP_gr", "rev.PGA_gr", "rev.Rib5P_gr", "rev.Rub5P_gr", "rev.Suc_gr", "rev.Xul5P_gr", "rev.akgdh", "rev.ald",
"rev.bs_DHAP", "rev.bs_accoa", "rev.bs_akg", "rev.bs_e4p", "rev.bs_fru6P", "rev.bs_glc6P", "rev.bs_oaa", "rev.bs_pep",
"rev.bs_pga", "rev.bs_pyr", "rev.bs_rib5P", "rev.citsynth", "rev.edd", "rev.eno", "rev.fum_a", "rev.fum_b", "rev.gnd",
"rev.idh", "rev.maldh", "rev.out_Ac", "rev.out_co2", "rev.pdh", "rev.pfk", "rev.pgi", "rev.pgk", "rev.ppc", "rev.pyk",
"rev.rib", "rev.xul", "rev.zwf")

# edge to netflux name translator
edge2fl=c("f.n.Glucupt_1", "d.n.Glucupt_U", "d.n.Glucupt", "c.n.CO2upt", "f.n.pgi", "d.n.pfk", "d.n.ald", "d.n.ald", "d.n.ald",
"d.n.pgk", "d.n.eno", "d.n.pyk", "d.n.zwf", "d.n.gnd", "d.n.gnd", "d.n.gnd", "d.n.rib", "d.n.xul", "f.n.edd", "f.n.edd",
"f.n.edd", "d.n.HR1", "d.n.HR1", "d.n.HR1", "d.n.HR2", "d.n.HR2", "d.n.HR2", "d.n.HR3", "d.n.HR3", "d.n.HR3", "d.n.HR4",
"d.n.HR4", "d.n.HR4", "d.n.HR5", "d.n.HR5", "d.n.HR5", "d.n.pdh", "d.n.pdh", "d.n.pdh", "d.n.citsynth", "d.n.citsynth",
"d.n.citsynth", "d.n.idh", "d.n.idh", "d.n.idh", "d.n.akgdh", "d.n.akgdh", "d.n.akgdh", "d.n.fum_a", "d.n.fum_b",
"d.n.maldh", "d.n.ppc", "d.n.ppc", "d.n.ppc", "c.n.bs_glc6P", "c.n.bs_fru6P", "c.n.bs_pga", "c.n.bs_DHAP", "c.n.bs_pyr",
"c.n.bs_e4p", "c.n.bs_rib5P", "c.n.bs_pep", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_oaa", "d.n.out_co2", "f.n.out_Ac",
"g.n.Cit_gr", "g.n.FruBP_gr", "g.n.Mal_gr", "g.n.PEP_gr", "g.n.PGA_gr", "g.n.Suc_gr", "g.n.Fru6P_gr", "g.n.Glc6P_gr",
"g.n.Gnt6P_gr", "c.n.Rib5P_gr", "g.n.Rub5P_gr", "g.n.Xul5P_gr")
names(edge2fl)=c("Gluc_1 (Glucupt_1) Glc", "Gluc_U (Glucupt_U) Glc", "Glc (Glucupt) Glc6P", "CO2_ext (CO2upt) CO2", "Glc6P (pgi) Fru6P",
"Fru6P (pfk) FruBP", "FruBP (ald) ald", "ald (ald1) GA3P", "ald (ald2) GA3P", "GA3P (pgk) PGA", "PGA (eno) PEP", "PEP
(pyk) Pyr", "Glc6P (zwf) Gnt6P", "Gnt6P (gnd) gnd", "gnd (gnd) CO2", "gnd (gnd) Rub5P", "Rub5P (rib) Rib5P", "Rub5P
(xul) Xul5P", "Gnt6P (edd) edd", "edd (edd) Pyr", "edd (edd) GA3P", "GA3P (HR1) HR1", "E2 (HR1) HR1", "HR1 (HR1) Xul5P",
"Fru6P (HR2) HR2", "HR2 (HR2) Ery4P", "HR2 (HR2) E2", "Fru6P (HR3) HR3", "HR3 (HR3) GA3P", "HR3 (HR3) E3", "Sed7P (HR4)
HR4", "HR4 (HR4) Rib5P", "HR4 (HR4) E2", "Ery4P (HR5) HR5", "E3 (HR5) HR5", "HR5 (HR5) Sed7P", "Pyr (pdh) pdh", "pdh
(pdh) AcCoA", "pdh (pdh) CO2", "AcCoA (citsynth) citsynth", "OAA (citsynth) citsynth", "citsynth (citsynth) Cit", "Cit
(idh) idh", "idh (idh) AKG", "idh (idh) CO2", "AKG (akgdh) akgdh", "akgdh (akgdh) Suc", "akgdh (akgdh) CO2", "Suc
(fum_a) Mal", "Suc (fum_b) Mal", "Mal (maldh) OAA", "PEP (ppc) ppc", "CO2 (ppc) ppc", "ppc (ppc) OAA", "Glc6P (bs_glc6P)
BM_Glc6P", "Fru6P (bs_fru6P) BM_Fru6P", "PGA (bs_pga) BM_PGA", "GA3P (bs_DHAP) Glp", "Pyr (bs_pyr) BM_Pyr", "Ery4P
(bs_e4p) BM_Ery4P", "Rib5P (bs_rib5P) BM_Rib5P", "PEP (bs_pep) BM_PEP", "AcCoA (bs_accoa) BM_AcCoA", "AKG (bs_akg)
BM_AKG", "OAA (bs_oaa) BM_OAA", "CO2 (out_co2) CO2_out", "AcCoA (out_Ac) Acetate", "Cit (Cit_gr) Cit_gr", "FruBP
(FruBP_gr) FruBP_gr", "Mal (Mal_gr) Mal_gr", "PEP (PEP_gr) PEP_gr", "PGA (PGA_gr) PGA_gr", "Suc (Suc_gr) Suc_gr", "Fru6P
(Fru6P_gr) Fru6P_gr", "Glc6P (Glc6P_gr) Glc6P_gr", "Gnt6P (Gnt6P_gr) Gnt6P_gr", "Rib5P (Rib5P_gr) Rib5P_gr", "Rub5P
(Rub5P_gr) Rub5P_gr", "Xul5P (Xul5P_gr) Xul5P_gr")

# initialize the linear system Afl*flnx=bfl (0-weight cumomers)
# unknown net flux names
nm_fln=c("d.n.Glucupt", "d.n.Glucupt_U", "d.n.HR1", "d.n.HR2", "d.n.HR3", "d.n.HR4", "d.n.HR5", "d.n.akgdh", "d.n.ald",
"d.n.citsynth", "d.n.eno", "d.n.fum_a", "d.n.fum_b", "d.n.gnd", "d.n.idh", "d.n.maldh", "d.n.out_co2", "d.n.pdh",
"d.n.pfk", "d.n.pgk", "d.n.ppc", "d.n.pyk", "d.n.rib", "d.n.xul", "d.n.zwf")
nb_fln=length(nm_fln)
fln=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.1, 0.0, 1.21144, 0.0,
0.0, 0.4)
names(fln)=nm_fln
# unknown xch flux names
nm_flx=c("d.x.fum_b")
nb_flx=length(nm_flx)
flx=c(0.0)
names(flx)=nm_flx
nm_fl=c(nm_fln, nm_flx)
nb_fl=nb_fln+nb_flx
fl=c(fln, flx)
# gather flux names in a list
nm_list$flnx=nm_fl
nm_list$fwrv=nm_fwrv

# carbon length of metabolites
clen=c(6,6,6,6,1,1,6,6,3,3,3,3,6,5,5,5,2,4,3,7,2,4,6,5,4,4,6,6,3,3,3,4,5,3,2,5,4,1,2)
names(clen)=c("Gluc_1","Glc","Gluc_U","Glc6P","CO2_ext","CO2","Fru6P","FruBP","GA3P","PGA","PEP","Pyr","Gnt6P","Rub5P","Rib5P","Xul5P","E2","Ery4P","E3","Sed7P","AcCoA","OAA","Cit","AKG","Suc","Mal","BM_Glc6P","BM_Fru6P","BM_PGA","Glp","BM_Pyr","BM_Ery4P","BM_Rib5P","BM_PEP","BM_AcCoA","BM_AKG","BM_OAA","CO2_out","Acetate")

# metabolite pools are : all (poolall) which is divided in free (poolf) and
# constrained (poolc)

# constrained pool
poolc=c(1e-07)
nm_poolc=c("pc:Rib5P")
if (length(nm_poolc)) {
   names(nm_poolc)=substring(nm_poolc, 4)
}
names(poolc)=nm_poolc

# starting values for free pool (the same number and the same alphabetic order than free growth fluxes, if present)
poolf=c(0.001630397300073748, 0.00010006707551232429, 0.0004927839907571225, 0.0004905098655004916, 0.00014480899018442714,
0.0006054470296805187, 5.501298486110693e-05, 0.0005008619523631337, 5.172415742935172e-05, 0.0014849826568155515,
0.0002068966297174069)
nm_poolf=c("pf:Cit", "pf:Fru6P", "pf:FruBP", "pf:Glc6P", "pf:Gnt6P", "pf:Mal", "pf:PEP", "pf:PGA", "pf:Rub5P", "pf:Suc", "pf:Xul5P")
if (length(nm_poolf)) {
   names(nm_poolf)=substring(nm_poolf, 4)
}
names(poolf)=nm_poolf
nb_poolf=length(poolf)
nb_f$nb_poolf=nb_poolf

nm_poolall=c(nm_poolf, nm_poolc)
poolall=as.numeric(c(poolf, poolc))
names(poolall)=nm_poolall
pool=poolall
nm_list$poolf=nm_poolf
nm_list$poolc=nm_poolc
nm_list$poolall=nm_poolall

# flux matrix
nb_flr=26
if (nb_fl) {
   Afl=matrix(0, nrow=nb_flr, ncol=nb_fl)
       Afl[1, c(1, 2)]=c(-1.0, 1.0)
           Afl[2, c(1, 25)]=c(1.0, -1.0)
           Afl[3, c(8, 14, 15, 17, 18, 21)]=c(1.0, 1.0, 1.0, -1.0, 1.0, -1.0)
           Afl[4, c(4, 5, 19)]=c(-1.0, -1.0, -1.0)
           Afl[5, c(9, 19)]=c(-1.0, 1.0)
           Afl[6, c(3, 5, 9, 20)]=c(-1.0, 1.0, 2.0, -1.0)
           Afl[7, c(11, 20)]=c(-1.0, 1.0)
           Afl[8, c(11, 21, 22)]=c(1.0, -1.0, -1.0)
           Afl[9, c(18, 22)]=c(-1.0, 1.0)
           Afl[10, c(14, 25)]=c(-1.0, 1.0)
           Afl[11, c(14, 23, 24)]=c(1.0, -1.0, -1.0)
           Afl[12, c(6, 23)]=c(1.0, 1.0)
           Afl[13, c(3, 24)]=c(1.0, 1.0)
           Afl[14, c(3, 4, 6)]=c(-1.0, 1.0, 1.0)
           Afl[15, c(4, 7)]=c(1.0, -1.0)
           Afl[16, c(5, 7)]=c(1.0, -1.0)
           Afl[17, c(6, 7)]=c(-1.0, 1.0)
           Afl[18, c(10, 18)]=c(-1.0, 1.0)
           Afl[19, c(10, 16, 21)]=c(-1.0, 1.0, 1.0)
           Afl[20, c(10, 15)]=c(1.0, -1.0)
           Afl[21, c(8, 15)]=c(-1.0, 1.0)
           Afl[22, c(8, 12, 13)]=c(1.0, -1.0, -1.0)
           Afl[23, c(12, 13, 16)]=c(1.0, 1.0, -1.0)
           Afl[24, c(2)]=c(1.0)
           Afl[25, c(12, 13)]=c(1.0, -1.0)
           Afl[26, c(26)]=c(-1.0)
        } else {
   Afl=matrix(0., nb_fl, nb_fl)
}
dimnames(Afl)=list(c("Glc", "Glc6P", "CO2", "Fru6P", "FruBP", "GA3P", "PGA", "PEP", "Pyr", "Gnt6P", "Rub5P", "Rib5P", "Xul5P", "E2", "Ery4P",
"E3", "Sed7P", "AcCoA", "OAA", "Cit", "AKG", "Suc", "Mal", "eq net: Glucupt_1+Glucupt_U=1: 202", "eq net: fum_a-fum_b=0:
203", "eq xch: fum_a-fum_b=0: 206"), nm_fl)
#browser()
# prepare param (Theta) vector
# order: free flux net, free flux xch, scale label, scale mass, scale peak
param=numeric(0)
nm_par=c()
# free net fluxes
nb_ffn=4
nm_ffn=c("f.n.Glucupt_1", "f.n.edd", "f.n.out_Ac", "f.n.pgi")
# starting values for iterations
param=c(param, c(0.8128, 0.1, 0.48, 0.1))
if (nb_ffn) {
   nm_par=c(nm_par, nm_ffn)
}
# free xch fluxes
nb_ffx=11
nm_ffx=c("f.x.HR2", "f.x.HR3", "f.x.HR5", "f.x.ald", "f.x.eno", "f.x.pfk", "f.x.pgi", "f.x.pgk", "f.x.ppc", "f.x.pyk", "f.x.xul")
# starting values for iterations
param=c(param, c(0.0151117, 0.14, 0.02, 0.4, 0.99, 0.01, 0.4, 0.99, 0.2, 0.4, 0.0))
if (nb_ffx) {
   nm_par=c(nm_par, nm_ffx)
}
names(param)=nm_par
ff=param
nm_ff=c(nm_ffn, nm_ffx)
nm_list$ff=nm_ff
nb_param=length(param)
# scaling factors are added to param later

nb_ff=nb_ffn+nb_ffx

# constrained fluxes
# net
nb_fcn=13
nm_fcn=c("c.n.CO2upt", "c.n.Rib5P_gr", "c.n.bs_DHAP", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_e4p", "c.n.bs_fru6P", "c.n.bs_glc6P",
"c.n.bs_oaa", "c.n.bs_pep", "c.n.bs_pga", "c.n.bs_pyr", "c.n.bs_rib5P")
fcn=c(0.77, 8e-08, 0.0083, 0.1895, 0.0692, 0.0247, 0.0045, 0.0132, 0.1146, 0.0461, 0.0958, 0.1818, 0.0576)
# xch
nb_fcx=30
nm_fcx=c("c.x.CO2upt", "c.x.Glucupt", "c.x.Glucupt_1", "c.x.Glucupt_U", "c.x.HR1", "c.x.HR4", "c.x.Rib5P_gr", "c.x.akgdh",
"c.x.bs_DHAP", "c.x.bs_accoa", "c.x.bs_akg", "c.x.bs_e4p", "c.x.bs_fru6P", "c.x.bs_glc6P", "c.x.bs_oaa", "c.x.bs_pep",
"c.x.bs_pga", "c.x.bs_pyr", "c.x.bs_rib5P", "c.x.citsynth", "c.x.edd", "c.x.fum_a", "c.x.gnd", "c.x.idh", "c.x.maldh",
"c.x.out_Ac", "c.x.out_co2", "c.x.pdh", "c.x.rib", "c.x.zwf")
fcx=c(0.0, 0.0, 0.0, 0.0, 0.24, 0.04, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01, 0.0,
0.0, 0.42, 0.0, 0.0, 0.01, 0.99, 0.0)
fc=c(fcn, fcx)
nm_fc=c(nm_fcn, nm_fcx)
names(fc)=nm_fc
nb_fc=nb_fcn+nb_fcx

# variable growth fluxes (constant are already accounted in constrained fluxes)
nb_fgr=11
nm_fgr=c("g.n.Cit_gr", "g.n.Fru6P_gr", "g.n.FruBP_gr", "g.n.Glc6P_gr", "g.n.Gnt6P_gr", "g.n.Mal_gr", "g.n.PEP_gr", "g.n.PGA_gr",
"g.n.Rub5P_gr", "g.n.Suc_gr", "g.n.Xul5P_gr")
fgr=c(0.0013043178400589984, 8.005366040985944e-05, 0.000394227192605698, 0.00039240789240039327, 0.00011584719214754172,
0.000484357623744415, 4.401038788888554e-05, 0.00040068956189050697, 4.137932594348138e-05, 0.0011879861254524412,
0.0001655173037739255)
nm_list$fgr=nm_fgr
nb_f$nb_fgr=nb_fgr

# total flux vector fallnx dimension
nb_fallnx=nb_fl+nb_ff+nb_fc+nb_fgr+nb_fgr
nb_fwrv=nb_fallnx

# net dependent and free fluxes
nm_dfn=c(nm_fln, nm_ffn)
names(nm_dfn)=substring(nm_dfn, 5)

# all flux cardinals
nb_f=append(nb_f, list(nb_fln=nb_fln, nb_flx=nb_flx, nb_fl=nb_fl,
   nb_ffn=nb_ffn, nb_ffx=nb_ffx, nb_ff=nb_ff,
   nb_fcn=nb_fcn, nb_fcx=nb_fcx, nb_fc=nb_fc,
   nb_fallnx=nb_fallnx, nb_fwrv=nb_fwrv,
   nb_fgr=nb_fgr,
   include_growth_flux=TRUE,
   mu=0.8))
    
# prepare p2bfl, c2bfl, g2bfl, cnst2bfl matrices such that p2bfl%*%param[1:nb_ff]+
# c2bfl%*%fc+g2bfl%*%fgr+cnst2bfl=bfl
# replace f.[nx].flx by corresponding param coefficient
p2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_ff)
# replace c.[nx].flx by corresponding fc coefficient
c2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fc)
# variable growth fluxes
g2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fgr)
cnst2bfl=numeric(nb_flr); # may be coming from equalities
colnames(p2bfl)=nm_par
colnames(c2bfl)=nm_fc
colnames(g2bfl)=nm_fgr

p2bfl[1, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);

p2bfl[2, pmatch(c("f.n.pgi"), nm_par)]=c(1.0);
c2bfl[2, pmatch(c("c.n.bs_glc6P"), nm_fc)]=c(1.0);
g2bfl[2, pmatch(c("g.n.Glc6P_gr"), nm_fgr)]=c(1.0);

c2bfl[3, pmatch(c("c.n.CO2upt"), nm_fc)]=c(-1.0);

p2bfl[4, pmatch(c("f.n.pgi"), nm_par)]=c(-1.0);
c2bfl[4, pmatch(c("c.n.bs_fru6P"), nm_fc)]=c(1.0);
g2bfl[4, pmatch(c("g.n.Fru6P_gr"), nm_fgr)]=c(1.0);

g2bfl[5, pmatch(c("g.n.FruBP_gr"), nm_fgr)]=c(1.0);

p2bfl[6, pmatch(c("f.n.edd"), nm_par)]=c(-1.0);
c2bfl[6, pmatch(c("c.n.bs_DHAP"), nm_fc)]=c(1.0);

c2bfl[7, pmatch(c("c.n.bs_pga"), nm_fc)]=c(1.0);
g2bfl[7, pmatch(c("g.n.PGA_gr"), nm_fgr)]=c(1.0);

c2bfl[8, pmatch(c("c.n.bs_pep"), nm_fc)]=c(1.0);
g2bfl[8, pmatch(c("g.n.PEP_gr"), nm_fgr)]=c(1.0);

p2bfl[9, pmatch(c("f.n.edd"), nm_par)]=c(-1.0);
c2bfl[9, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(1.0);

p2bfl[10, pmatch(c("f.n.edd"), nm_par)]=c(1.0);
g2bfl[10, pmatch(c("g.n.Gnt6P_gr"), nm_fgr)]=c(1.0);

g2bfl[11, pmatch(c("g.n.Rub5P_gr"), nm_fgr)]=c(1.0);

c2bfl[12, pmatch(c("c.n.bs_rib5P", "c.n.Rib5P_gr"), nm_fc)]=c(1.0, 1.0);

g2bfl[13, pmatch(c("g.n.Xul5P_gr"), nm_fgr)]=c(1.0);

c2bfl[15, pmatch(c("c.n.bs_e4p"), nm_fc)]=c(1.0);

p2bfl[18, pmatch(c("f.n.out_Ac"), nm_par)]=c(1.0);
c2bfl[18, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(1.0);

c2bfl[19, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(1.0);

g2bfl[20, pmatch(c("g.n.Cit_gr"), nm_fgr)]=c(1.0);

c2bfl[21, pmatch(c("c.n.bs_akg"), nm_fc)]=c(1.0);

g2bfl[22, pmatch(c("g.n.Suc_gr"), nm_fgr)]=c(1.0);

g2bfl[23, pmatch(c("g.n.Mal_gr"), nm_fgr)]=c(1.0);

p2bfl[24, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);
cnst2bfl[24]=1;


c2bfl[26, pmatch(c("c.x.fum_a"), nm_fc)]=c(-1.0);

bp=as.numeric(c2bfl%stm%fc+cnst2bfl)

if (ffguess) {
   # make an automatic guess for free/dependent flux partition
   afd=as.matrix(cbind(Afl, -p2bfl))
   qafd=qr(afd, LAPACK=TRUE)
   d=abs(diag(qafd$qr))
   rank=sum(d > d[1]*tol)
   qrow=qr(t(afd))
   rankr=qrow$rank
   if (rank != rankr)
      stop_mes("Weird error: column and row ranks are not equal.", file=fcerr)
   
   irows=qrow$pivot[seq_len(rankr)]
   if (rank==0) {
      stop_mes("Error: No free/dependent flux partition could be made. Stoichiometric matrix has rank=0.", file=fcerr)
   }
   Afl=afd[irows, qafd$pivot[1L:rank], drop=FALSE]
   ka=kappa(Afl)
   if (ka > 1.e7) {
      mes=sprintf("Error: No working free/dependent flux partition could be proposed. Stoichiometric matrix has condition number %g.\n", ka)
      stop_mes(mes, file=fcerr)
   }
   p2bfl=-as.simple_triplet_matrix(afd[irows, qafd$pivot[-seq_len(rank)], drop=FALSE])
   c2bfl=c2bfl[irows, , drop=FALSE]
   g2bfl=g2bfl[irows, , drop=FALSE]
   cnst2bfl=cnst2bfl[irows]
   bp=bp[irows]
   
   # replace names
   nm_fl=sub("f.", "d.", colnames(Afl), fixed=TRUE)
   colnames(Afl)=nm_fl # both net and xch
   nm_fln=sort(grep("^d.n.", nm_fl, v=TRUE))
   nm_flx=sort(grep("^d.x.", nm_fl, v=TRUE))
   nm_fl=c(nm_fln, nm_flx)
   Afl=Afl[, nm_fl, drop=FALSE]
   
   nm_ff=sub("d.", "f.", colnames(p2bfl), fixed=TRUE) # both net and xch
   colnames(p2bfl)=nm_ff
   nm_ffn=sort(grep("^f.n.", nm_ff, v=TRUE))
   nm_ffx=sort(grep("^f.x.", nm_ff, v=TRUE))
   nm_ff=c(nm_ffn, nm_ffx)
   p2bfl=p2bfl[, nm_ff, drop=FALSE]
   
   # re-init param vector
   if (!fdfit)
      param=c(runif(length(nm_ff)), if (nb_ff == 0) param else param[-seq_len(nb_ff)])
   names(param)[seq(along=nm_ff)]=nm_ff
#browser()
}
nm_list$flnx=nm_fl
nm_fallnx=c(nm_fln, nm_ffn, nm_fcn, nm_fgr, nm_flx, nm_ffx, nm_fcx, sub(".n.", ".x.", nm_fgr, fixed=TRUE))
nm_list$fallnx=nm_fallnx
nm_net=c(nm_fln, nm_ffn, nm_fcn)
names(nm_net)=substring(nm_net, 5)
nm_xch=c(nm_flx, nm_ffx, nm_fcx)
names(nm_xch)=substring(nm_xch, 5)
edge2fl[]=nm_net[substring(edge2fl, 5)]
nm_list$ff=nm_ff

# accounting numbers
nb_flr=nrow(Afl)
nb_param=length(param)
nb_ffn=length(nm_ffn)
nb_ffx=length(nm_ffx)
nb_ff=nb_ffn+nb_ffx
nb_fln=length(nm_fln)
nb_flx=length(nm_flx)
nb_fl=nb_fln+nb_flx
nm_par=names(param)

for (item in c("nb_fln", "nb_flx", "nb_fl", "nb_ffn", "nb_ffx", "nb_ff")) {
   nb_f[item]=get(item)
}
# translation from n-x to fw-rv
sh_fwrv=substring(nm_fwrv[1:(nb_fwrv/2)], 5)
sh_nx=substring(nm_fallnx, 2)
nb_f$inet2ifwrv=pmatch(paste(".n.", sh_fwrv, sep=""), sh_nx)
nb_f$ixch2ifwrv=pmatch(paste(".x.", sh_fwrv, sep=""), sh_nx)
#nb_f$inet2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.n\\.%s$", substring(f, 5)), nm_fallnx))
#nb_f$ixch2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.x\\.%s$", substring(f, 5)), nm_fallnx))

if (TIMEIT) {
   cat("Afl qr(): ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

qrAfl=qr(Afl, LAPACK=TRUE)
d=abs(diag(qrAfl$qr))
qrAfl$rank=sum(d > d[1]*tol)
rank=qrAfl$rank
aful=as.matrix(cbind(Afl, -p2bfl, -c2bfl))
qrow=qr(t(aful))
rankr=qrow$rank
#browser()
# first check the presence of lindep rows
if (nrow(Afl) > rankr) {
   # find list of independent metabs for dependent ones
   idep=qrow$pivot[(rankr+1):nrow(Afl)]
   dcoef=qr.solve(t(aful[-idep,,drop=FALSE]), t(aful[idep,,drop=FALSE]))
   lidep=apply(dcoef, 2, function(v) names(which(abs(v) >= tol)), simplify=FALSE)
   prop=sprintf("***Warning: Among %d equations (rows), %d are redundant.\nThe dependencies are:\n\t", nrow(Afl), nrow(Afl)-rankr)
   prop=paste0(prop, paste0(lapply(names(lidep), function(nm) paste0(nm, ": ", paste0(lidep[[nm]], collapse=", "))), collapse="\n\t"), "\nThe redundant balances for species '", paste0(names(lidep), collapse="', '"), "' will be ignored.\n")
   #browser()
   cat(prop, file=fclog)
   Afl=Afl[-idep,,drop=FALSE]
   rankr=nrow(Afl)
   qrAfl=qr(Afl, LAPACK=TRUE)
   d=abs(diag(qrAfl$qr))
   qrAfl$rank=sum(d > d[1]*tol)
   rank=qrAfl$rank
   p2bfl=p2bfl[-idep,,drop=FALSE]
   c2bfl=c2bfl[-idep,,drop=FALSE]
   g2bfl=g2bfl[-idep,,drop=FALSE]
   cnst2bfl=cnst2bfl[-idep]
   bp=bp[-idep]
}
if (nrow(Afl) != rank || nrow(Afl) != ncol(Afl)) {
   #write.table(Afl)
   mes=NULL
   if (nrow(Afl) <= rank) {
      mes=paste("Candidate(s) for free or constrained flux(es):\n",
         paste(colnames(Afl)[-qrAfl$pivot[1L:nrow(Afl)]], collapse="\n"),
         "\nFor this choice, condition number of stoichiometric matrix will be ",
         kappa(Afl[,qrAfl$pivot[1L:nrow(Afl)],drop=FALSE]), "\n", sep="")
   } else if (nrow(Afl) > rank) {
      nextra=nrow(Afl)-rank
      comb=combn(c(nm_ffn, colnames(Afl)[-qrAfl$pivot[1L:rank]]), nextra)
      aextra=cbind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl)
      colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl))
      ara=Afl[,qrAfl$pivot[1L:rank],drop=FALSE]
      i=which.min(apply(comb, 2, function(i) kappa(cbind(ara, aextra[,i]))))[1L]
      nm_tmp=comb[,i]
      ka=kappa(cbind(ara, aextra[,nm_tmp]))
      if (ka < 1.e7) {
         prop=paste("Proposal to declare dependent flux(es) is:\n",
            paste(nm_tmp, collapse="\n"), "\n", sep="")
         if (rank < ncol(Afl)) {
            prop=prop%s+%"While the following dependent flux(es) should be declared free or constrained:\n"%s+%join("\n", colnames(Afl)[-qrAfl$pivot[1L:rank]])%s+%"\n"
         }
         prop=paste(prop, "For this choice, condition number of stoichiometric matrix will be ", ka, "\n", sep="")
      } else {
         # add constraint fluxes to candidate list
         if (nb_fcn > 0) {
            aextra=as.matrix(cbind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl, -c2bfl))
            colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl), colnames(c2bfl))
         }
         aextended=aful
         qae=qr(aextended, LAPACK=TRUE)
         d=abs(diag(qae$qr))
         ranke=sum(d > d[1L]*tol)
         if (ranke == nrow(Afl)) {
            prop=paste("Proposal to declare dependent flux(es) is:\n",
            join("\n", colnames(aextended)[qae$pivot[1L:ranke]]), "\n",
            "while free and constrained fluxes should be:\n",
            join("\n", colnames(aextended)[-qae$pivot[1L:ranke]]), "\n",
            sep="")
            ka=kappa(aextended[,qae$pivot[1L:ranke]])
            prop=paste(prop, "For this choice, condition number of stoichiometric matrix will be ", ka, "\n", sep="")
         } else {
            prop="No proposal for partition dependent/free fluxes could be made.\n"
         }
      }
      mes=paste("There is (are) probably ", nextra,
         " extra free flux(es) among the following:\n",
         paste(nm_ffn, collapse="\n"), "\n",
         prop,
         sep="")
   }
   stop_mes("Flux matrix is not square or is singular: (", nrow(Afl), "eq x ", ncol(Afl), "unk)\n",
      "You have to change your choice of free fluxes in the 'e_coli_growth.ftbl' file.\n",
      mes, file=fcerr)
}

# make sure that free params choice leads to not singular matrix
if (qrAfl$rank != nb_fl) {
   #write.table(Afl)
   # make a suggestion of new free fluxes
   A=cbind(Afl, -p2bfl, -c2bfl)
   colnames(A)=c(colnames(Afl), nm_ff, nm_fc)
   qa=qr(A, LAPACK=TRUE)
   d=diag(qa$qr)
   qa$rank=sum(abs(d)>=abs(d[1]*tol))
   
   mes=paste("Error: Dependent flux matrix is singular.\n",
      "Change your partition on free/dependent/constrained fluxes in the 'e_coli_growth.ftbl' file.\n",
      "Can not resolve dependent fluxe(s):\n",
      paste(colnames(Afl)[-qrAfl$pivot[(1:qrAfl$rank)]], collapse="\n"),
      sep="")
   if (qa$rank==nb_fl) {
      mes=paste(mes,
      "\n\nSuggested dependent fluxes:\n",
      paste(colnames(A)[qa$pivot[(1:qa$rank)]], collapse="\n"),
      "\n\nWhich would give the following free and constrained fluxes:\n",
      paste(colnames(A)[-qa$pivot[(1:qa$rank)]], collapse="\n"), "\n",
      sep="")
   } else {
      mes=paste(mes, "\nNo suggested free fluxes could be found", sep="")
   }
   stop_mes(mes, file=fcerr)
}

# inverse flux matrix
invAfl=solve(qrAfl)
    
if (fdfit) {
#browser()
   # choose free fluxe values such that they fit starting values from ftbl
   #dep=invAfl%*%(p2bfl%*%ff+bp)
   #ff=ff
   ff=qr.solve(rbind(invAfl%stm%p2bfl, diag(ncol(p2bfl))), c(fl-invAfl%*%bp, param))
}
# intermediate jacobian
if (TIMEIT) {
   cat("dfl_dffg: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

dfl_dffg=invAfl%stm%p2bfl
if (nb_fgr > 0L) {
   dfl_dffg=cbind(dfl_dffg, invAfl%stm%g2bfl)
}
dimnames(dfl_dffg)=list(nm_fl, c(nm_ff, nm_fgr))
dfl_dffg[abs(dfl_dffg) < 1.e-14]=0.
nb_f$dfl_dffg=as.simple_triplet_matrix(dfl_dffg)

# prepare mf, md, mc and mg matrices
# such that mf%*%ff+md%*%fl+mc%*%fc+mg%*%fgr gives fallnx
# here ff free fluxes (param), fl are dependent fluxes, fc are constrained
# fluxes and fgr are variable growth fluxes
mf=matrix(0., nb_fallnx, nb_ff)
dimnames(mf)=list(nm_fallnx, nm_ff)
md=matrix(0., nb_fallnx, nb_fl)
dimnames(md)=list(nm_fallnx, nm_fl)
mc=matrix(0., nb_fallnx, nb_fc)
dimnames(mc)=list(nm_fallnx, nm_fc)
mg=matrix(0., nb_fallnx, nb_fgr)
dimnames(mg)=list(nm_fallnx, nm_fgr)

if (nb_ff > 0) {
   mf[nm_ff, nm_ff]=diag(1., nb_ff)
}
if (nb_fl > 0) {
   md[nm_fl, nm_fl]=diag(1., nb_fl)
}
if (nb_fc > 0) {
   mc[nm_fc, nm_fc]=diag(1., nb_fc)
}
if (nb_fgr > 0) {
   mg[nm_fgr, nm_fgr]=diag(1., nb_fgr)
}

# sparse matrix static parts
# $varname fields:
#  ind_fa - flux index in a_pre$vfwrv[ind_fa]
#  a_pre - sparse matrix whose colsum() gives the a$v vector
#  prodx - dense matrix whose colprod() will give x[ind_x1]*x[ind_x2]*...
#  ind_fb - flux index in b_pre$v=fwrv[ind_fb1]*colprod(prodx)
#  ind_b - dense matrix of indexes for  b_pre$v=f[ind_b[,"indf"]*x[ind_b[,2+1]]*x[ind_b[,2+2]], ...]
#  b_pre - sparse matrix whose colsum gives b@x

#  a - unsigned sparse cumomer A matrix (off-diagonal part)
#  b - unsigned sparse vector of right hand side

if (TIMEIT) {
   cat("spAbr   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

nb_fwrv=106
nb_w=7
spAbr=list()
    
if (TIMEIT) {
   cat("weight  1: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=1
nb_c=99
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=0 # number of lighter cumomers
maxprod=1
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(45, 0, 0, 88, 0, 0, 45, 0, 58, 88, 0, 3, 45, 1, 1, 88, 1, 1, 45, 1, 59, 88, 1, 2, 35, 2, 2, 94, 2, 2, 35, 2, 1, 94, 2,
74, 35, 3, 3, 94, 3, 3, 35, 3, 0, 94, 3, 75, 35, 4, 4, 94, 4, 4, 35, 4, 65, 94, 4, 49, 35, 5, 5, 94, 5, 5, 35, 5, 66,
94, 5, 76, 35, 6, 6, 94, 6, 6, 35, 6, 67, 94, 6, 77, 35, 7, 7, 94, 7, 7, 35, 7, 68, 94, 7, 78, 47, 8, 8, 99, 8, 8, 64,
8, 8, 65, 8, 8, 47, 8, 20, 99, 8, 14, 64, 8, 61, 65, 8, 55, 47, 9, 9, 99, 9, 9, 64, 9, 9, 65, 9, 9, 47, 9, 21, 99, 9,
15, 64, 9, 62, 65, 9, 56, 47, 10, 10, 99, 10, 10, 64, 10, 10, 65, 10, 10, 47, 10, 22, 99, 10, 16, 64, 10, 63, 65, 10,
57, 47, 11, 11, 99, 11, 11, 64, 11, 11, 65, 11, 11, 47, 11, 23, 99, 11, 17, 64, 11, 64, 65, 11, 52, 47, 12, 12, 99, 12,
12, 64, 12, 12, 65, 12, 12, 47, 12, 24, 99, 12, 18, 64, 12, 50, 65, 12, 53, 47, 13, 13, 99, 13, 13, 64, 13, 13, 65, 13,
13, 47, 13, 25, 99, 13, 19, 64, 13, 51, 65, 13, 54, 46, 14, 14, 76, 14, 14, 46, 14, 8, 76, 14, 55, 46, 15, 15, 76, 15,
15, 46, 15, 9, 76, 15, 56, 46, 16, 16, 76, 16, 16, 46, 16, 10, 76, 16, 57, 46, 17, 17, 76, 17, 17, 46, 17, 11, 76, 17,
57, 46, 18, 18, 76, 18, 18, 46, 18, 12, 76, 18, 56, 46, 19, 19, 76, 19, 19, 46, 19, 13, 76, 19, 55, 6, 20, 20, 100, 20,
20, 106, 20, 20, 6, 20, 88, 100, 20, 8, 106, 20, 26, 6, 21, 21, 100, 21, 21, 106, 21, 21, 6, 21, 89, 100, 21, 9, 106,
21, 27, 6, 22, 22, 100, 22, 22, 106, 22, 22, 6, 22, 90, 100, 22, 10, 106, 22, 28, 6, 23, 23, 100, 23, 23, 106, 23, 23,
6, 23, 91, 100, 23, 11, 106, 23, 29, 6, 24, 24, 100, 24, 24, 106, 24, 24, 6, 24, 92, 100, 24, 12, 106, 24, 30, 6, 25,
25, 100, 25, 25, 106, 25, 25, 6, 25, 93, 100, 25, 13, 106, 25, 31, 53, 26, 26, 93, 26, 26, 89, 26, 26, 53, 26, 20, 93,
26, 79, 89, 26, 55, 53, 27, 27, 93, 27, 27, 89, 27, 27, 53, 27, 21, 93, 27, 80, 89, 27, 56, 53, 28, 28, 93, 28, 28, 89,
28, 28, 53, 28, 22, 93, 28, 81, 89, 28, 57, 53, 29, 29, 93, 29, 29, 89, 29, 29, 53, 29, 23, 93, 29, 82, 89, 29, 58, 53,
30, 30, 93, 30, 30, 89, 30, 30, 53, 30, 24, 93, 30, 83, 89, 30, 59, 53, 31, 31, 93, 31, 31, 89, 31, 31, 53, 31, 25, 93,
31, 49, 89, 31, 60, 38, 32, 32, 39, 32, 32, 95, 32, 32, 38, 32, 84, 39, 32, 87, 95, 32, 68, 38, 33, 33, 39, 33, 33, 95,
33, 33, 38, 33, 85, 39, 33, 86, 95, 33, 67, 38, 34, 34, 39, 34, 34, 95, 34, 34, 38, 34, 86, 39, 34, 85, 95, 34, 66, 38,
35, 35, 39, 35, 35, 95, 35, 35, 38, 35, 87, 39, 35, 84, 95, 35, 65, 37, 36, 36, 103, 36, 36, 102, 36, 36, 37, 36, 39,
103, 36, 58, 102, 36, 67, 37, 37, 37, 103, 37, 37, 102, 37, 37, 37, 37, 40, 103, 37, 59, 102, 37, 66, 37, 38, 38, 103,
38, 38, 102, 38, 38, 37, 38, 41, 103, 38, 60, 102, 38, 65, 48, 39, 39, 90, 39, 39, 48, 39, 55, 90, 39, 36, 48, 40, 40,
90, 40, 40, 48, 40, 56, 90, 40, 37, 48, 41, 41, 90, 41, 41, 48, 41, 57, 90, 41, 38, 14, 42, 42, 66, 42, 42, 14, 42, 61,
66, 42, 69, 14, 43, 43, 66, 43, 43, 14, 43, 62, 66, 43, 70, 14, 44, 44, 66, 44, 44, 14, 44, 63, 66, 44, 71, 14, 45, 45,
66, 45, 45, 14, 45, 64, 66, 45, 72, 14, 46, 46, 66, 46, 46, 14, 46, 52, 66, 46, 73, 14, 47, 47, 66, 47, 47, 14, 47, 53,
66, 47, 50, 14, 48, 48, 66, 48, 48, 14, 48, 54, 66, 48, 51, 40, 49, 49, 45, 49, 49, 41, 49, 49, 22, 49, 49, 102, 49, 49,
1, 49, 49, 40, 49, 31, 45, 49, 60, 41, 49, 4, 22, 49, 78, 102, 49, 68, 11, 50, 50, 13, 50, 50, 63, 50, 50, 11, 50, 12,
13, 50, 47, 63, 50, 94, 11, 51, 51, 13, 51, 51, 63, 51, 51, 11, 51, 13, 13, 51, 48, 63, 51, 95, 12, 52, 52, 67, 52, 52,
12, 52, 11, 67, 52, 46, 12, 53, 53, 67, 53, 53, 12, 53, 12, 67, 53, 47, 12, 54, 54, 67, 54, 54, 12, 54, 13, 67, 54, 48,
23, 55, 55, 23, 55, 55, 36, 55, 55, 12, 55, 55, 101, 55, 55, 63, 55, 55, 23, 55, 19, 23, 55, 14, 36, 55, 26, 12, 55, 8,
101, 55, 39, 63, 55, 96, 23, 56, 56, 23, 56, 56, 36, 56, 56, 12, 56, 56, 101, 56, 56, 63, 56, 56, 23, 56, 18, 23, 56,
15, 36, 56, 27, 12, 56, 9, 101, 56, 40, 63, 56, 97, 23, 57, 57, 23, 57, 57, 36, 57, 57, 12, 57, 57, 101, 57, 57, 63, 57,
57, 23, 57, 17, 23, 57, 16, 36, 57, 28, 12, 57, 10, 101, 57, 41, 63, 57, 98, 50, 58, 58, 36, 58, 58, 98, 58, 58, 50, 58,
36, 36, 58, 29, 98, 58, 0, 50, 59, 59, 36, 59, 59, 98, 59, 59, 50, 59, 37, 36, 59, 30, 98, 59, 1, 50, 60, 60, 36, 60,
60, 98, 60, 60, 50, 60, 38, 36, 60, 31, 98, 60, 49, 11, 61, 61, 67, 61, 61, 11, 61, 8, 67, 61, 42, 11, 62, 62, 67, 62,
62, 11, 62, 9, 67, 62, 43, 11, 63, 63, 67, 63, 63, 11, 63, 10, 67, 63, 44, 11, 64, 64, 67, 64, 64, 11, 64, 11, 67, 64,
45, 42, 65, 65, 49, 65, 65, 88, 65, 65, 42, 65, 35, 49, 65, 38, 88, 65, 4, 42, 66, 66, 49, 66, 66, 88, 66, 66, 42, 66,
34, 49, 66, 37, 88, 66, 5, 42, 67, 67, 49, 67, 67, 88, 67, 67, 42, 67, 33, 49, 67, 36, 88, 67, 6, 42, 68, 68, 49, 68,
68, 88, 68, 68, 42, 68, 32, 49, 68, 49, 88, 68, 7, 51, 69, 69, 13, 69, 69, 51, 69, 79, 13, 69, 42, 51, 70, 70, 13, 70,
70, 51, 70, 80, 13, 70, 43, 51, 71, 71, 13, 71, 71, 51, 71, 81, 13, 71, 44, 51, 72, 72, 13, 72, 72, 51, 72, 82, 13, 72,
45, 51, 73, 73, 13, 73, 73, 51, 73, 83, 13, 73, 46, 41, 74, 74, 75, 74, 74, 41, 74, 2, 75, 74, 84, 41, 75, 75, 75, 75,
75, 41, 75, 3, 75, 75, 85, 41, 76, 76, 75, 76, 76, 41, 76, 5, 75, 76, 86, 41, 77, 77, 75, 77, 77, 41, 77, 6, 75, 77, 87,
41, 78, 78, 75, 78, 78, 41, 78, 7, 75, 78, 49, 40, 79, 79, 104, 79, 79, 105, 79, 79, 40, 79, 26, 104, 79, 69, 105, 79,
96, 40, 80, 80, 104, 80, 80, 105, 80, 80, 40, 80, 27, 104, 80, 70, 105, 80, 97, 40, 81, 81, 104, 81, 81, 105, 81, 81,
40, 81, 28, 104, 81, 71, 105, 81, 98, 40, 82, 82, 104, 82, 82, 105, 82, 82, 40, 82, 29, 104, 82, 72, 105, 82, 94, 40,
83, 83, 104, 83, 83, 105, 83, 83, 40, 83, 30, 104, 83, 73, 105, 83, 95, 22, 84, 84, 91, 84, 84, 92, 84, 84, 22, 84, 74,
91, 84, 32, 92, 84, 35, 22, 85, 85, 91, 85, 85, 92, 85, 85, 22, 85, 75, 91, 85, 33, 92, 85, 34, 22, 86, 86, 91, 86, 86,
92, 86, 86, 22, 86, 76, 91, 86, 34, 92, 86, 33, 22, 87, 87, 91, 87, 87, 92, 87, 87, 22, 87, 77, 91, 87, 35, 92, 87, 32,
59, 88, 88, 7, 88, 88, 8, 88, 88, 59, 88, 20, 59, 89, 89, 7, 89, 89, 8, 89, 89, 59, 89, 21, 59, 90, 90, 7, 90, 90, 8,
90, 90, 59, 90, 22, 59, 91, 91, 7, 91, 91, 8, 91, 91, 59, 91, 23, 59, 92, 92, 7, 92, 92, 8, 92, 92, 59, 92, 24, 59, 93,
93, 7, 93, 93, 8, 93, 93, 59, 93, 25, 52, 94, 94, 10, 94, 94, 52, 94, 82, 10, 94, 50, 52, 95, 95, 10, 95, 95, 52, 95,
83, 10, 95, 51, 52, 96, 96, 10, 96, 96, 52, 96, 79, 10, 96, 55, 52, 97, 97, 10, 97, 97, 52, 97, 80, 10, 97, 56, 52, 98,
98, 10, 98, 98, 52, 98, 81, 10, 98, 57)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(1, 50, 116, 7, 89, 117, 8, 89, 118, 7, 90, 119, 8, 90, 120, 7, 91, 121, 8, 91, 122, 7, 92, 123, 8, 92, 124, 7, 93, 125,
8, 93, 126, 7, 94, 127, 8, 94, 128)), ncol=2+1, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(1), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  2: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=2
nb_c=192
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=99 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(45, 0, 0, 88, 0, 0, 45, 0, 116, 88, 0, 1, 35, 1, 1, 94, 1, 1, 35, 1, 0, 94, 1, 141, 35, 2, 2, 94, 2, 2, 94, 3, 3, 35, 3,
3, 94, 3, 142, 94, 4, 4, 35, 4, 4, 94, 4, 143, 94, 5, 5, 35, 5, 5, 94, 5, 144, 35, 6, 6, 94, 6, 6, 94, 7, 7, 35, 7, 7,
94, 7, 145, 94, 8, 8, 35, 8, 8, 94, 8, 146, 94, 9, 9, 35, 9, 9, 94, 9, 147, 35, 10, 10, 94, 10, 10, 35, 10, 125, 35, 11,
11, 94, 11, 11, 35, 11, 126, 35, 12, 12, 94, 12, 12, 35, 12, 128, 35, 13, 13, 94, 13, 13, 35, 13, 127, 94, 13, 148, 35,
14, 14, 94, 14, 14, 35, 14, 129, 94, 14, 149, 35, 15, 15, 94, 15, 15, 35, 15, 130, 94, 15, 150, 47, 16, 16, 99, 16, 16,
64, 16, 16, 65, 16, 16, 47, 16, 46, 99, 16, 31, 64, 16, 119, 65, 16, 113, 47, 17, 17, 99, 17, 17, 64, 17, 17, 65, 17,
17, 47, 17, 47, 99, 17, 32, 64, 17, 120, 65, 17, 114, 47, 18, 18, 99, 18, 18, 64, 18, 18, 65, 18, 18, 47, 18, 48, 99,
18, 33, 64, 18, 121, 65, 18, 115, 47, 19, 19, 99, 19, 19, 64, 19, 19, 65, 19, 19, 47, 19, 49, 99, 19, 34, 64, 19, 122,
47, 20, 20, 99, 20, 20, 64, 20, 20, 65, 20, 20, 47, 20, 50, 99, 20, 35, 64, 20, 123, 47, 21, 21, 99, 21, 21, 64, 21, 21,
65, 21, 21, 47, 21, 51, 99, 21, 36, 64, 21, 124, 47, 22, 22, 99, 22, 22, 64, 22, 22, 65, 22, 22, 47, 22, 52, 99, 22, 37,
47, 23, 23, 99, 23, 23, 64, 23, 23, 65, 23, 23, 47, 23, 53, 99, 23, 38, 47, 24, 24, 99, 24, 24, 64, 24, 24, 65, 24, 24,
47, 24, 54, 99, 24, 39, 47, 25, 25, 99, 25, 25, 65, 25, 25, 64, 25, 25, 47, 25, 55, 99, 25, 40, 65, 25, 110, 47, 26, 26,
99, 26, 26, 64, 26, 26, 65, 26, 26, 47, 26, 56, 99, 26, 41, 47, 27, 27, 99, 27, 27, 64, 27, 27, 65, 27, 27, 47, 27, 57,
99, 27, 42, 47, 28, 28, 99, 28, 28, 64, 28, 28, 65, 28, 28, 47, 28, 58, 99, 28, 43, 47, 29, 29, 99, 29, 29, 65, 29, 29,
64, 29, 29, 47, 29, 59, 99, 29, 44, 65, 29, 111, 47, 30, 30, 99, 30, 30, 64, 30, 30, 65, 30, 30, 47, 30, 60, 99, 30, 45,
64, 30, 109, 65, 30, 112, 46, 31, 31, 76, 31, 31, 46, 31, 16, 76, 31, 113, 46, 32, 32, 76, 32, 32, 46, 32, 17, 76, 32,
114, 46, 33, 33, 76, 33, 33, 46, 33, 18, 76, 33, 115, 46, 34, 34, 76, 34, 34, 46, 34, 19, 46, 35, 35, 76, 35, 35, 46,
35, 20, 46, 36, 36, 76, 36, 36, 46, 36, 21, 46, 37, 37, 76, 37, 37, 46, 37, 22, 46, 38, 38, 76, 38, 38, 46, 38, 23, 46,
39, 39, 76, 39, 39, 46, 39, 24, 46, 40, 40, 76, 40, 40, 46, 40, 25, 76, 40, 115, 46, 41, 41, 76, 41, 41, 46, 41, 26, 46,
42, 42, 76, 42, 42, 46, 42, 27, 46, 43, 43, 76, 43, 43, 46, 43, 28, 46, 44, 44, 76, 44, 44, 46, 44, 29, 76, 44, 114, 46,
45, 45, 76, 45, 45, 46, 45, 30, 76, 45, 113, 6, 46, 46, 100, 46, 46, 106, 46, 46, 6, 46, 167, 100, 46, 16, 106, 46, 61,
6, 47, 47, 100, 47, 47, 106, 47, 47, 6, 47, 168, 100, 47, 17, 106, 47, 62, 6, 48, 48, 100, 48, 48, 106, 48, 48, 6, 48,
169, 100, 48, 18, 106, 48, 63, 6, 49, 49, 100, 49, 49, 106, 49, 49, 6, 49, 170, 100, 49, 19, 106, 49, 64, 6, 50, 50,
100, 50, 50, 106, 50, 50, 6, 50, 171, 100, 50, 20, 106, 50, 65, 6, 51, 51, 100, 51, 51, 106, 51, 51, 6, 51, 172, 100,
51, 21, 106, 51, 66, 6, 52, 52, 100, 52, 52, 106, 52, 52, 6, 52, 173, 100, 52, 22, 106, 52, 67, 6, 53, 53, 100, 53, 53,
106, 53, 53, 6, 53, 174, 100, 53, 23, 106, 53, 68, 6, 54, 54, 100, 54, 54, 106, 54, 54, 6, 54, 175, 100, 54, 24, 106,
54, 69, 6, 55, 55, 100, 55, 55, 106, 55, 55, 6, 55, 176, 100, 55, 25, 106, 55, 70, 6, 56, 56, 100, 56, 56, 106, 56, 56,
6, 56, 177, 100, 56, 26, 106, 56, 71, 6, 57, 57, 100, 57, 57, 106, 57, 57, 6, 57, 178, 100, 57, 27, 106, 57, 72, 6, 58,
58, 100, 58, 58, 106, 58, 58, 6, 58, 179, 100, 58, 28, 106, 58, 73, 6, 59, 59, 100, 59, 59, 106, 59, 59, 6, 59, 180,
100, 59, 29, 106, 59, 74, 6, 60, 60, 100, 60, 60, 106, 60, 60, 6, 60, 181, 100, 60, 30, 106, 60, 75, 53, 61, 61, 93, 61,
61, 89, 61, 61, 53, 61, 46, 93, 61, 151, 89, 61, 113, 53, 62, 62, 93, 62, 62, 89, 62, 62, 53, 62, 47, 93, 62, 152, 89,
62, 114, 53, 63, 63, 93, 63, 63, 89, 63, 63, 53, 63, 48, 93, 63, 153, 89, 63, 115, 53, 64, 64, 93, 64, 64, 89, 64, 64,
53, 64, 49, 93, 64, 154, 53, 65, 65, 93, 65, 65, 89, 65, 65, 53, 65, 50, 93, 65, 155, 53, 66, 66, 93, 66, 66, 89, 66,
66, 53, 66, 51, 93, 66, 156, 53, 67, 67, 93, 67, 67, 89, 67, 67, 53, 67, 52, 93, 67, 157, 53, 68, 68, 93, 68, 68, 89,
68, 68, 53, 68, 53, 93, 68, 158, 53, 69, 69, 93, 69, 69, 89, 69, 69, 53, 69, 54, 93, 69, 159, 53, 70, 70, 93, 70, 70,
89, 70, 70, 53, 70, 55, 93, 70, 160, 89, 70, 116, 53, 71, 71, 93, 71, 71, 89, 71, 71, 53, 71, 56, 53, 72, 72, 93, 72,
72, 89, 72, 72, 53, 72, 57, 53, 73, 73, 93, 73, 73, 89, 73, 73, 53, 73, 58, 53, 74, 74, 89, 74, 74, 93, 74, 74, 53, 74,
59, 89, 74, 117, 53, 75, 75, 89, 75, 75, 93, 75, 75, 53, 75, 60, 89, 75, 118, 38, 76, 76, 39, 76, 76, 95, 76, 76, 38,
76, 161, 39, 76, 166, 95, 76, 130, 38, 77, 77, 39, 77, 77, 95, 77, 77, 38, 77, 162, 39, 77, 165, 95, 77, 129, 38, 78,
78, 39, 78, 78, 95, 78, 78, 38, 78, 163, 39, 78, 163, 95, 78, 128, 38, 79, 79, 39, 79, 79, 95, 79, 79, 38, 79, 164, 39,
79, 164, 95, 79, 127, 38, 80, 80, 39, 80, 80, 95, 80, 80, 38, 80, 165, 39, 80, 162, 95, 80, 126, 38, 81, 81, 39, 81, 81,
95, 81, 81, 38, 81, 166, 39, 81, 161, 95, 81, 125, 37, 82, 82, 103, 82, 82, 102, 82, 82, 37, 82, 85, 103, 82, 116, 102,
82, 127, 37, 83, 83, 103, 83, 83, 102, 83, 83, 37, 83, 86, 103, 83, 117, 102, 83, 126, 37, 84, 84, 103, 84, 84, 102, 84,
84, 37, 84, 87, 103, 84, 118, 102, 84, 125, 48, 85, 85, 90, 85, 85, 48, 85, 113, 90, 85, 82, 48, 86, 86, 90, 86, 86, 48,
86, 114, 90, 86, 83, 48, 87, 87, 90, 87, 87, 48, 87, 115, 90, 87, 84, 14, 88, 88, 66, 88, 88, 14, 88, 119, 66, 88, 131,
14, 89, 89, 66, 89, 89, 14, 89, 120, 66, 89, 132, 14, 90, 90, 66, 90, 90, 14, 90, 121, 66, 90, 133, 14, 91, 91, 66, 91,
91, 14, 91, 122, 66, 91, 134, 14, 92, 92, 66, 92, 92, 14, 92, 123, 66, 92, 135, 14, 93, 93, 66, 93, 93, 14, 93, 124, 66,
93, 136, 66, 94, 94, 14, 94, 94, 66, 94, 137, 66, 95, 95, 14, 95, 95, 66, 95, 138, 66, 96, 96, 14, 96, 96, 66, 96, 139,
66, 97, 97, 14, 97, 97, 66, 97, 140, 14, 98, 98, 66, 98, 98, 14, 99, 99, 66, 99, 99, 14, 100, 100, 66, 100, 100, 14,
101, 101, 66, 101, 101, 14, 102, 102, 66, 102, 102, 14, 102, 110, 14, 103, 103, 66, 103, 103, 14, 104, 104, 66, 104,
104, 14, 105, 105, 66, 105, 105, 14, 106, 106, 66, 106, 106, 14, 107, 107, 66, 107, 107, 14, 107, 111, 14, 108, 108, 66,
108, 108, 14, 108, 112, 66, 108, 109, 11, 109, 109, 13, 109, 109, 63, 109, 109, 11, 109, 30, 13, 109, 108, 63, 109, 182,
12, 110, 110, 67, 110, 110, 12, 110, 25, 67, 110, 102, 12, 111, 111, 67, 111, 111, 12, 111, 29, 67, 111, 107, 12, 112,
112, 67, 112, 112, 12, 112, 30, 67, 112, 108, 23, 113, 113, 23, 113, 113, 36, 113, 113, 12, 113, 113, 101, 113, 113, 63,
113, 113, 23, 113, 45, 23, 113, 31, 36, 113, 61, 12, 113, 16, 101, 113, 85, 63, 113, 183, 23, 114, 114, 23, 114, 114,
36, 114, 114, 12, 114, 114, 101, 114, 114, 63, 114, 114, 23, 114, 44, 23, 114, 32, 36, 114, 62, 12, 114, 17, 101, 114,
86, 63, 114, 184, 23, 115, 115, 23, 115, 115, 36, 115, 115, 12, 115, 115, 101, 115, 115, 63, 115, 115, 23, 115, 40, 23,
115, 33, 36, 115, 63, 12, 115, 18, 101, 115, 87, 63, 115, 185, 50, 116, 116, 36, 116, 116, 98, 116, 116, 50, 116, 82,
36, 116, 70, 98, 116, 0, 50, 117, 117, 36, 117, 117, 98, 117, 117, 50, 117, 83, 36, 117, 74, 50, 118, 118, 36, 118, 118,
98, 118, 118, 50, 118, 84, 36, 118, 75, 11, 119, 119, 67, 119, 119, 11, 119, 16, 67, 119, 88, 11, 120, 120, 67, 120,
120, 11, 120, 17, 67, 120, 89, 11, 121, 121, 67, 121, 121, 11, 121, 18, 67, 121, 90, 11, 122, 122, 67, 122, 122, 11,
122, 19, 67, 122, 91, 11, 123, 123, 67, 123, 123, 11, 123, 20, 67, 123, 92, 11, 124, 124, 67, 124, 124, 11, 124, 21, 67,
124, 93, 42, 125, 125, 49, 125, 125, 88, 125, 125, 42, 125, 81, 49, 125, 84, 88, 125, 10, 42, 126, 126, 49, 126, 126,
88, 126, 126, 42, 126, 80, 49, 126, 83, 88, 126, 11, 42, 127, 127, 49, 127, 127, 88, 127, 127, 42, 127, 79, 49, 127, 82,
88, 127, 13, 42, 128, 128, 88, 128, 128, 49, 128, 128, 42, 128, 78, 88, 128, 12, 42, 129, 129, 88, 129, 129, 49, 129,
129, 42, 129, 77, 88, 129, 14, 42, 130, 130, 88, 130, 130, 49, 130, 130, 42, 130, 76, 88, 130, 15, 51, 131, 131, 13,
131, 131, 51, 131, 151, 13, 131, 88, 51, 132, 132, 13, 132, 132, 51, 132, 152, 13, 132, 89, 51, 133, 133, 13, 133, 133,
51, 133, 153, 13, 133, 90, 51, 134, 134, 13, 134, 134, 51, 134, 154, 13, 134, 91, 51, 135, 135, 13, 135, 135, 51, 135,
155, 13, 135, 92, 51, 136, 136, 13, 136, 136, 51, 136, 156, 13, 136, 93, 51, 137, 137, 13, 137, 137, 51, 137, 157, 13,
137, 94, 51, 138, 138, 13, 138, 138, 51, 138, 158, 13, 138, 95, 51, 139, 139, 13, 139, 139, 51, 139, 159, 13, 139, 96,
51, 140, 140, 13, 140, 140, 51, 140, 160, 13, 140, 97, 41, 141, 141, 75, 141, 141, 41, 141, 1, 75, 141, 161, 41, 142,
142, 75, 142, 142, 41, 142, 3, 75, 142, 162, 41, 143, 143, 75, 143, 143, 41, 143, 4, 75, 143, 163, 41, 144, 144, 75,
144, 144, 41, 144, 5, 41, 145, 145, 75, 145, 145, 41, 145, 7, 75, 145, 164, 41, 146, 146, 75, 146, 146, 41, 146, 8, 75,
146, 165, 41, 147, 147, 75, 147, 147, 41, 147, 9, 41, 148, 148, 75, 148, 148, 41, 148, 13, 75, 148, 166, 41, 149, 149,
75, 149, 149, 41, 149, 14, 41, 150, 150, 75, 150, 150, 41, 150, 15, 40, 151, 151, 104, 151, 151, 105, 151, 151, 40, 151,
61, 104, 151, 131, 105, 151, 183, 40, 152, 152, 104, 152, 152, 105, 152, 152, 40, 152, 62, 104, 152, 132, 105, 152, 184,
40, 153, 153, 104, 153, 153, 105, 153, 153, 40, 153, 63, 104, 153, 133, 105, 153, 185, 40, 154, 154, 104, 154, 154, 105,
154, 154, 40, 154, 64, 104, 154, 134, 105, 154, 186, 40, 155, 155, 104, 155, 155, 105, 155, 155, 40, 155, 65, 104, 155,
135, 105, 155, 187, 40, 156, 156, 104, 156, 156, 105, 156, 156, 40, 156, 66, 104, 156, 136, 105, 156, 188, 40, 157, 157,
104, 157, 157, 105, 157, 157, 40, 157, 67, 104, 157, 137, 105, 157, 189, 40, 158, 158, 104, 158, 158, 105, 158, 158, 40,
158, 68, 104, 158, 138, 105, 158, 190, 40, 159, 159, 104, 159, 159, 105, 159, 159, 40, 159, 69, 104, 159, 139, 105, 159,
191, 40, 160, 160, 104, 160, 160, 105, 160, 160, 40, 160, 70, 104, 160, 140, 105, 160, 182, 22, 161, 161, 91, 161, 161,
92, 161, 161, 22, 161, 141, 91, 161, 76, 92, 161, 81, 22, 162, 162, 91, 162, 162, 92, 162, 162, 22, 162, 142, 91, 162,
77, 92, 162, 80, 22, 163, 163, 91, 163, 163, 92, 163, 163, 22, 163, 143, 91, 163, 78, 92, 163, 78, 22, 164, 164, 91,
164, 164, 92, 164, 164, 22, 164, 145, 91, 164, 79, 92, 164, 79, 22, 165, 165, 91, 165, 165, 92, 165, 165, 22, 165, 146,
91, 165, 80, 92, 165, 77, 22, 166, 166, 91, 166, 166, 92, 166, 166, 22, 166, 148, 91, 166, 81, 92, 166, 76, 59, 167,
167, 7, 167, 167, 8, 167, 167, 59, 167, 46, 59, 168, 168, 7, 168, 168, 8, 168, 168, 59, 168, 47, 59, 169, 169, 7, 169,
169, 8, 169, 169, 59, 169, 48, 59, 170, 170, 7, 170, 170, 8, 170, 170, 59, 170, 49, 59, 171, 171, 7, 171, 171, 8, 171,
171, 59, 171, 50, 59, 172, 172, 7, 172, 172, 8, 172, 172, 59, 172, 51, 59, 173, 173, 7, 173, 173, 8, 173, 173, 59, 173,
52, 59, 174, 174, 7, 174, 174, 8, 174, 174, 59, 174, 53, 59, 175, 175, 7, 175, 175, 8, 175, 175, 59, 175, 54, 59, 176,
176, 7, 176, 176, 8, 176, 176, 59, 176, 55, 59, 177, 177, 7, 177, 177, 8, 177, 177, 59, 177, 56, 59, 178, 178, 7, 178,
178, 8, 178, 178, 59, 178, 57, 59, 179, 179, 7, 179, 179, 8, 179, 179, 59, 179, 58, 59, 180, 180, 7, 180, 180, 8, 180,
180, 59, 180, 59, 59, 181, 181, 7, 181, 181, 8, 181, 181, 59, 181, 60, 52, 182, 182, 10, 182, 182, 52, 182, 160, 10,
182, 109, 52, 183, 183, 10, 183, 183, 52, 183, 151, 10, 183, 113, 52, 184, 184, 10, 184, 184, 52, 184, 152, 10, 184,
114, 52, 185, 185, 10, 185, 185, 52, 185, 153, 10, 185, 115, 52, 186, 186, 10, 186, 186, 52, 186, 154, 52, 187, 187, 10,
187, 187, 52, 187, 155, 52, 188, 188, 10, 188, 188, 52, 188, 156, 52, 189, 189, 10, 189, 189, 52, 189, 157, 52, 190,
190, 10, 190, 190, 52, 190, 158, 52, 191, 191, 10, 191, 191, 52, 191, 159)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(35, 3, 130, 194, 94, 3, 203, 178, 35, 4, 130, 195, 35, 5, 130, 196, 35, 6, 130, 197, 35, 7, 129, 194, 94, 7, 204, 178,
35, 8, 129, 195, 35, 9, 129, 196, 35, 10, 129, 197, 94, 11, 205, 178, 94, 12, 206, 178, 94, 13, 207, 178, 65, 20, 184,
181, 65, 21, 185, 181, 65, 22, 186, 181, 64, 23, 190, 179, 65, 23, 184, 182, 64, 24, 191, 179, 65, 24, 185, 182, 64, 25,
192, 179, 65, 25, 186, 182, 64, 26, 193, 179, 64, 27, 190, 180, 65, 27, 184, 183, 64, 28, 191, 180, 65, 28, 185, 183,
64, 29, 192, 180, 65, 29, 186, 183, 64, 30, 193, 180, 76, 35, 186, 184, 76, 36, 186, 185, 76, 37, 186, 186, 76, 38, 185,
184, 76, 39, 185, 185, 76, 40, 185, 186, 76, 42, 184, 184, 76, 43, 184, 185, 76, 44, 184, 186, 89, 65, 187, 184, 89, 66,
187, 185, 89, 67, 187, 186, 89, 68, 188, 184, 89, 69, 188, 185, 89, 70, 188, 186, 93, 72, 178, 208, 89, 72, 189, 184,
93, 73, 178, 209, 89, 73, 189, 185, 93, 74, 178, 210, 89, 74, 189, 186, 93, 75, 178, 211, 93, 76, 178, 212, 14, 95, 190,
181, 14, 96, 191, 181, 14, 97, 192, 181, 14, 98, 193, 181, 14, 99, 190, 182, 66, 99, 198, 179, 14, 100, 191, 182, 66,
100, 199, 179, 14, 101, 192, 182, 66, 101, 200, 179, 14, 102, 193, 182, 66, 102, 201, 179, 66, 103, 202, 179, 14, 104,
190, 183, 66, 104, 198, 180, 14, 105, 191, 183, 66, 105, 199, 180, 14, 106, 192, 183, 66, 106, 200, 180, 14, 107, 193,
183, 66, 107, 201, 180, 66, 108, 202, 180, 98, 118, 129, 178, 98, 119, 130, 178, 49, 129, 167, 178, 49, 130, 166, 178,
49, 131, 165, 178, 75, 145, 213, 178, 75, 148, 214, 178, 75, 150, 215, 178, 75, 151, 216, 178, 7, 168, 86, 1, 8, 168,
87, 1, 7, 169, 88, 1, 8, 169, 89, 1, 7, 170, 90, 1, 8, 170, 91, 1, 7, 171, 92, 1, 8, 171, 93, 1, 7, 172, 94, 1, 8, 172,
95, 1, 7, 173, 96, 1, 8, 173, 97, 1, 7, 174, 98, 1, 8, 174, 99, 1, 7, 175, 100, 1, 8, 175, 101, 1, 7, 176, 102, 1, 8,
176, 103, 1, 7, 177, 104, 1, 8, 177, 105, 1, 7, 178, 106, 1, 8, 178, 107, 1, 7, 179, 108, 1, 8, 179, 109, 1, 7, 180,
110, 1, 8, 180, 111, 1, 7, 181, 112, 1, 8, 181, 113, 1, 7, 182, 114, 1, 8, 182, 115, 1, 10, 187, 184, 179, 10, 188, 185,
179, 10, 189, 186, 179, 10, 190, 184, 180, 10, 191, 185, 180, 10, 192, 186, 180)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  3: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=3
nb_c=216
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=291 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(35, 0, 0, 94, 0, 0, 94, 1, 1, 35, 1, 1, 94, 1, 162, 35, 2, 2, 94, 2, 2, 94, 3, 3, 35, 3, 3, 94, 3, 163, 35, 4, 4, 94, 4,
4, 94, 5, 5, 35, 5, 5, 94, 5, 164, 94, 6, 6, 35, 6, 6, 94, 6, 165, 35, 7, 7, 94, 7, 7, 94, 8, 8, 35, 8, 8, 94, 8, 166,
94, 9, 9, 35, 9, 9, 94, 9, 167, 35, 10, 10, 94, 10, 10, 35, 11, 11, 94, 11, 11, 94, 12, 12, 35, 12, 12, 94, 12, 168, 35,
13, 13, 94, 13, 13, 94, 14, 14, 35, 14, 14, 94, 14, 169, 94, 15, 15, 35, 15, 15, 94, 15, 170, 35, 16, 16, 94, 16, 16,
35, 16, 148, 35, 17, 17, 94, 17, 17, 35, 17, 149, 35, 18, 18, 94, 18, 18, 35, 18, 150, 35, 19, 19, 94, 19, 19, 35, 19,
151, 94, 19, 171, 47, 20, 20, 99, 20, 20, 64, 20, 20, 65, 20, 20, 47, 20, 60, 99, 20, 40, 64, 20, 144, 65, 20, 142, 47,
21, 21, 99, 21, 21, 64, 21, 21, 65, 21, 21, 47, 21, 61, 99, 21, 41, 64, 21, 145, 47, 22, 22, 99, 22, 22, 64, 22, 22, 65,
22, 22, 47, 22, 62, 99, 22, 42, 64, 22, 146, 47, 23, 23, 99, 23, 23, 64, 23, 23, 65, 23, 23, 47, 23, 63, 99, 23, 43, 64,
23, 147, 47, 24, 24, 99, 24, 24, 64, 24, 24, 65, 24, 24, 47, 24, 64, 99, 24, 44, 47, 25, 25, 99, 25, 25, 64, 25, 25, 65,
25, 25, 47, 25, 65, 99, 25, 45, 47, 26, 26, 99, 26, 26, 64, 26, 26, 65, 26, 26, 47, 26, 66, 99, 26, 46, 47, 27, 27, 99,
27, 27, 64, 27, 27, 65, 27, 27, 47, 27, 67, 99, 27, 47, 47, 28, 28, 99, 28, 28, 64, 28, 28, 65, 28, 28, 47, 28, 68, 99,
28, 48, 47, 29, 29, 99, 29, 29, 64, 29, 29, 65, 29, 29, 47, 29, 69, 99, 29, 49, 47, 30, 30, 99, 30, 30, 64, 30, 30, 65,
30, 30, 47, 30, 70, 99, 30, 50, 47, 31, 31, 99, 31, 31, 64, 31, 31, 65, 31, 31, 47, 31, 71, 99, 31, 51, 47, 32, 32, 99,
32, 32, 64, 32, 32, 65, 32, 32, 47, 32, 72, 99, 32, 52, 47, 33, 33, 99, 33, 33, 64, 33, 33, 65, 33, 33, 47, 33, 73, 99,
33, 53, 47, 34, 34, 99, 34, 34, 64, 34, 34, 65, 34, 34, 47, 34, 74, 99, 34, 54, 47, 35, 35, 99, 35, 35, 64, 35, 35, 65,
35, 35, 47, 35, 75, 99, 35, 55, 47, 36, 36, 99, 36, 36, 64, 36, 36, 65, 36, 36, 47, 36, 76, 99, 36, 56, 47, 37, 37, 99,
37, 37, 64, 37, 37, 65, 37, 37, 47, 37, 77, 99, 37, 57, 47, 38, 38, 99, 38, 38, 64, 38, 38, 65, 38, 38, 47, 38, 78, 99,
38, 58, 47, 39, 39, 99, 39, 39, 65, 39, 39, 64, 39, 39, 47, 39, 79, 99, 39, 59, 65, 39, 141, 46, 40, 40, 76, 40, 40, 46,
40, 20, 76, 40, 142, 46, 41, 41, 76, 41, 41, 46, 41, 21, 46, 42, 42, 76, 42, 42, 46, 42, 22, 46, 43, 43, 76, 43, 43, 46,
43, 23, 46, 44, 44, 76, 44, 44, 46, 44, 24, 46, 45, 45, 76, 45, 45, 46, 45, 25, 46, 46, 46, 76, 46, 46, 46, 46, 26, 46,
47, 47, 76, 47, 47, 46, 47, 27, 46, 48, 48, 76, 48, 48, 46, 48, 28, 46, 49, 49, 76, 49, 49, 46, 49, 29, 46, 50, 50, 76,
50, 50, 46, 50, 30, 46, 51, 51, 76, 51, 51, 46, 51, 31, 46, 52, 52, 76, 52, 52, 46, 52, 32, 46, 53, 53, 76, 53, 53, 46,
53, 33, 46, 54, 54, 76, 54, 54, 46, 54, 34, 46, 55, 55, 76, 55, 55, 46, 55, 35, 46, 56, 56, 76, 56, 56, 46, 56, 36, 46,
57, 57, 76, 57, 57, 46, 57, 37, 46, 58, 58, 76, 58, 58, 46, 58, 38, 46, 59, 59, 76, 59, 59, 46, 59, 39, 76, 59, 142, 6,
60, 60, 100, 60, 60, 106, 60, 60, 6, 60, 186, 100, 60, 20, 106, 60, 80, 6, 61, 61, 100, 61, 61, 106, 61, 61, 6, 61, 187,
100, 61, 21, 106, 61, 81, 6, 62, 62, 100, 62, 62, 106, 62, 62, 6, 62, 188, 100, 62, 22, 106, 62, 82, 6, 63, 63, 100, 63,
63, 106, 63, 63, 6, 63, 189, 100, 63, 23, 106, 63, 83, 6, 64, 64, 100, 64, 64, 106, 64, 64, 6, 64, 190, 100, 64, 24,
106, 64, 84, 6, 65, 65, 100, 65, 65, 106, 65, 65, 6, 65, 191, 100, 65, 25, 106, 65, 85, 6, 66, 66, 100, 66, 66, 106, 66,
66, 6, 66, 192, 100, 66, 26, 106, 66, 86, 6, 67, 67, 100, 67, 67, 106, 67, 67, 6, 67, 193, 100, 67, 27, 106, 67, 87, 6,
68, 68, 100, 68, 68, 106, 68, 68, 6, 68, 194, 100, 68, 28, 106, 68, 88, 6, 69, 69, 100, 69, 69, 106, 69, 69, 6, 69, 195,
100, 69, 29, 106, 69, 89, 6, 70, 70, 100, 70, 70, 106, 70, 70, 6, 70, 196, 100, 70, 30, 106, 70, 90, 6, 71, 71, 100, 71,
71, 106, 71, 71, 6, 71, 197, 100, 71, 31, 106, 71, 91, 6, 72, 72, 100, 72, 72, 106, 72, 72, 6, 72, 198, 100, 72, 32,
106, 72, 92, 6, 73, 73, 100, 73, 73, 106, 73, 73, 6, 73, 199, 100, 73, 33, 106, 73, 93, 6, 74, 74, 100, 74, 74, 106, 74,
74, 6, 74, 200, 100, 74, 34, 106, 74, 94, 6, 75, 75, 100, 75, 75, 106, 75, 75, 6, 75, 201, 100, 75, 35, 106, 75, 95, 6,
76, 76, 100, 76, 76, 106, 76, 76, 6, 76, 202, 100, 76, 36, 106, 76, 96, 6, 77, 77, 100, 77, 77, 106, 77, 77, 6, 77, 203,
100, 77, 37, 106, 77, 97, 6, 78, 78, 100, 78, 78, 106, 78, 78, 6, 78, 204, 100, 78, 38, 106, 78, 98, 6, 79, 79, 100, 79,
79, 106, 79, 79, 6, 79, 205, 100, 79, 39, 106, 79, 99, 53, 80, 80, 93, 80, 80, 89, 80, 80, 53, 80, 60, 93, 80, 172, 89,
80, 142, 53, 81, 81, 93, 81, 81, 89, 81, 81, 53, 81, 61, 93, 81, 173, 53, 82, 82, 93, 82, 82, 89, 82, 82, 53, 82, 62,
93, 82, 174, 53, 83, 83, 93, 83, 83, 89, 83, 83, 53, 83, 63, 93, 83, 175, 53, 84, 84, 93, 84, 84, 89, 84, 84, 53, 84,
64, 93, 84, 176, 53, 85, 85, 93, 85, 85, 89, 85, 85, 53, 85, 65, 93, 85, 177, 53, 86, 86, 93, 86, 86, 89, 86, 86, 53,
86, 66, 93, 86, 178, 53, 87, 87, 93, 87, 87, 89, 87, 87, 53, 87, 67, 93, 87, 179, 53, 88, 88, 93, 88, 88, 89, 88, 88,
53, 88, 68, 93, 88, 180, 53, 89, 89, 93, 89, 89, 89, 89, 89, 53, 89, 69, 93, 89, 181, 53, 90, 90, 93, 90, 90, 89, 90,
90, 53, 90, 70, 53, 91, 91, 93, 91, 91, 89, 91, 91, 53, 91, 71, 53, 92, 92, 93, 92, 92, 89, 92, 92, 53, 92, 72, 53, 93,
93, 93, 93, 93, 89, 93, 93, 53, 93, 73, 53, 94, 94, 93, 94, 94, 89, 94, 94, 53, 94, 74, 53, 95, 95, 93, 95, 95, 89, 95,
95, 53, 95, 75, 53, 96, 96, 93, 96, 96, 89, 96, 96, 53, 96, 76, 53, 97, 97, 93, 97, 97, 89, 97, 97, 53, 97, 77, 53, 98,
98, 93, 98, 98, 89, 98, 98, 53, 98, 78, 53, 99, 99, 89, 99, 99, 93, 99, 99, 53, 99, 79, 89, 99, 143, 38, 100, 100, 39,
100, 100, 95, 100, 100, 38, 100, 182, 39, 100, 185, 95, 100, 151, 38, 101, 101, 39, 101, 101, 95, 101, 101, 38, 101,
183, 39, 101, 184, 95, 101, 150, 38, 102, 102, 39, 102, 102, 95, 102, 102, 38, 102, 184, 39, 102, 183, 95, 102, 149, 38,
103, 103, 39, 103, 103, 95, 103, 103, 38, 103, 185, 39, 103, 182, 95, 103, 148, 37, 104, 104, 103, 104, 104, 102, 104,
104, 37, 104, 105, 103, 104, 143, 102, 104, 148, 48, 105, 105, 90, 105, 105, 48, 105, 142, 90, 105, 104, 14, 106, 106,
66, 106, 106, 14, 106, 144, 66, 106, 152, 14, 107, 107, 66, 107, 107, 14, 107, 145, 66, 107, 153, 14, 108, 108, 66, 108,
108, 14, 108, 146, 66, 108, 154, 14, 109, 109, 66, 109, 109, 14, 109, 147, 66, 109, 155, 66, 110, 110, 14, 110, 110, 66,
110, 156, 66, 111, 111, 14, 111, 111, 66, 111, 157, 66, 112, 112, 14, 112, 112, 66, 112, 158, 66, 113, 113, 14, 113,
113, 66, 113, 159, 66, 114, 114, 14, 114, 114, 66, 114, 160, 66, 115, 115, 14, 115, 115, 66, 115, 161, 14, 116, 116, 66,
116, 116, 14, 117, 117, 66, 117, 117, 14, 118, 118, 66, 118, 118, 14, 119, 119, 66, 119, 119, 14, 120, 120, 66, 120,
120, 14, 121, 121, 66, 121, 121, 14, 122, 122, 66, 122, 122, 14, 123, 123, 66, 123, 123, 14, 124, 124, 66, 124, 124, 14,
125, 125, 66, 125, 125, 14, 126, 126, 66, 126, 126, 14, 127, 127, 66, 127, 127, 14, 128, 128, 66, 128, 128, 14, 129,
129, 66, 129, 129, 14, 130, 130, 66, 130, 130, 14, 131, 131, 66, 131, 131, 14, 132, 132, 66, 132, 132, 14, 133, 133, 66,
133, 133, 14, 134, 134, 66, 134, 134, 14, 135, 135, 66, 135, 135, 14, 136, 136, 66, 136, 136, 14, 137, 137, 66, 137,
137, 14, 138, 138, 66, 138, 138, 14, 139, 139, 66, 139, 139, 14, 140, 140, 66, 140, 140, 14, 140, 141, 12, 141, 141, 67,
141, 141, 12, 141, 39, 67, 141, 140, 23, 142, 142, 23, 142, 142, 36, 142, 142, 12, 142, 142, 101, 142, 142, 63, 142,
142, 23, 142, 59, 23, 142, 40, 36, 142, 80, 12, 142, 20, 101, 142, 105, 63, 142, 206, 50, 143, 143, 36, 143, 143, 98,
143, 143, 50, 143, 104, 36, 143, 99, 11, 144, 144, 67, 144, 144, 11, 144, 20, 67, 144, 106, 11, 145, 145, 67, 145, 145,
11, 145, 21, 67, 145, 107, 11, 146, 146, 67, 146, 146, 11, 146, 22, 67, 146, 108, 11, 147, 147, 67, 147, 147, 11, 147,
23, 67, 147, 109, 42, 148, 148, 49, 148, 148, 88, 148, 148, 42, 148, 103, 49, 148, 104, 88, 148, 16, 42, 149, 149, 88,
149, 149, 49, 149, 149, 42, 149, 102, 88, 149, 17, 42, 150, 150, 88, 150, 150, 49, 150, 150, 42, 150, 101, 88, 150, 18,
42, 151, 151, 88, 151, 151, 49, 151, 151, 42, 151, 100, 88, 151, 19, 51, 152, 152, 13, 152, 152, 51, 152, 172, 13, 152,
106, 51, 153, 153, 13, 153, 153, 51, 153, 173, 13, 153, 107, 51, 154, 154, 13, 154, 154, 51, 154, 174, 13, 154, 108, 51,
155, 155, 13, 155, 155, 51, 155, 175, 13, 155, 109, 51, 156, 156, 13, 156, 156, 51, 156, 176, 13, 156, 110, 51, 157,
157, 13, 157, 157, 51, 157, 177, 13, 157, 111, 51, 158, 158, 13, 158, 158, 51, 158, 178, 13, 158, 112, 51, 159, 159, 13,
159, 159, 51, 159, 179, 13, 159, 113, 51, 160, 160, 13, 160, 160, 51, 160, 180, 13, 160, 114, 51, 161, 161, 13, 161,
161, 51, 161, 181, 13, 161, 115, 41, 162, 162, 75, 162, 162, 41, 162, 1, 75, 162, 182, 41, 163, 163, 75, 163, 163, 41,
163, 3, 75, 163, 183, 41, 164, 164, 75, 164, 164, 41, 164, 5, 75, 164, 184, 41, 165, 165, 75, 165, 165, 41, 165, 6, 41,
166, 166, 75, 166, 166, 41, 166, 8, 41, 167, 167, 75, 167, 167, 41, 167, 9, 41, 168, 168, 75, 168, 168, 41, 168, 12, 75,
168, 185, 41, 169, 169, 75, 169, 169, 41, 169, 14, 41, 170, 170, 75, 170, 170, 41, 170, 15, 41, 171, 171, 75, 171, 171,
41, 171, 19, 40, 172, 172, 104, 172, 172, 105, 172, 172, 40, 172, 80, 104, 172, 152, 105, 172, 206, 40, 173, 173, 104,
173, 173, 105, 173, 173, 40, 173, 81, 104, 173, 153, 105, 173, 207, 40, 174, 174, 104, 174, 174, 105, 174, 174, 40, 174,
82, 104, 174, 154, 105, 174, 208, 40, 175, 175, 104, 175, 175, 105, 175, 175, 40, 175, 83, 104, 175, 155, 105, 175, 209,
40, 176, 176, 104, 176, 176, 105, 176, 176, 40, 176, 84, 104, 176, 156, 105, 176, 210, 40, 177, 177, 104, 177, 177, 105,
177, 177, 40, 177, 85, 104, 177, 157, 105, 177, 211, 40, 178, 178, 104, 178, 178, 105, 178, 178, 40, 178, 86, 104, 178,
158, 105, 178, 212, 40, 179, 179, 104, 179, 179, 105, 179, 179, 40, 179, 87, 104, 179, 159, 105, 179, 213, 40, 180, 180,
104, 180, 180, 105, 180, 180, 40, 180, 88, 104, 180, 160, 105, 180, 214, 40, 181, 181, 104, 181, 181, 105, 181, 181, 40,
181, 89, 104, 181, 161, 105, 181, 215, 22, 182, 182, 91, 182, 182, 92, 182, 182, 22, 182, 162, 91, 182, 100, 92, 182,
103, 22, 183, 183, 91, 183, 183, 92, 183, 183, 22, 183, 163, 91, 183, 101, 92, 183, 102, 22, 184, 184, 91, 184, 184, 92,
184, 184, 22, 184, 164, 91, 184, 102, 92, 184, 101, 22, 185, 185, 91, 185, 185, 92, 185, 185, 22, 185, 168, 91, 185,
103, 92, 185, 100, 59, 186, 186, 7, 186, 186, 8, 186, 186, 59, 186, 60, 59, 187, 187, 7, 187, 187, 8, 187, 187, 59, 187,
61, 59, 188, 188, 7, 188, 188, 8, 188, 188, 59, 188, 62, 59, 189, 189, 7, 189, 189, 8, 189, 189, 59, 189, 63, 59, 190,
190, 7, 190, 190, 8, 190, 190, 59, 190, 64, 59, 191, 191, 7, 191, 191, 8, 191, 191, 59, 191, 65, 59, 192, 192, 7, 192,
192, 8, 192, 192, 59, 192, 66, 59, 193, 193, 7, 193, 193, 8, 193, 193, 59, 193, 67, 59, 194, 194, 7, 194, 194, 8, 194,
194, 59, 194, 68, 59, 195, 195, 7, 195, 195, 8, 195, 195, 59, 195, 69, 59, 196, 196, 7, 196, 196, 8, 196, 196, 59, 196,
70, 59, 197, 197, 7, 197, 197, 8, 197, 197, 59, 197, 71, 59, 198, 198, 7, 198, 198, 8, 198, 198, 59, 198, 72, 59, 199,
199, 7, 199, 199, 8, 199, 199, 59, 199, 73, 59, 200, 200, 7, 200, 200, 8, 200, 200, 59, 200, 74, 59, 201, 201, 7, 201,
201, 8, 201, 201, 59, 201, 75, 59, 202, 202, 7, 202, 202, 8, 202, 202, 59, 202, 76, 59, 203, 203, 7, 203, 203, 8, 203,
203, 59, 203, 77, 59, 204, 204, 7, 204, 204, 8, 204, 204, 59, 204, 78, 59, 205, 205, 7, 205, 205, 8, 205, 205, 59, 205,
79, 52, 206, 206, 10, 206, 206, 52, 206, 172, 10, 206, 142, 52, 207, 207, 10, 207, 207, 52, 207, 173, 52, 208, 208, 10,
208, 208, 52, 208, 174, 52, 209, 209, 10, 209, 209, 52, 209, 175, 52, 210, 210, 10, 210, 210, 52, 210, 176, 52, 211,
211, 10, 211, 211, 52, 211, 177, 52, 212, 212, 10, 212, 212, 52, 212, 178, 52, 213, 213, 10, 213, 213, 52, 213, 179, 52,
214, 214, 10, 214, 214, 52, 214, 180, 52, 215, 215, 10, 215, 215, 52, 215, 181)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(35, 1, 228, 194, 94, 1, 369, 178, 35, 2, 228, 195, 35, 3, 130, 353, 94, 3, 370, 178, 35, 4, 228, 196, 35, 5, 130, 354,
94, 5, 371, 178, 35, 6, 130, 355, 35, 7, 228, 197, 35, 8, 130, 356, 94, 8, 372, 178, 35, 9, 130, 357, 35, 10, 130, 358,
35, 11, 129, 353, 94, 11, 373, 178, 35, 12, 129, 354, 94, 12, 374, 178, 35, 13, 129, 355, 35, 14, 129, 356, 94, 14, 375,
178, 35, 15, 129, 357, 35, 16, 129, 358, 94, 17, 376, 178, 94, 18, 377, 178, 94, 19, 378, 178, 65, 22, 341, 181, 65, 23,
342, 181, 65, 24, 343, 181, 64, 25, 347, 179, 65, 25, 341, 182, 64, 26, 348, 179, 65, 26, 342, 182, 64, 27, 349, 179,
65, 27, 343, 182, 64, 28, 350, 179, 65, 28, 184, 338, 64, 29, 351, 179, 65, 29, 185, 338, 64, 30, 352, 179, 65, 30, 186,
338, 64, 31, 347, 180, 65, 31, 341, 183, 64, 32, 348, 180, 65, 32, 342, 183, 64, 33, 349, 180, 65, 33, 343, 183, 64, 34,
350, 180, 65, 34, 184, 339, 64, 35, 351, 180, 65, 35, 185, 339, 64, 36, 352, 180, 65, 36, 186, 339, 64, 37, 190, 337,
65, 37, 184, 340, 64, 38, 191, 337, 65, 38, 185, 340, 64, 39, 192, 337, 65, 39, 186, 340, 64, 40, 193, 337, 76, 42, 186,
341, 76, 43, 186, 342, 76, 44, 186, 343, 76, 45, 185, 341, 76, 46, 185, 342, 76, 47, 185, 343, 76, 48, 343, 184, 76, 49,
343, 185, 76, 50, 343, 186, 76, 51, 184, 341, 76, 52, 184, 342, 76, 53, 184, 343, 76, 54, 342, 184, 76, 55, 342, 185,
76, 56, 342, 186, 76, 57, 341, 184, 76, 58, 341, 185, 76, 59, 341, 186, 89, 82, 187, 341, 89, 83, 187, 342, 89, 84, 187,
343, 89, 85, 188, 341, 89, 86, 188, 342, 89, 87, 188, 343, 89, 88, 344, 184, 89, 89, 344, 185, 89, 90, 344, 186, 93, 91,
178, 379, 89, 91, 189, 341, 93, 92, 178, 380, 89, 92, 189, 342, 93, 93, 178, 381, 89, 93, 189, 343, 93, 94, 178, 382,
89, 94, 345, 184, 93, 95, 178, 383, 89, 95, 345, 185, 93, 96, 178, 384, 89, 96, 345, 186, 93, 97, 178, 385, 89, 97, 346,
184, 93, 98, 178, 386, 89, 98, 346, 185, 93, 99, 178, 387, 89, 99, 346, 186, 93, 100, 178, 388, 14, 111, 347, 181, 14,
112, 348, 181, 14, 113, 349, 181, 14, 114, 350, 181, 14, 115, 351, 181, 14, 116, 352, 181, 14, 117, 347, 182, 66, 117,
359, 179, 14, 118, 348, 182, 66, 118, 360, 179, 14, 119, 349, 182, 66, 119, 361, 179, 14, 120, 350, 182, 66, 120, 362,
179, 14, 121, 351, 182, 66, 121, 363, 179, 14, 122, 352, 182, 66, 122, 364, 179, 14, 123, 190, 338, 66, 123, 365, 179,
14, 124, 191, 338, 66, 124, 366, 179, 14, 125, 192, 338, 66, 125, 367, 179, 14, 126, 193, 338, 66, 126, 368, 179, 14,
127, 347, 183, 66, 127, 359, 180, 14, 128, 348, 183, 66, 128, 360, 180, 14, 129, 349, 183, 66, 129, 361, 180, 14, 130,
350, 183, 66, 130, 362, 180, 14, 131, 351, 183, 66, 131, 363, 180, 14, 132, 352, 183, 66, 132, 364, 180, 14, 133, 190,
339, 66, 133, 365, 180, 14, 134, 191, 339, 66, 134, 366, 180, 14, 135, 192, 339, 66, 135, 367, 180, 14, 136, 193, 339,
66, 136, 368, 180, 14, 137, 190, 340, 66, 137, 198, 337, 14, 138, 191, 340, 66, 138, 199, 337, 14, 139, 192, 340, 66,
139, 200, 337, 14, 140, 193, 340, 66, 140, 201, 337, 66, 141, 202, 337, 98, 144, 228, 178, 49, 150, 312, 178, 49, 151,
311, 178, 49, 152, 310, 178, 75, 166, 389, 178, 75, 167, 390, 178, 75, 168, 391, 178, 75, 170, 392, 178, 75, 171, 393,
178, 75, 172, 394, 178, 7, 187, 46, 1, 8, 187, 47, 1, 7, 188, 48, 1, 8, 188, 49, 1, 7, 189, 50, 1, 8, 189, 51, 1, 7,
190, 52, 1, 8, 190, 53, 1, 7, 191, 54, 1, 8, 191, 55, 1, 7, 192, 56, 1, 8, 192, 57, 1, 7, 193, 58, 1, 8, 193, 59, 1, 7,
194, 60, 1, 8, 194, 61, 1, 7, 195, 62, 1, 8, 195, 63, 1, 7, 196, 64, 1, 8, 196, 65, 1, 7, 197, 66, 1, 8, 197, 67, 1, 7,
198, 68, 1, 8, 198, 69, 1, 7, 199, 70, 1, 8, 199, 71, 1, 7, 200, 72, 1, 8, 200, 73, 1, 7, 201, 74, 1, 8, 201, 75, 1, 7,
202, 76, 1, 8, 202, 77, 1, 7, 203, 78, 1, 8, 203, 79, 1, 7, 204, 80, 1, 8, 204, 81, 1, 7, 205, 82, 1, 8, 205, 83, 1, 7,
206, 84, 1, 8, 206, 85, 1, 10, 208, 341, 179, 10, 209, 342, 179, 10, 210, 343, 179, 10, 211, 341, 180, 10, 212, 342,
180, 10, 213, 343, 180, 10, 214, 184, 337, 10, 215, 185, 337, 10, 216, 186, 337)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  4: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=4
nb_c=149
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=507 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(35, 0, 0, 94, 0, 0, 35, 1, 1, 94, 1, 1, 94, 2, 2, 35, 2, 2, 94, 2, 118, 35, 3, 3, 94, 3, 3, 35, 4, 4, 94, 4, 4, 94, 5,
5, 35, 5, 5, 94, 5, 119, 35, 6, 6, 94, 6, 6, 94, 7, 7, 35, 7, 7, 94, 7, 120, 35, 8, 8, 94, 8, 8, 94, 9, 9, 35, 9, 9, 94,
9, 121, 35, 10, 10, 94, 10, 10, 35, 11, 11, 94, 11, 11, 35, 12, 12, 94, 12, 12, 94, 13, 13, 35, 13, 13, 94, 13, 122, 35,
14, 14, 94, 14, 14, 35, 14, 112, 47, 15, 15, 99, 15, 15, 64, 15, 15, 65, 15, 15, 47, 15, 45, 99, 15, 30, 64, 15, 111,
47, 16, 16, 99, 16, 16, 64, 16, 16, 65, 16, 16, 47, 16, 46, 99, 16, 31, 47, 17, 17, 99, 17, 17, 64, 17, 17, 65, 17, 17,
47, 17, 47, 99, 17, 32, 47, 18, 18, 99, 18, 18, 64, 18, 18, 65, 18, 18, 47, 18, 48, 99, 18, 33, 47, 19, 19, 99, 19, 19,
64, 19, 19, 65, 19, 19, 47, 19, 49, 99, 19, 34, 47, 20, 20, 99, 20, 20, 64, 20, 20, 65, 20, 20, 47, 20, 50, 99, 20, 35,
47, 21, 21, 99, 21, 21, 64, 21, 21, 65, 21, 21, 47, 21, 51, 99, 21, 36, 47, 22, 22, 99, 22, 22, 64, 22, 22, 65, 22, 22,
47, 22, 52, 99, 22, 37, 47, 23, 23, 99, 23, 23, 64, 23, 23, 65, 23, 23, 47, 23, 53, 99, 23, 38, 47, 24, 24, 99, 24, 24,
64, 24, 24, 65, 24, 24, 47, 24, 54, 99, 24, 39, 47, 25, 25, 99, 25, 25, 64, 25, 25, 65, 25, 25, 47, 25, 55, 99, 25, 40,
47, 26, 26, 99, 26, 26, 64, 26, 26, 65, 26, 26, 47, 26, 56, 99, 26, 41, 47, 27, 27, 99, 27, 27, 64, 27, 27, 65, 27, 27,
47, 27, 57, 99, 27, 42, 47, 28, 28, 99, 28, 28, 64, 28, 28, 65, 28, 28, 47, 28, 58, 99, 28, 43, 47, 29, 29, 99, 29, 29,
64, 29, 29, 65, 29, 29, 47, 29, 59, 99, 29, 44, 46, 30, 30, 76, 30, 30, 46, 30, 15, 46, 31, 31, 76, 31, 31, 46, 31, 16,
46, 32, 32, 76, 32, 32, 46, 32, 17, 46, 33, 33, 76, 33, 33, 46, 33, 18, 46, 34, 34, 76, 34, 34, 46, 34, 19, 46, 35, 35,
76, 35, 35, 46, 35, 20, 46, 36, 36, 76, 36, 36, 46, 36, 21, 46, 37, 37, 76, 37, 37, 46, 37, 22, 46, 38, 38, 76, 38, 38,
46, 38, 23, 46, 39, 39, 76, 39, 39, 46, 39, 24, 46, 40, 40, 76, 40, 40, 46, 40, 25, 46, 41, 41, 76, 41, 41, 46, 41, 26,
46, 42, 42, 76, 42, 42, 46, 42, 27, 46, 43, 43, 76, 43, 43, 46, 43, 28, 46, 44, 44, 76, 44, 44, 46, 44, 29, 6, 45, 45,
100, 45, 45, 106, 45, 45, 6, 45, 129, 100, 45, 15, 106, 45, 60, 6, 46, 46, 100, 46, 46, 106, 46, 46, 6, 46, 130, 100,
46, 16, 106, 46, 61, 6, 47, 47, 100, 47, 47, 106, 47, 47, 6, 47, 131, 100, 47, 17, 106, 47, 62, 6, 48, 48, 100, 48, 48,
106, 48, 48, 6, 48, 132, 100, 48, 18, 106, 48, 63, 6, 49, 49, 100, 49, 49, 106, 49, 49, 6, 49, 133, 100, 49, 19, 106,
49, 64, 6, 50, 50, 100, 50, 50, 106, 50, 50, 6, 50, 134, 100, 50, 20, 106, 50, 65, 6, 51, 51, 100, 51, 51, 106, 51, 51,
6, 51, 135, 100, 51, 21, 106, 51, 66, 6, 52, 52, 100, 52, 52, 106, 52, 52, 6, 52, 136, 100, 52, 22, 106, 52, 67, 6, 53,
53, 100, 53, 53, 106, 53, 53, 6, 53, 137, 100, 53, 23, 106, 53, 68, 6, 54, 54, 100, 54, 54, 106, 54, 54, 6, 54, 138,
100, 54, 24, 106, 54, 69, 6, 55, 55, 100, 55, 55, 106, 55, 55, 6, 55, 139, 100, 55, 25, 106, 55, 70, 6, 56, 56, 100, 56,
56, 106, 56, 56, 6, 56, 140, 100, 56, 26, 106, 56, 71, 6, 57, 57, 100, 57, 57, 106, 57, 57, 6, 57, 141, 100, 57, 27,
106, 57, 72, 6, 58, 58, 100, 58, 58, 106, 58, 58, 6, 58, 142, 100, 58, 28, 106, 58, 73, 6, 59, 59, 100, 59, 59, 106, 59,
59, 6, 59, 143, 100, 59, 29, 106, 59, 74, 53, 60, 60, 93, 60, 60, 89, 60, 60, 53, 60, 45, 93, 60, 123, 53, 61, 61, 93,
61, 61, 89, 61, 61, 53, 61, 46, 93, 61, 124, 53, 62, 62, 93, 62, 62, 89, 62, 62, 53, 62, 47, 93, 62, 125, 53, 63, 63,
93, 63, 63, 89, 63, 63, 53, 63, 48, 93, 63, 126, 53, 64, 64, 93, 64, 64, 89, 64, 64, 53, 64, 49, 93, 64, 127, 53, 65,
65, 93, 65, 65, 89, 65, 65, 53, 65, 50, 53, 66, 66, 93, 66, 66, 89, 66, 66, 53, 66, 51, 53, 67, 67, 93, 67, 67, 89, 67,
67, 53, 67, 52, 53, 68, 68, 93, 68, 68, 89, 68, 68, 53, 68, 53, 53, 69, 69, 93, 69, 69, 89, 69, 69, 53, 69, 54, 53, 70,
70, 93, 70, 70, 89, 70, 70, 53, 70, 55, 53, 71, 71, 93, 71, 71, 89, 71, 71, 53, 71, 56, 53, 72, 72, 93, 72, 72, 89, 72,
72, 53, 72, 57, 53, 73, 73, 93, 73, 73, 89, 73, 73, 53, 73, 58, 53, 74, 74, 93, 74, 74, 89, 74, 74, 53, 74, 59, 38, 75,
75, 39, 75, 75, 95, 75, 75, 38, 75, 128, 39, 75, 128, 95, 75, 112, 14, 76, 76, 66, 76, 76, 14, 76, 111, 66, 76, 113, 66,
77, 77, 14, 77, 77, 66, 77, 114, 66, 78, 78, 14, 78, 78, 66, 78, 115, 66, 79, 79, 14, 79, 79, 66, 79, 116, 66, 80, 80,
14, 80, 80, 66, 80, 117, 14, 81, 81, 66, 81, 81, 14, 82, 82, 66, 82, 82, 14, 83, 83, 66, 83, 83, 14, 84, 84, 66, 84, 84,
14, 85, 85, 66, 85, 85, 14, 86, 86, 66, 86, 86, 14, 87, 87, 66, 87, 87, 14, 88, 88, 66, 88, 88, 14, 89, 89, 66, 89, 89,
14, 90, 90, 66, 90, 90, 14, 91, 91, 66, 91, 91, 14, 92, 92, 66, 92, 92, 14, 93, 93, 66, 93, 93, 14, 94, 94, 66, 94, 94,
14, 95, 95, 66, 95, 95, 14, 96, 96, 66, 96, 96, 14, 97, 97, 66, 97, 97, 14, 98, 98, 66, 98, 98, 14, 99, 99, 66, 99, 99,
14, 100, 100, 66, 100, 100, 14, 101, 101, 66, 101, 101, 14, 102, 102, 66, 102, 102, 14, 103, 103, 66, 103, 103, 14, 104,
104, 66, 104, 104, 14, 105, 105, 66, 105, 105, 14, 106, 106, 66, 106, 106, 14, 107, 107, 66, 107, 107, 14, 108, 108, 66,
108, 108, 14, 109, 109, 66, 109, 109, 14, 110, 110, 66, 110, 110, 11, 111, 111, 67, 111, 111, 11, 111, 15, 67, 111, 76,
42, 112, 112, 88, 112, 112, 49, 112, 112, 42, 112, 75, 88, 112, 14, 51, 113, 113, 13, 113, 113, 51, 113, 123, 13, 113,
76, 51, 114, 114, 13, 114, 114, 51, 114, 124, 13, 114, 77, 51, 115, 115, 13, 115, 115, 51, 115, 125, 13, 115, 78, 51,
116, 116, 13, 116, 116, 51, 116, 126, 13, 116, 79, 51, 117, 117, 13, 117, 117, 51, 117, 127, 13, 117, 80, 41, 118, 118,
75, 118, 118, 41, 118, 2, 75, 118, 128, 41, 119, 119, 75, 119, 119, 41, 119, 5, 41, 120, 120, 75, 120, 120, 41, 120, 7,
41, 121, 121, 75, 121, 121, 41, 121, 9, 41, 122, 122, 75, 122, 122, 41, 122, 13, 40, 123, 123, 104, 123, 123, 105, 123,
123, 40, 123, 60, 104, 123, 113, 105, 123, 144, 40, 124, 124, 104, 124, 124, 105, 124, 124, 40, 124, 61, 104, 124, 114,
105, 124, 145, 40, 125, 125, 104, 125, 125, 105, 125, 125, 40, 125, 62, 104, 125, 115, 105, 125, 146, 40, 126, 126, 104,
126, 126, 105, 126, 126, 40, 126, 63, 104, 126, 116, 105, 126, 147, 40, 127, 127, 104, 127, 127, 105, 127, 127, 40, 127,
64, 104, 127, 117, 105, 127, 148, 22, 128, 128, 91, 128, 128, 92, 128, 128, 22, 128, 118, 91, 128, 75, 92, 128, 75, 59,
129, 129, 7, 129, 129, 8, 129, 129, 59, 129, 45, 59, 130, 130, 7, 130, 130, 8, 130, 130, 59, 130, 46, 59, 131, 131, 7,
131, 131, 8, 131, 131, 59, 131, 47, 59, 132, 132, 7, 132, 132, 8, 132, 132, 59, 132, 48, 59, 133, 133, 7, 133, 133, 8,
133, 133, 59, 133, 49, 59, 134, 134, 7, 134, 134, 8, 134, 134, 59, 134, 50, 59, 135, 135, 7, 135, 135, 8, 135, 135, 59,
135, 51, 59, 136, 136, 7, 136, 136, 8, 136, 136, 59, 136, 52, 59, 137, 137, 7, 137, 137, 8, 137, 137, 59, 137, 53, 59,
138, 138, 7, 138, 138, 8, 138, 138, 59, 138, 54, 59, 139, 139, 7, 139, 139, 8, 139, 139, 59, 139, 55, 59, 140, 140, 7,
140, 140, 8, 140, 140, 59, 140, 56, 59, 141, 141, 7, 141, 141, 8, 141, 141, 59, 141, 57, 59, 142, 142, 7, 142, 142, 8,
142, 142, 59, 142, 58, 59, 143, 143, 7, 143, 143, 8, 143, 143, 59, 143, 59, 52, 144, 144, 10, 144, 144, 52, 144, 123,
52, 145, 145, 10, 145, 145, 52, 145, 124, 52, 146, 146, 10, 146, 146, 52, 146, 125, 52, 147, 147, 10, 147, 147, 52, 147,
126, 52, 148, 148, 10, 148, 148, 52, 148, 127)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(35, 1, 228, 353, 94, 1, 582, 178, 35, 2, 228, 354, 94, 2, 583, 178, 35, 3, 228, 355, 35, 4, 130, 568, 94, 4, 584, 178,
35, 5, 228, 356, 94, 5, 585, 178, 35, 6, 228, 357, 35, 7, 130, 569, 94, 7, 586, 178, 35, 8, 228, 358, 35, 9, 130, 570,
94, 9, 587, 178, 35, 10, 130, 571, 35, 11, 129, 568, 94, 11, 588, 178, 35, 12, 129, 569, 94, 12, 589, 178, 35, 13, 129,
570, 94, 13, 590, 178, 35, 14, 129, 571, 94, 15, 591, 178, 65, 16, 562, 181, 64, 17, 564, 179, 65, 17, 562, 182, 64, 18,
565, 179, 65, 18, 341, 338, 64, 19, 566, 179, 65, 19, 342, 338, 64, 20, 567, 179, 65, 20, 343, 338, 64, 21, 564, 180,
65, 21, 562, 183, 64, 22, 565, 180, 65, 22, 341, 339, 64, 23, 566, 180, 65, 23, 342, 339, 64, 24, 567, 180, 65, 24, 343,
339, 64, 25, 347, 337, 65, 25, 341, 340, 64, 26, 348, 337, 65, 26, 342, 340, 64, 27, 349, 337, 65, 27, 343, 340, 64, 28,
350, 337, 65, 28, 184, 561, 64, 29, 351, 337, 65, 29, 185, 561, 64, 30, 352, 337, 65, 30, 186, 561, 76, 31, 186, 562,
76, 32, 185, 562, 76, 33, 343, 341, 76, 34, 343, 342, 76, 35, 343, 343, 76, 36, 184, 562, 76, 37, 342, 341, 76, 38, 342,
342, 76, 39, 342, 343, 76, 40, 341, 341, 76, 41, 341, 342, 76, 42, 341, 343, 76, 43, 562, 184, 76, 44, 562, 185, 76, 45,
562, 186, 89, 61, 187, 562, 89, 62, 188, 562, 89, 63, 344, 341, 89, 64, 344, 342, 89, 65, 344, 343, 93, 66, 178, 592,
89, 66, 189, 562, 93, 67, 178, 593, 89, 67, 345, 341, 93, 68, 178, 594, 89, 68, 345, 342, 93, 69, 178, 595, 89, 69, 345,
343, 93, 70, 178, 596, 89, 70, 346, 341, 93, 71, 178, 597, 89, 71, 346, 342, 93, 72, 178, 598, 89, 72, 346, 343, 93, 73,
178, 599, 89, 73, 563, 184, 93, 74, 178, 600, 89, 74, 563, 185, 93, 75, 178, 601, 89, 75, 563, 186, 14, 78, 564, 181,
14, 79, 565, 181, 14, 80, 566, 181, 14, 81, 567, 181, 14, 82, 564, 182, 66, 82, 572, 179, 14, 83, 565, 182, 66, 83, 573,
179, 14, 84, 566, 182, 66, 84, 574, 179, 14, 85, 567, 182, 66, 85, 575, 179, 14, 86, 347, 338, 66, 86, 576, 179, 14, 87,
348, 338, 66, 87, 577, 179, 14, 88, 349, 338, 66, 88, 578, 179, 14, 89, 350, 338, 66, 89, 579, 179, 14, 90, 351, 338,
66, 90, 580, 179, 14, 91, 352, 338, 66, 91, 581, 179, 14, 92, 564, 183, 66, 92, 572, 180, 14, 93, 565, 183, 66, 93, 573,
180, 14, 94, 566, 183, 66, 94, 574, 180, 14, 95, 567, 183, 66, 95, 575, 180, 14, 96, 347, 339, 66, 96, 576, 180, 14, 97,
348, 339, 66, 97, 577, 180, 14, 98, 349, 339, 66, 98, 578, 180, 14, 99, 350, 339, 66, 99, 579, 180, 14, 100, 351, 339,
66, 100, 580, 180, 14, 101, 352, 339, 66, 101, 581, 180, 14, 102, 347, 340, 66, 102, 359, 337, 14, 103, 348, 340, 66,
103, 360, 337, 14, 104, 349, 340, 66, 104, 361, 337, 14, 105, 350, 340, 66, 105, 362, 337, 14, 106, 351, 340, 66, 106,
363, 337, 14, 107, 352, 340, 66, 107, 364, 337, 14, 108, 190, 561, 66, 108, 365, 337, 14, 109, 191, 561, 66, 109, 366,
337, 14, 110, 192, 561, 66, 110, 367, 337, 14, 111, 193, 561, 66, 111, 368, 337, 49, 113, 524, 178, 75, 120, 602, 178,
75, 121, 603, 178, 75, 122, 604, 178, 75, 123, 605, 178, 7, 130, 16, 1, 8, 130, 17, 1, 7, 131, 18, 1, 8, 131, 19, 1, 7,
132, 20, 1, 8, 132, 21, 1, 7, 133, 22, 1, 8, 133, 23, 1, 7, 134, 24, 1, 8, 134, 25, 1, 7, 135, 26, 1, 8, 135, 27, 1, 7,
136, 28, 1, 8, 136, 29, 1, 7, 137, 30, 1, 8, 137, 31, 1, 7, 138, 32, 1, 8, 138, 33, 1, 7, 139, 34, 1, 8, 139, 35, 1, 7,
140, 36, 1, 8, 140, 37, 1, 7, 141, 38, 1, 8, 141, 39, 1, 7, 142, 40, 1, 8, 142, 41, 1, 7, 143, 42, 1, 8, 143, 43, 1, 7,
144, 44, 1, 8, 144, 45, 1, 10, 145, 562, 179, 10, 146, 562, 180, 10, 147, 341, 337, 10, 148, 342, 337, 10, 149, 343, 337)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  5: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=5
nb_c=61
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=656 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(35, 0, 0, 94, 0, 0, 35, 1, 1, 94, 1, 1, 35, 2, 2, 94, 2, 2, 94, 3, 3, 35, 3, 3, 94, 3, 52, 35, 4, 4, 94, 4, 4, 35, 5, 5,
94, 5, 5, 47, 6, 6, 99, 6, 6, 64, 6, 6, 65, 6, 6, 47, 6, 18, 99, 6, 12, 47, 7, 7, 99, 7, 7, 64, 7, 7, 65, 7, 7, 47, 7,
19, 99, 7, 13, 47, 8, 8, 99, 8, 8, 64, 8, 8, 65, 8, 8, 47, 8, 20, 99, 8, 14, 47, 9, 9, 99, 9, 9, 64, 9, 9, 65, 9, 9, 47,
9, 21, 99, 9, 15, 47, 10, 10, 99, 10, 10, 64, 10, 10, 65, 10, 10, 47, 10, 22, 99, 10, 16, 47, 11, 11, 99, 11, 11, 64,
11, 11, 65, 11, 11, 47, 11, 23, 99, 11, 17, 46, 12, 12, 76, 12, 12, 46, 12, 6, 46, 13, 13, 76, 13, 13, 46, 13, 7, 46,
14, 14, 76, 14, 14, 46, 14, 8, 46, 15, 15, 76, 15, 15, 46, 15, 9, 46, 16, 16, 76, 16, 16, 46, 16, 10, 46, 17, 17, 76,
17, 17, 46, 17, 11, 6, 18, 18, 100, 18, 18, 106, 18, 18, 6, 18, 54, 100, 18, 6, 106, 18, 24, 6, 19, 19, 100, 19, 19,
106, 19, 19, 6, 19, 55, 100, 19, 7, 106, 19, 25, 6, 20, 20, 100, 20, 20, 106, 20, 20, 6, 20, 56, 100, 20, 8, 106, 20,
26, 6, 21, 21, 100, 21, 21, 106, 21, 21, 6, 21, 57, 100, 21, 9, 106, 21, 27, 6, 22, 22, 100, 22, 22, 106, 22, 22, 6, 22,
58, 100, 22, 10, 106, 22, 28, 6, 23, 23, 100, 23, 23, 106, 23, 23, 6, 23, 59, 100, 23, 11, 106, 23, 29, 53, 24, 24, 93,
24, 24, 89, 24, 24, 53, 24, 18, 93, 24, 53, 53, 25, 25, 93, 25, 25, 89, 25, 25, 53, 25, 19, 53, 26, 26, 93, 26, 26, 89,
26, 26, 53, 26, 20, 53, 27, 27, 93, 27, 27, 89, 27, 27, 53, 27, 21, 53, 28, 28, 93, 28, 28, 89, 28, 28, 53, 28, 22, 53,
29, 29, 93, 29, 29, 89, 29, 29, 53, 29, 23, 66, 30, 30, 14, 30, 30, 66, 30, 51, 14, 31, 31, 66, 31, 31, 14, 32, 32, 66,
32, 32, 14, 33, 33, 66, 33, 33, 14, 34, 34, 66, 34, 34, 14, 35, 35, 66, 35, 35, 14, 36, 36, 66, 36, 36, 14, 37, 37, 66,
37, 37, 14, 38, 38, 66, 38, 38, 14, 39, 39, 66, 39, 39, 14, 40, 40, 66, 40, 40, 14, 41, 41, 66, 41, 41, 14, 42, 42, 66,
42, 42, 14, 43, 43, 66, 43, 43, 14, 44, 44, 66, 44, 44, 14, 45, 45, 66, 45, 45, 14, 46, 46, 66, 46, 46, 14, 47, 47, 66,
47, 47, 14, 48, 48, 66, 48, 48, 14, 49, 49, 66, 49, 49, 14, 50, 50, 66, 50, 50, 51, 51, 51, 13, 51, 51, 51, 51, 53, 13,
51, 30, 41, 52, 52, 75, 52, 52, 41, 52, 3, 40, 53, 53, 104, 53, 53, 105, 53, 53, 40, 53, 24, 104, 53, 51, 105, 53, 60,
59, 54, 54, 7, 54, 54, 8, 54, 54, 59, 54, 18, 59, 55, 55, 7, 55, 55, 8, 55, 55, 59, 55, 19, 59, 56, 56, 7, 56, 56, 8,
56, 56, 59, 56, 20, 59, 57, 57, 7, 57, 57, 8, 57, 57, 59, 57, 21, 59, 58, 58, 7, 58, 58, 8, 58, 58, 59, 58, 22, 59, 59,
59, 7, 59, 59, 8, 59, 59, 59, 59, 23, 52, 60, 60, 10, 60, 60, 52, 60, 53)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(35, 1, 228, 568, 94, 1, 754, 178, 35, 2, 228, 569, 94, 2, 755, 178, 35, 3, 228, 570, 94, 3, 756, 178, 35, 4, 228, 571,
35, 5, 130, 748, 94, 5, 757, 178, 35, 6, 129, 748, 94, 6, 758, 178, 64, 7, 747, 179, 65, 7, 562, 338, 64, 8, 747, 180,
65, 8, 562, 339, 64, 9, 564, 337, 65, 9, 562, 340, 64, 10, 565, 337, 65, 10, 341, 561, 64, 11, 566, 337, 65, 11, 342,
561, 64, 12, 567, 337, 65, 12, 343, 561, 76, 13, 343, 562, 76, 14, 342, 562, 76, 15, 341, 562, 76, 16, 562, 341, 76, 17,
562, 342, 76, 18, 562, 343, 89, 25, 344, 562, 93, 26, 178, 759, 89, 26, 345, 562, 93, 27, 178, 760, 89, 27, 346, 562,
93, 28, 178, 761, 89, 28, 563, 341, 93, 29, 178, 762, 89, 29, 563, 342, 93, 30, 178, 763, 89, 30, 563, 343, 14, 31, 747,
181, 14, 32, 747, 182, 66, 32, 749, 179, 14, 33, 564, 338, 66, 33, 750, 179, 14, 34, 565, 338, 66, 34, 751, 179, 14, 35,
566, 338, 66, 35, 752, 179, 14, 36, 567, 338, 66, 36, 753, 179, 14, 37, 747, 183, 66, 37, 749, 180, 14, 38, 564, 339,
66, 38, 750, 180, 14, 39, 565, 339, 66, 39, 751, 180, 14, 40, 566, 339, 66, 40, 752, 180, 14, 41, 567, 339, 66, 41, 753,
180, 14, 42, 564, 340, 66, 42, 572, 337, 14, 43, 565, 340, 66, 43, 573, 337, 14, 44, 566, 340, 66, 44, 574, 337, 14, 45,
567, 340, 66, 45, 575, 337, 14, 46, 347, 561, 66, 46, 576, 337, 14, 47, 348, 561, 66, 47, 577, 337, 14, 48, 349, 561,
66, 48, 578, 337, 14, 49, 350, 561, 66, 49, 579, 337, 14, 50, 351, 561, 66, 50, 580, 337, 14, 51, 352, 561, 66, 51, 581,
337, 75, 53, 764, 178, 7, 55, 4, 1, 8, 55, 5, 1, 7, 56, 6, 1, 8, 56, 7, 1, 7, 57, 8, 1, 8, 57, 9, 1, 7, 58, 10, 1, 8,
58, 11, 1, 7, 59, 12, 1, 8, 59, 13, 1, 7, 60, 14, 1, 8, 60, 15, 1, 10, 61, 562, 337)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  6: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=6
nb_c=13
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=717 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(35, 0, 0, 94, 0, 0, 47, 1, 1, 99, 1, 1, 64, 1, 1, 65, 1, 1, 47, 1, 3, 99, 1, 2, 46, 2, 2, 76, 2, 2, 46, 2, 1, 6, 3, 3,
100, 3, 3, 106, 3, 3, 6, 3, 12, 100, 3, 1, 106, 3, 4, 53, 4, 4, 93, 4, 4, 89, 4, 4, 53, 4, 3, 14, 5, 5, 66, 5, 5, 14, 6,
6, 66, 6, 6, 14, 7, 7, 66, 7, 7, 14, 8, 8, 66, 8, 8, 14, 9, 9, 66, 9, 9, 14, 10, 10, 66, 10, 10, 14, 11, 11, 66, 11, 11,
59, 12, 12, 7, 12, 12, 8, 12, 12, 59, 12, 3)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(35, 1, 228, 748, 94, 1, 837, 178, 64, 2, 747, 337, 65, 2, 562, 561, 76, 3, 562, 562, 93, 5, 178, 838, 89, 5, 563, 562,
14, 6, 747, 338, 66, 6, 836, 179, 14, 7, 747, 339, 66, 7, 836, 180, 14, 8, 747, 340, 66, 8, 749, 337, 14, 9, 564, 561,
66, 9, 750, 337, 14, 10, 565, 561, 66, 10, 751, 337, 14, 11, 566, 561, 66, 11, 752, 337, 14, 12, 567, 561, 66, 12, 753,
337, 7, 13, 2, 1, 8, 13, 3, 1)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  7: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=7
nb_c=1
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=730 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(14, 0, 0, 66, 0, 0)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(14, 1, 747, 561, 66, 1, 836, 337)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

# weight count
nb_rw=7
# cumomer count by weight
nb_rcumos=c(99, 192, 216, 149, 61, 13, 1)
nbc_rcumos=c(0, cumsum(nb_rcumos))
# cumo names
nm_rcumo=c("AcCoA:1", "AcCoA:2", "Cit:1", "Cit:2", "Cit:4", "Cit:8", "Cit:16", "Cit:32", "Fru6P:1", "Fru6P:2", "Fru6P:4",
"Fru6P:8", "Fru6P:16", "Fru6P:32", "FruBP:1", "FruBP:2", "FruBP:4", "FruBP:8", "FruBP:16", "FruBP:32", "Glc6P:1",
"Glc6P:2", "Glc6P:4", "Glc6P:8", "Glc6P:16", "Glc6P:32", "Gnt6P:1", "Gnt6P:2", "Gnt6P:4", "Gnt6P:8", "Gnt6P:16",
"Gnt6P:32", "Mal:1", "Mal:2", "Mal:4", "Mal:8", "PEP:1", "PEP:2", "PEP:4", "PGA:1", "PGA:2", "PGA:4", "Sed7P:1",
"Sed7P:2", "Sed7P:4", "Sed7P:8", "Sed7P:16", "Sed7P:32", "Sed7P:64", "CO2:1", "E2:1", "E2:2", "E3:1", "E3:2", "E3:4",
"GA3P:1", "GA3P:2", "GA3P:4", "Pyr:1", "Pyr:2", "Pyr:4", "Ery4P:1", "Ery4P:2", "Ery4P:4", "Ery4P:8", "OAA:8", "OAA:4",
"OAA:2", "OAA:1", "Rib5P:1", "Rib5P:2", "Rib5P:4", "Rib5P:8", "Rib5P:16", "AKG:1", "AKG:2", "AKG:4", "AKG:8", "AKG:16",
"Rub5P:1", "Rub5P:2", "Rub5P:4", "Rub5P:8", "Rub5P:16", "Suc:1", "Suc:2", "Suc:4", "Suc:8", "Glc:1", "Glc:2", "Glc:4",
"Glc:8", "Glc:16", "Glc:32", "Xul5P:8", "Xul5P:16", "Xul5P:1", "Xul5P:2", "Xul5P:4", "AcCoA:3", "Cit:3", "Cit:5",
"Cit:9", "Cit:17", "Cit:33", "Cit:6", "Cit:10", "Cit:18", "Cit:34", "Cit:12", "Cit:20", "Cit:36", "Cit:24", "Cit:40",
"Cit:48", "Fru6P:3", "Fru6P:5", "Fru6P:6", "Fru6P:9", "Fru6P:10", "Fru6P:12", "Fru6P:17", "Fru6P:18", "Fru6P:20",
"Fru6P:24", "Fru6P:33", "Fru6P:34", "Fru6P:36", "Fru6P:40", "Fru6P:48", "FruBP:3", "FruBP:5", "FruBP:6", "FruBP:9",
"FruBP:10", "FruBP:12", "FruBP:17", "FruBP:18", "FruBP:20", "FruBP:24", "FruBP:33", "FruBP:34", "FruBP:36", "FruBP:40",
"FruBP:48", "Glc6P:3", "Glc6P:5", "Glc6P:6", "Glc6P:9", "Glc6P:10", "Glc6P:12", "Glc6P:17", "Glc6P:18", "Glc6P:20",
"Glc6P:24", "Glc6P:33", "Glc6P:34", "Glc6P:36", "Glc6P:40", "Glc6P:48", "Gnt6P:3", "Gnt6P:5", "Gnt6P:6", "Gnt6P:9",
"Gnt6P:10", "Gnt6P:12", "Gnt6P:17", "Gnt6P:18", "Gnt6P:20", "Gnt6P:24", "Gnt6P:33", "Gnt6P:34", "Gnt6P:36", "Gnt6P:40",
"Gnt6P:48", "Mal:3", "Mal:5", "Mal:9", "Mal:6", "Mal:10", "Mal:12", "PEP:3", "PEP:5", "PEP:6", "PGA:3", "PGA:5",
"PGA:6", "Sed7P:3", "Sed7P:5", "Sed7P:6", "Sed7P:9", "Sed7P:10", "Sed7P:12", "Sed7P:17", "Sed7P:18", "Sed7P:20",
"Sed7P:24", "Sed7P:33", "Sed7P:34", "Sed7P:36", "Sed7P:40", "Sed7P:48", "Sed7P:65", "Sed7P:66", "Sed7P:68", "Sed7P:72",
"Sed7P:80", "Sed7P:96", "E2:3", "E3:3", "E3:5", "E3:6", "GA3P:3", "GA3P:5", "GA3P:6", "Pyr:3", "Pyr:5", "Pyr:6",
"Ery4P:3", "Ery4P:5", "Ery4P:6", "Ery4P:9", "Ery4P:10", "Ery4P:12", "OAA:12", "OAA:10", "OAA:6", "OAA:9", "OAA:5",
"OAA:3", "Rib5P:3", "Rib5P:5", "Rib5P:6", "Rib5P:9", "Rib5P:10", "Rib5P:12", "Rib5P:17", "Rib5P:18", "Rib5P:20",
"Rib5P:24", "AKG:3", "AKG:5", "AKG:9", "AKG:17", "AKG:6", "AKG:10", "AKG:18", "AKG:12", "AKG:20", "AKG:24", "Rub5P:3",
"Rub5P:5", "Rub5P:6", "Rub5P:9", "Rub5P:10", "Rub5P:12", "Rub5P:17", "Rub5P:18", "Rub5P:20", "Rub5P:24", "Suc:3",
"Suc:5", "Suc:9", "Suc:6", "Suc:10", "Suc:12", "Glc:3", "Glc:5", "Glc:6", "Glc:9", "Glc:10", "Glc:12", "Glc:17",
"Glc:18", "Glc:20", "Glc:24", "Glc:33", "Glc:34", "Glc:36", "Glc:40", "Glc:48", "Xul5P:24", "Xul5P:3", "Xul5P:5",
"Xul5P:6", "Xul5P:9", "Xul5P:10", "Xul5P:12", "Xul5P:17", "Xul5P:18", "Xul5P:20", "Cit:7", "Cit:11", "Cit:13", "Cit:19",
"Cit:21", "Cit:25", "Cit:35", "Cit:37", "Cit:41", "Cit:49", "Cit:14", "Cit:22", "Cit:26", "Cit:38", "Cit:42", "Cit:50",
"Cit:28", "Cit:44", "Cit:52", "Cit:56", "Fru6P:7", "Fru6P:11", "Fru6P:13", "Fru6P:14", "Fru6P:19", "Fru6P:21",
"Fru6P:22", "Fru6P:25", "Fru6P:26", "Fru6P:28", "Fru6P:35", "Fru6P:37", "Fru6P:38", "Fru6P:41", "Fru6P:42", "Fru6P:44",
"Fru6P:49", "Fru6P:50", "Fru6P:52", "Fru6P:56", "FruBP:7", "FruBP:11", "FruBP:13", "FruBP:14", "FruBP:19", "FruBP:21",
"FruBP:22", "FruBP:25", "FruBP:26", "FruBP:28", "FruBP:35", "FruBP:37", "FruBP:38", "FruBP:41", "FruBP:42", "FruBP:44",
"FruBP:49", "FruBP:50", "FruBP:52", "FruBP:56", "Glc6P:7", "Glc6P:11", "Glc6P:13", "Glc6P:14", "Glc6P:19", "Glc6P:21",
"Glc6P:22", "Glc6P:25", "Glc6P:26", "Glc6P:28", "Glc6P:35", "Glc6P:37", "Glc6P:38", "Glc6P:41", "Glc6P:42", "Glc6P:44",
"Glc6P:49", "Glc6P:50", "Glc6P:52", "Glc6P:56", "Gnt6P:7", "Gnt6P:11", "Gnt6P:13", "Gnt6P:14", "Gnt6P:19", "Gnt6P:21",
"Gnt6P:22", "Gnt6P:25", "Gnt6P:26", "Gnt6P:28", "Gnt6P:35", "Gnt6P:37", "Gnt6P:38", "Gnt6P:41", "Gnt6P:42", "Gnt6P:44",
"Gnt6P:49", "Gnt6P:50", "Gnt6P:52", "Gnt6P:56", "Mal:7", "Mal:11", "Mal:13", "Mal:14", "PEP:7", "PGA:7", "Sed7P:7",
"Sed7P:11", "Sed7P:13", "Sed7P:14", "Sed7P:19", "Sed7P:21", "Sed7P:22", "Sed7P:25", "Sed7P:26", "Sed7P:28", "Sed7P:35",
"Sed7P:37", "Sed7P:38", "Sed7P:41", "Sed7P:42", "Sed7P:44", "Sed7P:49", "Sed7P:50", "Sed7P:52", "Sed7P:56", "Sed7P:67",
"Sed7P:69", "Sed7P:70", "Sed7P:73", "Sed7P:74", "Sed7P:76", "Sed7P:81", "Sed7P:82", "Sed7P:84", "Sed7P:88", "Sed7P:97",
"Sed7P:98", "Sed7P:100", "Sed7P:104", "Sed7P:112", "E3:7", "GA3P:7", "Pyr:7", "Ery4P:7", "Ery4P:11", "Ery4P:13",
"Ery4P:14", "OAA:14", "OAA:13", "OAA:11", "OAA:7", "Rib5P:7", "Rib5P:11", "Rib5P:13", "Rib5P:14", "Rib5P:19",
"Rib5P:21", "Rib5P:22", "Rib5P:25", "Rib5P:26", "Rib5P:28", "AKG:7", "AKG:11", "AKG:13", "AKG:19", "AKG:21", "AKG:25",
"AKG:14", "AKG:22", "AKG:26", "AKG:28", "Rub5P:7", "Rub5P:11", "Rub5P:13", "Rub5P:14", "Rub5P:19", "Rub5P:21",
"Rub5P:22", "Rub5P:25", "Rub5P:26", "Rub5P:28", "Suc:7", "Suc:11", "Suc:13", "Suc:14", "Glc:7", "Glc:11", "Glc:13",
"Glc:14", "Glc:19", "Glc:21", "Glc:22", "Glc:25", "Glc:26", "Glc:28", "Glc:35", "Glc:37", "Glc:38", "Glc:41", "Glc:42",
"Glc:44", "Glc:49", "Glc:50", "Glc:52", "Glc:56", "Xul5P:7", "Xul5P:11", "Xul5P:13", "Xul5P:14", "Xul5P:19", "Xul5P:21",
"Xul5P:22", "Xul5P:25", "Xul5P:26", "Xul5P:28", "Cit:15", "Cit:23", "Cit:27", "Cit:29", "Cit:39", "Cit:43", "Cit:45",
"Cit:51", "Cit:53", "Cit:57", "Cit:30", "Cit:46", "Cit:54", "Cit:58", "Cit:60", "Fru6P:15", "Fru6P:23", "Fru6P:27",
"Fru6P:29", "Fru6P:30", "Fru6P:39", "Fru6P:43", "Fru6P:45", "Fru6P:46", "Fru6P:51", "Fru6P:53", "Fru6P:54", "Fru6P:57",
"Fru6P:58", "Fru6P:60", "FruBP:15", "FruBP:23", "FruBP:27", "FruBP:29", "FruBP:30", "FruBP:39", "FruBP:43", "FruBP:45",
"FruBP:46", "FruBP:51", "FruBP:53", "FruBP:54", "FruBP:57", "FruBP:58", "FruBP:60", "Glc6P:15", "Glc6P:23", "Glc6P:27",
"Glc6P:29", "Glc6P:30", "Glc6P:39", "Glc6P:43", "Glc6P:45", "Glc6P:46", "Glc6P:51", "Glc6P:53", "Glc6P:54", "Glc6P:57",
"Glc6P:58", "Glc6P:60", "Gnt6P:15", "Gnt6P:23", "Gnt6P:27", "Gnt6P:29", "Gnt6P:30", "Gnt6P:39", "Gnt6P:43", "Gnt6P:45",
"Gnt6P:46", "Gnt6P:51", "Gnt6P:53", "Gnt6P:54", "Gnt6P:57", "Gnt6P:58", "Gnt6P:60", "Mal:15", "Sed7P:15", "Sed7P:23",
"Sed7P:27", "Sed7P:29", "Sed7P:30", "Sed7P:39", "Sed7P:43", "Sed7P:45", "Sed7P:46", "Sed7P:51", "Sed7P:53", "Sed7P:54",
"Sed7P:57", "Sed7P:58", "Sed7P:60", "Sed7P:71", "Sed7P:75", "Sed7P:77", "Sed7P:78", "Sed7P:83", "Sed7P:85", "Sed7P:86",
"Sed7P:89", "Sed7P:90", "Sed7P:92", "Sed7P:99", "Sed7P:101", "Sed7P:102", "Sed7P:105", "Sed7P:106", "Sed7P:108",
"Sed7P:113", "Sed7P:114", "Sed7P:116", "Sed7P:120", "Ery4P:15", "OAA:15", "Rib5P:15", "Rib5P:23", "Rib5P:27",
"Rib5P:29", "Rib5P:30", "AKG:15", "AKG:23", "AKG:27", "AKG:29", "AKG:30", "Rub5P:15", "Rub5P:23", "Rub5P:27",
"Rub5P:29", "Rub5P:30", "Suc:15", "Glc:15", "Glc:23", "Glc:27", "Glc:29", "Glc:30", "Glc:39", "Glc:43", "Glc:45",
"Glc:46", "Glc:51", "Glc:53", "Glc:54", "Glc:57", "Glc:58", "Glc:60", "Xul5P:15", "Xul5P:23", "Xul5P:27", "Xul5P:29",
"Xul5P:30", "Cit:31", "Cit:47", "Cit:55", "Cit:59", "Cit:61", "Cit:62", "Fru6P:31", "Fru6P:47", "Fru6P:55", "Fru6P:59",
"Fru6P:61", "Fru6P:62", "FruBP:31", "FruBP:47", "FruBP:55", "FruBP:59", "FruBP:61", "FruBP:62", "Glc6P:31", "Glc6P:47",
"Glc6P:55", "Glc6P:59", "Glc6P:61", "Glc6P:62", "Gnt6P:31", "Gnt6P:47", "Gnt6P:55", "Gnt6P:59", "Gnt6P:61", "Gnt6P:62",
"Sed7P:31", "Sed7P:47", "Sed7P:55", "Sed7P:59", "Sed7P:61", "Sed7P:62", "Sed7P:79", "Sed7P:87", "Sed7P:91", "Sed7P:93",
"Sed7P:94", "Sed7P:103", "Sed7P:107", "Sed7P:109", "Sed7P:110", "Sed7P:115", "Sed7P:117", "Sed7P:118", "Sed7P:121",
"Sed7P:122", "Sed7P:124", "Rib5P:31", "AKG:31", "Rub5P:31", "Glc:31", "Glc:47", "Glc:55", "Glc:59", "Glc:61", "Glc:62",
"Xul5P:31", "Cit:63", "Fru6P:63", "FruBP:63", "Glc6P:63", "Gnt6P:63", "Sed7P:63", "Sed7P:95", "Sed7P:111", "Sed7P:119",
"Sed7P:123", "Sed7P:125", "Sed7P:126", "Glc:63", "Sed7P:127")
nm_list$rcumo=nm_rcumo
    
if (case_i) {
   # check the coherence of metabolites/cumomers
   met_net=unique(matrix(unlist(strsplit(nm_rcumo, ":", fixed=TRUE)), nrow=2)[1,])
   net_pool=sort(setdiff(met_net, names(nm_poolall)))
   if (length(net_pool) > 0) {
      stop_mes("The following metabolites are internal in NETWORK section but not in METABOLITE_POOLS one:\n", paste(net_pool, collapse="\n"), file=fcerr)
   }
}

nb_exp=1
nm_exp=c("e_coli_growth")
nm_list$nm_exp=nm_exp
# input cumomer vectors, list of vectors for case_s and matrices (nb_inp x nb_time) for case_i
xi=list(c(0, 0.952, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0,
0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.976, 0, 0.976, 0,
0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0,
0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0,
0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0.0107, 0.984, 0.0107, 0.984, 0.0107, 0.984, 0.0107, 0.984, 0.0107, 0.984, 0.0107,
0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 1.0, 0.992))
if (any(lengths(xi) == 0))
   stop_mes("No reduced label entry is defined (may be because no measurement provided). Cannot continue.", file=fcerr)
nm_xi=c("Gluc_1:63", "Gluc_U:63", "Gluc_1:31", "Gluc_U:31", "Gluc_1:47", "Gluc_U:47", "Gluc_1:55", "Gluc_U:55", "Gluc_1:59",
"Gluc_U:59", "Gluc_1:61", "Gluc_U:61", "Gluc_1:62", "Gluc_U:62", "Gluc_1:15", "Gluc_U:15", "Gluc_1:23", "Gluc_U:23",
"Gluc_1:27", "Gluc_U:27", "Gluc_1:29", "Gluc_U:29", "Gluc_1:30", "Gluc_U:30", "Gluc_1:39", "Gluc_U:39", "Gluc_1:43",
"Gluc_U:43", "Gluc_1:45", "Gluc_U:45", "Gluc_1:46", "Gluc_U:46", "Gluc_1:51", "Gluc_U:51", "Gluc_1:53", "Gluc_U:53",
"Gluc_1:54", "Gluc_U:54", "Gluc_1:57", "Gluc_U:57", "Gluc_1:58", "Gluc_U:58", "Gluc_1:60", "Gluc_U:60", "Gluc_1:7",
"Gluc_U:7", "Gluc_1:11", "Gluc_U:11", "Gluc_1:13", "Gluc_U:13", "Gluc_1:14", "Gluc_U:14", "Gluc_1:19", "Gluc_U:19",
"Gluc_1:21", "Gluc_U:21", "Gluc_1:22", "Gluc_U:22", "Gluc_1:25", "Gluc_U:25", "Gluc_1:26", "Gluc_U:26", "Gluc_1:28",
"Gluc_U:28", "Gluc_1:35", "Gluc_U:35", "Gluc_1:37", "Gluc_U:37", "Gluc_1:38", "Gluc_U:38", "Gluc_1:41", "Gluc_U:41",
"Gluc_1:42", "Gluc_U:42", "Gluc_1:44", "Gluc_U:44", "Gluc_1:49", "Gluc_U:49", "Gluc_1:50", "Gluc_U:50", "Gluc_1:52",
"Gluc_U:52", "Gluc_1:56", "Gluc_U:56", "Gluc_1:3", "Gluc_U:3", "Gluc_1:5", "Gluc_U:5", "Gluc_1:6", "Gluc_U:6",
"Gluc_1:9", "Gluc_U:9", "Gluc_1:10", "Gluc_U:10", "Gluc_1:12", "Gluc_U:12", "Gluc_1:17", "Gluc_U:17", "Gluc_1:18",
"Gluc_U:18", "Gluc_1:20", "Gluc_U:20", "Gluc_1:24", "Gluc_U:24", "Gluc_1:33", "Gluc_U:33", "Gluc_1:34", "Gluc_U:34",
"Gluc_1:36", "Gluc_U:36", "Gluc_1:40", "Gluc_U:40", "Gluc_1:48", "Gluc_U:48", "CO2_ext:1", "Gluc_1:1", "Gluc_U:1",
"Gluc_1:2", "Gluc_U:2", "Gluc_1:4", "Gluc_U:4", "Gluc_1:8", "Gluc_U:8", "Gluc_1:16", "Gluc_U:16", "Gluc_1:32",
"Gluc_U:32") # same for all parallel exps
for (i in seq_along(xi)) {
   names(xi[[i]])=nm_xi
}
nm_list$xi=nm_xi
nb_xi=length(nm_xi)
nb_f$xi=nb_xi
nb_cumoi=nb_xi
nm_inp=nm_xi
nm_incu=c("one", nm_xi, nm_rcumo)
nm_inlab=nm_incu
spa=spAbr
nm_x=nm_rcumo
nb_x=nb_rcumos
nb_f$rcumos=nb_rcumos
nb_f$cumoi=nb_cumoi
if (emu) {
   nm_emu=c()
   nb_emus=nb_rcumos*(seq_len(nb_rw)+1)
   nb_f$emus=nb_emus
   nm_list$emu=nm_emu
   nm_x=nm_emu
   nb_x=nb_emus
   xiemu=list()
   nm_xiemu=c()
   nm_list$xiemu=nm_xiemu
   for (i in seq_along(xiemu))
        names(xiemu[[i]])=nm_xiemu
   nb_xiemu=length(nm_xiemu)
   nb_f$xiemu=nb_xiemu
   nb_f$xi=nb_xiemu
   nb_xi=nb_xiemu
   nm_inp=nm_xiemu
   xi=xiemu
   nm_inemu=c("one", nm_xiemu, nm_emu)
   nm_inlab=nm_inemu
   spa=spr2emu(spAbr, nm_incu, nm_inemu, nb_f)
}
# reorder indexes to accelerate sparse matrix construction
spa=sparse2spa(spa)
#browser()
# composite labeling vector incu c(1, xi, xc) names
nm_inlab=c("one", nm_inp, nm_x); # the constant 1 has name "one"
nm_list$x=nm_x
nm_list$inp=nm_inp
nb_f$x=nb_x
    
nm_cumo=NULL
spaf=NULL

if (TIMEIT) {
   cat("measure : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
if (!noscale) {
   # make place for scaling factors
   nb_sc=vector("integer", 1)
    # experiment: 1

   # mass
   # initial values for scales are set later
   param=c(param,1, 1, 1, 1, 1, 1, 1, 1, 1)
   nm_par=c(nm_par,c("1:mass;Cit;111111;252", "1:mass;Fru6P;111111;258", "1:mass;FruBP;111111;265", "1:mass;Glc6P;111111;272",
"1:mass;Gnt6P;111111;279", "1:mass;Mal;1111;286", "1:mass;PEP;111;290", "1:mass;PGA;111;294", "1:mass;Sed7P;1111111;298"))
   names(param)=nm_par
            
   nb_param=length(param)
   nb_sc[1]=nb_param-nb_ff # at this moment it is cumulated sum. diff() is taken later

   # indices mapping from scaling to measure matrix row
   # c(1,par)[ir2isc[[iexp]]] replicates scale parameters
   # for corresponding rows of measure matrix
   ir2isc=vector("list", 1)

   # 1:label
   ir2isc[[1]]=c(ir2isc[[1]],c(1, 1, 1, 1))

   # 1:mass
   ir2isc[[1]]=c(ir2isc[[1]],c(2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8,
8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10))

   if (!is.null(ir2isc[[1]])) {
      isc=ir2isc[[1]] != 1
      ir2isc[[1]][isc]=ir2isc[[1]][isc]+nb_ff
   }

   # cumulated base for nb_sc
   nb_sc_base=c(0, nb_sc[-nb_exp])
   nb_sc=diff(c(0, nb_sc))
   nb_sc_tot=sum(nb_sc)
   nb_f$nb_sc=nb_sc
   nb_f$nb_sc_tot=nb_sc_tot
   nb_f$nb_sc_base=nb_sc_base
#browser()
} else {
   # no scaling
   ir2isc=list()
   nb_sc=integer(nb_exp)
   nb_sc_tot=0
}
nb_f$nb_sc=nb_sc
nb_f$nb_sc_tot=nb_sc_tot
nm_list$par=nm_par

# make a list of sparse measurement matrices
# measmat*xr+memaone gives a vector of simulated not-yet-pooled and not-yet-scaled measurements
# all but 0. Coefficients of 0-cumomers (by defenition equal to 1)
# are all regrouped in the memaone.
nm_measmat=nm_meas=nb_meas=nb_measmat=measmat=memaone=measvec=measdev=ipooled=vector("list", 1)

nm_measmat[[1]]=c("l:AcCoA:00:244", "l:AcCoA:01:245", "l:AcCoA:10:246", "l:AcCoA:11:247", "m:Cit::1:252", "m:Cit::2:253", "m:Cit::3:254",
"m:Cit::4:255", "m:Cit::5:256", "m:Cit::6:257", "m:Fru6P::0:258", "m:Fru6P::1:259", "m:Fru6P::2:260", "m:Fru6P::3:261",
"m:Fru6P::4:262", "m:Fru6P::5:263", "m:Fru6P::6:264", "m:FruBP::0:265", "m:FruBP::1:266", "m:FruBP::2:267",
"m:FruBP::3:268", "m:FruBP::4:269", "m:FruBP::5:270", "m:FruBP::6:271", "m:Glc6P::0:272", "m:Glc6P::1:273",
"m:Glc6P::2:274", "m:Glc6P::3:275", "m:Glc6P::4:276", "m:Glc6P::5:277", "m:Glc6P::6:278", "m:Gnt6P::0:279",
"m:Gnt6P::1:280", "m:Gnt6P::2:281", "m:Gnt6P::3:282", "m:Gnt6P::4:283", "m:Gnt6P::5:284", "m:Gnt6P::6:285",
"m:Mal::1:286", "m:Mal::2:287", "m:Mal::3:288", "m:Mal::4:289", "m:PEP::0:290", "m:PEP::1:291", "m:PEP::2:292",
"m:PEP::3:293", "m:PGA::0:294", "m:PGA::1:295", "m:PGA::2:296", "m:PGA::3:297", "m:Sed7P::0:298", "m:Sed7P::1:299",
"m:Sed7P::2:300", "m:Sed7P::3:301", "m:Sed7P::4:302", "m:Sed7P::5:303", "m:Sed7P::6:304", "m:Sed7P::7:305")
if (length(nm_measmat[[1]]) == 0)
   stop_mes("At least one labeling measurement must be given in experiment '", nm_exp[1], "'", file=fcerr)
nm_meas[[1]]=c("l:AcCoA:00:244", "l:AcCoA:01:245", "l:AcCoA:10:246", "l:AcCoA:11:247", "m:Cit::1:252", "m:Cit::2:253", "m:Cit::3:254",
"m:Cit::4:255", "m:Cit::5:256", "m:Cit::6:257", "m:Fru6P::0:258", "m:Fru6P::1:259", "m:Fru6P::2:260", "m:Fru6P::3:261",
"m:Fru6P::4:262", "m:Fru6P::5:263", "m:Fru6P::6:264", "m:FruBP::0:265", "m:FruBP::1:266", "m:FruBP::2:267",
"m:FruBP::3:268", "m:FruBP::4:269", "m:FruBP::5:270", "m:FruBP::6:271", "m:Glc6P::0:272", "m:Glc6P::1:273",
"m:Glc6P::2:274", "m:Glc6P::3:275", "m:Glc6P::4:276", "m:Glc6P::5:277", "m:Glc6P::6:278", "m:Gnt6P::0:279",
"m:Gnt6P::1:280", "m:Gnt6P::2:281", "m:Gnt6P::3:282", "m:Gnt6P::4:283", "m:Gnt6P::5:284", "m:Gnt6P::6:285",
"m:Mal::1:286", "m:Mal::2:287", "m:Mal::3:288", "m:Mal::4:289", "m:PEP::0:290", "m:PEP::1:291", "m:PEP::2:292",
"m:PEP::3:293", "m:PGA::0:294", "m:PGA::1:295", "m:PGA::2:296", "m:PGA::3:297", "m:Sed7P::0:298", "m:Sed7P::1:299",
"m:Sed7P::2:300", "m:Sed7P::3:301", "m:Sed7P::4:302", "m:Sed7P::5:303", "m:Sed7P::6:304", "m:Sed7P::7:305")
nb_meas[[1]]=length(nm_meas[[1]])
nb_measmat[[1]]=length(nm_measmat[[1]])
measmat[[1]]=simple_triplet_zero_matrix(nrow=nb_measmat[[1]], ncol=731)
dimnames(measmat[[1]])=list(nm_measmat[[1]], nm_x)
memaone[[1]]=numeric(nb_measmat[[1]])
measvec[[1]]=c(0.495, 0.303, 0.012, 0.19, 0.322208057034832, 0.288291305558056, 0.212855540659154, 0.117626468347467,
0.0484839619377435, 0.0105346664627478, 0.04716, 0.623343333333333, 0.0820266666666667, 0.03604, 0.0315766666666667,
0.0149133333333333, 0.164943333333333, 0.0853733333333333, 0.482283333333333, 0.140086666666667, 0.0953466666666667,
0.09712, 0.0120166666666667, 0.0877666666666667, 0.0167633333333333, 0.716826666666667, 0.0578233333333333,
0.0122433333333333, 0.01151, 0.01089, 0.173946666666667, 0.0195533333333333, 0.72562, 0.0571233333333333,
0.0135033333333333, 0.01331, 0.0131033333333333, 0.157793333333333, 0.587391867374382, 0.216493214407424,
0.159494782909672, 0.0366201353085213, 0.462166666666667, 0.340003333333333, 0.0273166666666667, 0.170513333333333,
0.447066666666667, 0.34127, 0.02441, 0.187253333333333, 0.272433333333333, 0.23752, 0.180446666666667, 0.12744, 0.06321,
0.0839233333333333, 0.01751, 0.0175266666666667)
measdev[[1]]=c(0.02, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.01, 0.0106878170518274, 0.01, 0.01, 0.01, 0.01,
0.0111688555068697, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01,
0.0120547874307264, 0.01, 0.01, 0.01, 0.01, 0.01, 0.0493159626907812, 0.0306546571894417, 0.03, 0.03, 0.01, 0.01, 0.01,
0.01, 0.0180848260520618, 0.018075350619006, 0.01, 0.01, 0.0122309539012022, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(measvec[[1]])=nm_meas[[1]]
names(measdev[[1]])=nm_meas[[1]]
ipooled[[1]]=list(ishort=pmatch(nm_meas[[1]], nm_measmat[[1]]))

nm_meas_tot=unlist(nm_meas)
nb_meas=unlist(nb_meas)
nb_meas_cumo=c(0., cumsum(nb_meas[-nb_exp]))
iexp_meas=lapply(seq_len(nb_exp), function(iexp) seq_len(nb_meas[iexp])+nb_meas_cumo[iexp])
nm_list$meas=nm_meas
nm_list$measmat=nm_measmat
nm_list$meas_tot=nm_meas_tot
nb_f$nb_meas=nb_meas

names(measvec)=names(measdev)=nm_exp

if (!noscale) {
   for (iexp in seq_len(nb_exp))
      if (length(ipooled[[iexp]]$ishort))
         ir2isc[[iexp]]=ir2isc[[iexp]][ipooled[[iexp]]$ishort]

   # prepare indexes of dispatching scale params in jacobian
   if (nb_sc_tot > 0) {
      nb_f$is2m=vector("list", nb_exp)
      for (iexp in seq_len(nb_exp)) {
         ipaire=matrix(0, nrow=0, ncol=2)
         tmp=lapply(seq_len(nb_sc[[iexp]]), function(isc) {
            i=which(ir2isc[[iexp]]==isc+nb_sc_base[iexp]+1+nb_ff)
            ipaire <<- rbind(ipaire, cbind(i, isc+nb_sc_base[iexp]))
            return(NULL)
         })
         nb_f$is2m[[iexp]]=ipaire
         # place holder for scale part of jacobian
         jx_f$dr_dsc[[iexp]]=simple_triplet_zero_matrix(nrow=length(ir2isc[[iexp]]), ncol=nb_sc_tot)
      }
   }
}
# prepare measmat indexes and values : ir, ic, val

ind_mema=matrix(c(
1, 100, 1, 1, 1, -1, 1, 2, -1,
                    2, 1, 1, 2, 100, -1,
                    3, 2, 1, 3, 100, -1,
                    4, 100, 1,
                    5, 3, 1, 5, 292, 3, 5, 293, 3, 5, 294, 3, 5, 295, 3, 5, 296, 3, 5, 297, 3, 5, 657, 5, 5, 298, 3, 5, 299, 3, 5, 300, 3,
5, 658, 5, 5, 301, 3, 5, 659, 5, 5, 660, 5, 5, 661, 5, 5, 101, -2, 5, 102, -2, 5, 103, -2, 5, 508, -4, 5, 104, -2, 5,
509, -4, 5, 510, -4, 5, 511, -4, 5, 105, -2, 5, 512, -4, 5, 513, -4, 5, 514, -4, 5, 515, -4, 5, 516, -4, 5, 517, -4, 5,
718, -6, 5, 4, 1, 5, 302, 3, 5, 303, 3, 5, 304, 3, 5, 305, 3, 5, 306, 3, 5, 307, 3, 5, 662, 5, 5, 106, -2, 5, 107, -2,
5, 108, -2, 5, 518, -4, 5, 109, -2, 5, 519, -4, 5, 520, -4, 5, 521, -4, 5, 5, 1, 5, 308, 3, 5, 309, 3, 5, 310, 3, 5,
110, -2, 5, 111, -2, 5, 112, -2, 5, 522, -4, 5, 6, 1, 5, 311, 3, 5, 113, -2, 5, 114, -2, 5, 7, 1, 5, 115, -2, 5, 8, 1,
                    6, 101, 1, 6, 508, 6, 6, 509, 6, 6, 510, 6, 6, 512, 6, 6, 513, 6, 6, 515, 6, 6, 718, 15, 6, 292, -3, 6, 293, -3, 6, 295,
-3, 6, 657, -10, 6, 298, -3, 6, 658, -10, 6, 659, -10, 6, 660, -10, 6, 102, 1, 6, 511, 6, 6, 514, 6, 6, 516, 6, 6, 294,
-3, 6, 296, -3, 6, 299, -3, 6, 661, -10, 6, 106, 1, 6, 518, 6, 6, 519, 6, 6, 520, 6, 6, 302, -3, 6, 303, -3, 6, 305, -3,
6, 662, -10, 6, 103, 1, 6, 517, 6, 6, 297, -3, 6, 300, -3, 6, 107, 1, 6, 521, 6, 6, 304, -3, 6, 306, -3, 6, 110, 1, 6,
522, 6, 6, 308, -3, 6, 309, -3, 6, 104, 1, 6, 301, -3, 6, 108, 1, 6, 307, -3, 6, 111, 1, 6, 310, -3, 6, 113, 1, 6, 311,
-3, 6, 105, 1, 6, 109, 1, 6, 112, 1, 6, 114, 1, 6, 115, 1,
                    7, 292, 1, 7, 657, 10, 7, 658, 10, 7, 659, 10, 7, 508, -4, 7, 509, -4, 7, 512, -4, 7, 718, -20, 7, 293, 1, 7, 660, 10,
7, 510, -4, 7, 513, -4, 7, 294, 1, 7, 661, 10, 7, 511, -4, 7, 514, -4, 7, 302, 1, 7, 662, 10, 7, 518, -4, 7, 519, -4, 7,
295, 1, 7, 515, -4, 7, 296, 1, 7, 516, -4, 7, 303, 1, 7, 520, -4, 7, 297, 1, 7, 517, -4, 7, 304, 1, 7, 521, -4, 7, 308,
1, 7, 522, -4, 7, 298, 1, 7, 299, 1, 7, 305, 1, 7, 300, 1, 7, 306, 1, 7, 309, 1, 7, 301, 1, 7, 307, 1, 7, 310, 1, 7,
311, 1,
                    8, 508, 1, 8, 718, 15, 8, 657, -5, 8, 658, -5, 8, 509, 1, 8, 659, -5, 8, 510, 1, 8, 660, -5, 8, 511, 1, 8, 661, -5, 8,
518, 1, 8, 662, -5, 8, 512, 1, 8, 513, 1, 8, 514, 1, 8, 519, 1, 8, 515, 1, 8, 516, 1, 8, 520, 1, 8, 517, 1, 8, 521, 1,
8, 522, 1,
                    9, 657, 1, 9, 718, -6, 9, 658, 1, 9, 659, 1, 9, 660, 1, 9, 661, 1, 9, 662, 1,
                    10, 718, 1,
                    11, 116, 1, 11, 117, 1, 11, 118, 1, 11, 119, 1, 11, 120, 1, 11, 121, 1, 11, 523, 1, 11, 122, 1, 11, 123, 1, 11, 124, 1,
11, 524, 1, 11, 125, 1, 11, 525, 1, 11, 526, 1, 11, 527, 1, 11, 126, 1, 11, 127, 1, 11, 128, 1, 11, 528, 1, 11, 129, 1,
11, 529, 1, 11, 530, 1, 11, 531, 1, 11, 130, 1, 11, 532, 1, 11, 533, 1, 11, 534, 1, 11, 535, 1, 11, 536, 1, 11, 537, 1,
11, 719, 1, 11, 9, -1, 11, 10, -1, 11, 11, -1, 11, 312, -1, 11, 12, -1, 11, 313, -1, 11, 314, -1, 11, 315, -1, 11, 13,
-1, 11, 316, -1, 11, 317, -1, 11, 318, -1, 11, 319, -1, 11, 320, -1, 11, 321, -1, 11, 663, -1, 11, 14, -1, 11, 322, -1,
11, 323, -1, 11, 324, -1, 11, 325, -1, 11, 326, -1, 11, 327, -1, 11, 664, -1, 11, 328, -1, 11, 329, -1, 11, 330, -1, 11,
665, -1, 11, 331, -1, 11, 666, -1, 11, 667, -1, 11, 668, -1,
                    12, 9, 1, 12, 312, 3, 12, 313, 3, 12, 314, 3, 12, 316, 3, 12, 317, 3, 12, 319, 3, 12, 663, 5, 12, 322, 3, 12, 323, 3,
12, 325, 3, 12, 664, 5, 12, 328, 3, 12, 665, 5, 12, 666, 5, 12, 667, 5, 12, 116, -2, 12, 117, -2, 12, 119, -2, 12, 523,
-4, 12, 122, -2, 12, 524, -4, 12, 525, -4, 12, 526, -4, 12, 126, -2, 12, 528, -4, 12, 529, -4, 12, 530, -4, 12, 532, -4,
12, 533, -4, 12, 535, -4, 12, 719, -6, 12, 10, 1, 12, 315, 3, 12, 318, 3, 12, 320, 3, 12, 324, 3, 12, 326, 3, 12, 329,
3, 12, 668, 5, 12, 118, -2, 12, 120, -2, 12, 123, -2, 12, 527, -4, 12, 127, -2, 12, 531, -4, 12, 534, -4, 12, 536, -4,
12, 11, 1, 12, 321, 3, 12, 327, 3, 12, 330, 3, 12, 121, -2, 12, 124, -2, 12, 128, -2, 12, 537, -4, 12, 12, 1, 12, 331,
3, 12, 125, -2, 12, 129, -2, 12, 13, 1, 12, 130, -2, 12, 14, 1,
                    13, 116, 1, 13, 523, 6, 13, 524, 6, 13, 525, 6, 13, 528, 6, 13, 529, 6, 13, 532, 6, 13, 719, 15, 13, 312, -3, 13, 313,
-3, 13, 316, -3, 13, 663, -10, 13, 322, -3, 13, 664, -10, 13, 665, -10, 13, 666, -10, 13, 117, 1, 13, 526, 6, 13, 530,
6, 13, 533, 6, 13, 314, -3, 13, 317, -3, 13, 323, -3, 13, 667, -10, 13, 118, 1, 13, 527, 6, 13, 531, 6, 13, 534, 6, 13,
315, -3, 13, 318, -3, 13, 324, -3, 13, 668, -10, 13, 119, 1, 13, 535, 6, 13, 319, -3, 13, 325, -3, 13, 120, 1, 13, 536,
6, 13, 320, -3, 13, 326, -3, 13, 121, 1, 13, 537, 6, 13, 321, -3, 13, 327, -3, 13, 122, 1, 13, 328, -3, 13, 123, 1, 13,
329, -3, 13, 124, 1, 13, 330, -3, 13, 125, 1, 13, 331, -3, 13, 126, 1, 13, 127, 1, 13, 128, 1, 13, 129, 1, 13, 130, 1,
                    14, 312, 1, 14, 663, 10, 14, 664, 10, 14, 665, 10, 14, 523, -4, 14, 524, -4, 14, 528, -4, 14, 719, -20, 14, 313, 1, 14,
666, 10, 14, 525, -4, 14, 529, -4, 14, 314, 1, 14, 667, 10, 14, 526, -4, 14, 530, -4, 14, 315, 1, 14, 668, 10, 14, 527,
-4, 14, 531, -4, 14, 316, 1, 14, 532, -4, 14, 317, 1, 14, 533, -4, 14, 318, 1, 14, 534, -4, 14, 319, 1, 14, 535, -4, 14,
320, 1, 14, 536, -4, 14, 321, 1, 14, 537, -4, 14, 322, 1, 14, 323, 1, 14, 324, 1, 14, 325, 1, 14, 326, 1, 14, 327, 1,
14, 328, 1, 14, 329, 1, 14, 330, 1, 14, 331, 1,
                    15, 523, 1, 15, 719, 15, 15, 663, -5, 15, 664, -5, 15, 524, 1, 15, 665, -5, 15, 525, 1, 15, 666, -5, 15, 526, 1, 15,
667, -5, 15, 527, 1, 15, 668, -5, 15, 528, 1, 15, 529, 1, 15, 530, 1, 15, 531, 1, 15, 532, 1, 15, 533, 1, 15, 534, 1,
15, 535, 1, 15, 536, 1, 15, 537, 1,
                    16, 663, 1, 16, 719, -6, 16, 664, 1, 16, 665, 1, 16, 666, 1, 16, 667, 1, 16, 668, 1,
                    17, 719, 1,
                    18, 131, 1, 18, 132, 1, 18, 133, 1, 18, 134, 1, 18, 135, 1, 18, 136, 1, 18, 538, 1, 18, 137, 1, 18, 138, 1, 18, 139, 1,
18, 539, 1, 18, 140, 1, 18, 540, 1, 18, 541, 1, 18, 542, 1, 18, 141, 1, 18, 142, 1, 18, 143, 1, 18, 543, 1, 18, 144, 1,
18, 544, 1, 18, 545, 1, 18, 546, 1, 18, 145, 1, 18, 547, 1, 18, 548, 1, 18, 549, 1, 18, 550, 1, 18, 551, 1, 18, 552, 1,
18, 720, 1, 18, 15, -1, 18, 16, -1, 18, 17, -1, 18, 332, -1, 18, 18, -1, 18, 333, -1, 18, 334, -1, 18, 335, -1, 18, 19,
-1, 18, 336, -1, 18, 337, -1, 18, 338, -1, 18, 339, -1, 18, 340, -1, 18, 341, -1, 18, 669, -1, 18, 20, -1, 18, 342, -1,
18, 343, -1, 18, 344, -1, 18, 345, -1, 18, 346, -1, 18, 347, -1, 18, 670, -1, 18, 348, -1, 18, 349, -1, 18, 350, -1, 18,
671, -1, 18, 351, -1, 18, 672, -1, 18, 673, -1, 18, 674, -1,
                    19, 15, 1, 19, 332, 3, 19, 333, 3, 19, 334, 3, 19, 336, 3, 19, 337, 3, 19, 339, 3, 19, 669, 5, 19, 342, 3, 19, 343, 3,
19, 345, 3, 19, 670, 5, 19, 348, 3, 19, 671, 5, 19, 672, 5, 19, 673, 5, 19, 131, -2, 19, 132, -2, 19, 134, -2, 19, 538,
-4, 19, 137, -2, 19, 539, -4, 19, 540, -4, 19, 541, -4, 19, 141, -2, 19, 543, -4, 19, 544, -4, 19, 545, -4, 19, 547, -4,
19, 548, -4, 19, 550, -4, 19, 720, -6, 19, 16, 1, 19, 335, 3, 19, 338, 3, 19, 340, 3, 19, 344, 3, 19, 346, 3, 19, 349,
3, 19, 674, 5, 19, 133, -2, 19, 135, -2, 19, 138, -2, 19, 542, -4, 19, 142, -2, 19, 546, -4, 19, 549, -4, 19, 551, -4,
19, 17, 1, 19, 341, 3, 19, 347, 3, 19, 350, 3, 19, 136, -2, 19, 139, -2, 19, 143, -2, 19, 552, -4, 19, 18, 1, 19, 351,
3, 19, 140, -2, 19, 144, -2, 19, 19, 1, 19, 145, -2, 19, 20, 1,
                    20, 131, 1, 20, 538, 6, 20, 539, 6, 20, 540, 6, 20, 543, 6, 20, 544, 6, 20, 547, 6, 20, 720, 15, 20, 332, -3, 20, 333,
-3, 20, 336, -3, 20, 669, -10, 20, 342, -3, 20, 670, -10, 20, 671, -10, 20, 672, -10, 20, 132, 1, 20, 541, 6, 20, 545,
6, 20, 548, 6, 20, 334, -3, 20, 337, -3, 20, 343, -3, 20, 673, -10, 20, 133, 1, 20, 542, 6, 20, 546, 6, 20, 549, 6, 20,
335, -3, 20, 338, -3, 20, 344, -3, 20, 674, -10, 20, 134, 1, 20, 550, 6, 20, 339, -3, 20, 345, -3, 20, 135, 1, 20, 551,
6, 20, 340, -3, 20, 346, -3, 20, 136, 1, 20, 552, 6, 20, 341, -3, 20, 347, -3, 20, 137, 1, 20, 348, -3, 20, 138, 1, 20,
349, -3, 20, 139, 1, 20, 350, -3, 20, 140, 1, 20, 351, -3, 20, 141, 1, 20, 142, 1, 20, 143, 1, 20, 144, 1, 20, 145, 1,
                    21, 332, 1, 21, 669, 10, 21, 670, 10, 21, 671, 10, 21, 538, -4, 21, 539, -4, 21, 543, -4, 21, 720, -20, 21, 333, 1, 21,
672, 10, 21, 540, -4, 21, 544, -4, 21, 334, 1, 21, 673, 10, 21, 541, -4, 21, 545, -4, 21, 335, 1, 21, 674, 10, 21, 542,
-4, 21, 546, -4, 21, 336, 1, 21, 547, -4, 21, 337, 1, 21, 548, -4, 21, 338, 1, 21, 549, -4, 21, 339, 1, 21, 550, -4, 21,
340, 1, 21, 551, -4, 21, 341, 1, 21, 552, -4, 21, 342, 1, 21, 343, 1, 21, 344, 1, 21, 345, 1, 21, 346, 1, 21, 347, 1,
21, 348, 1, 21, 349, 1, 21, 350, 1, 21, 351, 1,
                    22, 538, 1, 22, 720, 15, 22, 669, -5, 22, 670, -5, 22, 539, 1, 22, 671, -5, 22, 540, 1, 22, 672, -5, 22, 541, 1, 22,
673, -5, 22, 542, 1, 22, 674, -5, 22, 543, 1, 22, 544, 1, 22, 545, 1, 22, 546, 1, 22, 547, 1, 22, 548, 1, 22, 549, 1,
22, 550, 1, 22, 551, 1, 22, 552, 1,
                    23, 669, 1, 23, 720, -6, 23, 670, 1, 23, 671, 1, 23, 672, 1, 23, 673, 1, 23, 674, 1,
                    24, 720, 1,
                    25, 146, 1, 25, 147, 1, 25, 148, 1, 25, 149, 1, 25, 150, 1, 25, 151, 1, 25, 553, 1, 25, 152, 1, 25, 153, 1, 25, 154, 1,
25, 554, 1, 25, 155, 1, 25, 555, 1, 25, 556, 1, 25, 557, 1, 25, 156, 1, 25, 157, 1, 25, 158, 1, 25, 558, 1, 25, 159, 1,
25, 559, 1, 25, 560, 1, 25, 561, 1, 25, 160, 1, 25, 562, 1, 25, 563, 1, 25, 564, 1, 25, 565, 1, 25, 566, 1, 25, 567, 1,
25, 721, 1, 25, 21, -1, 25, 22, -1, 25, 23, -1, 25, 352, -1, 25, 24, -1, 25, 353, -1, 25, 354, -1, 25, 355, -1, 25, 25,
-1, 25, 356, -1, 25, 357, -1, 25, 358, -1, 25, 359, -1, 25, 360, -1, 25, 361, -1, 25, 675, -1, 25, 26, -1, 25, 362, -1,
25, 363, -1, 25, 364, -1, 25, 365, -1, 25, 366, -1, 25, 367, -1, 25, 676, -1, 25, 368, -1, 25, 369, -1, 25, 370, -1, 25,
677, -1, 25, 371, -1, 25, 678, -1, 25, 679, -1, 25, 680, -1,
                    26, 21, 1, 26, 352, 3, 26, 353, 3, 26, 354, 3, 26, 356, 3, 26, 357, 3, 26, 359, 3, 26, 675, 5, 26, 362, 3, 26, 363, 3,
26, 365, 3, 26, 676, 5, 26, 368, 3, 26, 677, 5, 26, 678, 5, 26, 679, 5, 26, 146, -2, 26, 147, -2, 26, 149, -2, 26, 553,
-4, 26, 152, -2, 26, 554, -4, 26, 555, -4, 26, 556, -4, 26, 156, -2, 26, 558, -4, 26, 559, -4, 26, 560, -4, 26, 562, -4,
26, 563, -4, 26, 565, -4, 26, 721, -6, 26, 22, 1, 26, 355, 3, 26, 358, 3, 26, 360, 3, 26, 364, 3, 26, 366, 3, 26, 369,
3, 26, 680, 5, 26, 148, -2, 26, 150, -2, 26, 153, -2, 26, 557, -4, 26, 157, -2, 26, 561, -4, 26, 564, -4, 26, 566, -4,
26, 23, 1, 26, 361, 3, 26, 367, 3, 26, 370, 3, 26, 151, -2, 26, 154, -2, 26, 158, -2, 26, 567, -4, 26, 24, 1, 26, 371,
3, 26, 155, -2, 26, 159, -2, 26, 25, 1, 26, 160, -2, 26, 26, 1,
                    27, 146, 1, 27, 553, 6, 27, 554, 6, 27, 555, 6, 27, 558, 6, 27, 559, 6, 27, 562, 6, 27, 721, 15, 27, 352, -3, 27, 353,
-3, 27, 356, -3, 27, 675, -10, 27, 362, -3, 27, 676, -10, 27, 677, -10, 27, 678, -10, 27, 147, 1, 27, 556, 6, 27, 560,
6, 27, 563, 6, 27, 354, -3, 27, 357, -3, 27, 363, -3, 27, 679, -10, 27, 148, 1, 27, 557, 6, 27, 561, 6, 27, 564, 6, 27,
355, -3, 27, 358, -3, 27, 364, -3, 27, 680, -10, 27, 149, 1, 27, 565, 6, 27, 359, -3, 27, 365, -3, 27, 150, 1, 27, 566,
6, 27, 360, -3, 27, 366, -3, 27, 151, 1, 27, 567, 6, 27, 361, -3, 27, 367, -3, 27, 152, 1, 27, 368, -3, 27, 153, 1, 27,
369, -3, 27, 154, 1, 27, 370, -3, 27, 155, 1, 27, 371, -3, 27, 156, 1, 27, 157, 1, 27, 158, 1, 27, 159, 1, 27, 160, 1,
                    28, 352, 1, 28, 675, 10, 28, 676, 10, 28, 677, 10, 28, 553, -4, 28, 554, -4, 28, 558, -4, 28, 721, -20, 28, 353, 1, 28,
678, 10, 28, 555, -4, 28, 559, -4, 28, 354, 1, 28, 679, 10, 28, 556, -4, 28, 560, -4, 28, 355, 1, 28, 680, 10, 28, 557,
-4, 28, 561, -4, 28, 356, 1, 28, 562, -4, 28, 357, 1, 28, 563, -4, 28, 358, 1, 28, 564, -4, 28, 359, 1, 28, 565, -4, 28,
360, 1, 28, 566, -4, 28, 361, 1, 28, 567, -4, 28, 362, 1, 28, 363, 1, 28, 364, 1, 28, 365, 1, 28, 366, 1, 28, 367, 1,
28, 368, 1, 28, 369, 1, 28, 370, 1, 28, 371, 1,
                    29, 553, 1, 29, 721, 15, 29, 675, -5, 29, 676, -5, 29, 554, 1, 29, 677, -5, 29, 555, 1, 29, 678, -5, 29, 556, 1, 29,
679, -5, 29, 557, 1, 29, 680, -5, 29, 558, 1, 29, 559, 1, 29, 560, 1, 29, 561, 1, 29, 562, 1, 29, 563, 1, 29, 564, 1,
29, 565, 1, 29, 566, 1, 29, 567, 1,
                    30, 675, 1, 30, 721, -6, 30, 676, 1, 30, 677, 1, 30, 678, 1, 30, 679, 1, 30, 680, 1,
                    31, 721, 1,
                    32, 161, 1, 32, 162, 1, 32, 163, 1, 32, 164, 1, 32, 165, 1, 32, 166, 1, 32, 568, 1, 32, 167, 1, 32, 168, 1, 32, 169, 1,
32, 569, 1, 32, 170, 1, 32, 570, 1, 32, 571, 1, 32, 572, 1, 32, 171, 1, 32, 172, 1, 32, 173, 1, 32, 573, 1, 32, 174, 1,
32, 574, 1, 32, 575, 1, 32, 576, 1, 32, 175, 1, 32, 577, 1, 32, 578, 1, 32, 579, 1, 32, 580, 1, 32, 581, 1, 32, 582, 1,
32, 722, 1, 32, 27, -1, 32, 28, -1, 32, 29, -1, 32, 372, -1, 32, 30, -1, 32, 373, -1, 32, 374, -1, 32, 375, -1, 32, 31,
-1, 32, 376, -1, 32, 377, -1, 32, 378, -1, 32, 379, -1, 32, 380, -1, 32, 381, -1, 32, 681, -1, 32, 32, -1, 32, 382, -1,
32, 383, -1, 32, 384, -1, 32, 385, -1, 32, 386, -1, 32, 387, -1, 32, 682, -1, 32, 388, -1, 32, 389, -1, 32, 390, -1, 32,
683, -1, 32, 391, -1, 32, 684, -1, 32, 685, -1, 32, 686, -1,
                    33, 27, 1, 33, 372, 3, 33, 373, 3, 33, 374, 3, 33, 376, 3, 33, 377, 3, 33, 379, 3, 33, 681, 5, 33, 382, 3, 33, 383, 3,
33, 385, 3, 33, 682, 5, 33, 388, 3, 33, 683, 5, 33, 684, 5, 33, 685, 5, 33, 161, -2, 33, 162, -2, 33, 164, -2, 33, 568,
-4, 33, 167, -2, 33, 569, -4, 33, 570, -4, 33, 571, -4, 33, 171, -2, 33, 573, -4, 33, 574, -4, 33, 575, -4, 33, 577, -4,
33, 578, -4, 33, 580, -4, 33, 722, -6, 33, 28, 1, 33, 375, 3, 33, 378, 3, 33, 380, 3, 33, 384, 3, 33, 386, 3, 33, 389,
3, 33, 686, 5, 33, 163, -2, 33, 165, -2, 33, 168, -2, 33, 572, -4, 33, 172, -2, 33, 576, -4, 33, 579, -4, 33, 581, -4,
33, 29, 1, 33, 381, 3, 33, 387, 3, 33, 390, 3, 33, 166, -2, 33, 169, -2, 33, 173, -2, 33, 582, -4, 33, 30, 1, 33, 391,
3, 33, 170, -2, 33, 174, -2, 33, 31, 1, 33, 175, -2, 33, 32, 1,
                    34, 161, 1, 34, 568, 6, 34, 569, 6, 34, 570, 6, 34, 573, 6, 34, 574, 6, 34, 577, 6, 34, 722, 15, 34, 372, -3, 34, 373,
-3, 34, 376, -3, 34, 681, -10, 34, 382, -3, 34, 682, -10, 34, 683, -10, 34, 684, -10, 34, 162, 1, 34, 571, 6, 34, 575,
6, 34, 578, 6, 34, 374, -3, 34, 377, -3, 34, 383, -3, 34, 685, -10, 34, 163, 1, 34, 572, 6, 34, 576, 6, 34, 579, 6, 34,
375, -3, 34, 378, -3, 34, 384, -3, 34, 686, -10, 34, 164, 1, 34, 580, 6, 34, 379, -3, 34, 385, -3, 34, 165, 1, 34, 581,
6, 34, 380, -3, 34, 386, -3, 34, 166, 1, 34, 582, 6, 34, 381, -3, 34, 387, -3, 34, 167, 1, 34, 388, -3, 34, 168, 1, 34,
389, -3, 34, 169, 1, 34, 390, -3, 34, 170, 1, 34, 391, -3, 34, 171, 1, 34, 172, 1, 34, 173, 1, 34, 174, 1, 34, 175, 1,
                    35, 372, 1, 35, 681, 10, 35, 682, 10, 35, 683, 10, 35, 568, -4, 35, 569, -4, 35, 573, -4, 35, 722, -20, 35, 373, 1, 35,
684, 10, 35, 570, -4, 35, 574, -4, 35, 374, 1, 35, 685, 10, 35, 571, -4, 35, 575, -4, 35, 375, 1, 35, 686, 10, 35, 572,
-4, 35, 576, -4, 35, 376, 1, 35, 577, -4, 35, 377, 1, 35, 578, -4, 35, 378, 1, 35, 579, -4, 35, 379, 1, 35, 580, -4, 35,
380, 1, 35, 581, -4, 35, 381, 1, 35, 582, -4, 35, 382, 1, 35, 383, 1, 35, 384, 1, 35, 385, 1, 35, 386, 1, 35, 387, 1,
35, 388, 1, 35, 389, 1, 35, 390, 1, 35, 391, 1,
                    36, 568, 1, 36, 722, 15, 36, 681, -5, 36, 682, -5, 36, 569, 1, 36, 683, -5, 36, 570, 1, 36, 684, -5, 36, 571, 1, 36,
685, -5, 36, 572, 1, 36, 686, -5, 36, 573, 1, 36, 574, 1, 36, 575, 1, 36, 576, 1, 36, 577, 1, 36, 578, 1, 36, 579, 1,
36, 580, 1, 36, 581, 1, 36, 582, 1,
                    37, 681, 1, 37, 722, -6, 37, 682, 1, 37, 683, 1, 37, 684, 1, 37, 685, 1, 37, 686, 1,
                    38, 722, 1,
                    39, 33, 1, 39, 392, 3, 39, 393, 3, 39, 394, 3, 39, 176, -2, 39, 177, -2, 39, 178, -2, 39, 583, -4, 39, 34, 1, 39, 395,
3, 39, 179, -2, 39, 180, -2, 39, 35, 1, 39, 181, -2, 39, 36, 1,
                    40, 176, 1, 40, 583, 6, 40, 392, -3, 40, 393, -3, 40, 177, 1, 40, 394, -3, 40, 179, 1, 40, 395, -3, 40, 178, 1, 40, 180,
1, 40, 181, 1,
                    41, 392, 1, 41, 583, -4, 41, 393, 1, 41, 394, 1, 41, 395, 1,
                    42, 583, 1,
                    43, 182, 1, 43, 183, 1, 43, 184, 1, 43, 37, -1, 43, 38, -1, 43, 39, -1, 43, 396, -1,
                    44, 37, 1, 44, 396, 3, 44, 182, -2, 44, 183, -2, 44, 38, 1, 44, 184, -2, 44, 39, 1,
                    45, 182, 1, 45, 396, -3, 45, 183, 1, 45, 184, 1,
                    46, 396, 1,
                    47, 185, 1, 47, 186, 1, 47, 187, 1, 47, 40, -1, 47, 41, -1, 47, 42, -1, 47, 397, -1,
                    48, 40, 1, 48, 397, 3, 48, 185, -2, 48, 186, -2, 48, 41, 1, 48, 187, -2, 48, 42, 1,
                    49, 185, 1, 49, 397, -3, 49, 186, 1, 49, 187, 1,
                    50, 397, 1,
                    51, 188, 1, 51, 189, 1, 51, 190, 1, 51, 191, 1, 51, 192, 1, 51, 193, 1, 51, 584, 1, 51, 194, 1, 51, 195, 1, 51, 196, 1,
51, 585, 1, 51, 197, 1, 51, 586, 1, 51, 587, 1, 51, 588, 1, 51, 198, 1, 51, 199, 1, 51, 200, 1, 51, 589, 1, 51, 201, 1,
51, 590, 1, 51, 591, 1, 51, 592, 1, 51, 202, 1, 51, 593, 1, 51, 594, 1, 51, 595, 1, 51, 596, 1, 51, 597, 1, 51, 598, 1,
51, 723, 1, 51, 203, 1, 51, 204, 1, 51, 205, 1, 51, 599, 1, 51, 206, 1, 51, 600, 1, 51, 601, 1, 51, 602, 1, 51, 207, 1,
51, 603, 1, 51, 604, 1, 51, 605, 1, 51, 606, 1, 51, 607, 1, 51, 608, 1, 51, 724, 1, 51, 208, 1, 51, 609, 1, 51, 610, 1,
51, 611, 1, 51, 612, 1, 51, 613, 1, 51, 614, 1, 51, 725, 1, 51, 615, 1, 51, 616, 1, 51, 617, 1, 51, 726, 1, 51, 618, 1,
51, 727, 1, 51, 728, 1, 51, 729, 1, 51, 43, -1, 51, 44, -1, 51, 45, -1, 51, 398, -1, 51, 46, -1, 51, 399, -1, 51, 400,
-1, 51, 401, -1, 51, 47, -1, 51, 402, -1, 51, 403, -1, 51, 404, -1, 51, 405, -1, 51, 406, -1, 51, 407, -1, 51, 687, -1,
51, 48, -1, 51, 408, -1, 51, 409, -1, 51, 410, -1, 51, 411, -1, 51, 412, -1, 51, 413, -1, 51, 688, -1, 51, 414, -1, 51,
415, -1, 51, 416, -1, 51, 689, -1, 51, 417, -1, 51, 690, -1, 51, 691, -1, 51, 692, -1, 51, 49, -1, 51, 418, -1, 51, 419,
-1, 51, 420, -1, 51, 421, -1, 51, 422, -1, 51, 423, -1, 51, 693, -1, 51, 424, -1, 51, 425, -1, 51, 426, -1, 51, 694, -1,
51, 427, -1, 51, 695, -1, 51, 696, -1, 51, 697, -1, 51, 428, -1, 51, 429, -1, 51, 430, -1, 51, 698, -1, 51, 431, -1, 51,
699, -1, 51, 700, -1, 51, 701, -1, 51, 432, -1, 51, 702, -1, 51, 703, -1, 51, 704, -1, 51, 705, -1, 51, 706, -1, 51,
707, -1, 51, 731, -1,
                    52, 43, 1, 52, 398, 3, 52, 399, 3, 52, 400, 3, 52, 402, 3, 52, 403, 3, 52, 405, 3, 52, 687, 5, 52, 408, 3, 52, 409, 3,
52, 411, 3, 52, 688, 5, 52, 414, 3, 52, 689, 5, 52, 690, 5, 52, 691, 5, 52, 418, 3, 52, 419, 3, 52, 421, 3, 52, 693, 5,
52, 424, 3, 52, 694, 5, 52, 695, 5, 52, 696, 5, 52, 428, 3, 52, 698, 5, 52, 699, 5, 52, 700, 5, 52, 702, 5, 52, 703, 5,
52, 705, 5, 52, 731, 7, 52, 188, -2, 52, 189, -2, 52, 191, -2, 52, 584, -4, 52, 194, -2, 52, 585, -4, 52, 586, -4, 52,
587, -4, 52, 198, -2, 52, 589, -4, 52, 590, -4, 52, 591, -4, 52, 593, -4, 52, 594, -4, 52, 596, -4, 52, 723, -6, 52,
203, -2, 52, 599, -4, 52, 600, -4, 52, 601, -4, 52, 603, -4, 52, 604, -4, 52, 606, -4, 52, 724, -6, 52, 609, -4, 52,
610, -4, 52, 612, -4, 52, 725, -6, 52, 615, -4, 52, 726, -6, 52, 727, -6, 52, 728, -6, 52, 44, 1, 52, 401, 3, 52, 404,
3, 52, 406, 3, 52, 410, 3, 52, 412, 3, 52, 415, 3, 52, 692, 5, 52, 420, 3, 52, 422, 3, 52, 425, 3, 52, 697, 5, 52, 429,
3, 52, 701, 5, 52, 704, 5, 52, 706, 5, 52, 190, -2, 52, 192, -2, 52, 195, -2, 52, 588, -4, 52, 199, -2, 52, 592, -4, 52,
595, -4, 52, 597, -4, 52, 204, -2, 52, 602, -4, 52, 605, -4, 52, 607, -4, 52, 611, -4, 52, 613, -4, 52, 616, -4, 52,
729, -6, 52, 45, 1, 52, 407, 3, 52, 413, 3, 52, 416, 3, 52, 423, 3, 52, 426, 3, 52, 430, 3, 52, 707, 5, 52, 193, -2, 52,
196, -2, 52, 200, -2, 52, 598, -4, 52, 205, -2, 52, 608, -4, 52, 614, -4, 52, 617, -4, 52, 46, 1, 52, 417, 3, 52, 427,
3, 52, 431, 3, 52, 197, -2, 52, 201, -2, 52, 206, -2, 52, 618, -4, 52, 47, 1, 52, 432, 3, 52, 202, -2, 52, 207, -2, 52,
48, 1, 52, 208, -2, 52, 49, 1,
                    53, 188, 1, 53, 584, 6, 53, 585, 6, 53, 586, 6, 53, 589, 6, 53, 590, 6, 53, 593, 6, 53, 723, 15, 53, 599, 6, 53, 600, 6,
53, 603, 6, 53, 724, 15, 53, 609, 6, 53, 725, 15, 53, 726, 15, 53, 727, 15, 53, 398, -3, 53, 399, -3, 53, 402, -3, 53,
687, -10, 53, 408, -3, 53, 688, -10, 53, 689, -10, 53, 690, -10, 53, 418, -3, 53, 693, -10, 53, 694, -10, 53, 695, -10,
53, 698, -10, 53, 699, -10, 53, 702, -10, 53, 731, -21, 53, 189, 1, 53, 587, 6, 53, 591, 6, 53, 594, 6, 53, 601, 6, 53,
604, 6, 53, 610, 6, 53, 728, 15, 53, 400, -3, 53, 403, -3, 53, 409, -3, 53, 691, -10, 53, 419, -3, 53, 696, -10, 53,
700, -10, 53, 703, -10, 53, 190, 1, 53, 588, 6, 53, 592, 6, 53, 595, 6, 53, 602, 6, 53, 605, 6, 53, 611, 6, 53, 729, 15,
53, 401, -3, 53, 404, -3, 53, 410, -3, 53, 692, -10, 53, 420, -3, 53, 697, -10, 53, 701, -10, 53, 704, -10, 53, 191, 1,
53, 596, 6, 53, 606, 6, 53, 612, 6, 53, 405, -3, 53, 411, -3, 53, 421, -3, 53, 705, -10, 53, 192, 1, 53, 597, 6, 53,
607, 6, 53, 613, 6, 53, 406, -3, 53, 412, -3, 53, 422, -3, 53, 706, -10, 53, 193, 1, 53, 598, 6, 53, 608, 6, 53, 614, 6,
53, 407, -3, 53, 413, -3, 53, 423, -3, 53, 707, -10, 53, 194, 1, 53, 615, 6, 53, 414, -3, 53, 424, -3, 53, 195, 1, 53,
616, 6, 53, 415, -3, 53, 425, -3, 53, 196, 1, 53, 617, 6, 53, 416, -3, 53, 426, -3, 53, 197, 1, 53, 618, 6, 53, 417, -3,
53, 427, -3, 53, 198, 1, 53, 428, -3, 53, 199, 1, 53, 429, -3, 53, 200, 1, 53, 430, -3, 53, 201, 1, 53, 431, -3, 53,
202, 1, 53, 432, -3, 53, 203, 1, 53, 204, 1, 53, 205, 1, 53, 206, 1, 53, 207, 1, 53, 208, 1,
                    54, 398, 1, 54, 687, 10, 54, 688, 10, 54, 689, 10, 54, 693, 10, 54, 694, 10, 54, 698, 10, 54, 731, 35, 54, 584, -4, 54,
585, -4, 54, 589, -4, 54, 723, -20, 54, 599, -4, 54, 724, -20, 54, 725, -20, 54, 726, -20, 54, 399, 1, 54, 690, 10, 54,
695, 10, 54, 699, 10, 54, 586, -4, 54, 590, -4, 54, 600, -4, 54, 727, -20, 54, 400, 1, 54, 691, 10, 54, 696, 10, 54,
700, 10, 54, 587, -4, 54, 591, -4, 54, 601, -4, 54, 728, -20, 54, 401, 1, 54, 692, 10, 54, 697, 10, 54, 701, 10, 54,
588, -4, 54, 592, -4, 54, 602, -4, 54, 729, -20, 54, 402, 1, 54, 702, 10, 54, 593, -4, 54, 603, -4, 54, 403, 1, 54, 703,
10, 54, 594, -4, 54, 604, -4, 54, 404, 1, 54, 704, 10, 54, 595, -4, 54, 605, -4, 54, 405, 1, 54, 705, 10, 54, 596, -4,
54, 606, -4, 54, 406, 1, 54, 706, 10, 54, 597, -4, 54, 607, -4, 54, 407, 1, 54, 707, 10, 54, 598, -4, 54, 608, -4, 54,
408, 1, 54, 609, -4, 54, 409, 1, 54, 610, -4, 54, 410, 1, 54, 611, -4, 54, 411, 1, 54, 612, -4, 54, 412, 1, 54, 613, -4,
54, 413, 1, 54, 614, -4, 54, 414, 1, 54, 615, -4, 54, 415, 1, 54, 616, -4, 54, 416, 1, 54, 617, -4, 54, 417, 1, 54, 618,
-4, 54, 418, 1, 54, 419, 1, 54, 420, 1, 54, 421, 1, 54, 422, 1, 54, 423, 1, 54, 424, 1, 54, 425, 1, 54, 426, 1, 54, 427,
1, 54, 428, 1, 54, 429, 1, 54, 430, 1, 54, 431, 1, 54, 432, 1,
                    55, 584, 1, 55, 723, 15, 55, 724, 15, 55, 725, 15, 55, 687, -5, 55, 688, -5, 55, 693, -5, 55, 731, -35, 55, 585, 1, 55,
726, 15, 55, 689, -5, 55, 694, -5, 55, 586, 1, 55, 727, 15, 55, 690, -5, 55, 695, -5, 55, 587, 1, 55, 728, 15, 55, 691,
-5, 55, 696, -5, 55, 588, 1, 55, 729, 15, 55, 692, -5, 55, 697, -5, 55, 589, 1, 55, 698, -5, 55, 590, 1, 55, 699, -5,
55, 591, 1, 55, 700, -5, 55, 592, 1, 55, 701, -5, 55, 593, 1, 55, 702, -5, 55, 594, 1, 55, 703, -5, 55, 595, 1, 55, 704,
-5, 55, 596, 1, 55, 705, -5, 55, 597, 1, 55, 706, -5, 55, 598, 1, 55, 707, -5, 55, 599, 1, 55, 600, 1, 55, 601, 1, 55,
602, 1, 55, 603, 1, 55, 604, 1, 55, 605, 1, 55, 606, 1, 55, 607, 1, 55, 608, 1, 55, 609, 1, 55, 610, 1, 55, 611, 1, 55,
612, 1, 55, 613, 1, 55, 614, 1, 55, 615, 1, 55, 616, 1, 55, 617, 1, 55, 618, 1,
                    56, 687, 1, 56, 731, 21, 56, 723, -6, 56, 724, -6, 56, 688, 1, 56, 725, -6, 56, 689, 1, 56, 726, -6, 56, 690, 1, 56,
727, -6, 56, 691, 1, 56, 728, -6, 56, 692, 1, 56, 729, -6, 56, 693, 1, 56, 694, 1, 56, 695, 1, 56, 696, 1, 56, 697, 1,
56, 698, 1, 56, 699, 1, 56, 700, 1, 56, 701, 1, 56, 702, 1, 56, 703, 1, 56, 704, 1, 56, 705, 1, 56, 706, 1, 56, 707, 1,
                    57, 723, 1, 57, 731, -7, 57, 724, 1, 57, 725, 1, 57, 726, 1, 57, 727, 1, 57, 728, 1, 57, 729, 1,
                    58, 731, 1,
                    
NULL), ncol=3, byrow=TRUE); # close ind_mema creation
measmat[[1]][ind_mema[,1:2,drop=FALSE]]=ind_mema[,3]
memaone[[1]]=c(1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1,
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0,
1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
        
pwe=ipwe=ip2ipwe=pool_factor=ijpwef=dp_ones=meas2sum=dpw_dpf=ipf_in_ppw=vector("list", nb_exp)
mets_in_res=vector("list", nb_exp)
for (iexp in seq_len(nb_exp)) {
   names(memaone[[iexp]])=nm_measmat[[iexp]]

   # prepare weights of label data for pooled metabs
   # prepare ipwe and ip2ipwe such that pwe[ipwe]=pool[ip2ipwe]
   # gives a good base for weight sum and normalization
   pwe[[iexp]]=double(nb_measmat[[iexp]])+1.
   mets_in_res[[iexp]]=sapply(nm_measmat[[iexp]], function(m) strsplit(m, ":")[[1L]][2L])
   for (po in names(ipooled[[iexp]])) {
      if (po == "ishort") next
      nm_sum=strsplit(po, ":")[[1L]][2L]
      mets=trimws(strsplit(nm_sum, "\\+")[[1L]])
      irpo=ipooled[[iexp]][[po]]
      ipwe[[iexp]]=c(ipwe[[iexp]], irpo) # where weighting is
      i=pmatch(mets, names(nm_poolf))
      if (any(!is.na(i))) {
         for (ir in i) {
            if (is.na(ir)) next
            ijpwef[[iexp]]=rbind(ijpwef[[iexp]], cbind(irpo, ir)) # where free pools matter
         }
      }
      ip2ipwe[[iexp]]=c(ip2ipwe[[iexp]], pmatch(mets, names(nm_poolall)))
      mets_in_res[[iexp]][irpo]=mets
   }
   # order ijpwef for sparse matrix ordering
   if (!is.null(ijpwef[[iexp]])) {
      o=order(ijpwef[[iexp]][,2L], ijpwef[[iexp]][,1L])
      ijpwef[[iexp]]=ijpwef[[iexp]][o,,drop=FALSE]
   }
   pool_factor[[iexp]]=as.factor(nm_measmat[[iexp]])
   # free pool in principal pool weight
   ipf_in_ppw[[iexp]]=apply(outer(mets_in_res[[iexp]], names(nm_poolf), "=="), 1, function(v) if(length(w <-which(v))) w else NA)
   ipf_in_ppw[[iexp]][is.na(ipf_in_ppw[[iexp]])]=0L
   dp_ones[[iexp]]=matrix(0., nb_measmat[[iexp]], nb_poolf)
   dp_ones[[iexp]][cbind(ipwe[[iexp]], ipf_in_ppw[[iexp]][ipwe[[iexp]]])]=1.
   
   # matrix for summing weighted measurements
   meas2sum[[iexp]]=simple_triplet_zero_matrix(length(ipooled[[iexp]]$ishort), nb_measmat[[iexp]])
   meas2sum[[iexp]][cbind(pmatch(nm_measmat[[iexp]], nm_measmat[[iexp]][ipooled[[iexp]]$ishort], dup=TRUE),       seq_len(nb_measmat[[iexp]]))]=1.
   dimnames(meas2sum[[iexp]])=list(nm_meas[[iexp]], nm_measmat[[iexp]])
   
   # dpw_dpf - matrix for derivation of pool weights by free pools
   if (nb_poolf > 0L && length(ijpwef[[iexp]]) > 0) {
      # indeed, we'll have to do weight derivation by free pools
      dpw_dpf[[iexp]]=simple_triplet_zero_matrix(nb_measmat[[iexp]], nb_poolf)
      dpw_dpf[[iexp]][ijpwef[[iexp]]]=1.
   }
}


# prepare flux measurements
nm_fmn=nm_net[c("out_Ac")]
nm_list$fmn=nm_fmn
nb_fmn=length(nm_fmn)
nb_f$nb_fmn=nb_fmn

# measured values
fmn=c(0.497)

# SD for flux measurements
fmndev=c(0.04)
if (nb_fmn)
   names(fmndev)=names(fmn)=nm_fmn

# indices for measured fluxes
# fallnx[ifmn]=>fmn, here fallnx is complete net|xch flux vector
# combining unknown (dependent), free, constrainded and groth fluxes
ifmn=match(nm_fmn, nm_fallnx)
    
if (TIMEIT) {
   cat("ineq    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
# prepare mi matrix and li vector
# such that mi*fallnx>=li corresponds
# to the inequalities given in ftbl file
nb_ineq=6
mi=matrix(0., nrow=nb_ineq, ncol=nb_fallnx)
li=numeric(nb_ineq)
nm_i=c(c("n:0.0<=akgdh", "n:0.0<=edd", "n:0.0<=gnd", "n:0.0<=idh", "n:0.0<=ppc", "n:0.0<=zwf"), c())
dimnames(mi)=list(nm_i, nm_fallnx)
    mi[1, nm_net[c("akgdh")]]=c(1.0)
li[1]=0
mi[2, nm_net[c("edd")]]=c(1.0)
li[2]=0
mi[3, nm_net[c("gnd")]]=c(1.0)
li[3]=0
mi[4, nm_net[c("idh")]]=c(1.0)
li[4]=0
mi[5, nm_net[c("ppc")]]=c(1.0)
li[5]=0
mi[6, nm_net[c("zwf")]]=c(1.0)
li[6]=0

# add standard limits on [df].xch [0;cupx]
nb_tmp=nrow(mi)
nb_fx=nb_flx+nb_ffx
if (nb_fx) {
   mi=rbind(mi, matrix(0, nrow=2*nb_fx, ncol=nb_fallnx))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, ">=0", sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, ">=0", sep=""))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, "<=", cupx, sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, "<=", cupx, sep=""))
   li=c(li, rep(0, nb_fx), rep(-cupx, nb_fx))
   mi[nb_tmp+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(1., nb_fx)
   mi[nb_tmp+nb_fx+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(-1., nb_fx)
}

nm_inout=grep("^[^c]\\.", nm_net[c("bs_glc6P", "bs_fru6P", "bs_pga", "bs_DHAP", "bs_pyr", "bs_e4p", "bs_rib5P", "bs_pep", "bs_accoa", "bs_akg", "bs_oaa",
"out_co2", "out_Ac", "Cit_gr", "FruBP_gr", "Mal_gr", "PEP_gr", "PGA_gr", "Suc_gr", "Fru6P_gr", "Glc6P_gr", "Gnt6P_gr",
"Rib5P_gr", "Rub5P_gr", "Xul5P_gr", "Glucupt_1", "Glucupt_U", "CO2upt")], v=TRUE) # strip out constrained fluxes
nb_inout=length(nm_inout)
if (nb_inout > 0) {
   # add cinout low limits on inout net fluxes
   nb_tmp=nrow(mi)
   # explicit inequalities take precedence over generic ones
   # so eliminate inout fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_inout, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_inout[-i]
   } else {
      nm_tmp=nm_inout
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste("inout ", nm_tmp, ">=", cinout, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(cinout, len_tmp))
   }
}
if (clownr!=0.) {
   # add low limits on net >= clownr for not reversible reactions
   nb_tmp=nrow(mi)
   nm_tmp=nm_net[c("Glucupt_1", "Glucupt_U", "bs_glc6P", "bs_fru6P", "bs_pga", "bs_DHAP", "bs_pyr", "bs_e4p", "bs_rib5P", "bs_pep",
"bs_accoa", "bs_akg", "bs_oaa", "out_co2", "out_Ac", "Cit_gr", "FruBP_gr", "Mal_gr", "PEP_gr", "PGA_gr", "Suc_gr",
"Fru6P_gr", "Glc6P_gr", "Gnt6P_gr", "Rib5P_gr", "Rub5P_gr", "Xul5P_gr", "CO2upt", "Glucupt", "zwf", "gnd", "edd",
"citsynth", "idh", "akgdh")]
   # explicit inequalities take precedence over generic ones
   # so eliminate notrev fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   # search for inout too
   nm_itmp=paste("inout ", nm_tmp, ">=", sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i, fix=TRUE)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }

   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, ">=", clownr, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(clownr, len_tmp))
   }
}
nb_fn=nb_fln+nb_ffn
if (cupn != 0 && nb_fn > 0) {
   # add absolute upper limits on -cupn <= [df].net <= cupn for net fluxes
   # explicit inequalities take precedence over generic ones
   # so eliminate net fluxes which are already in inequalities
   ## proceed n:smth>=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+>=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, "<=", cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(-1., len_tmp)
   }
   ## proceed n:smth<=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, ">=", -cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(1., len_tmp)
   }
}
#browser()
nb_ineq=NROW(li);

dimnames(mi)=list(nm_i, nm_fallnx)
names(li)=nm_i
# prepare ui matrix and ci vector for optimisation
# ui%*%param-ci>=0
# it is composed of explicite inequalities from ftbl
# and permanent inequalities 0<=xch<=0.999 and scale>=0

# constraints such that ui%*%param-ci>=0
# first flux part
ui=mi%*%(md%*%invAfl%stm%p2bfl+mf)
mic=(md%*%invAfl%*%(c2bfl%stm%fc+cnst2bfl) + mc%*%fc)
ci=as.numeric(li-mi%*%mic)

# finaly, metab part
uip=matrix(0., 0, ncol=nb_poolf)
colnames(uip)=nm_poolf
cip=c()
# ind: irow, metab, coef, rhs, name
uip_ind=c(
    
)
if (length(uip_ind) > 0) {
   uip_ind=matrix(uip_ind, byrow=TRUE, ncol=5L)
} else {
   uip_ind=matrix(0, 0L, 5L)
}
colnames(uip_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(uip_ind) > 0) {
   # rhs are summed up for the same irow by aggregate()
   irow=as.integer(uip_ind[,"irow"])
   cip=aggregate(as.double(uip_ind[,"rhs"]), by=list(irow), sum)[,"x"]
   for (i in seq_len(nrow(uip_ind))) {
      row=uip_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      uip[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(uip) > 0) {
      rownames(uip)=paste("m:", uip_ind[pmatch(seq_len(nrow(uip)), irow),"name"], sep="")
   }
}
names(cip)=rownames(uip)

#browser() # before null inequality removing
# remove all zero rows in ui (constrained fluxes with fixed values)
# find zero indexes
#print(dim(ui))
if (ncol(ui)) {
   zi=apply(ui,1,function(v){return(max(abs(v))<=1.e-14)})
} else {
   # remove all flux inequalities as there is no free fluxe
   zi=rep(TRUE, nrow(ui))
}

if (!all(ci[zi]<=tol)) {
   cat("The following constant inequalities are not satisfied:\n", file=fclog)
   cat(nm_i[zi][ci[zi]>tol], sep="\n", file=fclog)
   cat("They are simply ignored.\n", file=fclog)
   #stop_mes("", file=fcerr)
}
ui=ui[!zi,,drop=FALSE]
ci=ci[!zi]
nm_i=nm_i[!zi]

# complete ui by zero columns corresponding to scale params
if (nb_sc_tot) {
   ui=cbind(as.matrix(ui), matrix(0., NROW(ui), nb_sc_tot))
   # complete ui by scales >=0
   ui=rbind(ui, cbind(matrix(0, nb_sc_tot, nb_ff), diag(1, nb_sc_tot)))
   ci=c(ci,rep(0., nb_sc_tot))
   nm_i=c(nm_i, paste(nm_par[nb_ff+seq_len(nb_sc_tot)], ">=0", sep=""))
   rownames(ui)=nm_i
   names(ci)=nm_i
}

# remove redundant inequalities
#browser()
nb_i=nrow(ui)
ired=c()
if (nb_i > 1L) {
   for (i in 1L:(nb_i-1L)) {
      nmref=nm_i[i]
      for (j in setdiff((i+1L):nb_i, ired)) {
         if (all(ui[j,]==ui[i,]) && ci[i]==ci[j]) {
            # redundancy
            cat("inequality '", nm_i[j], "' redundant with '", nmref, "' is removed.
", sep="", file=fclog)
            ired=c(ired, j)
         }
      }
   }
}
if (!is.null(ired)) {
   # remove all ired inequalities
   ui=ui[-ired,,drop=FALSE]
   ci=ci[-ired]
   nm_i=nm_i[-ired]
}

# metabolite equalities
ep=matrix(0., 0, ncol=nb_poolf)
cp=c()
colnames(ep)=nm_poolf
# ind: irow, metab, coef, rhs, name
ep_ind=c(
    
)
if (length(ep_ind) > 0) {
   ep_ind=matrix(ep_ind, byrow=TRUE, ncol=5L)
} else {
   ep_ind=matrix(0, 0L, 5L)
}
colnames(ep_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(ep_ind) > 0) {
   # rhs are summed up for the same irow by aggregate
   irow=as.integer(ep_ind[,"irow"])
   cp=aggregate(as.double(ep_ind[,"rhs"]), by=list(irow))[,"x"]
   for (i in seq_len(nrow(ep_ind))) {
      row=ep_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      ep[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(ep) > 0) {
      rownames(ep)=paste("m:", ep_ind[pmatch(seq_len(nrow(ep)), irow),"name"], sep="")
   }
}
ep=as.matrix(ep)
names(cp)=rownames(ep)

nb_sys=list(
   reactions=list(
      reversible=18,
      non_reversible=35
   ),
   fluxes=list(
      free=15,
      dependent=26,
      constrained=43
   ),
   metabolites=list(
      input=3,
      output=25,
      intra=11
   ),
   measurements=list(
      flux=1,
      mass=54,
      peak=0,
      label=4,
      metab=10
   ),
   equations=list(
      equalities=3,
      inequalities=6
   ),
   label_variables=list(
      full=c(0,0,0,0,0,0,0),
      reduced_cumomers=c(99,192,216,149,61,13,1)
   ),
   parallel_experiments=1
)
if (sum(nb_sys$label_variables$full)==0) {
   nb_sys$label_variables$full=NULL
}
if (emu) {
   x=nb_sys$label_variables$reduced_cumomers
   nb_sys$label_variables$reduced_cumomers=NULL
   nb_sys$label_variables$emu=paste(x, "*", seq_len(length(x)), "=", x*seq_len(length(x)))
}
    
#browser()

# extend param vector by free pools
if (nb_poolf > 0) {
   param=c(param, poolf)
   nm_par=c(nm_par, nm_poolf)
   nb_param=length(param)
}
nm_list$par=nm_par

#browser()
if (nb_poolf > 0) {
   # extend inequalities ui, ci by uip, cip
   nb_row=nrow(ui)
   nb_col=ncol(ui)
   ui=cbind(ui, matrix (0., nrow=nb_row, ncol=nb_poolf)) # add 0-columns
   ui=rbind(ui, cbind(matrix(0., nrow(uip), ncol=nb_col), uip))
   ci=c(ci, cip)
   
   # extend inequalities ui, ci by cupp>= poolf >= clowp
   # but exclude metabolites that are individually set in the uip (FTBL)
   met_low=met_up=c()
   if (nrow(uip) > 0) {
      # number of non zero entries per row in uip
      i_nz=rowSums(abs(uip) != 0.)
      # number of positive coeffs for alone metabs (i.e. low limit is set)
      i_pos=colSums(uip[i_nz > 0,,drop=FALSE] > 0)
      met_low=nm_poolf[i_pos > 0]
      # number of negative coeffs for alone metabs (i.e. upper limit is set)
      i_neg=colSums(uip[i_nz > 0,,drop=FALSE] < 0)
      met_up=nm_poolf[i_neg > 0]
   }

   # add low limit
   nb_add=nb_poolf-length(met_low)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_low]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(1., nb_add)
      rownames(ui_add)=paste(nm_add, ">=", clowp, sep="")
      if (nrow(ui)) {
         ui=rbind(ui, ui_add)
      } else {
         ui=ui_add
      }
      ci=c(ci, rep(clowp, nb_add))
   }

   # add upper limit
   nb_add=nb_poolf-length(met_up)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_up]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(-1., nb_add)
      rownames(ui_add)=paste(nm_add, "<=", cupp, sep="")
      ui=rbind(ui, ui_add)
      ci=c(ci, rep(-cupp, nb_add))
   }

   nm_i=names(ci)=rownames(ui)
   colnames(ui)=nm_par
}
# extend the matrix of metabolite equalities
ep=cbind(matrix(0., nrow(ep), nb_param-nb_poolf), ep)
colnames(ep)=nm_par

# prepare metabolite pools measurements
nb_poolm=10
nb_f$nb_poolm=nb_poolm
nm_poolm=c("pm:Cit", "pm:Fru6P", "pm:FruBP", "pm:Glc6P", "pm:Gnt6P", "pm:Mal", "pm:PEP", "pm:PGA", "pm:Rub5P+Rib5P+Xul5P", "pm:Suc")
nm_list$poolm=nm_poolm

# measured values
vecpoolm=c(0.001630397300073748, 0.00010006707551232429, 0.0004927839907571225, 0.0004905098655004916, 0.00014480899018442714, 0.0006054470296805187, 5.501298486110693e-05, 0.0005008619523631337, 0.00015517247228805515, 0.0014849826568155515)
names(vecpoolm)=nm_poolm

# inverse of variance for pool measurements
poolmdev=c(0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(poolmdev)=nm_poolm

# simulated metabolite measurements are calculated as
# measmatpool*poolall=>poolm
measmatpool=matrix(0., nrow=nb_poolm, ncol=length(poolall))
dimnames(measmatpool)=list(nm_poolm, nm_poolall)
i=matrix(1+c(0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 11, 8, 10, 9, 9), ncol=2, byrow=TRUE)
measmatpool[i]=1.

labargs=new.env()
labargs$labargs2=new.env()
    
# gather all measurement information
measurements=list(
   vec=list(labeled=measvec, flux=fmn, pool=vecpoolm, kin=if (case_i) measvecti else NULL),
   dev=list(labeled=measdev, flux=fmndev, pool=poolmdev, kin=if (case_i) lapply(structure(seq(nb_exp), names=names(measdev)), function(i) {v=measdev[[i]]; nbc=if (is.null(measvecti[[i]])) 0 else ncol(measvecti[[i]]); suppressWarnings(matrix(v, nrow=length(v), ncol=nbc))}) else NULL),
   mat=list(labeled=measmat, flux=ifmn, pool=measmatpool),
   one=list(labeled=memaone)
)
nm_resid=c(if (case_i) unlist(lapply(seq_len(nb_exp), function(iexp) {m=outer(rownames(measvecti[[iexp]]), ti[[iexp]][-1L], paste, sep=", t="); if (length(m) > 0L) paste(iexp, m, sep=":", recycle0=TRUE) else character(0L)})) else unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, nm_meas[[iexp]], sep=":"))), nm_fmn, nm_poolm)
nm_list$resid=nm_resid

if (TIMEIT) {
   cat("preopt  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
names(param)=nm_par
# prepare series of starting points
if (nchar(fseries) > 0) {
   pstart=as.matrix(read.table(file.path(dirw, fseries), header=TRUE, row.names=1L, sep="\t"))
   # skip parameters (rows) who's name is not in nm_par
   i=rownames(pstart) %in% nm_par
   if (!any(i)) {
      stop_mes("Option --fseries is used but no free parameter with known name is found.\n", file=fcerr)
   }
   pstart=pstart[i,,drop=FALSE]
   cat("Using starting values form '", fseries, "' for the following free parameters:\n", paste(rownames(pstart), collapse="\n"), "\n", sep="", file=fclog)
   nseries=ncol(pstart)
   if (initrand) {
      # fill the rest of rows with random values
      i=nm_par %in% rownames(pstart)
      n=sum(!i)
      pstart=rbind(pstart, structure(matrix(runif(n*nseries), n, nseries), dimnames=list(NULL, sprintf(paste0("V%0", ceiling(log10(nseries+1)), "d"), seq(nseries)))))
      rownames(pstart)=c(rownames(pstart)[seq_len(nb_param-n)], nm_par[!i])
   }
   if (nchar(iseries) > 0) {
      iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
      iseries=iseries[iseries<=nseries]
      # subsample
      pstart=pstart[,iseries, drop=FALSE]
      nseries=ncol(pstart)
   } else {
      iseries=seq_len(nseries)
   }
} else if (nchar(iseries) > 0) {
   # first construct pstart then if needed fill it with random values
   # and only then subsample
   iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
   nseries=max(iseries)
   pstart=matrix(rep(param, nseries), nrow=nb_param, ncol=nseries)
   dimnames(pstart)=list(nm_par, sprintf(paste0("V%0", ceiling(log10(nseries+1)), "d"), seq(nseries)))
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
   # subsample
   pstart=pstart[,iseries, drop=FALSE]
   nseries=ncol(pstart)
} else {
   iseries=1L
   pstart=as.matrix(param)
   nseries=1L
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
}
nm_pseries=rownames(pstart)

if (is.null(nseries) || nseries==0) {
   stop_mes(sprintf("No starting values in the series file '%s' or --iseries is empty.", fseries),  file=fcerr)
}

pres=matrix(NA, nb_param, nseries)
rownames(pres)=nm_par
colnames(pres)=colnames(pstart)
costres=rep.int(NA, nseries)

# prepare flux index conversion
ifwrv=1:nb_fwrv
names(ifwrv)=nm_fwrv
ifl_in_fw=if (nb_fln) ifwrv[paste("fwd", substring(c(nm_fln, nm_flx), 4), sep="")] else integer(0)
iff_in_fw=if (nb_ff > 0) ifwrv[paste("fwd", substring(c(nm_ffn, nm_ffx), 4), sep="")] else integer(0)
ifg_in_fw=if (nb_fgr > 0) ifwrv[paste("fwd", substring(nm_fgr, 4), sep="")] else integer(0)

# index couples for jacobian df_dfl, df_dffd
cfw_fl=crv_fl=cbind(ifl_in_fw, seq_len(nb_fl))
cfw_ff=crv_ff=cbind(iff_in_fw, seq_len(nb_ff))
cfw_fg=crv_fg=cbind(ifg_in_fw, nb_ff+seq_len(nb_fgr))
crv_fl[,1L]=(nb_fwrv/2)+crv_fl[,1L]
crv_ff[,1L]=(nb_fwrv/2)+crv_ff[,1L]
crv_fg[,1L]=(nb_fwrv/2)+crv_fg[,1L]

# store it in nb_f
nb_f=append(nb_f, list(cfw_fl=cfw_fl, crv_fl=crv_fl, cfw_ff=cfw_ff,
   crv_ff=crv_ff, cfw_fg=cfw_fg, crv_fg=crv_fg))
nb_f=as.environment(nb_f)

nbc_x=c(0, cumsum(nb_x))
nb_f$nbc_x=nbc_x

# fixed part of jacobian (unreduced by SD)
# measured fluxes
dufm_dp=cbind(dufm_dff(nb_f, nm_list), matrix(0, nrow=nb_fmn, ncol=nb_sc_tot+nb_poolf))
dimnames(dufm_dp)=list(nm_fmn, nm_par)

# measured pools
dupm_dp=matrix(0., nb_poolm, nb_ff+nb_sc_tot)
if (nb_poolf > 0L) {
   dupm_dp=cbind(dupm_dp, measurements$mat$pool[,nm_list$poolf, drop=FALSE])
}
dimnames(dupm_dp)=list(rownames(measurements$mat$pool), nm_par)

#browser()
# prepare argument list for passing to label simulating functions
nm_labargs=c("jx_f", "nb_f", "nm_list", "nb_x", "invAfl", "p2bfl", "g2bfl", "bp", "fc", "xi", "spa", "spaf", "emu", "pool", "measurements", "ipooled", "ir2isc",  "nb_w", "nb_rw", "nbc_x", "measmat", "memaone", "dufm_dp", "dupm_dp", "pwe", "ipwe", "ip2ipwe", "pool_factor", "ijpwef", "ipf_in_ppw", "meas2sum", "dp_ones", "clen", "dirr", "dirw", "dirres", "baseshort", "case_i", "nb_exp", "noscale", "dpw_dpf", "fclog", "fcerr")

if (TIMEIT) {
   cat("labargs : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
tmp=lapply(nm_labargs, function(nm) assign(nm, get(nm), labargs))
#for (nm in nm_labargs) {
#   labargs[[nm]]=get(nm)
#}
#labargs[["nm"]]=labargs[["nm_list"]]

# prepare labargs2 if time_order includes 2
if (case_i && (time_order == "2" || time_order == "1,2")) {
   list2env(as.list(labargs), envir=labargs$labargs2)
   labargs$labargs2$tifull=tifull2
   labargs$labargs2$xi=xi2
   labargs$labargs2$jx_f=new.env()
   labargs$labargs2$nb_f=new.env()
   list2env(as.list(labargs$nb_f), envir=labargs$labargs2$nb_f)
   labargs$labargs2$nb_f$ipf2ircumo=nb_f$ipf2ircumo2
   labargs$labargs2$nb_f$tifu=nb_f$tifu2
}

# formated output in kvh file
if (write_res && wkvh) {
   fkvh_saved=file.path(dirres, "tmp", sprintf("%s_res.kvh", baseshort))
} else {
   fkvh_saved=NULL
}

retcode=numeric(nseries)
cl_type="PSOCK"
cl=NULL
if ((case_i && (time_order %in% c("1,2", "2"))) || sensitive == "mc") {
   if (np > 1L) {
      # prepare cluster
      nodes=if (sensitive == "mc" && !parR) np else 2

      cl=makeCluster(nodes, cl_type) #)
      #cl=makeCluster(1L, cl_type, manual=TRUE, outfile="")
#cat("make cluster=")
#print(cl[[1]])
      labargs[["cl"]]=cl
      nodes=length(cl)
      if (TIMEIT) {
         cat("cl expor: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterExport(cl, c("lsi_fun", "df_dffp", "lab_sim", "is.diff", "lab_resid", "ui", "ci", "ep", "cp", "control_ftbl", "methods", "sln", "labargs", "dirr", "emu", "%stm%", "case_i", "time_order", "fullsys", "nm_inp"))
      if (TIMEIT) {
         cat("cl sourc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterEvalQ(cl, {
         #idth=myinfo$id
         suppressPackageStartupMessages(library(nlsic))
         suppressPackageStartupMessages(library(slam)) # for quick sparse matrices
         suppressPackageStartupMessages(library(Rcpp))
         suppressPackageStartupMessages(library(RcppArmadillo))
         suppressPackageStartupMessages(library(rmumps))
         suppressPackageStartupMessages(library(arrApply)) # for fast apply() on arrays
         suppressPackageStartupMessages(library(multbxxc))
         compiler::enableJIT(0)
         source(file.path(dirr, "tools_ssg.R"))
         #source(file.path(dirr, "nlsic.R"))
         source(file.path(dirr, "opt_cumo_tools.R"))
         source(file.path(dirr, "opt_icumo_tools.R"))
         labargs$spa=sparse2spa(labargs$spa)
         if (case_i && (time_order == "2" || time_order == "1,2")) {
            labargs$labargs2$spa=labargs$spa
         }
         if (fullsys) {
            labargs$spaf=sparse2spa(labargs$spaf)
            if (case_i && (time_order == "2" || time_order == "1,2")) {
               labargs$labargs2$spaf=labargs$spaf
            }
         }
#cat("evalQ idth=", idth, "\n")
#print(labargs)
#print(labargs$labargs2)
#print(labargs$spa)
#print(labargs$labargs2$spa)
#print(list(cre_cl="", labargs=labargs, spa_a1=labargs$spa[[1L]]$a))
         NULL
      })
      clusterSetRNGStream(cl)
      # set worker id
      idw=parLapply(cl, seq_along(cl), function(i) assign("idw", i, envir=.GlobalEnv))

   } else {
      labargs$cl=NULL
   }
}
for (irun in seq_len(nseries)) {
   if (TIMEIT) {
      cat(sprintf("run %4d: %s cpu=%g\n", irun, format(Sys.time()), proc.time()[1]), "\n", sep="", file=fclog)
   }
   param[nm_pseries]=pstart[nm_pseries, irun]
#browser()
   if (nseries > 1) {
      runsuf="." %s+% colnames(pstart)[irun]
   } else {
      runsuf=""
   }
   if (length(nseries) > 0) {
      cat("Starting point", runsuf, "\n", sep="", file=fclog)
   }
   # prepare kvh file name
   if (write_res && wkvh) {
      fkvh=file(substring(fkvh_saved, 1, nchar(fkvh_saved)-4) %s+% runsuf %s+% ".kvh", "w");
   } else {
      fkvh=NULL
   }

   # remove zc inequalities from previous runs
   izc=grep("^zc ", nm_i)
   if (length(izc)) {
      ui=ui[-izc,,drop=FALSE]
      ci=ci[-izc]
      nm_i=rownames(ui)
   }
   # check if initial approximation is feasible
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   # set tolerance for inequality
   tol_ineq=if ("BFGS" %in% methods) 0. else tol
   nbad=sum(ineq <= -tol_ineq)
   if (anyNA(param))
      stop_mes("NA found in initial 'param' values:\n\t",
      paste0(apply(cbind(nm_par, param), 1, paste0, collapse="\t"), collapse="\n\t"))
   if (nbad > 0) {
      if (TIMEIT) {
         cat(sprintf("put_ins : %s cpu=%g\n", format(Sys.time()), proc.time()[1]), "\n", sep="", file=fclog)
      }
      cat("The following ", nbad, " inequalities are not respected at starting point", runsuf, ":\n", sep="", file=fclog)
      i=ineq[ineq<= -tol_ineq]
      cat(paste(names(i), i, sep="\t", collapse="\n"), "\n", sep="", file=fclog)
      # put them inside
      if (write_res) {
         capture.output(pinside <- put_inside(param, ui, ci), file=fclog)
      } else {
         pinside <- put_inside(param, ui, ci)
      }
      if (any(is.na(pinside))) {
         if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
            # fatal error occured
            cat("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n",
               file=fcerr, sep="")
            #close(fkvh)
            retcode[irun]=attr(pinside, "err")
            next;
         }
      } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0) {
         # non fatal problem
         cat(paste("***Warning: put_inside: ", attr(pinside, "mes"), collapse=""), "\n", file=fclog)
      }
      param[]=pinside
   }

   # prepare zero crossing strategy
   # inequalities to keep sens of net flux on first call to opt_wrapper()
   # if active they are removed on the second call to opt_wrapper()
   # and finaly all zc constraints are relaxed on the last call to opt_wrapper()
   fallnx=param2fl(param, labargs)$fallnx
   mi_zc=NULL
   li_zc=NULL
   if (!noopt && zerocross && length(grep("^[df]\\.n\\.", nm_fallnx))>0) {
      if (TIMEIT) {
         cat("zc ineq : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
#browser()
      # prepare fluxes that are already in inequalities in alone mode
      ige=names(which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==1) & li>=0))
      ige=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ige, v=TRUE)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ige, v=TRUE)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ige, v=TRUE))
      ))]
      ile=which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==-1)&li>=0)
      ile=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ile, v=TRUE)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ile, v=TRUE)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ile, v=TRUE))
      ))]
      # add lower limits on [df].net >= zc for positive net fluxes
      # and upper limits on [df].net <= -zc for negative net fluxes
      nm_izc=c()
      ipos=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]>=0.)), ige)
      ineg=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]<0.)), ile)
      mi_zc=matrix(0, nrow=length(ipos)+length(ineg), ncol=nb_fallnx)
      colnames(mi_zc)=nm_fallnx
      if (length(ipos)) {
         nm_izc=c(nm_izc, paste("zc ", ipos, ">=", zc, sep=""))
         mi_zc[(1:length(ipos)),ipos]=diag(1., length(ipos))
      }
      if (length(ineg)) {
         nm_izc=c(nm_izc, paste("zc ", ineg, "<=", -zc, sep=""))
         mi_zc[length(ipos)+(1:length(ineg)),ineg]=diag(-1., length(ineg))
      }
      rownames(mi_zc)=nm_izc
      li_zc=rep(zc, length(nm_izc)) # that's ok for both pos and neg constraints
      ui_zc=cbind(mi_zc%*%(md%*%invAfl%stm%p2bfl+mf),
         matrix(0., nrow=nrow(mi_zc), ncol=nb_sc_tot))
      if (nb_fgr > 0) {
         ui_zc=cbind(ui_zc, mi_zc%*%((md%*%invAfl%stm%g2bfl)+mg*nb_f$mu))
      } else if (nb_poolf > 0) {
         ui_zc=cbind(ui_zc, matrix(0., nrow=nrow(mi_zc), ncol=nb_poolf))
      }
      ci_zc=li_zc-mi_zc%*%mic
      # remove constant inequalities
      if (ncol(ui_zc)) {
         zi=apply(ui_zc,1,function(v){return(max(abs(v))<=1.e-14)})
      } else {
         # remove all flux inequalities as there is no free params
         zi=rep(TRUE, nrow(ui_zc))
      }

      inotsat=ci_zc[zi]>tol_ineq
      if (any(inotsat)) {
         cat("***Warning: the following constant zc inequalities are not satisfied:\n", file=fclog)
         cat(nm_izc[zi][inotsat], sep="\n", file=fclog)
      }
      ui_zc=ui_zc[!zi,,drop=FALSE]
      ci_zc=ci_zc[!zi]
      nm_izc=nm_izc[!zi]
      mi_zc=mi_zc[!zi,,drop=FALSE]

      # remove redundant/contradictory inequalities
      nb_zc=nrow(ui_zc)
      nb_i=nrow(ui)
      ired=c()
      tui=t(ui)
      uzcd=sapply(seq_len(nb_zc), function(i) apply(abs(tui-ui_zc[i,]), 2L, max))
      uzcs=sapply(seq_len(nb_zc), function(i) apply(abs(tui+ui_zc[i,]), 2L, max))
      czcd=abs(outer(abs(ci), abs(ci_zc), "-"))
      ired=which(apply((uzcd < tol_ineq | uzcs < tol_ineq) & czcd <= 1.e-2, 2, any))
      
      if (length(ired) > 0L) {
         # remove all ired inequalities
         cat("The following ", length(ired), " zerocross inequalities are redundant and are removed:\n", paste(nm_izc[ired], collapse="\n"), "\n", sep="", file=fclog)
         ui_zc=ui_zc[-ired,,drop=FALSE]
         ci_zc=ci_zc[-ired]
         nm_izc=nm_izc[-ired]
         mi_zc=mi_zc[-ired,,drop=FALSE]
      }
      if (nrow(ui_zc)) {
         # add zc inequalities
         ui=rbind(ui, ui_zc)
         ci=c(ci, ci_zc)
         nm_i=c(nm_i, nm_izc)
      }
      rm(ui_zc, ci_zc, uzcd, uzcs, czcd)
   }
   rres=NULL

   # set initial scale values to sum(measvec*simlab/dev**2)/sum(simlab**2/dev**2)
   # for corresponding measurements
   if (nb_sc_tot > 0) {
      if (TRUE) { # always estimate scaling params even for --noopt
         if (TIMEIT) {
            cat("res esti: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         if (write_res) {
            capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
         } else {
            rres <- lab_resid(param, cjac=FALSE, labargs)
         }
         if (!is.null(rres$err) && rres$err) {
            cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
            #close(fkvh)
            retcode[irun]=rres$err
            next
         }
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at init scale values)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         for (iexp in seq_len(nb_exp)) {
            simlab=jx_f$usimlab[[iexp]]
            measinvvar=1./measurements$dev$labeled[[iexp]]**2
            ms=measvec[[iexp]]*simlab*measinvvar
            ss=simlab*simlab*measinvvar
            # get only valid measurements
            iva=!is.na(ms)
            for (i in nb_ff+nb_sc_base[iexp]+seq_len(nb_sc[[iexp]])) {
               im=(ir2isc[[iexp]]==(i+1)) & iva
               if (sum(im) < 2) {
                  mes=sprintf("scaling: no sufficient valid data for scaling factor '%s'\n", nm_par[i])
                  stop_mes(mes, file=fcerr)
               }
               param[i]=sum(ms[im])/sum(ss[im])
            }
         }
      } else {
         # if no optimization, set all scaling params to 1.
         param[nb_ff+seq_len(nb_sc_tot)]=1.
      }
   }

#browser()
   # see if there are any active inequalities at starting point
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   nbad=sum(abs(ineq)<=tol_ineq)
   if (anyNA(param))
      stop_mes("NA introduced in 'param' values during scaling factor estimation:
	",
      paste0(apply(cbind(nm_par, param), 1, paste0, collapse="	"), collapse="
	"))
   if (nbad > 0) {
      cat("The following ", nbad, " ineqalitie(s) are active at starting point", runsuf, ":\n",
         paste(names(ineq[abs(ineq)<=tol_ineq]), collapse="\n"), "\n", sep="", file=fclog)
   }

   if (TIMEIT && wkvh) {
      cat("kvh init: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }

   if (write_res && wkvh) {
      cat("influx\n", file=fkvh)
      cat("\tversion\t", vernum, "\n", file=fkvh, sep="")
      cat("\tlabeling\t", if (case_i) "instationary" else "stationary", "\n", file=fkvh, sep="")
      # save options of command line
      cat("\truntime options\n", file=fkvh)
      cat("\t\thelp='==SUPPRESS=='
version='==SUPPRESS=='
TIMEIT=TRUE
parR=TRUE\n", file=fkvh)
   }
   
   if (write_res && wkvh) {
      obj2kvh(R.Version(), "R.Version", fkvh, indent=1)
      cat("\tR command line\n", file=fkvh)
      obj2kvh(opts, "opts", fkvh, indent=2)
      cat("\t\texecution date	", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fkvh)
      
      # resume system sizes
      obj2kvh(nb_sys, "system sizes", fkvh)
      
      # save initial param
      cat("starting point\n", file=fkvh)
      names(param)=nm_par
      obj2kvh(param, "starting free parameters", fkvh, indent=1)
   }
#browser()
   if (!length(rres)) {
      rres <- lab_resid(param, cjac=FALSE, labargs)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #close(fkvh)
         retcode[irun]=rres$err
         next
      }
      if (sum(is.infinite(rres$res))) {
         cat("Infinite values appeared in residual vector (at starting point)", file=fcerr)
         retcode[irun]=1
         #close(fkvh)
         next
      }
   }
   rcost=if (length(rres$res) && !all(ina <- is.na(rres$res))) sum(crossprod(rres$res[!ina])) else NA
   if (write_res && wkvh) {
      obj2kvh(rcost, "starting cost value", fkvh, indent=1)
      obj2kvh(Afl, "flux system (Afl)", fkvh, indent=1)
   }
   fg=numeric(nb_f$nb_fgr)
   names(fg)=nm_list$fgr
   if (nb_f$nb_fgr > 0) {
      fg[paste("g.n.", substring(nm_list$poolf, 4), "_gr", sep="")]=nb_f$mu*param[nm_list$poolf]
   }
   if (write_res && wkvh) {
      btmp=as.numeric(p2bfl%stm%param[seq_len(nb_f$nb_ff)]+bp+g2bfl%stm%fg)
      names(btmp)=dimnames(Afl)[[1]]
      obj2kvh(btmp, "flux system (bfl)", fkvh, indent=1)
   }

   #cat("mass vector:\n", file=fclog)
   #print_mass(x)

   names(param)=nm_par

#browser()
   if (optimize && nb_ff+nb_poolf > 0L) {
      if (!(least_norm || sln || !"nlsic" %in% methods)) {
         # check if at starting position all fluxes can be resolved
         if (TIMEIT) {
            cat("check ja: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         rres=lab_resid(param, cjac=TRUE, labargs)
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at identifiability check)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         if (any(is.infinite(rres$jacobian))) {
            cat("Infinite values appeared in Jacobian (at identifiability check)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         qrj=qr(jx_f$dr_dff, LAPACK=TRUE)
         d=diag(qrj$qr)
         qrj$rank=sum(abs(d)>abs(d[1])*tol)
         if (is.na(qrj$rank)) {
            cat("Rank of starting jacobian could not be estimated.", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         if (qrj$rank) {
            nm_uns=nm_ff[qrj$pivot[-(1:qrj$rank)]]
         } else {
            nm_uns=nm_ff
         }
         if (qrj$rank < nb_ff) {
            # Too bad. The jacobian of free fluxes is not of full rank.
            dimnames(jx_f$dr_dff)[[2]]=c(nm_ffn, nm_ffx)
            fname="dbg_dr_dff_singular" %s+% runsuf %s+% ".csv"
            cat(sprintf("Provided measurements (labeling and fluxes) are not sufficient to resolve all free fluxes.\nUnsolvable fluxes may be:\n%s\nJacobian dr_dff is written in the result kvh file (if --wkvh is activated).\n",
               paste(nm_uns, sep=", ", collapse=", ")),
               file=fcerr)
            if (write_res && wkvh) {
               obj2kvh(jx_f$dr_dff, "Jacobian dr_dff", fkvh, indent=0)
            }
            #close(fkvh)
            retcode[irun]=1
            next
         }
      }
      if (TIMEIT) {
         cat("optim   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      # pass control to the chosen optimization method
      if (time_order=="1,2")
         labargs$time_order="1" # start with order 1, later continue with 2
#browser()
      for (method in methods) {
         if (write_res) {
            capture.output(res <- opt_wrapper(param, method, measurements, jx_f, labargs), file=fclog)
         } else {
            res <- opt_wrapper(param, method, measurements, jx_f, labargs)
         }
         if ((!is.null(res$err) && res$err) || is.null(res$par)) {
            cat("***Warning: error occured in first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fclog)
            res$par=rep(NA, length(param))
            res$cost=NA
         } else if (!is.null(res$mes) && nchar(res$mes)) {
            cat("***Warning: in first optimization pass in run ", runsuf, ": ", res$mes, "\n", sep="", file=fclog)
         }
         if (any(is.na(res$par))) {
#browser()
            res$retres$jx_f=NULL # to avoid writing of huge data
            if (write_res && wkvh) {
               obj2kvh(res, "failed first pass optimization process information", fkvh)
            }
            cat("Optimization failed", runsuf, ": ", res$mes, "\n", file=fcerr, sep="")
            #close(fkvh) # some additional information can be written into fkvh
            retcode[irun]=max(res$err, 1)
            next
         }
         param=res$par
#browser()
         if (zerocross && !is.null(mi_zc)) {
            if (TIMEIT) {
               cat("secondzc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
            }
            # inverse active "zc" inequalities
            nm_inv=names(which((ui%*%res$par-ci)[,1]<=tol_ineq))
            i=grep("^zc ", nm_inv, v=TRUE)
            if (length(i) > 0) {
               i=str2ind(i, nm_i)
               cat("The following inequalities are active after first pass
   of zero crossing strategy and will be inverted", runsuf, ":\n", paste(nm_i[i], collapse="\n"), "\n", sep="", file=fclog)
               ipos=grep(">=", nm_i[i], v=TRUE)
               ineg=grep("<=", nm_i[i], v=TRUE)
               ui[i,]=-ui[i,,drop=FALSE]
               if (length(ipos)) {
                  ipzc=str2ind(ipos, nm_izc)
                  ipos=str2ind(ipos, nm_i)
                  ci[ipos]=as.numeric(zc+mi_zc[ipzc,,drop=FALSE]%*%mic)
                  nm_i[ipos]=sub(">=", "<=-", nm_i[ipos])
               }
               if (length(ineg)) {
                  inzc=str2ind(ineg, nm_izc)
                  ineg=str2ind(ineg, nm_i)
                  ci[ineg]=as.numeric(zc+mi_zc[inzc,,drop=FALSE]%*%mic)
                  nm_i[ineg]=sub("<=-", ">=", nm_i[ineg])
               }
               rownames(ui)=nm_i
               names(ci)=nm_i
               # enforce new inequalities
               reopt=TRUE
               if (write_res) {
                  capture.output(pinside <- put_inside(res$par, ui, ci), file=fclog)
               } else {
                  pinside <- put_inside(res$par, ui, ci)
               }
               if (any(is.na(pinside))) {
                  if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
                     # fatal error occured, don't reoptimize
                     cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
                     reopt=FALSE
                  }
               } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0){
                  # non fatal problem
                  cat(paste("***Warning: put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fclog)
               }
               # reoptimize
               if (reopt) {
                  cat("Second zero crossing pass", runsuf, "\n", sep="", file=fclog)
                  if (write_res) {
                     capture.output(reso <- opt_wrapper(pinside, method, measurements, new.env(), labargs), file=fclog)
                  } else {
                     reso <- opt_wrapper(pinside, method, measurements, new.env(), labargs)
                  }
                  if (reso$err || is.null(reso$par)) {
                     cat("***Warning: error in second zero crossing pass: ", reso$mes, "\n", sep="", file=fclog)
                  } else if (!is.null(reso$mes) && nchar(reso$mes)) {
                     cat("***Warning: second zero crossing pass", runsuf, ": ", reso$mes, "\n", sep="", file=fclog)
                  }
                  if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                     param=reso$par
                     res=reso
                     jx_f=labargs$jx_f
                  }
                  if (any(is.na(reso$par))) {
                     reso$retres$jx_f=NULL # to avoid writing of huge data
                     if (write_res && wkvh)
                        obj2kvh(reso, "failed second pass optimization process information", fkvh)
                     cat("***Warning: second zero crossing pass failed. Keep free parameters from previous pass", runsuf, "\n", file=fclog, sep="")
                  }
               }
               # last pass, free all zc constraints
               i=grep("^zc ", nm_i)
               if (length(i) > 0) {
                  if (TIMEIT) {
                     cat("last zc : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
                  }
                  ui=ui[-i,,drop=FALSE]
                  ci=ci[-i]
                  nm_i=nm_i[-i]
                  cat("Last zero crossing pass (free of zc constraints)", runsuf, "\n", sep="", file=fclog)
                  if (write_res) {
                     capture.output(reso <- opt_wrapper(param, method, measurements, new.env(), labargs), file=fclog)
                  } else {
                     reso <- opt_wrapper(param, method, measurements, new.env(), labargs)
                  }
                  if (reso$err || is.null(reso$par) || (!is.null(res$mes) && nchar(res$mes))) {
                     cat("***Warning: last zero crossing (free of zc)", runsuf, ": ", reso$mes, "\n", sep="", file=fclog)
                  }
                  if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                     param=reso$par
                     res=reso
                     jx_f=labargs$jx_f
                  }
                  if (any(is.na(res$par))) {
                     res$retres$jx_f=NULL # to avoid writing of huge data
                     if (write_res && wkvh)
                        obj2kvh(res, "failed last pass optimization process information", fkvh)
                     cat("***Warning: last zero crossing pass failed. Keep free parameters from previous passes", runsuf, "\n", file=fclog, sep="")
                  }
               }
            } else {
               cat("After the first optimization, no zero crossing inequality was activated. So no reoptimization", runsuf, "\n", sep="", file=fclog)
            }
         } # end if zero crossing
      } # for method
#browser()
      param=res$par
      names(param)=nm_par
      if (excl_outliers != F) {
         # detect outliers
         if (TIMEIT) {
            cat("outliers: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         iva=!is.na(res$res)
         zpval=rz.pval.bi(res$res)
         iout=which(zpval <= excl_outliers & iva)
         #cat("iout=", iout, "\n", file=fclog)
         if (length(iout)) {
            measurements$outlier=iout
            outtab=cbind(residual=res$res[iout], `p-value`=zpval[iout])
            row.names(outtab)=nm_resid[iout]
            cat("Excluded outliers at p-value ", excl_outliers, ":\n", sep="", file=fclog)
            write.table(outtab, file=fclog, append=TRUE, quote=FALSE, sep="\t", col.names=FALSE)
            
            # optimize with the last method from methods
            if (write_res) {
               capture.output(reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs), file=fclog)
            } else {
               reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs)
            }
            if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
               cat("***Warning: error without outliers: ", reso$mes, "\n", sep="", file=fclog)
            }
            if (any(is.na(reso$par))) {
               cat("***Warning: optimization with outliers excluded has failed", runsuf, "\n", file=fclog, sep="")
               # continue without outlier exclusion
               measurements$outlier=NULL
            } else {
               res=reso
               param=reso$par
               names(param)=nm_par
               jx_f=labargs$jx_f
               labargs$measurements=measurements # store outliers
               if (write_res && wkvh)
                  obj2kvh(outtab, "excluded outliers", fkvh)
            }
         } else {
            cat("***Warning: outlier exclusion at p-value "%s+%excl_outliers%s+%" has been requested but no outlier was detected at this p-value threshold.", "\n", sep="", file=fclog)
         }
      }
      if (case_i && time_order=="1,2") {
         if (TIMEIT) {
            cat("order 2 : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         labargs$time_order="2" # continue with the 2-nd order
         if (write_res) {
            capture.output(reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs), file=fclog)
         } else {
            reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs)
         }
         if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
            cat("***Warning: order2: ", reso$mes, "\n", sep="", file=fclog)
         }
         if (any(is.na(reso$par))) {
            cat("***Warning: optimization time_order 2 (in '1,2' suite) has failed, run=", runsuf, "\n", file=fclog, sep="")
         } else {
            res=reso
            param=reso$par
            names(param)=nm_par
            jx_f=labargs$jx_f
         }
      }
#browser()
      optinfo=list(
         "fitted parameters"=param,
         "last increment before backtracking"=res$lastp,
         "last increment after backtracking"=res$laststep,
         "iteration number"=res$it,
         "convergence history"=res$hist,
         "exit message"=res$mes
      )
      if (write_res && wkvh)
         obj2kvh(optinfo, "optimization process information", fkvh)
      rres=res$retres
   } else {
      if (TIMEIT) {
         cat("residjac: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      rres=lab_resid(param, TRUE, labargs)
   }
   if (TIMEIT) {
      cat("postopt : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # active constraints
   if (!all(is.na(param))) {
      ine=as.numeric(abs(ui%*%param-ci))<tol_ineq
      if (any(ine) && write_res && wkvh) {
         obj2kvh(nm_i[ine], "active inequality constraints", fkvh)
      }
   }
   poolall[nm_poolf]=param[nm_poolf]

#browser()
   if (is.null(jx_f$jacobian)) {
      # final jacobian calculation
      if (write_res) {
         capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      } else {
         rres <- lab_resid(param, cjac=TRUE, labargs)
      }
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #if (write_res && wkvh)
         #   close(fkvh)
         retcode[irun]=rres$err
         next
      }
   }
   rcost=cumo_cost(param, labargs, rres)
   pres[,irun]=param
   costres[irun]=rcost
   if (write_res) {
      if (wkvh) obj2kvh(rcost, "final cost", fkvh)
#browser()
      # get z p-values on residual vector
      zpval=rz.pval.bi(rres$res)
      resid=list()
      if (sum(nb_meas)) {
         resid[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) if (is.matrix(jx_f$reslab[[iexp]])) jx_f$reslab[[iexp]] else cbind(residual=jx_f$reslab[[iexp]], `p-value`=zpval[seq_along(jx_f$reslab[[iexp]])]))
         names(resid[["labeled data"]])=nm_exp
      
         if (case_i) {
            resid[["labeled data p-value"]]=vector("list", nb_exp)
            names(resid[["labeled data p-value"]])=nm_exp
            for (iexp in seq_len(nb_exp)) {
               mtmp=zpval[seq_along(jx_f$reslab[[iexp]])]
               dim(mtmp)=dim(jx_f$reslab[[iexp]])
               dimnames(mtmp)=dimnames(jx_f$reslab[[iexp]])
               resid[["labeled data p-value"]][[iexp]]=mtmp
               rm(mtmp)
            }
         }
      }
      nb_reslab_tot=sum(sapply(jx_f$reslab, length))
      if (length(jx_f$resflu))
         resid[["measured fluxes"]]=cbind(residual=jx_f$resflu, `p-value`=zpval[nb_reslab_tot+seq_along(jx_f$resflu)])
      if (length(jx_f$respool))
         resid[["measured pools"]]=cbind(residual=if (is.matrix(jx_f$respool)) jx_f$respool[,1] else jx_f$respool, `p-value`=zpval[nb_reslab_tot+length(jx_f$resflu)+seq_along(jx_f$respool)])
      if (wkvh)
         obj2kvh(resid, "(simulated-measured)/sd_exp", fkvh)

      # simulated measurements -> out
      simul=list()
#browser()
      if (case_i) {
         if (sum(nb_meas)) {
            if (addnoise) {
               simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) jx_f$usm[[iexp]]+rnorm(length(jx_f$usm[[iexp]]))*measurements$dev$labeled[[iexp]])
               names(simul[["labeled data"]])=nm_exp
            } else {
               # move mass in usm into valid interval [0, 1] and sum=1
               simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) {
                  x=clamp(jx_f$usm[[iexp]], 0, 1)
                  # get unique mass names to sum up to 1
                  nmx=rownames(x)
                  nm_m=nmx[startsWith(nmx, "m:")]
                  if (length(nm_m)) {
                     # get unique fragments
                     fr_u=unique(sapply(strsplit(nm_m, ":", fixed=TRUE), function(v) paste0(c(v[1L:3L], ""), collapse=":")))
                     lapply(fr_u, function(nm) {
                        # get indexes per fragment
                        i=which(startsWith(nmx, nm))
                        mets=strsplit(nm, ":", fixed=TRUE)[[1L]][2L]
                        met1=strsplit(mets, "+", fixed=TRUE)[[1L]][1L]
                        if (length(i) < clen[met1]+1)
                           return(NULL)
                        s=colSums(x[i,,drop=FALSE])
                        x[i,] <<- arrApply::arrApply(x[i,,drop=FALSE], 2, "multv", v=1./s)
                        NULL
                     })
                  }
                  x
               })
               names(simul[["labeled data"]])=nm_exp
            }
            # simul --> .miso.sim
            mlp2LAB=c(m="MS", l="LAB", p="PEAK")
            cnm=c("Id", "Comment", "Specie", "Fragment", "Dataset", "Isospecies", "Value", "SD", "Time", "Residual", "Pvalue")
            for (fnm in nm_exp) {
               rnm=gsub("#", "", rownames(simul[["labeled data"]][[fnm]]), fixed=TRUE)
               mnm=strsplitlim(rnm, ":", fixed=TRUE, lim=NA, strict=TRUE)
               mnm=matrix(unlist(mnm), ncol=length(mnm[[1L]]), byrow=TRUE)
               ct=rep(colnames(simul[["labeled data"]][[fnm]]), each=nrow(simul[["labeled data"]][[fnm]]))
               c3=suppressWarnings(as.integer(mnm[, 3L]))
               df=cbind(
                  "",
                  "",
                  Specie=mnm[, 2L],
                  Fragment=ifelse(mnm[, 1L] == "m", mnm[, 3L], ""),
                  Dataset=paste0(mlp2LAB[mnm[, 1L]], "_", mnm[, 2L], "_", mnm[, 3L]),
                  Isospecies=ifelse(mnm[, 1L] == "m",
                     paste0("M", mnm[, 4L]), # MS: M0, M1, etc
                     ifelse(mnm[, 1L] == "l", mnm[, 3L], # label: 01x+00x etc
                     paste0(mnm[, 3L], "->", # peak: 2->1,3 etc.
                           ifelse(mnm[, 4L] == "S", "",
                           ifelse(mnm[, 4L] == "D-", c3-1,
                           ifelse(mnm[, 4L] == "D+", c3+1,
                           paste0(c3-1, ",", c3+1) # DD
                           )))))),
                  Value=c(simul[["labeled data"]][[fnm]]),
                  SD=measdev[[fnm]],
                  Time=ct,
                  Resid=c(resid[["labeled data"]][[fnm]]),
                  Pvalue=c(resid[["labeled data p-value"]][[fnm]])
               )
               colnames(df)=cnm
               write.table(df, sep="	", quote=FALSE, row.names=FALSE, fileEncoding="utf8", file=file.path(dirres, paste0(fnm, runsuf, ".miso.sim")))
            }
         }
      } else {
         if (sum(nb_meas)) {
            if (addnoise) {
               simlab=lapply(seq_len(nb_exp), function(iexp) jx_f$simlab[[iexp]]+rnorm(length(jx_f$simlab[[iexp]]))*measurements$dev$labeled[[iexp]])
               names(simlab)=nm_exp
            } else {
               simlab=jx_f$simlab
               names(simlab)=nm_exp
            }
            if (nb_sc_tot > 0) {
               simul[["labeled data (unscaled)"]]=jx_f$usimlab
               simul[["labeled data (scaled)"]]=simlab
            } else {
               simul[["labeled data"]]=simlab
            }
            # simlab --> .miso.sim
            mlp2LAB=c(m="MS", l="LAB", p="PEAK")
            cnm=c("Id", "Comment", "Specie", "Fragment", "Dataset", "Isospecies", "Value", "SD", "Time", "Residual", "Pvalue")
            for (fnm in nm_exp) {
               rnm=gsub("#", "", names(simlab[[fnm]]), fixed=TRUE)
               mnm=strsplitlim(rnm, ":", fixed=TRUE, lim=NA, strict=TRUE)
               mnm=matrix(unlist(mnm), ncol=length(mnm[[1L]]), byrow=TRUE)
               c3=suppressWarnings(as.integer(mnm[, 3L]))
               df=cbind(
                  "",
                  "",
                  Specie=mnm[, 2L],
                  Fragment=ifelse(mnm[, 1L] == "m", mnm[, 3L], ""),
                  Dataset=paste0(mlp2LAB[mnm[, 1L]], "_", mnm[, 2L], "_", mnm[, 3L]),
                  Isospecies=ifelse(mnm[, 1L] == "m",
                     paste0("M", mnm[, 4L]), # MS: M0, M1, etc
                     ifelse(mnm[, 1L] == "l", mnm[, 3L], # label: 01x+00x etc
                     paste0(mnm[, 3L], "->", # peak: 2->1,3 etc.
                           ifelse(mnm[, 4L] == "S", "",
                           ifelse(mnm[, 4L] == "D-", c3-1,
                           ifelse(mnm[, 4L] == "D+", c3+1,
                           paste0(c3-1, ",", c3+1) # DD
                           )))))),
                  Value=simlab[[fnm]],
                  SD=measdev[[fnm]],
                  Time="",
                  resid[["labeled data"]][[fnm]]
               )
               colnames(df)=cnm
               write.table(df, sep="	", quote=FALSE, row.names=FALSE, fileEncoding="utf8", file=file.path(dirres, paste0(fnm, runsuf, ".miso.sim")))
            }
         }
      }
      #browser()
      if (nb_fmn) {
         if (addnoise)
            simul[["measured fluxes"]]=jx_f$simfmn+rnorm(length(jx_f$simfm))*measurements$dev$flux
         else
            simul[["measured fluxes"]]=jx_f$simfmn
         # measured fluxes --> .mflux
         cnm=c("Id", "Comment", "Flux", "Value", "SD", "Residual", "Pvalue")
         df=structure(cbind("", "", substring(names(simul[["measured fluxes"]]), 5), simul[["measured fluxes"]], measurements$dev$flux, resid[["measured fluxes"]]), dimnames=list(NULL, cnm))
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".mflux.sim")))
      }
      if (nb_poolm) {
         if (addnoise)
            simul[["measured pools"]]=jx_f$simpool+rnorm(length(jx_f$simpool))*measurements$dev$pool
         else
            simul[["measured pools"]]=jx_f$simpool
         # measured metabolites --> .mmet
         cnm=c("Id", "Comment", "Specie", "Value", "SD", "Residual", "Pvalue")
         df=structure(cbind("", "", substring(names(simul[["measured pools"]]), 4), simul[["measured pools"]], measurements$dev$pool, resid[["measured pools"]]), dimnames=list(NULL, cnm))
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".mmet.sim")))
      }
      rm(resid, zpval)
      if (wkvh) obj2kvh(simul, "simulated measurements", fkvh)
   
      # SD -> out
      # get index of non null components
      iget=sapply(names(measurements$dev), function(nm) !is.null(measurements$dev[[nm]]) & nm %in% c("labeled", "flux", "pool"))
      if (wkvh) obj2kvh(measurements$dev[iget], "measurement SD", fkvh)

      # gradient -> kvh
      if (length(jx_f$res) && !all(ina <- is.na(jx_f$res)) && wkvh) {
         if (any(ina)) {
            gr=2*as.numeric(crossprod(jx_f$res[!ina], jx_f$jacobian[!ina,,drop=FALSE]))
         } else {
            gr=2*as.numeric(crossprod(jx_f$res, jx_f$jacobian))
         }
         names(gr)=nm_par
         obj2kvh(gr, "gradient vector", fkvh)
      }
      colnames(jx_f$udr_dp)=nm_par
      if (wkvh) obj2kvh(jx_f$udr_dp, "jacobian dr_dp (without 1/sd_exp)", fkvh)
      # generalized inverse of non reduced jacobian
      if (length(jx_f$udr_dp) > 0L && wkvh) {
         svj=svd(jx_f$udr_dp)
         svj$d=with(svj, ifelse(d >= d[1L]*tol, d, d[1L]*tol))
         invj=svj$v%*%(t(svj$u)/svj$d)
         dimnames(invj)=rev(dimnames(jx_f$udr_dp))
         obj2kvh(invj, "generalized inverse of jacobian dr_dp (without 1/sd_exp)", fkvh)
      }
   }

   labargs$getx=TRUE
   labargs$labargs2$getx=TRUE
   if (fullsys) {
   
#browser()
      nm_xif=c()
      # full label input is the same for all experiments
      xif=rep(list(c()), nb_exp)
      xif=lapply(xif, setNames, nm_xif)
      if (case_i) {
         # prepare xif from funlab
         xilf=vector("list", nb_exp)
         xi2f=vector("list", nb_exp)
         for (iexp in seq(nb_exp)) {
            fli=funlabli[[iexp]]
            if (length(fli) == 0) {
               # replicate first column in xi as many times as there are time points
               if (time_order == "2" || time_order == "1,2")
                  xi2f[[iexp]]=matrix(xif[[iexp]], nrow=length(xif[[iexp]]), ncol=nb_tifu2[[iexp]])
               xilf[[iexp]]=matrix(xif[[iexp]], nrow=length(xif[[iexp]]), ncol=nb_tifu[[iexp]])
            }  else {
               # use funlab
               xilf[[iexp]]=funlab(tifull[[iexp]], nm_xif, fli, envfunlab, emu=FALSE, nm_exp[[iexp]], fcerr)
               if (time_order == "2" || time_order == "1,2")
                  xi2f[[iexp]]=funlab(tifull2[[iexp]], nm_xif, fli, envfunlab, emu=FALSE, nm_exp[[iexp]], fcerr)
            }
         }
#browser()
         xif=xilf
         if (time_order == "2" || time_order == "1,2")
            labargs$labargs2$xif=xi2f
      }
      labargs$nm_list$xif=nm_xif
      labargs$nm_list$inp=nm_xif
      labargs$xif=xif
      labargs$nb_f$xif=length(xif[[1L]])
      labargs$labargs2$nm_list$xif=nm_xif
      labargs$labargs2$nm_list$inp=nm_xif
      labargs$labargs2$nb_f$xif=length(xif[[1L]])
      if (case_i && !is.null(labargs$cl)) {
         clusterExport(labargs$cl, c("labargs"))
         clusterEvalQ(labargs$cl, {
            labargs$spa=sparse2spa(labargs$spa)
            labargs$labargs2$spa=labargs$spa
            labargs$spaf=sparse2spa(labargs$spaf)
            labargs$labargs2$spaf=labargs$spaf
#print(c(lab_new="", labargs=labargs, labargs2=labargs$labargs2, a1_1=labargs$spaf[[1]]$a, a1_2=labargs$labargs2spaf[[1]]$a))
         })
      }
#browser()
      v=lab_sim(param, cjac=FALSE, labargs, fullsys)
      if (identical(v$err, 1L)) {
         #save(v$fA$triplet(), file="singular237_triplet.RData")
         stop_mes("fullsys: weight=", v$iw, "; ", v$mes, file=fcerr)
      }
#browser()
      labargs$nm_list$inp=nm_inp
      if (time_order == "2" || time_order == "1,2") {
         labargs$labargs2$nm_list$inp=nm_inp
      }
      x=if (case_i) v$xf else v$x
   } else {
      v=lab_sim(param, cjac=FALSE, labargs)
      x=if (case_i) v$xf else v$x
   }

   mid=cumo2mass(x)
   if (case_i) {
      mid=lapply(mid, function(m) m[sort(rownames(m)),,drop=FALSE])
   } else if (length(mid)) {
      mid=mid[sort(rownames(mid)),,drop=FALSE]
   }
   # write some info in result kvh
   if (write_res && wkvh) {
      obj2kvh(mid, "MID vector", fkvh)
      
      # constrained fluxes to kvh
      obj2kvh(fallnx[nm_fc], "constrained net-xch01 fluxes", fkvh)
   }
   fwrv=v$lf$fwrv
   fallnx=v$lf$fallnx
   flnx=v$lf$flnx
   fgr=fallnx[nm_fgr]

   # keep last jx_f in jx_f_last
#browser()
   while (sensitive=="mc" && !all(is.na(param))) {
      if (TIMEIT) {
         cat("monte-ca: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      if (set_seed) {
         set.seed(seed)
      }
      # reference simulation corresponding to the final param
      refsim=new.env()
      for (nm_it in c("simlab", "simfmn", "simpool", "usm")) {
         assign(nm_it, jx_f[[nm_it]], envir=refsim)
      }
      # Monte-Carlo simulation in parallel way (if asked and possible)
      if (np > 1L && !parR) {
         inmc=seq_len(nmc)
         #spli=splitIndices(nmc, nodes);
         spli=suppressWarnings(split(inmc, seq_len(np)))
         ii=inmc
         ii[unlist(spli)]=inmc # inverse the counting in spli
         clusterExport(cl, c("param", "refsim", "runsuf", "cl_worker", "mc_sim")) #, "spli"))
         ##clusterEvalQ(cl, labargs$spa[[1]]$a <- NULL) # to rebuild sparse matrices on cores ## now, they are build once, at the cluster init
         cl_res=clusterEvalQ(cl, {mc_iter=TRUE; labargs$getx=FALSE;})
         mc_res=parLapply(cl, spli, function(iv) lapply(iv, function(i) cl_worker(funth=mc_sim, argth=list(i))))
         mc_res=Reduce(c, mc_res, NULL)[ii]
         #mc_res=vector(nmc, mode="list")
         #for (i in seq(nodes))
         #   mc_res[spli[[i]]]=cl_res[[i]]
         #mc_res=parLapplyLB(cl, seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      } else {
         mc_res=lapply(seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      }
#browser()
      free_mc=sapply(mc_res, function(l) {if (class(l)=="character" || is.null(l) || is.na(l$cost) || l$err) { ret=rep(NA, nb_param+3) } else { ret=c(cost=l$cost, it=l$it, normp=l$normp, l$par) }; ret })
      if (length(free_mc)==0) {
         cat("***Warning: parallel exectution of Monte-Carlo simulations has failed.", "\n", sep="", file=fclog)
         free_mc=matrix(NA, nb_param+2, 0)
      }
      cost_mc=free_mc[1,]
      nmc_real=nmc-sum(is.na(free_mc[4,]))
      # remove failed m-c iterations
      ifa=which(is.na(free_mc[1,]))
      if (length(ifa)) {
         if (ncol(free_mc) > length(ifa)) {
            cat("***Warning: some Monte-Carlo iterations failed.", "\n", sep="", file=fclog)
         } else {
            cat("All Monter-Carlo samples failed.", "\n", sep="", file=fcerr)
            retcode[irun]=1
            break
         }
         free_mc=free_mc[,-ifa,drop=FALSE]
         cost_mc=cost_mc[-ifa]
      }
      if (nmc_real <= 1) {
         cat("No sufficient Monter-Carlo samples were successfully calculated to do any statistics.", "\n", sep="", file=fcerr)
         retcode[irun]=1
         break
      }
#browser()
      fallnx_mc=apply(free_mc[-(1L:3L),,drop=FALSE], 2, function(p)param2fl(p, labargs)$fallnx)
      if (length(fallnx_mc)) {
         # mean
         fallnx_mc_mean=rowMeans(fallnx_mc)
         # median
         fallnx_mc_median=apply(fallnx_mc, 1, median)
         # confidence intervals
         cinx_mc=t(apply(fallnx_mc, 1, quantile, probs=c(0.025, 0.975)))
         cinx_mc=cbind(cinx_mc, "CI 95% length"=c(diff(t(cinx_mc))))
         cinx_mc=cbind(cinx_mc, "relative CI (%)"=cinx_mc[,3]*100/abs(fallnx_mc_mean))
      }

      if (write_res && wkvh) {
         cat("monte-carlo\n", file=fkvh)
         indent=1
         obj2kvh(cl_type, "cluster type", fkvh, indent)
         obj2kvh(avaco, "detected cores", fkvh, indent)
         avaco=max(1, avaco, na.rm=TRUE)
         obj2kvh(min(avaco, np, na.rm=TRUE), "used cores", fkvh, indent)
         cat("\tfitting samples\n", file=fkvh)
         indent=2
         obj2kvh(nmc, "requested number", fkvh, indent)
         obj2kvh(nmc_real, "calculated number", fkvh, indent)
         obj2kvh(nmc-nmc_real, "failed to calculate", fkvh, indent)
         # convergence section in kvh
         indent=1
         mout=rbind(round(free_mc[1:2,,drop=FALSE], 2),
            format(free_mc[3,,drop=FALSE], di=2, sci=TRUE))
         dimnames(mout)=list(c("cost", "it.numb", "normp"), seq_len(ncol(free_mc)))
         obj2kvh(mout, "convergence per sample", fkvh, indent)
      }
      free_mc=free_mc[-(1L:3L),,drop=FALSE]
      rownames(free_mc)=nm_par

      # param stats
      # mean
      parmean=rowMeans(free_mc)
      # median
      parmed=apply(free_mc, 1, median)

      # cost section in kvh
      if (write_res && wkvh) {
         cat("\tcost\n", file=fkvh)
         indent=2
         obj2kvh(mean(cost_mc), "mean", fkvh, indent)
         obj2kvh(median(cost_mc), "median", fkvh, indent)
         obj2kvh(sd(cost_mc), "sd", fkvh, indent)
         obj2kvh(sd(cost_mc)*100/mean(cost_mc), "rsd (%)", fkvh, indent)
         obj2kvh(quantile(cost_mc, c(0.025, 0.95, 0.975)), "ci", fkvh, indent)
         
         # free parameters section in kvh
         cat("\tStatistics\n", file=fkvh)
         mout=c()
         indent=2
#browser()
         # covariance matrix
         covmc=cov(t(free_mc))
         obj2kvh(covmc, "covariance", fkvh, indent)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(free_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI length")
         mout=cbind(mout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
         obj2kvh(mout, "free parameters", fkvh, indent)

         # net-xch01 stats
         fallnx=param2fl(param, labargs)$fallnx
         if (length(fallnx_mc)) {
            dimnames(fallnx_mc)[[1]]=nm_fallnx
            # form a matrix output
            fallout=matrix(0, nrow=nrow(fallnx_mc), ncol=0)
            # covariance matrix
            covmc=cov(t(fallnx_mc))
            dimnames(covmc)=list(nm_fallnx, nm_fallnx)
            # sd
            sdmc=sqrt(diag(covmc))
            fallout=cbind(fallout, mean=fallnx_mc_mean, median=fallnx_mc_median, sd=sdmc,
               "rsd (%)"=sdmc*100/abs(fallnx_mc_mean), cinx_mc)
            o=order(nm_fallnx)
            obj2kvh(fallout[o,,drop=FALSE], "all net-xch01 fluxes", fkvh, indent)
            obj2kvh(covmc[o,o], "covariance of all net-xch01 fluxes", fkvh, indent)

            # fwd-rev stats
            fwrv_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fwrv)
            dimnames(fwrv_mc)[[1]]=nm_fwrv
            fallout=matrix(0, nrow=nrow(fwrv_mc), ncol=0)
            # mean
            parmean=apply(fwrv_mc, 1, mean)
            # median
            parmed=apply(fwrv_mc, 1, median)
            # covariance matrix
            covmc=cov(t(fwrv_mc))
            dimnames(covmc)=list(nm_fwrv, nm_fwrv)
            # sd
            sdmc=sqrt(diag(covmc))
            # confidence intervals
            cif_mc=t(apply(fwrv_mc, 1, quantile, probs=c(0.025, 0.975)))
            cif_mc=cbind(cif_mc, t(diff(t(cif_mc))))
            cif_mc=cbind(cif_mc, cif_mc[,3]*100/abs(fwrv))
            dimnames(cif_mc)[[2]]=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
            fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
               "rsd (%)"=sdmc*100/abs(parmean), cif_mc)
            o=order(nm_fwrv)
            obj2kvh(fallout[o,,drop=FALSE], "forward-reverse fluxes", fkvh, indent)
            obj2kvh(covmc[o,o], "covariance of forward-reverse fluxes", fkvh, indent)
         }
      }
      break
   }
#browser()
   if (length(sensitive) && nchar(sensitive) && sensitive != "mc") {
      cat(paste("Unknown sensitivity '", sensitive, "' method chosen.", sep=""), "\n", sep="", file=fcerr)
      retcode[irun]=1
   }

   if (TIMEIT) {
      cat("linstats: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # Linear method based on jacobian x_f
   # reset fluxes and jacobians according to param
   if (is.null(jx_f$jacobian)) {
      if (write_res) {
         capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      } else {
         rres <- lab_resid(param, cjac=TRUE, labargs)
      }
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #if (write_res && wkvh)
         #   close(fkvh)
         retcode[irun]=rres$err
         next
      }
   } # else use the last calculated jacobian
browser()
   # covariance matrix of free fluxes
   if (length(jx_f$jacobian) > 0L && !all(is.na(param))) {
      svj=svd(jx_f$jacobian)
      if (svj$d[1] == 0.) {
         i=rep(TRUE, length(svj$d))
      } else {
         i=svj$d/svj$d[1]<tol
         if (all(!i) && svj$d[1]<tol) {
            # we could not find very small d, take just the last
            i[length(i)]=TRUE
         }
      }
      ibad=apply(svj$v[, i, drop=FALSE], 2, which.contrib)
      ibad=unique(unlist(ibad))
      if (length(ibad) > 0) {
         cat(paste(if (nchar(runsuf)) runsuf%s+%": " else "", "***Warning: inverse of covariance matrix is numerically singular.\nStatistically undefined parameter(s) seems to be:\n",
            paste(sort(nm_par[ibad]), collapse="\n"), "\nFor a more complete list, see SD column in '.tvar.sim' result file.", sep=""), "\n", sep="", file=fclog)
      }
      # "square root" of covariance matrix (to preserve numerical positive definitness)
      svj$d=with(svj, ifelse(d >= d[1L]*tol, d, d[1L]*tol))
      rtcov=(svj$u)%*%(t(svj$v)/svj$d)
      # standard deviations of free fluxes
      if (write_res) {
         if (wkvh) cat("linear stats\n", file=fkvh)

         # sd free+dependent+growth net-xch01 fluxes
         nm_flfd=c(nm_ff, nm_fgr, nm_fl)
         if (nb_ff > 0 || nb_fgr > 0) {
            i=1:nb_param
            i=c(head(i, nb_ff), tail(i, nb_fgr))
            covfl=crossprod(rtcov[, i, drop=FALSE]%mmt%(rbind(diag(nb_ff+nb_fgr), dfl_dffg)%mrv%c(rep.int(1., nb_ff), fgr)))
            dimnames(covfl)=list(nm_flfd, nm_flfd)
            sdfl=sqrt(diag(covfl))
         } else {
            sdfl=rep(0., nb_fl)
            covfl=matrix(0., nb_fl, nb_fl)
         }
         fl=c(head(param, nb_ff), fgr, flnx)
         stats_nx=cbind("value"=fl, "sd"=sdfl, "rsd"=sdfl/abs(fl))
         rownames(stats_nx)=nm_flfd
         if (wkvh) {
            o=order(nm_flfd)
            obj2kvh(stats_nx[o,,drop=FALSE], "net-xch01 fluxes (sorted by name)", fkvh, indent=1)
            obj2kvh(covfl[o, o], "covariance net-xch01 fluxes", fkvh, indent=1)
         }
         
         # flux, pool --> .tvar
#browser()
         rnm=grep("_gr$", nm_fallnx, invert=TRUE, value=TRUE)
         cnm=c("Id", "Comment", "Name", "Kind", "Type", "Value", "SD", "Struct_identif")
         if (sensitive == "mc") {
            cnm=c(cnm, "Low_mc", "Up_mc")
         }
         nx2suf=c(n="NET", x="XCH")
         fd2cap=c(f="F", d="D", c="C")

         mnm=matrix(unlist(strsplitlim(rnm, ".", fixed=TRUE, lim=3L)), ncol=3L, byrow=TRUE)
         o=natorder(mnm[, 3L])
         rnm=rnm[o]
         mnm=mnm[o,,drop=FALSE]
         vfl=fallnx[rnm]
         vfl=ifelse(mnm[,2L] == "x", clamp(vfl, 0, 1), vfl)
         vsd=sdfl[rnm]
         vsd[is.na(vsd)]=0.
         df=cbind("", "", mnm[, 3L], nx2suf[mnm[, 2L]], fd2cap[mnm[, 1L]], vfl, vsd, ifelse(vsd > 10000, "no", "yes"))
         if (sensitive == "mc") {
            df=cbind(df, cinx_mc[rnm, 1L:2L])
         }

         # sd of all fwd-rev
         if (nb_ff > 0 || nb_fgr > 0) {
            i=1:nb_param
            i=c(head(i, nb_ff), tail(i, nb_fgr))
            covf=crossprod(tcrossprod_simple_triplet_matrix(rtcov[,i, drop=FALSE], jx_f$df_dffp%mrv%c(rep.int(1., nb_ff), head(poolall[nm_poolf], nb_fgr))))
            dimnames(covf)=list(nm_fwrv, nm_fwrv)
            sdf=sqrt(diag(covf))
         } else {
            sdf=rep(0., length(fwrv))
         }
         if (wkvh) {
            mtmp=cbind(fwrv, sdf, sdf/abs(fwrv))
            dimnames(mtmp)[[2]]=c("value", "sd", "rsd")
            o=order(nm_fwrv)
            obj2kvh(mtmp[o,], "fwd-rev fluxes (sorted by name)", fkvh, indent=1)
            if (nb_ff > 0 || nb_fgr > 0) {
               obj2kvh(covf, "covariance fwd-rev fluxes", fkvh, indent=1)
            }
         }
         # pool -> kvh
         sdpf=poolall
         sdpf[]=0.

         if (nb_poolf > 0) {
            # covariance matrix of free pools
            # "square root" of covariance matrix (to preserve numerical positive definitness)
            poolall[nm_poolf]=param[nm_poolf]
            # cov poolf
            covpf=crossprod(rtcov[,nb_ff+nb_sc_tot+seq_len(nb_poolf), drop=FALSE])
            dimnames(covpf)=list(nm_poolf, nm_poolf)
            sdpf[nm_poolf]=sqrt(diag(covpf))
         }
         if (length(poolall) > 0) {
            if (wkvh) {
               mtmp=cbind("value"=poolall, "sd"=sdpf, "rsd"=sdpf/poolall)
               rownames(mtmp)=nm_poolall
               o=order(nm_poolall)
               obj2kvh(mtmp[o,,drop=FALSE], "metabolite pools (sorted by name)", fkvh, indent=1)
               if (nb_poolf > 0) {
                  o=order(nm_poolf)
                  obj2kvh(covpf[o, o], "covariance free pools", fkvh, indent=1)
               }
            }
            rnm=names(poolall)
            mnm=matrix(unlist(strsplitlim(rnm, ":", fixed=TRUE, lim=2L)), ncol=2L, byrow=TRUE)
            o=natorder(mnm[, 2L])
            rnm=rnm[o]
            mnm=mnm[o,,drop=FALSE]
            pfc2cap=c(pf="F", pc="C")
            vsd=sdpf[rnm]
            vsd[is.na(vsd)]=0.
            dfp=cbind("", "", mnm[, 2L], "METAB", pfc2cap[mnm[,1L]], poolall[rnm], vsd, ifelse(vsd >= 10000., "no", "yes"))
            if (sensitive == "mc") {
               mci=ci_mc[nm_poolf, 1L:2L]
               mci=rbind(mci, cbind(poolall[nm_poolc], poolall[nm_poolc]))
               dfp=cbind(dfp, mci[rnm,])
            }
            df=rbind(df, dfp)
         }
         colnames(df)=cnm
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".tvar.sim")))
      }
   }

   # chi2 test for goodness of fit
   # goodness of fit (chi2 test)
   if (length(jx_f$res)) {
      if (is.na(rcost)) {
         cat(sprintf("***Warning: chi2: Reduced cost value is NA. Chi2 test cannot be done.\n"), sep="", file=fclog)
      } else {
         nvres=sum(!is.na(jx_f$res))
         if (nvres > nb_param) {
            chi2test=list("chi2 value"=rcost, "data points"=nvres,
               "fitted parameters"=nb_param, "degrees of freedom"=nvres-nb_param)
            chi2test$`chi2 reduced value`=chi2test$`chi2 value`/chi2test$`degrees of freedom`
            chi2test$`p-value, i.e. P(X^2<=value)`=pchisq(chi2test$`chi2 value`, df=chi2test$`degrees of freedom`)
            chi2test$conclusion=if (chi2test$`p-value, i.e. P(X^2<=value)` > 0.95) "At level of 95% confidence, the model does not fit the data good enough with respect to the provided measurement SD" else "At level of 95% confidence, the model fits the data good enough with respect to the provided measurement SD"
            if (write_res) {
               if (wkvh) obj2kvh(chi2test, "goodness of fit (chi2 test)", fkvh, indent=1)
               fstat=file(file.path(dirres, sprintf("%s%s.stat", baseshort,  runsuf)), "w")
               df=c(rcost, rcost/(nvres-nb_param), nvres, nb_param, nvres-nb_param, chi2test$`p-value, i.e. P(X^2<=value)`, chi2test$conclusion)
               names(df)=c("chi2_value", "chi2/df", "number_of_measurements", "number_of_parameters", "degrees_of_freedom", "p-value", "conclusion")
               write.table(df, sep="	", quote=FALSE, row.names=TRUE, file=fstat, col.names=FALSE)
               close(fstat)
            }
         } else {
            cat(sprintf("***Warning: chi2: Measurement number %d is lower or equal to parameter number %d. Chi2 test cannot be done.\n", nvres, nb_param), sep="", file=fclog)
         }
      }
   }
   if (prof) {
      Rprof(NULL)
   }
   if (write_res) {
      if (wkvh) close(fkvh)
      # write edge.netflux property
      fedge=file(file.path(dirres, "tmp", sprintf("edge.netflux.%s%s.attrs", baseshort,  runsuf)), "w")
      cat("netflux (class=Double)\n", sep="", file=fedge)
      nm_edge=names(edge2fl)
      cat(paste(nm_edge, fallnx[edge2fl], sep=" = "), sep="\n" , file=fedge)
      close(fedge)

      # write edge.xchflux property
      fedge=file(file.path(dirres, "tmp",  sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
      flxch=paste(".x", substring(edge2fl, 4), sep="")
      ifl=charmatch(flxch, substring(names(fallnx), 2))
      cat("xchflux (class=Double)\n", sep="", file=fedge)
      cat(paste(nm_edge, fallnx[ifl], sep=" = "), sep="\n" , file=fedge)
      close(fedge)

      # write node.log2pool property
      if (length(poolall)> 0) {
         fnode=file(file.path(dirres, "tmp", sprintf("node.log2pool.%s%s.attrs", baseshort,  runsuf)), "w")
         cat("log2pool (class=Double)\n", sep="", file=fnode)
         nm_node=substring(names(poolall), 4)
         cat(paste(nm_node, log2(poolall), sep=" = "), sep="\n" , file=fnode)
         close(fnode)
      }
   }
}
#browser()
if (!is.null(cl)) {
   stopCluster(cl)
   labargs$cl=cl=NULL
}

if (write_res) {
   pres=rbind(cost=costres, pres)
   fco=file(file.path(dirres, "tmp", sprintf("%s.pres.csv", baseshort)), open="w")
   cat("row_col	", file=fco)
   write.table(file=fco, pres, row.n=T, quot=F, sep="\t")
   close(fco)
}
if (TIMEIT) {
   cat("rend    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# source files from FTBL/posttreat_R
postlist=strsplit("plot_smeas.R", " *; *")[[1]]
for (post in postlist) {
   fpostR=file.path(dirw, post)
   if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
      source(fpostR)
   } else {
      # not found in 'dirw', try 'dirr'
      fpostR=file.path(dirr, post)
      if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
         source(fpostR)
      } else {
         cat(sprintf("***Warning: posttreatment R file '%s' does not exist in working directory neither in influx_si one. Ignored.\n", post), file=fclog)
      }
   }
}
xgc=gc(verbose=FALSE) # to avoid the message "Error in (function (x)  : tentative d'appliquer un objet qui n'est pas une fonction"
if (write_res) {
   close(fclog)
   close(fcerr)
}
retcode=max(retcode)
if (!interactive() && format(parent.frame()) == format(.GlobalEnv))
   q("no", status=retcode)
