# This is an automatically generated R code. Don't edit.
# Generated by 
# /home/sokol/.local/bin/influx_s --pref e_coli --pref e_coli_growth --pref ../prl_exp/mtf/e_coli_glc1-6n
# at Thu Dec 12 16:57:46 2024.

# Copyright 2011-2024, INRAE/INSA/CNRS, France.
    
# working dir
dirw="/home/sokol/sysbio/dev/ftbl2sys/influx_si/test/ok/mtf"

# result dir
dirres="/home/sokol/sysbio/dev/ftbl2sys/influx_si/test/ok/mtf/e_coli_res"
write_res=nchar(dirres) > 0L

# installation dir (where influx_si/R/*.R live)
dirr="/home/sokol/sysbio/dev/ftbl2sys/influx_si/R"
# short base name of the FTBL (withount '.ftbl')
baseshort="e_coli"

if (nchar(dirres)) {
    fcerr=file(file.path(dirres, sprintf("%s.err", baseshort)), "ab")
    fclog=file(file.path(dirres, sprintf("%s.log", baseshort)), "ab")
} else {
    fcerr=base::stderr()
    fclog=base::stdout()
}
if (options()$warn == 0)
    options(warn=1)
options(digits.secs=2)

case_i=FALSE

source(file.path(dirr, "libs.R"), echo=FALSE)

# define matprod for simple_triplet_matrix
`%stm%` = slam::matprod_simple_triplet_matrix

# default options
version=FALSE
noopt=FALSE
noscale=FALSE
meth="nlsic"
fullsys=FALSE
emu=FALSE
irand=FALSE
sens=""
cupx=0.999
cupn=1.e3
cupp=1.e5
clownr=0
cinout=0
clowp=1.e-8
np=0
ln=FALSE
tikhreg=FALSE
sln=FALSE
lim=FALSE
zc=-.Machine$double.xmax
ffguess=FALSE
fdfit=FALSE
addnoise=FALSE
fseries=""
iseries=""
seed=-.Machine$integer.max
excl_outliers=FALSE
TIMEIT=FALSE
prof=FALSE
time_order="1"
wkvh=FALSE
parR=FALSE
tol=1.e-10

# get runtime arguments
help='==SUPPRESS=='
version='==SUPPRESS=='
TIMEIT=TRUE
parR=TRUE

# synonymous
myver=version
optimize=!noopt
methods=trimws(strsplit(meth, ",")[[1L]])
sensitive=sens
least_norm=ln
initrand=irand

vernum="7.2.1.90"

# sanity check for command line parameters
if (substring(sensitive, 1, 3)=="mc=") {
   # read the mc iteration number
   nmc=as.integer(substring(sensitive, 4))
   sensitive="mc"
} else if (sensitive=="mc") {
   nmc=10
} else if (nchar(sensitive) > 0L) {
   stop_mes("Option '--sens SENS' got unknown argument SENS '", sensitive,"'\n",
      "Expected 'mc[=N]' where optional N is a number of Monter-Carlo iterations", file=fcerr)
}
# cupx==0 means no upper limit => cupx=1
cupx=ifelse(cupx, cupx, 1)
if (cupx < 0 || cupx > 1) {
   stop_mes("Option '--cupx N' must have N in the interval [0,1]\n",
      "Instead, the value ", cupx, " is given.", file=fcerr)
}
if (cinout < 0) {
   stop_mes("Option '--cinout N' must have N non negative\n",
      "Instead, the value ", cinout, " is given.", file=fcerr)
}
# minimization method
validmethods=c("BFGS", "Nelder-Mead", "SANN", "ipopt", "nlsic", "pso")
if (! all(igood <- (methods %in% validmethods))) {
   cat(paste("***Warning: optimization methods ", paste0(methods[!igood], collapse=", "), " are not implemented. 'nlsic' is used instead."), "\n", sep="", file=fclog)
   methods[!igood]="nlsic"
}
if ("ipopt" %in% methods) {
   installed=suppressPackageStartupMessages(library(ipoptr, logical.return=TRUE))
   if (!installed) {
      stop_mes("An optimization method ipopt is requested but not available in this R installation", file=fcerr)
   }
}
if (least_norm && sln) {
   stop_mes("Options --ln and --sln cannot be activated simultaniously.", file=fcerr)
}

avaco=try(detectCores(), silent=TRUE)
if (inherits(avaco, "try-error")) {
   avaco=NULL
}
if (np > 0L && np < 1L) {
   np=round(avaco*np)
} else if (np >= 1L) {
   np=round(np)
} else {
   np=avaco
}
if (is.null(np) || np <= 0L) {
   np=1L
}
if (sensitive=="mc") {
   np=min(np, nmc)
}
options(mc.cores=np)

if (least_norm+tikhreg+lim > 1) {
   stop_mes("Options --ln, --lim and --tikhreg cannot be activated simultaneously. Use only one of them at a time.", file=fcerr)
}
lsi_fun=lsi
if (least_norm || sln) {
   lsi_fun=lsi_ln
} else if (tikhreg) {
   lsi_fun=lsi_reg
} else if (lim) {
   suppressPackageStartupMessages(library(limSolve));
   lsi_fun=lsi_lim
}
if (zc==-.Machine$double.xmax) {
   # no zero scrossing to apply
   zerocross=F
} else {
   if (zc < 0.) {
      stop_mes("Zero crossing value ZC must be non negative, instead ", zc, " is given.", file=fcerr)
   }
   zerocross=T
}
if (seed==-.Machine$integer.max) {
   # no seed to apply
   set_seed=F
} else {
   set_seed=T
   set.seed(seed)
}
time_order=gsub("\\s", "", time_order) # remove spaces if any
if (!(time_order %in% c("1", "2", "1,2"))) {
   stop_mes("time_order must be '1', '2' or '1,2'. Instead got '", time_order, "'", file=fcerr)
}
opts=commandArgs()
# end command line argument proceeding

# get some cumomer tools
source(file.path(dirr, "opt_cumo_tools.R"))
#loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))

lab_resid=cumo_resid
lab_sim=param2fl_x
jx_f=new.env()
    control_ftbl=list(`default`=list())
if (TIMEIT) {
   cat("rinit   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# R profiling
if (prof)
   Rprof(file.path(dirw, sprintf("%s.Rprof", baseshort)))

nm_list=list()
nb_f=list()

if (TIMEIT) {
   cat("r_flux  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# fwd-rev flux names
nm_fwrv=c("fwd.Glucupt_1", "fwd.Glucupt_U", "fwd.akgdh", "fwd.ald", "fwd.bs_DHAP", "fwd.bs_accoa", "fwd.bs_accoa_aux",
"fwd.bs_akg", "fwd.bs_akg1", "fwd.bs_akg2", "fwd.bs_akg3", "fwd.bs_akg4", "fwd.bs_akg4_aux", "fwd.bs_e4p",
"fwd.bs_fru6P", "fwd.bs_glc6P", "fwd.bs_oaa", "fwd.bs_oaa1", "fwd.bs_oaa1_aux", "fwd.bs_oaa2", "fwd.bs_oaa2_aux",
"fwd.bs_oaa3_aux", "fwd.bs_oaa3a", "fwd.bs_oaa3b", "fwd.bs_oaa4", "fwd.bs_oaa5", "fwd.bs_oaa5_aux", "fwd.bs_oaa6",
"fwd.bs_oaa6_aux", "fwd.bs_oaa7", "fwd.bs_oaa7_aux", "fwd.bs_pep", "fwd.bs_pep1", "fwd.bs_pep2", "fwd.bs_pep3_aux",
"fwd.bs_pep3a", "fwd.bs_pep3b", "fwd.bs_pep4_aux", "fwd.bs_pep4a", "fwd.bs_pep4b", "fwd.bs_pep5", "fwd.bs_pep6",
"fwd.bs_pep6_aux", "fwd.bs_pep7", "fwd.bs_pga", "fwd.bs_pga1", "fwd.bs_pga1_aux", "fwd.bs_pga2", "fwd.bs_pga2_aux",
"fwd.bs_pga3", "fwd.bs_pga3_aux", "fwd.bs_pga_aux", "fwd.bs_pyr", "fwd.bs_pyr1", "fwd.bs_pyr1_aux", "fwd.bs_pyr2",
"fwd.bs_pyr3", "fwd.bs_pyr3_aux", "fwd.bs_pyr4", "fwd.bs_pyr4_aux", "fwd.bs_rib5p", "fwd.bs_rib5p1",
"fwd.bs_rib5p1_aux", "fwd.bs_rib5p2", "fwd.citsynth", "fwd.edd", "fwd.eno", "fwd.fum_a", "fwd.fum_b", "fwd.gnd",
"fwd.idh", "fwd.mae", "fwd.maldh", "fwd.out_Ac", "fwd.out_FTHF", "fwd.out_co2", "fwd.pdh", "fwd.pfk", "fwd.pgi",
"fwd.pgk", "fwd.ppc", "fwd.pyk", "fwd.ta", "fwd.tk1", "fwd.tk2", "fwd.zwf", "rev.Glucupt_1", "rev.Glucupt_U",
"rev.akgdh", "rev.ald", "rev.bs_DHAP", "rev.bs_accoa", "rev.bs_accoa_aux", "rev.bs_akg", "rev.bs_akg1", "rev.bs_akg2",
"rev.bs_akg3", "rev.bs_akg4", "rev.bs_akg4_aux", "rev.bs_e4p", "rev.bs_fru6P", "rev.bs_glc6P", "rev.bs_oaa",
"rev.bs_oaa1", "rev.bs_oaa1_aux", "rev.bs_oaa2", "rev.bs_oaa2_aux", "rev.bs_oaa3_aux", "rev.bs_oaa3a", "rev.bs_oaa3b",
"rev.bs_oaa4", "rev.bs_oaa5", "rev.bs_oaa5_aux", "rev.bs_oaa6", "rev.bs_oaa6_aux", "rev.bs_oaa7", "rev.bs_oaa7_aux",
"rev.bs_pep", "rev.bs_pep1", "rev.bs_pep2", "rev.bs_pep3_aux", "rev.bs_pep3a", "rev.bs_pep3b", "rev.bs_pep4_aux",
"rev.bs_pep4a", "rev.bs_pep4b", "rev.bs_pep5", "rev.bs_pep6", "rev.bs_pep6_aux", "rev.bs_pep7", "rev.bs_pga",
"rev.bs_pga1", "rev.bs_pga1_aux", "rev.bs_pga2", "rev.bs_pga2_aux", "rev.bs_pga3", "rev.bs_pga3_aux", "rev.bs_pga_aux",
"rev.bs_pyr", "rev.bs_pyr1", "rev.bs_pyr1_aux", "rev.bs_pyr2", "rev.bs_pyr3", "rev.bs_pyr3_aux", "rev.bs_pyr4",
"rev.bs_pyr4_aux", "rev.bs_rib5p", "rev.bs_rib5p1", "rev.bs_rib5p1_aux", "rev.bs_rib5p2", "rev.citsynth", "rev.edd",
"rev.eno", "rev.fum_a", "rev.fum_b", "rev.gnd", "rev.idh", "rev.mae", "rev.maldh", "rev.out_Ac", "rev.out_FTHF",
"rev.out_co2", "rev.pdh", "rev.pfk", "rev.pgi", "rev.pgk", "rev.ppc", "rev.pyk", "rev.ta", "rev.tk1", "rev.tk2",
"rev.zwf")

# edge to netflux name translator
edge2fl=c("f.n.Glucupt_1", "d.n.Glucupt_U", "d.n.pgi", "d.n.pfk", "d.n.ald", "d.n.ald", "d.n.ald", "d.n.pgk", "d.n.eno",
"f.n.pyk", "f.n.zwf", "f.n.gnd", "f.n.gnd", "f.n.gnd", "d.n.edd", "d.n.edd", "d.n.edd", "d.n.ta", "d.n.ta", "d.n.ta",
"d.n.ta", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.tk2", "d.n.tk2", "d.n.tk2", "d.n.tk2", "d.n.pdh", "d.n.pdh",
"d.n.pdh", "d.n.citsynth", "d.n.citsynth", "d.n.citsynth", "d.n.idh", "d.n.idh", "d.n.idh", "d.n.akgdh", "d.n.akgdh",
"d.n.akgdh", "d.n.fum_a", "d.n.fum_b", "d.n.maldh", "d.n.ppc", "d.n.ppc", "d.n.ppc", "d.n.mae", "d.n.mae", "d.n.mae",
"c.n.bs_glc6P", "c.n.bs_fru6P", "c.n.bs_pga", "d.n.bs_pga_aux", "d.n.bs_pga1", "c.n.bs_pga1_aux", "d.n.bs_pga2",
"c.n.bs_pga2_aux", "d.n.bs_pga3", "d.n.bs_pga3", "d.n.bs_pga3", "c.n.bs_pga3_aux", "c.n.bs_DHAP", "c.n.bs_pyr",
"d.n.bs_pyr1", "d.n.bs_pyr1_aux", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr4",
"c.n.bs_pyr4_aux", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "c.n.bs_pyr3_aux", "d.n.bs_e4p",
"c.n.bs_rib5p", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "c.n.bs_rib5p1_aux", "d.n.bs_rib5p2", "c.n.bs_pep",
"d.n.bs_pep1", "d.n.bs_pep1", "d.n.bs_pep1", "d.n.bs_pep2", "d.n.bs_pep2", "d.n.bs_pep2", "d.n.bs_pep3a",
"d.n.bs_pep3a", "d.n.bs_pep3a", "d.n.bs_pep3b", "d.n.bs_pep3b", "d.n.bs_pep3b", "c.n.bs_pep3_aux", "d.n.bs_pep4a",
"d.n.bs_pep4a", "d.n.bs_pep4a", "d.n.bs_pep4b", "d.n.bs_pep4b", "d.n.bs_pep4b", "c.n.bs_pep4_aux", "c.n.bs_pep5",
"d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6_aux", "d.n.bs_pep7", "d.n.bs_pep7",
"d.n.bs_pep7", "c.n.bs_accoa", "d.n.bs_accoa_aux", "c.n.bs_akg", "d.n.bs_akg1", "c.n.bs_akg2", "c.n.bs_akg3",
"d.n.bs_akg4", "d.n.bs_akg4", "d.n.bs_akg4", "d.n.bs_akg4_aux", "c.n.bs_oaa", "d.n.bs_oaa1", "c.n.bs_oaa1_aux",
"d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "c.n.bs_oaa2_aux", "d.n.bs_oaa3a", "d.n.bs_oaa3a",
"d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "c.n.bs_oaa3_aux",
"d.n.bs_oaa4", "d.n.bs_oaa5", "c.n.bs_oaa5_aux", "d.n.bs_oaa6", "d.n.bs_oaa6", "d.n.bs_oaa6", "c.n.bs_oaa6_aux",
"d.n.bs_oaa7", "c.n.bs_oaa7_aux", "d.n.out_co2", "f.n.out_Ac", "d.n.out_FTHF")
names(edge2fl)=c("Gluc_1 (Glucupt_1) Glc6P", "Gluc_U (Glucupt_U) Glc6P", "Glc6P (pgi) Fru6P", "Fru6P (pfk) FruBP", "FruBP (ald) ald",
"ald (ald1) GA3P", "ald (ald2) GA3P", "GA3P (pgk) PGA", "PGA (eno) PEP", "PEP (pyk) Pyr", "Glc6P (zwf) Gnt6P", "Gnt6P
(gnd) gnd", "gnd (gnd) CO2", "gnd (gnd) Rib5P", "Gnt6P (edd) edd", "edd (edd) Pyr", "edd (edd) GA3P", "GA3P (ta) ta",
"Sed7P (ta) ta", "ta (ta) Ery4P", "ta (ta) Fru6P", "Rib5P (tk11) tk1", "Rib5P (tk12) tk1", "tk1 (tk1) GA3P", "tk1 (tk1)
Sed7P", "Rib5P (tk2) tk2", "Ery4P (tk2) tk2", "tk2 (tk2) GA3P", "tk2 (tk2) Fru6P", "Pyr (pdh) pdh", "pdh (pdh) AcCoA",
"pdh (pdh) CO2", "AcCoA (citsynth) citsynth", "OAA (citsynth) citsynth", "citsynth (citsynth) ICit", "ICit (idh) idh",
"idh (idh) AKG", "idh (idh) CO2", "AKG (akgdh) akgdh", "akgdh (akgdh) Suc", "akgdh (akgdh) CO2", "Suc (fum_a) Mal", "Suc
(fum_b) Mal", "Mal (maldh) OAA", "PEP (ppc) ppc", "CO2 (ppc) ppc", "ppc (ppc) OAA", "Mal (mae) mae", "mae (mae) Pyr",
"mae (mae) CO2", "Glc6P (bs_glc6P) BM_Glc6P", "Fru6P (bs_fru6P) BM_Fru6P", "PGA (bs_pga) BM_PGA", "BM_PGA (bs_pga_aux)
PGA_Aux", "BM_PGA (bs_pga1) Ser", "Ser (bs_pga1_aux) Ser_Aux", "Ser (bs_pga2) Cys", "Cys (bs_pga2_aux) Cys_Aux", "Ser
(bs_pga3) bs_pga3", "bs_pga3 (bs_pga3) Gly", "bs_pga3 (bs_pga3) FTHF", "Gly (bs_pga3_aux) Gly_Aux", "GA3P (bs_DHAP)
Glp", "Pyr (bs_pyr) BM_Pyr", "BM_Pyr (bs_pyr1) Ala", "Ala (bs_pyr1_aux) Ala_Aux", "BM_Pyr (bs_pyr21) bs_pyr2", "BM_Pyr
(bs_pyr22) bs_pyr2", "bs_pyr2 (bs_pyr2) AKV", "bs_pyr2 (bs_pyr2) CO2", "AKV (bs_pyr4) Val", "Val (bs_pyr4_aux) Val_Aux",
"AKV (bs_pyr3) bs_pyr3", "BM_AcCoA (bs_pyr3) bs_pyr3", "bs_pyr3 (bs_pyr3) Leu", "bs_pyr3 (bs_pyr3) CO2", "Leu
(bs_pyr3_aux) Leu_Aux", "Ery4P (bs_e4p) BM_Ery4P", "Rib5P (bs_rib5p) BM_Rib5P", "BM_Rib5P (bs_rib5p1) bs_rib5p1", "FTHF
(bs_rib5p1) bs_rib5p1", "bs_rib5p1 (bs_rib5p1) His", "His (bs_rib5p1_aux) His_Aux", "BM_Rib5P (bs_rib5p2) Ri5P_Aux",
"PEP (bs_pep) BM_PEP", "BM_PEP (bs_pep1) bs_pep1", "BM_Ery4P (bs_pep1) bs_pep1", "bs_pep1 (bs_pep1) DAHP", "BM_PEP
(bs_pep2) bs_pep2", "DAHP (bs_pep2) bs_pep2", "bs_pep2 (bs_pep2) Chor", "Chor (bs_pep3a) bs_pep3a", "bs_pep3a (bs_pep3a)
Phe", "bs_pep3a (bs_pep3a) CO2", "Chor (bs_pep3b) bs_pep3b", "bs_pep3b (bs_pep3b) Phe", "bs_pep3b (bs_pep3b) CO2", "Phe
(bs_pep3_aux) Phe_Aux", "Chor (bs_pep4a) bs_pep4a", "bs_pep4a (bs_pep4a) Tyr", "bs_pep4a (bs_pep4a) CO2", "Chor
(bs_pep4b) bs_pep4b", "bs_pep4b (bs_pep4b) Tyr", "bs_pep4b (bs_pep4b) CO2", "Tyr (bs_pep4_aux) Tyr_Aux", "BM_PEP
(bs_pep5) PEP_Aux", "Chor (bs_pep6) bs_pep6", "BM_Rib5P (bs_pep6) bs_pep6", "bs_pep6 (bs_pep6) Trp", "bs_pep6 (bs_pep6)
PyrCO2", "Trp (bs_pep6_aux) Trp_Aux", "PyrCO2 (bs_pep7) bs_pep7", "bs_pep7 (bs_pep7) Pyr", "bs_pep7 (bs_pep7) CO2",
"AcCoA (bs_accoa) BM_AcCoA", "BM_AcCoA (bs_accoa_aux) AcCoA_Aux", "AKG (bs_akg) BM_AKG", "BM_AKG (bs_akg1) Glu", "Glu
(bs_akg2) Pro", "Glu (bs_akg3) Gln", "Glu (bs_akg4) bs_akg4", "CO2 (bs_akg4) bs_akg4", "bs_akg4 (bs_akg4) Arg", "Arg
(bs_akg4_aux) Arg_Aux", "OAA (bs_oaa) BM_OAA", "BM_OAA (bs_oaa1) Asp", "Asp (bs_oaa1_aux) Asp_Aux", "Thr (bs_oaa2)
bs_oaa2", "BM_Pyr (bs_oaa2) bs_oaa2", "bs_oaa2 (bs_oaa2) Ile", "bs_oaa2 (bs_oaa2) CO2", "Ile (bs_oaa2_aux) Ile_Aux",
"BM_OAA (bs_oaa3a) bs_oaa3a", "BM_Pyr (bs_oaa3a) bs_oaa3a", "bs_oaa3a (bs_oaa3a) Lys", "bs_oaa3a (bs_oaa3a) CO2",
"BM_OAA (bs_oaa3b) bs_oaa3b", "BM_Pyr (bs_oaa3b) bs_oaa3b", "bs_oaa3b (bs_oaa3b) Lys", "bs_oaa3b (bs_oaa3b) CO2", "Lys
(bs_oaa3_aux) Lys_Aux", "BM_OAA (bs_oaa4) OAA_Aux", "BM_OAA (bs_oaa5) Thr", "Thr (bs_oaa5_aux) Thr_Aux", "BM_OAA
(bs_oaa6) bs_oaa6", "FTHF (bs_oaa6) bs_oaa6", "bs_oaa6 (bs_oaa6) Met", "Met (bs_oaa6_aux) Met_Aux", "BM_OAA (bs_oaa7)
Asn", "Asn (bs_oaa7_aux) Asn_Aux", "CO2 (out_co2) CO2_out", "AcCoA (out_Ac) Acetate", "FTHF (out_FTHF) FTHF_out")

# initialize the linear system Afl*flnx=bfl (0-weight cumomers)
# unknown net flux names
nm_fln=c("d.n.Glucupt_U", "d.n.akgdh", "d.n.ald", "d.n.bs_accoa_aux", "d.n.bs_akg1", "d.n.bs_akg4", "d.n.bs_akg4_aux",
"d.n.bs_e4p", "d.n.bs_oaa1", "d.n.bs_oaa2", "d.n.bs_oaa3a", "d.n.bs_oaa3b", "d.n.bs_oaa4", "d.n.bs_oaa5", "d.n.bs_oaa6",
"d.n.bs_oaa7", "d.n.bs_pep1", "d.n.bs_pep2", "d.n.bs_pep3a", "d.n.bs_pep3b", "d.n.bs_pep4a", "d.n.bs_pep4b",
"d.n.bs_pep6", "d.n.bs_pep6_aux", "d.n.bs_pep7", "d.n.bs_pga1", "d.n.bs_pga2", "d.n.bs_pga3", "d.n.bs_pga_aux",
"d.n.bs_pyr1", "d.n.bs_pyr1_aux", "d.n.bs_pyr2", "d.n.bs_pyr3", "d.n.bs_pyr4", "d.n.bs_rib5p1", "d.n.bs_rib5p2",
"d.n.citsynth", "d.n.edd", "d.n.eno", "d.n.fum_a", "d.n.fum_b", "d.n.idh", "d.n.mae", "d.n.maldh", "d.n.out_FTHF",
"d.n.out_co2", "d.n.pdh", "d.n.pfk", "d.n.pgi", "d.n.pgk", "d.n.ppc", "d.n.ta", "d.n.tk1", "d.n.tk2")
nb_fln=length(nm_fln)
fln=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
names(fln)=nm_fln
# unknown xch flux names
nm_flx=c("d.x.fum_b")
nb_flx=length(nm_flx)
flx=c(0.0)
names(flx)=nm_flx
nm_fl=c(nm_fln, nm_flx)
nb_fl=nb_fln+nb_flx
fl=c(fln, flx)
# gather flux names in a list
nm_list$flnx=nm_fl
nm_list$fwrv=nm_fwrv

# carbon length of metabolites
clen=c(6,6,6,6,6,3,3,3,3,6,1,5,7,4,2,4,6,5,4,4,6,6,3,3,3,3,3,3,2,1,2,3,3,3,3,5,5,5,2,6,6,4,5,6,6,5,3,7,10,9,9,9,9,3,11,4,11,2,5,5,5,5,6,6,4,4,4,4,6,6,6,6,4,4,5,5,4,4,1,2,1)
names(clen)=c("Gluc_1","Glc6P","Gluc_U","Fru6P","FruBP","GA3P","PGA","PEP","Pyr","Gnt6P","CO2","Rib5P","Sed7P","Ery4P","AcCoA","OAA","ICit","AKG","Suc","Mal","BM_Glc6P","BM_Fru6P","BM_PGA","PGA_Aux","Ser","Ser_Aux","Cys","Cys_Aux","Gly","FTHF","Gly_Aux","Glp","BM_Pyr","Ala","Ala_Aux","AKV","Val","Val_Aux","BM_AcCoA","Leu","Leu_Aux","BM_Ery4P","BM_Rib5P","His","His_Aux","Ri5P_Aux","BM_PEP","DAHP","Chor","Phe","Phe_Aux","Tyr","Tyr_Aux","PEP_Aux","Trp","PyrCO2","Trp_Aux","AcCoA_Aux","BM_AKG","Glu","Pro","Gln","Arg","Arg_Aux","BM_OAA","Asp","Asp_Aux","Thr","Ile","Ile_Aux","Lys","Lys_Aux","OAA_Aux","Thr_Aux","Met","Met_Aux","Asn","Asn_Aux","CO2_out","Acetate","FTHF_out")

# metabolite pools are : all (poolall) which is divided in free (poolf) and
# constrained (poolc)

# constrained pool
poolc=c()
nm_poolc=c()
if (length(nm_poolc)) {
   names(nm_poolc)=substring(nm_poolc, 4)
}
names(poolc)=nm_poolc

# starting values for free pool (the same number and the same alphabetic order than free growth fluxes, if present)
poolf=c()
nm_poolf=c()
if (length(nm_poolf)) {
   names(nm_poolf)=substring(nm_poolf, 4)
}
names(poolf)=nm_poolf
nb_poolf=length(poolf)
nb_f$nb_poolf=nb_poolf

nm_poolall=c(nm_poolf, nm_poolc)
poolall=as.numeric(c(poolf, poolc))
names(poolall)=nm_poolall
pool=poolall
nm_list$poolf=nm_poolf
nm_list$poolc=nm_poolc
nm_list$poolall=nm_poolall

# flux matrix
nb_flr=55
if (nb_fl) {
   Afl=matrix(0, nrow=nb_flr, ncol=nb_fl)
       Afl[1, c(1, 49)]=c(1.0, -1.0)
           Afl[2, c(48, 49, 52, 54)]=c(-1.0, 1.0, 1.0, 1.0)
           Afl[3, c(3, 48)]=c(-1.0, 1.0)
           Afl[4, c(3, 38, 50, 52, 53, 54)]=c(2.0, 1.0, -1.0, -1.0, 1.0, 1.0)
           Afl[5, c(39, 50)]=c(-1.0, 1.0)
           Afl[6, c(39, 51)]=c(1.0, -1.0)
           Afl[7, c(25, 38, 43, 47)]=c(1.0, 1.0, 1.0, -1.0)
           Afl[8, c(38)]=c(-1.0)
           Afl[9, c(2, 6, 10, 11, 12, 19, 20, 21, 22, 25, 32, 33, 42, 43, 46, 47, 51)]=c(1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0)
           Afl[10, c(53, 54)]=c(-2.0, -1.0)
           Afl[11, c(52, 53)]=c(-1.0, 1.0)
           Afl[12, c(8, 52, 54)]=c(-1.0, 1.0, -1.0)
           Afl[13, c(37, 47)]=c(-1.0, 1.0)
           Afl[14, c(37, 44, 51)]=c(-1.0, 1.0, 1.0)
           Afl[15, c(37, 42)]=c(1.0, -1.0)
           Afl[16, c(2, 42)]=c(-1.0, 1.0)
           Afl[17, c(2, 40, 41)]=c(1.0, -1.0, -1.0)
           Afl[18, c(40, 41, 43, 44)]=c(1.0, 1.0, -1.0, -1.0)
           Afl[19, c(26, 29)]=c(-1.0, -1.0)
           Afl[20, c(26, 27, 28)]=c(1.0, -1.0, -1.0)
           Afl[21, c(27)]=c(1.0)
           Afl[22, c(28)]=c(1.0)
           Afl[23, c(15, 28, 35, 45)]=c(-1.0, 1.0, -1.0, -1.0)
           Afl[24, c(10, 11, 12, 30, 32)]=c(-1.0, -1.0, -1.0, -1.0, -2.0)
           Afl[25, c(30, 31)]=c(1.0, -1.0)
           Afl[26, c(32, 33, 34)]=c(1.0, -1.0, -1.0)
           Afl[27, c(34)]=c(1.0)
           Afl[28, c(4, 33)]=c(-1.0, -1.0)
           Afl[29, c(33)]=c(1.0)
           Afl[30, c(8, 17)]=c(1.0, -1.0)
           Afl[31, c(23, 35, 36)]=c(-1.0, -1.0, -1.0)
           Afl[32, c(35)]=c(1.0)
           Afl[33, c(17, 18)]=c(-1.0, -1.0)
           Afl[34, c(17, 18)]=c(1.0, -1.0)
           Afl[35, c(18, 19, 20, 21, 22, 23)]=c(1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
           Afl[36, c(19, 20)]=c(1.0, 1.0)
           Afl[37, c(21, 22)]=c(1.0, 1.0)
           Afl[38, c(23, 24)]=c(1.0, -1.0)
           Afl[39, c(23, 25)]=c(1.0, -1.0)
           Afl[40, c(5)]=c(-1.0)
           Afl[41, c(5, 6)]=c(1.0, -1.0)
           Afl[42, c(6, 7)]=c(1.0, -1.0)
           Afl[43, c(9, 11, 12, 13, 14, 15, 16)]=c(-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
           Afl[44, c(9)]=c(1.0)
           Afl[45, c(10, 14)]=c(-1.0, 1.0)
           Afl[46, c(10)]=c(1.0)
           Afl[47, c(11, 12)]=c(1.0, 1.0)
           Afl[48, c(15)]=c(1.0)
           Afl[49, c(16)]=c(1.0)
           Afl[50, c(1)]=c(1.0)
           Afl[51, c(11, 12)]=c(1.0, -1.0)
           Afl[52, c(19, 20)]=c(1.0, -1.0)
           Afl[53, c(21, 22)]=c(1.0, -1.0)
           Afl[54, c(40, 41)]=c(1.0, -1.0)
           Afl[55, c(55)]=c(-1.0)
        } else {
   Afl=matrix(0., nb_fl, nb_fl)
}
dimnames(Afl)=list(c("Glc6P", "Fru6P", "FruBP", "GA3P", "PGA", "PEP", "Pyr", "Gnt6P", "CO2", "Rib5P", "Sed7P", "Ery4P", "AcCoA", "OAA",
"ICit", "AKG", "Suc", "Mal", "BM_PGA", "Ser", "Cys", "Gly", "FTHF", "BM_Pyr", "Ala", "AKV", "Val", "BM_AcCoA", "Leu",
"BM_Ery4P", "BM_Rib5P", "His", "BM_PEP", "DAHP", "Chor", "Phe", "Tyr", "Trp", "PyrCO2", "BM_AKG", "Glu", "Arg",
"BM_OAA", "Asp", "Thr", "Ile", "Lys", "Met", "Asn", "eq net: Glucupt_1+Glucupt_U=1: 367", "eq net: bs_oaa3a-bs_oaa3b=0:
368", "eq net: bs_pep3a-bs_pep3b=0: 369", "eq net: bs_pep4a-bs_pep4b=0: 370", "eq net: fum_a-fum_b=0: 371", "eq xch:
fum_a-fum_b=0: 374"), nm_fl)
#browser()
# prepare param (Theta) vector
# order: free flux net, free flux xch, scale label, scale mass, scale peak
param=numeric(0)
nm_par=c()
# free net fluxes
nb_ffn=5
nm_ffn=c("f.n.Glucupt_1", "f.n.gnd", "f.n.out_Ac", "f.n.pyk", "f.n.zwf")
# starting values for iterations
param=c(param, c(0.7, 0.15062, 0.213, 1.4, 0.2))
if (nb_ffn) {
   nm_par=c(nm_par, nm_ffn)
}
# free xch fluxes
nb_ffx=7
nm_ffx=c("f.x.ald", "f.x.eno", "f.x.fum_a", "f.x.ppc", "f.x.ta", "f.x.tk1", "f.x.tk2")
# starting values for iterations
param=c(param, c(0.413926, 0.800962, 0.395958, 0.256772, 0.359468, 0.166316, 0.00211559))
if (nb_ffx) {
   nm_par=c(nm_par, nm_ffx)
}
names(param)=nm_par
ff=param
nm_ff=c(nm_ffn, nm_ffx)
nm_list$ff=nm_ff
nb_param=length(param)
# scaling factors are added to param later

nb_ff=nb_ffn+nb_ffx

# constrained fluxes
# net
nb_fcn=27
nm_fcn=c("c.n.bs_DHAP", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_akg2", "c.n.bs_akg3", "c.n.bs_fru6P", "c.n.bs_glc6P", "c.n.bs_oaa",
"c.n.bs_oaa1_aux", "c.n.bs_oaa2_aux", "c.n.bs_oaa3_aux", "c.n.bs_oaa5_aux", "c.n.bs_oaa6_aux", "c.n.bs_oaa7_aux",
"c.n.bs_pep", "c.n.bs_pep3_aux", "c.n.bs_pep4_aux", "c.n.bs_pep5", "c.n.bs_pga", "c.n.bs_pga1_aux", "c.n.bs_pga2_aux",
"c.n.bs_pga3_aux", "c.n.bs_pyr", "c.n.bs_pyr3_aux", "c.n.bs_pyr4_aux", "c.n.bs_rib5p", "c.n.bs_rib5p1_aux")
fcn=c(0.0068, 0.1565, 0.0571, 0.0111, 0.0132, 0.0038, 0.0109, 0.0947, 0.0121, 0.0146, 0.0173, 0.0128, 0.0077, 0.0121, 0.0381,
0.0093, 0.0069, 0.0027, 0.0791, 0.0109, 0.0046, 0.0308, 0.1501, 0.0227, 0.0213, 0.0476, 0.0048)
# xch
nb_fcx=78
nm_fcx=c("c.x.Glucupt_1", "c.x.Glucupt_U", "c.x.akgdh", "c.x.bs_DHAP", "c.x.bs_accoa", "c.x.bs_accoa_aux", "c.x.bs_akg",
"c.x.bs_akg1", "c.x.bs_akg2", "c.x.bs_akg3", "c.x.bs_akg4", "c.x.bs_akg4_aux", "c.x.bs_e4p", "c.x.bs_fru6P",
"c.x.bs_glc6P", "c.x.bs_oaa", "c.x.bs_oaa1", "c.x.bs_oaa1_aux", "c.x.bs_oaa2", "c.x.bs_oaa2_aux", "c.x.bs_oaa3_aux",
"c.x.bs_oaa3a", "c.x.bs_oaa3b", "c.x.bs_oaa4", "c.x.bs_oaa5", "c.x.bs_oaa5_aux", "c.x.bs_oaa6", "c.x.bs_oaa6_aux",
"c.x.bs_oaa7", "c.x.bs_oaa7_aux", "c.x.bs_pep", "c.x.bs_pep1", "c.x.bs_pep2", "c.x.bs_pep3_aux", "c.x.bs_pep3a",
"c.x.bs_pep3b", "c.x.bs_pep4_aux", "c.x.bs_pep4a", "c.x.bs_pep4b", "c.x.bs_pep5", "c.x.bs_pep6", "c.x.bs_pep6_aux",
"c.x.bs_pep7", "c.x.bs_pga", "c.x.bs_pga1", "c.x.bs_pga1_aux", "c.x.bs_pga2", "c.x.bs_pga2_aux", "c.x.bs_pga3",
"c.x.bs_pga3_aux", "c.x.bs_pga_aux", "c.x.bs_pyr", "c.x.bs_pyr1", "c.x.bs_pyr1_aux", "c.x.bs_pyr2", "c.x.bs_pyr3",
"c.x.bs_pyr3_aux", "c.x.bs_pyr4", "c.x.bs_pyr4_aux", "c.x.bs_rib5p", "c.x.bs_rib5p1", "c.x.bs_rib5p1_aux",
"c.x.bs_rib5p2", "c.x.citsynth", "c.x.edd", "c.x.gnd", "c.x.idh", "c.x.mae", "c.x.maldh", "c.x.out_Ac", "c.x.out_FTHF",
"c.x.out_co2", "c.x.pdh", "c.x.pfk", "c.x.pgi", "c.x.pgk", "c.x.pyk", "c.x.zwf")
fcx=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
0.011799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.647115, 0.0,
0.0, 0.0, 0.0322745, 0.0, 0.752386, 0.984718, 0.0109591, 0.0)
fc=c(fcn, fcx)
nm_fc=c(nm_fcn, nm_fcx)
names(fc)=nm_fc
nb_fc=nb_fcn+nb_fcx

# variable growth fluxes (constant are already accounted in constrained fluxes)
nb_fgr=0
nm_fgr=c()
fgr=c()
nm_list$fgr=nm_fgr
nb_f$nb_fgr=nb_fgr

# total flux vector fallnx dimension
nb_fallnx=nb_fl+nb_ff+nb_fc+nb_fgr+nb_fgr
nb_fwrv=nb_fallnx

# net dependent and free fluxes
nm_dfn=c(nm_fln, nm_ffn)
names(nm_dfn)=substring(nm_dfn, 5)

# all flux cardinals
nb_f=append(nb_f, list(nb_fln=nb_fln, nb_flx=nb_flx, nb_fl=nb_fl,
   nb_ffn=nb_ffn, nb_ffx=nb_ffx, nb_ff=nb_ff,
   nb_fcn=nb_fcn, nb_fcx=nb_fcx, nb_fc=nb_fc,
   nb_fallnx=nb_fallnx, nb_fwrv=nb_fwrv,
   nb_fgr=nb_fgr,
   include_growth_flux=FALSE,
   mu=NULL))
    
# prepare p2bfl, c2bfl, g2bfl, cnst2bfl matrices such that p2bfl%*%param[1:nb_ff]+
# c2bfl%*%fc+g2bfl%*%fgr+cnst2bfl=bfl
# replace f.[nx].flx by corresponding param coefficient
p2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_ff)
# replace c.[nx].flx by corresponding fc coefficient
c2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fc)
# variable growth fluxes
g2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fgr)
cnst2bfl=numeric(nb_flr); # may be coming from equalities
colnames(p2bfl)=nm_par
colnames(c2bfl)=nm_fc
colnames(g2bfl)=nm_fgr

p2bfl[1, pmatch(c("f.n.zwf", "f.n.Glucupt_1"), nm_par)]=c(1.0, -1.0);
c2bfl[1, pmatch(c("c.n.bs_glc6P"), nm_fc)]=c(1.0);

c2bfl[2, pmatch(c("c.n.bs_fru6P"), nm_fc)]=c(1.0);

c2bfl[4, pmatch(c("c.n.bs_DHAP"), nm_fc)]=c(1.0);

c2bfl[5, pmatch(c("c.n.bs_pga"), nm_fc)]=c(1.0);

p2bfl[6, pmatch(c("f.n.pyk"), nm_par)]=c(1.0);
c2bfl[6, pmatch(c("c.n.bs_pep"), nm_fc)]=c(1.0);

p2bfl[7, pmatch(c("f.n.pyk"), nm_par)]=c(-1.0);
c2bfl[7, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(1.0);

p2bfl[8, pmatch(c("f.n.gnd", "f.n.zwf"), nm_par)]=c(1.0, -1.0);

p2bfl[9, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);

p2bfl[10, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);
c2bfl[10, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(1.0);

p2bfl[13, pmatch(c("f.n.out_Ac"), nm_par)]=c(1.0);
c2bfl[13, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(1.0);

c2bfl[14, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(1.0);

c2bfl[16, pmatch(c("c.n.bs_akg"), nm_fc)]=c(1.0);

c2bfl[19, pmatch(c("c.n.bs_pga"), nm_fc)]=c(-1.0);

c2bfl[20, pmatch(c("c.n.bs_pga1_aux"), nm_fc)]=c(1.0);

c2bfl[21, pmatch(c("c.n.bs_pga2_aux"), nm_fc)]=c(1.0);

c2bfl[22, pmatch(c("c.n.bs_pga3_aux"), nm_fc)]=c(1.0);

c2bfl[24, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(-1.0);

c2bfl[27, pmatch(c("c.n.bs_pyr4_aux"), nm_fc)]=c(1.0);

c2bfl[28, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(-1.0);

c2bfl[29, pmatch(c("c.n.bs_pyr3_aux"), nm_fc)]=c(1.0);

c2bfl[31, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(-1.0);

c2bfl[32, pmatch(c("c.n.bs_rib5p1_aux"), nm_fc)]=c(1.0);

c2bfl[33, pmatch(c("c.n.bs_pep5", "c.n.bs_pep"), nm_fc)]=c(1.0, -1.0);

c2bfl[36, pmatch(c("c.n.bs_pep3_aux"), nm_fc)]=c(1.0);

c2bfl[37, pmatch(c("c.n.bs_pep4_aux"), nm_fc)]=c(1.0);

c2bfl[40, pmatch(c("c.n.bs_akg"), nm_fc)]=c(-1.0);

c2bfl[41, pmatch(c("c.n.bs_akg2", "c.n.bs_akg3"), nm_fc)]=c(1.0, 1.0);

c2bfl[43, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(-1.0);

c2bfl[44, pmatch(c("c.n.bs_oaa1_aux"), nm_fc)]=c(1.0);

c2bfl[45, pmatch(c("c.n.bs_oaa5_aux"), nm_fc)]=c(1.0);

c2bfl[46, pmatch(c("c.n.bs_oaa2_aux"), nm_fc)]=c(1.0);

c2bfl[47, pmatch(c("c.n.bs_oaa3_aux"), nm_fc)]=c(1.0);

c2bfl[48, pmatch(c("c.n.bs_oaa6_aux"), nm_fc)]=c(1.0);

c2bfl[49, pmatch(c("c.n.bs_oaa7_aux"), nm_fc)]=c(1.0);

p2bfl[50, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);
cnst2bfl[50]=1;





p2bfl[55, pmatch(c("f.x.fum_a"), nm_par)]=c(-1.0);

bp=as.numeric(c2bfl%stm%fc+cnst2bfl)

if (ffguess) {
   # make an automatic guess for free/dependent flux partition
   afd=as.matrix(cbind(Afl, -p2bfl))
   qafd=qr(afd, LAPACK=TRUE)
   d=abs(diag(qafd$qr))
   rank=sum(d > d[1]*tol)
   qrow=qr(t(afd))
   rankr=qrow$rank
   if (rank != rankr)
      stop_mes("Weird error: column and row ranks are not equal.", file=fcerr)
   
   irows=qrow$pivot[seq_len(rankr)]
   if (rank==0) {
      stop_mes("Error: No free/dependent flux partition could be made. Stoichiometric matrix has rank=0.", file=fcerr)
   }
   Afl=afd[irows, qafd$pivot[1L:rank], drop=FALSE]
   ka=kappa(Afl)
   if (ka > 1.e7) {
      mes=sprintf("Error: No working free/dependent flux partition could be proposed. Stoichiometric matrix has condition number %g.\n", ka)
      stop_mes(mes, file=fcerr)
   }
   p2bfl=-as.simple_triplet_matrix(afd[irows, qafd$pivot[-seq_len(rank)], drop=FALSE])
   c2bfl=c2bfl[irows, , drop=FALSE]
   g2bfl=g2bfl[irows, , drop=FALSE]
   cnst2bfl=cnst2bfl[irows]
   bp=bp[irows]
   
   # replace names
   nm_fl=sub("f.", "d.", colnames(Afl), fixed=TRUE)
   colnames(Afl)=nm_fl # both net and xch
   nm_fln=sort(grep("^d.n.", nm_fl, v=TRUE))
   nm_flx=sort(grep("^d.x.", nm_fl, v=TRUE))
   nm_fl=c(nm_fln, nm_flx)
   Afl=Afl[, nm_fl, drop=FALSE]
   
   nm_ff=sub("d.", "f.", colnames(p2bfl), fixed=TRUE) # both net and xch
   colnames(p2bfl)=nm_ff
   nm_ffn=sort(grep("^f.n.", nm_ff, v=TRUE))
   nm_ffx=sort(grep("^f.x.", nm_ff, v=TRUE))
   nm_ff=c(nm_ffn, nm_ffx)
   p2bfl=p2bfl[, nm_ff, drop=FALSE]
   
   # re-init param vector
   if (!fdfit)
      param=c(runif(length(nm_ff)), if (nb_ff == 0) param else param[-seq_len(nb_ff)])
   names(param)[seq(along=nm_ff)]=nm_ff
#browser()
}
nm_list$flnx=nm_fl
nm_fallnx=c(nm_fln, nm_ffn, nm_fcn, nm_fgr, nm_flx, nm_ffx, nm_fcx, sub(".n.", ".x.", nm_fgr, fixed=TRUE))
nm_list$fallnx=nm_fallnx
nm_net=c(nm_fln, nm_ffn, nm_fcn)
names(nm_net)=substring(nm_net, 5)
nm_xch=c(nm_flx, nm_ffx, nm_fcx)
names(nm_xch)=substring(nm_xch, 5)
edge2fl[]=nm_net[substring(edge2fl, 5)]
nm_list$ff=nm_ff

# accounting numbers
nb_flr=nrow(Afl)
nb_param=length(param)
nb_ffn=length(nm_ffn)
nb_ffx=length(nm_ffx)
nb_ff=nb_ffn+nb_ffx
nb_fln=length(nm_fln)
nb_flx=length(nm_flx)
nb_fl=nb_fln+nb_flx
nm_par=names(param)

for (item in c("nb_fln", "nb_flx", "nb_fl", "nb_ffn", "nb_ffx", "nb_ff")) {
   nb_f[item]=get(item)
}
# translation from n-x to fw-rv
sh_fwrv=substring(nm_fwrv[1:(nb_fwrv/2)], 5)
sh_nx=substring(nm_fallnx, 2)
nb_f$inet2ifwrv=pmatch(paste(".n.", sh_fwrv, sep=""), sh_nx)
nb_f$ixch2ifwrv=pmatch(paste(".x.", sh_fwrv, sep=""), sh_nx)
#nb_f$inet2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.n\\.%s$", substring(f, 5)), nm_fallnx))
#nb_f$ixch2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.x\\.%s$", substring(f, 5)), nm_fallnx))

if (TIMEIT) {
   cat("Afl qr(): ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

qrAfl=qr(Afl, LAPACK=TRUE)
d=abs(diag(qrAfl$qr))
qrAfl$rank=sum(d > d[1]*tol)
rank=qrAfl$rank
aful=as.matrix(cbind(Afl, -p2bfl, -c2bfl))
qrow=qr(t(aful))
rankr=qrow$rank
#browser()
# first check the presence of lindep rows
if (nrow(Afl) > rankr) {
   # find list of independent metabs for dependent ones
   idep=qrow$pivot[(rankr+1):nrow(Afl)]
   dcoef=qr.solve(t(aful[-idep,,drop=FALSE]), t(aful[idep,,drop=FALSE]))
   lidep=apply(dcoef, 2, function(v) names(which(abs(v) >= tol)), simplify=FALSE)
   prop=sprintf("***Warning: Among %d equations (rows), %d are redundant.\nThe dependencies are:\n\t", nrow(Afl), nrow(Afl)-rankr)
   prop=paste0(prop, paste0(lapply(names(lidep), function(nm) paste0(nm, ": ", paste0(lidep[[nm]], collapse=", "))), collapse="\n\t"), "\nThe redundant balances for species '", paste0(names(lidep), collapse="', '"), "' will be ignored.\n")
   #browser()
   cat(prop, file=fclog)
   Afl=Afl[-idep,,drop=FALSE]
   rankr=nrow(Afl)
   qrAfl=qr(Afl, LAPACK=TRUE)
   d=abs(diag(qrAfl$qr))
   qrAfl$rank=sum(d > d[1]*tol)
   rank=qrAfl$rank
   p2bfl=p2bfl[-idep,,drop=FALSE]
   c2bfl=c2bfl[-idep,,drop=FALSE]
   g2bfl=g2bfl[-idep,,drop=FALSE]
   cnst2bfl=cnst2bfl[-idep]
   bp=bp[-idep]
}
if (nrow(Afl) != rank || nrow(Afl) != ncol(Afl)) {
   #write.table(Afl)
   mes=NULL
   if (nrow(Afl) <= rank) {
      mes=paste("Candidate(s) for free or constrained flux(es):\n",
         paste(colnames(Afl)[-qrAfl$pivot[1L:nrow(Afl)]], collapse="\n"),
         "\nFor this choice, condition number of stoichiometric matrix will be ",
         kappa(Afl[,qrAfl$pivot[1L:nrow(Afl)],drop=FALSE]), "\n", sep="")
   } else if (nrow(Afl) > rank) {
      nextra=nrow(Afl)-rank
      comb=combn(c(nm_ffn, colnames(Afl)[-qrAfl$pivot[1L:rank]]), nextra)
      aextra=cbind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl)
      colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl))
      ara=Afl[,qrAfl$pivot[1L:rank],drop=FALSE]
      i=which.min(apply(comb, 2, function(i) kappa(cbind(ara, aextra[,i]))))[1L]
      nm_tmp=comb[,i]
      ka=kappa(cbind(ara, aextra[,nm_tmp]))
      if (ka < 1.e7) {
         prop=paste("Proposal to declare dependent flux(es) is:\n",
            paste(nm_tmp, collapse="\n"), "\n", sep="")
         if (rank < ncol(Afl)) {
            prop=prop%s+%"While the following dependent flux(es) should be declared free or constrained:\n"%s+%join("\n", colnames(Afl)[-qrAfl$pivot[1L:rank]])%s+%"\n"
         }
         prop=paste(prop, "For this choice, condition number of stoichiometric matrix will be ", ka, "\n", sep="")
      } else {
         # add constraint fluxes to candidate list
         if (nb_fcn > 0) {
            aextra=as.matrix(cbind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl, -c2bfl))
            colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl), colnames(c2bfl))
         }
         aextended=aful
         qae=qr(aextended, LAPACK=TRUE)
         d=abs(diag(qae$qr))
         ranke=sum(d > d[1L]*tol)
         if (ranke == nrow(Afl)) {
            prop=paste("Proposal to declare dependent flux(es) is:\n",
            join("\n", colnames(aextended)[qae$pivot[1L:ranke]]), "\n",
            "while free and constrained fluxes should be:\n",
            join("\n", colnames(aextended)[-qae$pivot[1L:ranke]]), "\n",
            sep="")
            ka=kappa(aextended[,qae$pivot[1L:ranke]])
            prop=paste(prop, "For this choice, condition number of stoichiometric matrix will be ", ka, "\n", sep="")
         } else {
            prop="No proposal for partition dependent/free fluxes could be made.\n"
         }
      }
      mes=paste("There is (are) probably ", nextra,
         " extra free flux(es) among the following:\n",
         paste(nm_ffn, collapse="\n"), "\n",
         prop,
         sep="")
   }
   stop_mes("Flux matrix is not square or is singular: (", nrow(Afl), "eq x ", ncol(Afl), "unk)\n",
      "You have to change your choice of free fluxes in the 'e_coli.ftbl' file.\n",
      mes, file=fcerr)
}

# make sure that free params choice leads to not singular matrix
if (qrAfl$rank != nb_fl) {
   #write.table(Afl)
   # make a suggestion of new free fluxes
   A=cbind(Afl, -p2bfl, -c2bfl)
   colnames(A)=c(colnames(Afl), nm_ff, nm_fc)
   qa=qr(A, LAPACK=TRUE)
   d=diag(qa$qr)
   qa$rank=sum(abs(d)>=abs(d[1]*tol))
   
   mes=paste("Error: Dependent flux matrix is singular.\n",
      "Change your partition on free/dependent/constrained fluxes in the 'e_coli.ftbl' file.\n",
      "Can not resolve dependent fluxe(s):\n",
      paste(colnames(Afl)[-qrAfl$pivot[(1:qrAfl$rank)]], collapse="\n"),
      sep="")
   if (qa$rank==nb_fl) {
      mes=paste(mes,
      "\n\nSuggested dependent fluxes:\n",
      paste(colnames(A)[qa$pivot[(1:qa$rank)]], collapse="\n"),
      "\n\nWhich would give the following free and constrained fluxes:\n",
      paste(colnames(A)[-qa$pivot[(1:qa$rank)]], collapse="\n"), "\n",
      sep="")
   } else {
      mes=paste(mes, "\nNo suggested free fluxes could be found", sep="")
   }
   stop_mes(mes, file=fcerr)
}

# inverse flux matrix
invAfl=solve(qrAfl)
    
if (fdfit) {
#browser()
   # choose free fluxe values such that they fit starting values from ftbl
   #dep=invAfl%*%(p2bfl%*%ff+bp)
   #ff=ff
   ff=qr.solve(rbind(invAfl%stm%p2bfl, diag(ncol(p2bfl))), c(fl-invAfl%*%bp, param))
}
# intermediate jacobian
if (TIMEIT) {
   cat("dfl_dffg: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

dfl_dffg=invAfl%stm%p2bfl
if (nb_fgr > 0L) {
   dfl_dffg=cbind(dfl_dffg, invAfl%stm%g2bfl)
}
dimnames(dfl_dffg)=list(nm_fl, c(nm_ff, nm_fgr))
dfl_dffg[abs(dfl_dffg) < 1.e-14]=0.
nb_f$dfl_dffg=as.simple_triplet_matrix(dfl_dffg)

# prepare mf, md, mc and mg matrices
# such that mf%*%ff+md%*%fl+mc%*%fc+mg%*%fgr gives fallnx
# here ff free fluxes (param), fl are dependent fluxes, fc are constrained
# fluxes and fgr are variable growth fluxes
mf=matrix(0., nb_fallnx, nb_ff)
dimnames(mf)=list(nm_fallnx, nm_ff)
md=matrix(0., nb_fallnx, nb_fl)
dimnames(md)=list(nm_fallnx, nm_fl)
mc=matrix(0., nb_fallnx, nb_fc)
dimnames(mc)=list(nm_fallnx, nm_fc)
mg=matrix(0., nb_fallnx, nb_fgr)
dimnames(mg)=list(nm_fallnx, nm_fgr)

if (nb_ff > 0) {
   mf[nm_ff, nm_ff]=diag(1., nb_ff)
}
if (nb_fl > 0) {
   md[nm_fl, nm_fl]=diag(1., nb_fl)
}
if (nb_fc > 0) {
   mc[nm_fc, nm_fc]=diag(1., nb_fc)
}
if (nb_fgr > 0) {
   mg[nm_fgr, nm_fgr]=diag(1., nb_fgr)
}

# sparse matrix static parts
# $varname fields:
#  ind_fa - flux index in a_pre$vfwrv[ind_fa]
#  a_pre - sparse matrix whose colsum() gives the a$v vector
#  prodx - dense matrix whose colprod() will give x[ind_x1]*x[ind_x2]*...
#  ind_fb - flux index in b_pre$v=fwrv[ind_fb1]*colprod(prodx)
#  ind_b - dense matrix of indexes for  b_pre$v=f[ind_b[,"indf"]*x[ind_b[,2+1]]*x[ind_b[,2+2]], ...]
#  b_pre - sparse matrix whose colsum gives b@x

#  a - unsigned sparse cumomer A matrix (off-diagonal part)
#  b - unsigned sparse vector of right hand side

if (TIMEIT) {
   cat("spAbr   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

nb_fwrv=172
nb_w=6
spAbr=list()
    
if (TIMEIT) {
   cat("weight  1: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=1
nb_c=231
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=0 # number of lighter cumomers
maxprod=1
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 83, 0, 0, 85, 0, 0, 164, 0, 0, 79, 0, 12, 83, 0, 51, 85, 0, 59, 164, 0, 6, 79, 1, 1, 83, 1, 1, 85, 1, 1, 164,
1, 1, 79, 1, 13, 83, 1, 52, 85, 1, 60, 164, 1, 7, 79, 2, 2, 83, 2, 2, 85, 2, 2, 164, 2, 2, 79, 2, 14, 83, 2, 53, 85, 2,
61, 164, 2, 8, 79, 3, 3, 83, 3, 3, 85, 3, 3, 164, 3, 3, 79, 3, 15, 83, 3, 48, 85, 3, 62, 164, 3, 9, 79, 4, 4, 83, 4, 4,
85, 4, 4, 164, 4, 4, 79, 4, 16, 83, 4, 49, 85, 4, 39, 164, 4, 10, 79, 5, 5, 83, 5, 5, 85, 5, 5, 164, 5, 5, 79, 5, 17,
83, 5, 50, 85, 5, 40, 164, 5, 11, 78, 6, 6, 90, 6, 6, 78, 6, 0, 90, 6, 51, 78, 7, 7, 90, 7, 7, 78, 7, 1, 90, 7, 52, 78,
8, 8, 90, 8, 8, 78, 8, 2, 90, 8, 53, 78, 9, 9, 90, 9, 9, 78, 9, 3, 90, 9, 53, 78, 10, 10, 90, 10, 10, 78, 10, 4, 90, 10,
52, 78, 11, 11, 90, 11, 11, 78, 11, 5, 90, 11, 51, 165, 12, 12, 172, 12, 12, 1, 12, 12, 2, 12, 12, 165, 12, 0, 172, 12,
18, 165, 13, 13, 172, 13, 13, 1, 13, 13, 2, 13, 13, 165, 13, 1, 172, 13, 19, 165, 14, 14, 172, 14, 14, 1, 14, 14, 2, 14,
14, 165, 14, 2, 172, 14, 20, 165, 15, 15, 172, 15, 15, 1, 15, 15, 2, 15, 15, 165, 15, 3, 172, 15, 21, 165, 16, 16, 172,
16, 16, 1, 16, 16, 2, 16, 16, 165, 16, 4, 172, 16, 22, 165, 17, 17, 172, 17, 17, 1, 17, 17, 2, 17, 17, 165, 17, 5, 172,
17, 23, 86, 18, 18, 156, 18, 18, 152, 18, 18, 86, 18, 12, 156, 18, 36, 152, 18, 51, 86, 19, 19, 156, 19, 19, 152, 19,
19, 86, 19, 13, 156, 19, 37, 152, 19, 52, 86, 20, 20, 156, 20, 20, 152, 20, 20, 86, 20, 14, 156, 20, 38, 152, 20, 53,
86, 21, 21, 156, 21, 21, 152, 21, 21, 86, 21, 15, 156, 21, 39, 152, 21, 54, 86, 22, 22, 156, 22, 22, 152, 22, 22, 86,
22, 16, 156, 22, 40, 152, 22, 55, 86, 23, 23, 156, 23, 23, 152, 23, 23, 86, 23, 17, 156, 23, 45, 152, 23, 56, 65, 24,
24, 157, 24, 24, 65, 24, 46, 157, 24, 69, 65, 25, 25, 157, 25, 25, 65, 25, 47, 157, 25, 70, 65, 26, 26, 157, 26, 26, 65,
26, 63, 157, 26, 45, 65, 27, 27, 157, 27, 27, 65, 27, 64, 157, 27, 71, 65, 28, 28, 157, 28, 28, 65, 28, 65, 157, 28, 72,
65, 29, 29, 157, 29, 29, 65, 29, 66, 157, 29, 73, 67, 30, 30, 168, 30, 30, 167, 30, 30, 118, 30, 30, 67, 30, 33, 168,
30, 54, 167, 30, 65, 118, 30, 58, 67, 31, 31, 168, 31, 31, 167, 31, 31, 118, 31, 31, 67, 31, 34, 168, 31, 55, 167, 31,
64, 118, 31, 88, 67, 32, 32, 168, 32, 32, 167, 32, 32, 118, 32, 32, 67, 32, 35, 168, 32, 56, 167, 32, 63, 118, 32, 101,
80, 33, 33, 153, 33, 33, 131, 33, 33, 80, 33, 51, 153, 33, 30, 131, 33, 102, 80, 34, 34, 153, 34, 34, 131, 34, 34, 80,
34, 52, 153, 34, 31, 131, 34, 103, 80, 35, 35, 153, 35, 35, 131, 35, 35, 80, 35, 53, 153, 35, 32, 131, 35, 104, 70, 36,
36, 170, 36, 36, 171, 36, 36, 170, 36, 36, 147, 36, 36, 70, 36, 18, 170, 36, 51, 171, 36, 51, 170, 36, 105, 147, 36,
106, 70, 37, 37, 170, 37, 37, 171, 37, 37, 170, 37, 37, 147, 37, 37, 70, 37, 19, 170, 37, 52, 171, 37, 52, 170, 37, 107,
147, 37, 108, 70, 38, 38, 170, 38, 38, 171, 38, 38, 170, 38, 38, 147, 38, 38, 70, 38, 20, 170, 38, 53, 171, 38, 53, 170,
38, 109, 147, 38, 110, 70, 39, 39, 170, 39, 39, 170, 39, 39, 171, 39, 39, 147, 39, 39, 70, 39, 21, 170, 39, 49, 170, 39,
111, 171, 39, 4, 147, 39, 112, 70, 40, 40, 170, 40, 40, 170, 40, 40, 171, 40, 40, 147, 40, 40, 70, 40, 22, 170, 40, 50,
170, 40, 48, 171, 40, 5, 147, 40, 113, 3, 41, 41, 154, 41, 41, 155, 41, 41, 3, 41, 69, 154, 41, 114, 155, 41, 115, 3,
42, 42, 154, 42, 42, 155, 42, 42, 3, 42, 70, 154, 42, 116, 155, 42, 117, 3, 43, 43, 154, 43, 43, 155, 43, 43, 3, 43, 71,
154, 43, 117, 155, 43, 116, 3, 44, 44, 154, 44, 44, 155, 44, 44, 3, 44, 72, 154, 44, 115, 155, 44, 114, 70, 45, 45, 77,
45, 45, 71, 45, 45, 3, 45, 45, 72, 45, 45, 56, 45, 45, 20, 45, 45, 23, 45, 45, 57, 45, 45, 36, 45, 45, 37, 45, 45, 39,
45, 45, 40, 45, 45, 44, 45, 45, 24, 45, 45, 167, 45, 45, 98, 45, 45, 70, 45, 23, 77, 45, 56, 71, 45, 26, 3, 45, 73, 72,
45, 114, 56, 45, 87, 20, 45, 87, 23, 45, 87, 57, 45, 118, 36, 45, 119, 37, 45, 119, 39, 45, 119, 40, 45, 119, 44, 45,
68, 24, 45, 120, 167, 45, 66, 98, 45, 121, 77, 46, 46, 151, 46, 46, 92, 46, 46, 77, 46, 55, 151, 46, 24, 92, 46, 122,
77, 47, 47, 151, 47, 47, 92, 47, 47, 77, 47, 54, 151, 47, 25, 92, 47, 123, 84, 48, 48, 169, 48, 48, 84, 48, 40, 169, 48,
3, 84, 49, 49, 169, 49, 49, 84, 49, 39, 169, 49, 4, 84, 50, 50, 169, 50, 50, 84, 50, 40, 169, 50, 5, 4, 51, 51, 4, 51,
51, 66, 51, 51, 84, 51, 51, 85, 51, 51, 166, 51, 51, 169, 51, 51, 4, 51, 11, 4, 51, 6, 66, 51, 18, 84, 51, 36, 85, 51,
36, 166, 51, 33, 169, 51, 0, 4, 52, 52, 4, 52, 52, 66, 52, 52, 84, 52, 52, 85, 52, 52, 166, 52, 52, 169, 52, 52, 4, 52,
10, 4, 52, 7, 66, 52, 19, 84, 52, 37, 85, 52, 37, 166, 52, 34, 169, 52, 1, 4, 53, 53, 4, 53, 53, 66, 53, 53, 84, 53, 53,
85, 53, 53, 166, 53, 53, 169, 53, 53, 4, 53, 9, 4, 53, 8, 66, 53, 20, 84, 53, 38, 85, 53, 38, 166, 53, 35, 169, 53, 2,
82, 54, 54, 66, 54, 54, 72, 54, 54, 44, 54, 54, 163, 54, 54, 139, 54, 54, 82, 54, 30, 66, 54, 21, 72, 54, 116, 44, 54,
124, 163, 54, 47, 139, 54, 75, 82, 55, 55, 66, 55, 55, 72, 55, 55, 44, 55, 55, 163, 55, 55, 139, 55, 55, 82, 55, 31, 66,
55, 22, 72, 55, 117, 44, 55, 125, 163, 55, 46, 139, 55, 74, 82, 56, 56, 66, 56, 56, 72, 56, 56, 44, 56, 56, 163, 56, 56,
139, 56, 56, 82, 56, 32, 66, 56, 23, 72, 56, 115, 44, 56, 126, 163, 56, 45, 139, 56, 87, 17, 57, 57, 104, 57, 57, 109,
57, 57, 110, 57, 57, 112, 57, 57, 114, 57, 57, 116, 57, 57, 17, 57, 66, 104, 57, 127, 109, 57, 82, 110, 57, 82, 112, 57,
128, 114, 57, 129, 116, 57, 130, 32, 58, 58, 119, 58, 58, 120, 58, 58, 32, 58, 30, 119, 58, 131, 120, 58, 132, 83, 59,
59, 171, 59, 59, 100, 59, 59, 83, 59, 105, 171, 59, 0, 100, 59, 89, 83, 60, 60, 171, 60, 60, 100, 60, 60, 83, 60, 107,
171, 60, 1, 100, 60, 100, 83, 61, 61, 171, 61, 61, 100, 61, 61, 83, 61, 109, 171, 61, 2, 100, 61, 99, 83, 62, 62, 171,
62, 62, 100, 62, 62, 83, 62, 111, 171, 62, 3, 100, 62, 98, 73, 63, 63, 81, 63, 63, 151, 63, 63, 103, 63, 63, 73, 63,
115, 81, 63, 32, 151, 63, 26, 103, 63, 120, 73, 64, 64, 81, 64, 64, 151, 64, 64, 103, 64, 64, 73, 64, 117, 81, 64, 31,
151, 64, 27, 103, 64, 133, 73, 65, 65, 81, 65, 65, 151, 65, 65, 103, 65, 65, 73, 65, 116, 81, 65, 30, 151, 65, 28, 103,
65, 134, 73, 66, 66, 81, 66, 66, 151, 66, 66, 103, 66, 66, 73, 66, 114, 81, 66, 45, 151, 66, 29, 103, 66, 57, 50, 67,
67, 148, 67, 67, 114, 67, 67, 50, 67, 135, 148, 67, 136, 114, 67, 137, 42, 68, 68, 130, 68, 68, 42, 68, 119, 130, 68,
45, 71, 69, 69, 89, 69, 69, 94, 69, 69, 71, 69, 24, 89, 69, 41, 94, 69, 138, 71, 70, 70, 89, 70, 70, 94, 70, 70, 71, 70,
25, 89, 70, 42, 94, 70, 139, 71, 71, 71, 89, 71, 71, 94, 71, 71, 71, 71, 27, 89, 71, 43, 94, 71, 140, 71, 72, 72, 89,
72, 72, 94, 72, 72, 71, 72, 28, 89, 72, 44, 94, 72, 141, 71, 73, 73, 89, 73, 73, 94, 73, 73, 71, 73, 29, 89, 73, 45, 94,
73, 142, 53, 74, 74, 140, 74, 74, 142, 74, 74, 142, 74, 74, 106, 74, 74, 109, 74, 74, 110, 74, 74, 53, 74, 55, 140, 74,
143, 142, 74, 144, 142, 74, 76, 106, 74, 77, 109, 74, 78, 110, 74, 145, 53, 75, 75, 140, 75, 75, 142, 75, 75, 142, 75,
75, 106, 75, 75, 109, 75, 75, 110, 75, 75, 53, 75, 54, 140, 75, 146, 142, 75, 147, 142, 75, 79, 106, 75, 80, 109, 75,
81, 110, 75, 148, 56, 76, 76, 145, 76, 76, 143, 76, 76, 56, 76, 74, 145, 76, 149, 143, 76, 150, 20, 77, 77, 20, 77, 74,
23, 78, 78, 24, 78, 78, 23, 78, 74, 24, 78, 133, 56, 79, 79, 145, 79, 79, 143, 79, 79, 56, 79, 75, 145, 79, 151, 143,
79, 152, 20, 80, 80, 20, 80, 75, 23, 81, 81, 24, 81, 81, 23, 81, 75, 24, 81, 134, 23, 82, 82, 24, 82, 82, 23, 82, 57,
24, 82, 57, 57, 83, 83, 57, 83, 144, 57, 84, 84, 57, 84, 147, 50, 85, 85, 50, 85, 153, 50, 86, 86, 50, 86, 154, 53, 87,
87, 140, 87, 87, 142, 87, 87, 142, 87, 87, 106, 87, 87, 109, 87, 87, 110, 87, 87, 53, 87, 56, 140, 87, 155, 142, 87,
118, 142, 87, 45, 106, 87, 45, 109, 87, 45, 110, 87, 156, 32, 88, 88, 119, 88, 88, 120, 88, 88, 32, 88, 31, 119, 88,
157, 120, 88, 158, 14, 89, 89, 119, 89, 89, 14, 89, 59, 119, 89, 159, 36, 90, 90, 37, 90, 90, 36, 90, 160, 37, 90, 161,
36, 91, 91, 37, 91, 91, 36, 91, 161, 37, 91, 160, 39, 92, 92, 40, 92, 92, 39, 92, 160, 40, 92, 161, 39, 93, 93, 40, 93,
93, 39, 93, 161, 40, 93, 160, 42, 94, 94, 42, 94, 160, 36, 95, 95, 37, 95, 95, 36, 95, 162, 37, 95, 162, 39, 96, 96, 40,
96, 96, 39, 96, 162, 40, 96, 162, 42, 97, 97, 42, 97, 162, 14, 98, 98, 119, 98, 98, 14, 98, 62, 119, 98, 163, 14, 99,
99, 119, 99, 99, 14, 99, 61, 119, 99, 164, 14, 100, 100, 119, 100, 100, 14, 100, 60, 119, 100, 165, 32, 101, 101, 119,
101, 101, 120, 101, 101, 32, 101, 32, 119, 101, 166, 120, 101, 167, 45, 102, 102, 132, 102, 102, 45, 102, 33, 132, 102,
135, 45, 103, 103, 132, 103, 103, 45, 103, 34, 132, 103, 153, 45, 104, 104, 132, 104, 104, 45, 104, 35, 132, 104, 154,
84, 105, 105, 169, 105, 105, 84, 105, 36, 169, 105, 59, 61, 106, 106, 148, 106, 106, 128, 106, 106, 61, 106, 36, 148,
106, 168, 128, 106, 169, 84, 107, 107, 169, 107, 107, 84, 107, 37, 169, 107, 60, 61, 108, 108, 148, 108, 108, 128, 108,
108, 61, 108, 37, 148, 108, 170, 128, 108, 171, 84, 109, 109, 169, 109, 109, 84, 109, 38, 169, 109, 61, 61, 110, 110,
148, 110, 110, 128, 110, 110, 61, 110, 38, 148, 110, 172, 128, 110, 173, 84, 111, 111, 169, 111, 111, 84, 111, 39, 169,
111, 62, 61, 112, 112, 148, 112, 112, 128, 112, 112, 61, 112, 39, 148, 112, 174, 128, 112, 175, 61, 113, 113, 148, 113,
113, 128, 113, 113, 61, 113, 40, 148, 113, 176, 128, 113, 177, 68, 114, 114, 69, 114, 114, 159, 114, 114, 158, 114, 114,
68, 114, 41, 69, 114, 44, 159, 114, 66, 158, 114, 45, 68, 115, 115, 69, 115, 115, 159, 115, 115, 158, 115, 115, 68, 115,
44, 69, 115, 41, 159, 115, 63, 158, 115, 56, 68, 116, 116, 69, 116, 116, 159, 116, 116, 158, 116, 116, 68, 116, 42, 69,
116, 43, 159, 116, 65, 158, 116, 54, 68, 117, 117, 69, 117, 117, 159, 117, 117, 158, 117, 117, 68, 117, 43, 69, 117, 42,
159, 117, 64, 158, 117, 55, 56, 118, 118, 145, 118, 118, 143, 118, 118, 56, 118, 87, 145, 118, 178, 143, 118, 45, 34,
119, 119, 122, 119, 119, 123, 119, 119, 125, 119, 119, 126, 119, 119, 128, 119, 119, 34, 119, 166, 122, 119, 45, 123,
119, 45, 125, 119, 45, 126, 119, 45, 128, 119, 68, 17, 120, 120, 104, 120, 120, 109, 120, 120, 110, 120, 120, 112, 120,
120, 114, 120, 120, 116, 120, 120, 17, 120, 63, 104, 120, 179, 109, 120, 156, 110, 120, 45, 112, 120, 180, 114, 120,
181, 116, 120, 182, 12, 121, 121, 12, 121, 45, 6, 122, 122, 143, 122, 122, 6, 122, 46, 143, 122, 183, 6, 123, 123, 143,
123, 123, 6, 123, 47, 143, 123, 184, 42, 124, 124, 130, 124, 124, 42, 124, 132, 130, 124, 54, 42, 125, 125, 130, 125,
125, 42, 125, 158, 130, 125, 55, 42, 126, 126, 130, 126, 126, 42, 126, 167, 130, 126, 56, 18, 127, 127, 18, 127, 57, 26,
128, 128, 106, 128, 128, 26, 128, 57, 106, 128, 185, 28, 129, 129, 28, 129, 57, 30, 130, 130, 30, 130, 57, 33, 131, 131,
120, 131, 131, 33, 131, 58, 120, 131, 160, 34, 132, 132, 122, 132, 132, 123, 132, 132, 125, 132, 132, 126, 132, 132,
128, 132, 132, 34, 132, 58, 122, 132, 186, 123, 132, 186, 125, 132, 187, 126, 132, 187, 128, 132, 124, 17, 133, 133,
104, 133, 133, 109, 133, 133, 110, 133, 133, 112, 133, 133, 114, 133, 133, 116, 133, 133, 17, 133, 64, 104, 133, 188,
109, 133, 145, 110, 133, 78, 112, 133, 189, 114, 133, 190, 116, 133, 191, 17, 134, 134, 104, 134, 134, 109, 134, 134,
110, 134, 134, 112, 134, 134, 114, 134, 134, 116, 134, 134, 17, 134, 65, 104, 134, 192, 109, 134, 148, 110, 134, 81,
112, 134, 193, 114, 134, 194, 116, 134, 195, 46, 135, 135, 134, 135, 135, 136, 135, 135, 46, 135, 102, 134, 135, 196,
136, 135, 67, 62, 136, 136, 62, 136, 67, 28, 137, 137, 28, 137, 67, 8, 138, 138, 95, 138, 138, 8, 138, 69, 95, 138, 197,
8, 139, 139, 95, 139, 139, 8, 139, 70, 95, 139, 198, 8, 140, 140, 95, 140, 140, 8, 140, 71, 95, 140, 199, 8, 141, 141,
95, 141, 141, 8, 141, 72, 95, 141, 200, 8, 142, 142, 95, 142, 142, 8, 142, 73, 95, 142, 201, 54, 143, 143, 54, 143, 74,
56, 144, 144, 145, 144, 144, 143, 144, 144, 56, 144, 74, 145, 144, 202, 143, 144, 83, 23, 145, 145, 24, 145, 145, 23,
145, 133, 24, 145, 74, 54, 146, 146, 54, 146, 75, 56, 147, 147, 145, 147, 147, 143, 147, 147, 56, 147, 75, 145, 147,
203, 143, 147, 84, 23, 148, 148, 24, 148, 148, 23, 148, 134, 24, 148, 75, 59, 149, 149, 59, 149, 76, 57, 150, 150, 57,
150, 76, 59, 151, 151, 59, 151, 79, 57, 152, 152, 57, 152, 79, 46, 153, 153, 134, 153, 153, 136, 153, 153, 46, 153, 103,
134, 153, 204, 136, 153, 85, 46, 154, 154, 134, 154, 154, 136, 154, 154, 46, 154, 104, 134, 154, 205, 136, 154, 86, 54,
155, 155, 54, 155, 87, 23, 156, 156, 24, 156, 156, 23, 156, 120, 24, 156, 87, 33, 157, 157, 120, 157, 157, 33, 157, 88,
120, 157, 162, 34, 158, 158, 122, 158, 158, 123, 158, 158, 125, 158, 158, 126, 158, 158, 128, 158, 158, 34, 158, 88,
122, 158, 206, 123, 158, 206, 125, 158, 207, 126, 158, 207, 128, 158, 125, 33, 159, 159, 120, 159, 159, 33, 159, 89,
120, 159, 161, 34, 160, 160, 122, 160, 160, 123, 160, 160, 125, 160, 160, 126, 160, 160, 128, 160, 160, 34, 160, 131,
122, 160, 90, 123, 160, 91, 125, 160, 92, 126, 160, 93, 128, 160, 94, 34, 161, 161, 122, 161, 161, 123, 161, 161, 125,
161, 161, 126, 161, 161, 128, 161, 161, 34, 161, 159, 122, 161, 91, 123, 161, 90, 125, 161, 93, 126, 161, 92, 128, 161,
208, 34, 162, 162, 122, 162, 162, 123, 162, 162, 125, 162, 162, 126, 162, 162, 128, 162, 162, 34, 162, 157, 122, 162,
95, 123, 162, 95, 125, 162, 96, 126, 162, 96, 128, 162, 97, 33, 163, 163, 120, 163, 163, 33, 163, 98, 120, 163, 209, 33,
164, 164, 120, 164, 164, 33, 164, 99, 120, 164, 210, 33, 165, 165, 120, 165, 165, 33, 165, 100, 120, 165, 211, 33, 166,
166, 120, 166, 166, 33, 166, 101, 120, 166, 119, 34, 167, 167, 122, 167, 167, 123, 167, 167, 125, 167, 167, 126, 167,
167, 128, 167, 167, 34, 167, 101, 122, 167, 212, 123, 167, 212, 125, 167, 213, 126, 167, 213, 128, 167, 126, 62, 168,
168, 62, 168, 106, 42, 169, 169, 42, 169, 106, 62, 170, 170, 62, 170, 108, 42, 171, 171, 42, 171, 108, 62, 172, 172, 62,
172, 110, 42, 173, 173, 42, 173, 110, 62, 174, 174, 62, 174, 112, 42, 175, 175, 42, 175, 112, 62, 176, 176, 62, 176,
113, 42, 177, 177, 42, 177, 113, 59, 178, 178, 59, 178, 118, 18, 179, 179, 18, 179, 120, 26, 180, 180, 106, 180, 180,
26, 180, 120, 106, 180, 214, 28, 181, 181, 28, 181, 120, 30, 182, 182, 30, 182, 120, 57, 183, 183, 57, 183, 122, 57,
184, 184, 57, 184, 123, 20, 185, 185, 20, 185, 128, 36, 186, 186, 37, 186, 186, 36, 186, 132, 37, 186, 132, 39, 187,
187, 40, 187, 187, 39, 187, 132, 40, 187, 132, 18, 188, 188, 18, 188, 133, 26, 189, 189, 106, 189, 189, 26, 189, 133,
106, 189, 215, 28, 190, 190, 28, 190, 133, 30, 191, 191, 30, 191, 133, 18, 192, 192, 18, 192, 134, 26, 193, 193, 106,
193, 193, 26, 193, 134, 106, 193, 216, 28, 194, 194, 28, 194, 134, 30, 195, 195, 30, 195, 134, 48, 196, 196, 48, 196,
135, 9, 197, 197, 98, 197, 197, 9, 197, 138, 98, 197, 217, 9, 198, 198, 98, 198, 198, 9, 198, 139, 98, 198, 218, 9, 199,
199, 98, 199, 199, 9, 199, 140, 98, 199, 219, 9, 200, 200, 98, 200, 200, 9, 200, 141, 98, 200, 220, 9, 201, 201, 98,
201, 201, 9, 201, 142, 98, 201, 221, 59, 202, 202, 59, 202, 144, 59, 203, 203, 59, 203, 147, 48, 204, 204, 48, 204, 153,
48, 205, 205, 48, 205, 154, 36, 206, 206, 37, 206, 206, 36, 206, 158, 37, 206, 158, 39, 207, 207, 40, 207, 207, 39, 207,
158, 40, 207, 158, 42, 208, 208, 42, 208, 161, 34, 209, 209, 122, 209, 209, 123, 209, 209, 125, 209, 209, 126, 209, 209,
128, 209, 209, 34, 209, 163, 122, 209, 222, 123, 209, 223, 125, 209, 224, 126, 209, 225, 128, 209, 226, 34, 210, 210,
122, 210, 210, 123, 210, 210, 125, 210, 210, 126, 210, 210, 128, 210, 210, 34, 210, 164, 122, 210, 227, 123, 210, 227,
125, 210, 228, 126, 210, 228, 128, 210, 229, 34, 211, 211, 122, 211, 211, 123, 211, 211, 125, 211, 211, 126, 211, 211,
128, 211, 211, 34, 211, 165, 122, 211, 223, 123, 211, 222, 125, 211, 225, 126, 211, 224, 128, 211, 230, 36, 212, 212,
37, 212, 212, 36, 212, 167, 37, 212, 167, 39, 213, 213, 40, 213, 213, 39, 213, 167, 40, 213, 167, 20, 214, 214, 20, 214,
180, 20, 215, 215, 20, 215, 189, 20, 216, 216, 20, 216, 193, 12, 217, 217, 12, 217, 197, 12, 218, 218, 12, 218, 198, 12,
219, 219, 12, 219, 199, 12, 220, 220, 12, 220, 200, 12, 221, 221, 12, 221, 201, 36, 222, 222, 37, 222, 222, 36, 222,
209, 37, 222, 211, 36, 223, 223, 37, 223, 223, 36, 223, 211, 37, 223, 209, 39, 224, 224, 40, 224, 224, 39, 224, 209, 40,
224, 211, 39, 225, 225, 40, 225, 225, 39, 225, 211, 40, 225, 209, 42, 226, 226, 42, 226, 209, 36, 227, 227, 37, 227,
227, 36, 227, 210, 37, 227, 210, 39, 228, 228, 40, 228, 228, 39, 228, 210, 40, 228, 210, 42, 229, 229, 42, 229, 210, 42,
230, 230, 42, 230, 211)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(1, 13, 116, 2, 13, 117, 1, 14, 118, 2, 14, 119, 1, 15, 120, 2, 15, 121, 1, 16, 122, 2, 16, 123, 1, 17, 124, 2, 17, 125,
1, 18, 126, 2, 18, 127)), ncol=2+1, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(1), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  2: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=2
nb_c=359
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=231 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 83, 0, 0, 85, 0, 0, 164, 0, 0, 79, 0, 30, 83, 0, 101, 85, 0, 107, 164, 0, 15, 79, 1, 1, 83, 1, 1, 85, 1, 1,
164, 1, 1, 79, 1, 31, 83, 1, 102, 85, 1, 108, 164, 1, 16, 79, 2, 2, 83, 2, 2, 85, 2, 2, 164, 2, 2, 79, 2, 32, 83, 2,
103, 85, 2, 109, 164, 2, 17, 79, 3, 3, 85, 3, 3, 164, 3, 3, 83, 3, 3, 79, 3, 33, 85, 3, 110, 164, 3, 18, 79, 4, 4, 85,
4, 4, 164, 4, 4, 83, 4, 4, 79, 4, 34, 85, 4, 111, 164, 4, 19, 79, 5, 5, 85, 5, 5, 164, 5, 5, 83, 5, 5, 79, 5, 35, 85, 5,
112, 164, 5, 20, 79, 6, 6, 164, 6, 6, 83, 6, 6, 85, 6, 6, 79, 6, 36, 164, 6, 21, 79, 7, 7, 164, 7, 7, 83, 7, 7, 85, 7,
7, 79, 7, 37, 164, 7, 22, 79, 8, 8, 164, 8, 8, 83, 8, 8, 85, 8, 8, 79, 8, 38, 164, 8, 23, 79, 9, 9, 83, 9, 9, 164, 9, 9,
85, 9, 9, 79, 9, 39, 83, 9, 98, 164, 9, 24, 79, 10, 10, 164, 10, 10, 83, 10, 10, 85, 10, 10, 79, 10, 40, 164, 10, 25,
79, 11, 11, 164, 11, 11, 83, 11, 11, 85, 11, 11, 79, 11, 41, 164, 11, 26, 79, 12, 12, 164, 12, 12, 83, 12, 12, 85, 12,
12, 79, 12, 42, 164, 12, 27, 79, 13, 13, 83, 13, 13, 164, 13, 13, 85, 13, 13, 79, 13, 43, 83, 13, 99, 164, 13, 28, 79,
14, 14, 83, 14, 14, 85, 14, 14, 164, 14, 14, 79, 14, 44, 83, 14, 100, 85, 14, 90, 164, 14, 29, 78, 15, 15, 90, 15, 15,
78, 15, 0, 90, 15, 101, 78, 16, 16, 90, 16, 16, 78, 16, 1, 90, 16, 102, 78, 17, 17, 90, 17, 17, 78, 17, 2, 90, 17, 103,
78, 18, 18, 90, 18, 18, 78, 18, 3, 78, 19, 19, 90, 19, 19, 78, 19, 4, 78, 20, 20, 90, 20, 20, 78, 20, 5, 78, 21, 21, 90,
21, 21, 78, 21, 6, 78, 22, 22, 90, 22, 22, 78, 22, 7, 78, 23, 23, 90, 23, 23, 78, 23, 8, 78, 24, 24, 90, 24, 24, 78, 24,
9, 90, 24, 103, 78, 25, 25, 90, 25, 25, 78, 25, 10, 78, 26, 26, 90, 26, 26, 78, 26, 11, 78, 27, 27, 90, 27, 27, 78, 27,
12, 78, 28, 28, 90, 28, 28, 78, 28, 13, 90, 28, 102, 78, 29, 29, 90, 29, 29, 78, 29, 14, 90, 29, 101, 165, 30, 30, 172,
30, 30, 1, 30, 30, 2, 30, 30, 165, 30, 0, 172, 30, 45, 165, 31, 31, 172, 31, 31, 1, 31, 31, 2, 31, 31, 165, 31, 1, 172,
31, 46, 165, 32, 32, 172, 32, 32, 1, 32, 32, 2, 32, 32, 165, 32, 2, 172, 32, 47, 165, 33, 33, 172, 33, 33, 1, 33, 33, 2,
33, 33, 165, 33, 3, 172, 33, 48, 165, 34, 34, 172, 34, 34, 1, 34, 34, 2, 34, 34, 165, 34, 4, 172, 34, 49, 165, 35, 35,
172, 35, 35, 1, 35, 35, 2, 35, 35, 165, 35, 5, 172, 35, 50, 165, 36, 36, 172, 36, 36, 1, 36, 36, 2, 36, 36, 165, 36, 6,
172, 36, 51, 165, 37, 37, 172, 37, 37, 1, 37, 37, 2, 37, 37, 165, 37, 7, 172, 37, 52, 165, 38, 38, 172, 38, 38, 1, 38,
38, 2, 38, 38, 165, 38, 8, 172, 38, 53, 165, 39, 39, 172, 39, 39, 1, 39, 39, 2, 39, 39, 165, 39, 9, 172, 39, 54, 165,
40, 40, 172, 40, 40, 1, 40, 40, 2, 40, 40, 165, 40, 10, 172, 40, 55, 165, 41, 41, 172, 41, 41, 1, 41, 41, 2, 41, 41,
165, 41, 11, 172, 41, 56, 165, 42, 42, 172, 42, 42, 1, 42, 42, 2, 42, 42, 165, 42, 12, 172, 42, 57, 165, 43, 43, 172,
43, 43, 1, 43, 43, 2, 43, 43, 165, 43, 13, 172, 43, 58, 165, 44, 44, 172, 44, 44, 1, 44, 44, 2, 44, 44, 165, 44, 14,
172, 44, 59, 86, 45, 45, 156, 45, 45, 152, 45, 45, 86, 45, 30, 156, 45, 81, 152, 45, 101, 86, 46, 46, 156, 46, 46, 152,
46, 46, 86, 46, 31, 156, 46, 82, 152, 46, 102, 86, 47, 47, 156, 47, 47, 152, 47, 47, 86, 47, 32, 156, 47, 83, 152, 47,
103, 86, 48, 48, 156, 48, 48, 152, 48, 48, 86, 48, 33, 156, 48, 84, 86, 49, 49, 156, 49, 49, 152, 49, 49, 86, 49, 34,
156, 49, 85, 86, 50, 50, 156, 50, 50, 152, 50, 50, 86, 50, 35, 156, 50, 86, 86, 51, 51, 156, 51, 51, 152, 51, 51, 86,
51, 36, 156, 51, 87, 86, 52, 52, 156, 52, 52, 152, 52, 52, 86, 52, 37, 156, 52, 88, 86, 53, 53, 156, 53, 53, 152, 53,
53, 86, 53, 38, 156, 53, 89, 86, 54, 54, 156, 54, 54, 152, 54, 54, 86, 54, 39, 156, 54, 90, 152, 54, 104, 86, 55, 55,
156, 55, 55, 152, 55, 55, 86, 55, 40, 86, 56, 56, 156, 56, 56, 152, 56, 56, 86, 56, 41, 86, 57, 57, 156, 57, 57, 152,
57, 57, 86, 57, 42, 86, 58, 58, 152, 58, 58, 156, 58, 58, 86, 58, 43, 152, 58, 105, 86, 59, 59, 152, 59, 59, 156, 59,
59, 86, 59, 44, 152, 59, 106, 65, 60, 60, 157, 60, 60, 65, 60, 97, 157, 60, 119, 65, 61, 61, 157, 61, 61, 65, 62, 62,
157, 62, 62, 157, 63, 63, 65, 63, 63, 157, 63, 120, 157, 64, 64, 65, 64, 64, 157, 64, 121, 65, 65, 65, 157, 65, 65, 65,
65, 113, 157, 66, 66, 65, 66, 66, 157, 66, 122, 157, 67, 67, 65, 67, 67, 157, 67, 123, 65, 68, 68, 157, 68, 68, 65, 68,
114, 65, 69, 69, 157, 69, 69, 65, 69, 115, 157, 69, 124, 157, 70, 70, 65, 70, 70, 157, 70, 125, 157, 71, 71, 65, 71, 71,
157, 71, 126, 65, 72, 72, 157, 72, 72, 65, 72, 116, 65, 73, 73, 157, 73, 73, 65, 73, 117, 157, 73, 127, 65, 74, 74, 157,
74, 74, 65, 74, 118, 157, 74, 128, 67, 75, 75, 168, 75, 75, 167, 75, 75, 118, 75, 75, 67, 75, 78, 168, 75, 104, 167, 75,
115, 118, 75, 147, 67, 76, 76, 168, 76, 76, 167, 76, 76, 118, 76, 76, 67, 76, 79, 168, 76, 105, 167, 76, 114, 118, 76,
148, 67, 77, 77, 168, 77, 77, 167, 77, 77, 118, 77, 77, 67, 77, 80, 168, 77, 106, 167, 77, 113, 118, 77, 149, 80, 78,
78, 153, 78, 78, 131, 78, 78, 80, 78, 101, 153, 78, 75, 131, 78, 150, 80, 79, 79, 153, 79, 79, 131, 79, 79, 80, 79, 102,
153, 79, 76, 131, 79, 151, 80, 80, 80, 153, 80, 80, 131, 80, 80, 80, 80, 103, 153, 80, 77, 131, 80, 152, 70, 81, 81,
170, 81, 81, 171, 81, 81, 170, 81, 81, 147, 81, 81, 70, 81, 45, 170, 81, 101, 171, 81, 101, 170, 81, 153, 147, 81, 154,
70, 82, 82, 170, 82, 82, 171, 82, 82, 170, 82, 82, 147, 82, 82, 70, 82, 46, 170, 82, 102, 171, 82, 102, 170, 82, 155,
147, 82, 156, 70, 83, 83, 170, 83, 83, 171, 83, 83, 170, 83, 83, 147, 83, 83, 70, 83, 47, 170, 83, 103, 171, 83, 103,
170, 83, 157, 147, 83, 158, 70, 84, 84, 170, 84, 84, 147, 84, 84, 170, 84, 84, 171, 84, 84, 70, 84, 48, 170, 84, 159,
147, 84, 160, 70, 85, 85, 170, 85, 85, 147, 85, 85, 170, 85, 85, 171, 85, 85, 70, 85, 49, 170, 85, 161, 147, 85, 162,
70, 86, 86, 170, 86, 86, 147, 86, 86, 170, 86, 86, 171, 86, 86, 70, 86, 50, 170, 86, 163, 147, 86, 164, 70, 87, 87, 170,
87, 87, 147, 87, 87, 170, 87, 87, 171, 87, 87, 70, 87, 51, 170, 87, 165, 147, 87, 166, 70, 88, 88, 170, 88, 88, 147, 88,
88, 170, 88, 88, 171, 88, 88, 70, 88, 52, 170, 88, 167, 147, 88, 168, 70, 89, 89, 170, 89, 89, 147, 89, 89, 170, 89, 89,
171, 89, 89, 70, 89, 53, 170, 89, 169, 147, 89, 170, 70, 90, 90, 170, 90, 90, 170, 90, 90, 171, 90, 90, 147, 90, 90, 70,
90, 54, 170, 90, 100, 170, 90, 171, 171, 90, 14, 147, 90, 172, 3, 91, 91, 154, 91, 91, 155, 91, 91, 3, 91, 119, 154, 91,
173, 155, 91, 174, 3, 92, 92, 154, 92, 92, 155, 92, 92, 3, 92, 120, 154, 92, 175, 155, 92, 176, 3, 93, 93, 154, 93, 93,
155, 93, 93, 3, 93, 122, 154, 93, 177, 155, 93, 177, 3, 94, 94, 154, 94, 94, 155, 94, 94, 3, 94, 121, 154, 94, 178, 155,
94, 178, 3, 95, 95, 154, 95, 95, 155, 95, 95, 3, 95, 123, 154, 95, 176, 155, 95, 175, 3, 96, 96, 154, 96, 96, 155, 96,
96, 3, 96, 124, 154, 96, 174, 155, 96, 173, 77, 97, 97, 151, 97, 97, 92, 97, 97, 77, 97, 104, 151, 97, 60, 92, 97, 179,
169, 98, 98, 84, 98, 98, 169, 98, 9, 169, 99, 99, 84, 99, 99, 169, 99, 13, 84, 100, 100, 169, 100, 100, 84, 100, 90,
169, 100, 14, 4, 101, 101, 4, 101, 101, 66, 101, 101, 84, 101, 101, 85, 101, 101, 166, 101, 101, 169, 101, 101, 4, 101,
29, 4, 101, 15, 66, 101, 45, 84, 101, 81, 85, 101, 81, 166, 101, 78, 169, 101, 0, 4, 102, 102, 4, 102, 102, 66, 102,
102, 84, 102, 102, 85, 102, 102, 166, 102, 102, 169, 102, 102, 4, 102, 28, 4, 102, 16, 66, 102, 46, 84, 102, 82, 85,
102, 82, 166, 102, 79, 169, 102, 1, 4, 103, 103, 4, 103, 103, 66, 103, 103, 84, 103, 103, 85, 103, 103, 166, 103, 103,
169, 103, 103, 4, 103, 24, 4, 103, 17, 66, 103, 47, 84, 103, 83, 85, 103, 83, 166, 103, 80, 169, 103, 2, 82, 104, 104,
66, 104, 104, 72, 104, 104, 44, 104, 104, 163, 104, 104, 139, 104, 104, 82, 104, 75, 66, 104, 54, 72, 104, 178, 44, 104,
180, 163, 104, 97, 139, 104, 129, 82, 105, 105, 66, 105, 105, 72, 105, 105, 44, 105, 105, 139, 105, 105, 163, 105, 105,
82, 105, 76, 66, 105, 58, 72, 105, 176, 44, 105, 181, 139, 105, 138, 82, 106, 106, 66, 106, 106, 72, 106, 106, 44, 106,
106, 139, 106, 106, 163, 106, 106, 82, 106, 77, 66, 106, 59, 72, 106, 174, 44, 106, 182, 139, 106, 137, 83, 107, 107,
171, 107, 107, 100, 107, 107, 83, 107, 153, 171, 107, 0, 100, 107, 183, 83, 108, 108, 171, 108, 108, 100, 108, 108, 83,
108, 155, 171, 108, 1, 100, 108, 184, 83, 109, 109, 171, 109, 109, 100, 109, 109, 83, 109, 157, 171, 109, 2, 100, 109,
146, 83, 110, 110, 171, 110, 110, 100, 110, 110, 83, 110, 159, 171, 110, 3, 100, 110, 185, 83, 111, 111, 171, 111, 111,
100, 111, 111, 83, 111, 161, 171, 111, 4, 100, 111, 145, 83, 112, 112, 171, 112, 112, 100, 112, 112, 83, 112, 163, 171,
112, 5, 100, 112, 144, 73, 113, 113, 81, 113, 113, 151, 113, 113, 103, 113, 113, 73, 113, 174, 81, 113, 77, 151, 113,
65, 103, 113, 186, 73, 114, 114, 81, 114, 114, 151, 114, 114, 103, 114, 114, 73, 114, 176, 81, 114, 76, 151, 114, 68,
103, 114, 187, 73, 115, 115, 81, 115, 115, 151, 115, 115, 103, 115, 115, 73, 115, 178, 81, 115, 75, 151, 115, 69, 103,
115, 188, 73, 116, 116, 151, 116, 116, 103, 116, 116, 81, 116, 116, 73, 116, 177, 151, 116, 72, 103, 116, 189, 73, 117,
117, 151, 117, 117, 103, 117, 117, 81, 117, 117, 73, 117, 175, 151, 117, 73, 103, 117, 190, 73, 118, 118, 151, 118, 118,
103, 118, 118, 81, 118, 118, 73, 118, 173, 151, 118, 74, 103, 118, 191, 71, 119, 119, 89, 119, 119, 94, 119, 119, 71,
119, 60, 89, 119, 91, 94, 119, 192, 71, 120, 120, 89, 120, 120, 94, 120, 120, 71, 120, 63, 89, 120, 92, 94, 120, 193,
71, 121, 121, 89, 121, 121, 94, 121, 121, 71, 121, 64, 89, 121, 94, 94, 121, 194, 71, 122, 122, 89, 122, 122, 94, 122,
122, 71, 122, 66, 89, 122, 93, 94, 122, 195, 71, 123, 123, 89, 123, 123, 94, 123, 123, 71, 123, 67, 89, 123, 95, 94,
123, 196, 71, 124, 124, 89, 124, 124, 94, 124, 124, 71, 124, 69, 89, 124, 96, 94, 124, 197, 71, 125, 125, 94, 125, 125,
89, 125, 125, 71, 125, 70, 94, 125, 198, 71, 126, 126, 94, 126, 126, 89, 126, 126, 71, 126, 71, 94, 126, 199, 71, 127,
127, 94, 127, 127, 89, 127, 127, 71, 127, 73, 94, 127, 200, 71, 128, 128, 94, 128, 128, 89, 128, 128, 71, 128, 74, 94,
128, 201, 53, 129, 129, 140, 129, 129, 142, 129, 129, 142, 129, 129, 106, 129, 129, 109, 129, 129, 110, 129, 129, 53,
129, 104, 140, 129, 202, 142, 129, 203, 142, 129, 130, 106, 129, 131, 109, 129, 132, 110, 129, 204, 56, 130, 130, 145,
130, 130, 143, 130, 130, 56, 130, 129, 145, 130, 205, 143, 130, 206, 20, 131, 131, 20, 131, 129, 23, 132, 132, 24, 132,
132, 23, 132, 129, 24, 132, 188, 24, 133, 133, 23, 133, 133, 24, 133, 190, 24, 134, 134, 23, 134, 134, 24, 134, 191, 57,
135, 135, 57, 135, 203, 50, 136, 136, 50, 136, 207, 53, 137, 137, 140, 137, 137, 142, 137, 137, 110, 137, 137, 142, 137,
137, 106, 137, 137, 109, 137, 137, 53, 137, 106, 140, 137, 208, 142, 137, 209, 110, 137, 210, 53, 138, 138, 140, 138,
138, 142, 138, 138, 110, 138, 138, 142, 138, 138, 106, 138, 138, 109, 138, 138, 53, 138, 105, 140, 138, 211, 142, 138,
212, 110, 138, 213, 36, 139, 139, 37, 139, 139, 36, 139, 214, 37, 139, 215, 36, 140, 140, 37, 140, 140, 36, 140, 215,
37, 140, 214, 39, 141, 141, 40, 141, 141, 39, 141, 214, 40, 141, 215, 39, 142, 142, 40, 142, 142, 39, 142, 215, 40, 142,
214, 42, 143, 143, 42, 143, 214, 14, 144, 144, 119, 144, 144, 14, 144, 112, 119, 144, 216, 14, 145, 145, 119, 145, 145,
14, 145, 111, 119, 145, 217, 14, 146, 146, 119, 146, 146, 14, 146, 109, 119, 146, 218, 32, 147, 147, 119, 147, 147, 120,
147, 147, 32, 147, 75, 119, 147, 219, 120, 147, 220, 32, 148, 148, 119, 148, 148, 120, 148, 148, 32, 148, 76, 119, 148,
221, 120, 148, 222, 32, 149, 149, 119, 149, 149, 120, 149, 149, 32, 149, 77, 119, 149, 223, 120, 149, 224, 45, 150, 150,
132, 150, 150, 45, 150, 78, 132, 150, 225, 45, 151, 151, 132, 151, 151, 45, 151, 79, 132, 151, 226, 45, 152, 152, 132,
152, 152, 45, 152, 80, 132, 152, 207, 84, 153, 153, 169, 153, 153, 84, 153, 81, 169, 153, 107, 61, 154, 154, 148, 154,
154, 128, 154, 154, 61, 154, 81, 148, 154, 227, 128, 154, 228, 84, 155, 155, 169, 155, 155, 84, 155, 82, 169, 155, 108,
61, 156, 156, 148, 156, 156, 128, 156, 156, 61, 156, 82, 148, 156, 229, 128, 156, 230, 84, 157, 157, 169, 157, 157, 84,
157, 83, 169, 157, 109, 61, 158, 158, 148, 158, 158, 128, 158, 158, 61, 158, 83, 148, 158, 231, 128, 158, 232, 84, 159,
159, 169, 159, 159, 84, 159, 84, 169, 159, 110, 61, 160, 160, 148, 160, 160, 128, 160, 160, 61, 160, 84, 148, 160, 233,
128, 160, 234, 84, 161, 161, 169, 161, 161, 84, 161, 85, 169, 161, 111, 61, 162, 162, 148, 162, 162, 128, 162, 162, 61,
162, 85, 148, 162, 235, 128, 162, 236, 84, 163, 163, 169, 163, 163, 84, 163, 86, 169, 163, 112, 61, 164, 164, 148, 164,
164, 128, 164, 164, 61, 164, 86, 148, 164, 237, 128, 164, 238, 84, 165, 165, 169, 165, 165, 84, 165, 87, 61, 166, 166,
148, 166, 166, 128, 166, 166, 61, 166, 87, 148, 166, 239, 128, 166, 240, 84, 167, 167, 169, 167, 167, 84, 167, 88, 61,
168, 168, 148, 168, 168, 128, 168, 168, 61, 168, 88, 148, 168, 241, 128, 168, 242, 84, 169, 169, 169, 169, 169, 84, 169,
89, 61, 170, 170, 148, 170, 170, 128, 170, 170, 61, 170, 89, 148, 170, 243, 128, 170, 244, 84, 171, 171, 169, 171, 171,
84, 171, 90, 61, 172, 172, 148, 172, 172, 128, 172, 172, 61, 172, 90, 148, 172, 245, 128, 172, 246, 68, 173, 173, 69,
173, 173, 159, 173, 173, 158, 173, 173, 68, 173, 91, 69, 173, 96, 159, 173, 118, 68, 174, 174, 69, 174, 174, 159, 174,
174, 158, 174, 174, 68, 174, 96, 69, 174, 91, 159, 174, 113, 158, 174, 106, 68, 175, 175, 69, 175, 175, 159, 175, 175,
158, 175, 175, 68, 175, 92, 69, 175, 95, 159, 175, 117, 68, 176, 176, 69, 176, 176, 159, 176, 176, 158, 176, 176, 68,
176, 95, 69, 176, 92, 159, 176, 114, 158, 176, 105, 68, 177, 177, 69, 177, 177, 159, 177, 177, 158, 177, 177, 68, 177,
93, 69, 177, 93, 159, 177, 116, 68, 178, 178, 69, 178, 178, 159, 178, 178, 158, 178, 178, 68, 178, 94, 69, 178, 94, 159,
178, 115, 158, 178, 104, 6, 179, 179, 143, 179, 179, 6, 179, 97, 143, 179, 247, 42, 180, 180, 130, 180, 180, 42, 180,
220, 130, 180, 104, 42, 181, 181, 130, 181, 181, 42, 181, 222, 130, 181, 105, 42, 182, 182, 130, 182, 182, 42, 182, 224,
130, 182, 106, 14, 183, 183, 119, 183, 183, 14, 183, 107, 119, 183, 248, 14, 184, 184, 119, 184, 184, 14, 184, 108, 119,
184, 249, 14, 185, 185, 119, 185, 185, 14, 185, 110, 119, 185, 250, 17, 186, 186, 104, 186, 186, 109, 186, 186, 112,
186, 186, 114, 186, 186, 116, 186, 186, 110, 186, 186, 17, 186, 113, 104, 186, 251, 109, 186, 210, 112, 186, 252, 114,
186, 253, 116, 186, 254, 17, 187, 187, 104, 187, 187, 109, 187, 187, 112, 187, 187, 114, 187, 187, 116, 187, 187, 110,
187, 187, 17, 187, 114, 104, 187, 255, 109, 187, 213, 112, 187, 256, 114, 187, 257, 116, 187, 258, 17, 188, 188, 104,
188, 188, 109, 188, 188, 110, 188, 188, 112, 188, 188, 114, 188, 188, 116, 188, 188, 17, 188, 115, 104, 188, 259, 109,
188, 204, 110, 188, 132, 112, 188, 260, 114, 188, 261, 116, 188, 262, 17, 189, 189, 104, 189, 189, 109, 189, 189, 112,
189, 189, 114, 189, 189, 116, 189, 189, 110, 189, 189, 17, 189, 116, 104, 189, 263, 109, 189, 264, 112, 189, 265, 114,
189, 266, 116, 189, 267, 17, 190, 190, 104, 190, 190, 109, 190, 190, 110, 190, 190, 112, 190, 190, 114, 190, 190, 116,
190, 190, 17, 190, 117, 104, 190, 268, 109, 190, 269, 110, 190, 133, 112, 190, 270, 114, 190, 271, 116, 190, 272, 17,
191, 191, 104, 191, 191, 109, 191, 191, 110, 191, 191, 112, 191, 191, 114, 191, 191, 116, 191, 191, 17, 191, 118, 104,
191, 273, 109, 191, 274, 110, 191, 134, 112, 191, 275, 114, 191, 276, 116, 191, 277, 8, 192, 192, 95, 192, 192, 8, 192,
119, 95, 192, 278, 8, 193, 193, 95, 193, 193, 8, 193, 120, 95, 193, 279, 8, 194, 194, 95, 194, 194, 8, 194, 121, 95,
194, 280, 8, 195, 195, 95, 195, 195, 8, 195, 122, 95, 195, 281, 8, 196, 196, 95, 196, 196, 8, 196, 123, 95, 196, 282, 8,
197, 197, 95, 197, 197, 8, 197, 124, 95, 197, 283, 8, 198, 198, 95, 198, 198, 8, 198, 125, 95, 198, 284, 8, 199, 199,
95, 199, 199, 8, 199, 126, 95, 199, 285, 8, 200, 200, 95, 200, 200, 8, 200, 127, 95, 200, 286, 8, 201, 201, 95, 201,
201, 8, 201, 128, 95, 201, 287, 54, 202, 202, 54, 202, 129, 56, 203, 203, 145, 203, 203, 143, 203, 203, 56, 203, 129,
145, 203, 288, 143, 203, 135, 23, 204, 204, 24, 204, 204, 23, 204, 188, 24, 204, 129, 59, 205, 205, 59, 205, 130, 57,
206, 206, 57, 206, 130, 46, 207, 207, 134, 207, 207, 136, 207, 207, 46, 207, 152, 134, 207, 289, 136, 207, 136, 54, 208,
208, 54, 208, 137, 56, 209, 209, 145, 209, 209, 143, 209, 209, 56, 209, 137, 145, 209, 290, 23, 210, 210, 24, 210, 210,
23, 210, 186, 24, 210, 137, 54, 211, 211, 54, 211, 138, 56, 212, 212, 145, 212, 212, 143, 212, 212, 56, 212, 138, 145,
212, 291, 23, 213, 213, 24, 213, 213, 23, 213, 187, 24, 213, 138, 34, 214, 214, 122, 214, 214, 123, 214, 214, 125, 214,
214, 126, 214, 214, 128, 214, 214, 34, 214, 219, 122, 214, 139, 123, 214, 140, 125, 214, 141, 126, 214, 142, 128, 214,
143, 34, 215, 215, 122, 215, 215, 123, 215, 215, 125, 215, 215, 126, 215, 215, 128, 215, 215, 34, 215, 292, 122, 215,
140, 123, 215, 139, 125, 215, 142, 126, 215, 141, 128, 215, 293, 33, 216, 216, 120, 216, 216, 33, 216, 144, 120, 216,
294, 33, 217, 217, 120, 217, 217, 33, 217, 145, 120, 217, 295, 33, 218, 218, 120, 218, 218, 33, 218, 146, 120, 218, 296,
33, 219, 219, 120, 219, 219, 33, 219, 147, 120, 219, 214, 34, 220, 220, 122, 220, 220, 123, 220, 220, 125, 220, 220,
126, 220, 220, 128, 220, 220, 34, 220, 147, 122, 220, 297, 123, 220, 297, 125, 220, 298, 126, 220, 298, 128, 220, 180,
33, 221, 221, 120, 221, 221, 33, 221, 148, 120, 221, 299, 34, 222, 222, 122, 222, 222, 123, 222, 222, 125, 222, 222,
126, 222, 222, 128, 222, 222, 34, 222, 148, 122, 222, 300, 123, 222, 300, 125, 222, 301, 126, 222, 301, 128, 222, 181,
33, 223, 223, 120, 223, 223, 33, 223, 149, 120, 223, 302, 34, 224, 224, 122, 224, 224, 123, 224, 224, 125, 224, 224,
126, 224, 224, 128, 224, 224, 34, 224, 149, 122, 224, 303, 123, 224, 303, 125, 224, 304, 126, 224, 304, 128, 224, 182,
46, 225, 225, 134, 225, 225, 136, 225, 225, 46, 225, 150, 134, 225, 305, 46, 226, 226, 134, 226, 226, 136, 226, 226, 46,
226, 151, 134, 226, 306, 62, 227, 227, 62, 227, 154, 42, 228, 228, 42, 228, 154, 62, 229, 229, 62, 229, 156, 42, 230,
230, 42, 230, 156, 62, 231, 231, 62, 231, 158, 42, 232, 232, 42, 232, 158, 62, 233, 233, 62, 233, 160, 42, 234, 234, 42,
234, 160, 62, 235, 235, 62, 235, 162, 42, 236, 236, 42, 236, 162, 62, 237, 237, 62, 237, 164, 42, 238, 238, 42, 238,
164, 62, 239, 239, 62, 239, 166, 42, 240, 240, 42, 240, 166, 62, 241, 241, 62, 241, 168, 42, 242, 242, 42, 242, 168, 62,
243, 243, 62, 243, 170, 42, 244, 244, 42, 244, 170, 62, 245, 245, 62, 245, 172, 42, 246, 246, 42, 246, 172, 57, 247,
247, 57, 247, 179, 33, 248, 248, 120, 248, 248, 33, 248, 183, 120, 248, 307, 33, 249, 249, 120, 249, 249, 33, 249, 184,
120, 249, 308, 33, 250, 250, 120, 250, 250, 33, 250, 185, 120, 250, 309, 18, 251, 251, 18, 251, 186, 26, 252, 252, 106,
252, 252, 26, 252, 186, 106, 252, 310, 28, 253, 253, 28, 253, 186, 30, 254, 254, 30, 254, 186, 18, 255, 255, 18, 255,
187, 26, 256, 256, 106, 256, 256, 26, 256, 187, 106, 256, 311, 28, 257, 257, 28, 257, 187, 30, 258, 258, 30, 258, 187,
18, 259, 259, 18, 259, 188, 26, 260, 260, 106, 260, 260, 26, 260, 188, 106, 260, 312, 28, 261, 261, 28, 261, 188, 30,
262, 262, 30, 262, 188, 18, 263, 263, 18, 263, 189, 23, 264, 264, 24, 264, 264, 23, 264, 189, 26, 265, 265, 106, 265,
265, 26, 265, 189, 106, 265, 313, 28, 266, 266, 28, 266, 189, 30, 267, 267, 30, 267, 189, 18, 268, 268, 18, 268, 190,
23, 269, 269, 24, 269, 269, 23, 269, 190, 26, 270, 270, 106, 270, 270, 26, 270, 190, 106, 270, 314, 28, 271, 271, 28,
271, 190, 30, 272, 272, 30, 272, 190, 18, 273, 273, 18, 273, 191, 23, 274, 274, 24, 274, 274, 23, 274, 191, 26, 275,
275, 106, 275, 275, 26, 275, 191, 106, 275, 315, 28, 276, 276, 28, 276, 191, 30, 277, 277, 30, 277, 191, 9, 278, 278,
98, 278, 278, 9, 278, 192, 98, 278, 316, 9, 279, 279, 98, 279, 279, 9, 279, 193, 98, 279, 317, 9, 280, 280, 98, 280,
280, 9, 280, 194, 98, 280, 318, 9, 281, 281, 98, 281, 281, 9, 281, 195, 98, 281, 319, 9, 282, 282, 98, 282, 282, 9, 282,
196, 98, 282, 320, 9, 283, 283, 98, 283, 283, 9, 283, 197, 98, 283, 321, 9, 284, 284, 98, 284, 284, 9, 284, 198, 98,
284, 322, 9, 285, 285, 98, 285, 285, 9, 285, 199, 98, 285, 323, 9, 286, 286, 98, 286, 286, 9, 286, 200, 98, 286, 324, 9,
287, 287, 98, 287, 287, 9, 287, 201, 98, 287, 325, 59, 288, 288, 59, 288, 203, 48, 289, 289, 48, 289, 207, 59, 290, 290,
59, 290, 209, 59, 291, 291, 59, 291, 212, 120, 292, 292, 33, 292, 292, 120, 292, 215, 42, 293, 293, 42, 293, 215, 34,
294, 294, 122, 294, 294, 123, 294, 294, 125, 294, 294, 126, 294, 294, 128, 294, 294, 34, 294, 216, 122, 294, 326, 123,
294, 327, 125, 294, 328, 126, 294, 329, 128, 294, 330, 34, 295, 295, 122, 295, 295, 123, 295, 295, 125, 295, 295, 126,
295, 295, 128, 295, 295, 34, 295, 217, 122, 295, 331, 123, 295, 331, 125, 295, 332, 126, 295, 332, 128, 295, 333, 34,
296, 296, 122, 296, 296, 123, 296, 296, 125, 296, 296, 126, 296, 296, 128, 296, 296, 34, 296, 218, 122, 296, 327, 123,
296, 326, 125, 296, 329, 126, 296, 328, 128, 296, 334, 36, 297, 297, 37, 297, 297, 36, 297, 220, 37, 297, 220, 39, 298,
298, 40, 298, 298, 39, 298, 220, 40, 298, 220, 34, 299, 299, 122, 299, 299, 123, 299, 299, 125, 299, 299, 126, 299, 299,
128, 299, 299, 34, 299, 221, 36, 300, 300, 37, 300, 300, 36, 300, 222, 37, 300, 222, 39, 301, 301, 40, 301, 301, 39,
301, 222, 40, 301, 222, 34, 302, 302, 122, 302, 302, 123, 302, 302, 125, 302, 302, 126, 302, 302, 128, 302, 302, 34,
302, 223, 36, 303, 303, 37, 303, 303, 36, 303, 224, 37, 303, 224, 39, 304, 304, 40, 304, 304, 39, 304, 224, 40, 304,
224, 48, 305, 305, 48, 305, 225, 48, 306, 306, 48, 306, 226, 34, 307, 307, 122, 307, 307, 123, 307, 307, 125, 307, 307,
126, 307, 307, 128, 307, 307, 34, 307, 248, 122, 307, 335, 123, 307, 336, 125, 307, 337, 126, 307, 338, 128, 307, 339,
34, 308, 308, 122, 308, 308, 123, 308, 308, 125, 308, 308, 126, 308, 308, 128, 308, 308, 34, 308, 249, 122, 308, 340,
123, 308, 341, 125, 308, 342, 126, 308, 343, 128, 308, 344, 34, 309, 309, 122, 309, 309, 123, 309, 309, 125, 309, 309,
126, 309, 309, 128, 309, 309, 34, 309, 250, 122, 309, 345, 123, 309, 346, 125, 309, 347, 126, 309, 348, 128, 309, 349,
20, 310, 310, 20, 310, 252, 20, 311, 311, 20, 311, 256, 20, 312, 312, 20, 312, 260, 20, 313, 313, 20, 313, 265, 20, 314,
314, 20, 314, 270, 20, 315, 315, 20, 315, 275, 12, 316, 316, 12, 316, 278, 12, 317, 317, 12, 317, 279, 12, 318, 318, 12,
318, 280, 12, 319, 319, 12, 319, 281, 12, 320, 320, 12, 320, 282, 12, 321, 321, 12, 321, 283, 12, 322, 322, 12, 322,
284, 12, 323, 323, 12, 323, 285, 12, 324, 324, 12, 324, 286, 12, 325, 325, 12, 325, 287, 36, 326, 326, 37, 326, 326, 36,
326, 294, 37, 326, 296, 36, 327, 327, 37, 327, 327, 36, 327, 296, 37, 327, 294, 39, 328, 328, 40, 328, 328, 39, 328,
294, 40, 328, 296, 39, 329, 329, 40, 329, 329, 39, 329, 296, 40, 329, 294, 42, 330, 330, 42, 330, 294, 36, 331, 331, 37,
331, 331, 36, 331, 295, 37, 331, 295, 39, 332, 332, 40, 332, 332, 39, 332, 295, 40, 332, 295, 42, 333, 333, 42, 333,
295, 42, 334, 334, 42, 334, 296, 36, 335, 335, 37, 335, 335, 36, 335, 307, 37, 335, 350, 36, 336, 336, 37, 336, 336, 36,
336, 350, 37, 336, 307, 39, 337, 337, 40, 337, 337, 39, 337, 307, 40, 337, 350, 39, 338, 338, 40, 338, 338, 39, 338,
350, 40, 338, 307, 42, 339, 339, 42, 339, 307, 36, 340, 340, 37, 340, 340, 36, 340, 308, 37, 340, 351, 36, 341, 341, 37,
341, 341, 36, 341, 351, 37, 341, 308, 39, 342, 342, 40, 342, 342, 39, 342, 308, 40, 342, 351, 39, 343, 343, 40, 343,
343, 39, 343, 351, 40, 343, 308, 42, 344, 344, 42, 344, 308, 36, 345, 345, 37, 345, 345, 36, 345, 309, 37, 345, 352, 36,
346, 346, 37, 346, 346, 36, 346, 352, 37, 346, 309, 39, 347, 347, 40, 347, 347, 39, 347, 309, 40, 347, 352, 39, 348,
348, 40, 348, 348, 39, 348, 352, 40, 348, 309, 42, 349, 349, 42, 349, 309, 34, 350, 350, 122, 350, 350, 123, 350, 350,
125, 350, 350, 126, 350, 350, 128, 350, 350, 34, 350, 353, 122, 350, 336, 123, 350, 335, 125, 350, 338, 126, 350, 337,
128, 350, 354, 34, 351, 351, 122, 351, 351, 123, 351, 351, 125, 351, 351, 126, 351, 351, 128, 351, 351, 34, 351, 355,
122, 351, 341, 123, 351, 340, 125, 351, 343, 126, 351, 342, 128, 351, 356, 34, 352, 352, 122, 352, 352, 123, 352, 352,
125, 352, 352, 126, 352, 352, 128, 352, 352, 34, 352, 357, 122, 352, 346, 123, 352, 345, 125, 352, 348, 126, 352, 347,
128, 352, 358, 120, 353, 353, 33, 353, 353, 120, 353, 350, 42, 354, 354, 42, 354, 350, 120, 355, 355, 33, 355, 355, 120,
355, 351, 42, 356, 356, 42, 356, 351, 120, 357, 357, 33, 357, 357, 120, 357, 352, 42, 358, 358, 42, 358, 352)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(83, 4, 179, 176, 83, 5, 180, 176, 83, 6, 181, 176, 83, 7, 179, 177, 85, 7, 167, 187, 83, 8, 180, 177, 85, 8, 167, 188,
83, 9, 181, 177, 85, 9, 167, 189, 85, 10, 167, 190, 83, 11, 179, 178, 85, 11, 168, 187, 83, 12, 180, 178, 85, 12, 168,
188, 83, 13, 181, 178, 85, 13, 168, 189, 85, 14, 168, 190, 90, 19, 181, 179, 90, 20, 181, 180, 90, 21, 181, 181, 90, 22,
180, 179, 90, 23, 180, 180, 90, 24, 180, 181, 90, 26, 179, 179, 90, 27, 179, 180, 90, 28, 179, 181, 1, 31, 86, 1, 2, 31,
87, 1, 1, 32, 88, 1, 2, 32, 89, 1, 1, 33, 90, 1, 2, 33, 91, 1, 1, 34, 92, 1, 2, 34, 93, 1, 1, 35, 94, 1, 2, 35, 95, 1,
1, 36, 96, 1, 2, 36, 97, 1, 1, 37, 98, 1, 2, 37, 99, 1, 1, 38, 100, 1, 2, 38, 101, 1, 1, 39, 102, 1, 2, 39, 103, 1, 1,
40, 104, 1, 2, 40, 105, 1, 1, 41, 106, 1, 2, 41, 107, 1, 1, 42, 108, 1, 2, 42, 109, 1, 1, 43, 110, 1, 2, 43, 111, 1, 1,
44, 112, 1, 2, 44, 113, 1, 1, 45, 114, 1, 2, 45, 115, 1, 152, 49, 182, 179, 152, 50, 182, 180, 152, 51, 182, 181, 152,
52, 183, 179, 152, 53, 183, 180, 152, 54, 183, 181, 156, 56, 173, 164, 152, 56, 184, 179, 156, 57, 173, 165, 152, 57,
184, 180, 156, 58, 173, 166, 152, 58, 184, 181, 156, 59, 173, 167, 156, 60, 173, 168, 65, 62, 174, 191, 157, 62, 197,
173, 65, 63, 175, 191, 157, 63, 198, 173, 65, 64, 174, 192, 65, 65, 175, 192, 157, 66, 199, 173, 65, 67, 174, 193, 65,
68, 175, 193, 157, 69, 200, 173, 65, 71, 174, 194, 65, 72, 175, 194, 157, 73, 201, 173, 170, 85, 179, 177, 171, 85, 179,
132, 170, 86, 180, 177, 171, 86, 180, 132, 170, 87, 181, 177, 171, 87, 181, 132, 170, 88, 179, 178, 171, 88, 179, 133,
170, 89, 180, 178, 171, 89, 180, 133, 170, 90, 181, 178, 171, 90, 181, 133, 84, 99, 167, 168, 84, 100, 168, 168, 163,
106, 175, 173, 163, 107, 174, 173, 81, 117, 160, 173, 81, 118, 159, 173, 81, 119, 158, 173, 89, 126, 169, 173, 89, 127,
170, 173, 89, 128, 171, 173, 89, 129, 172, 173, 23, 134, 185, 202, 23, 135, 185, 203, 142, 138, 204, 173, 106, 138, 205,
173, 109, 138, 206, 173, 142, 139, 207, 173, 106, 139, 208, 173, 109, 139, 209, 173, 169, 166, 187, 131, 169, 168, 188,
131, 169, 170, 189, 131, 169, 172, 190, 131, 158, 174, 182, 173, 158, 176, 183, 173, 158, 178, 184, 173, 110, 187, 206,
173, 110, 188, 209, 173, 110, 190, 210, 173, 143, 210, 211, 173, 143, 213, 212, 173, 136, 226, 213, 195, 136, 227, 214,
195, 24, 265, 185, 215, 24, 270, 185, 202, 24, 275, 185, 203, 33, 293, 216, 217, 122, 300, 218, 173, 123, 300, 219, 173,
125, 300, 220, 173, 126, 300, 221, 173, 128, 300, 222, 196, 122, 303, 223, 173, 123, 303, 223, 173, 125, 303, 224, 173,
126, 303, 224, 173, 128, 303, 225, 196, 33, 354, 186, 226, 33, 356, 186, 227, 33, 358, 186, 228)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  3: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=3
nb_c=293
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=590 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 83, 0, 0, 85, 0, 0, 164, 0, 0, 79, 0, 40, 83, 0, 116, 85, 0, 119, 164, 0, 20, 79, 1, 1, 85, 1, 1, 164, 1, 1,
83, 1, 1, 79, 1, 41, 85, 1, 120, 164, 1, 21, 79, 2, 2, 85, 2, 2, 164, 2, 2, 83, 2, 2, 79, 2, 42, 85, 2, 121, 164, 2, 22,
79, 3, 3, 85, 3, 3, 164, 3, 3, 83, 3, 3, 79, 3, 43, 85, 3, 122, 164, 3, 23, 79, 4, 4, 164, 4, 4, 83, 4, 4, 85, 4, 4, 79,
4, 44, 164, 4, 24, 79, 5, 5, 164, 5, 5, 83, 5, 5, 85, 5, 5, 79, 5, 45, 164, 5, 25, 79, 6, 6, 164, 6, 6, 83, 6, 6, 85, 6,
6, 79, 6, 46, 164, 6, 26, 79, 7, 7, 164, 7, 7, 83, 7, 7, 85, 7, 7, 79, 7, 47, 164, 7, 27, 79, 8, 8, 164, 8, 8, 83, 8, 8,
85, 8, 8, 79, 8, 48, 164, 8, 28, 79, 9, 9, 164, 9, 9, 83, 9, 9, 85, 9, 9, 79, 9, 49, 164, 9, 29, 79, 10, 10, 164, 10,
10, 83, 10, 10, 85, 10, 10, 79, 10, 50, 164, 10, 30, 79, 11, 11, 164, 11, 11, 83, 11, 11, 85, 11, 11, 79, 11, 51, 164,
11, 31, 79, 12, 12, 164, 12, 12, 83, 12, 12, 85, 12, 12, 79, 12, 52, 164, 12, 32, 79, 13, 13, 164, 13, 13, 83, 13, 13,
85, 13, 13, 79, 13, 53, 164, 13, 33, 79, 14, 14, 164, 14, 14, 83, 14, 14, 85, 14, 14, 79, 14, 54, 164, 14, 34, 79, 15,
15, 164, 15, 15, 83, 15, 15, 85, 15, 15, 79, 15, 55, 164, 15, 35, 79, 16, 16, 164, 16, 16, 83, 16, 16, 85, 16, 16, 79,
16, 56, 164, 16, 36, 79, 17, 17, 164, 17, 17, 83, 17, 17, 85, 17, 17, 79, 17, 57, 164, 17, 37, 79, 18, 18, 164, 18, 18,
83, 18, 18, 85, 18, 18, 79, 18, 58, 164, 18, 38, 79, 19, 19, 83, 19, 19, 164, 19, 19, 85, 19, 19, 79, 19, 59, 83, 19,
117, 164, 19, 39, 78, 20, 20, 90, 20, 20, 78, 20, 0, 90, 20, 116, 78, 21, 21, 90, 21, 21, 78, 21, 1, 78, 22, 22, 90, 22,
22, 78, 22, 2, 78, 23, 23, 90, 23, 23, 78, 23, 3, 78, 24, 24, 90, 24, 24, 78, 24, 4, 78, 25, 25, 90, 25, 25, 78, 25, 5,
78, 26, 26, 90, 26, 26, 78, 26, 6, 78, 27, 27, 90, 27, 27, 78, 27, 7, 78, 28, 28, 90, 28, 28, 78, 28, 8, 78, 29, 29, 90,
29, 29, 78, 29, 9, 78, 30, 30, 90, 30, 30, 78, 30, 10, 78, 31, 31, 90, 31, 31, 78, 31, 11, 78, 32, 32, 90, 32, 32, 78,
32, 12, 78, 33, 33, 90, 33, 33, 78, 33, 13, 78, 34, 34, 90, 34, 34, 78, 34, 14, 78, 35, 35, 90, 35, 35, 78, 35, 15, 78,
36, 36, 90, 36, 36, 78, 36, 16, 78, 37, 37, 90, 37, 37, 78, 37, 17, 78, 38, 38, 90, 38, 38, 78, 38, 18, 78, 39, 39, 90,
39, 39, 78, 39, 19, 90, 39, 116, 165, 40, 40, 172, 40, 40, 1, 40, 40, 2, 40, 40, 165, 40, 0, 172, 40, 60, 165, 41, 41,
172, 41, 41, 1, 41, 41, 2, 41, 41, 165, 41, 1, 172, 41, 61, 165, 42, 42, 172, 42, 42, 1, 42, 42, 2, 42, 42, 165, 42, 2,
172, 42, 62, 165, 43, 43, 172, 43, 43, 1, 43, 43, 2, 43, 43, 165, 43, 3, 172, 43, 63, 165, 44, 44, 172, 44, 44, 1, 44,
44, 2, 44, 44, 165, 44, 4, 172, 44, 64, 165, 45, 45, 172, 45, 45, 1, 45, 45, 2, 45, 45, 165, 45, 5, 172, 45, 65, 165,
46, 46, 172, 46, 46, 1, 46, 46, 2, 46, 46, 165, 46, 6, 172, 46, 66, 165, 47, 47, 172, 47, 47, 1, 47, 47, 2, 47, 47, 165,
47, 7, 172, 47, 67, 165, 48, 48, 172, 48, 48, 1, 48, 48, 2, 48, 48, 165, 48, 8, 172, 48, 68, 165, 49, 49, 172, 49, 49,
1, 49, 49, 2, 49, 49, 165, 49, 9, 172, 49, 69, 165, 50, 50, 172, 50, 50, 1, 50, 50, 2, 50, 50, 165, 50, 10, 172, 50, 70,
165, 51, 51, 172, 51, 51, 1, 51, 51, 2, 51, 51, 165, 51, 11, 172, 51, 71, 165, 52, 52, 172, 52, 52, 1, 52, 52, 2, 52,
52, 165, 52, 12, 172, 52, 72, 165, 53, 53, 172, 53, 53, 1, 53, 53, 2, 53, 53, 165, 53, 13, 172, 53, 73, 165, 54, 54,
172, 54, 54, 1, 54, 54, 2, 54, 54, 165, 54, 14, 172, 54, 74, 165, 55, 55, 172, 55, 55, 1, 55, 55, 2, 55, 55, 165, 55,
15, 172, 55, 75, 165, 56, 56, 172, 56, 56, 1, 56, 56, 2, 56, 56, 165, 56, 16, 172, 56, 76, 165, 57, 57, 172, 57, 57, 1,
57, 57, 2, 57, 57, 165, 57, 17, 172, 57, 77, 165, 58, 58, 172, 58, 58, 1, 58, 58, 2, 58, 58, 165, 58, 18, 172, 58, 78,
165, 59, 59, 172, 59, 59, 1, 59, 59, 2, 59, 59, 165, 59, 19, 172, 59, 79, 86, 60, 60, 156, 60, 60, 152, 60, 60, 86, 60,
40, 156, 60, 102, 152, 60, 116, 86, 61, 61, 156, 61, 61, 152, 61, 61, 86, 61, 41, 156, 61, 103, 86, 62, 62, 156, 62, 62,
152, 62, 62, 86, 62, 42, 156, 62, 104, 86, 63, 63, 156, 63, 63, 152, 63, 63, 86, 63, 43, 156, 63, 105, 86, 64, 64, 156,
64, 64, 152, 64, 64, 86, 64, 44, 156, 64, 106, 86, 65, 65, 156, 65, 65, 152, 65, 65, 86, 65, 45, 156, 65, 107, 86, 66,
66, 156, 66, 66, 152, 66, 66, 86, 66, 46, 156, 66, 108, 86, 67, 67, 156, 67, 67, 152, 67, 67, 86, 67, 47, 156, 67, 109,
86, 68, 68, 156, 68, 68, 152, 68, 68, 86, 68, 48, 156, 68, 110, 86, 69, 69, 156, 69, 69, 152, 69, 69, 86, 69, 49, 156,
69, 111, 86, 70, 70, 156, 70, 70, 152, 70, 70, 86, 70, 50, 86, 71, 71, 156, 71, 71, 152, 71, 71, 86, 71, 51, 86, 72, 72,
156, 72, 72, 152, 72, 72, 86, 72, 52, 86, 73, 73, 156, 73, 73, 152, 73, 73, 86, 73, 53, 86, 74, 74, 156, 74, 74, 152,
74, 74, 86, 74, 54, 86, 75, 75, 156, 75, 75, 152, 75, 75, 86, 75, 55, 86, 76, 76, 156, 76, 76, 152, 76, 76, 86, 76, 56,
86, 77, 77, 156, 77, 77, 152, 77, 77, 86, 77, 57, 86, 78, 78, 156, 78, 78, 152, 78, 78, 86, 78, 58, 86, 79, 79, 152, 79,
79, 156, 79, 79, 86, 79, 59, 152, 79, 118, 65, 80, 80, 157, 80, 80, 157, 81, 81, 65, 81, 81, 157, 81, 127, 65, 82, 82,
157, 82, 82, 65, 83, 83, 157, 83, 83, 157, 84, 84, 65, 84, 84, 157, 84, 128, 65, 85, 85, 157, 85, 85, 65, 86, 86, 157,
86, 86, 157, 87, 87, 65, 87, 87, 157, 87, 129, 157, 88, 88, 65, 88, 88, 157, 88, 130, 65, 89, 89, 157, 89, 89, 65, 89,
123, 157, 90, 90, 65, 90, 90, 157, 90, 131, 65, 91, 91, 157, 91, 91, 65, 92, 92, 157, 92, 92, 157, 93, 93, 65, 93, 93,
157, 93, 132, 157, 94, 94, 65, 94, 94, 157, 94, 133, 65, 95, 95, 157, 95, 95, 65, 95, 124, 157, 96, 96, 65, 96, 96, 157,
96, 134, 157, 97, 97, 65, 97, 97, 157, 97, 135, 65, 98, 98, 157, 98, 98, 65, 98, 125, 65, 99, 99, 157, 99, 99, 65, 99,
126, 157, 99, 136, 67, 100, 100, 168, 100, 100, 167, 100, 100, 118, 100, 100, 67, 100, 101, 168, 100, 118, 167, 100,
123, 118, 100, 140, 80, 101, 101, 153, 101, 101, 131, 101, 101, 80, 101, 116, 153, 101, 100, 131, 101, 141, 70, 102,
102, 170, 102, 102, 171, 102, 102, 170, 102, 102, 147, 102, 102, 70, 102, 60, 170, 102, 116, 171, 102, 116, 170, 102,
142, 147, 102, 143, 70, 103, 103, 170, 103, 103, 147, 103, 103, 170, 103, 103, 171, 103, 103, 70, 103, 61, 170, 103,
144, 147, 103, 145, 70, 104, 104, 170, 104, 104, 147, 104, 104, 170, 104, 104, 171, 104, 104, 70, 104, 62, 170, 104,
146, 147, 104, 147, 70, 105, 105, 170, 105, 105, 147, 105, 105, 170, 105, 105, 171, 105, 105, 70, 105, 63, 170, 105,
148, 147, 105, 149, 70, 106, 106, 170, 106, 106, 147, 106, 106, 170, 106, 106, 171, 106, 106, 70, 106, 64, 170, 106,
150, 147, 106, 151, 70, 107, 107, 170, 107, 107, 147, 107, 107, 170, 107, 107, 171, 107, 107, 70, 107, 65, 170, 107,
152, 147, 107, 153, 70, 108, 108, 170, 108, 108, 147, 108, 108, 170, 108, 108, 171, 108, 108, 70, 108, 66, 170, 108,
154, 147, 108, 155, 70, 109, 109, 170, 109, 109, 147, 109, 109, 170, 109, 109, 171, 109, 109, 70, 109, 67, 170, 109,
156, 147, 109, 157, 70, 110, 110, 170, 110, 110, 147, 110, 110, 170, 110, 110, 171, 110, 110, 70, 110, 68, 170, 110,
158, 147, 110, 159, 70, 111, 111, 170, 111, 111, 147, 111, 111, 170, 111, 111, 171, 111, 111, 70, 111, 69, 170, 111,
160, 147, 111, 161, 3, 112, 112, 154, 112, 112, 155, 112, 112, 3, 112, 127, 154, 112, 162, 155, 112, 163, 3, 113, 113,
154, 113, 113, 155, 113, 113, 3, 113, 128, 154, 113, 164, 155, 113, 165, 3, 114, 114, 154, 114, 114, 155, 114, 114, 3,
114, 129, 154, 114, 165, 155, 114, 164, 3, 115, 115, 154, 115, 115, 155, 115, 115, 3, 115, 130, 154, 115, 163, 155, 115,
162, 4, 116, 116, 4, 116, 116, 66, 116, 116, 84, 116, 116, 85, 116, 116, 166, 116, 116, 169, 116, 116, 4, 116, 39, 4,
116, 20, 66, 116, 60, 84, 116, 102, 85, 116, 102, 166, 116, 101, 169, 116, 0, 169, 117, 117, 84, 117, 117, 169, 117, 19,
82, 118, 118, 66, 118, 118, 72, 118, 118, 44, 118, 118, 139, 118, 118, 163, 118, 118, 82, 118, 100, 66, 118, 79, 72,
118, 163, 44, 118, 166, 139, 118, 138, 83, 119, 119, 171, 119, 119, 100, 119, 119, 83, 119, 142, 171, 119, 0, 100, 119,
167, 83, 120, 120, 171, 120, 120, 100, 120, 120, 83, 120, 144, 171, 120, 1, 100, 120, 168, 83, 121, 121, 171, 121, 121,
100, 121, 121, 83, 121, 146, 171, 121, 2, 100, 121, 169, 83, 122, 122, 171, 122, 122, 100, 122, 122, 83, 122, 148, 171,
122, 3, 100, 122, 139, 73, 123, 123, 81, 123, 123, 151, 123, 123, 103, 123, 123, 73, 123, 163, 81, 123, 100, 151, 123,
89, 103, 123, 170, 73, 124, 124, 151, 124, 124, 103, 124, 124, 81, 124, 124, 73, 124, 165, 151, 124, 95, 103, 124, 171,
73, 125, 125, 151, 125, 125, 103, 125, 125, 81, 125, 125, 73, 125, 164, 151, 125, 98, 103, 125, 172, 73, 126, 126, 151,
126, 126, 103, 126, 126, 81, 126, 126, 73, 126, 162, 151, 126, 99, 103, 126, 173, 71, 127, 127, 89, 127, 127, 94, 127,
127, 71, 127, 81, 89, 127, 112, 94, 127, 174, 71, 128, 128, 89, 128, 128, 94, 128, 128, 71, 128, 84, 89, 128, 113, 94,
128, 175, 71, 129, 129, 89, 129, 129, 94, 129, 129, 71, 129, 87, 89, 129, 114, 94, 129, 176, 71, 130, 130, 89, 130, 130,
94, 130, 130, 71, 130, 88, 89, 130, 115, 94, 130, 177, 71, 131, 131, 94, 131, 131, 89, 131, 131, 71, 131, 90, 94, 131,
178, 71, 132, 132, 94, 132, 132, 89, 132, 132, 71, 132, 93, 94, 132, 179, 71, 133, 133, 94, 133, 133, 89, 133, 133, 71,
133, 94, 94, 133, 180, 71, 134, 134, 94, 134, 134, 89, 134, 134, 71, 134, 96, 94, 134, 181, 71, 135, 135, 94, 135, 135,
89, 135, 135, 71, 135, 97, 94, 135, 182, 71, 136, 136, 94, 136, 136, 89, 136, 136, 71, 136, 99, 94, 136, 183, 24, 137,
137, 23, 137, 137, 24, 137, 173, 53, 138, 138, 140, 138, 138, 142, 138, 138, 110, 138, 138, 142, 138, 138, 106, 138,
138, 109, 138, 138, 53, 138, 118, 140, 138, 184, 142, 138, 185, 110, 138, 186, 14, 139, 139, 119, 139, 139, 14, 139,
122, 119, 139, 187, 32, 140, 140, 119, 140, 140, 120, 140, 140, 32, 140, 100, 119, 140, 188, 120, 140, 189, 45, 141,
141, 132, 141, 141, 45, 141, 101, 132, 141, 190, 84, 142, 142, 169, 142, 142, 84, 142, 102, 169, 142, 119, 61, 143, 143,
148, 143, 143, 128, 143, 143, 61, 143, 102, 148, 143, 191, 128, 143, 192, 84, 144, 144, 169, 144, 144, 84, 144, 103,
169, 144, 120, 61, 145, 145, 148, 145, 145, 128, 145, 145, 61, 145, 103, 148, 145, 193, 128, 145, 194, 84, 146, 146,
169, 146, 146, 84, 146, 104, 169, 146, 121, 61, 147, 147, 148, 147, 147, 128, 147, 147, 61, 147, 104, 148, 147, 195,
128, 147, 196, 84, 148, 148, 169, 148, 148, 84, 148, 105, 169, 148, 122, 61, 149, 149, 148, 149, 149, 128, 149, 149, 61,
149, 105, 148, 149, 197, 128, 149, 198, 84, 150, 150, 169, 150, 150, 84, 150, 106, 61, 151, 151, 148, 151, 151, 128,
151, 151, 61, 151, 106, 148, 151, 199, 128, 151, 200, 84, 152, 152, 169, 152, 152, 84, 152, 107, 61, 153, 153, 148, 153,
153, 128, 153, 153, 61, 153, 107, 148, 153, 201, 128, 153, 202, 84, 154, 154, 169, 154, 154, 84, 154, 108, 61, 155, 155,
148, 155, 155, 128, 155, 155, 61, 155, 108, 148, 155, 203, 128, 155, 204, 84, 156, 156, 169, 156, 156, 84, 156, 109, 61,
157, 157, 148, 157, 157, 128, 157, 157, 61, 157, 109, 148, 157, 205, 128, 157, 206, 84, 158, 158, 169, 158, 158, 84,
158, 110, 61, 159, 159, 148, 159, 159, 128, 159, 159, 61, 159, 110, 148, 159, 207, 128, 159, 208, 84, 160, 160, 169,
160, 160, 84, 160, 111, 61, 161, 161, 148, 161, 161, 128, 161, 161, 61, 161, 111, 148, 161, 209, 128, 161, 210, 68, 162,
162, 69, 162, 162, 159, 162, 162, 158, 162, 162, 68, 162, 112, 69, 162, 115, 159, 162, 126, 68, 163, 163, 69, 163, 163,
159, 163, 163, 158, 163, 163, 68, 163, 115, 69, 163, 112, 159, 163, 123, 158, 163, 118, 68, 164, 164, 69, 164, 164, 159,
164, 164, 158, 164, 164, 68, 164, 113, 69, 164, 114, 159, 164, 125, 68, 165, 165, 69, 165, 165, 159, 165, 165, 158, 165,
165, 68, 165, 114, 69, 165, 113, 159, 165, 124, 42, 166, 166, 130, 166, 166, 42, 166, 189, 130, 166, 118, 14, 167, 167,
119, 167, 167, 14, 167, 119, 119, 167, 211, 14, 168, 168, 119, 168, 168, 14, 168, 120, 119, 168, 212, 14, 169, 169, 119,
169, 169, 14, 169, 121, 119, 169, 213, 17, 170, 170, 104, 170, 170, 109, 170, 170, 112, 170, 170, 114, 170, 170, 116,
170, 170, 110, 170, 170, 17, 170, 123, 104, 170, 214, 109, 170, 186, 112, 170, 215, 114, 170, 216, 116, 170, 217, 17,
171, 171, 104, 171, 171, 109, 171, 171, 112, 171, 171, 114, 171, 171, 116, 171, 171, 110, 171, 171, 17, 171, 124, 104,
171, 218, 109, 171, 219, 112, 171, 220, 114, 171, 221, 116, 171, 222, 17, 172, 172, 104, 172, 172, 109, 172, 172, 112,
172, 172, 114, 172, 172, 116, 172, 172, 110, 172, 172, 17, 172, 125, 104, 172, 223, 109, 172, 224, 112, 172, 225, 114,
172, 226, 116, 172, 227, 17, 173, 173, 104, 173, 173, 109, 173, 173, 110, 173, 173, 112, 173, 173, 114, 173, 173, 116,
173, 173, 17, 173, 126, 104, 173, 228, 109, 173, 229, 110, 173, 137, 112, 173, 230, 114, 173, 231, 116, 173, 232, 8,
174, 174, 95, 174, 174, 8, 174, 127, 95, 174, 233, 8, 175, 175, 95, 175, 175, 8, 175, 128, 95, 175, 234, 8, 176, 176,
95, 176, 176, 8, 176, 129, 95, 176, 235, 8, 177, 177, 95, 177, 177, 8, 177, 130, 95, 177, 236, 8, 178, 178, 95, 178,
178, 8, 178, 131, 95, 178, 237, 8, 179, 179, 95, 179, 179, 8, 179, 132, 95, 179, 238, 8, 180, 180, 95, 180, 180, 8, 180,
133, 95, 180, 239, 8, 181, 181, 95, 181, 181, 8, 181, 134, 95, 181, 240, 8, 182, 182, 95, 182, 182, 8, 182, 135, 95,
182, 241, 8, 183, 183, 95, 183, 183, 8, 183, 136, 95, 183, 242, 54, 184, 184, 54, 184, 138, 56, 185, 185, 145, 185, 185,
143, 185, 185, 56, 185, 138, 145, 185, 243, 23, 186, 186, 24, 186, 186, 23, 186, 170, 24, 186, 138, 33, 187, 187, 120,
187, 187, 33, 187, 139, 120, 187, 244, 33, 188, 188, 120, 188, 188, 33, 188, 140, 120, 188, 245, 34, 189, 189, 122, 189,
189, 123, 189, 189, 125, 189, 189, 126, 189, 189, 128, 189, 189, 34, 189, 140, 122, 189, 246, 123, 189, 246, 125, 189,
247, 126, 189, 247, 128, 189, 166, 46, 190, 190, 134, 190, 190, 136, 190, 190, 46, 190, 141, 134, 190, 248, 62, 191,
191, 62, 191, 143, 42, 192, 192, 42, 192, 143, 62, 193, 193, 62, 193, 145, 42, 194, 194, 42, 194, 145, 62, 195, 195, 62,
195, 147, 42, 196, 196, 42, 196, 147, 62, 197, 197, 62, 197, 149, 42, 198, 198, 42, 198, 149, 62, 199, 199, 62, 199,
151, 42, 200, 200, 42, 200, 151, 62, 201, 201, 62, 201, 153, 42, 202, 202, 42, 202, 153, 62, 203, 203, 62, 203, 155, 42,
204, 204, 42, 204, 155, 62, 205, 205, 62, 205, 157, 42, 206, 206, 42, 206, 157, 62, 207, 207, 62, 207, 159, 42, 208,
208, 42, 208, 159, 62, 209, 209, 62, 209, 161, 42, 210, 210, 42, 210, 161, 33, 211, 211, 120, 211, 211, 33, 211, 167,
120, 211, 249, 33, 212, 212, 120, 212, 212, 33, 212, 168, 120, 212, 250, 33, 213, 213, 120, 213, 213, 33, 213, 169, 120,
213, 251, 18, 214, 214, 18, 214, 170, 26, 215, 215, 106, 215, 215, 26, 215, 170, 106, 215, 252, 28, 216, 216, 28, 216,
170, 30, 217, 217, 30, 217, 170, 18, 218, 218, 18, 218, 171, 23, 219, 219, 24, 219, 219, 23, 219, 171, 26, 220, 220,
106, 220, 220, 26, 220, 171, 106, 220, 253, 28, 221, 221, 28, 221, 171, 30, 222, 222, 30, 222, 171, 18, 223, 223, 18,
223, 172, 23, 224, 224, 24, 224, 224, 23, 224, 172, 26, 225, 225, 106, 225, 225, 26, 225, 172, 106, 225, 254, 28, 226,
226, 28, 226, 172, 30, 227, 227, 30, 227, 172, 18, 228, 228, 18, 228, 173, 23, 229, 229, 24, 229, 229, 23, 229, 173, 26,
230, 230, 106, 230, 230, 26, 230, 173, 106, 230, 255, 28, 231, 231, 28, 231, 173, 30, 232, 232, 30, 232, 173, 9, 233,
233, 98, 233, 233, 9, 233, 174, 98, 233, 256, 9, 234, 234, 98, 234, 234, 9, 234, 175, 98, 234, 257, 9, 235, 235, 98,
235, 235, 9, 235, 176, 98, 235, 258, 9, 236, 236, 98, 236, 236, 9, 236, 177, 98, 236, 259, 9, 237, 237, 98, 237, 237, 9,
237, 178, 98, 237, 260, 9, 238, 238, 98, 238, 238, 9, 238, 179, 98, 238, 261, 9, 239, 239, 98, 239, 239, 9, 239, 180,
98, 239, 262, 9, 240, 240, 98, 240, 240, 9, 240, 181, 98, 240, 263, 9, 241, 241, 98, 241, 241, 9, 241, 182, 98, 241,
264, 9, 242, 242, 98, 242, 242, 9, 242, 183, 98, 242, 265, 59, 243, 243, 59, 243, 185, 34, 244, 244, 122, 244, 244, 123,
244, 244, 125, 244, 244, 126, 244, 244, 128, 244, 244, 34, 244, 187, 122, 244, 266, 123, 244, 266, 125, 244, 267, 126,
244, 267, 128, 244, 268, 34, 245, 245, 122, 245, 245, 123, 245, 245, 125, 245, 245, 126, 245, 245, 128, 245, 245, 34,
245, 188, 36, 246, 246, 37, 246, 246, 36, 246, 189, 37, 246, 189, 39, 247, 247, 40, 247, 247, 39, 247, 189, 40, 247,
189, 48, 248, 248, 48, 248, 190, 34, 249, 249, 122, 249, 249, 123, 249, 249, 125, 249, 249, 126, 249, 249, 128, 249,
249, 34, 249, 211, 122, 249, 269, 123, 249, 270, 125, 249, 271, 126, 249, 272, 128, 249, 273, 34, 250, 250, 122, 250,
250, 123, 250, 250, 125, 250, 250, 126, 250, 250, 128, 250, 250, 34, 250, 212, 122, 250, 274, 123, 250, 275, 125, 250,
276, 126, 250, 277, 128, 250, 278, 34, 251, 251, 122, 251, 251, 123, 251, 251, 125, 251, 251, 126, 251, 251, 128, 251,
251, 34, 251, 213, 122, 251, 279, 123, 251, 280, 125, 251, 281, 126, 251, 282, 128, 251, 283, 20, 252, 252, 20, 252,
215, 20, 253, 253, 20, 253, 220, 20, 254, 254, 20, 254, 225, 20, 255, 255, 20, 255, 230, 12, 256, 256, 12, 256, 233, 12,
257, 257, 12, 257, 234, 12, 258, 258, 12, 258, 235, 12, 259, 259, 12, 259, 236, 12, 260, 260, 12, 260, 237, 12, 261,
261, 12, 261, 238, 12, 262, 262, 12, 262, 239, 12, 263, 263, 12, 263, 240, 12, 264, 264, 12, 264, 241, 12, 265, 265, 12,
265, 242, 36, 266, 266, 37, 266, 266, 36, 266, 244, 37, 266, 244, 39, 267, 267, 40, 267, 267, 39, 267, 244, 40, 267,
244, 42, 268, 268, 42, 268, 244, 36, 269, 269, 37, 269, 269, 36, 269, 249, 37, 269, 284, 36, 270, 270, 37, 270, 270, 36,
270, 284, 37, 270, 249, 39, 271, 271, 40, 271, 271, 39, 271, 249, 40, 271, 284, 39, 272, 272, 40, 272, 272, 39, 272,
284, 40, 272, 249, 42, 273, 273, 42, 273, 249, 36, 274, 274, 37, 274, 274, 36, 274, 250, 37, 274, 285, 36, 275, 275, 37,
275, 275, 36, 275, 285, 37, 275, 250, 39, 276, 276, 40, 276, 276, 39, 276, 250, 40, 276, 285, 39, 277, 277, 40, 277,
277, 39, 277, 285, 40, 277, 250, 42, 278, 278, 42, 278, 250, 36, 279, 279, 37, 279, 279, 36, 279, 251, 37, 279, 286, 36,
280, 280, 37, 280, 280, 36, 280, 286, 37, 280, 251, 39, 281, 281, 40, 281, 281, 39, 281, 251, 40, 281, 286, 39, 282,
282, 40, 282, 282, 39, 282, 286, 40, 282, 251, 42, 283, 283, 42, 283, 251, 34, 284, 284, 122, 284, 284, 123, 284, 284,
125, 284, 284, 126, 284, 284, 128, 284, 284, 34, 284, 287, 122, 284, 270, 123, 284, 269, 125, 284, 272, 126, 284, 271,
128, 284, 288, 34, 285, 285, 122, 285, 285, 123, 285, 285, 125, 285, 285, 126, 285, 285, 128, 285, 285, 34, 285, 289,
122, 285, 275, 123, 285, 274, 125, 285, 277, 126, 285, 276, 128, 285, 290, 34, 286, 286, 122, 286, 286, 123, 286, 286,
125, 286, 286, 126, 286, 286, 128, 286, 286, 34, 286, 291, 122, 286, 280, 123, 286, 279, 125, 286, 282, 126, 286, 281,
128, 286, 292, 120, 287, 287, 33, 287, 287, 120, 287, 284, 42, 288, 288, 42, 288, 284, 120, 289, 289, 33, 289, 289, 120,
289, 285, 42, 290, 290, 42, 290, 285, 120, 291, 291, 33, 291, 291, 120, 291, 286, 42, 292, 292, 42, 292, 286)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(83, 2, 460, 176, 83, 3, 461, 176, 83, 4, 462, 176, 83, 5, 460, 177, 85, 5, 167, 466, 83, 6, 461, 177, 85, 6, 167, 467,
83, 7, 462, 177, 85, 7, 167, 468, 83, 8, 179, 457, 85, 8, 167, 469, 83, 9, 180, 457, 85, 9, 167, 470, 83, 10, 181, 457,
85, 10, 167, 471, 83, 11, 460, 178, 85, 11, 168, 466, 83, 12, 461, 178, 85, 12, 168, 467, 83, 13, 462, 178, 85, 13, 168,
468, 83, 14, 179, 458, 85, 14, 168, 469, 83, 15, 180, 458, 85, 15, 168, 470, 83, 16, 181, 458, 85, 16, 168, 471, 83, 17,
179, 459, 85, 17, 449, 187, 83, 18, 180, 459, 85, 18, 449, 188, 83, 19, 181, 459, 85, 19, 449, 189, 85, 20, 449, 190,
90, 22, 181, 460, 90, 23, 181, 461, 90, 24, 181, 462, 90, 25, 180, 460, 90, 26, 180, 461, 90, 27, 180, 462, 90, 28, 462,
179, 90, 29, 462, 180, 90, 30, 462, 181, 90, 31, 179, 460, 90, 32, 179, 461, 90, 33, 179, 462, 90, 34, 461, 179, 90, 35,
461, 180, 90, 36, 461, 181, 90, 37, 460, 179, 90, 38, 460, 180, 90, 39, 460, 181, 1, 41, 46, 1, 2, 41, 47, 1, 1, 42, 48,
1, 2, 42, 49, 1, 1, 43, 50, 1, 2, 43, 51, 1, 1, 44, 52, 1, 2, 44, 53, 1, 1, 45, 54, 1, 2, 45, 55, 1, 1, 46, 56, 1, 2,
46, 57, 1, 1, 47, 58, 1, 2, 47, 59, 1, 1, 48, 60, 1, 2, 48, 61, 1, 1, 49, 62, 1, 2, 49, 63, 1, 1, 50, 64, 1, 2, 50, 65,
1, 1, 51, 66, 1, 2, 51, 67, 1, 1, 52, 68, 1, 2, 52, 69, 1, 1, 53, 70, 1, 2, 53, 71, 1, 1, 54, 72, 1, 2, 54, 73, 1, 1,
55, 74, 1, 2, 55, 75, 1, 1, 56, 76, 1, 2, 56, 77, 1, 1, 57, 78, 1, 2, 57, 79, 1, 1, 58, 80, 1, 2, 58, 81, 1, 1, 59, 82,
1, 2, 59, 83, 1, 1, 60, 84, 1, 2, 60, 85, 1, 152, 62, 182, 460, 152, 63, 182, 461, 152, 64, 182, 462, 152, 65, 183, 460,
152, 66, 183, 461, 152, 67, 183, 462, 152, 68, 463, 179, 152, 69, 463, 180, 152, 70, 463, 181, 156, 71, 173, 440, 152,
71, 184, 460, 156, 72, 173, 441, 152, 72, 184, 461, 156, 73, 173, 442, 152, 73, 184, 462, 156, 74, 173, 443, 152, 74,
464, 179, 156, 75, 173, 444, 152, 75, 464, 180, 156, 76, 173, 445, 152, 76, 464, 181, 156, 77, 173, 446, 152, 77, 465,
179, 156, 78, 173, 447, 152, 78, 465, 180, 156, 79, 173, 448, 152, 79, 465, 181, 156, 80, 173, 449, 65, 81, 456, 191,
157, 81, 478, 173, 65, 82, 456, 192, 65, 83, 174, 472, 157, 83, 479, 173, 65, 84, 175, 472, 157, 84, 480, 173, 65, 85,
456, 193, 65, 86, 174, 473, 157, 86, 481, 173, 65, 87, 175, 473, 157, 87, 482, 173, 65, 88, 174, 474, 65, 89, 175, 474,
157, 90, 483, 173, 65, 91, 456, 194, 65, 92, 174, 475, 157, 92, 484, 173, 65, 93, 175, 475, 157, 93, 485, 173, 65, 94,
174, 476, 65, 95, 175, 476, 157, 96, 486, 173, 65, 97, 174, 477, 65, 98, 175, 477, 157, 99, 487, 173, 170, 104, 460,
177, 171, 104, 460, 132, 170, 105, 461, 177, 171, 105, 461, 132, 170, 106, 462, 177, 171, 106, 462, 132, 170, 107, 460,
178, 171, 107, 460, 133, 170, 108, 461, 178, 171, 108, 461, 133, 170, 109, 462, 178, 171, 109, 462, 133, 170, 110, 179,
459, 171, 110, 179, 373, 170, 111, 180, 459, 171, 111, 180, 373, 170, 112, 181, 459, 171, 112, 181, 373, 84, 118, 449,
168, 163, 119, 456, 173, 81, 125, 436, 173, 81, 126, 435, 173, 81, 127, 434, 173, 89, 132, 450, 173, 89, 133, 451, 173,
89, 134, 453, 173, 89, 135, 452, 173, 89, 136, 454, 173, 89, 137, 455, 173, 23, 138, 185, 488, 142, 139, 489, 173, 106,
139, 490, 173, 109, 139, 491, 173, 169, 151, 466, 131, 169, 153, 467, 131, 169, 155, 468, 131, 169, 157, 469, 131, 169,
159, 470, 131, 169, 161, 471, 131, 158, 163, 463, 173, 158, 165, 464, 173, 158, 166, 465, 173, 110, 171, 491, 173, 110,
172, 492, 173, 110, 173, 493, 173, 143, 186, 494, 173, 136, 191, 495, 195, 24, 220, 185, 496, 24, 225, 185, 497, 24,
230, 185, 488, 122, 246, 498, 173, 123, 246, 499, 173, 125, 246, 500, 173, 126, 246, 501, 173, 128, 246, 502, 196, 33,
288, 186, 503, 33, 290, 186, 504, 33, 292, 186, 505)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  4: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=4
nb_c=142
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=883 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 85, 0, 0, 164, 0, 0, 83, 0, 0, 79, 0, 30, 85, 0, 81, 164, 0, 15, 79, 1, 1, 164, 1, 1, 83, 1, 1, 85, 1, 1, 79,
1, 31, 164, 1, 16, 79, 2, 2, 164, 2, 2, 83, 2, 2, 85, 2, 2, 79, 2, 32, 164, 2, 17, 79, 3, 3, 164, 3, 3, 83, 3, 3, 85, 3,
3, 79, 3, 33, 164, 3, 18, 79, 4, 4, 164, 4, 4, 83, 4, 4, 85, 4, 4, 79, 4, 34, 164, 4, 19, 79, 5, 5, 164, 5, 5, 83, 5, 5,
85, 5, 5, 79, 5, 35, 164, 5, 20, 79, 6, 6, 164, 6, 6, 83, 6, 6, 85, 6, 6, 79, 6, 36, 164, 6, 21, 79, 7, 7, 164, 7, 7,
83, 7, 7, 85, 7, 7, 79, 7, 37, 164, 7, 22, 79, 8, 8, 164, 8, 8, 83, 8, 8, 85, 8, 8, 79, 8, 38, 164, 8, 23, 79, 9, 9,
164, 9, 9, 83, 9, 9, 85, 9, 9, 79, 9, 39, 164, 9, 24, 79, 10, 10, 164, 10, 10, 83, 10, 10, 85, 10, 10, 79, 10, 40, 164,
10, 25, 79, 11, 11, 164, 11, 11, 83, 11, 11, 85, 11, 11, 79, 11, 41, 164, 11, 26, 79, 12, 12, 164, 12, 12, 83, 12, 12,
85, 12, 12, 79, 12, 42, 164, 12, 27, 79, 13, 13, 164, 13, 13, 83, 13, 13, 85, 13, 13, 79, 13, 43, 164, 13, 28, 79, 14,
14, 164, 14, 14, 83, 14, 14, 85, 14, 14, 79, 14, 44, 164, 14, 29, 78, 15, 15, 90, 15, 15, 78, 15, 0, 78, 16, 16, 90, 16,
16, 78, 16, 1, 78, 17, 17, 90, 17, 17, 78, 17, 2, 78, 18, 18, 90, 18, 18, 78, 18, 3, 78, 19, 19, 90, 19, 19, 78, 19, 4,
78, 20, 20, 90, 20, 20, 78, 20, 5, 78, 21, 21, 90, 21, 21, 78, 21, 6, 78, 22, 22, 90, 22, 22, 78, 22, 7, 78, 23, 23, 90,
23, 23, 78, 23, 8, 78, 24, 24, 90, 24, 24, 78, 24, 9, 78, 25, 25, 90, 25, 25, 78, 25, 10, 78, 26, 26, 90, 26, 26, 78,
26, 11, 78, 27, 27, 90, 27, 27, 78, 27, 12, 78, 28, 28, 90, 28, 28, 78, 28, 13, 78, 29, 29, 90, 29, 29, 78, 29, 14, 165,
30, 30, 172, 30, 30, 1, 30, 30, 2, 30, 30, 165, 30, 0, 172, 30, 45, 165, 31, 31, 172, 31, 31, 1, 31, 31, 2, 31, 31, 165,
31, 1, 172, 31, 46, 165, 32, 32, 172, 32, 32, 1, 32, 32, 2, 32, 32, 165, 32, 2, 172, 32, 47, 165, 33, 33, 172, 33, 33,
1, 33, 33, 2, 33, 33, 165, 33, 3, 172, 33, 48, 165, 34, 34, 172, 34, 34, 1, 34, 34, 2, 34, 34, 165, 34, 4, 172, 34, 49,
165, 35, 35, 172, 35, 35, 1, 35, 35, 2, 35, 35, 165, 35, 5, 172, 35, 50, 165, 36, 36, 172, 36, 36, 1, 36, 36, 2, 36, 36,
165, 36, 6, 172, 36, 51, 165, 37, 37, 172, 37, 37, 1, 37, 37, 2, 37, 37, 165, 37, 7, 172, 37, 52, 165, 38, 38, 172, 38,
38, 1, 38, 38, 2, 38, 38, 165, 38, 8, 172, 38, 53, 165, 39, 39, 172, 39, 39, 1, 39, 39, 2, 39, 39, 165, 39, 9, 172, 39,
54, 165, 40, 40, 172, 40, 40, 1, 40, 40, 2, 40, 40, 165, 40, 10, 172, 40, 55, 165, 41, 41, 172, 41, 41, 1, 41, 41, 2,
41, 41, 165, 41, 11, 172, 41, 56, 165, 42, 42, 172, 42, 42, 1, 42, 42, 2, 42, 42, 165, 42, 12, 172, 42, 57, 165, 43, 43,
172, 43, 43, 1, 43, 43, 2, 43, 43, 165, 43, 13, 172, 43, 58, 165, 44, 44, 172, 44, 44, 1, 44, 44, 2, 44, 44, 165, 44,
14, 172, 44, 59, 86, 45, 45, 156, 45, 45, 152, 45, 45, 86, 45, 30, 156, 45, 75, 86, 46, 46, 156, 46, 46, 152, 46, 46,
86, 46, 31, 156, 46, 76, 86, 47, 47, 156, 47, 47, 152, 47, 47, 86, 47, 32, 156, 47, 77, 86, 48, 48, 156, 48, 48, 152,
48, 48, 86, 48, 33, 156, 48, 78, 86, 49, 49, 156, 49, 49, 152, 49, 49, 86, 49, 34, 156, 49, 79, 86, 50, 50, 156, 50, 50,
152, 50, 50, 86, 50, 35, 86, 51, 51, 156, 51, 51, 152, 51, 51, 86, 51, 36, 86, 52, 52, 156, 52, 52, 152, 52, 52, 86, 52,
37, 86, 53, 53, 156, 53, 53, 152, 53, 53, 86, 53, 38, 86, 54, 54, 156, 54, 54, 152, 54, 54, 86, 54, 39, 86, 55, 55, 156,
55, 55, 152, 55, 55, 86, 55, 40, 86, 56, 56, 156, 56, 56, 152, 56, 56, 86, 56, 41, 86, 57, 57, 156, 57, 57, 152, 57, 57,
86, 57, 42, 86, 58, 58, 156, 58, 58, 152, 58, 58, 86, 58, 43, 86, 59, 59, 156, 59, 59, 152, 59, 59, 86, 59, 44, 65, 60,
60, 157, 60, 60, 65, 61, 61, 157, 61, 61, 157, 62, 62, 65, 62, 62, 157, 62, 83, 65, 63, 63, 157, 63, 63, 65, 64, 64,
157, 64, 64, 65, 65, 65, 157, 65, 65, 157, 66, 66, 65, 66, 66, 157, 66, 84, 65, 67, 67, 157, 67, 67, 65, 68, 68, 157,
68, 68, 157, 69, 69, 65, 69, 69, 157, 69, 85, 65, 70, 70, 157, 70, 70, 65, 71, 71, 157, 71, 71, 157, 72, 72, 65, 72, 72,
157, 72, 86, 157, 73, 73, 65, 73, 73, 157, 73, 87, 65, 74, 74, 157, 74, 74, 65, 74, 82, 70, 75, 75, 170, 75, 75, 147,
75, 75, 170, 75, 75, 171, 75, 75, 70, 75, 45, 170, 75, 88, 147, 75, 89, 70, 76, 76, 170, 76, 76, 147, 76, 76, 170, 76,
76, 171, 76, 76, 70, 76, 46, 170, 76, 90, 147, 76, 91, 70, 77, 77, 170, 77, 77, 147, 77, 77, 170, 77, 77, 171, 77, 77,
70, 77, 47, 170, 77, 92, 147, 77, 93, 70, 78, 78, 170, 78, 78, 147, 78, 78, 170, 78, 78, 171, 78, 78, 70, 78, 48, 170,
78, 94, 147, 78, 95, 70, 79, 79, 170, 79, 79, 147, 79, 79, 170, 79, 79, 171, 79, 79, 70, 79, 49, 170, 79, 96, 147, 79,
97, 3, 80, 80, 154, 80, 80, 155, 80, 80, 3, 80, 83, 154, 80, 98, 155, 80, 98, 83, 81, 81, 171, 81, 81, 100, 81, 81, 83,
81, 88, 171, 81, 0, 100, 81, 99, 73, 82, 82, 151, 82, 82, 103, 82, 82, 81, 82, 82, 73, 82, 98, 151, 82, 74, 103, 82,
100, 71, 83, 83, 89, 83, 83, 94, 83, 83, 71, 83, 62, 89, 83, 80, 94, 83, 101, 71, 84, 84, 94, 84, 84, 89, 84, 84, 71,
84, 66, 94, 84, 102, 71, 85, 85, 94, 85, 85, 89, 85, 85, 71, 85, 69, 94, 85, 103, 71, 86, 86, 94, 86, 86, 89, 86, 86,
71, 86, 72, 94, 86, 104, 71, 87, 87, 94, 87, 87, 89, 87, 87, 71, 87, 73, 94, 87, 105, 84, 88, 88, 169, 88, 88, 84, 88,
75, 169, 88, 81, 61, 89, 89, 148, 89, 89, 128, 89, 89, 61, 89, 75, 148, 89, 106, 128, 89, 107, 84, 90, 90, 169, 90, 90,
84, 90, 76, 61, 91, 91, 148, 91, 91, 128, 91, 91, 61, 91, 76, 148, 91, 108, 128, 91, 109, 84, 92, 92, 169, 92, 92, 84,
92, 77, 61, 93, 93, 148, 93, 93, 128, 93, 93, 61, 93, 77, 148, 93, 110, 128, 93, 111, 84, 94, 94, 169, 94, 94, 84, 94,
78, 61, 95, 95, 148, 95, 95, 128, 95, 95, 61, 95, 78, 148, 95, 112, 128, 95, 113, 84, 96, 96, 169, 96, 96, 84, 96, 79,
61, 97, 97, 148, 97, 97, 128, 97, 97, 61, 97, 79, 148, 97, 114, 128, 97, 115, 68, 98, 98, 69, 98, 98, 159, 98, 98, 158,
98, 98, 68, 98, 80, 69, 98, 80, 159, 98, 82, 14, 99, 99, 119, 99, 99, 14, 99, 81, 119, 99, 116, 17, 100, 100, 104, 100,
100, 109, 100, 100, 112, 100, 100, 114, 100, 100, 116, 100, 100, 110, 100, 100, 17, 100, 82, 104, 100, 117, 109, 100,
118, 112, 100, 119, 114, 100, 120, 116, 100, 121, 8, 101, 101, 95, 101, 101, 8, 101, 83, 95, 101, 122, 8, 102, 102, 95,
102, 102, 8, 102, 84, 95, 102, 123, 8, 103, 103, 95, 103, 103, 8, 103, 85, 95, 103, 124, 8, 104, 104, 95, 104, 104, 8,
104, 86, 95, 104, 125, 8, 105, 105, 95, 105, 105, 8, 105, 87, 95, 105, 126, 62, 106, 106, 62, 106, 89, 42, 107, 107, 42,
107, 89, 62, 108, 108, 62, 108, 91, 42, 109, 109, 42, 109, 91, 62, 110, 110, 62, 110, 93, 42, 111, 111, 42, 111, 93, 62,
112, 112, 62, 112, 95, 42, 113, 113, 42, 113, 95, 62, 114, 114, 62, 114, 97, 42, 115, 115, 42, 115, 97, 33, 116, 116,
120, 116, 116, 33, 116, 99, 120, 116, 127, 18, 117, 117, 18, 117, 100, 23, 118, 118, 24, 118, 118, 23, 118, 100, 26,
119, 119, 106, 119, 119, 26, 119, 100, 106, 119, 128, 28, 120, 120, 28, 120, 100, 30, 121, 121, 30, 121, 100, 9, 122,
122, 98, 122, 122, 9, 122, 101, 98, 122, 129, 9, 123, 123, 98, 123, 123, 9, 123, 102, 98, 123, 130, 9, 124, 124, 98,
124, 124, 9, 124, 103, 98, 124, 131, 9, 125, 125, 98, 125, 125, 9, 125, 104, 98, 125, 132, 9, 126, 126, 98, 126, 126, 9,
126, 105, 98, 126, 133, 34, 127, 127, 122, 127, 127, 123, 127, 127, 125, 127, 127, 126, 127, 127, 128, 127, 127, 34,
127, 116, 122, 127, 134, 123, 127, 135, 125, 127, 136, 126, 127, 137, 128, 127, 138, 20, 128, 128, 20, 128, 119, 12,
129, 129, 12, 129, 122, 12, 130, 130, 12, 130, 123, 12, 131, 131, 12, 131, 124, 12, 132, 132, 12, 132, 125, 12, 133,
133, 12, 133, 126, 36, 134, 134, 37, 134, 134, 36, 134, 127, 37, 134, 139, 36, 135, 135, 37, 135, 135, 36, 135, 139, 37,
135, 127, 39, 136, 136, 40, 136, 136, 39, 136, 127, 40, 136, 139, 39, 137, 137, 40, 137, 137, 39, 137, 139, 40, 137,
127, 42, 138, 138, 42, 138, 127, 34, 139, 139, 122, 139, 139, 123, 139, 139, 125, 139, 139, 126, 139, 139, 128, 139,
139, 34, 139, 140, 122, 139, 135, 123, 139, 134, 125, 139, 137, 126, 139, 136, 128, 139, 141, 120, 140, 140, 33, 140,
140, 120, 140, 139, 42, 141, 141, 42, 141, 139)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(83, 1, 834, 176, 83, 2, 834, 177, 85, 2, 167, 837, 83, 3, 460, 457, 85, 3, 167, 838, 83, 4, 461, 457, 85, 4, 167, 839,
83, 5, 462, 457, 85, 5, 167, 840, 83, 6, 834, 178, 85, 6, 168, 837, 83, 7, 460, 458, 85, 7, 168, 838, 83, 8, 461, 458,
85, 8, 168, 839, 83, 9, 462, 458, 85, 9, 168, 840, 83, 10, 460, 459, 85, 10, 449, 466, 83, 11, 461, 459, 85, 11, 449,
467, 83, 12, 462, 459, 85, 12, 449, 468, 83, 13, 179, 835, 85, 13, 449, 469, 83, 14, 180, 835, 85, 14, 449, 470, 83, 15,
181, 835, 85, 15, 449, 471, 90, 16, 181, 834, 90, 17, 180, 834, 90, 18, 462, 460, 90, 19, 462, 461, 90, 20, 462, 462,
90, 21, 179, 834, 90, 22, 461, 460, 90, 23, 461, 461, 90, 24, 461, 462, 90, 25, 460, 460, 90, 26, 460, 461, 90, 27, 460,
462, 90, 28, 834, 179, 90, 29, 834, 180, 90, 30, 834, 181, 1, 31, 16, 1, 2, 31, 17, 1, 1, 32, 18, 1, 2, 32, 19, 1, 1,
33, 20, 1, 2, 33, 21, 1, 1, 34, 22, 1, 2, 34, 23, 1, 1, 35, 24, 1, 2, 35, 25, 1, 1, 36, 26, 1, 2, 36, 27, 1, 1, 37, 28,
1, 2, 37, 29, 1, 1, 38, 30, 1, 2, 38, 31, 1, 1, 39, 32, 1, 2, 39, 33, 1, 1, 40, 34, 1, 2, 40, 35, 1, 1, 41, 36, 1, 2,
41, 37, 1, 1, 42, 38, 1, 2, 42, 39, 1, 1, 43, 40, 1, 2, 43, 41, 1, 1, 44, 42, 1, 2, 44, 43, 1, 1, 45, 44, 1, 2, 45, 45,
1, 152, 46, 182, 834, 152, 47, 183, 834, 152, 48, 463, 460, 152, 49, 463, 461, 152, 50, 463, 462, 156, 51, 173, 820,
152, 51, 184, 834, 156, 52, 173, 821, 152, 52, 464, 460, 156, 53, 173, 822, 152, 53, 464, 461, 156, 54, 173, 823, 152,
54, 464, 462, 156, 55, 173, 824, 152, 55, 465, 460, 156, 56, 173, 825, 152, 56, 465, 461, 156, 57, 173, 826, 152, 57,
465, 462, 156, 58, 173, 827, 152, 58, 836, 179, 156, 59, 173, 828, 152, 59, 836, 180, 156, 60, 173, 829, 152, 60, 836,
181, 65, 61, 456, 472, 157, 61, 845, 173, 65, 62, 456, 473, 157, 62, 846, 173, 65, 63, 456, 474, 65, 64, 174, 841, 157,
64, 847, 173, 65, 65, 175, 841, 157, 65, 848, 173, 65, 66, 456, 475, 157, 66, 849, 173, 65, 67, 456, 476, 65, 68, 174,
842, 157, 68, 850, 173, 65, 69, 175, 842, 157, 69, 851, 173, 65, 70, 456, 477, 65, 71, 174, 843, 157, 71, 852, 173, 65,
72, 175, 843, 157, 72, 853, 173, 65, 73, 174, 844, 65, 74, 175, 844, 157, 75, 854, 173, 170, 76, 834, 177, 171, 76, 834,
132, 170, 77, 834, 178, 171, 77, 834, 133, 170, 78, 460, 459, 171, 78, 460, 373, 170, 79, 461, 459, 171, 79, 461, 373,
170, 80, 462, 459, 171, 80, 462, 373, 81, 83, 818, 173, 89, 85, 830, 173, 89, 86, 831, 173, 89, 87, 832, 173, 89, 88,
833, 173, 169, 91, 837, 131, 169, 93, 838, 131, 169, 95, 839, 131, 169, 97, 840, 131, 158, 99, 836, 173, 110, 101, 855,
173, 24, 119, 185, 856, 33, 141, 186, 857)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  5: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=5
nb_c=39
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1025 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 164, 0, 0, 83, 0, 0, 85, 0, 0, 79, 0, 12, 164, 0, 6, 79, 1, 1, 164, 1, 1, 83, 1, 1, 85, 1, 1, 79, 1, 13, 164,
1, 7, 79, 2, 2, 164, 2, 2, 83, 2, 2, 85, 2, 2, 79, 2, 14, 164, 2, 8, 79, 3, 3, 164, 3, 3, 83, 3, 3, 85, 3, 3, 79, 3, 15,
164, 3, 9, 79, 4, 4, 164, 4, 4, 83, 4, 4, 85, 4, 4, 79, 4, 16, 164, 4, 10, 79, 5, 5, 164, 5, 5, 83, 5, 5, 85, 5, 5, 79,
5, 17, 164, 5, 11, 78, 6, 6, 90, 6, 6, 78, 6, 0, 78, 7, 7, 90, 7, 7, 78, 7, 1, 78, 8, 8, 90, 8, 8, 78, 8, 2, 78, 9, 9,
90, 9, 9, 78, 9, 3, 78, 10, 10, 90, 10, 10, 78, 10, 4, 78, 11, 11, 90, 11, 11, 78, 11, 5, 165, 12, 12, 172, 12, 12, 1,
12, 12, 2, 12, 12, 165, 12, 0, 172, 12, 18, 165, 13, 13, 172, 13, 13, 1, 13, 13, 2, 13, 13, 165, 13, 1, 172, 13, 19,
165, 14, 14, 172, 14, 14, 1, 14, 14, 2, 14, 14, 165, 14, 2, 172, 14, 20, 165, 15, 15, 172, 15, 15, 1, 15, 15, 2, 15, 15,
165, 15, 3, 172, 15, 21, 165, 16, 16, 172, 16, 16, 1, 16, 16, 2, 16, 16, 165, 16, 4, 172, 16, 22, 165, 17, 17, 172, 17,
17, 1, 17, 17, 2, 17, 17, 165, 17, 5, 172, 17, 23, 86, 18, 18, 156, 18, 18, 152, 18, 18, 86, 18, 12, 156, 18, 30, 86,
19, 19, 156, 19, 19, 152, 19, 19, 86, 19, 13, 86, 20, 20, 156, 20, 20, 152, 20, 20, 86, 20, 14, 86, 21, 21, 156, 21, 21,
152, 21, 21, 86, 21, 15, 86, 22, 22, 156, 22, 22, 152, 22, 22, 86, 22, 16, 86, 23, 23, 156, 23, 23, 152, 23, 23, 86, 23,
17, 65, 24, 24, 157, 24, 24, 65, 25, 25, 157, 25, 25, 65, 26, 26, 157, 26, 26, 157, 27, 27, 65, 27, 27, 157, 27, 31, 65,
28, 28, 157, 28, 28, 65, 29, 29, 157, 29, 29, 70, 30, 30, 170, 30, 30, 147, 30, 30, 170, 30, 30, 171, 30, 30, 70, 30,
18, 170, 30, 32, 147, 30, 33, 71, 31, 31, 94, 31, 31, 89, 31, 31, 71, 31, 27, 94, 31, 34, 84, 32, 32, 169, 32, 32, 84,
32, 30, 61, 33, 33, 148, 33, 33, 128, 33, 33, 61, 33, 30, 148, 33, 35, 128, 33, 36, 8, 34, 34, 95, 34, 34, 8, 34, 31,
95, 34, 37, 62, 35, 35, 62, 35, 33, 42, 36, 36, 42, 36, 33, 9, 37, 37, 98, 37, 37, 9, 37, 34, 98, 37, 38, 12, 38, 38,
12, 38, 37)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(83, 1, 834, 457, 85, 1, 167, 1092, 83, 2, 834, 458, 85, 2, 168, 1092, 83, 3, 834, 459, 85, 3, 449, 837, 83, 4, 460, 835,
85, 4, 449, 838, 83, 5, 461, 835, 85, 5, 449, 839, 83, 6, 462, 835, 85, 6, 449, 840, 90, 7, 462, 834, 90, 8, 461, 834,
90, 9, 460, 834, 90, 10, 834, 460, 90, 11, 834, 461, 90, 12, 834, 462, 1, 13, 4, 1, 2, 13, 5, 1, 1, 14, 6, 1, 2, 14, 7,
1, 1, 15, 8, 1, 2, 15, 9, 1, 1, 16, 10, 1, 2, 16, 11, 1, 1, 17, 12, 1, 2, 17, 13, 1, 1, 18, 14, 1, 2, 18, 15, 1, 152,
19, 463, 834, 156, 20, 173, 1086, 152, 20, 464, 834, 156, 21, 173, 1087, 152, 21, 465, 834, 156, 22, 173, 1088, 152, 22,
836, 460, 156, 23, 173, 1089, 152, 23, 836, 461, 156, 24, 173, 1090, 152, 24, 836, 462, 65, 25, 456, 841, 157, 25, 1094,
173, 65, 26, 456, 842, 157, 26, 1095, 173, 65, 27, 456, 843, 157, 27, 1096, 173, 65, 28, 456, 844, 65, 29, 174, 1093,
157, 29, 1097, 173, 65, 30, 175, 1093, 157, 30, 1098, 173, 170, 31, 834, 459, 171, 31, 834, 373, 89, 32, 1091, 173, 169,
33, 1092, 131)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight  6: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=6
nb_c=5
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1064 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(79, 0, 0, 164, 0, 0, 83, 0, 0, 85, 0, 0, 79, 0, 2, 164, 0, 1, 78, 1, 1, 90, 1, 1, 78, 1, 0, 165, 2, 2, 172, 2, 2, 1, 2,
2, 2, 2, 2, 165, 2, 0, 172, 2, 3, 86, 3, 3, 156, 3, 3, 152, 3, 3, 86, 3, 2, 65, 4, 4, 157, 4, 4)), ncol=3, byrow=TRUE)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(83, 1, 834, 835, 85, 1, 449, 1092, 90, 2, 834, 834, 1, 3, 2, 1, 2, 3, 3, 1, 156, 4, 173, 1183, 152, 4, 836, 834, 65, 5,
456, 1093, 157, 5, 1184, 173)), ncol=2+2, byrow=TRUE)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

# weight count
nb_rw=6
# cumomer count by weight
nb_rcumos=c(231, 359, 293, 142, 39, 5)
nbc_rcumos=c(0, cumsum(nb_rcumos))
# cumo names
nm_rcumo=c("Fru6P:1", "Fru6P:2", "Fru6P:4", "Fru6P:8", "Fru6P:16", "Fru6P:32", "FruBP:1", "FruBP:2", "FruBP:4", "FruBP:8",
"FruBP:16", "FruBP:32", "Glc6P:1", "Glc6P:2", "Glc6P:4", "Glc6P:8", "Glc6P:16", "Glc6P:32", "Gnt6P:1", "Gnt6P:2",
"Gnt6P:4", "Gnt6P:8", "Gnt6P:16", "Gnt6P:32", "ICit:1", "ICit:2", "ICit:4", "ICit:8", "ICit:16", "ICit:32", "PEP:1",
"PEP:2", "PEP:4", "PGA:1", "PGA:2", "PGA:4", "Rib5P:1", "Rib5P:2", "Rib5P:4", "Rib5P:8", "Rib5P:16", "Suc:1", "Suc:2",
"Suc:4", "Suc:8", "CO2:1", "AcCoA:2", "AcCoA:1", "Sed7P:16", "Sed7P:32", "Sed7P:64", "GA3P:1", "GA3P:2", "GA3P:4",
"Pyr:1", "Pyr:2", "Pyr:4", "BM_OAA:1", "BM_PEP:1", "Ery4P:1", "Ery4P:2", "Ery4P:4", "Ery4P:8", "OAA:8", "OAA:4",
"OAA:2", "OAA:1", "FTHF:1", "PyrCO2:1", "AKG:1", "AKG:2", "AKG:4", "AKG:8", "AKG:16", "BM_Pyr:2", "BM_Pyr:1", "AKV:4",
"Ile:8", "Lys:1", "AKV:2", "Ile:1", "Lys:2", "Lys:4", "Leu:8", "Leu:1", "Gly:1", "Gly:2", "BM_Pyr:4", "BM_PEP:2",
"BM_Ery4P:1", "Phe:16", "Phe:1", "Tyr:16", "Tyr:1", "Trp:8", "Phe:32", "Tyr:32", "Trp:16", "BM_Ery4P:8", "BM_Ery4P:4",
"BM_Ery4P:2", "BM_PEP:4", "BM_PGA:1", "BM_PGA:2", "BM_PGA:4", "Sed7P:1", "BM_Rib5P:1", "Sed7P:2", "BM_Rib5P:2",
"Sed7P:4", "BM_Rib5P:4", "Sed7P:8", "BM_Rib5P:8", "BM_Rib5P:16", "Mal:1", "Mal:8", "Mal:2", "Mal:4", "AKV:16",
"Chor:64", "BM_OAA:8", "Arg:1", "BM_AcCoA:2", "BM_AcCoA:1", "PyrCO2:2", "PyrCO2:4", "PyrCO2:8", "Asp:1", "Thr:1",
"Met:2", "Asn:1", "DAHP:16", "Chor:128", "BM_OAA:4", "BM_OAA:2", "Ser:1", "His:1", "Met:1", "BM_AKG:1", "BM_AKG:2",
"BM_AKG:4", "BM_AKG:8", "BM_AKG:16", "Ala:2", "AKV:8", "Lys:16", "Ala:1", "AKV:1", "Lys:8", "Val:4", "Leu:4", "Val:2",
"Leu:2", "Ser:2", "Ser:4", "Ala:4", "Lys:32", "DAHP:32", "Chor:256", "DAHP:1", "Chor:16", "Chor:1", "Chor:32", "DAHP:8",
"DAHP:4", "DAHP:2", "DAHP:64", "Chor:512", "His:32", "Trp:1024", "His:16", "Trp:512", "His:8", "Trp:256", "His:4",
"Trp:128", "His:2", "Trp:64", "Val:16", "Asp:8", "Thr:8", "Met:16", "Asn:8", "Leu:32", "Leu:16", "Ile:2", "Phe:64",
"Tyr:64", "Asp:4", "Thr:4", "Met:8", "Asn:4", "Asp:2", "Thr:2", "Met:4", "Asn:2", "Cys:1", "Glu:1", "Glu:2", "Glu:4",
"Glu:8", "Glu:16", "Val:8", "Val:1", "Cys:2", "Cys:4", "Phe:128", "Tyr:128", "Trp:32", "Chor:8", "Chor:4", "Chor:2",
"Phe:256", "Tyr:256", "Ile:32", "Ile:16", "Ile:4", "Arg:2", "Arg:4", "Arg:8", "Arg:16", "Arg:32", "Phe:8", "Phe:2",
"Tyr:8", "Tyr:2", "Trp:4", "Phe:4", "Tyr:4", "Trp:2", "Trp:1", "Fru6P:3", "Fru6P:5", "Fru6P:6", "Fru6P:9", "Fru6P:10",
"Fru6P:12", "Fru6P:17", "Fru6P:18", "Fru6P:20", "Fru6P:24", "Fru6P:33", "Fru6P:34", "Fru6P:36", "Fru6P:40", "Fru6P:48",
"FruBP:3", "FruBP:5", "FruBP:6", "FruBP:9", "FruBP:10", "FruBP:12", "FruBP:17", "FruBP:18", "FruBP:20", "FruBP:24",
"FruBP:33", "FruBP:34", "FruBP:36", "FruBP:40", "FruBP:48", "Glc6P:3", "Glc6P:5", "Glc6P:6", "Glc6P:9", "Glc6P:10",
"Glc6P:12", "Glc6P:17", "Glc6P:18", "Glc6P:20", "Glc6P:24", "Glc6P:33", "Glc6P:34", "Glc6P:36", "Glc6P:40", "Glc6P:48",
"Gnt6P:3", "Gnt6P:5", "Gnt6P:6", "Gnt6P:9", "Gnt6P:10", "Gnt6P:12", "Gnt6P:17", "Gnt6P:18", "Gnt6P:20", "Gnt6P:24",
"Gnt6P:33", "Gnt6P:34", "Gnt6P:36", "Gnt6P:40", "Gnt6P:48", "ICit:3", "ICit:5", "ICit:6", "ICit:9", "ICit:10",
"ICit:12", "ICit:17", "ICit:18", "ICit:20", "ICit:24", "ICit:33", "ICit:34", "ICit:36", "ICit:40", "ICit:48", "PEP:3",
"PEP:5", "PEP:6", "PGA:3", "PGA:5", "PGA:6", "Rib5P:3", "Rib5P:5", "Rib5P:6", "Rib5P:9", "Rib5P:10", "Rib5P:12",
"Rib5P:17", "Rib5P:18", "Rib5P:20", "Rib5P:24", "Suc:3", "Suc:5", "Suc:9", "Suc:6", "Suc:10", "Suc:12", "AcCoA:3",
"Sed7P:48", "Sed7P:80", "Sed7P:96", "GA3P:3", "GA3P:5", "GA3P:6", "Pyr:3", "Pyr:5", "Pyr:6", "Ery4P:3", "Ery4P:5",
"Ery4P:6", "Ery4P:9", "Ery4P:10", "Ery4P:12", "OAA:12", "OAA:10", "OAA:6", "OAA:9", "OAA:5", "OAA:3", "AKG:3", "AKG:5",
"AKG:6", "AKG:9", "AKG:10", "AKG:12", "AKG:17", "AKG:18", "AKG:20", "AKG:24", "BM_Pyr:3", "AKV:6", "Ile:9", "Lys:3",
"Lys:5", "Lys:6", "Leu:9", "Gly:3", "BM_Pyr:6", "BM_Pyr:5", "Phe:48", "Phe:33", "Tyr:48", "Tyr:33", "Trp:24",
"BM_Ery4P:12", "BM_Ery4P:10", "BM_Ery4P:6", "BM_PEP:3", "BM_PEP:5", "BM_PEP:6", "BM_PGA:3", "BM_PGA:5", "BM_PGA:6",
"Sed7P:3", "BM_Rib5P:3", "Sed7P:5", "BM_Rib5P:5", "Sed7P:6", "BM_Rib5P:6", "Sed7P:9", "BM_Rib5P:9", "Sed7P:10",
"BM_Rib5P:10", "Sed7P:12", "BM_Rib5P:12", "Sed7P:17", "BM_Rib5P:17", "Sed7P:18", "BM_Rib5P:18", "Sed7P:20",
"BM_Rib5P:20", "Sed7P:24", "BM_Rib5P:24", "Mal:3", "Mal:12", "Mal:5", "Mal:10", "Mal:9", "Mal:6", "BM_AcCoA:3",
"PyrCO2:6", "PyrCO2:10", "PyrCO2:12", "BM_Ery4P:3", "BM_Ery4P:5", "BM_Ery4P:9", "BM_OAA:12", "BM_OAA:10", "BM_OAA:6",
"BM_OAA:9", "BM_OAA:5", "BM_OAA:3", "BM_AKG:3", "BM_AKG:5", "BM_AKG:6", "BM_AKG:9", "BM_AKG:10", "BM_AKG:12",
"BM_AKG:17", "BM_AKG:18", "BM_AKG:20", "BM_AKG:24", "Ala:3", "AKV:9", "Lys:24", "Val:6", "Leu:6", "Ser:6", "Ala:6",
"AKV:24", "Lys:48", "Ala:5", "AKV:17", "Lys:40", "Chor:48", "Chor:33", "DAHP:12", "DAHP:10", "DAHP:6", "DAHP:48",
"Chor:384", "DAHP:80", "Chor:640", "DAHP:96", "Chor:768", "Ser:3", "Ser:5", "His:48", "Trp:1536", "His:40", "Trp:1280",
"His:24", "Trp:768", "His:36", "Trp:1152", "His:20", "Trp:640", "His:12", "Trp:384", "His:34", "Trp:1088", "His:18",
"Trp:576", "His:10", "Trp:320", "His:6", "Trp:192", "Leu:48", "DAHP:3", "DAHP:5", "DAHP:9", "Asp:12", "Thr:12",
"Met:24", "Asn:12", "Asp:10", "Thr:10", "Met:20", "Asn:10", "Asp:6", "Thr:6", "Met:12", "Asn:6", "Asp:9", "Lys:36",
"Thr:9", "Met:18", "Asn:9", "Asp:5", "Lys:20", "Thr:5", "Met:10", "Asn:5", "Asp:3", "Lys:12", "Thr:3", "Met:6", "Asn:3",
"Glu:3", "Glu:5", "Glu:6", "Glu:9", "Glu:10", "Glu:12", "Glu:17", "Glu:18", "Glu:20", "Glu:24", "Val:9", "Cys:6",
"Val:24", "Val:17", "DAHP:33", "Trp:48", "Chor:12", "Chor:10", "Chor:6", "Phe:192", "Tyr:192", "Chor:80", "Phe:320",
"Tyr:320", "Chor:96", "Phe:384", "Tyr:384", "Cys:3", "Cys:5", "Chor:3", "Chor:5", "Chor:9", "Ile:48", "Ile:36",
"Ile:20", "Ile:34", "Ile:18", "Ile:6", "Arg:6", "Arg:10", "Arg:12", "Arg:18", "Arg:20", "Arg:24", "Arg:34", "Arg:36",
"Arg:40", "Arg:48", "Phe:12", "Phe:6", "Tyr:12", "Tyr:6", "Trp:6", "Phe:10", "Tyr:10", "Trp:5", "Trp:3", "Phe:3",
"Phe:24", "Tyr:3", "Tyr:24", "Trp:33", "Phe:5", "Phe:20", "Tyr:5", "Tyr:20", "Trp:34", "Phe:9", "Phe:18", "Tyr:9",
"Tyr:18", "Trp:36", "Chor:24", "Chor:20", "Chor:18", "DAHP:24", "Trp:12", "DAHP:20", "Trp:10", "DAHP:18", "Trp:9",
"Fru6P:7", "Fru6P:11", "Fru6P:13", "Fru6P:14", "Fru6P:19", "Fru6P:21", "Fru6P:22", "Fru6P:25", "Fru6P:26", "Fru6P:28",
"Fru6P:35", "Fru6P:37", "Fru6P:38", "Fru6P:41", "Fru6P:42", "Fru6P:44", "Fru6P:49", "Fru6P:50", "Fru6P:52", "Fru6P:56",
"FruBP:7", "FruBP:11", "FruBP:13", "FruBP:14", "FruBP:19", "FruBP:21", "FruBP:22", "FruBP:25", "FruBP:26", "FruBP:28",
"FruBP:35", "FruBP:37", "FruBP:38", "FruBP:41", "FruBP:42", "FruBP:44", "FruBP:49", "FruBP:50", "FruBP:52", "FruBP:56",
"Glc6P:7", "Glc6P:11", "Glc6P:13", "Glc6P:14", "Glc6P:19", "Glc6P:21", "Glc6P:22", "Glc6P:25", "Glc6P:26", "Glc6P:28",
"Glc6P:35", "Glc6P:37", "Glc6P:38", "Glc6P:41", "Glc6P:42", "Glc6P:44", "Glc6P:49", "Glc6P:50", "Glc6P:52", "Glc6P:56",
"Gnt6P:7", "Gnt6P:11", "Gnt6P:13", "Gnt6P:14", "Gnt6P:19", "Gnt6P:21", "Gnt6P:22", "Gnt6P:25", "Gnt6P:26", "Gnt6P:28",
"Gnt6P:35", "Gnt6P:37", "Gnt6P:38", "Gnt6P:41", "Gnt6P:42", "Gnt6P:44", "Gnt6P:49", "Gnt6P:50", "Gnt6P:52", "Gnt6P:56",
"ICit:7", "ICit:11", "ICit:13", "ICit:14", "ICit:19", "ICit:21", "ICit:22", "ICit:25", "ICit:26", "ICit:28", "ICit:35",
"ICit:37", "ICit:38", "ICit:41", "ICit:42", "ICit:44", "ICit:49", "ICit:50", "ICit:52", "ICit:56", "PEP:7", "PGA:7",
"Rib5P:7", "Rib5P:11", "Rib5P:13", "Rib5P:14", "Rib5P:19", "Rib5P:21", "Rib5P:22", "Rib5P:25", "Rib5P:26", "Rib5P:28",
"Suc:7", "Suc:11", "Suc:13", "Suc:14", "GA3P:7", "Sed7P:112", "Pyr:7", "Ery4P:7", "Ery4P:11", "Ery4P:13", "Ery4P:14",
"OAA:14", "OAA:13", "OAA:11", "OAA:7", "AKG:7", "AKG:11", "AKG:13", "AKG:14", "AKG:19", "AKG:21", "AKG:22", "AKG:25",
"AKG:26", "AKG:28", "Lys:7", "BM_Pyr:7", "BM_Ery4P:14", "BM_PEP:7", "BM_PGA:7", "Sed7P:7", "BM_Rib5P:7", "Sed7P:11",
"BM_Rib5P:11", "Sed7P:13", "BM_Rib5P:13", "Sed7P:14", "BM_Rib5P:14", "Sed7P:19", "BM_Rib5P:19", "Sed7P:21",
"BM_Rib5P:21", "Sed7P:22", "BM_Rib5P:22", "Sed7P:25", "BM_Rib5P:25", "Sed7P:26", "BM_Rib5P:26", "Sed7P:28",
"BM_Rib5P:28", "Mal:7", "Mal:14", "Mal:11", "Mal:13", "PyrCO2:14", "BM_Ery4P:7", "BM_Ery4P:11", "BM_Ery4P:13",
"BM_OAA:14", "BM_OAA:13", "BM_OAA:11", "BM_OAA:7", "BM_AKG:7", "BM_AKG:11", "BM_AKG:13", "BM_AKG:14", "BM_AKG:19",
"BM_AKG:21", "BM_AKG:22", "BM_AKG:25", "BM_AKG:26", "BM_AKG:28", "Ala:7", "AKV:25", "Lys:56", "DAHP:14", "DAHP:112",
"Chor:896", "Ser:7", "His:56", "Trp:1792", "His:52", "Trp:1664", "His:44", "Trp:1408", "His:28", "Trp:896", "His:50",
"Trp:1600", "His:42", "Trp:1344", "His:26", "Trp:832", "His:38", "Trp:1216", "His:22", "Trp:704", "His:14", "Trp:448",
"DAHP:7", "DAHP:11", "DAHP:13", "Asp:14", "Thr:14", "Met:28", "Asn:14", "Asp:13", "Lys:52", "Thr:13", "Met:26",
"Asn:13", "Asp:11", "Lys:44", "Thr:11", "Met:22", "Asn:11", "Asp:7", "Lys:28", "Thr:7", "Met:14", "Asn:7", "Glu:7",
"Glu:11", "Glu:13", "Glu:14", "Glu:19", "Glu:21", "Glu:22", "Glu:25", "Glu:26", "Glu:28", "Val:25", "Chor:14",
"Chor:112", "Phe:448", "Tyr:448", "Cys:7", "Chor:7", "Chor:11", "Chor:13", "Ile:52", "Ile:50", "Ile:38", "Ile:22",
"Arg:14", "Arg:22", "Arg:26", "Arg:28", "Arg:38", "Arg:42", "Arg:44", "Arg:50", "Arg:52", "Arg:56", "Phe:14", "Tyr:14",
"Trp:7", "Phe:7", "Phe:28", "Tyr:7", "Tyr:28", "Trp:35", "Phe:11", "Phe:26", "Tyr:11", "Tyr:26", "Trp:37", "Phe:13",
"Phe:22", "Tyr:13", "Tyr:22", "Trp:38", "Chor:28", "Chor:26", "Chor:22", "DAHP:28", "Trp:14", "DAHP:26", "Trp:13",
"DAHP:22", "Trp:11", "Fru6P:15", "Fru6P:23", "Fru6P:27", "Fru6P:29", "Fru6P:30", "Fru6P:39", "Fru6P:43", "Fru6P:45",
"Fru6P:46", "Fru6P:51", "Fru6P:53", "Fru6P:54", "Fru6P:57", "Fru6P:58", "Fru6P:60", "FruBP:15", "FruBP:23", "FruBP:27",
"FruBP:29", "FruBP:30", "FruBP:39", "FruBP:43", "FruBP:45", "FruBP:46", "FruBP:51", "FruBP:53", "FruBP:54", "FruBP:57",
"FruBP:58", "FruBP:60", "Glc6P:15", "Glc6P:23", "Glc6P:27", "Glc6P:29", "Glc6P:30", "Glc6P:39", "Glc6P:43", "Glc6P:45",
"Glc6P:46", "Glc6P:51", "Glc6P:53", "Glc6P:54", "Glc6P:57", "Glc6P:58", "Glc6P:60", "Gnt6P:15", "Gnt6P:23", "Gnt6P:27",
"Gnt6P:29", "Gnt6P:30", "Gnt6P:39", "Gnt6P:43", "Gnt6P:45", "Gnt6P:46", "Gnt6P:51", "Gnt6P:53", "Gnt6P:54", "Gnt6P:57",
"Gnt6P:58", "Gnt6P:60", "ICit:15", "ICit:23", "ICit:27", "ICit:29", "ICit:30", "ICit:39", "ICit:43", "ICit:45",
"ICit:46", "ICit:51", "ICit:53", "ICit:54", "ICit:57", "ICit:58", "ICit:60", "Rib5P:15", "Rib5P:23", "Rib5P:27",
"Rib5P:29", "Rib5P:30", "Suc:15", "Ery4P:15", "OAA:15", "AKG:15", "AKG:23", "AKG:27", "AKG:29", "AKG:30", "Sed7P:15",
"BM_Rib5P:15", "Sed7P:23", "BM_Rib5P:23", "Sed7P:27", "BM_Rib5P:27", "Sed7P:29", "BM_Rib5P:29", "Sed7P:30",
"BM_Rib5P:30", "Mal:15", "BM_Ery4P:15", "BM_OAA:15", "BM_AKG:15", "BM_AKG:23", "BM_AKG:27", "BM_AKG:29", "BM_AKG:30",
"His:60", "Trp:1920", "His:58", "Trp:1856", "His:54", "Trp:1728", "His:46", "Trp:1472", "His:30", "Trp:960", "DAHP:15",
"Asp:15", "Lys:60", "Thr:15", "Met:30", "Asn:15", "Glu:15", "Glu:23", "Glu:27", "Glu:29", "Glu:30", "Chor:15", "Ile:54",
"Arg:30", "Arg:46", "Arg:54", "Arg:58", "Arg:60", "Phe:15", "Phe:30", "Tyr:15", "Tyr:30", "Trp:39", "Chor:30",
"DAHP:30", "Trp:15", "Fru6P:31", "Fru6P:47", "Fru6P:55", "Fru6P:59", "Fru6P:61", "Fru6P:62", "FruBP:31", "FruBP:47",
"FruBP:55", "FruBP:59", "FruBP:61", "FruBP:62", "Glc6P:31", "Glc6P:47", "Glc6P:55", "Glc6P:59", "Glc6P:61", "Glc6P:62",
"Gnt6P:31", "Gnt6P:47", "Gnt6P:55", "Gnt6P:59", "Gnt6P:61", "Gnt6P:62", "ICit:31", "ICit:47", "ICit:55", "ICit:59",
"ICit:61", "ICit:62", "Rib5P:31", "AKG:31", "Sed7P:31", "BM_Rib5P:31", "BM_AKG:31", "His:62", "Trp:1984", "Glu:31",
"Arg:62", "Fru6P:63", "FruBP:63", "Glc6P:63", "Gnt6P:63", "ICit:63")
nm_list$rcumo=nm_rcumo
    
if (case_i) {
   # check the coherence of metabolites/cumomers
   met_net=unique(matrix(unlist(strsplit(nm_rcumo, ":", fixed=TRUE)), nrow=2)[1,])
   net_pool=sort(setdiff(met_net, names(nm_poolall)))
   if (length(net_pool) > 0) {
      stop_mes("The following metabolites are internal in NETWORK section but not in METABOLITE_POOLS one:\n", paste(net_pool, collapse="\n"), file=fcerr)
   }
}

nb_exp=1
nm_exp=c("e_coli")
nm_list$nm_exp=nm_exp
# input cumomer vectors, list of vectors for case_s and matrices (nb_inp x nb_time) for case_i
xi=list(c(0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
0, 1, 0, 1, 1.0, 1))
if (any(lengths(xi) == 0))
   stop_mes("No reduced label entry is defined (may be because no measurement provided). Cannot continue.", file=fcerr)
nm_xi=c("Gluc_1:63", "Gluc_U:63", "Gluc_1:31", "Gluc_U:31", "Gluc_1:47", "Gluc_U:47", "Gluc_1:55", "Gluc_U:55", "Gluc_1:59",
"Gluc_U:59", "Gluc_1:61", "Gluc_U:61", "Gluc_1:62", "Gluc_U:62", "Gluc_1:15", "Gluc_U:15", "Gluc_1:23", "Gluc_U:23",
"Gluc_1:27", "Gluc_U:27", "Gluc_1:29", "Gluc_U:29", "Gluc_1:30", "Gluc_U:30", "Gluc_1:39", "Gluc_U:39", "Gluc_1:43",
"Gluc_U:43", "Gluc_1:45", "Gluc_U:45", "Gluc_1:46", "Gluc_U:46", "Gluc_1:51", "Gluc_U:51", "Gluc_1:53", "Gluc_U:53",
"Gluc_1:54", "Gluc_U:54", "Gluc_1:57", "Gluc_U:57", "Gluc_1:58", "Gluc_U:58", "Gluc_1:60", "Gluc_U:60", "Gluc_1:7",
"Gluc_U:7", "Gluc_1:11", "Gluc_U:11", "Gluc_1:13", "Gluc_U:13", "Gluc_1:14", "Gluc_U:14", "Gluc_1:19", "Gluc_U:19",
"Gluc_1:21", "Gluc_U:21", "Gluc_1:22", "Gluc_U:22", "Gluc_1:25", "Gluc_U:25", "Gluc_1:26", "Gluc_U:26", "Gluc_1:28",
"Gluc_U:28", "Gluc_1:35", "Gluc_U:35", "Gluc_1:37", "Gluc_U:37", "Gluc_1:38", "Gluc_U:38", "Gluc_1:41", "Gluc_U:41",
"Gluc_1:42", "Gluc_U:42", "Gluc_1:44", "Gluc_U:44", "Gluc_1:49", "Gluc_U:49", "Gluc_1:50", "Gluc_U:50", "Gluc_1:52",
"Gluc_U:52", "Gluc_1:56", "Gluc_U:56", "Gluc_1:3", "Gluc_U:3", "Gluc_1:5", "Gluc_U:5", "Gluc_1:6", "Gluc_U:6",
"Gluc_1:9", "Gluc_U:9", "Gluc_1:10", "Gluc_U:10", "Gluc_1:12", "Gluc_U:12", "Gluc_1:17", "Gluc_U:17", "Gluc_1:18",
"Gluc_U:18", "Gluc_1:20", "Gluc_U:20", "Gluc_1:24", "Gluc_U:24", "Gluc_1:33", "Gluc_U:33", "Gluc_1:34", "Gluc_U:34",
"Gluc_1:36", "Gluc_U:36", "Gluc_1:40", "Gluc_U:40", "Gluc_1:48", "Gluc_U:48", "Gluc_1:1", "Gluc_U:1", "Gluc_1:2",
"Gluc_U:2", "Gluc_1:4", "Gluc_U:4", "Gluc_1:8", "Gluc_U:8", "Gluc_1:16", "Gluc_U:16", "Gluc_1:32", "Gluc_U:32") # same for all parallel exps
for (i in seq_along(xi)) {
   names(xi[[i]])=nm_xi
}
nm_list$xi=nm_xi
nb_xi=length(nm_xi)
nb_f$xi=nb_xi
nb_cumoi=nb_xi
nm_inp=nm_xi
nm_incu=c("one", nm_xi, nm_rcumo)
nm_inlab=nm_incu
spa=spAbr
nm_x=nm_rcumo
nb_x=nb_rcumos
nb_f$rcumos=nb_rcumos
nb_f$cumoi=nb_cumoi
if (emu) {
   nm_emu=c()
   nb_emus=nb_rcumos*(seq_len(nb_rw)+1)
   nb_f$emus=nb_emus
   nm_list$emu=nm_emu
   nm_x=nm_emu
   nb_x=nb_emus
   xiemu=list()
   nm_xiemu=c()
   nm_list$xiemu=nm_xiemu
   for (i in seq_along(xiemu))
        names(xiemu[[i]])=nm_xiemu
   nb_xiemu=length(nm_xiemu)
   nb_f$xiemu=nb_xiemu
   nb_f$xi=nb_xiemu
   nb_xi=nb_xiemu
   nm_inp=nm_xiemu
   xi=xiemu
   nm_inemu=c("one", nm_xiemu, nm_emu)
   nm_inlab=nm_inemu
   spa=spr2emu(spAbr, nm_incu, nm_inemu, nb_f)
}
# reorder indexes to accelerate sparse matrix construction
spa=sparse2spa(spa)
#browser()
# composite labeling vector incu c(1, xi, xc) names
nm_inlab=c("one", nm_inp, nm_x); # the constant 1 has name "one"
nm_list$x=nm_x
nm_list$inp=nm_inp
nb_f$x=nb_x
    
nm_cumo=NULL
spaf=NULL

if (TIMEIT) {
   cat("measure : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
if (!noscale) {
   # make place for scaling factors
   nb_sc=vector("integer", 1)
    # experiment: 1

   # mass
   # initial values for scales are set later
   param=c(param,1, 1, 1, 1, 1, 1, 1, 1, 1)
   nm_par=c(nm_par,c("1:mass;Fru6P;111111;405", "1:mass;FruBP;111111;412", "1:mass;Glc6P;111111;419", "1:mass;Gnt6P;111111;426",
"1:mass;ICit;111111;433", "1:mass;PEP;111;440", "1:mass;PGA;111;444", "1:mass;Rib5P;11111;448", "1:mass;Suc;1111;454"))
   names(param)=nm_par
            
   nb_param=length(param)
   nb_sc[1]=nb_param-nb_ff # at this moment it is cumulated sum. diff() is taken later

   # indices mapping from scaling to measure matrix row
   # c(1,par)[ir2isc[[iexp]]] replicates scale parameters
   # for corresponding rows of measure matrix
   ir2isc=vector("list", 1)

   # 1:mass
   ir2isc[[1]]=c(ir2isc[[1]],c(2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 8,
8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10))

   if (!is.null(ir2isc[[1]])) {
      isc=ir2isc[[1]] != 1
      ir2isc[[1]][isc]=ir2isc[[1]][isc]+nb_ff
   }

   # cumulated base for nb_sc
   nb_sc_base=c(0, nb_sc[-nb_exp])
   nb_sc=diff(c(0, nb_sc))
   nb_sc_tot=sum(nb_sc)
   nb_f$nb_sc=nb_sc
   nb_f$nb_sc_tot=nb_sc_tot
   nb_f$nb_sc_base=nb_sc_base
#browser()
} else {
   # no scaling
   ir2isc=list()
   nb_sc=integer(nb_exp)
   nb_sc_tot=0
}
nb_f$nb_sc=nb_sc
nb_f$nb_sc_tot=nb_sc_tot
nm_list$par=nm_par

# make a list of sparse measurement matrices
# measmat*xr+memaone gives a vector of simulated not-yet-pooled and not-yet-scaled measurements
# all but 0. Coefficients of 0-cumomers (by defenition equal to 1)
# are all regrouped in the memaone.
nm_measmat=nm_meas=nb_meas=nb_measmat=measmat=memaone=measvec=measdev=ipooled=vector("list", 1)

nm_measmat[[1]]=c("m:Fru6P::0:405", "m:Fru6P::1:406", "m:Fru6P::2:407", "m:Fru6P::3:408", "m:Fru6P::4:409", "m:Fru6P::5:410",
"m:Fru6P::6:411", "m:FruBP::0:412", "m:FruBP::1:413", "m:FruBP::2:414", "m:FruBP::3:415", "m:FruBP::4:416",
"m:FruBP::5:417", "m:FruBP::6:418", "m:Glc6P::0:419", "m:Glc6P::1:420", "m:Glc6P::2:421", "m:Glc6P::3:422",
"m:Glc6P::4:423", "m:Glc6P::5:424", "m:Glc6P::6:425", "m:Gnt6P::0:426", "m:Gnt6P::1:427", "m:Gnt6P::2:428",
"m:Gnt6P::3:429", "m:Gnt6P::4:430", "m:Gnt6P::5:431", "m:Gnt6P::6:432", "m:ICit::0:433", "m:ICit::1:434",
"m:ICit::2:435", "m:ICit::3:436", "m:ICit::4:437", "m:ICit::5:438", "m:ICit::6:439", "m:PEP::0:440", "m:PEP::1:441",
"m:PEP::2:442", "m:PEP::3:443", "m:PGA::0:444", "m:PGA::1:445", "m:PGA::2:446", "m:PGA::3:447", "m:Rib5P::0:448",
"m:Rib5P::1:449", "m:Rib5P::2:450", "m:Rib5P::3:451", "m:Rib5P::4:452", "m:Rib5P::5:453", "m:Suc::1:454",
"m:Suc::2:455", "m:Suc::3:456", "m:Suc::4:457")
if (length(nm_measmat[[1]]) == 0)
   stop_mes("At least one labeling measurement must be given in experiment '", nm_exp[1], "'", file=fcerr)
nm_meas[[1]]=c("m:Fru6P::0:405", "m:Fru6P::1:406", "m:Fru6P::2:407", "m:Fru6P::3:408", "m:Fru6P::4:409", "m:Fru6P::5:410",
"m:Fru6P::6:411", "m:FruBP::0:412", "m:FruBP::1:413", "m:FruBP::2:414", "m:FruBP::3:415", "m:FruBP::4:416",
"m:FruBP::5:417", "m:FruBP::6:418", "m:Glc6P::0:419", "m:Glc6P::1:420", "m:Glc6P::2:421", "m:Glc6P::3:422",
"m:Glc6P::4:423", "m:Glc6P::5:424", "m:Glc6P::6:425", "m:Gnt6P::0:426", "m:Gnt6P::1:427", "m:Gnt6P::2:428",
"m:Gnt6P::3:429", "m:Gnt6P::4:430", "m:Gnt6P::5:431", "m:Gnt6P::6:432", "m:ICit::0:433", "m:ICit::1:434",
"m:ICit::2:435", "m:ICit::3:436", "m:ICit::4:437", "m:ICit::5:438", "m:ICit::6:439", "m:PEP::0:440", "m:PEP::1:441",
"m:PEP::2:442", "m:PEP::3:443", "m:PGA::0:444", "m:PGA::1:445", "m:PGA::2:446", "m:PGA::3:447", "m:Rib5P::0:448",
"m:Rib5P::1:449", "m:Rib5P::2:450", "m:Rib5P::3:451", "m:Rib5P::4:452", "m:Rib5P::5:453", "m:Suc::1:454",
"m:Suc::2:455", "m:Suc::3:456", "m:Suc::4:457")
nb_meas[[1]]=length(nm_meas[[1]])
nb_measmat[[1]]=length(nm_measmat[[1]])
measmat[[1]]=simple_triplet_zero_matrix(nrow=nb_measmat[[1]], ncol=1069)
dimnames(measmat[[1]])=list(nm_measmat[[1]], nm_x)
memaone[[1]]=numeric(nb_measmat[[1]])
measvec[[1]]=c(0.0235029951295, 0.624253565357667, 0.113068441282333, 0.0456605631765, 0.0516089447155667, 0.0185881765378333,
0.123317313800333, 0.0738121029259333, 0.454450017158667, 0.160823529969333, 0.0944468077710667, 0.105281338489667,
0.0155016033633, 0.0956846003217333, 0.0160587173349, 0.673510772480667, 0.0930110047641, 0.0280359937297,
0.0397315614067667, 0.0145524520950667, 0.135099498189, 0.0249552273874, 0.672556163913, 0.0866890773125333,
0.0313987199704333, 0.0314691889898667, 0.0138168327362333, 0.139114789690333, 0.131864539419667, 0.225857638569,
0.256421170949333, 0.209230210478667, 0.116863585449667, 0.0457727744643333, 0.0139900806697867, 0.421359839367667,
0.358998301162333, 0.0348521859365667, 0.184789673534, 0.434335785072667, 0.352829683224667, 0.0323479804176,
0.180486551285333, 0.341615670498667, 0.25454117519, 0.159027180368333, 0.113789577528667, 0.0615266612553333,
0.0694997351590667, 0.371605319, 0.360829749, 0.208425325, 0.059139607)
measdev[[1]]=c(0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01,
0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01,
0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(measvec[[1]])=nm_meas[[1]]
names(measdev[[1]])=nm_meas[[1]]
ipooled[[1]]=list(ishort=pmatch(nm_meas[[1]], nm_measmat[[1]]))

nm_meas_tot=unlist(nm_meas)
nb_meas=unlist(nb_meas)
nb_meas_cumo=c(0., cumsum(nb_meas[-nb_exp]))
iexp_meas=lapply(seq_len(nb_exp), function(iexp) seq_len(nb_meas[iexp])+nb_meas_cumo[iexp])
nm_list$meas=nm_meas
nm_list$measmat=nm_measmat
nm_list$meas_tot=nm_meas_tot
nb_f$nb_meas=nb_meas

names(measvec)=names(measdev)=nm_exp

if (!noscale) {
   for (iexp in seq_len(nb_exp))
      if (length(ipooled[[iexp]]$ishort))
         ir2isc[[iexp]]=ir2isc[[iexp]][ipooled[[iexp]]$ishort]

   # prepare indexes of dispatching scale params in jacobian
   if (nb_sc_tot > 0) {
      nb_f$is2m=vector("list", nb_exp)
      for (iexp in seq_len(nb_exp)) {
         ipaire=matrix(0, nrow=0, ncol=2)
         tmp=lapply(seq_len(nb_sc[[iexp]]), function(isc) {
            i=which(ir2isc[[iexp]]==isc+nb_sc_base[iexp]+1+nb_ff)
            ipaire <<- rbind(ipaire, cbind(i, isc+nb_sc_base[iexp]))
            return(NULL)
         })
         nb_f$is2m[[iexp]]=ipaire
         # place holder for scale part of jacobian
         jx_f$dr_dsc[[iexp]]=simple_triplet_zero_matrix(nrow=length(ir2isc[[iexp]]), ncol=nb_sc_tot)
      }
   }
}
# prepare measmat indexes and values : ir, ic, val

ind_mema=matrix(c(
1, 232, 1, 1, 233, 1, 1, 234, 1, 1, 235, 1, 1, 236, 1, 1, 237, 1, 1, 884, 1, 1, 238, 1, 1, 239, 1, 1, 240, 1, 1, 885, 1,
1, 241, 1, 1, 886, 1, 1, 887, 1, 1, 888, 1, 1, 242, 1, 1, 243, 1, 1, 244, 1, 1, 889, 1, 1, 245, 1, 1, 890, 1, 1, 891, 1,
1, 892, 1, 1, 246, 1, 1, 893, 1, 1, 894, 1, 1, 895, 1, 1, 896, 1, 1, 897, 1, 1, 898, 1, 1, 1065, 1, 1, 1, -1, 1, 2, -1,
1, 3, -1, 1, 591, -1, 1, 4, -1, 1, 592, -1, 1, 593, -1, 1, 594, -1, 1, 5, -1, 1, 595, -1, 1, 596, -1, 1, 597, -1, 1,
598, -1, 1, 599, -1, 1, 600, -1, 1, 1026, -1, 1, 6, -1, 1, 601, -1, 1, 602, -1, 1, 603, -1, 1, 604, -1, 1, 605, -1, 1,
606, -1, 1, 1027, -1, 1, 607, -1, 1, 608, -1, 1, 609, -1, 1, 1028, -1, 1, 610, -1, 1, 1029, -1, 1, 1030, -1, 1, 1031, -1,
                    2, 1, 1, 2, 591, 3, 2, 592, 3, 2, 593, 3, 2, 595, 3, 2, 596, 3, 2, 598, 3, 2, 1026, 5, 2, 601, 3, 2, 602, 3, 2, 604, 3,
2, 1027, 5, 2, 607, 3, 2, 1028, 5, 2, 1029, 5, 2, 1030, 5, 2, 232, -2, 2, 233, -2, 2, 235, -2, 2, 884, -4, 2, 238, -2,
2, 885, -4, 2, 886, -4, 2, 887, -4, 2, 242, -2, 2, 889, -4, 2, 890, -4, 2, 891, -4, 2, 893, -4, 2, 894, -4, 2, 896, -4,
2, 1065, -6, 2, 2, 1, 2, 594, 3, 2, 597, 3, 2, 599, 3, 2, 603, 3, 2, 605, 3, 2, 608, 3, 2, 1031, 5, 2, 234, -2, 2, 236,
-2, 2, 239, -2, 2, 888, -4, 2, 243, -2, 2, 892, -4, 2, 895, -4, 2, 897, -4, 2, 3, 1, 2, 600, 3, 2, 606, 3, 2, 609, 3, 2,
237, -2, 2, 240, -2, 2, 244, -2, 2, 898, -4, 2, 4, 1, 2, 610, 3, 2, 241, -2, 2, 245, -2, 2, 5, 1, 2, 246, -2, 2, 6, 1,
                    3, 232, 1, 3, 884, 6, 3, 885, 6, 3, 886, 6, 3, 889, 6, 3, 890, 6, 3, 893, 6, 3, 1065, 15, 3, 591, -3, 3, 592, -3, 3,
595, -3, 3, 1026, -10, 3, 601, -3, 3, 1027, -10, 3, 1028, -10, 3, 1029, -10, 3, 233, 1, 3, 887, 6, 3, 891, 6, 3, 894, 6,
3, 593, -3, 3, 596, -3, 3, 602, -3, 3, 1030, -10, 3, 234, 1, 3, 888, 6, 3, 892, 6, 3, 895, 6, 3, 594, -3, 3, 597, -3, 3,
603, -3, 3, 1031, -10, 3, 235, 1, 3, 896, 6, 3, 598, -3, 3, 604, -3, 3, 236, 1, 3, 897, 6, 3, 599, -3, 3, 605, -3, 3,
237, 1, 3, 898, 6, 3, 600, -3, 3, 606, -3, 3, 238, 1, 3, 607, -3, 3, 239, 1, 3, 608, -3, 3, 240, 1, 3, 609, -3, 3, 241,
1, 3, 610, -3, 3, 242, 1, 3, 243, 1, 3, 244, 1, 3, 245, 1, 3, 246, 1,
                    4, 591, 1, 4, 1026, 10, 4, 1027, 10, 4, 1028, 10, 4, 884, -4, 4, 885, -4, 4, 889, -4, 4, 1065, -20, 4, 592, 1, 4, 1029,
10, 4, 886, -4, 4, 890, -4, 4, 593, 1, 4, 1030, 10, 4, 887, -4, 4, 891, -4, 4, 594, 1, 4, 1031, 10, 4, 888, -4, 4, 892,
-4, 4, 595, 1, 4, 893, -4, 4, 596, 1, 4, 894, -4, 4, 597, 1, 4, 895, -4, 4, 598, 1, 4, 896, -4, 4, 599, 1, 4, 897, -4,
4, 600, 1, 4, 898, -4, 4, 601, 1, 4, 602, 1, 4, 603, 1, 4, 604, 1, 4, 605, 1, 4, 606, 1, 4, 607, 1, 4, 608, 1, 4, 609,
1, 4, 610, 1,
                    5, 884, 1, 5, 1065, 15, 5, 1026, -5, 5, 1027, -5, 5, 885, 1, 5, 1028, -5, 5, 886, 1, 5, 1029, -5, 5, 887, 1, 5, 1030,
-5, 5, 888, 1, 5, 1031, -5, 5, 889, 1, 5, 890, 1, 5, 891, 1, 5, 892, 1, 5, 893, 1, 5, 894, 1, 5, 895, 1, 5, 896, 1, 5,
897, 1, 5, 898, 1,
                    6, 1026, 1, 6, 1065, -6, 6, 1027, 1, 6, 1028, 1, 6, 1029, 1, 6, 1030, 1, 6, 1031, 1,
                    7, 1065, 1,
                    8, 247, 1, 8, 248, 1, 8, 249, 1, 8, 250, 1, 8, 251, 1, 8, 252, 1, 8, 899, 1, 8, 253, 1, 8, 254, 1, 8, 255, 1, 8, 900, 1,
8, 256, 1, 8, 901, 1, 8, 902, 1, 8, 903, 1, 8, 257, 1, 8, 258, 1, 8, 259, 1, 8, 904, 1, 8, 260, 1, 8, 905, 1, 8, 906, 1,
8, 907, 1, 8, 261, 1, 8, 908, 1, 8, 909, 1, 8, 910, 1, 8, 911, 1, 8, 912, 1, 8, 913, 1, 8, 1066, 1, 8, 7, -1, 8, 8, -1,
8, 9, -1, 8, 611, -1, 8, 10, -1, 8, 612, -1, 8, 613, -1, 8, 614, -1, 8, 11, -1, 8, 615, -1, 8, 616, -1, 8, 617, -1, 8,
618, -1, 8, 619, -1, 8, 620, -1, 8, 1032, -1, 8, 12, -1, 8, 621, -1, 8, 622, -1, 8, 623, -1, 8, 624, -1, 8, 625, -1, 8,
626, -1, 8, 1033, -1, 8, 627, -1, 8, 628, -1, 8, 629, -1, 8, 1034, -1, 8, 630, -1, 8, 1035, -1, 8, 1036, -1, 8, 1037, -1,
                    9, 7, 1, 9, 611, 3, 9, 612, 3, 9, 613, 3, 9, 615, 3, 9, 616, 3, 9, 618, 3, 9, 1032, 5, 9, 621, 3, 9, 622, 3, 9, 624, 3,
9, 1033, 5, 9, 627, 3, 9, 1034, 5, 9, 1035, 5, 9, 1036, 5, 9, 247, -2, 9, 248, -2, 9, 250, -2, 9, 899, -4, 9, 253, -2,
9, 900, -4, 9, 901, -4, 9, 902, -4, 9, 257, -2, 9, 904, -4, 9, 905, -4, 9, 906, -4, 9, 908, -4, 9, 909, -4, 9, 911, -4,
9, 1066, -6, 9, 8, 1, 9, 614, 3, 9, 617, 3, 9, 619, 3, 9, 623, 3, 9, 625, 3, 9, 628, 3, 9, 1037, 5, 9, 249, -2, 9, 251,
-2, 9, 254, -2, 9, 903, -4, 9, 258, -2, 9, 907, -4, 9, 910, -4, 9, 912, -4, 9, 9, 1, 9, 620, 3, 9, 626, 3, 9, 629, 3, 9,
252, -2, 9, 255, -2, 9, 259, -2, 9, 913, -4, 9, 10, 1, 9, 630, 3, 9, 256, -2, 9, 260, -2, 9, 11, 1, 9, 261, -2, 9, 12, 1,
                    10, 247, 1, 10, 899, 6, 10, 900, 6, 10, 901, 6, 10, 904, 6, 10, 905, 6, 10, 908, 6, 10, 1066, 15, 10, 611, -3, 10, 612,
-3, 10, 615, -3, 10, 1032, -10, 10, 621, -3, 10, 1033, -10, 10, 1034, -10, 10, 1035, -10, 10, 248, 1, 10, 902, 6, 10,
906, 6, 10, 909, 6, 10, 613, -3, 10, 616, -3, 10, 622, -3, 10, 1036, -10, 10, 249, 1, 10, 903, 6, 10, 907, 6, 10, 910,
6, 10, 614, -3, 10, 617, -3, 10, 623, -3, 10, 1037, -10, 10, 250, 1, 10, 911, 6, 10, 618, -3, 10, 624, -3, 10, 251, 1,
10, 912, 6, 10, 619, -3, 10, 625, -3, 10, 252, 1, 10, 913, 6, 10, 620, -3, 10, 626, -3, 10, 253, 1, 10, 627, -3, 10,
254, 1, 10, 628, -3, 10, 255, 1, 10, 629, -3, 10, 256, 1, 10, 630, -3, 10, 257, 1, 10, 258, 1, 10, 259, 1, 10, 260, 1,
10, 261, 1,
                    11, 611, 1, 11, 1032, 10, 11, 1033, 10, 11, 1034, 10, 11, 899, -4, 11, 900, -4, 11, 904, -4, 11, 1066, -20, 11, 612, 1,
11, 1035, 10, 11, 901, -4, 11, 905, -4, 11, 613, 1, 11, 1036, 10, 11, 902, -4, 11, 906, -4, 11, 614, 1, 11, 1037, 10,
11, 903, -4, 11, 907, -4, 11, 615, 1, 11, 908, -4, 11, 616, 1, 11, 909, -4, 11, 617, 1, 11, 910, -4, 11, 618, 1, 11,
911, -4, 11, 619, 1, 11, 912, -4, 11, 620, 1, 11, 913, -4, 11, 621, 1, 11, 622, 1, 11, 623, 1, 11, 624, 1, 11, 625, 1,
11, 626, 1, 11, 627, 1, 11, 628, 1, 11, 629, 1, 11, 630, 1,
                    12, 899, 1, 12, 1066, 15, 12, 1032, -5, 12, 1033, -5, 12, 900, 1, 12, 1034, -5, 12, 901, 1, 12, 1035, -5, 12, 902, 1,
12, 1036, -5, 12, 903, 1, 12, 1037, -5, 12, 904, 1, 12, 905, 1, 12, 906, 1, 12, 907, 1, 12, 908, 1, 12, 909, 1, 12, 910,
1, 12, 911, 1, 12, 912, 1, 12, 913, 1,
                    13, 1032, 1, 13, 1066, -6, 13, 1033, 1, 13, 1034, 1, 13, 1035, 1, 13, 1036, 1, 13, 1037, 1,
                    14, 1066, 1,
                    15, 262, 1, 15, 263, 1, 15, 264, 1, 15, 265, 1, 15, 266, 1, 15, 267, 1, 15, 914, 1, 15, 268, 1, 15, 269, 1, 15, 270, 1,
15, 915, 1, 15, 271, 1, 15, 916, 1, 15, 917, 1, 15, 918, 1, 15, 272, 1, 15, 273, 1, 15, 274, 1, 15, 919, 1, 15, 275, 1,
15, 920, 1, 15, 921, 1, 15, 922, 1, 15, 276, 1, 15, 923, 1, 15, 924, 1, 15, 925, 1, 15, 926, 1, 15, 927, 1, 15, 928, 1,
15, 1067, 1, 15, 13, -1, 15, 14, -1, 15, 15, -1, 15, 631, -1, 15, 16, -1, 15, 632, -1, 15, 633, -1, 15, 634, -1, 15, 17,
-1, 15, 635, -1, 15, 636, -1, 15, 637, -1, 15, 638, -1, 15, 639, -1, 15, 640, -1, 15, 1038, -1, 15, 18, -1, 15, 641, -1,
15, 642, -1, 15, 643, -1, 15, 644, -1, 15, 645, -1, 15, 646, -1, 15, 1039, -1, 15, 647, -1, 15, 648, -1, 15, 649, -1,
15, 1040, -1, 15, 650, -1, 15, 1041, -1, 15, 1042, -1, 15, 1043, -1,
                    16, 13, 1, 16, 631, 3, 16, 632, 3, 16, 633, 3, 16, 635, 3, 16, 636, 3, 16, 638, 3, 16, 1038, 5, 16, 641, 3, 16, 642, 3,
16, 644, 3, 16, 1039, 5, 16, 647, 3, 16, 1040, 5, 16, 1041, 5, 16, 1042, 5, 16, 262, -2, 16, 263, -2, 16, 265, -2, 16,
914, -4, 16, 268, -2, 16, 915, -4, 16, 916, -4, 16, 917, -4, 16, 272, -2, 16, 919, -4, 16, 920, -4, 16, 921, -4, 16,
923, -4, 16, 924, -4, 16, 926, -4, 16, 1067, -6, 16, 14, 1, 16, 634, 3, 16, 637, 3, 16, 639, 3, 16, 643, 3, 16, 645, 3,
16, 648, 3, 16, 1043, 5, 16, 264, -2, 16, 266, -2, 16, 269, -2, 16, 918, -4, 16, 273, -2, 16, 922, -4, 16, 925, -4, 16,
927, -4, 16, 15, 1, 16, 640, 3, 16, 646, 3, 16, 649, 3, 16, 267, -2, 16, 270, -2, 16, 274, -2, 16, 928, -4, 16, 16, 1,
16, 650, 3, 16, 271, -2, 16, 275, -2, 16, 17, 1, 16, 276, -2, 16, 18, 1,
                    17, 262, 1, 17, 914, 6, 17, 915, 6, 17, 916, 6, 17, 919, 6, 17, 920, 6, 17, 923, 6, 17, 1067, 15, 17, 631, -3, 17, 632,
-3, 17, 635, -3, 17, 1038, -10, 17, 641, -3, 17, 1039, -10, 17, 1040, -10, 17, 1041, -10, 17, 263, 1, 17, 917, 6, 17,
921, 6, 17, 924, 6, 17, 633, -3, 17, 636, -3, 17, 642, -3, 17, 1042, -10, 17, 264, 1, 17, 918, 6, 17, 922, 6, 17, 925,
6, 17, 634, -3, 17, 637, -3, 17, 643, -3, 17, 1043, -10, 17, 265, 1, 17, 926, 6, 17, 638, -3, 17, 644, -3, 17, 266, 1,
17, 927, 6, 17, 639, -3, 17, 645, -3, 17, 267, 1, 17, 928, 6, 17, 640, -3, 17, 646, -3, 17, 268, 1, 17, 647, -3, 17,
269, 1, 17, 648, -3, 17, 270, 1, 17, 649, -3, 17, 271, 1, 17, 650, -3, 17, 272, 1, 17, 273, 1, 17, 274, 1, 17, 275, 1,
17, 276, 1,
                    18, 631, 1, 18, 1038, 10, 18, 1039, 10, 18, 1040, 10, 18, 914, -4, 18, 915, -4, 18, 919, -4, 18, 1067, -20, 18, 632, 1,
18, 1041, 10, 18, 916, -4, 18, 920, -4, 18, 633, 1, 18, 1042, 10, 18, 917, -4, 18, 921, -4, 18, 634, 1, 18, 1043, 10,
18, 918, -4, 18, 922, -4, 18, 635, 1, 18, 923, -4, 18, 636, 1, 18, 924, -4, 18, 637, 1, 18, 925, -4, 18, 638, 1, 18,
926, -4, 18, 639, 1, 18, 927, -4, 18, 640, 1, 18, 928, -4, 18, 641, 1, 18, 642, 1, 18, 643, 1, 18, 644, 1, 18, 645, 1,
18, 646, 1, 18, 647, 1, 18, 648, 1, 18, 649, 1, 18, 650, 1,
                    19, 914, 1, 19, 1067, 15, 19, 1038, -5, 19, 1039, -5, 19, 915, 1, 19, 1040, -5, 19, 916, 1, 19, 1041, -5, 19, 917, 1,
19, 1042, -5, 19, 918, 1, 19, 1043, -5, 19, 919, 1, 19, 920, 1, 19, 921, 1, 19, 922, 1, 19, 923, 1, 19, 924, 1, 19, 925,
1, 19, 926, 1, 19, 927, 1, 19, 928, 1,
                    20, 1038, 1, 20, 1067, -6, 20, 1039, 1, 20, 1040, 1, 20, 1041, 1, 20, 1042, 1, 20, 1043, 1,
                    21, 1067, 1,
                    22, 277, 1, 22, 278, 1, 22, 279, 1, 22, 280, 1, 22, 281, 1, 22, 282, 1, 22, 929, 1, 22, 283, 1, 22, 284, 1, 22, 285, 1,
22, 930, 1, 22, 286, 1, 22, 931, 1, 22, 932, 1, 22, 933, 1, 22, 287, 1, 22, 288, 1, 22, 289, 1, 22, 934, 1, 22, 290, 1,
22, 935, 1, 22, 936, 1, 22, 937, 1, 22, 291, 1, 22, 938, 1, 22, 939, 1, 22, 940, 1, 22, 941, 1, 22, 942, 1, 22, 943, 1,
22, 1068, 1, 22, 19, -1, 22, 20, -1, 22, 21, -1, 22, 651, -1, 22, 22, -1, 22, 652, -1, 22, 653, -1, 22, 654, -1, 22, 23,
-1, 22, 655, -1, 22, 656, -1, 22, 657, -1, 22, 658, -1, 22, 659, -1, 22, 660, -1, 22, 1044, -1, 22, 24, -1, 22, 661, -1,
22, 662, -1, 22, 663, -1, 22, 664, -1, 22, 665, -1, 22, 666, -1, 22, 1045, -1, 22, 667, -1, 22, 668, -1, 22, 669, -1,
22, 1046, -1, 22, 670, -1, 22, 1047, -1, 22, 1048, -1, 22, 1049, -1,
                    23, 19, 1, 23, 651, 3, 23, 652, 3, 23, 653, 3, 23, 655, 3, 23, 656, 3, 23, 658, 3, 23, 1044, 5, 23, 661, 3, 23, 662, 3,
23, 664, 3, 23, 1045, 5, 23, 667, 3, 23, 1046, 5, 23, 1047, 5, 23, 1048, 5, 23, 277, -2, 23, 278, -2, 23, 280, -2, 23,
929, -4, 23, 283, -2, 23, 930, -4, 23, 931, -4, 23, 932, -4, 23, 287, -2, 23, 934, -4, 23, 935, -4, 23, 936, -4, 23,
938, -4, 23, 939, -4, 23, 941, -4, 23, 1068, -6, 23, 20, 1, 23, 654, 3, 23, 657, 3, 23, 659, 3, 23, 663, 3, 23, 665, 3,
23, 668, 3, 23, 1049, 5, 23, 279, -2, 23, 281, -2, 23, 284, -2, 23, 933, -4, 23, 288, -2, 23, 937, -4, 23, 940, -4, 23,
942, -4, 23, 21, 1, 23, 660, 3, 23, 666, 3, 23, 669, 3, 23, 282, -2, 23, 285, -2, 23, 289, -2, 23, 943, -4, 23, 22, 1,
23, 670, 3, 23, 286, -2, 23, 290, -2, 23, 23, 1, 23, 291, -2, 23, 24, 1,
                    24, 277, 1, 24, 929, 6, 24, 930, 6, 24, 931, 6, 24, 934, 6, 24, 935, 6, 24, 938, 6, 24, 1068, 15, 24, 651, -3, 24, 652,
-3, 24, 655, -3, 24, 1044, -10, 24, 661, -3, 24, 1045, -10, 24, 1046, -10, 24, 1047, -10, 24, 278, 1, 24, 932, 6, 24,
936, 6, 24, 939, 6, 24, 653, -3, 24, 656, -3, 24, 662, -3, 24, 1048, -10, 24, 279, 1, 24, 933, 6, 24, 937, 6, 24, 940,
6, 24, 654, -3, 24, 657, -3, 24, 663, -3, 24, 1049, -10, 24, 280, 1, 24, 941, 6, 24, 658, -3, 24, 664, -3, 24, 281, 1,
24, 942, 6, 24, 659, -3, 24, 665, -3, 24, 282, 1, 24, 943, 6, 24, 660, -3, 24, 666, -3, 24, 283, 1, 24, 667, -3, 24,
284, 1, 24, 668, -3, 24, 285, 1, 24, 669, -3, 24, 286, 1, 24, 670, -3, 24, 287, 1, 24, 288, 1, 24, 289, 1, 24, 290, 1,
24, 291, 1,
                    25, 651, 1, 25, 1044, 10, 25, 1045, 10, 25, 1046, 10, 25, 929, -4, 25, 930, -4, 25, 934, -4, 25, 1068, -20, 25, 652, 1,
25, 1047, 10, 25, 931, -4, 25, 935, -4, 25, 653, 1, 25, 1048, 10, 25, 932, -4, 25, 936, -4, 25, 654, 1, 25, 1049, 10,
25, 933, -4, 25, 937, -4, 25, 655, 1, 25, 938, -4, 25, 656, 1, 25, 939, -4, 25, 657, 1, 25, 940, -4, 25, 658, 1, 25,
941, -4, 25, 659, 1, 25, 942, -4, 25, 660, 1, 25, 943, -4, 25, 661, 1, 25, 662, 1, 25, 663, 1, 25, 664, 1, 25, 665, 1,
25, 666, 1, 25, 667, 1, 25, 668, 1, 25, 669, 1, 25, 670, 1,
                    26, 929, 1, 26, 1068, 15, 26, 1044, -5, 26, 1045, -5, 26, 930, 1, 26, 1046, -5, 26, 931, 1, 26, 1047, -5, 26, 932, 1,
26, 1048, -5, 26, 933, 1, 26, 1049, -5, 26, 934, 1, 26, 935, 1, 26, 936, 1, 26, 937, 1, 26, 938, 1, 26, 939, 1, 26, 940,
1, 26, 941, 1, 26, 942, 1, 26, 943, 1,
                    27, 1044, 1, 27, 1068, -6, 27, 1045, 1, 27, 1046, 1, 27, 1047, 1, 27, 1048, 1, 27, 1049, 1,
                    28, 1068, 1,
                    29, 292, 1, 29, 293, 1, 29, 294, 1, 29, 295, 1, 29, 296, 1, 29, 297, 1, 29, 944, 1, 29, 298, 1, 29, 299, 1, 29, 300, 1,
29, 945, 1, 29, 301, 1, 29, 946, 1, 29, 947, 1, 29, 948, 1, 29, 302, 1, 29, 303, 1, 29, 304, 1, 29, 949, 1, 29, 305, 1,
29, 950, 1, 29, 951, 1, 29, 952, 1, 29, 306, 1, 29, 953, 1, 29, 954, 1, 29, 955, 1, 29, 956, 1, 29, 957, 1, 29, 958, 1,
29, 1069, 1, 29, 25, -1, 29, 26, -1, 29, 27, -1, 29, 671, -1, 29, 28, -1, 29, 672, -1, 29, 673, -1, 29, 674, -1, 29, 29,
-1, 29, 675, -1, 29, 676, -1, 29, 677, -1, 29, 678, -1, 29, 679, -1, 29, 680, -1, 29, 1050, -1, 29, 30, -1, 29, 681, -1,
29, 682, -1, 29, 683, -1, 29, 684, -1, 29, 685, -1, 29, 686, -1, 29, 1051, -1, 29, 687, -1, 29, 688, -1, 29, 689, -1,
29, 1052, -1, 29, 690, -1, 29, 1053, -1, 29, 1054, -1, 29, 1055, -1,
                    30, 25, 1, 30, 671, 3, 30, 672, 3, 30, 673, 3, 30, 675, 3, 30, 676, 3, 30, 678, 3, 30, 1050, 5, 30, 681, 3, 30, 682, 3,
30, 684, 3, 30, 1051, 5, 30, 687, 3, 30, 1052, 5, 30, 1053, 5, 30, 1054, 5, 30, 292, -2, 30, 293, -2, 30, 295, -2, 30,
944, -4, 30, 298, -2, 30, 945, -4, 30, 946, -4, 30, 947, -4, 30, 302, -2, 30, 949, -4, 30, 950, -4, 30, 951, -4, 30,
953, -4, 30, 954, -4, 30, 956, -4, 30, 1069, -6, 30, 26, 1, 30, 674, 3, 30, 677, 3, 30, 679, 3, 30, 683, 3, 30, 685, 3,
30, 688, 3, 30, 1055, 5, 30, 294, -2, 30, 296, -2, 30, 299, -2, 30, 948, -4, 30, 303, -2, 30, 952, -4, 30, 955, -4, 30,
957, -4, 30, 27, 1, 30, 680, 3, 30, 686, 3, 30, 689, 3, 30, 297, -2, 30, 300, -2, 30, 304, -2, 30, 958, -4, 30, 28, 1,
30, 690, 3, 30, 301, -2, 30, 305, -2, 30, 29, 1, 30, 306, -2, 30, 30, 1,
                    31, 292, 1, 31, 944, 6, 31, 945, 6, 31, 946, 6, 31, 949, 6, 31, 950, 6, 31, 953, 6, 31, 1069, 15, 31, 671, -3, 31, 672,
-3, 31, 675, -3, 31, 1050, -10, 31, 681, -3, 31, 1051, -10, 31, 1052, -10, 31, 1053, -10, 31, 293, 1, 31, 947, 6, 31,
951, 6, 31, 954, 6, 31, 673, -3, 31, 676, -3, 31, 682, -3, 31, 1054, -10, 31, 294, 1, 31, 948, 6, 31, 952, 6, 31, 955,
6, 31, 674, -3, 31, 677, -3, 31, 683, -3, 31, 1055, -10, 31, 295, 1, 31, 956, 6, 31, 678, -3, 31, 684, -3, 31, 296, 1,
31, 957, 6, 31, 679, -3, 31, 685, -3, 31, 297, 1, 31, 958, 6, 31, 680, -3, 31, 686, -3, 31, 298, 1, 31, 687, -3, 31,
299, 1, 31, 688, -3, 31, 300, 1, 31, 689, -3, 31, 301, 1, 31, 690, -3, 31, 302, 1, 31, 303, 1, 31, 304, 1, 31, 305, 1,
31, 306, 1,
                    32, 671, 1, 32, 1050, 10, 32, 1051, 10, 32, 1052, 10, 32, 944, -4, 32, 945, -4, 32, 949, -4, 32, 1069, -20, 32, 672, 1,
32, 1053, 10, 32, 946, -4, 32, 950, -4, 32, 673, 1, 32, 1054, 10, 32, 947, -4, 32, 951, -4, 32, 674, 1, 32, 1055, 10,
32, 948, -4, 32, 952, -4, 32, 675, 1, 32, 953, -4, 32, 676, 1, 32, 954, -4, 32, 677, 1, 32, 955, -4, 32, 678, 1, 32,
956, -4, 32, 679, 1, 32, 957, -4, 32, 680, 1, 32, 958, -4, 32, 681, 1, 32, 682, 1, 32, 683, 1, 32, 684, 1, 32, 685, 1,
32, 686, 1, 32, 687, 1, 32, 688, 1, 32, 689, 1, 32, 690, 1,
                    33, 944, 1, 33, 1069, 15, 33, 1050, -5, 33, 1051, -5, 33, 945, 1, 33, 1052, -5, 33, 946, 1, 33, 1053, -5, 33, 947, 1,
33, 1054, -5, 33, 948, 1, 33, 1055, -5, 33, 949, 1, 33, 950, 1, 33, 951, 1, 33, 952, 1, 33, 953, 1, 33, 954, 1, 33, 955,
1, 33, 956, 1, 33, 957, 1, 33, 958, 1,
                    34, 1050, 1, 34, 1069, -6, 34, 1051, 1, 34, 1052, 1, 34, 1053, 1, 34, 1054, 1, 34, 1055, 1,
                    35, 1069, 1,
                    36, 307, 1, 36, 308, 1, 36, 309, 1, 36, 31, -1, 36, 32, -1, 36, 33, -1, 36, 691, -1,
                    37, 31, 1, 37, 691, 3, 37, 307, -2, 37, 308, -2, 37, 32, 1, 37, 309, -2, 37, 33, 1,
                    38, 307, 1, 38, 691, -3, 38, 308, 1, 38, 309, 1,
                    39, 691, 1,
                    40, 310, 1, 40, 311, 1, 40, 312, 1, 40, 34, -1, 40, 35, -1, 40, 36, -1, 40, 692, -1,
                    41, 34, 1, 41, 692, 3, 41, 310, -2, 41, 311, -2, 41, 35, 1, 41, 312, -2, 41, 36, 1,
                    42, 310, 1, 42, 692, -3, 42, 311, 1, 42, 312, 1,
                    43, 692, 1,
                    44, 313, 1, 44, 314, 1, 44, 315, 1, 44, 316, 1, 44, 317, 1, 44, 318, 1, 44, 959, 1, 44, 319, 1, 44, 320, 1, 44, 321, 1,
44, 960, 1, 44, 322, 1, 44, 961, 1, 44, 962, 1, 44, 963, 1, 44, 37, -1, 44, 38, -1, 44, 39, -1, 44, 693, -1, 44, 40, -1,
44, 694, -1, 44, 695, -1, 44, 696, -1, 44, 41, -1, 44, 697, -1, 44, 698, -1, 44, 699, -1, 44, 700, -1, 44, 701, -1, 44,
702, -1, 44, 1056, -1,
                    45, 37, 1, 45, 693, 3, 45, 694, 3, 45, 695, 3, 45, 697, 3, 45, 698, 3, 45, 700, 3, 45, 1056, 5, 45, 313, -2, 45, 314,
-2, 45, 316, -2, 45, 959, -4, 45, 319, -2, 45, 960, -4, 45, 961, -4, 45, 962, -4, 45, 38, 1, 45, 696, 3, 45, 699, 3, 45,
701, 3, 45, 315, -2, 45, 317, -2, 45, 320, -2, 45, 963, -4, 45, 39, 1, 45, 702, 3, 45, 318, -2, 45, 321, -2, 45, 40, 1,
45, 322, -2, 45, 41, 1,
                    46, 313, 1, 46, 959, 6, 46, 960, 6, 46, 961, 6, 46, 693, -3, 46, 694, -3, 46, 697, -3, 46, 1056, -10, 46, 314, 1, 46,
962, 6, 46, 695, -3, 46, 698, -3, 46, 315, 1, 46, 963, 6, 46, 696, -3, 46, 699, -3, 46, 316, 1, 46, 700, -3, 46, 317, 1,
46, 701, -3, 46, 318, 1, 46, 702, -3, 46, 319, 1, 46, 320, 1, 46, 321, 1, 46, 322, 1,
                    47, 693, 1, 47, 1056, 10, 47, 959, -4, 47, 960, -4, 47, 694, 1, 47, 961, -4, 47, 695, 1, 47, 962, -4, 47, 696, 1, 47,
963, -4, 47, 697, 1, 47, 698, 1, 47, 699, 1, 47, 700, 1, 47, 701, 1, 47, 702, 1,
                    48, 959, 1, 48, 1056, -5, 48, 960, 1, 48, 961, 1, 48, 962, 1, 48, 963, 1,
                    49, 1056, 1,
                    50, 42, 1, 50, 703, 3, 50, 704, 3, 50, 705, 3, 50, 323, -2, 50, 324, -2, 50, 325, -2, 50, 964, -4, 50, 43, 1, 50, 706,
3, 50, 326, -2, 50, 327, -2, 50, 44, 1, 50, 328, -2, 50, 45, 1,
                    51, 323, 1, 51, 964, 6, 51, 703, -3, 51, 704, -3, 51, 324, 1, 51, 705, -3, 51, 326, 1, 51, 706, -3, 51, 325, 1, 51, 327,
1, 51, 328, 1,
                    52, 703, 1, 52, 964, -4, 52, 704, 1, 52, 705, 1, 52, 706, 1,
                    53, 964, 1,
                    
NULL), ncol=3, byrow=TRUE); # close ind_mema creation
measmat[[1]][ind_mema[,1:2,drop=FALSE]]=ind_mema[,3]
memaone[[1]]=c(1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0,
0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
0.0, 0.0, 0.0)
        
pwe=ipwe=ip2ipwe=pool_factor=ijpwef=dp_ones=meas2sum=dpw_dpf=ipf_in_ppw=vector("list", nb_exp)
mets_in_res=vector("list", nb_exp)
for (iexp in seq_len(nb_exp)) {
   names(memaone[[iexp]])=nm_measmat[[iexp]]

   # prepare weights of label data for pooled metabs
   # prepare ipwe and ip2ipwe such that pwe[ipwe]=pool[ip2ipwe]
   # gives a good base for weight sum and normalization
   pwe[[iexp]]=double(nb_measmat[[iexp]])+1.
   mets_in_res[[iexp]]=sapply(nm_measmat[[iexp]], function(m) strsplit(m, ":")[[1L]][2L])
   for (po in names(ipooled[[iexp]])) {
      if (po == "ishort") next
      nm_sum=strsplit(po, ":")[[1L]][2L]
      mets=trimws(strsplit(nm_sum, "\\+")[[1L]])
      irpo=ipooled[[iexp]][[po]]
      ipwe[[iexp]]=c(ipwe[[iexp]], irpo) # where weighting is
      i=pmatch(mets, names(nm_poolf))
      if (any(!is.na(i))) {
         for (ir in i) {
            if (is.na(ir)) next
            ijpwef[[iexp]]=rbind(ijpwef[[iexp]], cbind(irpo, ir)) # where free pools matter
         }
      }
      ip2ipwe[[iexp]]=c(ip2ipwe[[iexp]], pmatch(mets, names(nm_poolall)))
      mets_in_res[[iexp]][irpo]=mets
   }
   # order ijpwef for sparse matrix ordering
   if (!is.null(ijpwef[[iexp]])) {
      o=order(ijpwef[[iexp]][,2L], ijpwef[[iexp]][,1L])
      ijpwef[[iexp]]=ijpwef[[iexp]][o,,drop=FALSE]
   }
   pool_factor[[iexp]]=as.factor(nm_measmat[[iexp]])
   # free pool in principal pool weight
   ipf_in_ppw[[iexp]]=apply(outer(mets_in_res[[iexp]], names(nm_poolf), "=="), 1, function(v) if(length(w <-which(v))) w else NA)
   ipf_in_ppw[[iexp]][is.na(ipf_in_ppw[[iexp]])]=0L
   dp_ones[[iexp]]=matrix(0., nb_measmat[[iexp]], nb_poolf)
   dp_ones[[iexp]][cbind(ipwe[[iexp]], ipf_in_ppw[[iexp]][ipwe[[iexp]]])]=1.
   
   # matrix for summing weighted measurements
   meas2sum[[iexp]]=simple_triplet_zero_matrix(length(ipooled[[iexp]]$ishort), nb_measmat[[iexp]])
   meas2sum[[iexp]][cbind(pmatch(nm_measmat[[iexp]], nm_measmat[[iexp]][ipooled[[iexp]]$ishort], dup=TRUE),       seq_len(nb_measmat[[iexp]]))]=1.
   dimnames(meas2sum[[iexp]])=list(nm_meas[[iexp]], nm_measmat[[iexp]])
   
   # dpw_dpf - matrix for derivation of pool weights by free pools
   if (nb_poolf > 0L && length(ijpwef[[iexp]]) > 0) {
      # indeed, we'll have to do weight derivation by free pools
      dpw_dpf[[iexp]]=simple_triplet_zero_matrix(nb_measmat[[iexp]], nb_poolf)
      dpw_dpf[[iexp]][ijpwef[[iexp]]]=1.
   }
}


# prepare flux measurements
nm_fmn=nm_net[c("out_Ac")]
nm_list$fmn=nm_fmn
nb_fmn=length(nm_fmn)
nb_f$nb_fmn=nb_fmn

# measured values
fmn=c(0.213)

# SD for flux measurements
fmndev=c(0.0001)
if (nb_fmn)
   names(fmndev)=names(fmn)=nm_fmn

# indices for measured fluxes
# fallnx[ifmn]=>fmn, here fallnx is complete net|xch flux vector
# combining unknown (dependent), free, constrainded and groth fluxes
ifmn=match(nm_fmn, nm_fallnx)
    
if (TIMEIT) {
   cat("ineq    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
# prepare mi matrix and li vector
# such that mi*fallnx>=li corresponds
# to the inequalities given in ftbl file
nb_ineq=6
mi=matrix(0., nrow=nb_ineq, ncol=nb_fallnx)
li=numeric(nb_ineq)
nm_i=c(c("n:0.0001<=edd", "n:0.0001<=gnd", "n:0.0001<=mae", "n:0.0001<=ppc", "n:1.0<=pyk", "n:0.0001<=zwf"), c())
dimnames(mi)=list(nm_i, nm_fallnx)
    mi[1, nm_net[c("edd")]]=c(1.0)
li[1]=0.0001
mi[2, nm_net[c("gnd")]]=c(1.0)
li[2]=0.0001
mi[3, nm_net[c("mae")]]=c(1.0)
li[3]=0.0001
mi[4, nm_net[c("ppc")]]=c(1.0)
li[4]=0.0001
mi[5, nm_net[c("pyk")]]=c(1.0)
li[5]=1
mi[6, nm_net[c("zwf")]]=c(1.0)
li[6]=0.0001

# add standard limits on [df].xch [0;cupx]
nb_tmp=nrow(mi)
nb_fx=nb_flx+nb_ffx
if (nb_fx) {
   mi=rbind(mi, matrix(0, nrow=2*nb_fx, ncol=nb_fallnx))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, ">=0", sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, ">=0", sep=""))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, "<=", cupx, sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, "<=", cupx, sep=""))
   li=c(li, rep(0, nb_fx), rep(-cupx, nb_fx))
   mi[nb_tmp+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(1., nb_fx)
   mi[nb_tmp+nb_fx+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(-1., nb_fx)
}

nm_inout=grep("^[^c]\\.", nm_net[c("bs_glc6P", "bs_fru6P", "bs_pga_aux", "bs_pga1_aux", "bs_pga2_aux", "bs_pga3_aux", "bs_DHAP", "bs_pyr1_aux",
"bs_pyr4_aux", "bs_pyr3_aux", "bs_rib5p1_aux", "bs_rib5p2", "bs_pep3_aux", "bs_pep4_aux", "bs_pep5", "bs_pep6_aux",
"bs_accoa_aux", "bs_akg2", "bs_akg3", "bs_akg4_aux", "bs_oaa1_aux", "bs_oaa2_aux", "bs_oaa3_aux", "bs_oaa4",
"bs_oaa5_aux", "bs_oaa6_aux", "bs_oaa7_aux", "out_co2", "out_Ac", "out_FTHF", "Glucupt_1", "Glucupt_U")], v=TRUE) # strip out constrained fluxes
nb_inout=length(nm_inout)
if (nb_inout > 0) {
   # add cinout low limits on inout net fluxes
   nb_tmp=nrow(mi)
   # explicit inequalities take precedence over generic ones
   # so eliminate inout fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_inout, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_inout[-i]
   } else {
      nm_tmp=nm_inout
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste("inout ", nm_tmp, ">=", cinout, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(cinout, len_tmp))
   }
}
if (clownr!=0.) {
   # add low limits on net >= clownr for not reversible reactions
   nb_tmp=nrow(mi)
   nm_tmp=nm_net[c("Glucupt_1", "Glucupt_U", "bs_oaa3a", "bs_oaa3b", "bs_pep3a", "bs_pep3b", "bs_pep4a", "bs_pep4b", "bs_glc6P",
"bs_fru6P", "bs_pga_aux", "bs_pga1_aux", "bs_pga2_aux", "bs_pga3_aux", "bs_DHAP", "bs_pyr1_aux", "bs_pyr4_aux",
"bs_pyr3_aux", "bs_rib5p1_aux", "bs_rib5p2", "bs_pep3_aux", "bs_pep4_aux", "bs_pep5", "bs_pep6_aux", "bs_accoa_aux",
"bs_akg2", "bs_akg3", "bs_akg4_aux", "bs_oaa1_aux", "bs_oaa2_aux", "bs_oaa3_aux", "bs_oaa4", "bs_oaa5_aux",
"bs_oaa6_aux", "bs_oaa7_aux", "out_co2", "out_Ac", "out_FTHF", "pfk", "zwf", "gnd", "edd", "citsynth", "idh", "akgdh",
"mae", "bs_pga", "bs_pga1", "bs_pga2", "bs_pyr", "bs_pyr1", "bs_pyr2", "bs_pyr4", "bs_pyr3", "bs_e4p", "bs_rib5p",
"bs_rib5p1", "bs_pep", "bs_pep1", "bs_pep2", "bs_pep6", "bs_pep7", "bs_accoa", "bs_akg", "bs_akg1", "bs_akg4", "bs_oaa",
"bs_oaa1", "bs_oaa2", "bs_oaa5", "bs_oaa6", "bs_oaa7")]
   # explicit inequalities take precedence over generic ones
   # so eliminate notrev fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   # search for inout too
   nm_itmp=paste("inout ", nm_tmp, ">=", sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i, fix=TRUE)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }

   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, ">=", clownr, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(clownr, len_tmp))
   }
}
nb_fn=nb_fln+nb_ffn
if (cupn != 0 && nb_fn > 0) {
   # add absolute upper limits on -cupn <= [df].net <= cupn for net fluxes
   # explicit inequalities take precedence over generic ones
   # so eliminate net fluxes which are already in inequalities
   ## proceed n:smth>=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+>=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, "<=", cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(-1., len_tmp)
   }
   ## proceed n:smth<=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, ">=", -cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(1., len_tmp)
   }
}
#browser()
nb_ineq=NROW(li);

dimnames(mi)=list(nm_i, nm_fallnx)
names(li)=nm_i
# prepare ui matrix and ci vector for optimisation
# ui%*%param-ci>=0
# it is composed of explicite inequalities from ftbl
# and permanent inequalities 0<=xch<=0.999 and scale>=0

# constraints such that ui%*%param-ci>=0
# first flux part
ui=mi%*%(md%*%invAfl%stm%p2bfl+mf)
mic=(md%*%invAfl%*%(c2bfl%stm%fc+cnst2bfl) + mc%*%fc)
ci=as.numeric(li-mi%*%mic)

# finaly, metab part
uip=matrix(0., 0, ncol=nb_poolf)
colnames(uip)=nm_poolf
cip=c()
# ind: irow, metab, coef, rhs, name
uip_ind=c(
    
)
if (length(uip_ind) > 0) {
   uip_ind=matrix(uip_ind, byrow=TRUE, ncol=5L)
} else {
   uip_ind=matrix(0, 0L, 5L)
}
colnames(uip_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(uip_ind) > 0) {
   # rhs are summed up for the same irow by aggregate()
   irow=as.integer(uip_ind[,"irow"])
   cip=aggregate(as.double(uip_ind[,"rhs"]), by=list(irow), sum)[,"x"]
   for (i in seq_len(nrow(uip_ind))) {
      row=uip_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      uip[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(uip) > 0) {
      rownames(uip)=paste("m:", uip_ind[pmatch(seq_len(nrow(uip)), irow),"name"], sep="")
   }
}
names(cip)=rownames(uip)

#browser() # before null inequality removing
# remove all zero rows in ui (constrained fluxes with fixed values)
# find zero indexes
#print(dim(ui))
if (ncol(ui)) {
   zi=apply(ui,1,function(v){return(max(abs(v))<=1.e-14)})
} else {
   # remove all flux inequalities as there is no free fluxe
   zi=rep(TRUE, nrow(ui))
}

if (!all(ci[zi]<=tol)) {
   cat("The following constant inequalities are not satisfied:\n", file=fclog)
   cat(nm_i[zi][ci[zi]>tol], sep="\n", file=fclog)
   cat("They are simply ignored.\n", file=fclog)
   #stop_mes("", file=fcerr)
}
ui=ui[!zi,,drop=FALSE]
ci=ci[!zi]
nm_i=nm_i[!zi]

# complete ui by zero columns corresponding to scale params
if (nb_sc_tot) {
   ui=cbind(as.matrix(ui), matrix(0., NROW(ui), nb_sc_tot))
   # complete ui by scales >=0
   ui=rbind(ui, cbind(matrix(0, nb_sc_tot, nb_ff), diag(1, nb_sc_tot)))
   ci=c(ci,rep(0., nb_sc_tot))
   nm_i=c(nm_i, paste(nm_par[nb_ff+seq_len(nb_sc_tot)], ">=0", sep=""))
   rownames(ui)=nm_i
   names(ci)=nm_i
}

# remove redundant inequalities
#browser()
nb_i=nrow(ui)
ired=c()
if (nb_i > 1L) {
   for (i in 1L:(nb_i-1L)) {
      nmref=nm_i[i]
      for (j in setdiff((i+1L):nb_i, ired)) {
         if (all(ui[j,]==ui[i,]) && ci[i]==ci[j]) {
            # redundancy
            cat("inequality '", nm_i[j], "' redundant with '", nmref, "' is removed.
", sep="", file=fclog)
            ired=c(ired, j)
         }
      }
   }
}
if (!is.null(ired)) {
   # remove all ired inequalities
   ui=ui[-ired,,drop=FALSE]
   ci=ci[-ired]
   nm_i=nm_i[-ired]
}

# metabolite equalities
ep=matrix(0., 0, ncol=nb_poolf)
cp=c()
colnames(ep)=nm_poolf
# ind: irow, metab, coef, rhs, name
ep_ind=c(
    
)
if (length(ep_ind) > 0) {
   ep_ind=matrix(ep_ind, byrow=TRUE, ncol=5L)
} else {
   ep_ind=matrix(0, 0L, 5L)
}
colnames(ep_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(ep_ind) > 0) {
   # rhs are summed up for the same irow by aggregate
   irow=as.integer(ep_ind[,"irow"])
   cp=aggregate(as.double(ep_ind[,"rhs"]), by=list(irow))[,"x"]
   for (i in seq_len(nrow(ep_ind))) {
      row=ep_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      ep[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(ep) > 0) {
      rownames(ep)=paste("m:", ep_ind[pmatch(seq_len(nrow(ep)), irow),"name"], sep="")
   }
}
ep=as.matrix(ep)
names(cp)=rownames(ep)

nb_sys=list(
   reactions=list(
      reversible=14,
      non_reversible=72
   ),
   fluxes=list(
      free=12,
      dependent=55,
      constrained=105
   ),
   metabolites=list(
      input=2,
      output=30,
      intra=49
   ),
   measurements=list(
      flux=1,
      mass=53,
      peak=0,
      label=0,
      metab=0
   ),
   equations=list(
      equalities=6,
      inequalities=6
   ),
   label_variables=list(
      full=c(0,0,0,0,0,0,0,0,0,0,0),
      reduced_cumomers=c(231,359,293,142,39,5)
   ),
   parallel_experiments=1
)
if (sum(nb_sys$label_variables$full)==0) {
   nb_sys$label_variables$full=NULL
}
if (emu) {
   x=nb_sys$label_variables$reduced_cumomers
   nb_sys$label_variables$reduced_cumomers=NULL
   nb_sys$label_variables$emu=paste(x, "*", seq_len(length(x)), "=", x*seq_len(length(x)))
}
    
#browser()

# extend param vector by free pools
if (nb_poolf > 0) {
   param=c(param, poolf)
   nm_par=c(nm_par, nm_poolf)
   nb_param=length(param)
}
nm_list$par=nm_par

#browser()
if (nb_poolf > 0) {
   # extend inequalities ui, ci by uip, cip
   nb_row=nrow(ui)
   nb_col=ncol(ui)
   ui=cbind(ui, matrix (0., nrow=nb_row, ncol=nb_poolf)) # add 0-columns
   ui=rbind(ui, cbind(matrix(0., nrow(uip), ncol=nb_col), uip))
   ci=c(ci, cip)
   
   # extend inequalities ui, ci by cupp>= poolf >= clowp
   # but exclude metabolites that are individually set in the uip (FTBL)
   met_low=met_up=c()
   if (nrow(uip) > 0) {
      # number of non zero entries per row in uip
      i_nz=rowSums(abs(uip) != 0.)
      # number of positive coeffs for alone metabs (i.e. low limit is set)
      i_pos=colSums(uip[i_nz > 0,,drop=FALSE] > 0)
      met_low=nm_poolf[i_pos > 0]
      # number of negative coeffs for alone metabs (i.e. upper limit is set)
      i_neg=colSums(uip[i_nz > 0,,drop=FALSE] < 0)
      met_up=nm_poolf[i_neg > 0]
   }

   # add low limit
   nb_add=nb_poolf-length(met_low)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_low]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(1., nb_add)
      rownames(ui_add)=paste(nm_add, ">=", clowp, sep="")
      if (nrow(ui)) {
         ui=rbind(ui, ui_add)
      } else {
         ui=ui_add
      }
      ci=c(ci, rep(clowp, nb_add))
   }

   # add upper limit
   nb_add=nb_poolf-length(met_up)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_up]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(-1., nb_add)
      rownames(ui_add)=paste(nm_add, "<=", cupp, sep="")
      ui=rbind(ui, ui_add)
      ci=c(ci, rep(-cupp, nb_add))
   }

   nm_i=names(ci)=rownames(ui)
   colnames(ui)=nm_par
}
# extend the matrix of metabolite equalities
ep=cbind(matrix(0., nrow(ep), nb_param-nb_poolf), ep)
colnames(ep)=nm_par

# prepare metabolite pools measurements
nb_poolm=0
nb_f$nb_poolm=nb_poolm
nm_poolm=c()
nm_list$poolm=nm_poolm

# measured values
vecpoolm=c()
names(vecpoolm)=nm_poolm

# inverse of variance for pool measurements
poolmdev=c()
names(poolmdev)=nm_poolm

# simulated metabolite measurements are calculated as
# measmatpool*poolall=>poolm
measmatpool=matrix(0., nrow=nb_poolm, ncol=length(poolall))
dimnames(measmatpool)=list(nm_poolm, nm_poolall)
i=matrix(1+c(), ncol=2, byrow=TRUE)
measmatpool[i]=1.

labargs=new.env()
labargs$labargs2=new.env()
    
# gather all measurement information
measurements=list(
   vec=list(labeled=measvec, flux=fmn, pool=vecpoolm, kin=if (case_i) measvecti else NULL),
   dev=list(labeled=measdev, flux=fmndev, pool=poolmdev, kin=if (case_i) lapply(structure(seq(nb_exp), names=names(measdev)), function(i) {v=measdev[[i]]; nbc=if (is.null(measvecti[[i]])) 0 else ncol(measvecti[[i]]); suppressWarnings(matrix(v, nrow=length(v), ncol=nbc))}) else NULL),
   mat=list(labeled=measmat, flux=ifmn, pool=measmatpool),
   one=list(labeled=memaone)
)
nm_resid=c(if (case_i) unlist(lapply(seq_len(nb_exp), function(iexp) {m=outer(rownames(measvecti[[iexp]]), ti[[iexp]][-1L], paste, sep=", t="); if (length(m) > 0L) paste(iexp, m, sep=":", recycle0=TRUE) else character(0L)})) else unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, nm_meas[[iexp]], sep=":"))), nm_fmn, nm_poolm)
nm_list$resid=nm_resid

if (TIMEIT) {
   cat("preopt  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
names(param)=nm_par
# prepare series of starting points
if (nchar(fseries) > 0) {
   pstart=as.matrix(read.table(file.path(dirw, fseries), header=TRUE, row.names=1L, sep="\t"))
   # skip parameters (rows) who's name is not in nm_par
   i=rownames(pstart) %in% nm_par
   if (!any(i)) {
      stop_mes("Option --fseries is used but no free parameter with known name is found.\n", file=fcerr)
   }
   pstart=pstart[i,,drop=FALSE]
   cat("Using starting values form '", fseries, "' for the following free parameters:\n", paste(rownames(pstart), collapse="\n"), "\n", sep="", file=fclog)
   nseries=ncol(pstart)
   if (initrand) {
      # fill the rest of rows with random values
      i=nm_par %in% rownames(pstart)
      n=sum(!i)
      pstart=rbind(pstart, structure(matrix(runif(n*nseries), n, nseries), dimnames=list(NULL, sprintf(paste0("V%0", ceiling(log10(nseries+1)), "d"), seq(nseries)))))
      rownames(pstart)=c(rownames(pstart)[seq_len(nb_param-n)], nm_par[!i])
   }
   if (nchar(iseries) > 0) {
      iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
      iseries=iseries[iseries<=nseries]
      # subsample
      pstart=pstart[,iseries, drop=FALSE]
      nseries=ncol(pstart)
   } else {
      iseries=seq_len(nseries)
   }
} else if (nchar(iseries) > 0) {
   # first construct pstart then if needed fill it with random values
   # and only then subsample
   iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
   nseries=max(iseries)
   pstart=matrix(rep(param, nseries), nrow=nb_param, ncol=nseries)
   dimnames(pstart)=list(nm_par, sprintf(paste0("V%0", ceiling(log10(nseries+1)), "d"), seq(nseries)))
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
   # subsample
   pstart=pstart[,iseries, drop=FALSE]
   nseries=ncol(pstart)
} else {
   iseries=1L
   pstart=as.matrix(param)
   nseries=1L
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
}
nm_pseries=rownames(pstart)

if (is.null(nseries) || nseries==0) {
   stop_mes(sprintf("No starting values in the series file '%s' or --iseries is empty.", fseries),  file=fcerr)
}

pres=matrix(NA, nb_param, nseries)
rownames(pres)=nm_par
colnames(pres)=colnames(pstart)
costres=rep.int(NA, nseries)

# prepare flux index conversion
ifwrv=1:nb_fwrv
names(ifwrv)=nm_fwrv
ifl_in_fw=if (nb_fln) ifwrv[paste("fwd", substring(c(nm_fln, nm_flx), 4), sep="")] else integer(0)
iff_in_fw=if (nb_ff > 0) ifwrv[paste("fwd", substring(c(nm_ffn, nm_ffx), 4), sep="")] else integer(0)
ifg_in_fw=if (nb_fgr > 0) ifwrv[paste("fwd", substring(nm_fgr, 4), sep="")] else integer(0)

# index couples for jacobian df_dfl, df_dffd
cfw_fl=crv_fl=cbind(ifl_in_fw, seq_len(nb_fl))
cfw_ff=crv_ff=cbind(iff_in_fw, seq_len(nb_ff))
cfw_fg=crv_fg=cbind(ifg_in_fw, nb_ff+seq_len(nb_fgr))
crv_fl[,1L]=(nb_fwrv/2)+crv_fl[,1L]
crv_ff[,1L]=(nb_fwrv/2)+crv_ff[,1L]
crv_fg[,1L]=(nb_fwrv/2)+crv_fg[,1L]

# store it in nb_f
nb_f=append(nb_f, list(cfw_fl=cfw_fl, crv_fl=crv_fl, cfw_ff=cfw_ff,
   crv_ff=crv_ff, cfw_fg=cfw_fg, crv_fg=crv_fg))
nb_f=as.environment(nb_f)

nbc_x=c(0, cumsum(nb_x))
nb_f$nbc_x=nbc_x

# fixed part of jacobian (unreduced by SD)
# measured fluxes
dufm_dp=cbind(dufm_dff(nb_f, nm_list), matrix(0, nrow=nb_fmn, ncol=nb_sc_tot+nb_poolf))
dimnames(dufm_dp)=list(nm_fmn, nm_par)

# measured pools
dupm_dp=matrix(0., nb_poolm, nb_ff+nb_sc_tot)
if (nb_poolf > 0L) {
   dupm_dp=cbind(dupm_dp, measurements$mat$pool[,nm_list$poolf, drop=FALSE])
}
dimnames(dupm_dp)=list(rownames(measurements$mat$pool), nm_par)

#browser()
# prepare argument list for passing to label simulating functions
nm_labargs=c("jx_f", "nb_f", "nm_list", "nb_x", "invAfl", "p2bfl", "g2bfl", "bp", "fc", "xi", "spa", "spaf", "emu", "pool", "measurements", "ipooled", "ir2isc",  "nb_w", "nb_rw", "nbc_x", "measmat", "memaone", "dufm_dp", "dupm_dp", "pwe", "ipwe", "ip2ipwe", "pool_factor", "ijpwef", "ipf_in_ppw", "meas2sum", "dp_ones", "clen", "dirr", "dirw", "dirres", "baseshort", "case_i", "nb_exp", "noscale", "dpw_dpf", "fclog", "fcerr")

if (TIMEIT) {
   cat("labargs : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
tmp=lapply(nm_labargs, function(nm) assign(nm, get(nm), labargs))
#for (nm in nm_labargs) {
#   labargs[[nm]]=get(nm)
#}
#labargs[["nm"]]=labargs[["nm_list"]]

# prepare labargs2 if time_order includes 2
if (case_i && (time_order == "2" || time_order == "1,2")) {
   list2env(as.list(labargs), envir=labargs$labargs2)
   labargs$labargs2$tifull=tifull2
   labargs$labargs2$xi=xi2
   labargs$labargs2$jx_f=new.env()
   labargs$labargs2$nb_f=new.env()
   list2env(as.list(labargs$nb_f), envir=labargs$labargs2$nb_f)
   labargs$labargs2$nb_f$ipf2ircumo=nb_f$ipf2ircumo2
   labargs$labargs2$nb_f$tifu=nb_f$tifu2
}

# formated output in kvh file
if (write_res && wkvh) {
   fkvh_saved=file.path(dirres, "tmp", sprintf("%s_res.kvh", baseshort))
} else {
   fkvh_saved=NULL
}

retcode=numeric(nseries)
cl_type="PSOCK"
cl=NULL
if ((case_i && (time_order %in% c("1,2", "2"))) || sensitive == "mc") {
   if (np > 1L) {
      # prepare cluster
      nodes=if (sensitive == "mc" && !parR) np else 2

      cl=makeCluster(nodes, cl_type) #)
      #cl=makeCluster(1L, cl_type, manual=TRUE, outfile="")
#cat("make cluster=")
#print(cl[[1]])
      labargs[["cl"]]=cl
      nodes=length(cl)
      if (TIMEIT) {
         cat("cl expor: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterExport(cl, c("lsi_fun", "df_dffp", "lab_sim", "is.diff", "lab_resid", "ui", "ci", "ep", "cp", "control_ftbl", "methods", "sln", "labargs", "dirr", "emu", "%stm%", "case_i", "time_order", "fullsys", "nm_inp"))
      if (TIMEIT) {
         cat("cl sourc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterEvalQ(cl, {
         #idth=myinfo$id
         suppressPackageStartupMessages(library(nlsic))
         suppressPackageStartupMessages(library(slam)) # for quick sparse matrices
         suppressPackageStartupMessages(library(Rcpp))
         suppressPackageStartupMessages(library(RcppArmadillo))
         suppressPackageStartupMessages(library(rmumps))
         suppressPackageStartupMessages(library(arrApply)) # for fast apply() on arrays
         suppressPackageStartupMessages(library(multbxxc))
         compiler::enableJIT(0)
         source(file.path(dirr, "tools_ssg.R"))
         #source(file.path(dirr, "nlsic.R"))
         source(file.path(dirr, "opt_cumo_tools.R"))
         source(file.path(dirr, "opt_icumo_tools.R"))
         labargs$spa=sparse2spa(labargs$spa)
         if (case_i && (time_order == "2" || time_order == "1,2")) {
            labargs$labargs2$spa=labargs$spa
         }
         if (fullsys) {
            labargs$spaf=sparse2spa(labargs$spaf)
            if (case_i && (time_order == "2" || time_order == "1,2")) {
               labargs$labargs2$spaf=labargs$spaf
            }
         }
#cat("evalQ idth=", idth, "\n")
#print(labargs)
#print(labargs$labargs2)
#print(labargs$spa)
#print(labargs$labargs2$spa)
#print(list(cre_cl="", labargs=labargs, spa_a1=labargs$spa[[1L]]$a))
         NULL
      })
      clusterSetRNGStream(cl)
      # set worker id
      idw=parLapply(cl, seq_along(cl), function(i) assign("idw", i, envir=.GlobalEnv))

   } else {
      labargs$cl=NULL
   }
}
for (irun in seq_len(nseries)) {
   if (TIMEIT) {
      cat(sprintf("run %4d: %s cpu=%g\n", irun, format(Sys.time()), proc.time()[1]), "\n", sep="", file=fclog)
   }
   param[nm_pseries]=pstart[nm_pseries, irun]
#browser()
   if (nseries > 1) {
      runsuf="." %s+% colnames(pstart)[irun]
   } else {
      runsuf=""
   }
   if (length(nseries) > 0) {
      cat("Starting point", runsuf, "\n", sep="", file=fclog)
   }
   # prepare kvh file name
   if (write_res && wkvh) {
      fkvh=file(substring(fkvh_saved, 1, nchar(fkvh_saved)-4) %s+% runsuf %s+% ".kvh", "w");
   } else {
      fkvh=NULL
   }

   # remove zc inequalities from previous runs
   izc=grep("^zc ", nm_i)
   if (length(izc)) {
      ui=ui[-izc,,drop=FALSE]
      ci=ci[-izc]
      nm_i=rownames(ui)
   }
   # check if initial approximation is feasible
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   # set tolerance for inequality
   tol_ineq=if ("BFGS" %in% methods) 0. else tol
   nbad=sum(ineq <= -tol_ineq)
   if (anyNA(param))
      stop_mes("NA found in initial 'param' values:\n\t",
      paste0(apply(cbind(nm_par, param), 1, paste0, collapse="\t"), collapse="\n\t"))
   if (nbad > 0) {
      if (TIMEIT) {
         cat(sprintf("put_ins : %s cpu=%g\n", format(Sys.time()), proc.time()[1]), "\n", sep="", file=fclog)
      }
      cat("The following ", nbad, " inequalities are not respected at starting point", runsuf, ":\n", sep="", file=fclog)
      i=ineq[ineq<= -tol_ineq]
      cat(paste(names(i), i, sep="\t", collapse="\n"), "\n", sep="", file=fclog)
      # put them inside
      if (write_res) {
         capture.output(pinside <- put_inside(param, ui, ci), file=fclog)
      } else {
         pinside <- put_inside(param, ui, ci)
      }
      if (any(is.na(pinside))) {
         if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
            # fatal error occured
            cat("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n",
               file=fcerr, sep="")
            #close(fkvh)
            retcode[irun]=attr(pinside, "err")
            next;
         }
      } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0) {
         # non fatal problem
         cat(paste("***Warning: put_inside: ", attr(pinside, "mes"), collapse=""), "\n", file=fclog)
      }
      param[]=pinside
   }

   # prepare zero crossing strategy
   # inequalities to keep sens of net flux on first call to opt_wrapper()
   # if active they are removed on the second call to opt_wrapper()
   # and finaly all zc constraints are relaxed on the last call to opt_wrapper()
   fallnx=param2fl(param, labargs)$fallnx
   mi_zc=NULL
   li_zc=NULL
   if (!noopt && zerocross && length(grep("^[df]\\.n\\.", nm_fallnx))>0) {
      if (TIMEIT) {
         cat("zc ineq : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
#browser()
      # prepare fluxes that are already in inequalities in alone mode
      ige=names(which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==1) & li>=0))
      ige=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ige, v=TRUE)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ige, v=TRUE)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ige, v=TRUE))
      ))]
      ile=which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==-1)&li>=0)
      ile=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ile, v=TRUE)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ile, v=TRUE)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ile, v=TRUE))
      ))]
      # add lower limits on [df].net >= zc for positive net fluxes
      # and upper limits on [df].net <= -zc for negative net fluxes
      nm_izc=c()
      ipos=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]>=0.)), ige)
      ineg=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]<0.)), ile)
      mi_zc=matrix(0, nrow=length(ipos)+length(ineg), ncol=nb_fallnx)
      colnames(mi_zc)=nm_fallnx
      if (length(ipos)) {
         nm_izc=c(nm_izc, paste("zc ", ipos, ">=", zc, sep=""))
         mi_zc[(1:length(ipos)),ipos]=diag(1., length(ipos))
      }
      if (length(ineg)) {
         nm_izc=c(nm_izc, paste("zc ", ineg, "<=", -zc, sep=""))
         mi_zc[length(ipos)+(1:length(ineg)),ineg]=diag(-1., length(ineg))
      }
      rownames(mi_zc)=nm_izc
      li_zc=rep(zc, length(nm_izc)) # that's ok for both pos and neg constraints
      ui_zc=cbind(mi_zc%*%(md%*%invAfl%stm%p2bfl+mf),
         matrix(0., nrow=nrow(mi_zc), ncol=nb_sc_tot))
      if (nb_fgr > 0) {
         ui_zc=cbind(ui_zc, mi_zc%*%((md%*%invAfl%stm%g2bfl)+mg*nb_f$mu))
      } else if (nb_poolf > 0) {
         ui_zc=cbind(ui_zc, matrix(0., nrow=nrow(mi_zc), ncol=nb_poolf))
      }
      ci_zc=li_zc-mi_zc%*%mic
      # remove constant inequalities
      if (ncol(ui_zc)) {
         zi=apply(ui_zc,1,function(v){return(max(abs(v))<=1.e-14)})
      } else {
         # remove all flux inequalities as there is no free params
         zi=rep(TRUE, nrow(ui_zc))
      }

      inotsat=ci_zc[zi]>tol_ineq
      if (any(inotsat)) {
         cat("***Warning: the following constant zc inequalities are not satisfied:\n", file=fclog)
         cat(nm_izc[zi][inotsat], sep="\n", file=fclog)
      }
      ui_zc=ui_zc[!zi,,drop=FALSE]
      ci_zc=ci_zc[!zi]
      nm_izc=nm_izc[!zi]
      mi_zc=mi_zc[!zi,,drop=FALSE]

      # remove redundant/contradictory inequalities
      nb_zc=nrow(ui_zc)
      nb_i=nrow(ui)
      ired=c()
      tui=t(ui)
      uzcd=sapply(seq_len(nb_zc), function(i) apply(abs(tui-ui_zc[i,]), 2L, max))
      uzcs=sapply(seq_len(nb_zc), function(i) apply(abs(tui+ui_zc[i,]), 2L, max))
      czcd=abs(outer(abs(ci), abs(ci_zc), "-"))
      ired=which(apply((uzcd < tol_ineq | uzcs < tol_ineq) & czcd <= 1.e-2, 2, any))
      
      if (length(ired) > 0L) {
         # remove all ired inequalities
         cat("The following ", length(ired), " zerocross inequalities are redundant and are removed:\n", paste(nm_izc[ired], collapse="\n"), "\n", sep="", file=fclog)
         ui_zc=ui_zc[-ired,,drop=FALSE]
         ci_zc=ci_zc[-ired]
         nm_izc=nm_izc[-ired]
         mi_zc=mi_zc[-ired,,drop=FALSE]
      }
      if (nrow(ui_zc)) {
         # add zc inequalities
         ui=rbind(ui, ui_zc)
         ci=c(ci, ci_zc)
         nm_i=c(nm_i, nm_izc)
      }
      rm(ui_zc, ci_zc, uzcd, uzcs, czcd)
   }
   rres=NULL

   # set initial scale values to sum(measvec*simlab/dev**2)/sum(simlab**2/dev**2)
   # for corresponding measurements
   if (nb_sc_tot > 0) {
      if (TRUE) { # always estimate scaling params even for --noopt
         if (TIMEIT) {
            cat("res esti: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         if (write_res) {
            capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
         } else {
            rres <- lab_resid(param, cjac=FALSE, labargs)
         }
         if (!is.null(rres$err) && rres$err) {
            cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
            #close(fkvh)
            retcode[irun]=rres$err
            next
         }
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at init scale values)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         for (iexp in seq_len(nb_exp)) {
            simlab=jx_f$usimlab[[iexp]]
            measinvvar=1./measurements$dev$labeled[[iexp]]**2
            ms=measvec[[iexp]]*simlab*measinvvar
            ss=simlab*simlab*measinvvar
            # get only valid measurements
            iva=!is.na(ms)
            for (i in nb_ff+nb_sc_base[iexp]+seq_len(nb_sc[[iexp]])) {
               im=(ir2isc[[iexp]]==(i+1)) & iva
               if (sum(im) < 2) {
                  mes=sprintf("scaling: no sufficient valid data for scaling factor '%s'\n", nm_par[i])
                  stop_mes(mes, file=fcerr)
               }
               param[i]=sum(ms[im])/sum(ss[im])
            }
         }
      } else {
         # if no optimization, set all scaling params to 1.
         param[nb_ff+seq_len(nb_sc_tot)]=1.
      }
   }

#browser()
   # see if there are any active inequalities at starting point
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   nbad=sum(abs(ineq)<=tol_ineq)
   if (anyNA(param))
      stop_mes("NA introduced in 'param' values during scaling factor estimation:
	",
      paste0(apply(cbind(nm_par, param), 1, paste0, collapse="	"), collapse="
	"))
   if (nbad > 0) {
      cat("The following ", nbad, " ineqalitie(s) are active at starting point", runsuf, ":\n",
         paste(names(ineq[abs(ineq)<=tol_ineq]), collapse="\n"), "\n", sep="", file=fclog)
   }

   if (TIMEIT && wkvh) {
      cat("kvh init: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }

   if (write_res && wkvh) {
      cat("influx\n", file=fkvh)
      cat("\tversion\t", vernum, "\n", file=fkvh, sep="")
      cat("\tlabeling\t", if (case_i) "instationary" else "stationary", "\n", file=fkvh, sep="")
      # save options of command line
      cat("\truntime options\n", file=fkvh)
      cat("\t\thelp='==SUPPRESS=='
version='==SUPPRESS=='
TIMEIT=TRUE
parR=TRUE\n", file=fkvh)
   }
   
   if (write_res && wkvh) {
      obj2kvh(R.Version(), "R.Version", fkvh, indent=1)
      cat("\tR command line\n", file=fkvh)
      obj2kvh(opts, "opts", fkvh, indent=2)
      cat("\t\texecution date	", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fkvh)
      
      # resume system sizes
      obj2kvh(nb_sys, "system sizes", fkvh)
      
      # save initial param
      cat("starting point\n", file=fkvh)
      names(param)=nm_par
      obj2kvh(param, "starting free parameters", fkvh, indent=1)
   }
#browser()
   if (!length(rres)) {
      rres <- lab_resid(param, cjac=FALSE, labargs)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #close(fkvh)
         retcode[irun]=rres$err
         next
      }
      if (sum(is.infinite(rres$res))) {
         cat("Infinite values appeared in residual vector (at starting point)", file=fcerr)
         retcode[irun]=1
         #close(fkvh)
         next
      }
   }
   rcost=if (length(rres$res) && !all(ina <- is.na(rres$res))) sum(crossprod(rres$res[!ina])) else NA
   if (write_res && wkvh) {
      obj2kvh(rcost, "starting cost value", fkvh, indent=1)
      obj2kvh(Afl, "flux system (Afl)", fkvh, indent=1)
   }
   fg=numeric(nb_f$nb_fgr)
   names(fg)=nm_list$fgr
   if (nb_f$nb_fgr > 0) {
      fg[paste("g.n.", substring(nm_list$poolf, 4), "_gr", sep="")]=nb_f$mu*param[nm_list$poolf]
   }
   if (write_res && wkvh) {
      btmp=as.numeric(p2bfl%stm%param[seq_len(nb_f$nb_ff)]+bp+g2bfl%stm%fg)
      names(btmp)=dimnames(Afl)[[1]]
      obj2kvh(btmp, "flux system (bfl)", fkvh, indent=1)
   }

   #cat("mass vector:\n", file=fclog)
   #print_mass(x)

   names(param)=nm_par

#browser()
   if (optimize && nb_ff+nb_poolf > 0L) {
      if (!(least_norm || sln || !"nlsic" %in% methods)) {
         # check if at starting position all fluxes can be resolved
         if (TIMEIT) {
            cat("check ja: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         rres=lab_resid(param, cjac=TRUE, labargs)
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at identifiability check)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         if (any(is.infinite(rres$jacobian))) {
            cat("Infinite values appeared in Jacobian (at identifiability check)", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         qrj=qr(jx_f$dr_dff, LAPACK=TRUE)
         d=diag(qrj$qr)
         qrj$rank=sum(abs(d)>abs(d[1])*tol)
         if (is.na(qrj$rank)) {
            cat("Rank of starting jacobian could not be estimated.", file=fcerr)
            retcode[irun]=1
            #close(fkvh)
            next
         }
         if (qrj$rank) {
            nm_uns=nm_ff[qrj$pivot[-(1:qrj$rank)]]
         } else {
            nm_uns=nm_ff
         }
         if (qrj$rank < nb_ff) {
            # Too bad. The jacobian of free fluxes is not of full rank.
            dimnames(jx_f$dr_dff)[[2]]=c(nm_ffn, nm_ffx)
            fname="dbg_dr_dff_singular" %s+% runsuf %s+% ".csv"
            cat(sprintf("Provided measurements (labeling and fluxes) are not sufficient to resolve all free fluxes.\nUnsolvable fluxes may be:\n%s\nJacobian dr_dff is written in the result kvh file (if --wkvh is activated).\n",
               paste(nm_uns, sep=", ", collapse=", ")),
               file=fcerr)
            if (write_res && wkvh) {
               obj2kvh(jx_f$dr_dff, "Jacobian dr_dff", fkvh, indent=0)
            }
            #close(fkvh)
            retcode[irun]=1
            next
         }
      }
      if (TIMEIT) {
         cat("optim   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      # pass control to the chosen optimization method
      if (time_order=="1,2")
         labargs$time_order="1" # start with order 1, later continue with 2
#browser()
      for (method in methods) {
         if (write_res) {
            capture.output(res <- opt_wrapper(param, method, measurements, jx_f, labargs), file=fclog)
         } else {
            res <- opt_wrapper(param, method, measurements, jx_f, labargs)
         }
         if ((!is.null(res$err) && res$err) || is.null(res$par)) {
            cat("***Warning: error occured in first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fclog)
            res$par=rep(NA, length(param))
            res$cost=NA
         } else if (!is.null(res$mes) && nchar(res$mes)) {
            cat("***Warning: in first optimization pass in run ", runsuf, ": ", res$mes, "\n", sep="", file=fclog)
         }
         if (any(is.na(res$par))) {
#browser()
            res$retres$jx_f=NULL # to avoid writing of huge data
            if (write_res && wkvh) {
               obj2kvh(res, "failed first pass optimization process information", fkvh)
            }
            cat("Optimization failed", runsuf, ": ", res$mes, "\n", file=fcerr, sep="")
            #close(fkvh) # some additional information can be written into fkvh
            retcode[irun]=max(res$err, 1)
            next
         }
         param=res$par
#browser()
         if (zerocross && !is.null(mi_zc)) {
            if (TIMEIT) {
               cat("secondzc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
            }
            # inverse active "zc" inequalities
            nm_inv=names(which((ui%*%res$par-ci)[,1]<=tol_ineq))
            i=grep("^zc ", nm_inv, v=TRUE)
            if (length(i) > 0) {
               i=str2ind(i, nm_i)
               cat("The following inequalities are active after first pass
   of zero crossing strategy and will be inverted", runsuf, ":\n", paste(nm_i[i], collapse="\n"), "\n", sep="", file=fclog)
               ipos=grep(">=", nm_i[i], v=TRUE)
               ineg=grep("<=", nm_i[i], v=TRUE)
               ui[i,]=-ui[i,,drop=FALSE]
               if (length(ipos)) {
                  ipzc=str2ind(ipos, nm_izc)
                  ipos=str2ind(ipos, nm_i)
                  ci[ipos]=as.numeric(zc+mi_zc[ipzc,,drop=FALSE]%*%mic)
                  nm_i[ipos]=sub(">=", "<=-", nm_i[ipos])
               }
               if (length(ineg)) {
                  inzc=str2ind(ineg, nm_izc)
                  ineg=str2ind(ineg, nm_i)
                  ci[ineg]=as.numeric(zc+mi_zc[inzc,,drop=FALSE]%*%mic)
                  nm_i[ineg]=sub("<=-", ">=", nm_i[ineg])
               }
               rownames(ui)=nm_i
               names(ci)=nm_i
               # enforce new inequalities
               reopt=TRUE
               if (write_res) {
                  capture.output(pinside <- put_inside(res$par, ui, ci), file=fclog)
               } else {
                  pinside <- put_inside(res$par, ui, ci)
               }
               if (any(is.na(pinside))) {
                  if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
                     # fatal error occured, don't reoptimize
                     cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
                     reopt=FALSE
                  }
               } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0){
                  # non fatal problem
                  cat(paste("***Warning: put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fclog)
               }
               # reoptimize
               if (reopt) {
                  cat("Second zero crossing pass", runsuf, "\n", sep="", file=fclog)
                  if (write_res) {
                     capture.output(reso <- opt_wrapper(pinside, method, measurements, new.env(), labargs), file=fclog)
                  } else {
                     reso <- opt_wrapper(pinside, method, measurements, new.env(), labargs)
                  }
                  if (reso$err || is.null(reso$par)) {
                     cat("***Warning: error in second zero crossing pass: ", reso$mes, "\n", sep="", file=fclog)
                  } else if (!is.null(reso$mes) && nchar(reso$mes)) {
                     cat("***Warning: second zero crossing pass", runsuf, ": ", reso$mes, "\n", sep="", file=fclog)
                  }
                  if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                     param=reso$par
                     res=reso
                     jx_f=labargs$jx_f
                  }
                  if (any(is.na(reso$par))) {
                     reso$retres$jx_f=NULL # to avoid writing of huge data
                     if (write_res && wkvh)
                        obj2kvh(reso, "failed second pass optimization process information", fkvh)
                     cat("***Warning: second zero crossing pass failed. Keep free parameters from previous pass", runsuf, "\n", file=fclog, sep="")
                  }
               }
               # last pass, free all zc constraints
               i=grep("^zc ", nm_i)
               if (length(i) > 0) {
                  if (TIMEIT) {
                     cat("last zc : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
                  }
                  ui=ui[-i,,drop=FALSE]
                  ci=ci[-i]
                  nm_i=nm_i[-i]
                  cat("Last zero crossing pass (free of zc constraints)", runsuf, "\n", sep="", file=fclog)
                  if (write_res) {
                     capture.output(reso <- opt_wrapper(param, method, measurements, new.env(), labargs), file=fclog)
                  } else {
                     reso <- opt_wrapper(param, method, measurements, new.env(), labargs)
                  }
                  if (reso$err || is.null(reso$par) || (!is.null(res$mes) && nchar(res$mes))) {
                     cat("***Warning: last zero crossing (free of zc)", runsuf, ": ", reso$mes, "\n", sep="", file=fclog)
                  }
                  if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                     param=reso$par
                     res=reso
                     jx_f=labargs$jx_f
                  }
                  if (any(is.na(res$par))) {
                     res$retres$jx_f=NULL # to avoid writing of huge data
                     if (write_res && wkvh)
                        obj2kvh(res, "failed last pass optimization process information", fkvh)
                     cat("***Warning: last zero crossing pass failed. Keep free parameters from previous passes", runsuf, "\n", file=fclog, sep="")
                  }
               }
            } else {
               cat("After the first optimization, no zero crossing inequality was activated. So no reoptimization", runsuf, "\n", sep="", file=fclog)
            }
         } # end if zero crossing
      } # for method
#browser()
      param=res$par
      names(param)=nm_par
      if (excl_outliers != F) {
         # detect outliers
         if (TIMEIT) {
            cat("outliers: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         iva=!is.na(res$res)
         zpval=rz.pval.bi(res$res)
         iout=which(zpval <= excl_outliers & iva)
         #cat("iout=", iout, "\n", file=fclog)
         if (length(iout)) {
            measurements$outlier=iout
            outtab=cbind(residual=res$res[iout], `p-value`=zpval[iout])
            row.names(outtab)=nm_resid[iout]
            cat("Excluded outliers at p-value ", excl_outliers, ":\n", sep="", file=fclog)
            write.table(outtab, file=fclog, append=TRUE, quote=FALSE, sep="\t", col.names=FALSE)
            
            # optimize with the last method from methods
            if (write_res) {
               capture.output(reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs), file=fclog)
            } else {
               reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs)
            }
            if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
               cat("***Warning: error without outliers: ", reso$mes, "\n", sep="", file=fclog)
            }
            if (any(is.na(reso$par))) {
               cat("***Warning: optimization with outliers excluded has failed", runsuf, "\n", file=fclog, sep="")
               # continue without outlier exclusion
               measurements$outlier=NULL
            } else {
               res=reso
               param=reso$par
               names(param)=nm_par
               jx_f=labargs$jx_f
               labargs$measurements=measurements # store outliers
               if (write_res && wkvh)
                  obj2kvh(outtab, "excluded outliers", fkvh)
            }
         } else {
            cat("***Warning: outlier exclusion at p-value "%s+%excl_outliers%s+%" has been requested but no outlier was detected at this p-value threshold.", "\n", sep="", file=fclog)
         }
      }
      if (case_i && time_order=="1,2") {
         if (TIMEIT) {
            cat("order 2 : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         labargs$time_order="2" # continue with the 2-nd order
         if (write_res) {
            capture.output(reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs), file=fclog)
         } else {
            reso <- opt_wrapper(param, tail(methods, 1L), measurements, new.env(), labargs)
         }
         if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
            cat("***Warning: order2: ", reso$mes, "\n", sep="", file=fclog)
         }
         if (any(is.na(reso$par))) {
            cat("***Warning: optimization time_order 2 (in '1,2' suite) has failed, run=", runsuf, "\n", file=fclog, sep="")
         } else {
            res=reso
            param=reso$par
            names(param)=nm_par
            jx_f=labargs$jx_f
         }
      }
#browser()
      optinfo=list(
         "fitted parameters"=param,
         "last increment before backtracking"=res$lastp,
         "last increment after backtracking"=res$laststep,
         "iteration number"=res$it,
         "convergence history"=res$hist,
         "exit message"=res$mes
      )
      if (write_res && wkvh)
         obj2kvh(optinfo, "optimization process information", fkvh)
      rres=res$retres
   } else {
      if (TIMEIT) {
         cat("residjac: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      rres=lab_resid(param, TRUE, labargs)
   }
   if (TIMEIT) {
      cat("postopt : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # active constraints
   if (!all(is.na(param))) {
      ine=as.numeric(abs(ui%*%param-ci))<tol_ineq
      if (any(ine) && write_res && wkvh) {
         obj2kvh(nm_i[ine], "active inequality constraints", fkvh)
      }
   }
   poolall[nm_poolf]=param[nm_poolf]

#browser()
   if (is.null(jx_f$jacobian)) {
      # final jacobian calculation
      if (write_res) {
         capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      } else {
         rres <- lab_resid(param, cjac=TRUE, labargs)
      }
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #if (write_res && wkvh)
         #   close(fkvh)
         retcode[irun]=rres$err
         next
      }
   }
   rcost=cumo_cost(param, labargs, rres)
   pres[,irun]=param
   costres[irun]=rcost
   if (write_res) {
      if (wkvh) obj2kvh(rcost, "final cost", fkvh)
#browser()
      # get z p-values on residual vector
      zpval=rz.pval.bi(rres$res)
      resid=list()
      if (sum(nb_meas)) {
         resid[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) if (is.matrix(jx_f$reslab[[iexp]])) jx_f$reslab[[iexp]] else cbind(residual=jx_f$reslab[[iexp]], `p-value`=zpval[seq_along(jx_f$reslab[[iexp]])]))
         names(resid[["labeled data"]])=nm_exp
      
         if (case_i) {
            resid[["labeled data p-value"]]=vector("list", nb_exp)
            names(resid[["labeled data p-value"]])=nm_exp
            for (iexp in seq_len(nb_exp)) {
               mtmp=zpval[seq_along(jx_f$reslab[[iexp]])]
               dim(mtmp)=dim(jx_f$reslab[[iexp]])
               dimnames(mtmp)=dimnames(jx_f$reslab[[iexp]])
               resid[["labeled data p-value"]][[iexp]]=mtmp
               rm(mtmp)
            }
         }
      }
      nb_reslab_tot=sum(sapply(jx_f$reslab, length))
      if (length(jx_f$resflu))
         resid[["measured fluxes"]]=cbind(residual=jx_f$resflu, `p-value`=zpval[nb_reslab_tot+seq_along(jx_f$resflu)])
      if (length(jx_f$respool))
         resid[["measured pools"]]=cbind(residual=if (is.matrix(jx_f$respool)) jx_f$respool[,1] else jx_f$respool, `p-value`=zpval[nb_reslab_tot+length(jx_f$resflu)+seq_along(jx_f$respool)])
      if (wkvh)
         obj2kvh(resid, "(simulated-measured)/sd_exp", fkvh)

      # simulated measurements -> out
      simul=list()
#browser()
      if (case_i) {
         if (sum(nb_meas)) {
            if (addnoise) {
               simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) jx_f$usm[[iexp]]+rnorm(length(jx_f$usm[[iexp]]))*measurements$dev$labeled[[iexp]])
               names(simul[["labeled data"]])=nm_exp
            } else {
               # move mass in usm into valid interval [0, 1] and sum=1
               simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) {
                  x=clamp(jx_f$usm[[iexp]], 0, 1)
                  # get unique mass names to sum up to 1
                  nmx=rownames(x)
                  nm_m=nmx[startsWith(nmx, "m:")]
                  if (length(nm_m)) {
                     # get unique fragments
                     fr_u=unique(sapply(strsplit(nm_m, ":", fixed=TRUE), function(v) paste0(c(v[1L:3L], ""), collapse=":")))
                     lapply(fr_u, function(nm) {
                        # get indexes per fragment
                        i=which(startsWith(nmx, nm))
                        mets=strsplit(nm, ":", fixed=TRUE)[[1L]][2L]
                        met1=strsplit(mets, "+", fixed=TRUE)[[1L]][1L]
                        if (length(i) < clen[met1]+1)
                           return(NULL)
                        s=colSums(x[i,,drop=FALSE])
                        x[i,] <<- arrApply::arrApply(x[i,,drop=FALSE], 2, "multv", v=1./s)
                        NULL
                     })
                  }
                  x
               })
               names(simul[["labeled data"]])=nm_exp
            }
            # simul --> .miso.sim
            mlp2LAB=c(m="MS", l="LAB", p="PEAK")
            cnm=c("Id", "Comment", "Specie", "Fragment", "Dataset", "Isospecies", "Value", "SD", "Time", "Residual", "Pvalue")
            for (fnm in nm_exp) {
               rnm=gsub("#", "", rownames(simul[["labeled data"]][[fnm]]), fixed=TRUE)
               mnm=strsplitlim(rnm, ":", fixed=TRUE, lim=NA, strict=TRUE)
               mnm=matrix(unlist(mnm), ncol=length(mnm[[1L]]), byrow=TRUE)
               ct=rep(colnames(simul[["labeled data"]][[fnm]]), each=nrow(simul[["labeled data"]][[fnm]]))
               c3=suppressWarnings(as.integer(mnm[, 3L]))
               df=cbind(
                  "",
                  "",
                  Specie=mnm[, 2L],
                  Fragment=ifelse(mnm[, 1L] == "m", mnm[, 3L], ""),
                  Dataset=paste0(mlp2LAB[mnm[, 1L]], "_", mnm[, 2L], "_", mnm[, 3L]),
                  Isospecies=ifelse(mnm[, 1L] == "m",
                     paste0("M", mnm[, 4L]), # MS: M0, M1, etc
                     ifelse(mnm[, 1L] == "l", mnm[, 3L], # label: 01x+00x etc
                     paste0(mnm[, 3L], "->", # peak: 2->1,3 etc.
                           ifelse(mnm[, 4L] == "S", "",
                           ifelse(mnm[, 4L] == "D-", c3-1,
                           ifelse(mnm[, 4L] == "D+", c3+1,
                           paste0(c3-1, ",", c3+1) # DD
                           )))))),
                  Value=c(simul[["labeled data"]][[fnm]]),
                  SD=measdev[[fnm]],
                  Time=ct,
                  Resid=c(resid[["labeled data"]][[fnm]]),
                  Pvalue=c(resid[["labeled data p-value"]][[fnm]])
               )
               colnames(df)=cnm
               write.table(df, sep="	", quote=FALSE, row.names=FALSE, fileEncoding="utf8", file=file.path(dirres, paste0(fnm, runsuf, ".miso.sim")))
            }
         }
      } else {
         if (sum(nb_meas)) {
            if (addnoise) {
               simlab=lapply(seq_len(nb_exp), function(iexp) jx_f$simlab[[iexp]]+rnorm(length(jx_f$simlab[[iexp]]))*measurements$dev$labeled[[iexp]])
               names(simlab)=nm_exp
            } else {
               simlab=jx_f$simlab
               names(simlab)=nm_exp
            }
            if (nb_sc_tot > 0) {
               simul[["labeled data (unscaled)"]]=jx_f$usimlab
               simul[["labeled data (scaled)"]]=simlab
            } else {
               simul[["labeled data"]]=simlab
            }
            # simlab --> .miso.sim
            mlp2LAB=c(m="MS", l="LAB", p="PEAK")
            cnm=c("Id", "Comment", "Specie", "Fragment", "Dataset", "Isospecies", "Value", "SD", "Time", "Residual", "Pvalue")
            for (fnm in nm_exp) {
               rnm=gsub("#", "", names(simlab[[fnm]]), fixed=TRUE)
               mnm=strsplitlim(rnm, ":", fixed=TRUE, lim=NA, strict=TRUE)
               mnm=matrix(unlist(mnm), ncol=length(mnm[[1L]]), byrow=TRUE)
               c3=suppressWarnings(as.integer(mnm[, 3L]))
               df=cbind(
                  "",
                  "",
                  Specie=mnm[, 2L],
                  Fragment=ifelse(mnm[, 1L] == "m", mnm[, 3L], ""),
                  Dataset=paste0(mlp2LAB[mnm[, 1L]], "_", mnm[, 2L], "_", mnm[, 3L]),
                  Isospecies=ifelse(mnm[, 1L] == "m",
                     paste0("M", mnm[, 4L]), # MS: M0, M1, etc
                     ifelse(mnm[, 1L] == "l", mnm[, 3L], # label: 01x+00x etc
                     paste0(mnm[, 3L], "->", # peak: 2->1,3 etc.
                           ifelse(mnm[, 4L] == "S", "",
                           ifelse(mnm[, 4L] == "D-", c3-1,
                           ifelse(mnm[, 4L] == "D+", c3+1,
                           paste0(c3-1, ",", c3+1) # DD
                           )))))),
                  Value=simlab[[fnm]],
                  SD=measdev[[fnm]],
                  Time="",
                  resid[["labeled data"]][[fnm]]
               )
               colnames(df)=cnm
               write.table(df, sep="	", quote=FALSE, row.names=FALSE, fileEncoding="utf8", file=file.path(dirres, paste0(fnm, runsuf, ".miso.sim")))
            }
         }
      }
      #browser()
      if (nb_fmn) {
         if (addnoise)
            simul[["measured fluxes"]]=jx_f$simfmn+rnorm(length(jx_f$simfm))*measurements$dev$flux
         else
            simul[["measured fluxes"]]=jx_f$simfmn
         # measured fluxes --> .mflux
         cnm=c("Id", "Comment", "Flux", "Value", "SD", "Residual", "Pvalue")
         df=structure(cbind("", "", substring(names(simul[["measured fluxes"]]), 5), simul[["measured fluxes"]], measurements$dev$flux, resid[["measured fluxes"]]), dimnames=list(NULL, cnm))
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".mflux.sim")))
      }
      if (nb_poolm) {
         if (addnoise)
            simul[["measured pools"]]=jx_f$simpool+rnorm(length(jx_f$simpool))*measurements$dev$pool
         else
            simul[["measured pools"]]=jx_f$simpool
         # measured metabolites --> .mmet
         cnm=c("Id", "Comment", "Specie", "Value", "SD", "Residual", "Pvalue")
         df=structure(cbind("", "", substring(names(simul[["measured pools"]]), 4), simul[["measured pools"]], measurements$dev$pool, resid[["measured pools"]]), dimnames=list(NULL, cnm))
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".mmet.sim")))
      }
      rm(resid, zpval)
      if (wkvh) obj2kvh(simul, "simulated measurements", fkvh)
   
      # SD -> out
      # get index of non null components
      iget=sapply(names(measurements$dev), function(nm) !is.null(measurements$dev[[nm]]) & nm %in% c("labeled", "flux", "pool"))
      if (wkvh) obj2kvh(measurements$dev[iget], "measurement SD", fkvh)

      # gradient -> kvh
      if (length(jx_f$res) && !all(ina <- is.na(jx_f$res)) && wkvh) {
         if (any(ina)) {
            gr=2*as.numeric(crossprod(jx_f$res[!ina], jx_f$jacobian[!ina,,drop=FALSE]))
         } else {
            gr=2*as.numeric(crossprod(jx_f$res, jx_f$jacobian))
         }
         names(gr)=nm_par
         obj2kvh(gr, "gradient vector", fkvh)
      }
      colnames(jx_f$udr_dp)=nm_par
      if (wkvh) obj2kvh(jx_f$udr_dp, "jacobian dr_dp (without 1/sd_exp)", fkvh)
      # generalized inverse of non reduced jacobian
      if (length(jx_f$udr_dp) > 0L && wkvh) {
         svj=svd(jx_f$udr_dp)
         svj$d=with(svj, ifelse(d >= d[1L]*tol, d, d[1L]*tol))
         invj=svj$v%*%(t(svj$u)/svj$d)
         dimnames(invj)=rev(dimnames(jx_f$udr_dp))
         obj2kvh(invj, "generalized inverse of jacobian dr_dp (without 1/sd_exp)", fkvh)
      }
   }

   labargs$getx=TRUE
   labargs$labargs2$getx=TRUE
   if (fullsys) {
   
#browser()
      nm_xif=c()
      # full label input is the same for all experiments
      xif=rep(list(c()), nb_exp)
      xif=lapply(xif, setNames, nm_xif)
      if (case_i) {
         # prepare xif from funlab
         xilf=vector("list", nb_exp)
         xi2f=vector("list", nb_exp)
         for (iexp in seq(nb_exp)) {
            fli=funlabli[[iexp]]
            if (length(fli) == 0) {
               # replicate first column in xi as many times as there are time points
               if (time_order == "2" || time_order == "1,2")
                  xi2f[[iexp]]=matrix(xif[[iexp]], nrow=length(xif[[iexp]]), ncol=nb_tifu2[[iexp]])
               xilf[[iexp]]=matrix(xif[[iexp]], nrow=length(xif[[iexp]]), ncol=nb_tifu[[iexp]])
            }  else {
               # use funlab
               xilf[[iexp]]=funlab(tifull[[iexp]], nm_xif, fli, envfunlab, emu=FALSE, nm_exp[[iexp]], fcerr)
               if (time_order == "2" || time_order == "1,2")
                  xi2f[[iexp]]=funlab(tifull2[[iexp]], nm_xif, fli, envfunlab, emu=FALSE, nm_exp[[iexp]], fcerr)
            }
         }
#browser()
         xif=xilf
         if (time_order == "2" || time_order == "1,2")
            labargs$labargs2$xif=xi2f
      }
      labargs$nm_list$xif=nm_xif
      labargs$nm_list$inp=nm_xif
      labargs$xif=xif
      labargs$nb_f$xif=length(xif[[1L]])
      labargs$labargs2$nm_list$xif=nm_xif
      labargs$labargs2$nm_list$inp=nm_xif
      labargs$labargs2$nb_f$xif=length(xif[[1L]])
      if (case_i && !is.null(labargs$cl)) {
         clusterExport(labargs$cl, c("labargs"))
         clusterEvalQ(labargs$cl, {
            labargs$spa=sparse2spa(labargs$spa)
            labargs$labargs2$spa=labargs$spa
            labargs$spaf=sparse2spa(labargs$spaf)
            labargs$labargs2$spaf=labargs$spaf
#print(c(lab_new="", labargs=labargs, labargs2=labargs$labargs2, a1_1=labargs$spaf[[1]]$a, a1_2=labargs$labargs2spaf[[1]]$a))
         })
      }
#browser()
      v=lab_sim(param, cjac=FALSE, labargs, fullsys)
      if (identical(v$err, 1L)) {
         #save(v$fA$triplet(), file="singular237_triplet.RData")
         stop_mes("fullsys: weight=", v$iw, "; ", v$mes, file=fcerr)
      }
#browser()
      labargs$nm_list$inp=nm_inp
      if (time_order == "2" || time_order == "1,2") {
         labargs$labargs2$nm_list$inp=nm_inp
      }
      x=if (case_i) v$xf else v$x
   } else {
      v=lab_sim(param, cjac=FALSE, labargs)
      x=if (case_i) v$xf else v$x
   }

   mid=cumo2mass(x)
   if (case_i) {
      mid=lapply(mid, function(m) m[sort(rownames(m)),,drop=FALSE])
   } else if (length(mid)) {
      mid=mid[sort(rownames(mid)),,drop=FALSE]
   }
   # write some info in result kvh
   if (write_res && wkvh) {
      obj2kvh(mid, "MID vector", fkvh)
      
      # constrained fluxes to kvh
      obj2kvh(fallnx[nm_fc], "constrained net-xch01 fluxes", fkvh)
   }
   fwrv=v$lf$fwrv
   fallnx=v$lf$fallnx
   flnx=v$lf$flnx
   fgr=fallnx[nm_fgr]

   # keep last jx_f in jx_f_last
#browser()
   while (sensitive=="mc" && !all(is.na(param))) {
      if (TIMEIT) {
         cat("monte-ca: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      if (set_seed) {
         set.seed(seed)
      }
      # reference simulation corresponding to the final param
      refsim=new.env()
      for (nm_it in c("simlab", "simfmn", "simpool", "usm")) {
         assign(nm_it, jx_f[[nm_it]], envir=refsim)
      }
      # Monte-Carlo simulation in parallel way (if asked and possible)
      if (np > 1L && !parR) {
         inmc=seq_len(nmc)
         #spli=splitIndices(nmc, nodes);
         spli=suppressWarnings(split(inmc, seq_len(np)))
         ii=inmc
         ii[unlist(spli)]=inmc # inverse the counting in spli
         clusterExport(cl, c("param", "refsim", "runsuf", "cl_worker", "mc_sim")) #, "spli"))
         ##clusterEvalQ(cl, labargs$spa[[1]]$a <- NULL) # to rebuild sparse matrices on cores ## now, they are build once, at the cluster init
         cl_res=clusterEvalQ(cl, {mc_iter=TRUE; labargs$getx=FALSE;})
         mc_res=parLapply(cl, spli, function(iv) lapply(iv, function(i) cl_worker(funth=mc_sim, argth=list(i))))
         mc_res=Reduce(c, mc_res, NULL)[ii]
         #mc_res=vector(nmc, mode="list")
         #for (i in seq(nodes))
         #   mc_res[spli[[i]]]=cl_res[[i]]
         #mc_res=parLapplyLB(cl, seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      } else {
         mc_res=lapply(seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      }
#browser()
      free_mc=sapply(mc_res, function(l) {if (class(l)=="character" || is.null(l) || is.na(l$cost) || l$err) { ret=rep(NA, nb_param+3) } else { ret=c(cost=l$cost, it=l$it, normp=l$normp, l$par) }; ret })
      if (length(free_mc)==0) {
         cat("***Warning: parallel exectution of Monte-Carlo simulations has failed.", "\n", sep="", file=fclog)
         free_mc=matrix(NA, nb_param+2, 0)
      }
      cost_mc=free_mc[1,]
      nmc_real=nmc-sum(is.na(free_mc[4,]))
      # remove failed m-c iterations
      ifa=which(is.na(free_mc[1,]))
      if (length(ifa)) {
         if (ncol(free_mc) > length(ifa)) {
            cat("***Warning: some Monte-Carlo iterations failed.", "\n", sep="", file=fclog)
         } else {
            cat("All Monter-Carlo samples failed.", "\n", sep="", file=fcerr)
            retcode[irun]=1
            break
         }
         free_mc=free_mc[,-ifa,drop=FALSE]
         cost_mc=cost_mc[-ifa]
      }
      if (nmc_real <= 1) {
         cat("No sufficient Monter-Carlo samples were successfully calculated to do any statistics.", "\n", sep="", file=fcerr)
         retcode[irun]=1
         break
      }
#browser()
      fallnx_mc=apply(free_mc[-(1L:3L),,drop=FALSE], 2, function(p)param2fl(p, labargs)$fallnx)
      if (length(fallnx_mc)) {
         # mean
         fallnx_mc_mean=rowMeans(fallnx_mc)
         # median
         fallnx_mc_median=apply(fallnx_mc, 1, median)
         # confidence intervals
         cinx_mc=t(apply(fallnx_mc, 1, quantile, probs=c(0.025, 0.975)))
         cinx_mc=cbind(cinx_mc, "CI 95% length"=c(diff(t(cinx_mc))))
         cinx_mc=cbind(cinx_mc, "relative CI (%)"=cinx_mc[,3]*100/abs(fallnx_mc_mean))
      }

      if (write_res && wkvh) {
         cat("monte-carlo\n", file=fkvh)
         indent=1
         obj2kvh(cl_type, "cluster type", fkvh, indent)
         obj2kvh(avaco, "detected cores", fkvh, indent)
         avaco=max(1, avaco, na.rm=TRUE)
         obj2kvh(min(avaco, np, na.rm=TRUE), "used cores", fkvh, indent)
         cat("\tfitting samples\n", file=fkvh)
         indent=2
         obj2kvh(nmc, "requested number", fkvh, indent)
         obj2kvh(nmc_real, "calculated number", fkvh, indent)
         obj2kvh(nmc-nmc_real, "failed to calculate", fkvh, indent)
         # convergence section in kvh
         indent=1
         mout=rbind(round(free_mc[1:2,,drop=FALSE], 2),
            format(free_mc[3,,drop=FALSE], di=2, sci=TRUE))
         dimnames(mout)=list(c("cost", "it.numb", "normp"), seq_len(ncol(free_mc)))
         obj2kvh(mout, "convergence per sample", fkvh, indent)
      }
      free_mc=free_mc[-(1L:3L),,drop=FALSE]
      rownames(free_mc)=nm_par

      # param stats
      # mean
      parmean=rowMeans(free_mc)
      # median
      parmed=apply(free_mc, 1, median)

      # cost section in kvh
      if (write_res && wkvh) {
         cat("\tcost\n", file=fkvh)
         indent=2
         obj2kvh(mean(cost_mc), "mean", fkvh, indent)
         obj2kvh(median(cost_mc), "median", fkvh, indent)
         obj2kvh(sd(cost_mc), "sd", fkvh, indent)
         obj2kvh(sd(cost_mc)*100/mean(cost_mc), "rsd (%)", fkvh, indent)
         obj2kvh(quantile(cost_mc, c(0.025, 0.95, 0.975)), "ci", fkvh, indent)
         
         # free parameters section in kvh
         cat("\tStatistics\n", file=fkvh)
         mout=c()
         indent=2
#browser()
         # covariance matrix
         covmc=cov(t(free_mc))
         obj2kvh(covmc, "covariance", fkvh, indent)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(free_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI length")
         mout=cbind(mout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
         obj2kvh(mout, "free parameters", fkvh, indent)

         # net-xch01 stats
         fallnx=param2fl(param, labargs)$fallnx
         if (length(fallnx_mc)) {
            dimnames(fallnx_mc)[[1]]=nm_fallnx
            # form a matrix output
            fallout=matrix(0, nrow=nrow(fallnx_mc), ncol=0)
            # covariance matrix
            covmc=cov(t(fallnx_mc))
            dimnames(covmc)=list(nm_fallnx, nm_fallnx)
            # sd
            sdmc=sqrt(diag(covmc))
            fallout=cbind(fallout, mean=fallnx_mc_mean, median=fallnx_mc_median, sd=sdmc,
               "rsd (%)"=sdmc*100/abs(fallnx_mc_mean), cinx_mc)
            o=order(nm_fallnx)
            obj2kvh(fallout[o,,drop=FALSE], "all net-xch01 fluxes", fkvh, indent)
            obj2kvh(covmc[o,o], "covariance of all net-xch01 fluxes", fkvh, indent)

            # fwd-rev stats
            fwrv_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fwrv)
            dimnames(fwrv_mc)[[1]]=nm_fwrv
            fallout=matrix(0, nrow=nrow(fwrv_mc), ncol=0)
            # mean
            parmean=apply(fwrv_mc, 1, mean)
            # median
            parmed=apply(fwrv_mc, 1, median)
            # covariance matrix
            covmc=cov(t(fwrv_mc))
            dimnames(covmc)=list(nm_fwrv, nm_fwrv)
            # sd
            sdmc=sqrt(diag(covmc))
            # confidence intervals
            cif_mc=t(apply(fwrv_mc, 1, quantile, probs=c(0.025, 0.975)))
            cif_mc=cbind(cif_mc, t(diff(t(cif_mc))))
            cif_mc=cbind(cif_mc, cif_mc[,3]*100/abs(fwrv))
            dimnames(cif_mc)[[2]]=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
            fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
               "rsd (%)"=sdmc*100/abs(parmean), cif_mc)
            o=order(nm_fwrv)
            obj2kvh(fallout[o,,drop=FALSE], "forward-reverse fluxes", fkvh, indent)
            obj2kvh(covmc[o,o], "covariance of forward-reverse fluxes", fkvh, indent)
         }
      }
      break
   }
#browser()
   if (length(sensitive) && nchar(sensitive) && sensitive != "mc") {
      cat(paste("Unknown sensitivity '", sensitive, "' method chosen.", sep=""), "\n", sep="", file=fcerr)
      retcode[irun]=1
   }

   if (TIMEIT) {
      cat("linstats: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # Linear method based on jacobian x_f
   # reset fluxes and jacobians according to param
   if (is.null(jx_f$jacobian)) {
      if (write_res) {
         capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      } else {
         rres <- lab_resid(param, cjac=TRUE, labargs)
      }
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         #if (write_res && wkvh)
         #   close(fkvh)
         retcode[irun]=rres$err
         next
      }
   } # else use the last calculated jacobian
browser()
   # covariance matrix of free fluxes
   if (length(jx_f$jacobian) > 0L && !all(is.na(param))) {
      svj=svd(jx_f$jacobian)
      if (svj$d[1] == 0.) {
         i=rep(TRUE, length(svj$d))
      } else {
         i=svj$d/svj$d[1]<tol
         if (all(!i) && svj$d[1]<tol) {
            # we could not find very small d, take just the last
            i[length(i)]=TRUE
         }
      }
      ibad=apply(svj$v[, i, drop=FALSE], 2, which.contrib)
      ibad=unique(unlist(ibad))
      if (length(ibad) > 0) {
         cat(paste(if (nchar(runsuf)) runsuf%s+%": " else "", "***Warning: inverse of covariance matrix is numerically singular.\nStatistically undefined parameter(s) seems to be:\n",
            paste(sort(nm_par[ibad]), collapse="\n"), "\nFor a more complete list, see SD column in '.tvar.sim' result file.", sep=""), "\n", sep="", file=fclog)
      }
      # "square root" of covariance matrix (to preserve numerical positive definitness)
      svj$d=with(svj, ifelse(d >= d[1L]*tol, d, d[1L]*tol))
      rtcov=(svj$u)%*%(t(svj$v)/svj$d)
      # standard deviations of free fluxes
      if (write_res) {
         if (wkvh) cat("linear stats\n", file=fkvh)

         # sd free+dependent+growth net-xch01 fluxes
         nm_flfd=c(nm_ff, nm_fgr, nm_fl)
         if (nb_ff > 0 || nb_fgr > 0) {
            i=1:nb_param
            i=c(head(i, nb_ff), tail(i, nb_fgr))
            covfl=crossprod(rtcov[, i, drop=FALSE]%mmt%(rbind(diag(nb_ff+nb_fgr), dfl_dffg)%mrv%c(rep.int(1., nb_ff), fgr)))
            dimnames(covfl)=list(nm_flfd, nm_flfd)
            sdfl=sqrt(diag(covfl))
         } else {
            sdfl=rep(0., nb_fl)
            covfl=matrix(0., nb_fl, nb_fl)
         }
         fl=c(head(param, nb_ff), fgr, flnx)
         stats_nx=cbind("value"=fl, "sd"=sdfl, "rsd"=sdfl/abs(fl))
         rownames(stats_nx)=nm_flfd
         if (wkvh) {
            o=order(nm_flfd)
            obj2kvh(stats_nx[o,,drop=FALSE], "net-xch01 fluxes (sorted by name)", fkvh, indent=1)
            obj2kvh(covfl[o, o], "covariance net-xch01 fluxes", fkvh, indent=1)
         }
         
         # flux, pool --> .tvar
#browser()
         rnm=grep("_gr$", nm_fallnx, invert=TRUE, value=TRUE)
         cnm=c("Id", "Comment", "Name", "Kind", "Type", "Value", "SD", "Struct_identif")
         if (sensitive == "mc") {
            cnm=c(cnm, "Low_mc", "Up_mc")
         }
         nx2suf=c(n="NET", x="XCH")
         fd2cap=c(f="F", d="D", c="C")

         mnm=matrix(unlist(strsplitlim(rnm, ".", fixed=TRUE, lim=3L)), ncol=3L, byrow=TRUE)
         o=natorder(mnm[, 3L])
         rnm=rnm[o]
         mnm=mnm[o,,drop=FALSE]
         vfl=fallnx[rnm]
         vfl=ifelse(mnm[,2L] == "x", clamp(vfl, 0, 1), vfl)
         vsd=sdfl[rnm]
         vsd[is.na(vsd)]=0.
         df=cbind("", "", mnm[, 3L], nx2suf[mnm[, 2L]], fd2cap[mnm[, 1L]], vfl, vsd, ifelse(vsd > 10000, "no", "yes"))
         if (sensitive == "mc") {
            df=cbind(df, cinx_mc[rnm, 1L:2L])
         }

         # sd of all fwd-rev
         if (nb_ff > 0 || nb_fgr > 0) {
            i=1:nb_param
            i=c(head(i, nb_ff), tail(i, nb_fgr))
            covf=crossprod(tcrossprod_simple_triplet_matrix(rtcov[,i, drop=FALSE], jx_f$df_dffp%mrv%c(rep.int(1., nb_ff), head(poolall[nm_poolf], nb_fgr))))
            dimnames(covf)=list(nm_fwrv, nm_fwrv)
            sdf=sqrt(diag(covf))
         } else {
            sdf=rep(0., length(fwrv))
         }
         if (wkvh) {
            mtmp=cbind(fwrv, sdf, sdf/abs(fwrv))
            dimnames(mtmp)[[2]]=c("value", "sd", "rsd")
            o=order(nm_fwrv)
            obj2kvh(mtmp[o,], "fwd-rev fluxes (sorted by name)", fkvh, indent=1)
            if (nb_ff > 0 || nb_fgr > 0) {
               obj2kvh(covf, "covariance fwd-rev fluxes", fkvh, indent=1)
            }
         }
         # pool -> kvh
         sdpf=poolall
         sdpf[]=0.

         if (nb_poolf > 0) {
            # covariance matrix of free pools
            # "square root" of covariance matrix (to preserve numerical positive definitness)
            poolall[nm_poolf]=param[nm_poolf]
            # cov poolf
            covpf=crossprod(rtcov[,nb_ff+nb_sc_tot+seq_len(nb_poolf), drop=FALSE])
            dimnames(covpf)=list(nm_poolf, nm_poolf)
            sdpf[nm_poolf]=sqrt(diag(covpf))
         }
         if (length(poolall) > 0) {
            if (wkvh) {
               mtmp=cbind("value"=poolall, "sd"=sdpf, "rsd"=sdpf/poolall)
               rownames(mtmp)=nm_poolall
               o=order(nm_poolall)
               obj2kvh(mtmp[o,,drop=FALSE], "metabolite pools (sorted by name)", fkvh, indent=1)
               if (nb_poolf > 0) {
                  o=order(nm_poolf)
                  obj2kvh(covpf[o, o], "covariance free pools", fkvh, indent=1)
               }
            }
            rnm=names(poolall)
            mnm=matrix(unlist(strsplitlim(rnm, ":", fixed=TRUE, lim=2L)), ncol=2L, byrow=TRUE)
            o=natorder(mnm[, 2L])
            rnm=rnm[o]
            mnm=mnm[o,,drop=FALSE]
            pfc2cap=c(pf="F", pc="C")
            vsd=sdpf[rnm]
            vsd[is.na(vsd)]=0.
            dfp=cbind("", "", mnm[, 2L], "METAB", pfc2cap[mnm[,1L]], poolall[rnm], vsd, ifelse(vsd >= 10000., "no", "yes"))
            if (sensitive == "mc") {
               mci=ci_mc[nm_poolf, 1L:2L]
               mci=rbind(mci, cbind(poolall[nm_poolc], poolall[nm_poolc]))
               dfp=cbind(dfp, mci[rnm,])
            }
            df=rbind(df, dfp)
         }
         colnames(df)=cnm
         write.table(df, sep="	", quote=FALSE, row.names=FALSE, file=file.path(dirres, paste0(baseshort, runsuf, ".tvar.sim")))
      }
   }

   # chi2 test for goodness of fit
   # goodness of fit (chi2 test)
   if (length(jx_f$res)) {
      if (is.na(rcost)) {
         cat(sprintf("***Warning: chi2: Reduced cost value is NA. Chi2 test cannot be done.\n"), sep="", file=fclog)
      } else {
         nvres=sum(!is.na(jx_f$res))
         if (nvres > nb_param) {
            chi2test=list("chi2 value"=rcost, "data points"=nvres,
               "fitted parameters"=nb_param, "degrees of freedom"=nvres-nb_param)
            chi2test$`chi2 reduced value`=chi2test$`chi2 value`/chi2test$`degrees of freedom`
            chi2test$`p-value, i.e. P(X^2<=value)`=pchisq(chi2test$`chi2 value`, df=chi2test$`degrees of freedom`)
            chi2test$conclusion=if (chi2test$`p-value, i.e. P(X^2<=value)` > 0.95) "At level of 95% confidence, the model does not fit the data good enough with respect to the provided measurement SD" else "At level of 95% confidence, the model fits the data good enough with respect to the provided measurement SD"
            if (write_res) {
               if (wkvh) obj2kvh(chi2test, "goodness of fit (chi2 test)", fkvh, indent=1)
               fstat=file(file.path(dirres, sprintf("%s%s.stat", baseshort,  runsuf)), "w")
               df=c(rcost, rcost/(nvres-nb_param), nvres, nb_param, nvres-nb_param, chi2test$`p-value, i.e. P(X^2<=value)`, chi2test$conclusion)
               names(df)=c("chi2_value", "chi2/df", "number_of_measurements", "number_of_parameters", "degrees_of_freedom", "p-value", "conclusion")
               write.table(df, sep="	", quote=FALSE, row.names=TRUE, file=fstat, col.names=FALSE)
               close(fstat)
            }
         } else {
            cat(sprintf("***Warning: chi2: Measurement number %d is lower or equal to parameter number %d. Chi2 test cannot be done.\n", nvres, nb_param), sep="", file=fclog)
         }
      }
   }
   if (prof) {
      Rprof(NULL)
   }
   if (write_res) {
      if (wkvh) close(fkvh)
      # write edge.netflux property
      fedge=file(file.path(dirres, "tmp", sprintf("edge.netflux.%s%s.attrs", baseshort,  runsuf)), "w")
      cat("netflux (class=Double)\n", sep="", file=fedge)
      nm_edge=names(edge2fl)
      cat(paste(nm_edge, fallnx[edge2fl], sep=" = "), sep="\n" , file=fedge)
      close(fedge)

      # write edge.xchflux property
      fedge=file(file.path(dirres, "tmp",  sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
      flxch=paste(".x", substring(edge2fl, 4), sep="")
      ifl=charmatch(flxch, substring(names(fallnx), 2))
      cat("xchflux (class=Double)\n", sep="", file=fedge)
      cat(paste(nm_edge, fallnx[ifl], sep=" = "), sep="\n" , file=fedge)
      close(fedge)

      # write node.log2pool property
      if (length(poolall)> 0) {
         fnode=file(file.path(dirres, "tmp", sprintf("node.log2pool.%s%s.attrs", baseshort,  runsuf)), "w")
         cat("log2pool (class=Double)\n", sep="", file=fnode)
         nm_node=substring(names(poolall), 4)
         cat(paste(nm_node, log2(poolall), sep=" = "), sep="\n" , file=fnode)
         close(fnode)
      }
   }
}
#browser()
if (!is.null(cl)) {
   stopCluster(cl)
   labargs$cl=cl=NULL
}

if (write_res) {
   pres=rbind(cost=costres, pres)
   fco=file(file.path(dirres, "tmp", sprintf("%s.pres.csv", baseshort)), open="w")
   cat("row_col	", file=fco)
   write.table(file=fco, pres, row.n=T, quot=F, sep="\t")
   close(fco)
}
if (TIMEIT) {
   cat("rend    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# source files from FTBL/posttreat_R
postlist=strsplit("plot_smeas.R", " *; *")[[1]]
for (post in postlist) {
   fpostR=file.path(dirw, post)
   if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
      source(fpostR)
   } else {
      # not found in 'dirw', try 'dirr'
      fpostR=file.path(dirr, post)
      if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
         source(fpostR)
      } else {
         cat(sprintf("***Warning: posttreatment R file '%s' does not exist in working directory neither in influx_si one. Ignored.\n", post), file=fclog)
      }
   }
}
xgc=gc(verbose=FALSE) # to avoid the message "Error in (function (x)  : tentative d'appliquer un objet qui n'est pas une fonction"
if (write_res) {
   close(fclog)
   close(fcerr)
}
retcode=max(retcode)
if (!interactive() && format(parent.frame()) == format(.GlobalEnv))
   q("no", status=retcode)
