// g2o - General Graph Optimization
// Copyright (C) 2011 R. Kuemmerle, G. Grisetti, W. Burgard
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright notice,
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
// IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef G2O_DATA_QUEUE_H
#define G2O_DATA_QUEUE_H

#include <map>
#include <memory>

#include "g2o_types_data_api.h"

namespace g2o {

class RobotData;

/**
 * \brief a simple queue to store data and retrieve based on a timestamp
 */
class G2O_TYPES_DATA_API DataQueue {
 public:
  using RobotDataPtr = std::shared_ptr<RobotData>;
  using Buffer = std::map<double, RobotDataPtr>;

  void add(RobotDataPtr rd);

  [[nodiscard]] RobotDataPtr findClosestData(double timestamp) const;

  [[nodiscard]] RobotDataPtr before(double timestamp) const;
  [[nodiscard]] RobotDataPtr after(double timestamp) const;

  [[nodiscard]] const Buffer& buffer() const { return buffer_; }

 protected:
  Buffer buffer_;
};

}  // namespace g2o

#endif
