import numpy as np
from typing import Tuple

Image = np.ndarray
Spacing = Tuple[float, ...]

class Transform:
    def __call__(self, image: Image, spacing: Spacing): ...
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

class RotateCTTransform(Transform): ...
class RotateCTTransformType0(RotateCTTransform): ...

class RotateCTTransformType1(RotateCTTransform):
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

class RotateCTTransformType2(RotateCTTransform):
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

class RotateCTTransformType3(RotateCTTransform):
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

class RotateCTTransformType4(RotateCTTransform):
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

class RotateCTTransformType5(RotateCTTransform):
    def transform_image(self, image: Image): ...
    def transform_spacing(self, spacing: Spacing): ...

def rotate_ct_transform(image: Image, spacing: Spacing, transform_type: str): ...
def clean_ct_image(image: Image): ...
def process_ct_image(series_id: str, image: Image, spacing: Spacing): ...
