# -*- coding: utf-8 -*-
"""Untitled6.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1REgC3j4JorzY5Gt08YIEvvBZ0Jt0lw0F
"""

import tensorflow as tf

def adaptive_linear_quadratic_rrelu(x, adapt_factor):
    """Experimental Adaptive Linear-Quadratic RReLU activation function."""
    def true_fn(x):
        return x

    def false_fn(x):
        a = tf.random.uniform(shape=tf.shape(x), minval=0.01, maxval=adapt_factor)
        return a * x

    quadratic_values = x ** 2
    return tf.where(tf.greater(x, 0.5), quadratic_values, false_fn(x))

