# generated by datamodel-codegen:
#   filename:  9dhlq8qwlnfi9dc1yb91lz2k65827q5i-sarif-schema-2.1.0.json

from __future__ import annotations

from enum import Enum

from pydantic import (
    AnyUrl,
    AwareDatetime,
    BaseModel,
    ConfigDict,
    Field,
    RootModel,
    confloat,
    conint,
    constr,
)


class Version(Enum):
    FIELD_2_1_0 = "2.1.0"


class Role(Enum):
    ANALYSIS_TARGET = "analysisTarget"
    ATTACHMENT = "attachment"
    RESPONSE_FILE = "responseFile"
    RESULT_FILE = "resultFile"
    STANDARD_STREAM = "standardStream"
    TRACED_FILE = "tracedFile"
    UNMODIFIED = "unmodified"
    MODIFIED = "modified"
    ADDED = "added"
    DELETED = "deleted"
    RENAMED = "renamed"
    UNCONTROLLED = "uncontrolled"
    DRIVER = "driver"
    EXTENSION = "extension"
    TRANSLATION = "translation"
    TAXONOMY = "taxonomy"
    POLICY = "policy"
    REFERENCED_ON_COMMAND_LINE = "referencedOnCommandLine"
    MEMORY_CONTENTS = "memoryContents"
    DIRECTORY = "directory"
    USER_SPECIFIED_CONFIGURATION = "userSpecifiedConfiguration"
    TOOL_SPECIFIED_CONFIGURATION = "toolSpecifiedConfiguration"
    DEBUG_OUTPUT_FILE = "debugOutputFile"


class Level(Enum):
    NONE = "none"
    NOTE = "note"
    WARNING = "warning"
    ERROR = "error"


class PropertyBag(BaseModel):
    model_config = ConfigDict(
        extra="allow",
        populate_by_name=True,
    )
    tags: list[str] | None = Field(
        default=[],
        description="A set of distinct strings that provide additional information.",
        min_length=0,
    )


class DeprecatedGuid(
    RootModel[
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: constr(
        pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
    )


class ReportingConfiguration(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    enabled: bool | None = Field(
        default=True,
        description="Specifies whether the report may be produced during the scan.",
    )
    level: Level | None = Field(
        default="warning", description="Specifies the failure level for the report."
    )
    rank: confloat(ge=-1.0, le=100.0) | None = Field(
        default=-1.0,
        description="Specifies the relative priority of the report. Used for analysis output only.",
    )
    parameters: PropertyBag | None = Field(
        default=None,
        description="Contains configuration information specific to a report.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the reporting configuration.",
    )


class Kind(Enum):
    NOT_APPLICABLE = "notApplicable"
    PASS_ = "pass"
    FAIL = "fail"
    REVIEW = "review"
    OPEN = "open"
    INFORMATIONAL = "informational"


class BaselineState(Enum):
    NEW = "new"
    UNCHANGED = "unchanged"
    UPDATED = "updated"
    ABSENT = "absent"


class ColumnKind(Enum):
    UTF16_CODE_UNITS = "utf16CodeUnits"
    UNICODE_CODE_POINTS = "unicodeCodePoints"


class Kind1(Enum):
    IN_SOURCE = "inSource"
    EXTERNAL = "external"


class State(Enum):
    ACCEPTED = "accepted"
    UNDER_REVIEW = "underReview"
    REJECTED = "rejected"


class Importance(Enum):
    IMPORTANT = "important"
    ESSENTIAL = "essential"
    UNIMPORTANT = "unimportant"


class Content(Enum):
    LOCALIZED_DATA = "localizedData"
    NON_LOCALIZED_DATA = "nonLocalizedData"


class ToolComponentReference(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    name: str | None = Field(
        default=None, description="The 'name' property of the referenced toolComponent."
    )
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="An index into the referenced toolComponent in tool.extensions.",
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None, description="The 'guid' property of the referenced toolComponent."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the toolComponentReference.",
    )


class Address(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    absolute_address: conint(ge=-1) | None = Field(
        default=-1,
        alias="absoluteAddress",
        description="The address expressed as a byte offset from the start of the addressable region.",
    )
    relative_address: int | None = Field(
        default=None,
        alias="relativeAddress",
        description="The address expressed as a byte offset from the absolute address of the top-most parent object.",
    )
    length: int | None = Field(
        default=None, description="The number of bytes in this range of addresses."
    )
    kind: str | None = Field(
        default=None,
        description="An open-ended string that identifies the address kind. 'data', 'function', 'header','instruction', 'module', 'page', 'section', 'segment', 'stack', 'stackFrame', 'table' are well-known values.",
    )
    name: str | None = Field(
        default=None,
        description="A name that is associated with the address, e.g., '.text'.",
    )
    fully_qualified_name: str | None = Field(
        default=None,
        alias="fullyQualifiedName",
        description="A human-readable fully qualified name that is associated with the address.",
    )
    offset_from_parent: int | None = Field(
        default=None,
        alias="offsetFromParent",
        description="The byte offset of this address from the absolute or relative address of the parent object.",
    )
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index within run.addresses of the cached object for this address.",
    )
    parent_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="parentIndex",
        description="The index within run.addresses of the parent object.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the address.",
    )


class LogicalLocation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    name: str | None = Field(
        default=None,
        description="Identifies the construct in which the result occurred. For example, this property might contain the name of a class or a method.",
    )
    index: conint(ge=-1) | None = Field(
        default=-1, description="The index within the logical locations array."
    )
    fully_qualified_name: str | None = Field(
        default=None,
        alias="fullyQualifiedName",
        description="The human-readable fully qualified name of the logical location.",
    )
    decorated_name: str | None = Field(
        default=None,
        alias="decoratedName",
        description="The machine-readable name for the logical location, such as a mangled function name provided by a C++ compiler that encodes calling convention, return type and other details along with the function name.",
    )
    parent_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="parentIndex",
        description="Identifies the index of the immediate parent of the construct in which the result was detected. For example, this property might point to a logical location that represents the namespace that holds a type.",
    )
    kind: str | None = Field(
        default=None,
        description="The type of construct this logical location component refers to. Should be one of 'function', 'member', 'module', 'namespace', 'parameter', 'resource', 'returnType', 'type', 'variable', 'object', 'array', 'property', 'value', 'element', 'text', 'attribute', 'comment', 'declaration', 'dtd' or 'processingInstruction', if any of those accurately describe the construct.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the logical location.",
    )


class Message1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    text: str = Field(..., description="A plain text message string.")
    markdown: str | None = Field(default=None, description="A Markdown message string.")
    id: str | None = Field(default=None, description="The identifier for this message.")
    arguments: list[str] | None = Field(
        default=[],
        description="An array of strings to substitute into the message string.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the message.",
    )


class Message2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    text: str | None = Field(default=None, description="A plain text message string.")
    markdown: str | None = Field(default=None, description="A Markdown message string.")
    id: str = Field(..., description="The identifier for this message.")
    arguments: list[str] | None = Field(
        default=[],
        description="An array of strings to substitute into the message string.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the message.",
    )


class Message(RootModel[Message1 | Message2]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Message1 | Message2 = Field(
        ..., description="Encapsulates a message intended to be read by the end user."
    )


class MultiformatMessageString(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    text: str = Field(..., description="A plain text message string or format string.")
    markdown: str | None = Field(
        default=None, description="A Markdown message string or format string."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the message.",
    )


class Rectangle(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    top: float | None = Field(
        default=None,
        description="The Y coordinate of the top edge of the rectangle, measured in the image's natural units.",
    )
    left: float | None = Field(
        default=None,
        description="The X coordinate of the left edge of the rectangle, measured in the image's natural units.",
    )
    bottom: float | None = Field(
        default=None,
        description="The Y coordinate of the bottom edge of the rectangle, measured in the image's natural units.",
    )
    right: float | None = Field(
        default=None,
        description="The X coordinate of the right edge of the rectangle, measured in the image's natural units.",
    )
    message: Message | None = Field(
        default=None, description="A message relevant to the rectangle."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the rectangle.",
    )


class ReportingDescriptorReference1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str | None = Field(default=None, description="The id of the descriptor.")
    index: conint(ge=-1) = Field(
        ...,
        description="The index into an array of descriptors in toolComponent.ruleDescriptors, toolComponent.notificationDescriptors, or toolComponent.taxonomyDescriptors, depending on context.",
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None, description="A guid that uniquely identifies the descriptor."
    )
    tool_component: ToolComponentReference | None = Field(
        default=None,
        alias="toolComponent",
        description="A reference used to locate the toolComponent associated with the descriptor.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the reporting descriptor reference.",
    )


class ReportingDescriptorReference2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str | None = Field(default=None, description="The id of the descriptor.")
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index into an array of descriptors in toolComponent.ruleDescriptors, toolComponent.notificationDescriptors, or toolComponent.taxonomyDescriptors, depending on context.",
    )
    guid: constr(
        pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
    ) = Field(..., description="A guid that uniquely identifies the descriptor.")
    tool_component: ToolComponentReference | None = Field(
        default=None,
        alias="toolComponent",
        description="A reference used to locate the toolComponent associated with the descriptor.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the reporting descriptor reference.",
    )


class ReportingDescriptorReference3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str = Field(..., description="The id of the descriptor.")
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index into an array of descriptors in toolComponent.ruleDescriptors, toolComponent.notificationDescriptors, or toolComponent.taxonomyDescriptors, depending on context.",
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None, description="A guid that uniquely identifies the descriptor."
    )
    tool_component: ToolComponentReference | None = Field(
        default=None,
        alias="toolComponent",
        description="A reference used to locate the toolComponent associated with the descriptor.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the reporting descriptor reference.",
    )


class ReportingDescriptorReference(
    RootModel[
        ReportingDescriptorReference1
        | ReportingDescriptorReference2
        | ReportingDescriptorReference3
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ReportingDescriptorReference1
        | ReportingDescriptorReference2
        | ReportingDescriptorReference3
    ) = Field(
        ...,
        description="Information about how to locate a relevant reporting descriptor.",
    )


class ReportingDescriptorRelationship(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    target: ReportingDescriptorReference = Field(
        ..., description="A reference to the related reporting descriptor."
    )
    kinds: list[str] | None = Field(
        default=["relevant"],
        description="A set of distinct strings that categorize the relationship. Well-known kinds include 'canPrecede', 'canFollow', 'willPrecede', 'willFollow', 'superset', 'subset', 'equal', 'disjoint', 'relevant', and 'incomparable'.",
    )
    description: Message | None = Field(
        default=None,
        description="A description of the reporting descriptor relationship.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the reporting descriptor reference.",
    )


class RunAutomationDetails(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    description: Message | None = Field(
        default=None,
        description="A description of the identity and role played within the engineering system by this object's containing run object.",
    )
    id: str | None = Field(
        default=None,
        description="A hierarchical string that uniquely identifies this object's containing run object.",
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A stable, unique identifer for this object's containing run object in the form of a GUID.",
    )
    correlation_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="correlationGuid",
        description="A stable, unique identifier for the equivalence class of runs to which this object's containing run object belongs in the form of a GUID.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the run automation details.",
    )


class TranslationMetadata(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    name: str = Field(
        ..., description="The name associated with the translation metadata."
    )
    full_name: str | None = Field(
        default=None,
        alias="fullName",
        description="The full name associated with the translation metadata.",
    )
    short_description: MultiformatMessageString | None = Field(
        default=None,
        alias="shortDescription",
        description="A brief description of the translation metadata.",
    )
    full_description: MultiformatMessageString | None = Field(
        default=None,
        alias="fullDescription",
        description="A comprehensive description of the translation metadata.",
    )
    download_uri: AnyUrl | None = Field(
        default=None,
        alias="downloadUri",
        description="The absolute URI from which the translation metadata can be downloaded.",
    )
    information_uri: AnyUrl | None = Field(
        default=None,
        alias="informationUri",
        description="The absolute URI from which information related to the translation metadata can be downloaded.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the translation metadata.",
    )


class ArtifactContent(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    text: str | None = Field(
        default=None, description="UTF-8-encoded content from a text artifact."
    )
    binary: str | None = Field(
        default=None,
        description="MIME Base64-encoded content from a binary artifact, or from a text artifact in its original encoding.",
    )
    rendered: MultiformatMessageString | None = Field(
        default=None,
        description="An alternate rendered representation of the artifact (e.g., a decompiled representation of a binary region).",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the artifact content.",
    )


class ArtifactLocation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    uri: str | None = Field(
        default=None,
        description="A string containing a valid relative or absolute URI.",
    )
    uri_base_id: str | None = Field(
        default=None,
        alias="uriBaseId",
        description='A string which indirectly specifies the absolute URI with respect to which a relative URI in the "uri" property is interpreted.',
    )
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index within the run artifacts array of the artifact object associated with the artifact location.",
    )
    description: Message | None = Field(
        default=None, description="A short description of the artifact location."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the artifact location.",
    )


class ConfigurationOverride(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    configuration: ReportingConfiguration = Field(
        ...,
        description="Specifies how the rule or notification was configured during the scan.",
    )
    descriptor: ReportingDescriptorReference = Field(
        ...,
        description="A reference used to locate the descriptor whose configuration was overridden.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the configuration override.",
    )


class Edge(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str = Field(
        ..., description="A string that uniquely identifies the edge within its graph."
    )
    label: Message | None = Field(
        default=None, description="A short description of the edge."
    )
    source_node_id: str = Field(
        ...,
        alias="sourceNodeId",
        description="Identifies the source node (the node at which the edge starts).",
    )
    target_node_id: str = Field(
        ...,
        alias="targetNodeId",
        description="Identifies the target node (the node at which the edge ends).",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the edge.",
    )


class EdgeTraversal(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    edge_id: str = Field(
        ..., alias="edgeId", description="Identifies the edge being traversed."
    )
    message: Message | None = Field(
        default=None,
        description="A message to display to the user as the edge is traversed.",
    )
    final_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="finalState",
        description="The values of relevant expressions after the edge has been traversed.",
    )
    step_over_edge_count: conint(ge=0) | None = Field(
        default=None,
        alias="stepOverEdgeCount",
        description="The number of edge traversals necessary to return from a nested graph.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the edge traversal.",
    )


class ExternalPropertyFileReference1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    location: ArtifactLocation = Field(
        ..., description="The location of the external property file."
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A stable, unique identifer for the external property file in the form of a GUID.",
    )
    item_count: conint(ge=-1) | None = Field(
        default=-1,
        alias="itemCount",
        description="A non-negative integer specifying the number of items contained in the external property file.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the external property file.",
    )


class ExternalPropertyFileReference2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    location: ArtifactLocation | None = Field(
        default=None, description="The location of the external property file."
    )
    guid: constr(
        pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
    ) = Field(
        ...,
        description="A stable, unique identifer for the external property file in the form of a GUID.",
    )
    item_count: conint(ge=-1) | None = Field(
        default=-1,
        alias="itemCount",
        description="A non-negative integer specifying the number of items contained in the external property file.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the external property file.",
    )


class ExternalPropertyFileReference(
    RootModel[ExternalPropertyFileReference1 | ExternalPropertyFileReference2]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ExternalPropertyFileReference1 | ExternalPropertyFileReference2 = Field(
        ...,
        description="Contains information that enables a SARIF consumer to locate the external property file that contains the value of an externalized property associated with the run.",
    )


class ExternalPropertyFileReferences(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    conversion: ExternalPropertyFileReference | None = Field(
        default=None,
        description="An external property file containing a run.conversion object to be merged with the root log file.",
    )
    graphs: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing a run.graphs object to be merged with the root log file.",
        min_length=0,
    )
    externalized_properties: ExternalPropertyFileReference | None = Field(
        default=None,
        alias="externalizedProperties",
        description="An external property file containing a run.properties object to be merged with the root log file.",
    )
    artifacts: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.artifacts arrays to be merged with the root log file.",
        min_length=0,
    )
    invocations: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.invocations arrays to be merged with the root log file.",
        min_length=0,
    )
    logical_locations: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        alias="logicalLocations",
        description="An array of external property files containing run.logicalLocations arrays to be merged with the root log file.",
        min_length=0,
    )
    thread_flow_locations: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        alias="threadFlowLocations",
        description="An array of external property files containing run.threadFlowLocations arrays to be merged with the root log file.",
        min_length=0,
    )
    results: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.results arrays to be merged with the root log file.",
        min_length=0,
    )
    taxonomies: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.taxonomies arrays to be merged with the root log file.",
        min_length=0,
    )
    addresses: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.addresses arrays to be merged with the root log file.",
        min_length=0,
    )
    driver: ExternalPropertyFileReference | None = Field(
        default=None,
        description="An external property file containing a run.driver object to be merged with the root log file.",
    )
    extensions: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.extensions arrays to be merged with the root log file.",
        min_length=0,
    )
    policies: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.policies arrays to be merged with the root log file.",
        min_length=0,
    )
    translations: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        description="An array of external property files containing run.translations arrays to be merged with the root log file.",
        min_length=0,
    )
    web_requests: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        alias="webRequests",
        description="An array of external property files containing run.requests arrays to be merged with the root log file.",
        min_length=0,
    )
    web_responses: list[ExternalPropertyFileReference] | None = Field(
        default=[],
        alias="webResponses",
        description="An array of external property files containing run.responses arrays to be merged with the root log file.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the external property files.",
    )


class GraphTraversal1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    run_graph_index: conint(ge=-1) = Field(
        ...,
        alias="runGraphIndex",
        description="The index within the run.graphs to be associated with the result.",
    )
    result_graph_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="resultGraphIndex",
        description="The index within the result.graphs to be associated with the result.",
    )
    description: Message | None = Field(
        default=None, description="A description of this graph traversal."
    )
    initial_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="initialState",
        description="Values of relevant expressions at the start of the graph traversal that may change during graph traversal.",
    )
    immutable_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="immutableState",
        description="Values of relevant expressions at the start of the graph traversal that remain constant for the graph traversal.",
    )
    edge_traversals: list[EdgeTraversal] | None = Field(
        default=[],
        alias="edgeTraversals",
        description="The sequences of edges traversed by this graph traversal.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the graph traversal.",
    )


class GraphTraversal2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    run_graph_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="runGraphIndex",
        description="The index within the run.graphs to be associated with the result.",
    )
    result_graph_index: conint(ge=-1) = Field(
        ...,
        alias="resultGraphIndex",
        description="The index within the result.graphs to be associated with the result.",
    )
    description: Message | None = Field(
        default=None, description="A description of this graph traversal."
    )
    initial_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="initialState",
        description="Values of relevant expressions at the start of the graph traversal that may change during graph traversal.",
    )
    immutable_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="immutableState",
        description="Values of relevant expressions at the start of the graph traversal that remain constant for the graph traversal.",
    )
    edge_traversals: list[EdgeTraversal] | None = Field(
        default=[],
        alias="edgeTraversals",
        description="The sequences of edges traversed by this graph traversal.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the graph traversal.",
    )


class GraphTraversal(RootModel[GraphTraversal1 | GraphTraversal2]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: GraphTraversal1 | GraphTraversal2 = Field(
        ..., description="Represents a path through a graph."
    )


class LocationRelationship(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    target: conint(ge=0) = Field(
        ..., description="A reference to the related location."
    )
    kinds: list[str] | None = Field(
        default=["relevant"],
        description="A set of distinct strings that categorize the relationship. Well-known kinds include 'includes', 'isIncludedBy' and 'relevant'.",
    )
    description: Message | None = Field(
        default=None, description="A description of the location relationship."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the location relationship.",
    )


class Region(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    start_line: conint(ge=1) | None = Field(
        default=None,
        alias="startLine",
        description="The line number of the first character in the region.",
    )
    start_column: conint(ge=1) | None = Field(
        default=None,
        alias="startColumn",
        description="The column number of the first character in the region.",
    )
    end_line: conint(ge=1) | None = Field(
        default=None,
        alias="endLine",
        description="The line number of the last character in the region.",
    )
    end_column: conint(ge=1) | None = Field(
        default=None,
        alias="endColumn",
        description="The column number of the character following the end of the region.",
    )
    char_offset: conint(ge=-1) | None = Field(
        default=-1,
        alias="charOffset",
        description="The zero-based offset from the beginning of the artifact of the first character in the region.",
    )
    char_length: conint(ge=0) | None = Field(
        default=None,
        alias="charLength",
        description="The length of the region in characters.",
    )
    byte_offset: conint(ge=-1) | None = Field(
        default=-1,
        alias="byteOffset",
        description="The zero-based offset from the beginning of the artifact of the first byte in the region.",
    )
    byte_length: conint(ge=0) | None = Field(
        default=None,
        alias="byteLength",
        description="The length of the region in bytes.",
    )
    snippet: ArtifactContent | None = Field(
        default=None,
        description="The portion of the artifact contents within the specified region.",
    )
    message: Message | None = Field(
        default=None, description="A message relevant to the region."
    )
    source_language: str | None = Field(
        default=None,
        alias="sourceLanguage",
        description="Specifies the source language, if any, of the portion of the artifact specified by the region object.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the region.",
    )


class Replacement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    deleted_region: Region = Field(
        ..., alias="deletedRegion", description="The region of the artifact to delete."
    )
    inserted_content: ArtifactContent | None = Field(
        default=None,
        alias="insertedContent",
        description="The content to insert at the location specified by the 'deletedRegion' property.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the replacement.",
    )


class ReportingDescriptor(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str = Field(..., description="A stable, opaque identifier for the report.")
    deprecated_ids: list[str] | None = Field(
        default=None,
        alias="deprecatedIds",
        description="An array of stable, opaque identifiers by which this report was known in some previous version of the analysis tool.",
        min_length=0,
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A unique identifer for the reporting descriptor in the form of a GUID.",
    )
    deprecated_guids: list[DeprecatedGuid] | None = Field(
        default=None,
        alias="deprecatedGuids",
        description="An array of unique identifies in the form of a GUID by which this report was known in some previous version of the analysis tool.",
        min_length=0,
    )
    name: str | None = Field(
        default=None,
        description="A report identifier that is understandable to an end user.",
    )
    deprecated_names: list[str] | None = Field(
        default=None,
        alias="deprecatedNames",
        description="An array of readable identifiers by which this report was known in some previous version of the analysis tool.",
        min_length=0,
    )
    short_description: MultiformatMessageString | None = Field(
        default=None,
        alias="shortDescription",
        description="A concise description of the report. Should be a single sentence that is understandable when visible space is limited to a single line of text.",
    )
    full_description: MultiformatMessageString | None = Field(
        default=None,
        alias="fullDescription",
        description="A description of the report. Should, as far as possible, provide details sufficient to enable resolution of any problem indicated by the result.",
    )
    message_strings: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="messageStrings",
        description="A set of name/value pairs with arbitrary names. Each value is a multiformatMessageString object, which holds message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can be used to construct a message in combination with an arbitrary number of additional string arguments.",
    )
    default_configuration: ReportingConfiguration | None = Field(
        default=None,
        alias="defaultConfiguration",
        description="Default reporting configuration information.",
    )
    help_uri: AnyUrl | None = Field(
        default=None,
        alias="helpUri",
        description="A URI where the primary documentation for the report can be found.",
    )
    help: MultiformatMessageString | None = Field(
        default=None,
        description="Provides the primary documentation for the report, useful when there is no online documentation.",
    )
    relationships: list[ReportingDescriptorRelationship] | None = Field(
        default=[],
        description="An array of objects that describe relationships between this reporting descriptor and others.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the report.",
    )


class SpecialLocations(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    display_base: ArtifactLocation | None = Field(
        default=None,
        alias="displayBase",
        description="Provides a suggestion to SARIF consumers to display file paths relative to the specified location.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the special locations.",
    )


class ToolComponent(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A unique identifer for the tool component in the form of a GUID.",
    )
    name: str = Field(..., description="The name of the tool component.")
    organization: str | None = Field(
        default=None,
        description="The organization or company that produced the tool component.",
    )
    product: str | None = Field(
        default=None, description="A product suite to which the tool component belongs."
    )
    product_suite: str | None = Field(
        default=None,
        alias="productSuite",
        description="A localizable string containing the name of the suite of products to which the tool component belongs.",
    )
    short_description: MultiformatMessageString | None = Field(
        default=None,
        alias="shortDescription",
        description="A brief description of the tool component.",
    )
    full_description: MultiformatMessageString | None = Field(
        default=None,
        alias="fullDescription",
        description="A comprehensive description of the tool component.",
    )
    full_name: str | None = Field(
        default=None,
        alias="fullName",
        description="The name of the tool component along with its version and any other useful identifying information, such as its locale.",
    )
    version: str | None = Field(
        default=None,
        description="The tool component version, in whatever format the component natively provides.",
    )
    semantic_version: str | None = Field(
        default=None,
        alias="semanticVersion",
        description="The tool component version in the format specified by Semantic Versioning 2.0.",
    )
    dotted_quad_file_version: constr(pattern=r"[0-9]+(\.[0-9]+){3}") | None = Field(
        default=None,
        alias="dottedQuadFileVersion",
        description="The binary version of the tool component's primary executable file expressed as four non-negative integers separated by a period (for operating systems that express file versions in this way).",
    )
    release_date_utc: str | None = Field(
        default=None,
        alias="releaseDateUtc",
        description="A string specifying the UTC date (and optionally, the time) of the component's release.",
    )
    download_uri: AnyUrl | None = Field(
        default=None,
        alias="downloadUri",
        description="The absolute URI from which the tool component can be downloaded.",
    )
    information_uri: AnyUrl | None = Field(
        default=None,
        alias="informationUri",
        description="The absolute URI at which information about this version of the tool component can be found.",
    )
    global_message_strings: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="globalMessageStrings",
        description="A dictionary, each of whose keys is a resource identifier and each of whose values is a multiformatMessageString object, which holds message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can be used to construct a message in combination with an arbitrary number of additional string arguments.",
    )
    notifications: list[ReportingDescriptor] | None = Field(
        default=[],
        description="An array of reportingDescriptor objects relevant to the notifications related to the configuration and runtime execution of the tool component.",
        min_length=0,
    )
    rules: list[ReportingDescriptor] | None = Field(
        default=[],
        description="An array of reportingDescriptor objects relevant to the analysis performed by the tool component.",
        min_length=0,
    )
    taxa: list[ReportingDescriptor] | None = Field(
        default=[],
        description="An array of reportingDescriptor objects relevant to the definitions of both standalone and tool-defined taxonomies.",
        min_length=0,
    )
    locations: list[ArtifactLocation] | None = Field(
        default=[],
        description="An array of the artifactLocation objects associated with the tool component.",
        min_length=0,
    )
    language: constr(pattern=r"^[a-zA-Z]{2}|^[a-zA-Z]{2}-[a-zA-Z]{2}]?$") | None = (
        Field(
            default="en-US",
            description="The language of the messages emitted into the log file during this run (expressed as an ISO 639-1 two-letter lowercase language code) and an optional region (expressed as an ISO 3166-1 two-letter uppercase subculture code associated with a country or region). The casing is recommended but not required (in order for this data to conform to RFC5646).",
        )
    )
    contents: list[Content] | None = Field(
        default=["localizedData", "nonLocalizedData"],
        description="The kinds of data contained in this object.",
    )
    is_comprehensive: bool | None = Field(
        default=False,
        alias="isComprehensive",
        description="Specifies whether this object contains a complete definition of the localizable and/or non-localizable data for this component, as opposed to including only data that is relevant to the results persisted to this log file.",
    )
    localized_data_semantic_version: str | None = Field(
        default=None,
        alias="localizedDataSemanticVersion",
        description="The semantic version of the localized strings defined in this component; maintained by components that provide translations.",
    )
    minimum_required_localized_data_semantic_version: str | None = Field(
        default=None,
        alias="minimumRequiredLocalizedDataSemanticVersion",
        description="The minimum value of localizedDataSemanticVersion required in translations consumed by this component; used by components that consume translations.",
    )
    associated_component: ToolComponentReference | None = Field(
        default=None,
        alias="associatedComponent",
        description="The component which is strongly associated with this component. For a translation, this refers to the component which has been translated. For an extension, this is the driver that provides the extension's plugin model.",
    )
    translation_metadata: TranslationMetadata | None = Field(
        default=None,
        alias="translationMetadata",
        description="Translation metadata, required for a translation, not populated by other component types.",
    )
    supported_taxonomies: list[ToolComponentReference] | None = Field(
        default=[],
        alias="supportedTaxonomies",
        description="An array of toolComponentReference objects to declare the taxonomies supported by the tool component.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the tool component.",
    )


class VersionControlDetails(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    repository_uri: AnyUrl = Field(
        ..., alias="repositoryUri", description="The absolute URI of the repository."
    )
    revision_id: str | None = Field(
        default=None,
        alias="revisionId",
        description="A string that uniquely and permanently identifies the revision within the repository.",
    )
    branch: str | None = Field(
        default=None, description="The name of a branch containing the revision."
    )
    revision_tag: str | None = Field(
        default=None,
        alias="revisionTag",
        description="A tag that has been applied to the revision.",
    )
    as_of_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="asOfTimeUtc",
        description="A Coordinated Universal Time (UTC) date and time that can be used to synchronize an enlistment to the state of the repository at that time.",
    )
    mapped_to: ArtifactLocation | None = Field(
        default=None,
        alias="mappedTo",
        description="The location in the local file system to which the root of the repository was mapped at the time of the analysis.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the version control details.",
    )


class WebRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index within the run.webRequests array of the request object associated with this result.",
    )
    protocol: str | None = Field(
        default=None, description="The request protocol. Example: 'http'."
    )
    version: str | None = Field(
        default=None, description="The request version. Example: '1.1'."
    )
    target: str | None = Field(default=None, description="The target of the request.")
    method: str | None = Field(
        default=None,
        description="The HTTP method. Well-known values are 'GET', 'PUT', 'POST', 'DELETE', 'PATCH', 'HEAD', 'OPTIONS', 'TRACE', 'CONNECT'.",
    )
    headers: dict[str, str] | None = Field(
        default=None, description="The request headers."
    )
    parameters: dict[str, str] | None = Field(
        default=None, description="The request parameters."
    )
    body: ArtifactContent | None = Field(
        default=None, description="The body of the request."
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the request.",
    )


class WebResponse(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    index: conint(ge=-1) | None = Field(
        default=-1,
        description="The index within the run.webResponses array of the response object associated with this result.",
    )
    protocol: str | None = Field(
        default=None, description="The response protocol. Example: 'http'."
    )
    version: str | None = Field(
        default=None, description="The response version. Example: '1.1'."
    )
    status_code: int | None = Field(
        default=None,
        alias="statusCode",
        description="The response status code. Example: 451.",
    )
    reason_phrase: str | None = Field(
        default=None,
        alias="reasonPhrase",
        description="The response reason. Example: 'Not found'.",
    )
    headers: dict[str, str] | None = Field(
        default=None, description="The response headers."
    )
    body: ArtifactContent | None = Field(
        default=None, description="The body of the response."
    )
    no_response_received: bool | None = Field(
        default=False,
        alias="noResponseReceived",
        description="Specifies whether a response was received from the server.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the response.",
    )


class Artifact(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    description: Message | None = Field(
        default=None, description="A short description of the artifact."
    )
    location: ArtifactLocation | None = Field(
        default=None, description="The location of the artifact."
    )
    parent_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="parentIndex",
        description="Identifies the index of the immediate parent of the artifact, if this artifact is nested.",
    )
    offset: conint(ge=0) | None = Field(
        default=None,
        description="The offset in bytes of the artifact within its containing artifact.",
    )
    length: conint(ge=-1) | None = Field(
        default=-1, description="The length of the artifact in bytes."
    )
    roles: list[Role] | None = Field(
        default=[],
        description="The role or roles played by the artifact in the analysis.",
        min_length=0,
    )
    mime_type: constr(pattern=r"[^/]+/.+") | None = Field(
        default=None,
        alias="mimeType",
        description="The MIME type (RFC 2045) of the artifact.",
    )
    contents: ArtifactContent | None = Field(
        default=None, description="The contents of the artifact."
    )
    encoding: str | None = Field(
        default=None,
        description="Specifies the encoding for an artifact object that refers to a text file.",
    )
    source_language: str | None = Field(
        default=None,
        alias="sourceLanguage",
        description="Specifies the source language for any artifact object that refers to a text file that contains source code.",
    )
    hashes: dict[str, str] | None = Field(
        default=None,
        description="A dictionary, each of whose keys is the name of a hash function and each of whose values is the hashed value of the artifact produced by the specified hash function.",
    )
    last_modified_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="lastModifiedTimeUtc",
        description='The Coordinated Universal Time (UTC) date and time at which the artifact was most recently modified. See "Date/time properties" in the SARIF spec for the required format.',
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the artifact.",
    )


class ArtifactChange(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    artifact_location: ArtifactLocation = Field(
        ...,
        alias="artifactLocation",
        description="The location of the artifact to change.",
    )
    replacements: list[Replacement] = Field(
        ...,
        description="An array of replacement objects, each of which represents the replacement of a single region in a single artifact specified by 'artifactLocation'.",
        min_length=1,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the change.",
    )


class Attachment(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    description: Message | None = Field(
        default=None,
        description="A message describing the role played by the attachment.",
    )
    artifact_location: ArtifactLocation = Field(
        ..., alias="artifactLocation", description="The location of the attachment."
    )
    regions: list[Region] | None = Field(
        default=[],
        description="An array of regions of interest within the attachment.",
        min_length=0,
    )
    rectangles: list[Rectangle] | None = Field(
        default=[],
        description="An array of rectangles specifying areas of interest within the image.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the attachment.",
    )


class Fix(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    description: Message | None = Field(
        default=None,
        description="A message that describes the proposed fix, enabling viewers to present the proposed change to an end user.",
    )
    artifact_changes: list[ArtifactChange] = Field(
        ...,
        alias="artifactChanges",
        description="One or more artifact changes that comprise a fix for a result.",
        min_length=1,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the fix.",
    )


class PhysicalLocation1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    address: Address = Field(..., description="The address of the location.")
    artifact_location: ArtifactLocation | None = Field(
        default=None,
        alias="artifactLocation",
        description="The location of the artifact.",
    )
    region: Region | None = Field(
        default=None, description="Specifies a portion of the artifact."
    )
    context_region: Region | None = Field(
        default=None,
        alias="contextRegion",
        description="Specifies a portion of the artifact that encloses the region. Allows a viewer to display additional context around the region.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the physical location.",
    )


class PhysicalLocation2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    address: Address | None = Field(
        default=None, description="The address of the location."
    )
    artifact_location: ArtifactLocation = Field(
        ..., alias="artifactLocation", description="The location of the artifact."
    )
    region: Region | None = Field(
        default=None, description="Specifies a portion of the artifact."
    )
    context_region: Region | None = Field(
        default=None,
        alias="contextRegion",
        description="Specifies a portion of the artifact that encloses the region. Allows a viewer to display additional context around the region.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the physical location.",
    )


class PhysicalLocation(RootModel[PhysicalLocation1 | PhysicalLocation2]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: PhysicalLocation1 | PhysicalLocation2 = Field(
        ...,
        description="A physical location relevant to a result. Specifies a reference to a programming artifact together with a range of bytes or characters within that artifact.",
    )


class ResultProvenance(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    first_detection_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="firstDetectionTimeUtc",
        description='The Coordinated Universal Time (UTC) date and time at which the result was first detected. See "Date/time properties" in the SARIF spec for the required format.',
    )
    last_detection_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="lastDetectionTimeUtc",
        description='The Coordinated Universal Time (UTC) date and time at which the result was most recently detected. See "Date/time properties" in the SARIF spec for the required format.',
    )
    first_detection_run_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="firstDetectionRunGuid",
        description="A GUID-valued string equal to the automationDetails.guid property of the run in which the result was first detected.",
    )
    last_detection_run_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="lastDetectionRunGuid",
        description="A GUID-valued string equal to the automationDetails.guid property of the run in which the result was most recently detected.",
    )
    invocation_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="invocationIndex",
        description="The index within the run.invocations array of the invocation object which describes the tool invocation that detected the result.",
    )
    conversion_sources: list[PhysicalLocation] | None = Field(
        default=[],
        alias="conversionSources",
        description="An array of physicalLocation objects which specify the portions of an analysis tool's output that a converter transformed into the result.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the result.",
    )


class Tool(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    driver: ToolComponent = Field(..., description="The analysis tool that was run.")
    extensions: list[ToolComponent] | None = Field(
        default=[],
        description="Tool extensions that contributed to or reconfigured the analysis tool that was run.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the tool.",
    )


class Location(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: conint(ge=-1) | None = Field(
        default=-1,
        description="Value that distinguishes this location from all other locations within a single result object.",
    )
    physical_location: PhysicalLocation | None = Field(
        default=None,
        alias="physicalLocation",
        description="Identifies the artifact and region.",
    )
    logical_locations: list[LogicalLocation] | None = Field(
        default=[],
        alias="logicalLocations",
        description="The logical locations associated with the result.",
        min_length=0,
    )
    message: Message | None = Field(
        default=None, description="A message relevant to the location."
    )
    annotations: list[Region] | None = Field(
        default=[],
        description="A set of regions relevant to the location.",
        min_length=0,
    )
    relationships: list[LocationRelationship] | None = Field(
        default=[],
        description="An array of objects that describe relationships between this location and others.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the location.",
    )


class Node(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str = Field(
        ..., description="A string that uniquely identifies the node within its graph."
    )
    label: Message | None = Field(
        default=None, description="A short description of the node."
    )
    location: Location | None = Field(
        default=None, description="A code location associated with the node."
    )
    children: list[Node] | None = Field(default=[], description="Array of child nodes.")
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the node.",
    )


class StackFrame(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    location: Location | None = Field(
        default=None, description="The location to which this stack frame refers."
    )
    module: str | None = Field(
        default=None,
        description="The name of the module that contains the code of this stack frame.",
    )
    thread_id: int | None = Field(
        default=None,
        alias="threadId",
        description="The thread identifier of the stack frame.",
    )
    parameters: list[str] | None = Field(
        default=[],
        description="The parameters of the call that is executing.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the stack frame.",
    )


class Suppression(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A stable, unique identifer for the suprression in the form of a GUID.",
    )
    kind: Kind1 = Field(
        ..., description="A string that indicates where the suppression is persisted."
    )
    state: State | None = Field(
        default=None,
        description="A string that indicates the state of the suppression.",
    )
    justification: str | None = Field(
        default=None,
        description="A string representing the justification for the suppression.",
    )
    location: Location | None = Field(
        default=None,
        description="Identifies the location associated with the suppression.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the suppression.",
    )


class Graph(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    description: Message | None = Field(
        default=None, description="A description of the graph."
    )
    nodes: list[Node] | None = Field(
        default=[],
        description="An array of node objects representing the nodes of the graph.",
        min_length=0,
    )
    edges: list[Edge] | None = Field(
        default=[],
        description="An array of edge objects representing the edges of the graph.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the graph.",
    )


class Stack(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    message: Message | None = Field(
        default=None, description="A message relevant to this call stack."
    )
    frames: list[StackFrame] = Field(
        ...,
        description="An array of stack frames that represents a sequence of calls, rendered in reverse chronological order, that comprise the call stack.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the stack.",
    )


class ThreadFlowLocation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    index: conint(ge=-1) | None = Field(
        default=-1, description="The index within the run threadFlowLocations array."
    )
    location: Location | None = Field(default=None, description="The code location.")
    stack: Stack | None = Field(
        default=None, description="The call stack leading to this location."
    )
    kinds: list[str] | None = Field(
        default=[],
        description="A set of distinct strings that categorize the thread flow location. Well-known kinds include 'acquire', 'release', 'enter', 'exit', 'call', 'return', 'branch', 'implicit', 'false', 'true', 'caution', 'danger', 'unknown', 'unreachable', 'taint', 'function', 'handler', 'lock', 'memory', 'resource', 'scope' and 'value'.",
        min_length=0,
    )
    taxa: list[ReportingDescriptorReference] | None = Field(
        default=[],
        description="An array of references to rule or taxonomy reporting descriptors that are applicable to the thread flow location.",
        min_length=0,
    )
    module: str | None = Field(
        default=None,
        description="The name of the module that contains the code that is executing.",
    )
    state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        description="A dictionary, each of whose keys specifies a variable or expression, the associated value of which represents the variable or expression value. For an annotation of kind 'continuation', for example, this dictionary might hold the current assumed values of a set of global variables.",
    )
    nesting_level: conint(ge=0) | None = Field(
        default=None,
        alias="nestingLevel",
        description="An integer representing a containment hierarchy within the thread flow.",
    )
    execution_order: conint(ge=-1) | None = Field(
        default=-1,
        alias="executionOrder",
        description="An integer representing the temporal order in which execution reached this location.",
    )
    execution_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="executionTimeUtc",
        description="The Coordinated Universal Time (UTC) date and time at which this location was executed.",
    )
    importance: Importance | None = Field(
        default="important",
        description='Specifies the importance of this location in understanding the code flow in which it occurs. The order from most to least important is "essential", "important", "unimportant". Default: "important".',
    )
    web_request: WebRequest | None = Field(
        default=None,
        alias="webRequest",
        description="A web request associated with this thread flow location.",
    )
    web_response: WebResponse | None = Field(
        default=None,
        alias="webResponse",
        description="A web response associated with this thread flow location.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the threadflow location.",
    )


class Exception(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    kind: str | None = Field(
        default=None,
        description="A string that identifies the kind of exception, for example, the fully qualified type name of an object that was thrown, or the symbolic name of a signal.",
    )
    message: str | None = Field(
        default=None, description="A message that describes the exception."
    )
    stack: Stack | None = Field(
        default=None,
        description="The sequence of function calls leading to the exception.",
    )
    inner_exceptions: list[Exception] | None = Field(
        default=[],
        alias="innerExceptions",
        description="An array of exception objects each of which is considered a cause of this exception.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the exception.",
    )


class Notification(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    locations: list[Location] | None = Field(
        default=[],
        description="The locations relevant to this notification.",
        min_length=0,
    )
    message: Message = Field(
        ..., description="A message that describes the condition that was encountered."
    )
    level: Level | None = Field(
        default="warning",
        description="A value specifying the severity level of the notification.",
    )
    thread_id: int | None = Field(
        default=None,
        alias="threadId",
        description="The thread identifier of the code that generated the notification.",
    )
    time_utc: AwareDatetime | None = Field(
        default=None,
        alias="timeUtc",
        description="The Coordinated Universal Time (UTC) date and time at which the analysis tool generated the notification.",
    )
    exception: Exception | None = Field(
        default=None,
        description="The runtime exception, if any, relevant to this notification.",
    )
    descriptor: ReportingDescriptorReference | None = Field(
        default=None,
        description="A reference used to locate the descriptor relevant to this notification.",
    )
    associated_rule: ReportingDescriptorReference | None = Field(
        default=None,
        alias="associatedRule",
        description="A reference used to locate the rule descriptor associated with this notification.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the notification.",
    )


class ThreadFlow(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    id: str | None = Field(
        default=None,
        description="An string that uniquely identifies the threadFlow within the codeFlow in which it occurs.",
    )
    message: Message | None = Field(
        default=None, description="A message relevant to the thread flow."
    )
    initial_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="initialState",
        description="Values of relevant expressions at the start of the thread flow that may change during thread flow execution.",
    )
    immutable_state: dict[str, MultiformatMessageString] | None = Field(
        default=None,
        alias="immutableState",
        description="Values of relevant expressions at the start of the thread flow that remain constant.",
    )
    locations: list[ThreadFlowLocation] = Field(
        ...,
        description="A temporally ordered array of 'threadFlowLocation' objects, each of which describes a location visited by the tool while producing the result.",
        min_length=1,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the thread flow.",
    )


class CodeFlow(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    message: Message | None = Field(
        default=None, description="A message relevant to the code flow."
    )
    thread_flows: list[ThreadFlow] = Field(
        ...,
        alias="threadFlows",
        description="An array of one or more unique threadFlow objects, each of which describes the progress of a program through a thread of execution.",
        min_length=1,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the code flow.",
    )


class Invocation(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    command_line: str | None = Field(
        default=None,
        alias="commandLine",
        description="The command line used to invoke the tool.",
    )
    arguments: list[str] | None = Field(
        default=None,
        description="An array of strings, containing in order the command line arguments passed to the tool from the operating system.",
        min_length=0,
    )
    response_files: list[ArtifactLocation] | None = Field(
        default=None,
        alias="responseFiles",
        description="The locations of any response files specified on the tool's command line.",
        min_length=0,
    )
    start_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="startTimeUtc",
        description='The Coordinated Universal Time (UTC) date and time at which the run started. See "Date/time properties" in the SARIF spec for the required format.',
    )
    end_time_utc: AwareDatetime | None = Field(
        default=None,
        alias="endTimeUtc",
        description='The Coordinated Universal Time (UTC) date and time at which the run ended. See "Date/time properties" in the SARIF spec for the required format.',
    )
    exit_code: int | None = Field(
        default=None, alias="exitCode", description="The process exit code."
    )
    rule_configuration_overrides: list[ConfigurationOverride] | None = Field(
        default=[],
        alias="ruleConfigurationOverrides",
        description="An array of configurationOverride objects that describe rules related runtime overrides.",
        min_length=0,
    )
    notification_configuration_overrides: list[ConfigurationOverride] | None = Field(
        default=[],
        alias="notificationConfigurationOverrides",
        description="An array of configurationOverride objects that describe notifications related runtime overrides.",
        min_length=0,
    )
    tool_execution_notifications: list[Notification] | None = Field(
        default=[],
        alias="toolExecutionNotifications",
        description="A list of runtime conditions detected by the tool during the analysis.",
        min_length=0,
    )
    tool_configuration_notifications: list[Notification] | None = Field(
        default=[],
        alias="toolConfigurationNotifications",
        description="A list of conditions detected by the tool that are relevant to the tool's configuration.",
        min_length=0,
    )
    exit_code_description: str | None = Field(
        default=None,
        alias="exitCodeDescription",
        description="The reason for the process exit.",
    )
    exit_signal_name: str | None = Field(
        default=None,
        alias="exitSignalName",
        description="The name of the signal that caused the process to exit.",
    )
    exit_signal_number: int | None = Field(
        default=None,
        alias="exitSignalNumber",
        description="The numeric value of the signal that caused the process to exit.",
    )
    process_start_failure_message: str | None = Field(
        default=None,
        alias="processStartFailureMessage",
        description="The reason given by the operating system that the process failed to start.",
    )
    execution_successful: bool = Field(
        ...,
        alias="executionSuccessful",
        description="Specifies whether the tool's execution completed successfully.",
    )
    machine: str | None = Field(
        default=None, description="The machine that hosted the analysis tool run."
    )
    account: str | None = Field(
        default=None, description="The account that ran the analysis tool."
    )
    process_id: int | None = Field(
        default=None,
        alias="processId",
        description="The process id for the analysis tool run.",
    )
    executable_location: ArtifactLocation | None = Field(
        default=None,
        alias="executableLocation",
        description="An absolute URI specifying the location of the analysis tool's executable.",
    )
    working_directory: ArtifactLocation | None = Field(
        default=None,
        alias="workingDirectory",
        description="The working directory for the analysis tool run.",
    )
    environment_variables: dict[str, str] | None = Field(
        default=None,
        alias="environmentVariables",
        description="The environment variables associated with the analysis tool process, expressed as key/value pairs.",
    )
    stdin: ArtifactLocation | None = Field(
        default=None,
        description="A file containing the standard input stream to the process that was invoked.",
    )
    stdout: ArtifactLocation | None = Field(
        default=None,
        description="A file containing the standard output stream from the process that was invoked.",
    )
    stderr: ArtifactLocation | None = Field(
        default=None,
        description="A file containing the standard error stream from the process that was invoked.",
    )
    stdout_stderr: ArtifactLocation | None = Field(
        default=None,
        alias="stdoutStderr",
        description="A file containing the interleaved standard output and standard error stream from the process that was invoked.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the invocation.",
    )


class Result(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    rule_id: str | None = Field(
        default=None,
        alias="ruleId",
        description="The stable, unique identifier of the rule, if any, to which this notification is relevant. This member can be used to retrieve rule metadata from the rules dictionary, if it exists.",
    )
    rule_index: conint(ge=-1) | None = Field(
        default=-1,
        alias="ruleIndex",
        description="The index within the tool component rules array of the rule object associated with this result.",
    )
    rule: ReportingDescriptorReference | None = Field(
        default=None,
        description="A reference used to locate the rule descriptor relevant to this result.",
    )
    kind: Kind | None = Field(
        default="fail",
        description="A value that categorizes results by evaluation state.",
    )
    level: Level | None = Field(
        default="warning",
        description="A value specifying the severity level of the result.",
    )
    message: Message = Field(
        ...,
        description="A message that describes the result. The first sentence of the message only will be displayed when visible space is limited.",
    )
    analysis_target: ArtifactLocation | None = Field(
        default=None,
        alias="analysisTarget",
        description="Identifies the artifact that the analysis tool was instructed to scan. This need not be the same as the artifact where the result actually occurred.",
    )
    locations: list[Location] | None = Field(
        default=[],
        description="The set of locations where the result was detected. Specify only one location unless the problem indicated by the result can only be corrected by making a change at every specified location.",
        min_length=0,
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A stable, unique identifer for the result in the form of a GUID.",
    )
    correlation_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="correlationGuid",
        description="A stable, unique identifier for the equivalence class of logically identical results to which this result belongs, in the form of a GUID.",
    )
    occurrence_count: conint(ge=1) | None = Field(
        default=None,
        alias="occurrenceCount",
        description="A positive integer specifying the number of times this logically unique result was observed in this run.",
    )
    partial_fingerprints: dict[str, str] | None = Field(
        default=None,
        alias="partialFingerprints",
        description="A set of strings that contribute to the stable, unique identity of the result.",
    )
    fingerprints: dict[str, str] | None = Field(
        default=None,
        description="A set of strings each of which individually defines a stable, unique identity for the result.",
    )
    stacks: list[Stack] | None = Field(
        default=[],
        description="An array of 'stack' objects relevant to the result.",
        min_length=0,
    )
    code_flows: list[CodeFlow] | None = Field(
        default=[],
        alias="codeFlows",
        description="An array of 'codeFlow' objects relevant to the result.",
        min_length=0,
    )
    graphs: list[Graph] | None = Field(
        default=[],
        description="An array of zero or more unique graph objects associated with the result.",
        min_length=0,
    )
    graph_traversals: list[GraphTraversal] | None = Field(
        default=[],
        alias="graphTraversals",
        description="An array of one or more unique 'graphTraversal' objects.",
        min_length=0,
    )
    related_locations: list[Location] | None = Field(
        default=[],
        alias="relatedLocations",
        description="A set of locations relevant to this result.",
        min_length=0,
    )
    suppressions: list[Suppression] | None = Field(
        default=None,
        description="A set of suppressions relevant to this result.",
        min_length=0,
    )
    baseline_state: BaselineState | None = Field(
        default=None,
        alias="baselineState",
        description="The state of a result relative to a baseline of a previous run.",
    )
    rank: confloat(ge=-1.0, le=100.0) | None = Field(
        default=-1.0,
        description="A number representing the priority or importance of the result.",
    )
    attachments: list[Attachment] | None = Field(
        default=[],
        description="A set of artifacts relevant to the result.",
        min_length=0,
    )
    hosted_viewer_uri: AnyUrl | None = Field(
        default=None,
        alias="hostedViewerUri",
        description="An absolute URI at which the result can be viewed.",
    )
    work_item_uris: list[AnyUrl] | None = Field(
        default=None,
        alias="workItemUris",
        description="The URIs of the work items associated with this result.",
    )
    provenance: ResultProvenance | None = Field(
        default=None,
        description="Information about how and when the result was detected.",
    )
    fixes: list[Fix] | None = Field(
        default=[],
        description="An array of 'fix' objects, each of which represents a proposed fix to the problem indicated by the result.",
        min_length=0,
    )
    taxa: list[ReportingDescriptorReference] | None = Field(
        default=[],
        description="An array of references to taxonomy reporting descriptors that are applicable to the result.",
        min_length=0,
    )
    web_request: WebRequest | None = Field(
        default=None,
        alias="webRequest",
        description="A web request associated with this result.",
    )
    web_response: WebResponse | None = Field(
        default=None,
        alias="webResponse",
        description="A web response associated with this result.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the result.",
    )


class Conversion(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    tool: Tool = Field(..., description="A tool object that describes the converter.")
    invocation: Invocation | None = Field(
        default=None,
        description="An invocation object that describes the invocation of the converter.",
    )
    analysis_tool_log_files: list[ArtifactLocation] | None = Field(
        default=[],
        alias="analysisToolLogFiles",
        description="The locations of the analysis tool's per-run log files.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the conversion.",
    )


class ExternalProperties(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    schema_: AnyUrl | None = Field(
        default=None,
        alias="schema",
        description="The URI of the JSON schema corresponding to the version of the external property file format.",
    )
    version: Version | None = Field(
        default=None,
        description="The SARIF format version of this external properties object.",
    )
    guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        description="A stable, unique identifer for this external properties object, in the form of a GUID.",
    )
    run_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="runGuid",
        description="A stable, unique identifer for the run associated with this external properties object, in the form of a GUID.",
    )
    conversion: Conversion | None = Field(
        default=None,
        description="A conversion object that will be merged with a separate run.",
    )
    graphs: list[Graph] | None = Field(
        default=[],
        description="An array of graph objects that will be merged with a separate run.",
        min_length=0,
    )
    externalized_properties: PropertyBag | None = Field(
        default=None,
        alias="externalizedProperties",
        description="Key/value pairs that provide additional information that will be merged with a separate run.",
    )
    artifacts: list[Artifact] | None = Field(
        default=None,
        description="An array of artifact objects that will be merged with a separate run.",
        min_length=0,
    )
    invocations: list[Invocation] | None = Field(
        default=[],
        description="Describes the invocation of the analysis tool that will be merged with a separate run.",
        min_length=0,
    )
    logical_locations: list[LogicalLocation] | None = Field(
        default=[],
        alias="logicalLocations",
        description="An array of logical locations such as namespaces, types or functions that will be merged with a separate run.",
        min_length=0,
    )
    thread_flow_locations: list[ThreadFlowLocation] | None = Field(
        default=[],
        alias="threadFlowLocations",
        description="An array of threadFlowLocation objects that will be merged with a separate run.",
        min_length=0,
    )
    results: list[Result] | None = Field(
        default=[],
        description="An array of result objects that will be merged with a separate run.",
        min_length=0,
    )
    taxonomies: list[ToolComponent] | None = Field(
        default=[],
        description="Tool taxonomies that will be merged with a separate run.",
        min_length=0,
    )
    driver: ToolComponent | None = Field(
        default=None,
        description="The analysis tool object that will be merged with a separate run.",
    )
    extensions: list[ToolComponent] | None = Field(
        default=[],
        description="Tool extensions that will be merged with a separate run.",
        min_length=0,
    )
    policies: list[ToolComponent] | None = Field(
        default=[],
        description="Tool policies that will be merged with a separate run.",
        min_length=0,
    )
    translations: list[ToolComponent] | None = Field(
        default=[],
        description="Tool translations that will be merged with a separate run.",
        min_length=0,
    )
    addresses: list[Address] | None = Field(
        default=[],
        description="Addresses that will be merged with a separate run.",
        min_length=0,
    )
    web_requests: list[WebRequest] | None = Field(
        default=[],
        alias="webRequests",
        description="Requests that will be merged with a separate run.",
        min_length=0,
    )
    web_responses: list[WebResponse] | None = Field(
        default=[],
        alias="webResponses",
        description="Responses that will be merged with a separate run.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the external properties.",
    )


class Run(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    tool: Tool = Field(
        ...,
        description="Information about the tool or tool pipeline that generated the results in this run. A run can only contain results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.",
    )
    invocations: list[Invocation] | None = Field(
        default=[],
        description="Describes the invocation of the analysis tool.",
        min_length=0,
    )
    conversion: Conversion | None = Field(
        default=None,
        description="A conversion object that describes how a converter transformed an analysis tool's native reporting format into the SARIF format.",
    )
    language: constr(pattern=r"^[a-zA-Z]{2}|^[a-zA-Z]{2}-[a-zA-Z]{2}]?$") | None = (
        Field(
            default="en-US",
            description="The language of the messages emitted into the log file during this run (expressed as an ISO 639-1 two-letter lowercase culture code) and an optional region (expressed as an ISO 3166-1 two-letter uppercase subculture code associated with a country or region). The casing is recommended but not required (in order for this data to conform to RFC5646).",
        )
    )
    version_control_provenance: list[VersionControlDetails] | None = Field(
        default=[],
        alias="versionControlProvenance",
        description="Specifies the revision in version control of the artifacts that were scanned.",
        min_length=0,
    )
    original_uri_base_ids: dict[str, ArtifactLocation] | None = Field(
        default=None,
        alias="originalUriBaseIds",
        description="The artifact location specified by each uriBaseId symbol on the machine where the tool originally ran.",
    )
    artifacts: list[Artifact] | None = Field(
        default=None,
        description="An array of artifact objects relevant to the run.",
        min_length=0,
    )
    logical_locations: list[LogicalLocation] | None = Field(
        default=[],
        alias="logicalLocations",
        description="An array of logical locations such as namespaces, types or functions.",
        min_length=0,
    )
    graphs: list[Graph] | None = Field(
        default=[],
        description="An array of zero or more unique graph objects associated with the run.",
        min_length=0,
    )
    results: list[Result] | None = Field(
        default=None,
        description="The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting rules metadata. It must be present (but may be empty) if a log file represents an actual scan.",
        min_length=0,
    )
    automation_details: RunAutomationDetails | None = Field(
        default=None,
        alias="automationDetails",
        description="Automation details that describe this run.",
    )
    run_aggregates: list[RunAutomationDetails] | None = Field(
        default=[],
        alias="runAggregates",
        description="Automation details that describe the aggregate of runs to which this run belongs.",
        min_length=0,
    )
    baseline_guid: (
        constr(
            pattern=r"^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$"
        )
        | None
    ) = Field(
        default=None,
        alias="baselineGuid",
        description="The 'guid' property of a previous SARIF 'run' that comprises the baseline that was used to compute result 'baselineState' properties for the run.",
    )
    redaction_tokens: list[str] | None = Field(
        default=[],
        alias="redactionTokens",
        description="An array of strings used to replace sensitive information in a redaction-aware property.",
        min_length=0,
    )
    default_encoding: str | None = Field(
        default=None,
        alias="defaultEncoding",
        description="Specifies the default encoding for any artifact object that refers to a text file.",
    )
    default_source_language: str | None = Field(
        default=None,
        alias="defaultSourceLanguage",
        description="Specifies the default source language for any artifact object that refers to a text file that contains source code.",
    )
    newline_sequences: list[str] | None = Field(
        default=["\r\n", "\n"],
        alias="newlineSequences",
        description="An ordered list of character sequences that were treated as line breaks when computing region information for the run.",
        min_length=1,
    )
    column_kind: ColumnKind | None = Field(
        default=None,
        alias="columnKind",
        description="Specifies the unit in which the tool measures columns.",
    )
    external_property_file_references: ExternalPropertyFileReferences | None = Field(
        default=None,
        alias="externalPropertyFileReferences",
        description="References to external property files that should be inlined with the content of a root log file.",
    )
    thread_flow_locations: list[ThreadFlowLocation] | None = Field(
        default=[],
        alias="threadFlowLocations",
        description="An array of threadFlowLocation objects cached at run level.",
        min_length=0,
    )
    taxonomies: list[ToolComponent] | None = Field(
        default=[],
        description="An array of toolComponent objects relevant to a taxonomy in which results are categorized.",
        min_length=0,
    )
    addresses: list[Address] | None = Field(
        default=[],
        description="Addresses associated with this run instance, if any.",
        min_length=0,
    )
    translations: list[ToolComponent] | None = Field(
        default=[],
        description="The set of available translations of the localized data provided by the tool.",
        min_length=0,
    )
    policies: list[ToolComponent] | None = Field(
        default=[],
        description="Contains configurations that may potentially override both reportingDescriptor.defaultConfiguration (the tool's default severities) and invocation.configurationOverrides (severities established at run-time from the command line).",
        min_length=0,
    )
    web_requests: list[WebRequest] | None = Field(
        default=[],
        alias="webRequests",
        description="An array of request objects cached at run level.",
        min_length=0,
    )
    web_responses: list[WebResponse] | None = Field(
        default=[],
        alias="webResponses",
        description="An array of response objects cached at run level.",
        min_length=0,
    )
    special_locations: SpecialLocations | None = Field(
        default=None,
        alias="specialLocations",
        description="A specialLocations object that defines locations of special significance to SARIF consumers.",
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the run.",
    )


class SarifLog(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    field_schema: AnyUrl | None = Field(
        default=None,
        alias="$schema",
        description="The URI of the JSON schema corresponding to the version.",
    )
    version: Version = Field(
        ..., description="The SARIF format version of this log file."
    )
    runs: list[Run] = Field(
        ..., description="The set of runs contained in this log file.", min_length=0
    )
    inline_external_properties: list[ExternalProperties] | None = Field(
        default=None,
        alias="inlineExternalProperties",
        description="References to external property files that share data between runs.",
        min_length=0,
    )
    properties: PropertyBag | None = Field(
        default=None,
        description="Key/value pairs that provide additional information about the log file.",
    )


Node.model_rebuild()
Exception.model_rebuild()
