/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferDb;
import com.datapps.linkoopdb.jdbc.util.TransferHelper;
import com.datapps.linkoopdb.jdbc.util.TransferTable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class PostgresTransferHelper
extends TransferHelper {
    private final int PostgreSQL = 0;
    private final int LinkoopDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    PostgresTransferHelper() {
    }

    PostgresTransferHelper(TransferDb database, Traceable t, String q) {
        super(database, t, q);
    }

    @Override
    int convertToType(int type) {
        if (type == 3) {
            type = 2;
            this.tracer.trace("Converted DECIMAL to NUMERIC");
        }
        return type;
    }

    @Override
    String fixupColumnDefRead(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        String SeqName = new String("_" + columnDesc.getString(4) + "_seq");
        int spaceleft = 31 - SeqName.length();
        SeqName = t.Stmts.sDestTable.length() > spaceleft ? t.Stmts.sDestTable.substring(0, spaceleft) + SeqName : t.Stmts.sDestTable + SeqName;
        String CompareString = "nextval('\"" + SeqName + "\"'";
        if (columnType.indexOf(CompareString) >= 0) {
            columnType = "SERIAL";
        }
        for (int Idx = 0; Idx < this.Funcs.length; ++Idx) {
            String PostgreSQL_func = this.Funcs[Idx][0];
            int iStartPos = columnType.indexOf(PostgreSQL_func);
            if (iStartPos < 0) continue;
            String NewColumnType = columnType.substring(0, iStartPos);
            NewColumnType = NewColumnType + this.Funcs[Idx][1];
            columnType = NewColumnType = NewColumnType + columnType.substring(iStartPos + PostgreSQL_func.length());
        }
        return columnType;
    }

    @Override
    String fixupColumnDefWrite(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        if (columnType.equals("SERIAL")) {
            String SeqName = new String("_" + columnDesc.getString(4) + "_seq");
            int spaceleft = 31 - SeqName.length();
            SeqName = t.Stmts.sDestTable.length() > spaceleft ? t.Stmts.sDestTable.substring(0, spaceleft) + SeqName : t.Stmts.sDestTable + SeqName;
            String DropSequence = "DROP SEQUENCE " + SeqName + ";";
            t.Stmts.sDestDrop = t.Stmts.sDestDrop + DropSequence;
        }
        for (int Idx = 0; Idx < this.Funcs.length; ++Idx) {
            String LinkoopDB_func = this.Funcs[Idx][1];
            int iStartPos = columnType.indexOf(LinkoopDB_func);
            if (iStartPos < 0) continue;
            String NewColumnType = columnType.substring(0, iStartPos);
            NewColumnType = NewColumnType + this.Funcs[Idx][0];
            columnType = NewColumnType = NewColumnType + columnType.substring(iStartPos + LinkoopDB_func.length());
        }
        return columnType;
    }

    @Override
    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void endDataTransfer() {
        try {
            this.db.commit();
            this.db.execute("VACUUM ANALYZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

