# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceOsPatchActionArgs', 'BdsInstanceOsPatchAction']

@pulumi.input_type
class BdsInstanceOsPatchActionArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[builtins.str],
                 cluster_admin_password: pulumi.Input[builtins.str],
                 os_patch_version: pulumi.Input[builtins.str],
                 patching_configs: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]] = None):
        """
        The set of arguments for constructing a BdsInstanceOsPatchAction resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "os_patch_version", os_patch_version)
        if patching_configs is not None:
            pulumi.set(__self__, "patching_configs", patching_configs)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "os_patch_version", value)

    @property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

    @patching_configs.setter
    def patching_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]]):
        pulumi.set(self, "patching_configs", value)


@pulumi.input_type
class _BdsInstanceOsPatchActionState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 os_patch_version: Optional[pulumi.Input[builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceOsPatchAction resources.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if os_patch_version is not None:
            pulumi.set(__self__, "os_patch_version", os_patch_version)
        if patching_configs is not None:
            pulumi.set(__self__, "patching_configs", patching_configs)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_patch_version", value)

    @property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

    @patching_configs.setter
    def patching_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOsPatchActionPatchingConfigArgs']]]]):
        pulumi.set(self, "patching_configs", value)


class BdsInstanceOsPatchAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 os_patch_version: Optional[pulumi.Input[builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigArgs', 'BdsInstanceOsPatchActionPatchingConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance OS Patch Action resource in Oracle Cloud Infrastructure Big Data Service service.

        Install the specified OS patch to this cluster nodes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_os_patch_action = oci.big_data_service.BdsInstanceOsPatchAction("test_bds_instance_os_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_os_patch_action_cluster_admin_password,
            os_patch_version=bds_instance_os_patch_action_os_patch_version,
            patching_configs=[{
                "patching_config_strategy": bds_instance_os_patch_action_patching_config_strategy,
                "batch_size": bds_instance_os_patch_action_batch_size,
                "wait_time_between_batch_in_seconds": bds_instance_os_patch_action_wait_time_between_batch_in_seconds,
                "tolerance_threshold_per_batch": bds_instance_os_patch_action_tolerance_threshold_per_batch,
                "wait_time_between_domain_in_seconds": bds_instance_os_patch_action_wait_time_between_domain_in_seconds,
                "tolerance_threshold_per_domain": bds_instance_os_patch_action_tolerance_threshold_per_domain,
            }])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigArgs', 'BdsInstanceOsPatchActionPatchingConfigArgsDict']]]] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceOsPatchActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance OS Patch Action resource in Oracle Cloud Infrastructure Big Data Service service.

        Install the specified OS patch to this cluster nodes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_os_patch_action = oci.big_data_service.BdsInstanceOsPatchAction("test_bds_instance_os_patch_action",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_os_patch_action_cluster_admin_password,
            os_patch_version=bds_instance_os_patch_action_os_patch_version,
            patching_configs=[{
                "patching_config_strategy": bds_instance_os_patch_action_patching_config_strategy,
                "batch_size": bds_instance_os_patch_action_batch_size,
                "wait_time_between_batch_in_seconds": bds_instance_os_patch_action_wait_time_between_batch_in_seconds,
                "tolerance_threshold_per_batch": bds_instance_os_patch_action_tolerance_threshold_per_batch,
                "wait_time_between_domain_in_seconds": bds_instance_os_patch_action_wait_time_between_domain_in_seconds,
                "tolerance_threshold_per_domain": bds_instance_os_patch_action_tolerance_threshold_per_domain,
            }])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BdsInstanceOsPatchActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceOsPatchActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 os_patch_version: Optional[pulumi.Input[builtins.str]] = None,
                 patching_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigArgs', 'BdsInstanceOsPatchActionPatchingConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceOsPatchActionArgs.__new__(BdsInstanceOsPatchActionArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            if os_patch_version is None and not opts.urn:
                raise TypeError("Missing required property 'os_patch_version'")
            __props__.__dict__["os_patch_version"] = os_patch_version
            __props__.__dict__["patching_configs"] = patching_configs
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceOsPatchAction, __self__).__init__(
            'oci:BigDataService/bdsInstanceOsPatchAction:BdsInstanceOsPatchAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
            os_patch_version: Optional[pulumi.Input[builtins.str]] = None,
            patching_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigArgs', 'BdsInstanceOsPatchActionPatchingConfigArgsDict']]]]] = None) -> 'BdsInstanceOsPatchAction':
        """
        Get an existing BdsInstanceOsPatchAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] os_patch_version: The version of the OS patch to be installed.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOsPatchActionPatchingConfigArgs', 'BdsInstanceOsPatchActionPatchingConfigArgsDict']]]] patching_configs: Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceOsPatchActionState.__new__(_BdsInstanceOsPatchActionState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["os_patch_version"] = os_patch_version
        __props__.__dict__["patching_configs"] = patching_configs
        return BdsInstanceOsPatchAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the OS patch to be installed.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_patch_version")

    @property
    @pulumi.getter(name="patchingConfigs")
    def patching_configs(self) -> pulumi.Output[Sequence['outputs.BdsInstanceOsPatchActionPatchingConfig']]:
        """
        Detailed configurations for defining the behavior when installing ODH patches. If not provided, nodes will be patched with down time.
        """
        return pulumi.get(self, "patching_configs")

