# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateAuthorityResult',
    'AwaitableGetCertificateAuthorityResult',
    'get_certificate_authority',
    'get_certificate_authority_output',
]

@pulumi.output_type
class GetCertificateAuthorityResult:
    """
    A collection of values returned by getCertificateAuthority.
    """
    def __init__(__self__, certificate_authority_configs=None, certificate_authority_id=None, certificate_authority_rules=None, certificate_revocation_list_details=None, compartment_id=None, config_type=None, current_versions=None, defined_tags=None, description=None, freeform_tags=None, id=None, issuer_certificate_authority_id=None, kms_key_id=None, lifecycle_details=None, name=None, signing_algorithm=None, state=None, subjects=None, time_created=None, time_of_deletion=None):
        if certificate_authority_configs and not isinstance(certificate_authority_configs, list):
            raise TypeError("Expected argument 'certificate_authority_configs' to be a list")
        pulumi.set(__self__, "certificate_authority_configs", certificate_authority_configs)
        if certificate_authority_id and not isinstance(certificate_authority_id, str):
            raise TypeError("Expected argument 'certificate_authority_id' to be a str")
        pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if certificate_authority_rules and not isinstance(certificate_authority_rules, list):
            raise TypeError("Expected argument 'certificate_authority_rules' to be a list")
        pulumi.set(__self__, "certificate_authority_rules", certificate_authority_rules)
        if certificate_revocation_list_details and not isinstance(certificate_revocation_list_details, list):
            raise TypeError("Expected argument 'certificate_revocation_list_details' to be a list")
        pulumi.set(__self__, "certificate_revocation_list_details", certificate_revocation_list_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_type and not isinstance(config_type, str):
            raise TypeError("Expected argument 'config_type' to be a str")
        pulumi.set(__self__, "config_type", config_type)
        if current_versions and not isinstance(current_versions, list):
            raise TypeError("Expected argument 'current_versions' to be a list")
        pulumi.set(__self__, "current_versions", current_versions)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_certificate_authority_id and not isinstance(issuer_certificate_authority_id, str):
            raise TypeError("Expected argument 'issuer_certificate_authority_id' to be a str")
        pulumi.set(__self__, "issuer_certificate_authority_id", issuer_certificate_authority_id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if signing_algorithm and not isinstance(signing_algorithm, str):
            raise TypeError("Expected argument 'signing_algorithm' to be a str")
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subjects and not isinstance(subjects, list):
            raise TypeError("Expected argument 'subjects' to be a list")
        pulumi.set(__self__, "subjects", subjects)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @property
    @pulumi.getter(name="certificateAuthorityConfigs")
    def certificate_authority_configs(self) -> Sequence['outputs.GetCertificateAuthorityCertificateAuthorityConfigResult']:
        return pulumi.get(self, "certificate_authority_configs")

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> builtins.str:
        """
        The OCID of the CA.
        """
        return pulumi.get(self, "certificate_authority_id")

    @property
    @pulumi.getter(name="certificateAuthorityRules")
    def certificate_authority_rules(self) -> Sequence['outputs.GetCertificateAuthorityCertificateAuthorityRuleResult']:
        """
        An optional list of rules that control how the CA is used and managed.
        """
        return pulumi.get(self, "certificate_authority_rules")

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Sequence['outputs.GetCertificateAuthorityCertificateRevocationListDetailResult']:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment under which the CA is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> builtins.str:
        """
        The origin of the CA.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> Sequence['outputs.GetCertificateAuthorityCurrentVersionResult']:
        """
        The metadata details of the certificate authority (CA) version. This summary object does not contain the CA contents.
        """
        return pulumi.get(self, "current_versions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A brief description of the CA.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the CA.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> builtins.str:
        """
        The OCID of the parent CA that issued this CA. If this is the root CA, then this value is null.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current CA lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> builtins.str:
        """
        The algorithm used to sign public key certificates that the CA issues.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the certificate authority.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subjects(self) -> Sequence['outputs.GetCertificateAuthoritySubjectResult']:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        A property indicating when the CA was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> builtins.str:
        """
        An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")


class AwaitableGetCertificateAuthorityResult(GetCertificateAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityResult(
            certificate_authority_configs=self.certificate_authority_configs,
            certificate_authority_id=self.certificate_authority_id,
            certificate_authority_rules=self.certificate_authority_rules,
            certificate_revocation_list_details=self.certificate_revocation_list_details,
            compartment_id=self.compartment_id,
            config_type=self.config_type,
            current_versions=self.current_versions,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            issuer_certificate_authority_id=self.issuer_certificate_authority_id,
            kms_key_id=self.kms_key_id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            signing_algorithm=self.signing_algorithm,
            state=self.state,
            subjects=self.subjects,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion)


def get_certificate_authority(certificate_authority_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityResult:
    """
    This data source provides details about a specific Certificate Authority resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified certificate authority (CA).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate_authority = oci.CertificatesManagement.get_certificate_authority(certificate_authority_id=test_certificate_authority_oci_certificates_management_certificate_authority["id"])
    ```


    :param builtins.str certificate_authority_id: The OCID of the certificate authority (CA).
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCertificateAuthority:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult).value

    return AwaitableGetCertificateAuthorityResult(
        certificate_authority_configs=pulumi.get(__ret__, 'certificate_authority_configs'),
        certificate_authority_id=pulumi.get(__ret__, 'certificate_authority_id'),
        certificate_authority_rules=pulumi.get(__ret__, 'certificate_authority_rules'),
        certificate_revocation_list_details=pulumi.get(__ret__, 'certificate_revocation_list_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_type=pulumi.get(__ret__, 'config_type'),
        current_versions=pulumi.get(__ret__, 'current_versions'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        issuer_certificate_authority_id=pulumi.get(__ret__, 'issuer_certificate_authority_id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        signing_algorithm=pulumi.get(__ret__, 'signing_algorithm'),
        state=pulumi.get(__ret__, 'state'),
        subjects=pulumi.get(__ret__, 'subjects'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'))
def get_certificate_authority_output(certificate_authority_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateAuthorityResult]:
    """
    This data source provides details about a specific Certificate Authority resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified certificate authority (CA).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate_authority = oci.CertificatesManagement.get_certificate_authority(certificate_authority_id=test_certificate_authority_oci_certificates_management_certificate_authority["id"])
    ```


    :param builtins.str certificate_authority_id: The OCID of the certificate authority (CA).
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CertificatesManagement/getCertificateAuthority:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult)
    return __ret__.apply(lambda __response__: GetCertificateAuthorityResult(
        certificate_authority_configs=pulumi.get(__response__, 'certificate_authority_configs'),
        certificate_authority_id=pulumi.get(__response__, 'certificate_authority_id'),
        certificate_authority_rules=pulumi.get(__response__, 'certificate_authority_rules'),
        certificate_revocation_list_details=pulumi.get(__response__, 'certificate_revocation_list_details'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_type=pulumi.get(__response__, 'config_type'),
        current_versions=pulumi.get(__response__, 'current_versions'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        issuer_certificate_authority_id=pulumi.get(__response__, 'issuer_certificate_authority_id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        signing_algorithm=pulumi.get(__response__, 'signing_algorithm'),
        state=pulumi.get(__response__, 'state'),
        subjects=pulumi.get(__response__, 'subjects'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion')))
