# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CrossConnectArgs', 'CrossConnect']

@pulumi.input_type
class CrossConnectArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 location_name: pulumi.Input[builtins.str],
                 port_speed_shape_name: pulumi.Input[builtins.str],
                 cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 far_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 macsec_properties: Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']] = None,
                 near_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CrossConnect resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment to contain the cross-connect.
        :param pulumi.Input[builtins.str] location_name: The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        :param pulumi.Input[builtins.str] port_speed_shape_name: The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] cross_connect_group_id: The OCID of the cross-connect group to put this cross-connect in.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] far_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        :param pulumi.Input['CrossConnectMacsecPropertiesArgs'] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] near_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "location_name", location_name)
        pulumi.set(__self__, "port_speed_shape_name", port_speed_shape_name)
        if cross_connect_group_id is not None:
            pulumi.set(__self__, "cross_connect_group_id", cross_connect_group_id)
        if customer_reference_name is not None:
            pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if far_cross_connect_or_cross_connect_group_id is not None:
            pulumi.set(__self__, "far_cross_connect_or_cross_connect_group_id", far_cross_connect_or_cross_connect_group_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if macsec_properties is not None:
            pulumi.set(__self__, "macsec_properties", macsec_properties)
        if near_cross_connect_or_cross_connect_group_id is not None:
            pulumi.set(__self__, "near_cross_connect_or_cross_connect_group_id", near_cross_connect_or_cross_connect_group_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment to contain the cross-connect.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        """
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location_name", value)

    @property
    @pulumi.getter(name="portSpeedShapeName")
    def port_speed_shape_name(self) -> pulumi.Input[builtins.str]:
        """
        The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "port_speed_shape_name")

    @port_speed_shape_name.setter
    def port_speed_shape_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "port_speed_shape_name", value)

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cross-connect group to put this cross-connect in.
        """
        return pulumi.get(self, "cross_connect_group_id")

    @cross_connect_group_id.setter
    def cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cross_connect_group_id", value)

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @customer_reference_name.setter
    def customer_reference_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_reference_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="farCrossConnectOrCrossConnectGroupId")
    def far_cross_connect_or_cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "far_cross_connect_or_cross_connect_group_id")

    @far_cross_connect_or_cross_connect_group_id.setter
    def far_cross_connect_or_cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "far_cross_connect_or_cross_connect_group_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']]:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @macsec_properties.setter
    def macsec_properties(self, value: Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']]):
        pulumi.set(self, "macsec_properties", value)

    @property
    @pulumi.getter(name="nearCrossConnectOrCrossConnectGroupId")
    def near_cross_connect_or_cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "near_cross_connect_or_cross_connect_group_id")

    @near_cross_connect_or_cross_connect_group_id.setter
    def near_cross_connect_or_cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "near_cross_connect_or_cross_connect_group_id", value)


@pulumi.input_type
class _CrossConnectState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 far_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 location_name: Optional[pulumi.Input[builtins.str]] = None,
                 macsec_properties: Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']] = None,
                 near_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 oci_logical_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 oci_physical_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 port_name: Optional[pulumi.Input[builtins.str]] = None,
                 port_speed_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CrossConnect resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment to contain the cross-connect.
        :param pulumi.Input[builtins.str] cross_connect_group_id: The OCID of the cross-connect group to put this cross-connect in.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] far_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        :param pulumi.Input[builtins.str] location_name: The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        :param pulumi.Input['CrossConnectMacsecPropertiesArgs'] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] near_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[builtins.str] oci_logical_device_name: The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        :param pulumi.Input[builtins.str] oci_physical_device_name: The FastConnect device that terminates the physical connection.
        :param pulumi.Input[builtins.str] port_name: A string identifying the meet-me room port for this cross-connect.
        :param pulumi.Input[builtins.str] port_speed_shape_name: The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The cross-connect's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the cross-connect was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cross_connect_group_id is not None:
            pulumi.set(__self__, "cross_connect_group_id", cross_connect_group_id)
        if customer_reference_name is not None:
            pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if far_cross_connect_or_cross_connect_group_id is not None:
            pulumi.set(__self__, "far_cross_connect_or_cross_connect_group_id", far_cross_connect_or_cross_connect_group_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)
        if macsec_properties is not None:
            pulumi.set(__self__, "macsec_properties", macsec_properties)
        if near_cross_connect_or_cross_connect_group_id is not None:
            pulumi.set(__self__, "near_cross_connect_or_cross_connect_group_id", near_cross_connect_or_cross_connect_group_id)
        if oci_logical_device_name is not None:
            pulumi.set(__self__, "oci_logical_device_name", oci_logical_device_name)
        if oci_physical_device_name is not None:
            pulumi.set(__self__, "oci_physical_device_name", oci_physical_device_name)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_speed_shape_name is not None:
            pulumi.set(__self__, "port_speed_shape_name", port_speed_shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment to contain the cross-connect.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cross-connect group to put this cross-connect in.
        """
        return pulumi.get(self, "cross_connect_group_id")

    @cross_connect_group_id.setter
    def cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cross_connect_group_id", value)

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @customer_reference_name.setter
    def customer_reference_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_reference_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="farCrossConnectOrCrossConnectGroupId")
    def far_cross_connect_or_cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "far_cross_connect_or_cross_connect_group_id")

    @far_cross_connect_or_cross_connect_group_id.setter
    def far_cross_connect_or_cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "far_cross_connect_or_cross_connect_group_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        """
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_name", value)

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']]:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @macsec_properties.setter
    def macsec_properties(self, value: Optional[pulumi.Input['CrossConnectMacsecPropertiesArgs']]):
        pulumi.set(self, "macsec_properties", value)

    @property
    @pulumi.getter(name="nearCrossConnectOrCrossConnectGroupId")
    def near_cross_connect_or_cross_connect_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "near_cross_connect_or_cross_connect_group_id")

    @near_cross_connect_or_cross_connect_group_id.setter
    def near_cross_connect_or_cross_connect_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "near_cross_connect_or_cross_connect_group_id", value)

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @oci_logical_device_name.setter
    def oci_logical_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oci_logical_device_name", value)

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @oci_physical_device_name.setter
    def oci_physical_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oci_physical_device_name", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string identifying the meet-me room port for this cross-connect.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpeedShapeName")
    def port_speed_shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "port_speed_shape_name")

    @port_speed_shape_name.setter
    def port_speed_shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port_speed_shape_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cross-connect's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the cross-connect was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class CrossConnect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 far_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 location_name: Optional[pulumi.Input[builtins.str]] = None,
                 macsec_properties: Optional[pulumi.Input[Union['CrossConnectMacsecPropertiesArgs', 'CrossConnectMacsecPropertiesArgsDict']]] = None,
                 near_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 port_speed_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Cross Connect resource in Oracle Cloud Infrastructure Core service.

        Creates a new cross-connect. Oracle recommends you create each cross-connect in a
        [CrossConnectGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectGroup) so you can use link aggregation
        with the connection.

        After creating the `CrossConnect` object, you need to go the FastConnect location
        and request to have the physical cable installed. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
        compartment where you want the cross-connect to reside. If you're
        not sure which compartment to use, put the cross-connect in the
        same compartment with your VCN. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the cross-connect.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cross_connect = oci.core.CrossConnect("test_cross_connect",
            compartment_id=compartment_id,
            location_name=cross_connect_location_name,
            port_speed_shape_name=cross_connect_port_speed_shape_name,
            cross_connect_group_id=test_cross_connect_group["id"],
            customer_reference_name=cross_connect_customer_reference_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cross_connect_display_name,
            far_cross_connect_or_cross_connect_group_id=test_cross_connect_group["id"],
            freeform_tags={
                "Department": "Finance",
            },
            macsec_properties={
                "state": cross_connect_macsec_properties_state,
                "encryption_cipher": cross_connect_macsec_properties_encryption_cipher,
                "is_unprotected_traffic_allowed": cross_connect_macsec_properties_is_unprotected_traffic_allowed,
                "primary_key": {
                    "connectivity_association_key_secret_id": test_secret["id"],
                    "connectivity_association_name_secret_id": test_secret["id"],
                },
            },
            near_cross_connect_or_cross_connect_group_id=test_cross_connect_group["id"])
        ```

        ## Import

        CrossConnects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/crossConnect:CrossConnect test_cross_connect "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment to contain the cross-connect.
        :param pulumi.Input[builtins.str] cross_connect_group_id: The OCID of the cross-connect group to put this cross-connect in.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] far_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        :param pulumi.Input[builtins.str] location_name: The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        :param pulumi.Input[Union['CrossConnectMacsecPropertiesArgs', 'CrossConnectMacsecPropertiesArgsDict']] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] near_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[builtins.str] port_speed_shape_name: The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CrossConnectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cross Connect resource in Oracle Cloud Infrastructure Core service.

        Creates a new cross-connect. Oracle recommends you create each cross-connect in a
        [CrossConnectGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectGroup) so you can use link aggregation
        with the connection.

        After creating the `CrossConnect` object, you need to go the FastConnect location
        and request to have the physical cable installed. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
        compartment where you want the cross-connect to reside. If you're
        not sure which compartment to use, put the cross-connect in the
        same compartment with your VCN. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the cross-connect.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cross_connect = oci.core.CrossConnect("test_cross_connect",
            compartment_id=compartment_id,
            location_name=cross_connect_location_name,
            port_speed_shape_name=cross_connect_port_speed_shape_name,
            cross_connect_group_id=test_cross_connect_group["id"],
            customer_reference_name=cross_connect_customer_reference_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cross_connect_display_name,
            far_cross_connect_or_cross_connect_group_id=test_cross_connect_group["id"],
            freeform_tags={
                "Department": "Finance",
            },
            macsec_properties={
                "state": cross_connect_macsec_properties_state,
                "encryption_cipher": cross_connect_macsec_properties_encryption_cipher,
                "is_unprotected_traffic_allowed": cross_connect_macsec_properties_is_unprotected_traffic_allowed,
                "primary_key": {
                    "connectivity_association_key_secret_id": test_secret["id"],
                    "connectivity_association_name_secret_id": test_secret["id"],
                },
            },
            near_cross_connect_or_cross_connect_group_id=test_cross_connect_group["id"])
        ```

        ## Import

        CrossConnects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/crossConnect:CrossConnect test_cross_connect "id"
        ```

        :param str resource_name: The name of the resource.
        :param CrossConnectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrossConnectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 far_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 location_name: Optional[pulumi.Input[builtins.str]] = None,
                 macsec_properties: Optional[pulumi.Input[Union['CrossConnectMacsecPropertiesArgs', 'CrossConnectMacsecPropertiesArgsDict']]] = None,
                 near_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 port_speed_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrossConnectArgs.__new__(CrossConnectArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["cross_connect_group_id"] = cross_connect_group_id
            __props__.__dict__["customer_reference_name"] = customer_reference_name
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["far_cross_connect_or_cross_connect_group_id"] = far_cross_connect_or_cross_connect_group_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_active"] = is_active
            if location_name is None and not opts.urn:
                raise TypeError("Missing required property 'location_name'")
            __props__.__dict__["location_name"] = location_name
            __props__.__dict__["macsec_properties"] = macsec_properties
            __props__.__dict__["near_cross_connect_or_cross_connect_group_id"] = near_cross_connect_or_cross_connect_group_id
            if port_speed_shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'port_speed_shape_name'")
            __props__.__dict__["port_speed_shape_name"] = port_speed_shape_name
            __props__.__dict__["oci_logical_device_name"] = None
            __props__.__dict__["oci_physical_device_name"] = None
            __props__.__dict__["port_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(CrossConnect, __self__).__init__(
            'oci:Core/crossConnect:CrossConnect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
            customer_reference_name: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            far_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_active: Optional[pulumi.Input[builtins.bool]] = None,
            location_name: Optional[pulumi.Input[builtins.str]] = None,
            macsec_properties: Optional[pulumi.Input[Union['CrossConnectMacsecPropertiesArgs', 'CrossConnectMacsecPropertiesArgsDict']]] = None,
            near_cross_connect_or_cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
            oci_logical_device_name: Optional[pulumi.Input[builtins.str]] = None,
            oci_physical_device_name: Optional[pulumi.Input[builtins.str]] = None,
            port_name: Optional[pulumi.Input[builtins.str]] = None,
            port_speed_shape_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'CrossConnect':
        """
        Get an existing CrossConnect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment to contain the cross-connect.
        :param pulumi.Input[builtins.str] cross_connect_group_id: The OCID of the cross-connect group to put this cross-connect in.
        :param pulumi.Input[builtins.str] customer_reference_name: (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] far_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        :param pulumi.Input[builtins.str] location_name: The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        :param pulumi.Input[Union['CrossConnectMacsecPropertiesArgs', 'CrossConnectMacsecPropertiesArgsDict']] macsec_properties: (Updatable) Properties used to configure MACsec (if capable).
        :param pulumi.Input[builtins.str] near_cross_connect_or_cross_connect_group_id: If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        :param pulumi.Input[builtins.str] oci_logical_device_name: The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        :param pulumi.Input[builtins.str] oci_physical_device_name: The FastConnect device that terminates the physical connection.
        :param pulumi.Input[builtins.str] port_name: A string identifying the meet-me room port for this cross-connect.
        :param pulumi.Input[builtins.str] port_speed_shape_name: The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The cross-connect's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the cross-connect was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CrossConnectState.__new__(_CrossConnectState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cross_connect_group_id"] = cross_connect_group_id
        __props__.__dict__["customer_reference_name"] = customer_reference_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["far_cross_connect_or_cross_connect_group_id"] = far_cross_connect_or_cross_connect_group_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["location_name"] = location_name
        __props__.__dict__["macsec_properties"] = macsec_properties
        __props__.__dict__["near_cross_connect_or_cross_connect_group_id"] = near_cross_connect_or_cross_connect_group_id
        __props__.__dict__["oci_logical_device_name"] = oci_logical_device_name
        __props__.__dict__["oci_physical_device_name"] = oci_physical_device_name
        __props__.__dict__["port_name"] = port_name
        __props__.__dict__["port_speed_shape_name"] = port_speed_shape_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return CrossConnect(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment to contain the cross-connect.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cross-connect group to put this cross-connect in.
        """
        return pulumi.get(self, "cross_connect_group_id")

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A reference name or identifier for the physical fiber connection that this cross-connect uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farCrossConnectOrCrossConnectGroupId")
    def far_cross_connect_or_cross_connect_group_id(self) -> pulumi.Output[builtins.str]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on a different router (for the purposes of redundancy), provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "far_cross_connect_or_cross_connect_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) Set to true to activate the cross-connect. You activate it after the physical cabling is complete, and you've confirmed the cross-connect's light levels are good and your side of the interface is up. Activation indicates to Oracle that the physical connection is ready.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the FastConnect location where this cross-connect will be installed. To get a list of the available locations, see [ListCrossConnectLocations](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectLocation/ListCrossConnectLocations).  Example: `CyrusOne, Chandler, AZ`
        """
        return pulumi.get(self, "location_name")

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> pulumi.Output['outputs.CrossConnectMacsecProperties']:
        """
        (Updatable) Properties used to configure MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @property
    @pulumi.getter(name="nearCrossConnectOrCrossConnectGroupId")
    def near_cross_connect_or_cross_connect_group_id(self) -> pulumi.Output[builtins.str]:
        """
        If you already have an existing cross-connect or cross-connect group at this FastConnect location, and you want this new cross-connect to be on the same router, provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that existing cross-connect or cross-connect group.
        """
        return pulumi.get(self, "near_cross_connect_or_cross_connect_group_id")

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> pulumi.Output[builtins.str]:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> pulumi.Output[builtins.str]:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[builtins.str]:
        """
        A string identifying the meet-me room port for this cross-connect.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpeedShapeName")
    def port_speed_shape_name(self) -> pulumi.Output[builtins.str]:
        """
        The port speed for this cross-connect. To get a list of the available port speeds, see [ListCrossConnectPortSpeedShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CrossConnectPortSpeedShape/ListCrossconnectPortSpeedShapes).  Example: `10 Gbps` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "port_speed_shape_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The cross-connect's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the cross-connect was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

