# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpsecConnectionTunnelRoutesResult',
    'AwaitableGetIpsecConnectionTunnelRoutesResult',
    'get_ipsec_connection_tunnel_routes',
    'get_ipsec_connection_tunnel_routes_output',
]

@pulumi.output_type
class GetIpsecConnectionTunnelRoutesResult:
    """
    A collection of values returned by getIpsecConnectionTunnelRoutes.
    """
    def __init__(__self__, advertiser=None, filters=None, id=None, ipsec_id=None, tunnel_id=None, tunnel_routes=None):
        if advertiser and not isinstance(advertiser, str):
            raise TypeError("Expected argument 'advertiser' to be a str")
        pulumi.set(__self__, "advertiser", advertiser)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_routes and not isinstance(tunnel_routes, list):
            raise TypeError("Expected argument 'tunnel_routes' to be a list")
        pulumi.set(__self__, "tunnel_routes", tunnel_routes)

    @property
    @pulumi.getter
    def advertiser(self) -> Optional[builtins.str]:
        """
        The source of the route advertisement.
        """
        return pulumi.get(self, "advertiser")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpsecConnectionTunnelRoutesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> builtins.str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> builtins.str:
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="tunnelRoutes")
    def tunnel_routes(self) -> Sequence['outputs.GetIpsecConnectionTunnelRoutesTunnelRouteResult']:
        """
        The list of tunnel_routes.
        """
        return pulumi.get(self, "tunnel_routes")


class AwaitableGetIpsecConnectionTunnelRoutesResult(GetIpsecConnectionTunnelRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecConnectionTunnelRoutesResult(
            advertiser=self.advertiser,
            filters=self.filters,
            id=self.id,
            ipsec_id=self.ipsec_id,
            tunnel_id=self.tunnel_id,
            tunnel_routes=self.tunnel_routes)


def get_ipsec_connection_tunnel_routes(advertiser: Optional[builtins.str] = None,
                                       filters: Optional[Sequence[Union['GetIpsecConnectionTunnelRoutesFilterArgs', 'GetIpsecConnectionTunnelRoutesFilterArgsDict']]] = None,
                                       ipsec_id: Optional[builtins.str] = None,
                                       tunnel_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecConnectionTunnelRoutesResult:
    """
    This data source provides the list of Ipsec Connection Tunnel Routes in Oracle Cloud Infrastructure Core service.

    The routes advertised to the on-premises network and the routes received from the on-premises network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ipsec_connection_tunnel_routes = oci.Core.get_ipsec_connection_tunnel_routes(ipsec_id=test_ipsec["id"],
        tunnel_id=test_tunnel["id"],
        advertiser=ipsec_connection_tunnel_route_advertiser)
    ```


    :param builtins.str advertiser: Specifies the advertiser of the routes. If set to `ORACLE`, this returns only the routes advertised by Oracle. When set to `CUSTOMER`, this returns only the routes advertised by the CPE.
    :param builtins.str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    :param builtins.str tunnel_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tunnel.
    """
    __args__ = dict()
    __args__['advertiser'] = advertiser
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecConnectionTunnelRoutes:getIpsecConnectionTunnelRoutes', __args__, opts=opts, typ=GetIpsecConnectionTunnelRoutesResult).value

    return AwaitableGetIpsecConnectionTunnelRoutesResult(
        advertiser=pulumi.get(__ret__, 'advertiser'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        tunnel_routes=pulumi.get(__ret__, 'tunnel_routes'))
def get_ipsec_connection_tunnel_routes_output(advertiser: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIpsecConnectionTunnelRoutesFilterArgs', 'GetIpsecConnectionTunnelRoutesFilterArgsDict']]]]] = None,
                                              ipsec_id: Optional[pulumi.Input[builtins.str]] = None,
                                              tunnel_id: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsecConnectionTunnelRoutesResult]:
    """
    This data source provides the list of Ipsec Connection Tunnel Routes in Oracle Cloud Infrastructure Core service.

    The routes advertised to the on-premises network and the routes received from the on-premises network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ipsec_connection_tunnel_routes = oci.Core.get_ipsec_connection_tunnel_routes(ipsec_id=test_ipsec["id"],
        tunnel_id=test_tunnel["id"],
        advertiser=ipsec_connection_tunnel_route_advertiser)
    ```


    :param builtins.str advertiser: Specifies the advertiser of the routes. If set to `ORACLE`, this returns only the routes advertised by Oracle. When set to `CUSTOMER`, this returns only the routes advertised by the CPE.
    :param builtins.str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    :param builtins.str tunnel_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tunnel.
    """
    __args__ = dict()
    __args__['advertiser'] = advertiser
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getIpsecConnectionTunnelRoutes:getIpsecConnectionTunnelRoutes', __args__, opts=opts, typ=GetIpsecConnectionTunnelRoutesResult)
    return __ret__.apply(lambda __response__: GetIpsecConnectionTunnelRoutesResult(
        advertiser=pulumi.get(__response__, 'advertiser'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipsec_id=pulumi.get(__response__, 'ipsec_id'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id'),
        tunnel_routes=pulumi.get(__response__, 'tunnel_routes')))
