# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVcnsResult',
    'AwaitableGetVcnsResult',
    'get_vcns',
    'get_vcns_output',
]

@pulumi.output_type
class GetVcnsResult:
    """
    A collection of values returned by getVcns.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, virtual_networks=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if virtual_networks and not isinstance(virtual_networks, list):
            raise TypeError("Expected argument 'virtual_networks' to be a list")
        pulumi.set(__self__, "virtual_networks", virtual_networks)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the VCN.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVcnsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The VCN's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualNetworks")
    def virtual_networks(self) -> Sequence['outputs.GetVcnsVirtualNetworkResult']:
        """
        The list of virtual_networks.
        """
        return pulumi.get(self, "virtual_networks")


class AwaitableGetVcnsResult(GetVcnsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVcnsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            virtual_networks=self.virtual_networks)


def get_vcns(compartment_id: Optional[builtins.str] = None,
             display_name: Optional[builtins.str] = None,
             filters: Optional[Sequence[Union['GetVcnsFilterArgs', 'GetVcnsFilterArgsDict']]] = None,
             state: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVcnsResult:
    """
    This data source provides the list of Vcns in Oracle Cloud Infrastructure Core service.

    Lists the virtual cloud networks (VCNs) in the specified compartment.

    ## Supported Aliases

    * `core_get_virtual_networks`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vcns = oci.Core.get_vcns(compartment_id=compartment_id,
        display_name=vcn_display_name,
        state=vcn_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVcns:getVcns', __args__, opts=opts, typ=GetVcnsResult).value

    return AwaitableGetVcnsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        virtual_networks=pulumi.get(__ret__, 'virtual_networks'))
def get_vcns_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                    display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVcnsFilterArgs', 'GetVcnsFilterArgsDict']]]]] = None,
                    state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVcnsResult]:
    """
    This data source provides the list of Vcns in Oracle Cloud Infrastructure Core service.

    Lists the virtual cloud networks (VCNs) in the specified compartment.

    ## Supported Aliases

    * `core_get_virtual_networks`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vcns = oci.Core.get_vcns(compartment_id=compartment_id,
        display_name=vcn_display_name,
        state=vcn_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVcns:getVcns', __args__, opts=opts, typ=GetVcnsResult)
    return __ret__.apply(lambda __response__: GetVcnsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        virtual_networks=pulumi.get(__response__, 'virtual_networks')))
