# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabasePdbConversionHistoryEntriesResult',
    'AwaitableGetDatabasePdbConversionHistoryEntriesResult',
    'get_database_pdb_conversion_history_entries',
    'get_database_pdb_conversion_history_entries_output',
]

@pulumi.output_type
class GetDatabasePdbConversionHistoryEntriesResult:
    """
    A collection of values returned by getDatabasePdbConversionHistoryEntries.
    """
    def __init__(__self__, database_id=None, filters=None, id=None, pdb_conversion_action=None, pdb_conversion_history_entries=None, state=None):
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pdb_conversion_action and not isinstance(pdb_conversion_action, str):
            raise TypeError("Expected argument 'pdb_conversion_action' to be a str")
        pulumi.set(__self__, "pdb_conversion_action", pdb_conversion_action)
        if pdb_conversion_history_entries and not isinstance(pdb_conversion_history_entries, list):
            raise TypeError("Expected argument 'pdb_conversion_history_entries' to be a list")
        pulumi.set(__self__, "pdb_conversion_history_entries", pdb_conversion_history_entries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> builtins.str:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabasePdbConversionHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pdbConversionAction")
    def pdb_conversion_action(self) -> Optional[builtins.str]:
        return pulumi.get(self, "pdb_conversion_action")

    @property
    @pulumi.getter(name="pdbConversionHistoryEntries")
    def pdb_conversion_history_entries(self) -> Sequence['outputs.GetDatabasePdbConversionHistoryEntriesPdbConversionHistoryEntryResult']:
        """
        The list of pdb_conversion_history_entries.
        """
        return pulumi.get(self, "pdb_conversion_history_entries")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Status of an operation performed during the conversion of a non-container database to a pluggable database.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatabasePdbConversionHistoryEntriesResult(GetDatabasePdbConversionHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasePdbConversionHistoryEntriesResult(
            database_id=self.database_id,
            filters=self.filters,
            id=self.id,
            pdb_conversion_action=self.pdb_conversion_action,
            pdb_conversion_history_entries=self.pdb_conversion_history_entries,
            state=self.state)


def get_database_pdb_conversion_history_entries(database_id: Optional[builtins.str] = None,
                                                filters: Optional[Sequence[Union['GetDatabasePdbConversionHistoryEntriesFilterArgs', 'GetDatabasePdbConversionHistoryEntriesFilterArgsDict']]] = None,
                                                pdb_conversion_action: Optional[builtins.str] = None,
                                                state: Optional[builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasePdbConversionHistoryEntriesResult:
    """
    This data source provides the list of Database Pdb Conversion History Entries in Oracle Cloud Infrastructure Database service.

    Gets the pluggable database conversion history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entries = oci.Database.get_database_pdb_conversion_history_entries(database_id=test_database["id"],
        pdb_conversion_action=database_pdb_conversion_history_entry_pdb_conversion_action,
        state=database_pdb_conversion_history_entry_state)
    ```


    :param builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str pdb_conversion_action: A filter to return only the pluggable database conversion history entries that match the specified conversion action. For example, you can use this filter to return only entries for the precheck operation.
    :param builtins.str state: A filter to return only the pluggable database conversion history entries that match the specified lifecycle state. For example, you can use this filter to return only entries in the "failed" lifecycle state.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    __args__['pdbConversionAction'] = pdb_conversion_action
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabasePdbConversionHistoryEntries:getDatabasePdbConversionHistoryEntries', __args__, opts=opts, typ=GetDatabasePdbConversionHistoryEntriesResult).value

    return AwaitableGetDatabasePdbConversionHistoryEntriesResult(
        database_id=pulumi.get(__ret__, 'database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        pdb_conversion_action=pulumi.get(__ret__, 'pdb_conversion_action'),
        pdb_conversion_history_entries=pulumi.get(__ret__, 'pdb_conversion_history_entries'),
        state=pulumi.get(__ret__, 'state'))
def get_database_pdb_conversion_history_entries_output(database_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabasePdbConversionHistoryEntriesFilterArgs', 'GetDatabasePdbConversionHistoryEntriesFilterArgsDict']]]]] = None,
                                                       pdb_conversion_action: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabasePdbConversionHistoryEntriesResult]:
    """
    This data source provides the list of Database Pdb Conversion History Entries in Oracle Cloud Infrastructure Database service.

    Gets the pluggable database conversion history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entries = oci.Database.get_database_pdb_conversion_history_entries(database_id=test_database["id"],
        pdb_conversion_action=database_pdb_conversion_history_entry_pdb_conversion_action,
        state=database_pdb_conversion_history_entry_state)
    ```


    :param builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str pdb_conversion_action: A filter to return only the pluggable database conversion history entries that match the specified conversion action. For example, you can use this filter to return only entries for the precheck operation.
    :param builtins.str state: A filter to return only the pluggable database conversion history entries that match the specified lifecycle state. For example, you can use this filter to return only entries in the "failed" lifecycle state.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    __args__['pdbConversionAction'] = pdb_conversion_action
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDatabasePdbConversionHistoryEntries:getDatabasePdbConversionHistoryEntries', __args__, opts=opts, typ=GetDatabasePdbConversionHistoryEntriesResult)
    return __ret__.apply(lambda __response__: GetDatabasePdbConversionHistoryEntriesResult(
        database_id=pulumi.get(__response__, 'database_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        pdb_conversion_action=pulumi.get(__response__, 'pdb_conversion_action'),
        pdb_conversion_history_entries=pulumi.get(__response__, 'pdb_conversion_history_entries'),
        state=pulumi.get(__response__, 'state')))
