# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbHomesResult',
    'AwaitableGetDbHomesResult',
    'get_db_homes',
    'get_db_homes_output',
]

@pulumi.output_type
class GetDbHomesResult:
    """
    A collection of values returned by getDbHomes.
    """
    def __init__(__self__, backup_id=None, compartment_id=None, db_homes=None, db_system_id=None, db_version=None, display_name=None, filters=None, id=None, state=None, vm_cluster_id=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_homes and not isinstance(db_homes, list):
            raise TypeError("Expected argument 'db_homes' to be a list")
        pulumi.set(__self__, "db_homes", db_homes)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbHomes")
    def db_homes(self) -> Sequence['outputs.GetDbHomesDbHomeResult']:
        """
        The list of db_homes.
        """
        return pulumi.get(self, "db_homes")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[builtins.str]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-provided name for the Database Home. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbHomesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Database Home.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetDbHomesResult(GetDbHomesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbHomesResult(
            backup_id=self.backup_id,
            compartment_id=self.compartment_id,
            db_homes=self.db_homes,
            db_system_id=self.db_system_id,
            db_version=self.db_version,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vm_cluster_id=self.vm_cluster_id)


def get_db_homes(backup_id: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 db_system_id: Optional[builtins.str] = None,
                 db_version: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 filters: Optional[Sequence[Union['GetDbHomesFilterArgs', 'GetDbHomesFilterArgsDict']]] = None,
                 state: Optional[builtins.str] = None,
                 vm_cluster_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbHomesResult:
    """
    This data source provides the list of Db Homes in Oracle Cloud Infrastructure Database service.

    Lists the Database Homes in the specified DB system and compartment. A Database Home is a directory where Oracle Database software is installed.


    :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup. Specify a backupId to list only the DB systems or DB homes that support creating a database using this backup in this compartment.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). If provided, filters the results to the set of database versions which are supported for the DB system.
    :param builtins.str db_version: A filter to return only DB Homes that match the specified dbVersion.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param builtins.str vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['dbSystemId'] = db_system_id
    __args__['dbVersion'] = db_version
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbHomes:getDbHomes', __args__, opts=opts, typ=GetDbHomesResult).value

    return AwaitableGetDbHomesResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_homes=pulumi.get(__ret__, 'db_homes'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_version=pulumi.get(__ret__, 'db_version'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))
def get_db_homes_output(backup_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                        db_system_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        db_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbHomesFilterArgs', 'GetDbHomesFilterArgsDict']]]]] = None,
                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        vm_cluster_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbHomesResult]:
    """
    This data source provides the list of Db Homes in Oracle Cloud Infrastructure Database service.

    Lists the Database Homes in the specified DB system and compartment. A Database Home is a directory where Oracle Database software is installed.


    :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup. Specify a backupId to list only the DB systems or DB homes that support creating a database using this backup in this compartment.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). If provided, filters the results to the set of database versions which are supported for the DB system.
    :param builtins.str db_version: A filter to return only DB Homes that match the specified dbVersion.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param builtins.str vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['dbSystemId'] = db_system_id
    __args__['dbVersion'] = db_version
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbHomes:getDbHomes', __args__, opts=opts, typ=GetDbHomesResult)
    return __ret__.apply(lambda __response__: GetDbHomesResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_homes=pulumi.get(__response__, 'db_homes'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        db_version=pulumi.get(__response__, 'db_version'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id')))
