# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExadataInfrastructureUnAllocatedResourceResult',
    'AwaitableGetExadataInfrastructureUnAllocatedResourceResult',
    'get_exadata_infrastructure_un_allocated_resource',
    'get_exadata_infrastructure_un_allocated_resource_output',
]

@pulumi.output_type
class GetExadataInfrastructureUnAllocatedResourceResult:
    """
    A collection of values returned by getExadataInfrastructureUnAllocatedResource.
    """
    def __init__(__self__, autonomous_vm_clusters=None, db_servers=None, display_name=None, exadata_infrastructure_id=None, exadata_storage_in_tbs=None, id=None, local_storage_in_gbs=None, memory_in_gbs=None, ocpus=None):
        if autonomous_vm_clusters and not isinstance(autonomous_vm_clusters, list):
            raise TypeError("Expected argument 'autonomous_vm_clusters' to be a list")
        pulumi.set(__self__, "autonomous_vm_clusters", autonomous_vm_clusters)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if exadata_storage_in_tbs and not isinstance(exadata_storage_in_tbs, float):
            raise TypeError("Expected argument 'exadata_storage_in_tbs' to be a float")
        pulumi.set(__self__, "exadata_storage_in_tbs", exadata_storage_in_tbs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_storage_in_gbs and not isinstance(local_storage_in_gbs, int):
            raise TypeError("Expected argument 'local_storage_in_gbs' to be a int")
        pulumi.set(__self__, "local_storage_in_gbs", local_storage_in_gbs)
        if memory_in_gbs and not isinstance(memory_in_gbs, int):
            raise TypeError("Expected argument 'memory_in_gbs' to be a int")
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus and not isinstance(ocpus, int):
            raise TypeError("Expected argument 'ocpus' to be a int")
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="autonomousVmClusters")
    def autonomous_vm_clusters(self) -> Sequence['outputs.GetExadataInfrastructureUnAllocatedResourceAutonomousVmClusterResult']:
        """
        The list of Autonomous VM Clusters on the Infra and their associated unallocated resources details
        """
        return pulumi.get(self, "autonomous_vm_clusters")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> builtins.str:
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="exadataStorageInTbs")
    def exadata_storage_in_tbs(self) -> builtins.float:
        """
        Total unallocated exadata storage in the infrastructure in TBs.
        """
        return pulumi.get(self, "exadata_storage_in_tbs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localStorageInGbs")
    def local_storage_in_gbs(self) -> builtins.int:
        """
        The minimum amount of un allocated storage that is available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "local_storage_in_gbs")

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.int:
        """
        The minimum amount of un allocated memory that is available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.int:
        """
        The minimum amount of un allocated ocpus that is available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "ocpus")


class AwaitableGetExadataInfrastructureUnAllocatedResourceResult(GetExadataInfrastructureUnAllocatedResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadataInfrastructureUnAllocatedResourceResult(
            autonomous_vm_clusters=self.autonomous_vm_clusters,
            db_servers=self.db_servers,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            exadata_storage_in_tbs=self.exadata_storage_in_tbs,
            id=self.id,
            local_storage_in_gbs=self.local_storage_in_gbs,
            memory_in_gbs=self.memory_in_gbs,
            ocpus=self.ocpus)


def get_exadata_infrastructure_un_allocated_resource(db_servers: Optional[Sequence[builtins.str]] = None,
                                                     exadata_infrastructure_id: Optional[builtins.str] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadataInfrastructureUnAllocatedResourceResult:
    """
    This data source provides details about a specific Exadata Infrastructure Un Allocated Resource resource in Oracle Cloud Infrastructure Database service.

    Gets un allocated resources information for the specified Exadata infrastructure. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_infrastructure_un_allocated_resource = oci.Database.get_exadata_infrastructure_un_allocated_resource(exadata_infrastructure_id=test_exadata_infrastructure["id"],
        db_servers=exadata_infrastructure_un_allocated_resource_db_servers)
    ```


    :param Sequence[builtins.str] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbServers'] = db_servers
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExadataInfrastructureUnAllocatedResource:getExadataInfrastructureUnAllocatedResource', __args__, opts=opts, typ=GetExadataInfrastructureUnAllocatedResourceResult).value

    return AwaitableGetExadataInfrastructureUnAllocatedResourceResult(
        autonomous_vm_clusters=pulumi.get(__ret__, 'autonomous_vm_clusters'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        exadata_storage_in_tbs=pulumi.get(__ret__, 'exadata_storage_in_tbs'),
        id=pulumi.get(__ret__, 'id'),
        local_storage_in_gbs=pulumi.get(__ret__, 'local_storage_in_gbs'),
        memory_in_gbs=pulumi.get(__ret__, 'memory_in_gbs'),
        ocpus=pulumi.get(__ret__, 'ocpus'))
def get_exadata_infrastructure_un_allocated_resource_output(db_servers: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                            exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExadataInfrastructureUnAllocatedResourceResult]:
    """
    This data source provides details about a specific Exadata Infrastructure Un Allocated Resource resource in Oracle Cloud Infrastructure Database service.

    Gets un allocated resources information for the specified Exadata infrastructure. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_infrastructure_un_allocated_resource = oci.Database.get_exadata_infrastructure_un_allocated_resource(exadata_infrastructure_id=test_exadata_infrastructure["id"],
        db_servers=exadata_infrastructure_un_allocated_resource_db_servers)
    ```


    :param Sequence[builtins.str] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbServers'] = db_servers
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExadataInfrastructureUnAllocatedResource:getExadataInfrastructureUnAllocatedResource', __args__, opts=opts, typ=GetExadataInfrastructureUnAllocatedResourceResult)
    return __ret__.apply(lambda __response__: GetExadataInfrastructureUnAllocatedResourceResult(
        autonomous_vm_clusters=pulumi.get(__response__, 'autonomous_vm_clusters'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        exadata_storage_in_tbs=pulumi.get(__response__, 'exadata_storage_in_tbs'),
        id=pulumi.get(__response__, 'id'),
        local_storage_in_gbs=pulumi.get(__response__, 'local_storage_in_gbs'),
        memory_in_gbs=pulumi.get(__response__, 'memory_in_gbs'),
        ocpus=pulumi.get(__response__, 'ocpus')))
