# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClusterRecommendedNetworkResult',
    'AwaitableGetVmClusterRecommendedNetworkResult',
    'get_vm_cluster_recommended_network',
    'get_vm_cluster_recommended_network_output',
]

@pulumi.output_type
class GetVmClusterRecommendedNetworkResult:
    """
    A collection of values returned by getVmClusterRecommendedNetwork.
    """
    def __init__(__self__, compartment_id=None, db_servers=None, defined_tags=None, display_name=None, dns=None, dr_scan_listener_port_tcp=None, dr_scans=None, exadata_infrastructure_id=None, freeform_tags=None, id=None, networks=None, ntps=None, scan_listener_port_tcp=None, scan_listener_port_tcp_ssl=None, scans=None, vm_networks=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns and not isinstance(dns, list):
            raise TypeError("Expected argument 'dns' to be a list")
        pulumi.set(__self__, "dns", dns)
        if dr_scan_listener_port_tcp and not isinstance(dr_scan_listener_port_tcp, int):
            raise TypeError("Expected argument 'dr_scan_listener_port_tcp' to be a int")
        pulumi.set(__self__, "dr_scan_listener_port_tcp", dr_scan_listener_port_tcp)
        if dr_scans and not isinstance(dr_scans, list):
            raise TypeError("Expected argument 'dr_scans' to be a list")
        pulumi.set(__self__, "dr_scans", dr_scans)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if ntps and not isinstance(ntps, list):
            raise TypeError("Expected argument 'ntps' to be a list")
        pulumi.set(__self__, "ntps", ntps)
        if scan_listener_port_tcp and not isinstance(scan_listener_port_tcp, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl and not isinstance(scan_listener_port_tcp_ssl, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp_ssl' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if scans and not isinstance(scans, list):
            raise TypeError("Expected argument 'scans' to be a list")
        pulumi.set(__self__, "scans", scans)
        if vm_networks and not isinstance(vm_networks, list):
            raise TypeError("Expected argument 'vm_networks' to be a list")
        pulumi.set(__self__, "vm_networks", vm_networks)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def dns(self) -> Sequence[builtins.str]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="drScanListenerPortTcp")
    def dr_scan_listener_port_tcp(self) -> Optional[builtins.int]:
        return pulumi.get(self, "dr_scan_listener_port_tcp")

    @property
    @pulumi.getter(name="drScans")
    def dr_scans(self) -> Sequence['outputs.GetVmClusterRecommendedNetworkDrScanResult']:
        """
        The SCAN details for DR network
        """
        return pulumi.get(self, "dr_scans")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> builtins.str:
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetVmClusterRecommendedNetworkNetworkResult']:
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def ntps(self) -> Sequence[builtins.str]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntps")

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[builtins.int]:
        """
        The SCAN TCPIP port. Default is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> Optional[builtins.int]:
        """
        The SCAN TCPIP SSL port. Default is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @property
    @pulumi.getter
    def scans(self) -> Sequence['outputs.GetVmClusterRecommendedNetworkScanResult']:
        """
        The SCAN details.
        """
        return pulumi.get(self, "scans")

    @property
    @pulumi.getter(name="vmNetworks")
    def vm_networks(self) -> Sequence['outputs.GetVmClusterRecommendedNetworkVmNetworkResult']:
        """
        Details of the client and backup networks.
        """
        return pulumi.get(self, "vm_networks")


class AwaitableGetVmClusterRecommendedNetworkResult(GetVmClusterRecommendedNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterRecommendedNetworkResult(
            compartment_id=self.compartment_id,
            db_servers=self.db_servers,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dns=self.dns,
            dr_scan_listener_port_tcp=self.dr_scan_listener_port_tcp,
            dr_scans=self.dr_scans,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            networks=self.networks,
            ntps=self.ntps,
            scan_listener_port_tcp=self.scan_listener_port_tcp,
            scan_listener_port_tcp_ssl=self.scan_listener_port_tcp_ssl,
            scans=self.scans,
            vm_networks=self.vm_networks)


def get_vm_cluster_recommended_network(compartment_id: Optional[builtins.str] = None,
                                       db_servers: Optional[Sequence[builtins.str]] = None,
                                       defined_tags: Optional[Mapping[str, builtins.str]] = None,
                                       display_name: Optional[builtins.str] = None,
                                       dns: Optional[Sequence[builtins.str]] = None,
                                       dr_scan_listener_port_tcp: Optional[builtins.int] = None,
                                       exadata_infrastructure_id: Optional[builtins.str] = None,
                                       freeform_tags: Optional[Mapping[str, builtins.str]] = None,
                                       networks: Optional[Sequence[Union['GetVmClusterRecommendedNetworkNetworkArgs', 'GetVmClusterRecommendedNetworkNetworkArgsDict']]] = None,
                                       ntps: Optional[Sequence[builtins.str]] = None,
                                       scan_listener_port_tcp: Optional[builtins.int] = None,
                                       scan_listener_port_tcp_ssl: Optional[builtins.int] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterRecommendedNetworkResult:
    """
    This data source provides details about a specific Vm Cluster Recommended Network resource in Oracle Cloud Infrastructure Database service.

    Generates a recommended Cloud@Customer VM cluster network configuration.


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param Sequence[builtins.str] db_servers: The list of Db server Ids to configure network.
    :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
    :param builtins.str display_name: The user-friendly name for the VM cluster network. The name does not need to be unique.
    :param Sequence[builtins.str] dns: The list of DNS server IP addresses. Maximum of 3 allowed.
    :param builtins.int dr_scan_listener_port_tcp: The DR SCAN TCPIP port. Default is 1521.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
    :param Sequence[Union['GetVmClusterRecommendedNetworkNetworkArgs', 'GetVmClusterRecommendedNetworkNetworkArgsDict']] networks: List of parameters for generation of the client and backup networks.
    :param Sequence[builtins.str] ntps: The list of NTP server IP addresses. Maximum of 3 allowed.
    :param builtins.int scan_listener_port_tcp: The SCAN TCPIP port. Default is 1521.
    :param builtins.int scan_listener_port_tcp_ssl: The SCAN TCPIP SSL port. Default is 2484.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbServers'] = db_servers
    __args__['definedTags'] = defined_tags
    __args__['displayName'] = display_name
    __args__['dns'] = dns
    __args__['drScanListenerPortTcp'] = dr_scan_listener_port_tcp
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['freeformTags'] = freeform_tags
    __args__['networks'] = networks
    __args__['ntps'] = ntps
    __args__['scanListenerPortTcp'] = scan_listener_port_tcp
    __args__['scanListenerPortTcpSsl'] = scan_listener_port_tcp_ssl
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterRecommendedNetwork:getVmClusterRecommendedNetwork', __args__, opts=opts, typ=GetVmClusterRecommendedNetworkResult).value

    return AwaitableGetVmClusterRecommendedNetworkResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns=pulumi.get(__ret__, 'dns'),
        dr_scan_listener_port_tcp=pulumi.get(__ret__, 'dr_scan_listener_port_tcp'),
        dr_scans=pulumi.get(__ret__, 'dr_scans'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        networks=pulumi.get(__ret__, 'networks'),
        ntps=pulumi.get(__ret__, 'ntps'),
        scan_listener_port_tcp=pulumi.get(__ret__, 'scan_listener_port_tcp'),
        scan_listener_port_tcp_ssl=pulumi.get(__ret__, 'scan_listener_port_tcp_ssl'),
        scans=pulumi.get(__ret__, 'scans'),
        vm_networks=pulumi.get(__ret__, 'vm_networks'))
def get_vm_cluster_recommended_network_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                              db_servers: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                              defined_tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                              display_name: Optional[pulumi.Input[builtins.str]] = None,
                                              dns: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                              dr_scan_listener_port_tcp: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                              exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                                              freeform_tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                              networks: Optional[pulumi.Input[Sequence[Union['GetVmClusterRecommendedNetworkNetworkArgs', 'GetVmClusterRecommendedNetworkNetworkArgsDict']]]] = None,
                                              ntps: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                              scan_listener_port_tcp: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                              scan_listener_port_tcp_ssl: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmClusterRecommendedNetworkResult]:
    """
    This data source provides details about a specific Vm Cluster Recommended Network resource in Oracle Cloud Infrastructure Database service.

    Generates a recommended Cloud@Customer VM cluster network configuration.


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param Sequence[builtins.str] db_servers: The list of Db server Ids to configure network.
    :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
    :param builtins.str display_name: The user-friendly name for the VM cluster network. The name does not need to be unique.
    :param Sequence[builtins.str] dns: The list of DNS server IP addresses. Maximum of 3 allowed.
    :param builtins.int dr_scan_listener_port_tcp: The DR SCAN TCPIP port. Default is 1521.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
    :param Sequence[Union['GetVmClusterRecommendedNetworkNetworkArgs', 'GetVmClusterRecommendedNetworkNetworkArgsDict']] networks: List of parameters for generation of the client and backup networks.
    :param Sequence[builtins.str] ntps: The list of NTP server IP addresses. Maximum of 3 allowed.
    :param builtins.int scan_listener_port_tcp: The SCAN TCPIP port. Default is 1521.
    :param builtins.int scan_listener_port_tcp_ssl: The SCAN TCPIP SSL port. Default is 2484.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbServers'] = db_servers
    __args__['definedTags'] = defined_tags
    __args__['displayName'] = display_name
    __args__['dns'] = dns
    __args__['drScanListenerPortTcp'] = dr_scan_listener_port_tcp
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['freeformTags'] = freeform_tags
    __args__['networks'] = networks
    __args__['ntps'] = ntps
    __args__['scanListenerPortTcp'] = scan_listener_port_tcp
    __args__['scanListenerPortTcpSsl'] = scan_listener_port_tcp_ssl
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmClusterRecommendedNetwork:getVmClusterRecommendedNetwork', __args__, opts=opts, typ=GetVmClusterRecommendedNetworkResult)
    return __ret__.apply(lambda __response__: GetVmClusterRecommendedNetworkResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        dns=pulumi.get(__response__, 'dns'),
        dr_scan_listener_port_tcp=pulumi.get(__response__, 'dr_scan_listener_port_tcp'),
        dr_scans=pulumi.get(__response__, 'dr_scans'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        networks=pulumi.get(__response__, 'networks'),
        ntps=pulumi.get(__response__, 'ntps'),
        scan_listener_port_tcp=pulumi.get(__response__, 'scan_listener_port_tcp'),
        scan_listener_port_tcp_ssl=pulumi.get(__response__, 'scan_listener_port_tcp_ssl'),
        scans=pulumi.get(__response__, 'scans'),
        vm_networks=pulumi.get(__response__, 'vm_networks')))
