# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalMySqlDatabaseConnectorArgs', 'ExternalMySqlDatabaseConnector']

@pulumi.input_type
class ExternalMySqlDatabaseConnectorArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 connector_details: pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs'],
                 is_test_connection_param: pulumi.Input[builtins.bool],
                 check_connection_status_trigger: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ExternalMySqlDatabaseConnector resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID of compartment for the External MySQL Database.
        :param pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs'] connector_details: (Updatable) Create Details of external database connector.
        :param pulumi.Input[builtins.bool] is_test_connection_param: Parameter indicating whether database connection needs to be tested.
        :param pulumi.Input[builtins.int] check_connection_status_trigger: (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connector_details", connector_details)
        pulumi.set(__self__, "is_test_connection_param", is_test_connection_param)
        if check_connection_status_trigger is not None:
            pulumi.set(__self__, "check_connection_status_trigger", check_connection_status_trigger)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) OCID of compartment for the External MySQL Database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectorDetails")
    def connector_details(self) -> pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs']:
        """
        (Updatable) Create Details of external database connector.
        """
        return pulumi.get(self, "connector_details")

    @connector_details.setter
    def connector_details(self, value: pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs']):
        pulumi.set(self, "connector_details", value)

    @property
    @pulumi.getter(name="isTestConnectionParam")
    def is_test_connection_param(self) -> pulumi.Input[builtins.bool]:
        """
        Parameter indicating whether database connection needs to be tested.
        """
        return pulumi.get(self, "is_test_connection_param")

    @is_test_connection_param.setter
    def is_test_connection_param(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_test_connection_param", value)

    @property
    @pulumi.getter(name="checkConnectionStatusTrigger")
    def check_connection_status_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "check_connection_status_trigger")

    @check_connection_status_trigger.setter
    def check_connection_status_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "check_connection_status_trigger", value)


@pulumi.input_type
class _ExternalMySqlDatabaseConnectorState:
    def __init__(__self__, *,
                 associated_services: Optional[pulumi.Input[builtins.str]] = None,
                 check_connection_status_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_status: Optional[pulumi.Input[builtins.str]] = None,
                 connector_details: Optional[pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs']] = None,
                 connector_type: Optional[pulumi.Input[builtins.str]] = None,
                 credential_type: Optional[pulumi.Input[builtins.str]] = None,
                 external_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_test_connection_param: Optional[pulumi.Input[builtins.bool]] = None,
                 macs_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 source_database: Optional[pulumi.Input[builtins.str]] = None,
                 source_database_type: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_connection_status_updated: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalMySqlDatabaseConnector resources.
        :param pulumi.Input[builtins.str] associated_services: Oracle Cloud Infrastructure Services associated with this connector.
        :param pulumi.Input[builtins.int] check_connection_status_trigger: (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID of compartment for the External MySQL Database.
        :param pulumi.Input[builtins.str] connection_status: Connection Status
        :param pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs'] connector_details: (Updatable) Create Details of external database connector.
        :param pulumi.Input[builtins.str] connector_type: Connector Type.
        :param pulumi.Input[builtins.str] credential_type: Credential type used to connect to database.
        :param pulumi.Input[builtins.str] external_database_id: OCID of MySQL Database resource
        :param pulumi.Input[builtins.str] host_name: Host name for Connector.
        :param pulumi.Input[builtins.bool] is_test_connection_param: Parameter indicating whether database connection needs to be tested.
        :param pulumi.Input[builtins.str] macs_agent_id: Agent Id of the MACS agent.
        :param pulumi.Input[builtins.str] name: External MySQL Database Connector Name.
        :param pulumi.Input[builtins.str] network_protocol: Network Protocol.
        :param pulumi.Input[builtins.int] port: Connector port.
        :param pulumi.Input[builtins.str] source_database: Name of MySQL Database.
        :param pulumi.Input[builtins.str] source_database_type: Type of MySQL Database.
        :param pulumi.Input[builtins.str] ssl_secret_id: OCID of the SSL secret, if TCPS with SSL is used to connect to database.
        :param pulumi.Input[builtins.str] ssl_secret_name: Name of the SSL secret, if TCPS with SSL is used to connect to database.
        :param pulumi.Input[builtins.str] state: Indicates lifecycle  state of the resource.
        :param pulumi.Input[builtins.str] time_connection_status_updated: Time when connection status was last updated.
        :param pulumi.Input[builtins.str] time_created: Connector creation time.
        :param pulumi.Input[builtins.str] time_updated: Connector update time.
        """
        if associated_services is not None:
            pulumi.set(__self__, "associated_services", associated_services)
        if check_connection_status_trigger is not None:
            pulumi.set(__self__, "check_connection_status_trigger", check_connection_status_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if connector_details is not None:
            pulumi.set(__self__, "connector_details", connector_details)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if external_database_id is not None:
            pulumi.set(__self__, "external_database_id", external_database_id)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if is_test_connection_param is not None:
            pulumi.set(__self__, "is_test_connection_param", is_test_connection_param)
        if macs_agent_id is not None:
            pulumi.set(__self__, "macs_agent_id", macs_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_protocol is not None:
            pulumi.set(__self__, "network_protocol", network_protocol)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_database is not None:
            pulumi.set(__self__, "source_database", source_database)
        if source_database_type is not None:
            pulumi.set(__self__, "source_database_type", source_database_type)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)
        if ssl_secret_name is not None:
            pulumi.set(__self__, "ssl_secret_name", ssl_secret_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_connection_status_updated is not None:
            pulumi.set(__self__, "time_connection_status_updated", time_connection_status_updated)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="associatedServices")
    def associated_services(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Oracle Cloud Infrastructure Services associated with this connector.
        """
        return pulumi.get(self, "associated_services")

    @associated_services.setter
    def associated_services(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "associated_services", value)

    @property
    @pulumi.getter(name="checkConnectionStatusTrigger")
    def check_connection_status_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "check_connection_status_trigger")

    @check_connection_status_trigger.setter
    def check_connection_status_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "check_connection_status_trigger", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) OCID of compartment for the External MySQL Database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connection Status
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="connectorDetails")
    def connector_details(self) -> Optional[pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs']]:
        """
        (Updatable) Create Details of external database connector.
        """
        return pulumi.get(self, "connector_details")

    @connector_details.setter
    def connector_details(self, value: Optional[pulumi.Input['ExternalMySqlDatabaseConnectorConnectorDetailsArgs']]):
        pulumi.set(self, "connector_details", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connector Type.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credential type used to connect to database.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of MySQL Database resource
        """
        return pulumi.get(self, "external_database_id")

    @external_database_id.setter
    def external_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_database_id", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host name for Connector.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="isTestConnectionParam")
    def is_test_connection_param(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Parameter indicating whether database connection needs to be tested.
        """
        return pulumi.get(self, "is_test_connection_param")

    @is_test_connection_param.setter
    def is_test_connection_param(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_test_connection_param", value)

    @property
    @pulumi.getter(name="macsAgentId")
    def macs_agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Agent Id of the MACS agent.
        """
        return pulumi.get(self, "macs_agent_id")

    @macs_agent_id.setter
    def macs_agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "macs_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        External MySQL Database Connector Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProtocol")
    def network_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network Protocol.
        """
        return pulumi.get(self, "network_protocol")

    @network_protocol.setter
    def network_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_protocol", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Connector port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sourceDatabase")
    def source_database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of MySQL Database.
        """
        return pulumi.get(self, "source_database")

    @source_database.setter
    def source_database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_database", value)

    @property
    @pulumi.getter(name="sourceDatabaseType")
    def source_database_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of MySQL Database.
        """
        return pulumi.get(self, "source_database_type")

    @source_database_type.setter
    def source_database_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_database_type", value)

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_secret_id", value)

    @property
    @pulumi.getter(name="sslSecretName")
    def ssl_secret_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_name")

    @ssl_secret_name.setter
    def ssl_secret_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_secret_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates lifecycle  state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeConnectionStatusUpdated")
    def time_connection_status_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when connection status was last updated.
        """
        return pulumi.get(self, "time_connection_status_updated")

    @time_connection_status_updated.setter
    def time_connection_status_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_connection_status_updated", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connector creation time.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connector update time.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class ExternalMySqlDatabaseConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_connection_status_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connector_details: Optional[pulumi.Input[Union['ExternalMySqlDatabaseConnectorConnectorDetailsArgs', 'ExternalMySqlDatabaseConnectorConnectorDetailsArgsDict']]] = None,
                 is_test_connection_param: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the External My Sql Database Connector resource in Oracle Cloud Infrastructure Database Management service.

        Creates an external MySQL connector resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_my_sql_database_connector = oci.database_management.ExternalMySqlDatabaseConnector("test_external_my_sql_database_connector",
            compartment_id=compartment_id,
            connector_details={
                "credential_type": external_my_sql_database_connector_connector_details_credential_type,
                "display_name": external_my_sql_database_connector_connector_details_display_name,
                "external_database_id": test_external_database["id"],
                "host_name": external_my_sql_database_connector_connector_details_host_name,
                "macs_agent_id": test_agent["id"],
                "network_protocol": external_my_sql_database_connector_connector_details_network_protocol,
                "port": external_my_sql_database_connector_connector_details_port,
                "ssl_secret_id": test_secret["id"],
            },
            is_test_connection_param=external_my_sql_database_connector_is_test_connection_param)
        ```

        ## Import

        ExternalMySqlDatabaseConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalMySqlDatabaseConnector:ExternalMySqlDatabaseConnector test_external_my_sql_database_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] check_connection_status_trigger: (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID of compartment for the External MySQL Database.
        :param pulumi.Input[Union['ExternalMySqlDatabaseConnectorConnectorDetailsArgs', 'ExternalMySqlDatabaseConnectorConnectorDetailsArgsDict']] connector_details: (Updatable) Create Details of external database connector.
        :param pulumi.Input[builtins.bool] is_test_connection_param: Parameter indicating whether database connection needs to be tested.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalMySqlDatabaseConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External My Sql Database Connector resource in Oracle Cloud Infrastructure Database Management service.

        Creates an external MySQL connector resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_my_sql_database_connector = oci.database_management.ExternalMySqlDatabaseConnector("test_external_my_sql_database_connector",
            compartment_id=compartment_id,
            connector_details={
                "credential_type": external_my_sql_database_connector_connector_details_credential_type,
                "display_name": external_my_sql_database_connector_connector_details_display_name,
                "external_database_id": test_external_database["id"],
                "host_name": external_my_sql_database_connector_connector_details_host_name,
                "macs_agent_id": test_agent["id"],
                "network_protocol": external_my_sql_database_connector_connector_details_network_protocol,
                "port": external_my_sql_database_connector_connector_details_port,
                "ssl_secret_id": test_secret["id"],
            },
            is_test_connection_param=external_my_sql_database_connector_is_test_connection_param)
        ```

        ## Import

        ExternalMySqlDatabaseConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalMySqlDatabaseConnector:ExternalMySqlDatabaseConnector test_external_my_sql_database_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalMySqlDatabaseConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalMySqlDatabaseConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_connection_status_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connector_details: Optional[pulumi.Input[Union['ExternalMySqlDatabaseConnectorConnectorDetailsArgs', 'ExternalMySqlDatabaseConnectorConnectorDetailsArgsDict']]] = None,
                 is_test_connection_param: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalMySqlDatabaseConnectorArgs.__new__(ExternalMySqlDatabaseConnectorArgs)

            __props__.__dict__["check_connection_status_trigger"] = check_connection_status_trigger
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if connector_details is None and not opts.urn:
                raise TypeError("Missing required property 'connector_details'")
            __props__.__dict__["connector_details"] = connector_details
            if is_test_connection_param is None and not opts.urn:
                raise TypeError("Missing required property 'is_test_connection_param'")
            __props__.__dict__["is_test_connection_param"] = is_test_connection_param
            __props__.__dict__["associated_services"] = None
            __props__.__dict__["connection_status"] = None
            __props__.__dict__["connector_type"] = None
            __props__.__dict__["credential_type"] = None
            __props__.__dict__["external_database_id"] = None
            __props__.__dict__["host_name"] = None
            __props__.__dict__["macs_agent_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["network_protocol"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["source_database"] = None
            __props__.__dict__["source_database_type"] = None
            __props__.__dict__["ssl_secret_id"] = None
            __props__.__dict__["ssl_secret_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_connection_status_updated"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ExternalMySqlDatabaseConnector, __self__).__init__(
            'oci:DatabaseManagement/externalMySqlDatabaseConnector:ExternalMySqlDatabaseConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_services: Optional[pulumi.Input[builtins.str]] = None,
            check_connection_status_trigger: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_status: Optional[pulumi.Input[builtins.str]] = None,
            connector_details: Optional[pulumi.Input[Union['ExternalMySqlDatabaseConnectorConnectorDetailsArgs', 'ExternalMySqlDatabaseConnectorConnectorDetailsArgsDict']]] = None,
            connector_type: Optional[pulumi.Input[builtins.str]] = None,
            credential_type: Optional[pulumi.Input[builtins.str]] = None,
            external_database_id: Optional[pulumi.Input[builtins.str]] = None,
            host_name: Optional[pulumi.Input[builtins.str]] = None,
            is_test_connection_param: Optional[pulumi.Input[builtins.bool]] = None,
            macs_agent_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_protocol: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            source_database: Optional[pulumi.Input[builtins.str]] = None,
            source_database_type: Optional[pulumi.Input[builtins.str]] = None,
            ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None,
            ssl_secret_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_connection_status_updated: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ExternalMySqlDatabaseConnector':
        """
        Get an existing ExternalMySqlDatabaseConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] associated_services: Oracle Cloud Infrastructure Services associated with this connector.
        :param pulumi.Input[builtins.int] check_connection_status_trigger: (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID of compartment for the External MySQL Database.
        :param pulumi.Input[builtins.str] connection_status: Connection Status
        :param pulumi.Input[Union['ExternalMySqlDatabaseConnectorConnectorDetailsArgs', 'ExternalMySqlDatabaseConnectorConnectorDetailsArgsDict']] connector_details: (Updatable) Create Details of external database connector.
        :param pulumi.Input[builtins.str] connector_type: Connector Type.
        :param pulumi.Input[builtins.str] credential_type: Credential type used to connect to database.
        :param pulumi.Input[builtins.str] external_database_id: OCID of MySQL Database resource
        :param pulumi.Input[builtins.str] host_name: Host name for Connector.
        :param pulumi.Input[builtins.bool] is_test_connection_param: Parameter indicating whether database connection needs to be tested.
        :param pulumi.Input[builtins.str] macs_agent_id: Agent Id of the MACS agent.
        :param pulumi.Input[builtins.str] name: External MySQL Database Connector Name.
        :param pulumi.Input[builtins.str] network_protocol: Network Protocol.
        :param pulumi.Input[builtins.int] port: Connector port.
        :param pulumi.Input[builtins.str] source_database: Name of MySQL Database.
        :param pulumi.Input[builtins.str] source_database_type: Type of MySQL Database.
        :param pulumi.Input[builtins.str] ssl_secret_id: OCID of the SSL secret, if TCPS with SSL is used to connect to database.
        :param pulumi.Input[builtins.str] ssl_secret_name: Name of the SSL secret, if TCPS with SSL is used to connect to database.
        :param pulumi.Input[builtins.str] state: Indicates lifecycle  state of the resource.
        :param pulumi.Input[builtins.str] time_connection_status_updated: Time when connection status was last updated.
        :param pulumi.Input[builtins.str] time_created: Connector creation time.
        :param pulumi.Input[builtins.str] time_updated: Connector update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalMySqlDatabaseConnectorState.__new__(_ExternalMySqlDatabaseConnectorState)

        __props__.__dict__["associated_services"] = associated_services
        __props__.__dict__["check_connection_status_trigger"] = check_connection_status_trigger
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["connector_details"] = connector_details
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["external_database_id"] = external_database_id
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["is_test_connection_param"] = is_test_connection_param
        __props__.__dict__["macs_agent_id"] = macs_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_protocol"] = network_protocol
        __props__.__dict__["port"] = port
        __props__.__dict__["source_database"] = source_database
        __props__.__dict__["source_database_type"] = source_database_type
        __props__.__dict__["ssl_secret_id"] = ssl_secret_id
        __props__.__dict__["ssl_secret_name"] = ssl_secret_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_connection_status_updated"] = time_connection_status_updated
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ExternalMySqlDatabaseConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedServices")
    def associated_services(self) -> pulumi.Output[builtins.str]:
        """
        Oracle Cloud Infrastructure Services associated with this connector.
        """
        return pulumi.get(self, "associated_services")

    @property
    @pulumi.getter(name="checkConnectionStatusTrigger")
    def check_connection_status_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Check Connection Status. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "check_connection_status_trigger")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) OCID of compartment for the External MySQL Database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[builtins.str]:
        """
        Connection Status
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="connectorDetails")
    def connector_details(self) -> pulumi.Output['outputs.ExternalMySqlDatabaseConnectorConnectorDetails']:
        """
        (Updatable) Create Details of external database connector.
        """
        return pulumi.get(self, "connector_details")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[builtins.str]:
        """
        Connector Type.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[builtins.str]:
        """
        Credential type used to connect to database.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of MySQL Database resource
        """
        return pulumi.get(self, "external_database_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[builtins.str]:
        """
        Host name for Connector.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="isTestConnectionParam")
    def is_test_connection_param(self) -> pulumi.Output[builtins.bool]:
        """
        Parameter indicating whether database connection needs to be tested.
        """
        return pulumi.get(self, "is_test_connection_param")

    @property
    @pulumi.getter(name="macsAgentId")
    def macs_agent_id(self) -> pulumi.Output[builtins.str]:
        """
        Agent Id of the MACS agent.
        """
        return pulumi.get(self, "macs_agent_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        External MySQL Database Connector Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProtocol")
    def network_protocol(self) -> pulumi.Output[builtins.str]:
        """
        Network Protocol.
        """
        return pulumi.get(self, "network_protocol")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        Connector port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceDatabase")
    def source_database(self) -> pulumi.Output[builtins.str]:
        """
        Name of MySQL Database.
        """
        return pulumi.get(self, "source_database")

    @property
    @pulumi.getter(name="sourceDatabaseType")
    def source_database_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of MySQL Database.
        """
        return pulumi.get(self, "source_database_type")

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_id")

    @property
    @pulumi.getter(name="sslSecretName")
    def ssl_secret_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Indicates lifecycle  state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeConnectionStatusUpdated")
    def time_connection_status_updated(self) -> pulumi.Output[builtins.str]:
        """
        Time when connection status was last updated.
        """
        return pulumi.get(self, "time_connection_status_updated")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Connector creation time.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Connector update time.
        """
        return pulumi.get(self, "time_updated")

