# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobExecutionsStatusResult',
    'AwaitableGetJobExecutionsStatusResult',
    'get_job_executions_status',
    'get_job_executions_status_output',
]

@pulumi.output_type
class GetJobExecutionsStatusResult:
    """
    A collection of values returned by getJobExecutionsStatus.
    """
    def __init__(__self__, compartment_id=None, end_time=None, id=None, items=None, managed_database_group_id=None, managed_database_id=None, name=None, start_time=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if managed_database_group_id and not isinstance(managed_database_group_id, str):
            raise TypeError("Expected argument 'managed_database_group_id' to be a str")
        pulumi.set(__self__, "managed_database_group_id", managed_database_group_id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetJobExecutionsStatusItemResult']:
        """
        A list of JobExecutionsSummary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="managedDatabaseGroupId")
    def managed_database_group_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "managed_database_group_id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        return pulumi.get(self, "start_time")


class AwaitableGetJobExecutionsStatusResult(GetJobExecutionsStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobExecutionsStatusResult(
            compartment_id=self.compartment_id,
            end_time=self.end_time,
            id=self.id,
            items=self.items,
            managed_database_group_id=self.managed_database_group_id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            start_time=self.start_time)


def get_job_executions_status(compartment_id: Optional[builtins.str] = None,
                              end_time: Optional[builtins.str] = None,
                              id: Optional[builtins.str] = None,
                              managed_database_group_id: Optional[builtins.str] = None,
                              managed_database_id: Optional[builtins.str] = None,
                              name: Optional[builtins.str] = None,
                              start_time: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobExecutionsStatusResult:
    """
    This data source provides details about a specific Job Executions Status resource in Oracle Cloud Infrastructure Database Management service.

    Gets the number of job executions grouped by status for a job, Managed Database, or Database Group in a specific compartment. Only one of the parameters, jobId, managedDatabaseId, or managedDatabaseGroupId should be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_executions_status = oci.DatabaseManagement.get_job_executions_status(compartment_id=compartment_id,
        end_time=job_executions_status_end_time,
        start_time=job_executions_status_start_time,
        id=job_executions_status_id,
        managed_database_group_id=test_managed_database_group["id"],
        managed_database_id=test_managed_database["id"],
        name=job_executions_status_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str end_time: The end time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param builtins.str id: The identifier of the resource.
    :param builtins.str managed_database_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database Group.
    :param builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param builtins.str name: A filter to return only resources that match the entire name.
    :param builtins.str start_time: The start time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['endTime'] = end_time
    __args__['id'] = id
    __args__['managedDatabaseGroupId'] = managed_database_group_id
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getJobExecutionsStatus:getJobExecutionsStatus', __args__, opts=opts, typ=GetJobExecutionsStatusResult).value

    return AwaitableGetJobExecutionsStatusResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        managed_database_group_id=pulumi.get(__ret__, 'managed_database_group_id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        start_time=pulumi.get(__ret__, 'start_time'))
def get_job_executions_status_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                     end_time: Optional[pulumi.Input[builtins.str]] = None,
                                     id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     managed_database_group_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     managed_database_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     start_time: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobExecutionsStatusResult]:
    """
    This data source provides details about a specific Job Executions Status resource in Oracle Cloud Infrastructure Database Management service.

    Gets the number of job executions grouped by status for a job, Managed Database, or Database Group in a specific compartment. Only one of the parameters, jobId, managedDatabaseId, or managedDatabaseGroupId should be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_executions_status = oci.DatabaseManagement.get_job_executions_status(compartment_id=compartment_id,
        end_time=job_executions_status_end_time,
        start_time=job_executions_status_start_time,
        id=job_executions_status_id,
        managed_database_group_id=test_managed_database_group["id"],
        managed_database_id=test_managed_database["id"],
        name=job_executions_status_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str end_time: The end time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param builtins.str id: The identifier of the resource.
    :param builtins.str managed_database_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database Group.
    :param builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param builtins.str name: A filter to return only resources that match the entire name.
    :param builtins.str start_time: The start time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['endTime'] = end_time
    __args__['id'] = id
    __args__['managedDatabaseGroupId'] = managed_database_group_id
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getJobExecutionsStatus:getJobExecutionsStatus', __args__, opts=opts, typ=GetJobExecutionsStatusResult)
    return __ret__.apply(lambda __response__: GetJobExecutionsStatusResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        managed_database_group_id=pulumi.get(__response__, 'managed_database_group_id'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        name=pulumi.get(__response__, 'name'),
        start_time=pulumi.get(__response__, 'start_time')))
