# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedMySqlDatabasesResult',
    'AwaitableGetManagedMySqlDatabasesResult',
    'get_managed_my_sql_databases',
    'get_managed_my_sql_databases_output',
]

@pulumi.output_type
class GetManagedMySqlDatabasesResult:
    """
    A collection of values returned by getManagedMySqlDatabases.
    """
    def __init__(__self__, compartment_id=None, filter_by_my_sql_database_type_param=None, filters=None, id=None, managed_my_sql_database_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filter_by_my_sql_database_type_param and not isinstance(filter_by_my_sql_database_type_param, str):
            raise TypeError("Expected argument 'filter_by_my_sql_database_type_param' to be a str")
        pulumi.set(__self__, "filter_by_my_sql_database_type_param", filter_by_my_sql_database_type_param)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_my_sql_database_collections and not isinstance(managed_my_sql_database_collections, list):
            raise TypeError("Expected argument 'managed_my_sql_database_collections' to be a list")
        pulumi.set(__self__, "managed_my_sql_database_collections", managed_my_sql_database_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="filterByMySqlDatabaseTypeParam")
    def filter_by_my_sql_database_type_param(self) -> Optional[builtins.str]:
        return pulumi.get(self, "filter_by_my_sql_database_type_param")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedMySqlDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedMySqlDatabaseCollections")
    def managed_my_sql_database_collections(self) -> Sequence['outputs.GetManagedMySqlDatabasesManagedMySqlDatabaseCollectionResult']:
        """
        The list of managed_my_sql_database_collection.
        """
        return pulumi.get(self, "managed_my_sql_database_collections")


class AwaitableGetManagedMySqlDatabasesResult(GetManagedMySqlDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedMySqlDatabasesResult(
            compartment_id=self.compartment_id,
            filter_by_my_sql_database_type_param=self.filter_by_my_sql_database_type_param,
            filters=self.filters,
            id=self.id,
            managed_my_sql_database_collections=self.managed_my_sql_database_collections)


def get_managed_my_sql_databases(compartment_id: Optional[builtins.str] = None,
                                 filter_by_my_sql_database_type_param: Optional[builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetManagedMySqlDatabasesFilterArgs', 'GetManagedMySqlDatabasesFilterArgsDict']]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedMySqlDatabasesResult:
    """
    This data source provides the list of Managed My Sql Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of Managed MySQL Databases in a specific compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_databases = oci.DatabaseManagement.get_managed_my_sql_databases(compartment_id=compartment_id,
        filter_by_my_sql_database_type_param=managed_my_sql_database_filter_by_my_sql_database_type_param)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str filter_by_my_sql_database_type_param: The parameter to filter by MySQL database type. Allowed values are EXTERNAL or MDS.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filterByMySqlDatabaseTypeParam'] = filter_by_my_sql_database_type_param
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedMySqlDatabases:getManagedMySqlDatabases', __args__, opts=opts, typ=GetManagedMySqlDatabasesResult).value

    return AwaitableGetManagedMySqlDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filter_by_my_sql_database_type_param=pulumi.get(__ret__, 'filter_by_my_sql_database_type_param'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_my_sql_database_collections=pulumi.get(__ret__, 'managed_my_sql_database_collections'))
def get_managed_my_sql_databases_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                        filter_by_my_sql_database_type_param: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedMySqlDatabasesFilterArgs', 'GetManagedMySqlDatabasesFilterArgsDict']]]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedMySqlDatabasesResult]:
    """
    This data source provides the list of Managed My Sql Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of Managed MySQL Databases in a specific compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_databases = oci.DatabaseManagement.get_managed_my_sql_databases(compartment_id=compartment_id,
        filter_by_my_sql_database_type_param=managed_my_sql_database_filter_by_my_sql_database_type_param)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str filter_by_my_sql_database_type_param: The parameter to filter by MySQL database type. Allowed values are EXTERNAL or MDS.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filterByMySqlDatabaseTypeParam'] = filter_by_my_sql_database_type_param
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedMySqlDatabases:getManagedMySqlDatabases', __args__, opts=opts, typ=GetManagedMySqlDatabasesResult)
    return __ret__.apply(lambda __response__: GetManagedMySqlDatabasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filter_by_my_sql_database_type_param=pulumi.get(__response__, 'filter_by_my_sql_database_type_param'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_my_sql_database_collections=pulumi.get(__response__, 'managed_my_sql_database_collections')))
