# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GenerateOnPremConnectorConfigurationArgs', 'GenerateOnPremConnectorConfiguration']

@pulumi.input_type
class GenerateOnPremConnectorConfigurationArgs:
    def __init__(__self__, *,
                 on_prem_connector_id: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a GenerateOnPremConnectorConfiguration resource.
        :param pulumi.Input[builtins.str] on_prem_connector_id: The OCID of the on-premises connector.
        :param pulumi.Input[builtins.str] password: The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "on_prem_connector_id", on_prem_connector_id)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="onPremConnectorId")
    def on_prem_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the on-premises connector.
        """
        return pulumi.get(self, "on_prem_connector_id")

    @on_prem_connector_id.setter
    def on_prem_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "on_prem_connector_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _GenerateOnPremConnectorConfigurationState:
    def __init__(__self__, *,
                 on_prem_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenerateOnPremConnectorConfiguration resources.
        :param pulumi.Input[builtins.str] on_prem_connector_id: The OCID of the on-premises connector.
        :param pulumi.Input[builtins.str] password: The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if on_prem_connector_id is not None:
            pulumi.set(__self__, "on_prem_connector_id", on_prem_connector_id)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="onPremConnectorId")
    def on_prem_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the on-premises connector.
        """
        return pulumi.get(self, "on_prem_connector_id")

    @on_prem_connector_id.setter
    def on_prem_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_prem_connector_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)


class GenerateOnPremConnectorConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 on_prem_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Generate On Prem Connector Configuration resource in Oracle Cloud Infrastructure Data Safe service.

        Creates and downloads the configuration of the specified on-premises connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generate_on_prem_connector_configuration = oci.data_safe.GenerateOnPremConnectorConfiguration("test_generate_on_prem_connector_configuration",
            on_prem_connector_id=test_on_prem_connector["id"],
            password=generate_on_prem_connector_configuration_password)
        ```

        ## Import

        GenerateOnPremConnectorConfiguration can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/generateOnPremConnectorConfiguration:GenerateOnPremConnectorConfiguration test_generate_on_prem_connector_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] on_prem_connector_id: The OCID of the on-premises connector.
        :param pulumi.Input[builtins.str] password: The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenerateOnPremConnectorConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Generate On Prem Connector Configuration resource in Oracle Cloud Infrastructure Data Safe service.

        Creates and downloads the configuration of the specified on-premises connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generate_on_prem_connector_configuration = oci.data_safe.GenerateOnPremConnectorConfiguration("test_generate_on_prem_connector_configuration",
            on_prem_connector_id=test_on_prem_connector["id"],
            password=generate_on_prem_connector_configuration_password)
        ```

        ## Import

        GenerateOnPremConnectorConfiguration can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/generateOnPremConnectorConfiguration:GenerateOnPremConnectorConfiguration test_generate_on_prem_connector_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param GenerateOnPremConnectorConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenerateOnPremConnectorConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 on_prem_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenerateOnPremConnectorConfigurationArgs.__new__(GenerateOnPremConnectorConfigurationArgs)

            if on_prem_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'on_prem_connector_id'")
            __props__.__dict__["on_prem_connector_id"] = on_prem_connector_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GenerateOnPremConnectorConfiguration, __self__).__init__(
            'oci:DataSafe/generateOnPremConnectorConfiguration:GenerateOnPremConnectorConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            on_prem_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None) -> 'GenerateOnPremConnectorConfiguration':
        """
        Get an existing GenerateOnPremConnectorConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] on_prem_connector_id: The OCID of the on-premises connector.
        :param pulumi.Input[builtins.str] password: The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenerateOnPremConnectorConfigurationState.__new__(_GenerateOnPremConnectorConfigurationState)

        __props__.__dict__["on_prem_connector_id"] = on_prem_connector_id
        __props__.__dict__["password"] = password
        return GenerateOnPremConnectorConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="onPremConnectorId")
    def on_prem_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the on-premises connector.
        """
        return pulumi.get(self, "on_prem_connector_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password to encrypt the keys inside the wallet included as part of the configuration. The password must be between 12 and 30 characters long and must contain atleast 1 uppercase, 1 lowercase, 1 numeric, and 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

