# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSqlFirewallAllowedSqlResult',
    'AwaitableGetSqlFirewallAllowedSqlResult',
    'get_sql_firewall_allowed_sql',
    'get_sql_firewall_allowed_sql_output',
]

@pulumi.output_type
class GetSqlFirewallAllowedSqlResult:
    """
    A collection of values returned by getSqlFirewallAllowedSql.
    """
    def __init__(__self__, compartment_id=None, current_user=None, db_user_name=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, sql_accessed_objects=None, sql_firewall_allowed_sql_id=None, sql_firewall_policy_id=None, sql_level=None, sql_text=None, state=None, system_tags=None, time_collected=None, time_updated=None, version=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if current_user and not isinstance(current_user, str):
            raise TypeError("Expected argument 'current_user' to be a str")
        pulumi.set(__self__, "current_user", current_user)
        if db_user_name and not isinstance(db_user_name, str):
            raise TypeError("Expected argument 'db_user_name' to be a str")
        pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sql_accessed_objects and not isinstance(sql_accessed_objects, list):
            raise TypeError("Expected argument 'sql_accessed_objects' to be a list")
        pulumi.set(__self__, "sql_accessed_objects", sql_accessed_objects)
        if sql_firewall_allowed_sql_id and not isinstance(sql_firewall_allowed_sql_id, str):
            raise TypeError("Expected argument 'sql_firewall_allowed_sql_id' to be a str")
        pulumi.set(__self__, "sql_firewall_allowed_sql_id", sql_firewall_allowed_sql_id)
        if sql_firewall_policy_id and not isinstance(sql_firewall_policy_id, str):
            raise TypeError("Expected argument 'sql_firewall_policy_id' to be a str")
        pulumi.set(__self__, "sql_firewall_policy_id", sql_firewall_policy_id)
        if sql_level and not isinstance(sql_level, str):
            raise TypeError("Expected argument 'sql_level' to be a str")
        pulumi.set(__self__, "sql_level", sql_level)
        if sql_text and not isinstance(sql_text, str):
            raise TypeError("Expected argument 'sql_text' to be a str")
        pulumi.set(__self__, "sql_text", sql_text)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_collected and not isinstance(time_collected, str):
            raise TypeError("Expected argument 'time_collected' to be a str")
        pulumi.set(__self__, "time_collected", time_collected)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, float):
            raise TypeError("Expected argument 'version' to be a float")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentUser")
    def current_user(self) -> builtins.str:
        """
        The name of the user that SQL was executed as.
        """
        return pulumi.get(self, "current_user")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> builtins.str:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sqlAccessedObjects")
    def sql_accessed_objects(self) -> Sequence[builtins.str]:
        """
        The objects accessed by the SQL.
        """
        return pulumi.get(self, "sql_accessed_objects")

    @property
    @pulumi.getter(name="sqlFirewallAllowedSqlId")
    def sql_firewall_allowed_sql_id(self) -> builtins.str:
        return pulumi.get(self, "sql_firewall_allowed_sql_id")

    @property
    @pulumi.getter(name="sqlFirewallPolicyId")
    def sql_firewall_policy_id(self) -> builtins.str:
        """
        The OCID of the SQL Firewall policy corresponding to the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "sql_firewall_policy_id")

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> builtins.str:
        """
        Specifies the level of SQL included for this SQL Firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @property
    @pulumi.getter(name="sqlText")
    def sql_text(self) -> builtins.str:
        """
        The SQL text of the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "sql_text")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCollected")
    def time_collected(self) -> builtins.str:
        """
        The time the the SQL Firewall allowed SQL was collected from the target database, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_collected")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The last date and time the SQL Firewall allowed SQL was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> builtins.float:
        """
        Version of the associated SQL Firewall policy. This identifies whether the allowed SQLs were added in the same batch or not.
        """
        return pulumi.get(self, "version")


class AwaitableGetSqlFirewallAllowedSqlResult(GetSqlFirewallAllowedSqlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlFirewallAllowedSqlResult(
            compartment_id=self.compartment_id,
            current_user=self.current_user,
            db_user_name=self.db_user_name,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            sql_accessed_objects=self.sql_accessed_objects,
            sql_firewall_allowed_sql_id=self.sql_firewall_allowed_sql_id,
            sql_firewall_policy_id=self.sql_firewall_policy_id,
            sql_level=self.sql_level,
            sql_text=self.sql_text,
            state=self.state,
            system_tags=self.system_tags,
            time_collected=self.time_collected,
            time_updated=self.time_updated,
            version=self.version)


def get_sql_firewall_allowed_sql(sql_firewall_allowed_sql_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlFirewallAllowedSqlResult:
    """
    This data source provides details about a specific Sql Firewall Allowed Sql resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL firewall allowed SQL by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_allowed_sql = oci.DataSafe.get_sql_firewall_allowed_sql(sql_firewall_allowed_sql_id=test_sql_firewall_allowed_sql_oci_data_safe_sql_firewall_allowed_sql["id"])
    ```


    :param builtins.str sql_firewall_allowed_sql_id: The OCID of the sqlFirewallAllowedSql resource.
    """
    __args__ = dict()
    __args__['sqlFirewallAllowedSqlId'] = sql_firewall_allowed_sql_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlFirewallAllowedSql:getSqlFirewallAllowedSql', __args__, opts=opts, typ=GetSqlFirewallAllowedSqlResult).value

    return AwaitableGetSqlFirewallAllowedSqlResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        current_user=pulumi.get(__ret__, 'current_user'),
        db_user_name=pulumi.get(__ret__, 'db_user_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        sql_accessed_objects=pulumi.get(__ret__, 'sql_accessed_objects'),
        sql_firewall_allowed_sql_id=pulumi.get(__ret__, 'sql_firewall_allowed_sql_id'),
        sql_firewall_policy_id=pulumi.get(__ret__, 'sql_firewall_policy_id'),
        sql_level=pulumi.get(__ret__, 'sql_level'),
        sql_text=pulumi.get(__ret__, 'sql_text'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_collected=pulumi.get(__ret__, 'time_collected'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))
def get_sql_firewall_allowed_sql_output(sql_firewall_allowed_sql_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlFirewallAllowedSqlResult]:
    """
    This data source provides details about a specific Sql Firewall Allowed Sql resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL firewall allowed SQL by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_allowed_sql = oci.DataSafe.get_sql_firewall_allowed_sql(sql_firewall_allowed_sql_id=test_sql_firewall_allowed_sql_oci_data_safe_sql_firewall_allowed_sql["id"])
    ```


    :param builtins.str sql_firewall_allowed_sql_id: The OCID of the sqlFirewallAllowedSql resource.
    """
    __args__ = dict()
    __args__['sqlFirewallAllowedSqlId'] = sql_firewall_allowed_sql_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlFirewallAllowedSql:getSqlFirewallAllowedSql', __args__, opts=opts, typ=GetSqlFirewallAllowedSqlResult)
    return __ret__.apply(lambda __response__: GetSqlFirewallAllowedSqlResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        current_user=pulumi.get(__response__, 'current_user'),
        db_user_name=pulumi.get(__response__, 'db_user_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        sql_accessed_objects=pulumi.get(__response__, 'sql_accessed_objects'),
        sql_firewall_allowed_sql_id=pulumi.get(__response__, 'sql_firewall_allowed_sql_id'),
        sql_firewall_policy_id=pulumi.get(__response__, 'sql_firewall_policy_id'),
        sql_level=pulumi.get(__response__, 'sql_level'),
        sql_text=pulumi.get(__response__, 'sql_text'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_collected=pulumi.get(__response__, 'time_collected'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        version=pulumi.get(__response__, 'version')))
