# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetDatabaseRolesResult',
    'AwaitableGetTargetDatabaseRolesResult',
    'get_target_database_roles',
    'get_target_database_roles_output',
]

@pulumi.output_type
class GetTargetDatabaseRolesResult:
    """
    A collection of values returned by getTargetDatabaseRoles.
    """
    def __init__(__self__, authentication_type=None, filters=None, id=None, is_oracle_maintained=None, role_name_contains=None, role_names=None, roles=None, target_database_id=None):
        if authentication_type and not isinstance(authentication_type, str):
            raise TypeError("Expected argument 'authentication_type' to be a str")
        pulumi.set(__self__, "authentication_type", authentication_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_oracle_maintained and not isinstance(is_oracle_maintained, bool):
            raise TypeError("Expected argument 'is_oracle_maintained' to be a bool")
        pulumi.set(__self__, "is_oracle_maintained", is_oracle_maintained)
        if role_name_contains and not isinstance(role_name_contains, str):
            raise TypeError("Expected argument 'role_name_contains' to be a str")
        pulumi.set(__self__, "role_name_contains", role_name_contains)
        if role_names and not isinstance(role_names, list):
            raise TypeError("Expected argument 'role_names' to be a list")
        pulumi.set(__self__, "role_names", role_names)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if target_database_id and not isinstance(target_database_id, str):
            raise TypeError("Expected argument 'target_database_id' to be a str")
        pulumi.set(__self__, "target_database_id", target_database_id)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[builtins.str]:
        """
        Type of authentication.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetDatabaseRolesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOracleMaintained")
    def is_oracle_maintained(self) -> Optional[builtins.bool]:
        """
        Is the role oracle maintained.
        """
        return pulumi.get(self, "is_oracle_maintained")

    @property
    @pulumi.getter(name="roleNameContains")
    def role_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "role_name_contains")

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_names")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetTargetDatabaseRolesRoleResult']:
        """
        The list of roles.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> builtins.str:
        return pulumi.get(self, "target_database_id")


class AwaitableGetTargetDatabaseRolesResult(GetTargetDatabaseRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabaseRolesResult(
            authentication_type=self.authentication_type,
            filters=self.filters,
            id=self.id,
            is_oracle_maintained=self.is_oracle_maintained,
            role_name_contains=self.role_name_contains,
            role_names=self.role_names,
            roles=self.roles,
            target_database_id=self.target_database_id)


def get_target_database_roles(authentication_type: Optional[builtins.str] = None,
                              filters: Optional[Sequence[Union['GetTargetDatabaseRolesFilterArgs', 'GetTargetDatabaseRolesFilterArgsDict']]] = None,
                              is_oracle_maintained: Optional[builtins.bool] = None,
                              role_name_contains: Optional[builtins.str] = None,
                              role_names: Optional[Sequence[builtins.str]] = None,
                              target_database_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabaseRolesResult:
    """
    This data source provides the list of Target Database Roles in Oracle Cloud Infrastructure Data Safe service.

    Returns a list of role metadata objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_roles = oci.DataSafe.get_target_database_roles(target_database_id=test_target_database["id"],
        authentication_type=target_database_role_authentication_type,
        is_oracle_maintained=target_database_role_is_oracle_maintained,
        role_names=target_database_role_role_name,
        role_name_contains=target_database_role_role_name_contains)
    ```


    :param builtins.str authentication_type: A filter to return roles based on authentication type.
    :param builtins.bool is_oracle_maintained: A filter to return roles based on whether they are maintained by oracle or not.
    :param builtins.str role_name_contains: A filter to return only items if role name contains a specific string.
    :param Sequence[builtins.str] role_names: A filter to return only a specific role based on role name.
    :param builtins.str target_database_id: The OCID of the Data Safe target database.
    """
    __args__ = dict()
    __args__['authenticationType'] = authentication_type
    __args__['filters'] = filters
    __args__['isOracleMaintained'] = is_oracle_maintained
    __args__['roleNameContains'] = role_name_contains
    __args__['roleNames'] = role_names
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabaseRoles:getTargetDatabaseRoles', __args__, opts=opts, typ=GetTargetDatabaseRolesResult).value

    return AwaitableGetTargetDatabaseRolesResult(
        authentication_type=pulumi.get(__ret__, 'authentication_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_oracle_maintained=pulumi.get(__ret__, 'is_oracle_maintained'),
        role_name_contains=pulumi.get(__ret__, 'role_name_contains'),
        role_names=pulumi.get(__ret__, 'role_names'),
        roles=pulumi.get(__ret__, 'roles'),
        target_database_id=pulumi.get(__ret__, 'target_database_id'))
def get_target_database_roles_output(authentication_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTargetDatabaseRolesFilterArgs', 'GetTargetDatabaseRolesFilterArgsDict']]]]] = None,
                                     is_oracle_maintained: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     role_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     role_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     target_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetDatabaseRolesResult]:
    """
    This data source provides the list of Target Database Roles in Oracle Cloud Infrastructure Data Safe service.

    Returns a list of role metadata objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_roles = oci.DataSafe.get_target_database_roles(target_database_id=test_target_database["id"],
        authentication_type=target_database_role_authentication_type,
        is_oracle_maintained=target_database_role_is_oracle_maintained,
        role_names=target_database_role_role_name,
        role_name_contains=target_database_role_role_name_contains)
    ```


    :param builtins.str authentication_type: A filter to return roles based on authentication type.
    :param builtins.bool is_oracle_maintained: A filter to return roles based on whether they are maintained by oracle or not.
    :param builtins.str role_name_contains: A filter to return only items if role name contains a specific string.
    :param Sequence[builtins.str] role_names: A filter to return only a specific role based on role name.
    :param builtins.str target_database_id: The OCID of the Data Safe target database.
    """
    __args__ = dict()
    __args__['authenticationType'] = authentication_type
    __args__['filters'] = filters
    __args__['isOracleMaintained'] = is_oracle_maintained
    __args__['roleNameContains'] = role_name_contains
    __args__['roleNames'] = role_names
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getTargetDatabaseRoles:getTargetDatabaseRoles', __args__, opts=opts, typ=GetTargetDatabaseRolesResult)
    return __ret__.apply(lambda __response__: GetTargetDatabaseRolesResult(
        authentication_type=pulumi.get(__response__, 'authentication_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_oracle_maintained=pulumi.get(__response__, 'is_oracle_maintained'),
        role_name_contains=pulumi.get(__response__, 'role_name_contains'),
        role_names=pulumi.get(__response__, 'role_names'),
        roles=pulumi.get(__response__, 'roles'),
        target_database_id=pulumi.get(__response__, 'target_database_id')))
