# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccDemandSignalsResult',
    'AwaitableGetOccDemandSignalsResult',
    'get_occ_demand_signals',
    'get_occ_demand_signals_output',
]

@pulumi.output_type
class GetOccDemandSignalsResult:
    """
    A collection of values returned by getOccDemandSignals.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, occ_demand_signal_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if occ_demand_signal_collections and not isinstance(occ_demand_signal_collections, list):
            raise TypeError("Expected argument 'occ_demand_signal_collections' to be a list")
        pulumi.set(__self__, "occ_demand_signal_collections", occ_demand_signal_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccDemandSignalsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="occDemandSignalCollections")
    def occ_demand_signal_collections(self) -> Sequence['outputs.GetOccDemandSignalsOccDemandSignalCollectionResult']:
        """
        The list of occ_demand_signal_collection.
        """
        return pulumi.get(self, "occ_demand_signal_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the OccDemandSignal.
        """
        return pulumi.get(self, "state")


class AwaitableGetOccDemandSignalsResult(GetOccDemandSignalsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccDemandSignalsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            occ_demand_signal_collections=self.occ_demand_signal_collections,
            state=self.state)


def get_occ_demand_signals(compartment_id: Optional[builtins.str] = None,
                           display_name: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetOccDemandSignalsFilterArgs', 'GetOccDemandSignalsFilterArgsDict']]] = None,
                           id: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccDemandSignalsResult:
    """
    This data source provides the list of Occ Demand Signals in Oracle Cloud Infrastructure Demand Signal service.

    Gets a list of OccDemandSignals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_demand_signals = oci.DemandSignal.get_occ_demand_signals(compartment_id=compartment_id,
        display_name=occ_demand_signal_display_name,
        id=occ_demand_signal_id,
        state=occ_demand_signal_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DemandSignal/getOccDemandSignals:getOccDemandSignals', __args__, opts=opts, typ=GetOccDemandSignalsResult).value

    return AwaitableGetOccDemandSignalsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        occ_demand_signal_collections=pulumi.get(__ret__, 'occ_demand_signal_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_occ_demand_signals_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOccDemandSignalsFilterArgs', 'GetOccDemandSignalsFilterArgsDict']]]]] = None,
                                  id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccDemandSignalsResult]:
    """
    This data source provides the list of Occ Demand Signals in Oracle Cloud Infrastructure Demand Signal service.

    Gets a list of OccDemandSignals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_demand_signals = oci.DemandSignal.get_occ_demand_signals(compartment_id=compartment_id,
        display_name=occ_demand_signal_display_name,
        id=occ_demand_signal_id,
        state=occ_demand_signal_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DemandSignal/getOccDemandSignals:getOccDemandSignals', __args__, opts=opts, typ=GetOccDemandSignalsResult)
    return __ret__.apply(lambda __response__: GetOccDemandSignalsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        occ_demand_signal_collections=pulumi.get(__response__, 'occ_demand_signal_collections'),
        state=pulumi.get(__response__, 'state')))
