# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionCreateZoneFromZoneFileArgs', 'ActionCreateZoneFromZoneFile']

@pulumi.input_type
class ActionCreateZoneFromZoneFileArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 create_zone_from_zone_file_details: pulumi.Input[builtins.str],
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 view_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ActionCreateZoneFromZoneFile resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment the resource belongs to.
        :param pulumi.Input[builtins.str] create_zone_from_zone_file_details: The zone file contents.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] view_id: The OCID of the view the resource is associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "create_zone_from_zone_file_details", create_zone_from_zone_file_details)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if view_id is not None:
            pulumi.set(__self__, "view_id", view_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createZoneFromZoneFileDetails")
    def create_zone_from_zone_file_details(self) -> pulumi.Input[builtins.str]:
        """
        The zone file contents.
        """
        return pulumi.get(self, "create_zone_from_zone_file_details")

    @create_zone_from_zone_file_details.setter
    def create_zone_from_zone_file_details(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "create_zone_from_zone_file_details", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the view the resource is associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "view_id")

    @view_id.setter
    def view_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "view_id", value)


@pulumi.input_type
class _ActionCreateZoneFromZoneFileState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_zone_from_zone_file_details: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dnssec_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileDnssecConfigArgs']]]] = None,
                 dnssec_state: Optional[pulumi.Input[builtins.str]] = None,
                 external_downstreams: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalDownstreamArgs']]]] = None,
                 external_masters: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalMasterArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_protected: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileNameserverArgs']]]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.str]] = None,
                 serial: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 view_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_transfer_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileZoneTransferServerArgs']]]] = None,
                 zone_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionCreateZoneFromZoneFile resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment the resource belongs to.
        :param pulumi.Input[builtins.str] create_zone_from_zone_file_details: The zone file contents.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalDownstreamArgs']]] external_downstreams: External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        :param pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalMasterArgs']]] external_masters: External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.bool] is_protected: A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        :param pulumi.Input[builtins.str] name: The name of the zone.
        :param pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileNameserverArgs']]] nameservers: The authoritative nameservers for the zone.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] self: The canonical absolute URL of the resource.
        :param pulumi.Input[builtins.str] serial: The current serial of the zone. As seen in the zone's SOA record.
        :param pulumi.Input[builtins.str] state: The current state of the zone resource.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param pulumi.Input[builtins.str] version: Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        :param pulumi.Input[builtins.str] view_id: The OCID of the view the resource is associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileZoneTransferServerArgs']]] zone_transfer_servers: The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        :param pulumi.Input[builtins.str] zone_type: The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if create_zone_from_zone_file_details is not None:
            pulumi.set(__self__, "create_zone_from_zone_file_details", create_zone_from_zone_file_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dnssec_configs is not None:
            pulumi.set(__self__, "dnssec_configs", dnssec_configs)
        if dnssec_state is not None:
            pulumi.set(__self__, "dnssec_state", dnssec_state)
        if external_downstreams is not None:
            pulumi.set(__self__, "external_downstreams", external_downstreams)
        if external_masters is not None:
            pulumi.set(__self__, "external_masters", external_masters)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_protected is not None:
            pulumi.set(__self__, "is_protected", is_protected)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if view_id is not None:
            pulumi.set(__self__, "view_id", view_id)
        if zone_transfer_servers is not None:
            pulumi.set(__self__, "zone_transfer_servers", zone_transfer_servers)
        if zone_type is not None:
            pulumi.set(__self__, "zone_type", zone_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createZoneFromZoneFileDetails")
    def create_zone_from_zone_file_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone file contents.
        """
        return pulumi.get(self, "create_zone_from_zone_file_details")

    @create_zone_from_zone_file_details.setter
    def create_zone_from_zone_file_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_zone_from_zone_file_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dnssecConfigs")
    def dnssec_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileDnssecConfigArgs']]]]:
        return pulumi.get(self, "dnssec_configs")

    @dnssec_configs.setter
    def dnssec_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileDnssecConfigArgs']]]]):
        pulumi.set(self, "dnssec_configs", value)

    @property
    @pulumi.getter(name="dnssecState")
    def dnssec_state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "dnssec_state")

    @dnssec_state.setter
    def dnssec_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dnssec_state", value)

    @property
    @pulumi.getter(name="externalDownstreams")
    def external_downstreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalDownstreamArgs']]]]:
        """
        External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        """
        return pulumi.get(self, "external_downstreams")

    @external_downstreams.setter
    def external_downstreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalDownstreamArgs']]]]):
        pulumi.set(self, "external_downstreams", value)

    @property
    @pulumi.getter(name="externalMasters")
    def external_masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalMasterArgs']]]]:
        """
        External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        """
        return pulumi.get(self, "external_masters")

    @external_masters.setter
    def external_masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileExternalMasterArgs']]]]):
        pulumi.set(self, "external_masters", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @is_protected.setter
    def is_protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_protected", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileNameserverArgs']]]]:
        """
        The authoritative nameservers for the zone.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileNameserverArgs']]]]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current serial of the zone. As seen in the zone's SOA record.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the zone resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the view the resource is associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "view_id")

    @view_id.setter
    def view_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "view_id", value)

    @property
    @pulumi.getter(name="zoneTransferServers")
    def zone_transfer_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileZoneTransferServerArgs']]]]:
        """
        The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        """
        return pulumi.get(self, "zone_transfer_servers")

    @zone_transfer_servers.setter
    def zone_transfer_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionCreateZoneFromZoneFileZoneTransferServerArgs']]]]):
        pulumi.set(self, "zone_transfer_servers", value)

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        return pulumi.get(self, "zone_type")

    @zone_type.setter
    def zone_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_type", value)


class ActionCreateZoneFromZoneFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_zone_from_zone_file_details: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 view_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Action Create Zone From Zone File resource in Oracle Cloud Infrastructure DNS service.

        Creates a new zone from a zone file in the specified compartment. Not supported for private zones.

        After the zone has been created, it should be further managed by importing it to an `Dns.Zone` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_action_create_zone_from_zone_file = oci.dns.ActionCreateZoneFromZoneFile("test_action_create_zone_from_zone_file",
            create_zone_from_zone_file_details=action_create_zone_from_zone_file_create_zone_from_zone_file_details,
            compartment_id=compartment_id,
            scope=action_create_zone_from_zone_file_scope,
            view_id=test_view["id"])
        ```

        ## Import

        ActionCreateZoneFromZoneFile can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/actionCreateZoneFromZoneFile:ActionCreateZoneFromZoneFile test_action_create_zone_from_zone_file "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment the resource belongs to.
        :param pulumi.Input[builtins.str] create_zone_from_zone_file_details: The zone file contents.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] view_id: The OCID of the view the resource is associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionCreateZoneFromZoneFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Action Create Zone From Zone File resource in Oracle Cloud Infrastructure DNS service.

        Creates a new zone from a zone file in the specified compartment. Not supported for private zones.

        After the zone has been created, it should be further managed by importing it to an `Dns.Zone` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_action_create_zone_from_zone_file = oci.dns.ActionCreateZoneFromZoneFile("test_action_create_zone_from_zone_file",
            create_zone_from_zone_file_details=action_create_zone_from_zone_file_create_zone_from_zone_file_details,
            compartment_id=compartment_id,
            scope=action_create_zone_from_zone_file_scope,
            view_id=test_view["id"])
        ```

        ## Import

        ActionCreateZoneFromZoneFile can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/actionCreateZoneFromZoneFile:ActionCreateZoneFromZoneFile test_action_create_zone_from_zone_file "id"
        ```

        :param str resource_name: The name of the resource.
        :param ActionCreateZoneFromZoneFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionCreateZoneFromZoneFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_zone_from_zone_file_details: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 view_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionCreateZoneFromZoneFileArgs.__new__(ActionCreateZoneFromZoneFileArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if create_zone_from_zone_file_details is None and not opts.urn:
                raise TypeError("Missing required property 'create_zone_from_zone_file_details'")
            __props__.__dict__["create_zone_from_zone_file_details"] = create_zone_from_zone_file_details
            __props__.__dict__["scope"] = scope
            __props__.__dict__["view_id"] = view_id
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["dnssec_configs"] = None
            __props__.__dict__["dnssec_state"] = None
            __props__.__dict__["external_downstreams"] = None
            __props__.__dict__["external_masters"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_protected"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["nameservers"] = None
            __props__.__dict__["self"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["zone_transfer_servers"] = None
            __props__.__dict__["zone_type"] = None
        super(ActionCreateZoneFromZoneFile, __self__).__init__(
            'oci:Dns/actionCreateZoneFromZoneFile:ActionCreateZoneFromZoneFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            create_zone_from_zone_file_details: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            dnssec_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileDnssecConfigArgs', 'ActionCreateZoneFromZoneFileDnssecConfigArgsDict']]]]] = None,
            dnssec_state: Optional[pulumi.Input[builtins.str]] = None,
            external_downstreams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileExternalDownstreamArgs', 'ActionCreateZoneFromZoneFileExternalDownstreamArgsDict']]]]] = None,
            external_masters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileExternalMasterArgs', 'ActionCreateZoneFromZoneFileExternalMasterArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_protected: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileNameserverArgs', 'ActionCreateZoneFromZoneFileNameserverArgsDict']]]]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            self: Optional[pulumi.Input[builtins.str]] = None,
            serial: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            view_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_transfer_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileZoneTransferServerArgs', 'ActionCreateZoneFromZoneFileZoneTransferServerArgsDict']]]]] = None,
            zone_type: Optional[pulumi.Input[builtins.str]] = None) -> 'ActionCreateZoneFromZoneFile':
        """
        Get an existing ActionCreateZoneFromZoneFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment the resource belongs to.
        :param pulumi.Input[builtins.str] create_zone_from_zone_file_details: The zone file contents.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileExternalDownstreamArgs', 'ActionCreateZoneFromZoneFileExternalDownstreamArgsDict']]]] external_downstreams: External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileExternalMasterArgs', 'ActionCreateZoneFromZoneFileExternalMasterArgsDict']]]] external_masters: External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.bool] is_protected: A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        :param pulumi.Input[builtins.str] name: The name of the zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileNameserverArgs', 'ActionCreateZoneFromZoneFileNameserverArgsDict']]]] nameservers: The authoritative nameservers for the zone.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] self: The canonical absolute URL of the resource.
        :param pulumi.Input[builtins.str] serial: The current serial of the zone. As seen in the zone's SOA record.
        :param pulumi.Input[builtins.str] state: The current state of the zone resource.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param pulumi.Input[builtins.str] version: Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        :param pulumi.Input[builtins.str] view_id: The OCID of the view the resource is associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionCreateZoneFromZoneFileZoneTransferServerArgs', 'ActionCreateZoneFromZoneFileZoneTransferServerArgsDict']]]] zone_transfer_servers: The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        :param pulumi.Input[builtins.str] zone_type: The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionCreateZoneFromZoneFileState.__new__(_ActionCreateZoneFromZoneFileState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["create_zone_from_zone_file_details"] = create_zone_from_zone_file_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dnssec_configs"] = dnssec_configs
        __props__.__dict__["dnssec_state"] = dnssec_state
        __props__.__dict__["external_downstreams"] = external_downstreams
        __props__.__dict__["external_masters"] = external_masters
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_protected"] = is_protected
        __props__.__dict__["name"] = name
        __props__.__dict__["nameservers"] = nameservers
        __props__.__dict__["scope"] = scope
        __props__.__dict__["self"] = self
        __props__.__dict__["serial"] = serial
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["version"] = version
        __props__.__dict__["view_id"] = view_id
        __props__.__dict__["zone_transfer_servers"] = zone_transfer_servers
        __props__.__dict__["zone_type"] = zone_type
        return ActionCreateZoneFromZoneFile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createZoneFromZoneFileDetails")
    def create_zone_from_zone_file_details(self) -> pulumi.Output[builtins.str]:
        """
        The zone file contents.
        """
        return pulumi.get(self, "create_zone_from_zone_file_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dnssecConfigs")
    def dnssec_configs(self) -> pulumi.Output[Sequence['outputs.ActionCreateZoneFromZoneFileDnssecConfig']]:
        return pulumi.get(self, "dnssec_configs")

    @property
    @pulumi.getter(name="dnssecState")
    def dnssec_state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "dnssec_state")

    @property
    @pulumi.getter(name="externalDownstreams")
    def external_downstreams(self) -> pulumi.Output[Sequence['outputs.ActionCreateZoneFromZoneFileExternalDownstream']]:
        """
        External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        """
        return pulumi.get(self, "external_downstreams")

    @property
    @pulumi.getter(name="externalMasters")
    def external_masters(self) -> pulumi.Output[Sequence['outputs.ActionCreateZoneFromZoneFileExternalMaster']]:
        """
        External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        """
        return pulumi.get(self, "external_masters")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> pulumi.Output[builtins.bool]:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nameservers(self) -> pulumi.Output[Sequence['outputs.ActionCreateZoneFromZoneFileNameserver']]:
        """
        The authoritative nameservers for the zone.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[builtins.str]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[builtins.str]:
        """
        The current serial of the zone. As seen in the zone's SOA record.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the zone resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the view the resource is associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "view_id")

    @property
    @pulumi.getter(name="zoneTransferServers")
    def zone_transfer_servers(self) -> pulumi.Output[Sequence['outputs.ActionCreateZoneFromZoneFileZoneTransferServer']]:
        """
        The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        """
        return pulumi.get(self, "zone_transfer_servers")

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        return pulumi.get(self, "zone_type")

