# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFleetCredentialResult',
    'AwaitableGetFleetCredentialResult',
    'get_fleet_credential',
    'get_fleet_credential_output',
]

@pulumi.output_type
class GetFleetCredentialResult:
    """
    A collection of values returned by getFleetCredential.
    """
    def __init__(__self__, compartment_id=None, display_name=None, entity_specifics=None, fleet_credential_id=None, fleet_id=None, id=None, lifecycle_details=None, passwords=None, state=None, system_tags=None, time_created=None, time_updated=None, users=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if entity_specifics and not isinstance(entity_specifics, list):
            raise TypeError("Expected argument 'entity_specifics' to be a list")
        pulumi.set(__self__, "entity_specifics", entity_specifics)
        if fleet_credential_id and not isinstance(fleet_credential_id, str):
            raise TypeError("Expected argument 'fleet_credential_id' to be a str")
        pulumi.set(__self__, "fleet_credential_id", fleet_credential_id)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if passwords and not isinstance(passwords, list):
            raise TypeError("Expected argument 'passwords' to be a list")
        pulumi.set(__self__, "passwords", passwords)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entitySpecifics")
    def entity_specifics(self) -> Sequence['outputs.GetFleetCredentialEntitySpecificResult']:
        """
        Credential specific Details.
        """
        return pulumi.get(self, "entity_specifics")

    @property
    @pulumi.getter(name="fleetCredentialId")
    def fleet_credential_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_credential_id")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def passwords(self) -> Sequence['outputs.GetFleetCredentialPasswordResult']:
        """
        Credential Details.
        """
        return pulumi.get(self, "passwords")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the FleetCredential.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetFleetCredentialUserResult']:
        """
        Credential Details.
        """
        return pulumi.get(self, "users")


class AwaitableGetFleetCredentialResult(GetFleetCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetCredentialResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            entity_specifics=self.entity_specifics,
            fleet_credential_id=self.fleet_credential_id,
            fleet_id=self.fleet_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            passwords=self.passwords,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            users=self.users)


def get_fleet_credential(fleet_credential_id: Optional[builtins.str] = None,
                         fleet_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetCredentialResult:
    """
    This data source provides details about a specific Fleet Credential resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a FleetCredential by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_credential = oci.FleetAppsManagement.get_fleet_credential(fleet_credential_id=test_fleet_credential_oci_fleet_apps_management_fleet_credential["id"],
        fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_credential_id: unique FleetCredential identifier
    :param builtins.str fleet_id: Unique Fleet identifier.
    """
    __args__ = dict()
    __args__['fleetCredentialId'] = fleet_credential_id
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetCredential:getFleetCredential', __args__, opts=opts, typ=GetFleetCredentialResult).value

    return AwaitableGetFleetCredentialResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        entity_specifics=pulumi.get(__ret__, 'entity_specifics'),
        fleet_credential_id=pulumi.get(__ret__, 'fleet_credential_id'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        passwords=pulumi.get(__ret__, 'passwords'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        users=pulumi.get(__ret__, 'users'))
def get_fleet_credential_output(fleet_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                                fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetCredentialResult]:
    """
    This data source provides details about a specific Fleet Credential resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a FleetCredential by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_credential = oci.FleetAppsManagement.get_fleet_credential(fleet_credential_id=test_fleet_credential_oci_fleet_apps_management_fleet_credential["id"],
        fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_credential_id: unique FleetCredential identifier
    :param builtins.str fleet_id: Unique Fleet identifier.
    """
    __args__ = dict()
    __args__['fleetCredentialId'] = fleet_credential_id
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetCredential:getFleetCredential', __args__, opts=opts, typ=GetFleetCredentialResult)
    return __ret__.apply(lambda __response__: GetFleetCredentialResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        entity_specifics=pulumi.get(__response__, 'entity_specifics'),
        fleet_credential_id=pulumi.get(__response__, 'fleet_credential_id'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        passwords=pulumi.get(__response__, 'passwords'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        users=pulumi.get(__response__, 'users')))
