# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateEndpointsResult',
    'AwaitableGetPrivateEndpointsResult',
    'get_private_endpoints',
    'get_private_endpoints_output',
]

@pulumi.output_type
class GetPrivateEndpointsResult:
    """
    A collection of values returned by getPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, private_endpoint_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if private_endpoint_collections and not isinstance(private_endpoint_collections, list):
            raise TypeError("Expected argument 'private_endpoint_collections' to be a list")
        pulumi.set(__self__, "private_endpoint_collections", private_endpoint_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Identifier of the compartment in which private endpoint exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        PrivateEndpoint display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpointCollections")
    def private_endpoint_collections(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionResult']:
        """
        The list of private_endpoint_collection.
        """
        return pulumi.get(self, "private_endpoint_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Lifecycle states for private endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetPrivateEndpointsResult(GetPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            private_endpoint_collections=self.private_endpoint_collections,
            state=self.state)


def get_private_endpoints(compartment_id: Optional[builtins.str] = None,
                          display_name: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetPrivateEndpointsFilterArgs', 'GetPrivateEndpointsFilterArgsDict']]] = None,
                          state: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateEndpointsResult:
    """
    This data source provides the list of Private Endpoints in Oracle Cloud Infrastructure Globally Distributed Database service.

    List of PrivateEndpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_endpoints = oci.GloballyDistributedDatabase.get_private_endpoints(compartment_id=compartment_id,
        display_name=private_endpoint_display_name,
        state=private_endpoint_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only private endpoint that match the entire name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GloballyDistributedDatabase/getPrivateEndpoints:getPrivateEndpoints', __args__, opts=opts, typ=GetPrivateEndpointsResult).value

    return AwaitableGetPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        private_endpoint_collections=pulumi.get(__ret__, 'private_endpoint_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_private_endpoints_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPrivateEndpointsFilterArgs', 'GetPrivateEndpointsFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateEndpointsResult]:
    """
    This data source provides the list of Private Endpoints in Oracle Cloud Infrastructure Globally Distributed Database service.

    List of PrivateEndpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_endpoints = oci.GloballyDistributedDatabase.get_private_endpoints(compartment_id=compartment_id,
        display_name=private_endpoint_display_name,
        state=private_endpoint_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only private endpoint that match the entire name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GloballyDistributedDatabase/getPrivateEndpoints:getPrivateEndpoints', __args__, opts=opts, typ=GetPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        private_endpoint_collections=pulumi.get(__response__, 'private_endpoint_collections'),
        state=pulumi.get(__response__, 'state')))
