# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationInstanceArgs', 'IntegrationInstance']

@pulumi.input_type
class IntegrationInstanceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 integration_instance_type: pulumi.Input[builtins.str],
                 is_byol: pulumi.Input[builtins.bool],
                 message_packs: pulumi.Input[builtins.int],
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_process_automation_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 extend_data_retention_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 failover_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[builtins.str]] = None,
                 is_disaster_recovery_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_file_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_endpoint_details: Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationInstance resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Integration Instance Identifier.
        :param pulumi.Input[builtins.str] integration_instance_type: (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param pulumi.Input[builtins.bool] is_byol: (Updatable) Bring your own license.
        :param pulumi.Input[builtins.int] message_packs: (Updatable) The number of configured message packs
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input['IntegrationInstanceCustomEndpointArgs'] custom_endpoint: (Updatable) Details for a custom endpoint for the integration instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] domain_id: The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        :param pulumi.Input[builtins.int] enable_process_automation_trigger: (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        :param pulumi.Input[builtins.int] extend_data_retention_trigger: (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        :param pulumi.Input[builtins.int] failover_trigger: (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_at: (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        :param pulumi.Input[builtins.bool] is_disaster_recovery_enabled: Is Disaster Recovery enabled or not.
        :param pulumi.Input[builtins.bool] is_file_server_enabled: (Updatable) The file server is enabled or not.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] shape: Shape
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "integration_instance_type", integration_instance_type)
        pulumi.set(__self__, "is_byol", is_byol)
        pulumi.set(__self__, "message_packs", message_packs)
        if alternate_custom_endpoints is not None:
            pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if enable_process_automation_trigger is not None:
            pulumi.set(__self__, "enable_process_automation_trigger", enable_process_automation_trigger)
        if extend_data_retention_trigger is not None:
            pulumi.set(__self__, "extend_data_retention_trigger", extend_data_retention_trigger)
        if failover_trigger is not None:
            pulumi.set(__self__, "failover_trigger", failover_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_at is not None:
            pulumi.set(__self__, "idcs_at", idcs_at)
        if is_disaster_recovery_enabled is not None:
            pulumi.set(__self__, "is_disaster_recovery_enabled", is_disaster_recovery_enabled)
        if is_file_server_enabled is not None:
            pulumi.set(__self__, "is_file_server_enabled", is_file_server_enabled)
        if is_visual_builder_enabled is not None:
            pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Integration Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="integrationInstanceType")
    def integration_instance_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        """
        return pulumi.get(self, "integration_instance_type")

    @integration_instance_type.setter
    def integration_instance_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "integration_instance_type", value)

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Bring your own license.
        """
        return pulumi.get(self, "is_byol")

    @is_byol.setter
    def is_byol(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_byol", value)

    @property
    @pulumi.getter(name="messagePacks")
    def message_packs(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The number of configured message packs
        """
        return pulumi.get(self, "message_packs")

    @message_packs.setter
    def message_packs(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "message_packs", value)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @alternate_custom_endpoints.setter
    def alternate_custom_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]]):
        pulumi.set(self, "alternate_custom_endpoints", value)

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']]:
        """
        (Updatable) Details for a custom endpoint for the integration instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="enableProcessAutomationTrigger")
    def enable_process_automation_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        """
        return pulumi.get(self, "enable_process_automation_trigger")

    @enable_process_automation_trigger.setter
    def enable_process_automation_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "enable_process_automation_trigger", value)

    @property
    @pulumi.getter(name="extendDataRetentionTrigger")
    def extend_data_retention_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        """
        return pulumi.get(self, "extend_data_retention_trigger")

    @extend_data_retention_trigger.setter
    def extend_data_retention_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "extend_data_retention_trigger", value)

    @property
    @pulumi.getter(name="failoverTrigger")
    def failover_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        """
        return pulumi.get(self, "failover_trigger")

    @failover_trigger.setter
    def failover_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failover_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @idcs_at.setter
    def idcs_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_at", value)

    @property
    @pulumi.getter(name="isDisasterRecoveryEnabled")
    def is_disaster_recovery_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Disaster Recovery enabled or not.
        """
        return pulumi.get(self, "is_disaster_recovery_enabled")

    @is_disaster_recovery_enabled.setter
    def is_disaster_recovery_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disaster_recovery_enabled", value)

    @property
    @pulumi.getter(name="isFileServerEnabled")
    def is_file_server_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) The file server is enabled or not.
        """
        return pulumi.get(self, "is_file_server_enabled")

    @is_file_server_enabled.setter
    def is_file_server_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_file_server_enabled", value)

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @is_visual_builder_enabled.setter
    def is_visual_builder_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_visual_builder_enabled", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shape
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _IntegrationInstanceState:
    def __init__(__self__, *,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAttachmentArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']] = None,
                 data_retention_period: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 disaster_recovery_details: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceDisasterRecoveryDetailArgs']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_process_automation_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 extend_data_retention_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 failover_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_infos: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceIdcsInfoArgs']]]] = None,
                 instance_design_time_url: Optional[pulumi.Input[builtins.str]] = None,
                 instance_url: Optional[pulumi.Input[builtins.str]] = None,
                 integration_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_byol: Optional[pulumi.Input[builtins.bool]] = None,
                 is_disaster_recovery_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_file_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 message_packs: Optional[pulumi.Input[builtins.int]] = None,
                 network_endpoint_details: Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']] = None,
                 private_endpoint_outbound_connections: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstancePrivateEndpointOutboundConnectionArgs']]]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAttachmentArgs']]] attachments: A list of associated attachments to other services
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input['IntegrationInstanceCustomEndpointArgs'] custom_endpoint: (Updatable) Details for a custom endpoint for the integration instance (update).
        :param pulumi.Input[builtins.str] data_retention_period: Data retention period set for given integration instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceDisasterRecoveryDetailArgs']]] disaster_recovery_details: Disaster recovery details for the integration instance created in the region.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Integration Instance Identifier.
        :param pulumi.Input[builtins.str] domain_id: The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        :param pulumi.Input[builtins.int] enable_process_automation_trigger: (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        :param pulumi.Input[builtins.int] extend_data_retention_trigger: (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        :param pulumi.Input[builtins.int] failover_trigger: (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_at: (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceIdcsInfoArgs']]] idcs_infos: Information for IDCS access
        :param pulumi.Input[builtins.str] instance_url: The Integration Instance URL.
        :param pulumi.Input[builtins.str] integration_instance_type: (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param pulumi.Input[builtins.bool] is_byol: (Updatable) Bring your own license.
        :param pulumi.Input[builtins.bool] is_disaster_recovery_enabled: Is Disaster Recovery enabled or not.
        :param pulumi.Input[builtins.bool] is_file_server_enabled: (Updatable) The file server is enabled or not.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional details of lifecycleState or substates
        :param pulumi.Input[builtins.int] message_packs: (Updatable) The number of configured message packs
        :param pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationInstancePrivateEndpointOutboundConnectionArgs']]] private_endpoint_outbound_connections: Base representation for Outbound Connection (Reverse Connection).
        :param pulumi.Input[builtins.str] shape: Shape
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        if alternate_custom_endpoints is not None:
            pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if data_retention_period is not None:
            pulumi.set(__self__, "data_retention_period", data_retention_period)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disaster_recovery_details is not None:
            pulumi.set(__self__, "disaster_recovery_details", disaster_recovery_details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if enable_process_automation_trigger is not None:
            pulumi.set(__self__, "enable_process_automation_trigger", enable_process_automation_trigger)
        if extend_data_retention_trigger is not None:
            pulumi.set(__self__, "extend_data_retention_trigger", extend_data_retention_trigger)
        if failover_trigger is not None:
            pulumi.set(__self__, "failover_trigger", failover_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_at is not None:
            pulumi.set(__self__, "idcs_at", idcs_at)
        if idcs_infos is not None:
            pulumi.set(__self__, "idcs_infos", idcs_infos)
        if instance_design_time_url is not None:
            pulumi.set(__self__, "instance_design_time_url", instance_design_time_url)
        if instance_url is not None:
            pulumi.set(__self__, "instance_url", instance_url)
        if integration_instance_type is not None:
            pulumi.set(__self__, "integration_instance_type", integration_instance_type)
        if is_byol is not None:
            pulumi.set(__self__, "is_byol", is_byol)
        if is_disaster_recovery_enabled is not None:
            pulumi.set(__self__, "is_disaster_recovery_enabled", is_disaster_recovery_enabled)
        if is_file_server_enabled is not None:
            pulumi.set(__self__, "is_file_server_enabled", is_file_server_enabled)
        if is_visual_builder_enabled is not None:
            pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if message_packs is not None:
            pulumi.set(__self__, "message_packs", message_packs)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if private_endpoint_outbound_connections is not None:
            pulumi.set(__self__, "private_endpoint_outbound_connections", private_endpoint_outbound_connections)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @alternate_custom_endpoints.setter
    def alternate_custom_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAlternateCustomEndpointArgs']]]]):
        pulumi.set(self, "alternate_custom_endpoints", value)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAttachmentArgs']]]]:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']]:
        """
        (Updatable) Details for a custom endpoint for the integration instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['IntegrationInstanceCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="dataRetentionPeriod")
    def data_retention_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Data retention period set for given integration instance
        """
        return pulumi.get(self, "data_retention_period")

    @data_retention_period.setter
    def data_retention_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_retention_period", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="disasterRecoveryDetails")
    def disaster_recovery_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceDisasterRecoveryDetailArgs']]]]:
        """
        Disaster recovery details for the integration instance created in the region.
        """
        return pulumi.get(self, "disaster_recovery_details")

    @disaster_recovery_details.setter
    def disaster_recovery_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceDisasterRecoveryDetailArgs']]]]):
        pulumi.set(self, "disaster_recovery_details", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Integration Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="enableProcessAutomationTrigger")
    def enable_process_automation_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        """
        return pulumi.get(self, "enable_process_automation_trigger")

    @enable_process_automation_trigger.setter
    def enable_process_automation_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "enable_process_automation_trigger", value)

    @property
    @pulumi.getter(name="extendDataRetentionTrigger")
    def extend_data_retention_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        """
        return pulumi.get(self, "extend_data_retention_trigger")

    @extend_data_retention_trigger.setter
    def extend_data_retention_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "extend_data_retention_trigger", value)

    @property
    @pulumi.getter(name="failoverTrigger")
    def failover_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        """
        return pulumi.get(self, "failover_trigger")

    @failover_trigger.setter
    def failover_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failover_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @idcs_at.setter
    def idcs_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_at", value)

    @property
    @pulumi.getter(name="idcsInfos")
    def idcs_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceIdcsInfoArgs']]]]:
        """
        Information for IDCS access
        """
        return pulumi.get(self, "idcs_infos")

    @idcs_infos.setter
    def idcs_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstanceIdcsInfoArgs']]]]):
        pulumi.set(self, "idcs_infos", value)

    @property
    @pulumi.getter(name="instanceDesignTimeUrl")
    def instance_design_time_url(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_design_time_url")

    @instance_design_time_url.setter
    def instance_design_time_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_design_time_url", value)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Integration Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @instance_url.setter
    def instance_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_url", value)

    @property
    @pulumi.getter(name="integrationInstanceType")
    def integration_instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        """
        return pulumi.get(self, "integration_instance_type")

    @integration_instance_type.setter
    def integration_instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_instance_type", value)

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Bring your own license.
        """
        return pulumi.get(self, "is_byol")

    @is_byol.setter
    def is_byol(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_byol", value)

    @property
    @pulumi.getter(name="isDisasterRecoveryEnabled")
    def is_disaster_recovery_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Disaster Recovery enabled or not.
        """
        return pulumi.get(self, "is_disaster_recovery_enabled")

    @is_disaster_recovery_enabled.setter
    def is_disaster_recovery_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disaster_recovery_enabled", value)

    @property
    @pulumi.getter(name="isFileServerEnabled")
    def is_file_server_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) The file server is enabled or not.
        """
        return pulumi.get(self, "is_file_server_enabled")

    @is_file_server_enabled.setter
    def is_file_server_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_file_server_enabled", value)

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @is_visual_builder_enabled.setter
    def is_visual_builder_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_visual_builder_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional details of lifecycleState or substates
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="messagePacks")
    def message_packs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of configured message packs
        """
        return pulumi.get(self, "message_packs")

    @message_packs.setter
    def message_packs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "message_packs", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['IntegrationInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter(name="privateEndpointOutboundConnections")
    def private_endpoint_outbound_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstancePrivateEndpointOutboundConnectionArgs']]]]:
        """
        Base representation for Outbound Connection (Reverse Connection).
        """
        return pulumi.get(self, "private_endpoint_outbound_connections")

    @private_endpoint_outbound_connections.setter
    def private_endpoint_outbound_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationInstancePrivateEndpointOutboundConnectionArgs']]]]):
        pulumi.set(self, "private_endpoint_outbound_connections", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shape
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class IntegrationInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAlternateCustomEndpointArgs', 'IntegrationInstanceAlternateCustomEndpointArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['IntegrationInstanceCustomEndpointArgs', 'IntegrationInstanceCustomEndpointArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_process_automation_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 extend_data_retention_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 failover_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[builtins.str]] = None,
                 integration_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_byol: Optional[pulumi.Input[builtins.bool]] = None,
                 is_disaster_recovery_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_file_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 message_packs: Optional[pulumi.Input[builtins.int]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['IntegrationInstanceNetworkEndpointDetailsArgs', 'IntegrationInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Integration Instance resource in Oracle Cloud Infrastructure Integration service.

        Creates a new Integration Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_integration_instance = oci.integration.IntegrationInstance("test_integration_instance",
            compartment_id=compartment_id,
            display_name=integration_instance_display_name,
            integration_instance_type=integration_instance_integration_instance_type,
            is_byol=integration_instance_is_byol,
            message_packs=integration_instance_message_packs,
            alternate_custom_endpoints=[{
                "hostname": integration_instance_alternate_custom_endpoints_hostname,
                "certificate_secret_id": test_secret["id"],
            }],
            consumption_model=integration_instance_consumption_model,
            custom_endpoint={
                "hostname": integration_instance_custom_endpoint_hostname,
                "certificate_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            domain_id=test_domain["id"],
            freeform_tags={
                "bar-key": "value",
            },
            idcs_at=integration_instance_idcs_at,
            is_disaster_recovery_enabled=integration_instance_is_disaster_recovery_enabled,
            is_file_server_enabled=integration_instance_is_file_server_enabled,
            is_visual_builder_enabled=integration_instance_is_visual_builder_enabled,
            network_endpoint_details={
                "network_endpoint_type": integration_instance_network_endpoint_details_network_endpoint_type,
                "allowlisted_http_ips": integration_instance_network_endpoint_details_allowlisted_http_ips,
                "allowlisted_http_vcns": [{
                    "id": integration_instance_network_endpoint_details_allowlisted_http_vcns_id,
                    "allowlisted_ips": integration_instance_network_endpoint_details_allowlisted_http_vcns_allowlisted_ips,
                }],
                "is_integration_vcn_allowlisted": integration_instance_network_endpoint_details_is_integration_vcn_allowlisted,
            },
            shape=integration_instance_shape,
            state=integration_instance_target_state)
        ```

        ## Import

        IntegrationInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Integration/integrationInstance:IntegrationInstance test_integration_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAlternateCustomEndpointArgs', 'IntegrationInstanceAlternateCustomEndpointArgsDict']]]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input[Union['IntegrationInstanceCustomEndpointArgs', 'IntegrationInstanceCustomEndpointArgsDict']] custom_endpoint: (Updatable) Details for a custom endpoint for the integration instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Integration Instance Identifier.
        :param pulumi.Input[builtins.str] domain_id: The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        :param pulumi.Input[builtins.int] enable_process_automation_trigger: (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        :param pulumi.Input[builtins.int] extend_data_retention_trigger: (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        :param pulumi.Input[builtins.int] failover_trigger: (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_at: (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        :param pulumi.Input[builtins.str] integration_instance_type: (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param pulumi.Input[builtins.bool] is_byol: (Updatable) Bring your own license.
        :param pulumi.Input[builtins.bool] is_disaster_recovery_enabled: Is Disaster Recovery enabled or not.
        :param pulumi.Input[builtins.bool] is_file_server_enabled: (Updatable) The file server is enabled or not.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[builtins.int] message_packs: (Updatable) The number of configured message packs
        :param pulumi.Input[Union['IntegrationInstanceNetworkEndpointDetailsArgs', 'IntegrationInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] shape: Shape
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Integration Instance resource in Oracle Cloud Infrastructure Integration service.

        Creates a new Integration Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_integration_instance = oci.integration.IntegrationInstance("test_integration_instance",
            compartment_id=compartment_id,
            display_name=integration_instance_display_name,
            integration_instance_type=integration_instance_integration_instance_type,
            is_byol=integration_instance_is_byol,
            message_packs=integration_instance_message_packs,
            alternate_custom_endpoints=[{
                "hostname": integration_instance_alternate_custom_endpoints_hostname,
                "certificate_secret_id": test_secret["id"],
            }],
            consumption_model=integration_instance_consumption_model,
            custom_endpoint={
                "hostname": integration_instance_custom_endpoint_hostname,
                "certificate_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            domain_id=test_domain["id"],
            freeform_tags={
                "bar-key": "value",
            },
            idcs_at=integration_instance_idcs_at,
            is_disaster_recovery_enabled=integration_instance_is_disaster_recovery_enabled,
            is_file_server_enabled=integration_instance_is_file_server_enabled,
            is_visual_builder_enabled=integration_instance_is_visual_builder_enabled,
            network_endpoint_details={
                "network_endpoint_type": integration_instance_network_endpoint_details_network_endpoint_type,
                "allowlisted_http_ips": integration_instance_network_endpoint_details_allowlisted_http_ips,
                "allowlisted_http_vcns": [{
                    "id": integration_instance_network_endpoint_details_allowlisted_http_vcns_id,
                    "allowlisted_ips": integration_instance_network_endpoint_details_allowlisted_http_vcns_allowlisted_ips,
                }],
                "is_integration_vcn_allowlisted": integration_instance_network_endpoint_details_is_integration_vcn_allowlisted,
            },
            shape=integration_instance_shape,
            state=integration_instance_target_state)
        ```

        ## Import

        IntegrationInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Integration/integrationInstance:IntegrationInstance test_integration_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAlternateCustomEndpointArgs', 'IntegrationInstanceAlternateCustomEndpointArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['IntegrationInstanceCustomEndpointArgs', 'IntegrationInstanceCustomEndpointArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_process_automation_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 extend_data_retention_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 failover_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[builtins.str]] = None,
                 integration_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_byol: Optional[pulumi.Input[builtins.bool]] = None,
                 is_disaster_recovery_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_file_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 message_packs: Optional[pulumi.Input[builtins.int]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['IntegrationInstanceNetworkEndpointDetailsArgs', 'IntegrationInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationInstanceArgs.__new__(IntegrationInstanceArgs)

            __props__.__dict__["alternate_custom_endpoints"] = alternate_custom_endpoints
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["consumption_model"] = consumption_model
            __props__.__dict__["custom_endpoint"] = custom_endpoint
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["enable_process_automation_trigger"] = enable_process_automation_trigger
            __props__.__dict__["extend_data_retention_trigger"] = extend_data_retention_trigger
            __props__.__dict__["failover_trigger"] = failover_trigger
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["idcs_at"] = None if idcs_at is None else pulumi.Output.secret(idcs_at)
            if integration_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_instance_type'")
            __props__.__dict__["integration_instance_type"] = integration_instance_type
            if is_byol is None and not opts.urn:
                raise TypeError("Missing required property 'is_byol'")
            __props__.__dict__["is_byol"] = is_byol
            __props__.__dict__["is_disaster_recovery_enabled"] = is_disaster_recovery_enabled
            __props__.__dict__["is_file_server_enabled"] = is_file_server_enabled
            __props__.__dict__["is_visual_builder_enabled"] = is_visual_builder_enabled
            if message_packs is None and not opts.urn:
                raise TypeError("Missing required property 'message_packs'")
            __props__.__dict__["message_packs"] = message_packs
            __props__.__dict__["network_endpoint_details"] = network_endpoint_details
            __props__.__dict__["shape"] = shape
            __props__.__dict__["state"] = state
            __props__.__dict__["attachments"] = None
            __props__.__dict__["data_retention_period"] = None
            __props__.__dict__["disaster_recovery_details"] = None
            __props__.__dict__["idcs_infos"] = None
            __props__.__dict__["instance_design_time_url"] = None
            __props__.__dict__["instance_url"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["private_endpoint_outbound_connections"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsAt"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationInstance, __self__).__init__(
            'oci:Integration/integrationInstance:IntegrationInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAlternateCustomEndpointArgs', 'IntegrationInstanceAlternateCustomEndpointArgsDict']]]]] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAttachmentArgs', 'IntegrationInstanceAttachmentArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            consumption_model: Optional[pulumi.Input[builtins.str]] = None,
            custom_endpoint: Optional[pulumi.Input[Union['IntegrationInstanceCustomEndpointArgs', 'IntegrationInstanceCustomEndpointArgsDict']]] = None,
            data_retention_period: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            disaster_recovery_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceDisasterRecoveryDetailArgs', 'IntegrationInstanceDisasterRecoveryDetailArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            enable_process_automation_trigger: Optional[pulumi.Input[builtins.int]] = None,
            extend_data_retention_trigger: Optional[pulumi.Input[builtins.int]] = None,
            failover_trigger: Optional[pulumi.Input[builtins.int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            idcs_at: Optional[pulumi.Input[builtins.str]] = None,
            idcs_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceIdcsInfoArgs', 'IntegrationInstanceIdcsInfoArgsDict']]]]] = None,
            instance_design_time_url: Optional[pulumi.Input[builtins.str]] = None,
            instance_url: Optional[pulumi.Input[builtins.str]] = None,
            integration_instance_type: Optional[pulumi.Input[builtins.str]] = None,
            is_byol: Optional[pulumi.Input[builtins.bool]] = None,
            is_disaster_recovery_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_file_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            message_packs: Optional[pulumi.Input[builtins.int]] = None,
            network_endpoint_details: Optional[pulumi.Input[Union['IntegrationInstanceNetworkEndpointDetailsArgs', 'IntegrationInstanceNetworkEndpointDetailsArgsDict']]] = None,
            private_endpoint_outbound_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstancePrivateEndpointOutboundConnectionArgs', 'IntegrationInstancePrivateEndpointOutboundConnectionArgsDict']]]]] = None,
            shape: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'IntegrationInstance':
        """
        Get an existing IntegrationInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAlternateCustomEndpointArgs', 'IntegrationInstanceAlternateCustomEndpointArgsDict']]]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceAttachmentArgs', 'IntegrationInstanceAttachmentArgsDict']]]] attachments: A list of associated attachments to other services
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input[Union['IntegrationInstanceCustomEndpointArgs', 'IntegrationInstanceCustomEndpointArgsDict']] custom_endpoint: (Updatable) Details for a custom endpoint for the integration instance (update).
        :param pulumi.Input[builtins.str] data_retention_period: Data retention period set for given integration instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceDisasterRecoveryDetailArgs', 'IntegrationInstanceDisasterRecoveryDetailArgsDict']]]] disaster_recovery_details: Disaster recovery details for the integration instance created in the region.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Integration Instance Identifier.
        :param pulumi.Input[builtins.str] domain_id: The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        :param pulumi.Input[builtins.int] enable_process_automation_trigger: (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        :param pulumi.Input[builtins.int] extend_data_retention_trigger: (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        :param pulumi.Input[builtins.int] failover_trigger: (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_at: (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstanceIdcsInfoArgs', 'IntegrationInstanceIdcsInfoArgsDict']]]] idcs_infos: Information for IDCS access
        :param pulumi.Input[builtins.str] instance_url: The Integration Instance URL.
        :param pulumi.Input[builtins.str] integration_instance_type: (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        :param pulumi.Input[builtins.bool] is_byol: (Updatable) Bring your own license.
        :param pulumi.Input[builtins.bool] is_disaster_recovery_enabled: Is Disaster Recovery enabled or not.
        :param pulumi.Input[builtins.bool] is_file_server_enabled: (Updatable) The file server is enabled or not.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional details of lifecycleState or substates
        :param pulumi.Input[builtins.int] message_packs: (Updatable) The number of configured message packs
        :param pulumi.Input[Union['IntegrationInstanceNetworkEndpointDetailsArgs', 'IntegrationInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationInstancePrivateEndpointOutboundConnectionArgs', 'IntegrationInstancePrivateEndpointOutboundConnectionArgsDict']]]] private_endpoint_outbound_connections: Base representation for Outbound Connection (Reverse Connection).
        :param pulumi.Input[builtins.str] shape: Shape
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationInstanceState.__new__(_IntegrationInstanceState)

        __props__.__dict__["alternate_custom_endpoints"] = alternate_custom_endpoints
        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["consumption_model"] = consumption_model
        __props__.__dict__["custom_endpoint"] = custom_endpoint
        __props__.__dict__["data_retention_period"] = data_retention_period
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disaster_recovery_details"] = disaster_recovery_details
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["enable_process_automation_trigger"] = enable_process_automation_trigger
        __props__.__dict__["extend_data_retention_trigger"] = extend_data_retention_trigger
        __props__.__dict__["failover_trigger"] = failover_trigger
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idcs_at"] = idcs_at
        __props__.__dict__["idcs_infos"] = idcs_infos
        __props__.__dict__["instance_design_time_url"] = instance_design_time_url
        __props__.__dict__["instance_url"] = instance_url
        __props__.__dict__["integration_instance_type"] = integration_instance_type
        __props__.__dict__["is_byol"] = is_byol
        __props__.__dict__["is_disaster_recovery_enabled"] = is_disaster_recovery_enabled
        __props__.__dict__["is_file_server_enabled"] = is_file_server_enabled
        __props__.__dict__["is_visual_builder_enabled"] = is_visual_builder_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["message_packs"] = message_packs
        __props__.__dict__["network_endpoint_details"] = network_endpoint_details
        __props__.__dict__["private_endpoint_outbound_connections"] = private_endpoint_outbound_connections
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return IntegrationInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> pulumi.Output[Sequence['outputs.IntegrationInstanceAlternateCustomEndpoint']]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the integration instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.IntegrationInstanceAttachment']]:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> pulumi.Output[builtins.str]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> pulumi.Output['outputs.IntegrationInstanceCustomEndpoint']:
        """
        (Updatable) Details for a custom endpoint for the integration instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @property
    @pulumi.getter(name="dataRetentionPeriod")
    def data_retention_period(self) -> pulumi.Output[builtins.str]:
        """
        Data retention period set for given integration instance
        """
        return pulumi.get(self, "data_retention_period")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disasterRecoveryDetails")
    def disaster_recovery_details(self) -> pulumi.Output[Sequence['outputs.IntegrationInstanceDisasterRecoveryDetail']]:
        """
        Disaster recovery details for the integration instance created in the region.
        """
        return pulumi.get(self, "disaster_recovery_details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Integration Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The OCID of the identity domain, that will be used to determine the  corresponding Idcs Stripe and create an Idcs application within the stripe.  This parameter is mutually exclusive with parameter: idcsAt, i.e only one of  two parameters should be specified.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="enableProcessAutomationTrigger")
    def enable_process_automation_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Enable Process Automation. Could be set to any integer value.
        """
        return pulumi.get(self, "enable_process_automation_trigger")

    @property
    @pulumi.getter(name="extendDataRetentionTrigger")
    def extend_data_retention_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Extend Data Retention. Could be set to any integer value.
        """
        return pulumi.get(self, "extend_data_retention_trigger")

    @property
    @pulumi.getter(name="failoverTrigger")
    def failover_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Failover. Could be set to any integer value.
        """
        return pulumi.get(self, "failover_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) IDCS Authentication token. This is required for all realms with IDCS. Its optional as its not required for non IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @property
    @pulumi.getter(name="idcsInfos")
    def idcs_infos(self) -> pulumi.Output[Sequence['outputs.IntegrationInstanceIdcsInfo']]:
        """
        Information for IDCS access
        """
        return pulumi.get(self, "idcs_infos")

    @property
    @pulumi.getter(name="instanceDesignTimeUrl")
    def instance_design_time_url(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "instance_design_time_url")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> pulumi.Output[builtins.str]:
        """
        The Integration Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="integrationInstanceType")
    def integration_instance_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Standard or Enterprise type,  Oracle Integration Generation 2 uses ENTERPRISE and STANDARD,  Oracle Integration 3 uses ENTERPRISEX and STANDARDX
        """
        return pulumi.get(self, "integration_instance_type")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Bring your own license.
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isDisasterRecoveryEnabled")
    def is_disaster_recovery_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Is Disaster Recovery enabled or not.
        """
        return pulumi.get(self, "is_disaster_recovery_enabled")

    @property
    @pulumi.getter(name="isFileServerEnabled")
    def is_file_server_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) The file server is enabled or not.
        """
        return pulumi.get(self, "is_file_server_enabled")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional details of lifecycleState or substates
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="messagePacks")
    def message_packs(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of configured message packs
        """
        return pulumi.get(self, "message_packs")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> pulumi.Output['outputs.IntegrationInstanceNetworkEndpointDetails']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="privateEndpointOutboundConnections")
    def private_endpoint_outbound_connections(self) -> pulumi.Output[Sequence['outputs.IntegrationInstancePrivateEndpointOutboundConnection']]:
        """
        Base representation for Outbound Connection (Reverse Connection).
        """
        return pulumi.get(self, "private_endpoint_outbound_connections")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[builtins.str]:
        """
        Shape
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the instance. Could be set to ACTIVE or INACTIVE


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the the Integration Instance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the IntegrationInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

