# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleSetArgs', 'RuleSet']

@pulumi.input_type
class RuleSetArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]],
                 load_balancer_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RuleSet resource.
        :param pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]] items: (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        :param pulumi.Input[builtins.str] name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]]:
        """
        (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RuleSetState:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleSet resources.
        :param pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]] items: (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        :param pulumi.Input[builtins.str] name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]]]:
        """
        (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSetItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


class RuleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleSetItemArgs', 'RuleSetItemArgsDict']]]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Rule Set resource in Oracle Cloud Infrastructure Load Balancer service.

        Creates a new rule set associated with the specified load balancer. For more information, see
        [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_rule_set = oci.load_balancer.RuleSet("test_rule_set",
            items=[{
                "action": rule_set_items_action,
                "allowed_methods": rule_set_items_allowed_methods,
                "are_invalid_characters_allowed": rule_set_items_are_invalid_characters_allowed,
                "conditions": [{
                    "attribute_name": rule_set_items_conditions_attribute_name,
                    "attribute_value": rule_set_items_conditions_attribute_value,
                    "operator": rule_set_items_conditions_operator,
                }],
                "default_max_connections": rule_set_items_default_max_connections,
                "description": rule_set_items_description,
                "header": rule_set_items_header,
                "http_large_header_size_in_kb": rule_set_items_http_large_header_size_in_kb,
                "ip_max_connections": [{
                    "ip_addresses": rule_set_items_ip_max_connections_ip_addresses,
                    "max_connections": rule_set_items_ip_max_connections_max_connections,
                }],
                "prefix": rule_set_items_prefix,
                "redirect_uri": {
                    "host": rule_set_items_redirect_uri_host,
                    "path": rule_set_items_redirect_uri_path,
                    "port": rule_set_items_redirect_uri_port,
                    "protocol": rule_set_items_redirect_uri_protocol,
                    "query": rule_set_items_redirect_uri_query,
                },
                "response_code": rule_set_items_response_code,
                "status_code": rule_set_items_status_code,
                "suffix": rule_set_items_suffix,
                "value": rule_set_items_value,
            }],
            load_balancer_id=test_load_balancer["id"],
            name=rule_set_name)
        ```

        ## Import

        RuleSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/ruleSet:RuleSet test_rule_set "loadBalancers/{loadBalancerId}/ruleSets/{ruleSetName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleSetItemArgs', 'RuleSetItemArgsDict']]]] items: (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        :param pulumi.Input[builtins.str] name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Rule Set resource in Oracle Cloud Infrastructure Load Balancer service.

        Creates a new rule set associated with the specified load balancer. For more information, see
        [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_rule_set = oci.load_balancer.RuleSet("test_rule_set",
            items=[{
                "action": rule_set_items_action,
                "allowed_methods": rule_set_items_allowed_methods,
                "are_invalid_characters_allowed": rule_set_items_are_invalid_characters_allowed,
                "conditions": [{
                    "attribute_name": rule_set_items_conditions_attribute_name,
                    "attribute_value": rule_set_items_conditions_attribute_value,
                    "operator": rule_set_items_conditions_operator,
                }],
                "default_max_connections": rule_set_items_default_max_connections,
                "description": rule_set_items_description,
                "header": rule_set_items_header,
                "http_large_header_size_in_kb": rule_set_items_http_large_header_size_in_kb,
                "ip_max_connections": [{
                    "ip_addresses": rule_set_items_ip_max_connections_ip_addresses,
                    "max_connections": rule_set_items_ip_max_connections_max_connections,
                }],
                "prefix": rule_set_items_prefix,
                "redirect_uri": {
                    "host": rule_set_items_redirect_uri_host,
                    "path": rule_set_items_redirect_uri_path,
                    "port": rule_set_items_redirect_uri_port,
                    "protocol": rule_set_items_redirect_uri_protocol,
                    "query": rule_set_items_redirect_uri_query,
                },
                "response_code": rule_set_items_response_code,
                "status_code": rule_set_items_status_code,
                "suffix": rule_set_items_suffix,
                "value": rule_set_items_value,
            }],
            load_balancer_id=test_load_balancer["id"],
            name=rule_set_name)
        ```

        ## Import

        RuleSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/ruleSet:RuleSet test_rule_set "loadBalancers/{loadBalancerId}/ruleSets/{ruleSetName}"
        ```

        :param str resource_name: The name of the resource.
        :param RuleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleSetItemArgs', 'RuleSetItemArgsDict']]]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleSetArgs.__new__(RuleSetArgs)

            if items is None and not opts.urn:
                raise TypeError("Missing required property 'items'")
            __props__.__dict__["items"] = items
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["state"] = None
        super(RuleSet, __self__).__init__(
            'oci:LoadBalancer/ruleSet:RuleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleSetItemArgs', 'RuleSetItemArgsDict']]]]] = None,
            load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'RuleSet':
        """
        Get an existing RuleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleSetItemArgs', 'RuleSetItemArgsDict']]]] items: (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        :param pulumi.Input[builtins.str] name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleSetState.__new__(_RuleSetState)

        __props__.__dict__["items"] = items
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        return RuleSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.RuleSetItem']]:
        """
        (Updatable) An array of rules that compose the rule set. For more information, see [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm)
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "state")

