# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFileStorageLustreFileSystemResult',
    'AwaitableGetFileStorageLustreFileSystemResult',
    'get_file_storage_lustre_file_system',
    'get_file_storage_lustre_file_system_output',
]

@pulumi.output_type
class GetFileStorageLustreFileSystemResult:
    """
    A collection of values returned by getFileStorageLustreFileSystem.
    """
    def __init__(__self__, availability_domain=None, capacity_in_gbs=None, cluster_placement_group_id=None, compartment_id=None, defined_tags=None, display_name=None, file_system_description=None, file_system_name=None, freeform_tags=None, id=None, kms_key_id=None, lifecycle_details=None, lnet=None, lustre_file_system_id=None, maintenance_windows=None, major_version=None, management_service_address=None, nsg_ids=None, performance_tier=None, root_squash_configurations=None, state=None, subnet_id=None, system_tags=None, time_billing_cycle_end=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_in_gbs and not isinstance(capacity_in_gbs, int):
            raise TypeError("Expected argument 'capacity_in_gbs' to be a int")
        pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if file_system_description and not isinstance(file_system_description, str):
            raise TypeError("Expected argument 'file_system_description' to be a str")
        pulumi.set(__self__, "file_system_description", file_system_description)
        if file_system_name and not isinstance(file_system_name, str):
            raise TypeError("Expected argument 'file_system_name' to be a str")
        pulumi.set(__self__, "file_system_name", file_system_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lnet and not isinstance(lnet, str):
            raise TypeError("Expected argument 'lnet' to be a str")
        pulumi.set(__self__, "lnet", lnet)
        if lustre_file_system_id and not isinstance(lustre_file_system_id, str):
            raise TypeError("Expected argument 'lustre_file_system_id' to be a str")
        pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if major_version and not isinstance(major_version, str):
            raise TypeError("Expected argument 'major_version' to be a str")
        pulumi.set(__self__, "major_version", major_version)
        if management_service_address and not isinstance(management_service_address, str):
            raise TypeError("Expected argument 'management_service_address' to be a str")
        pulumi.set(__self__, "management_service_address", management_service_address)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if performance_tier and not isinstance(performance_tier, str):
            raise TypeError("Expected argument 'performance_tier' to be a str")
        pulumi.set(__self__, "performance_tier", performance_tier)
        if root_squash_configurations and not isinstance(root_squash_configurations, list):
            raise TypeError("Expected argument 'root_squash_configurations' to be a list")
        pulumi.set(__self__, "root_squash_configurations", root_squash_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_billing_cycle_end and not isinstance(time_billing_cycle_end, str):
            raise TypeError("Expected argument 'time_billing_cycle_end' to be a str")
        pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> builtins.int:
        """
        Capacity of the Lustre file system in GB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> builtins.str:
        """
        Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> builtins.str:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def lnet(self) -> builtins.str:
        """
        Type of network used by clients to mount the file system.   Example: `tcp`
        """
        return pulumi.get(self, "lnet")

    @property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> builtins.str:
        return pulumi.get(self, "lustre_file_system_id")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetFileStorageLustreFileSystemMaintenanceWindowResult']:
        """
        The preferred day and time to perform maintenance.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> builtins.str:
        """
        Major version of Lustre running in the Lustre file system.  Example: `2.15`
        """
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="managementServiceAddress")
    def management_service_address(self) -> builtins.str:
        """
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        """
        return pulumi.get(self, "management_service_address")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> builtins.str:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @property
    @pulumi.getter(name="rootSquashConfigurations")
    def root_squash_configurations(self) -> Sequence['outputs.GetFileStorageLustreFileSystemRootSquashConfigurationResult']:
        """
        An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configurations")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Lustre file system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> builtins.str:
        """
        The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFileStorageLustreFileSystemResult(GetFileStorageLustreFileSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStorageLustreFileSystemResult(
            availability_domain=self.availability_domain,
            capacity_in_gbs=self.capacity_in_gbs,
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            file_system_description=self.file_system_description,
            file_system_name=self.file_system_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            kms_key_id=self.kms_key_id,
            lifecycle_details=self.lifecycle_details,
            lnet=self.lnet,
            lustre_file_system_id=self.lustre_file_system_id,
            maintenance_windows=self.maintenance_windows,
            major_version=self.major_version,
            management_service_address=self.management_service_address,
            nsg_ids=self.nsg_ids,
            performance_tier=self.performance_tier,
            root_squash_configurations=self.root_squash_configurations,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_billing_cycle_end=self.time_billing_cycle_end,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_file_storage_lustre_file_system(lustre_file_system_id: Optional[builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStorageLustreFileSystemResult:
    """
    This data source provides details about a specific Lustre File System resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets information about a Lustre file system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lustre_file_system = oci.Lustre.get_file_storage_lustre_file_system(lustre_file_system_id=test_lustre_file_system_oci_lustre_file_storage_lustre_file_system["id"])
    ```


    :param builtins.str lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    """
    __args__ = dict()
    __args__['lustreFileSystemId'] = lustre_file_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Lustre/getFileStorageLustreFileSystem:getFileStorageLustreFileSystem', __args__, opts=opts, typ=GetFileStorageLustreFileSystemResult).value

    return AwaitableGetFileStorageLustreFileSystemResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_in_gbs=pulumi.get(__ret__, 'capacity_in_gbs'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        file_system_description=pulumi.get(__ret__, 'file_system_description'),
        file_system_name=pulumi.get(__ret__, 'file_system_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lnet=pulumi.get(__ret__, 'lnet'),
        lustre_file_system_id=pulumi.get(__ret__, 'lustre_file_system_id'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        major_version=pulumi.get(__ret__, 'major_version'),
        management_service_address=pulumi.get(__ret__, 'management_service_address'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        performance_tier=pulumi.get(__ret__, 'performance_tier'),
        root_squash_configurations=pulumi.get(__ret__, 'root_squash_configurations'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_billing_cycle_end=pulumi.get(__ret__, 'time_billing_cycle_end'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_file_storage_lustre_file_system_output(lustre_file_system_id: Optional[pulumi.Input[builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileStorageLustreFileSystemResult]:
    """
    This data source provides details about a specific Lustre File System resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets information about a Lustre file system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lustre_file_system = oci.Lustre.get_file_storage_lustre_file_system(lustre_file_system_id=test_lustre_file_system_oci_lustre_file_storage_lustre_file_system["id"])
    ```


    :param builtins.str lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    """
    __args__ = dict()
    __args__['lustreFileSystemId'] = lustre_file_system_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Lustre/getFileStorageLustreFileSystem:getFileStorageLustreFileSystem', __args__, opts=opts, typ=GetFileStorageLustreFileSystemResult)
    return __ret__.apply(lambda __response__: GetFileStorageLustreFileSystemResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        capacity_in_gbs=pulumi.get(__response__, 'capacity_in_gbs'),
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        file_system_description=pulumi.get(__response__, 'file_system_description'),
        file_system_name=pulumi.get(__response__, 'file_system_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lnet=pulumi.get(__response__, 'lnet'),
        lustre_file_system_id=pulumi.get(__response__, 'lustre_file_system_id'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        major_version=pulumi.get(__response__, 'major_version'),
        management_service_address=pulumi.get(__response__, 'management_service_address'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        performance_tier=pulumi.get(__response__, 'performance_tier'),
        root_squash_configurations=pulumi.get(__response__, 'root_squash_configurations'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_billing_cycle_end=pulumi.get(__response__, 'time_billing_cycle_end'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
