# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmSuppressionInitArgs', 'AlarmSuppression']

@pulumi.input_type
class AlarmSuppressionInitArgs:
    def __init__(__self__, *,
                 alarm_suppression_target: pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'],
                 display_name: pulumi.Input[builtins.str],
                 time_suppress_from: pulumi.Input[builtins.str],
                 time_suppress_until: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 suppression_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]] = None):
        """
        The set of arguments for constructing a AlarmSuppression resource.
        :param pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[builtins.str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
               
               Defaut: `DIMENSION`
        :param pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]] suppression_conditions: Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        pulumi.set(__self__, "alarm_suppression_target", alarm_suppression_target)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if suppression_conditions is not None:
            pulumi.set(__self__, "suppression_conditions", suppression_conditions)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, value: pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']):
        pulumi.set(self, "alarm_suppression_target", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> pulumi.Input[builtins.str]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @time_suppress_from.setter
    def time_suppress_from(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_suppress_from", value)

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> pulumi.Input[builtins.str]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @time_suppress_until.setter
    def time_suppress_until(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_suppress_until", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.

        Defaut: `DIMENSION`
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="suppressionConditions")
    def suppression_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]]:
        """
        Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        return pulumi.get(self, "suppression_conditions")

    @suppression_conditions.setter
    def suppression_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]]):
        pulumi.set(self, "suppression_conditions", value)


@pulumi.input_type
class _AlarmSuppressionState:
    def __init__(__self__, *,
                 alarm_suppression_target: Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 suppression_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_suppress_from: Optional[pulumi.Input[builtins.str]] = None,
                 time_suppress_until: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlarmSuppression resources.
        :param pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[builtins.str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
               
               Defaut: `DIMENSION`
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the alarm suppression.  Example: `DELETED`
        :param pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]] suppression_conditions: Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        :param pulumi.Input[builtins.str] time_created: The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_updated: The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        if alarm_suppression_target is not None:
            pulumi.set(__self__, "alarm_suppression_target", alarm_suppression_target)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if suppression_conditions is not None:
            pulumi.set(__self__, "suppression_conditions", suppression_conditions)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_suppress_from is not None:
            pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        if time_suppress_until is not None:
            pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']]:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, value: Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']]):
        pulumi.set(self, "alarm_suppression_target", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.

        Defaut: `DIMENSION`
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="suppressionConditions")
    def suppression_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]]:
        """
        Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        return pulumi.get(self, "suppression_conditions")

    @suppression_conditions.setter
    def suppression_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmSuppressionSuppressionConditionArgs']]]]):
        pulumi.set(self, "suppression_conditions", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @time_suppress_from.setter
    def time_suppress_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_suppress_from", value)

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @time_suppress_until.setter
    def time_suppress_until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_suppress_until", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class AlarmSuppression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 suppression_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmSuppressionSuppressionConditionArgs', 'AlarmSuppressionSuppressionConditionArgsDict']]]]] = None,
                 time_suppress_from: Optional[pulumi.Input[builtins.str]] = None,
                 time_suppress_until: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a new alarm suppression at the specified level (alarm-wide or dimension-specific).
        For more information, see
        [Adding an Alarm-wide Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/add-alarm-suppression.htm) and
        [Adding a Dimension-Specific Alarm Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm-suppression.htm).

        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm_suppression = oci.monitoring.AlarmSuppression("test_alarm_suppression",
            alarm_suppression_target={
                "target_type": alarm_suppression_alarm_suppression_target_target_type,
                "alarm_id": test_alarm["id"],
                "compartment_id": compartment_id,
                "compartment_id_in_subtree": alarm_suppression_alarm_suppression_target_compartment_id_in_subtree,
            },
            display_name=alarm_suppression_display_name,
            time_suppress_from=alarm_suppression_time_suppress_from,
            time_suppress_until=alarm_suppression_time_suppress_until,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alarm_suppression_description,
            dimensions=alarm_suppression_dimensions,
            freeform_tags={
                "Department": "Finance",
            },
            level=alarm_suppression_level,
            suppression_conditions=[{
                "condition_type": alarm_suppression_suppression_conditions_condition_type,
                "suppression_duration": alarm_suppression_suppression_conditions_suppression_duration,
                "suppression_recurrence": alarm_suppression_suppression_conditions_suppression_recurrence,
            }])
        ```

        ## Import

        AlarmSuppressions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarmSuppression:AlarmSuppression test_alarm_suppression "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[builtins.str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
               
               Defaut: `DIMENSION`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmSuppressionSuppressionConditionArgs', 'AlarmSuppressionSuppressionConditionArgsDict']]]] suppression_conditions: Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        :param pulumi.Input[builtins.str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmSuppressionInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a new alarm suppression at the specified level (alarm-wide or dimension-specific).
        For more information, see
        [Adding an Alarm-wide Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/add-alarm-suppression.htm) and
        [Adding a Dimension-Specific Alarm Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm-suppression.htm).

        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm_suppression = oci.monitoring.AlarmSuppression("test_alarm_suppression",
            alarm_suppression_target={
                "target_type": alarm_suppression_alarm_suppression_target_target_type,
                "alarm_id": test_alarm["id"],
                "compartment_id": compartment_id,
                "compartment_id_in_subtree": alarm_suppression_alarm_suppression_target_compartment_id_in_subtree,
            },
            display_name=alarm_suppression_display_name,
            time_suppress_from=alarm_suppression_time_suppress_from,
            time_suppress_until=alarm_suppression_time_suppress_until,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alarm_suppression_description,
            dimensions=alarm_suppression_dimensions,
            freeform_tags={
                "Department": "Finance",
            },
            level=alarm_suppression_level,
            suppression_conditions=[{
                "condition_type": alarm_suppression_suppression_conditions_condition_type,
                "suppression_duration": alarm_suppression_suppression_conditions_suppression_duration,
                "suppression_recurrence": alarm_suppression_suppression_conditions_suppression_recurrence,
            }])
        ```

        ## Import

        AlarmSuppressions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarmSuppression:AlarmSuppression test_alarm_suppression "id"
        ```

        :param str resource_name: The name of the resource.
        :param AlarmSuppressionInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmSuppressionInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 suppression_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmSuppressionSuppressionConditionArgs', 'AlarmSuppressionSuppressionConditionArgsDict']]]]] = None,
                 time_suppress_from: Optional[pulumi.Input[builtins.str]] = None,
                 time_suppress_until: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmSuppressionInitArgs.__new__(AlarmSuppressionInitArgs)

            if alarm_suppression_target is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_suppression_target'")
            __props__.__dict__["alarm_suppression_target"] = alarm_suppression_target
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["level"] = level
            __props__.__dict__["suppression_conditions"] = suppression_conditions
            if time_suppress_from is None and not opts.urn:
                raise TypeError("Missing required property 'time_suppress_from'")
            __props__.__dict__["time_suppress_from"] = time_suppress_from
            if time_suppress_until is None and not opts.urn:
                raise TypeError("Missing required property 'time_suppress_until'")
            __props__.__dict__["time_suppress_until"] = time_suppress_until
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AlarmSuppression, __self__).__init__(
            'oci:Monitoring/alarmSuppression:AlarmSuppression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            level: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            suppression_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmSuppressionSuppressionConditionArgs', 'AlarmSuppressionSuppressionConditionArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_suppress_from: Optional[pulumi.Input[builtins.str]] = None,
            time_suppress_until: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'AlarmSuppression':
        """
        Get an existing AlarmSuppression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[builtins.str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
               
               Defaut: `DIMENSION`
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the alarm suppression.  Example: `DELETED`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmSuppressionSuppressionConditionArgs', 'AlarmSuppressionSuppressionConditionArgsDict']]]] suppression_conditions: Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        :param pulumi.Input[builtins.str] time_created: The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[builtins.str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_updated: The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmSuppressionState.__new__(_AlarmSuppressionState)

        __props__.__dict__["alarm_suppression_target"] = alarm_suppression_target
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["level"] = level
        __props__.__dict__["state"] = state
        __props__.__dict__["suppression_conditions"] = suppression_conditions
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_suppress_from"] = time_suppress_from
        __props__.__dict__["time_suppress_until"] = time_suppress_until
        __props__.__dict__["time_updated"] = time_updated
        return AlarmSuppression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> pulumi.Output['outputs.AlarmSuppressionAlarmSuppressionTarget']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        This is required only when the value of level is `DIMENSION`. If required, the value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[builtins.str]:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.

        Defaut: `DIMENSION`
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suppressionConditions")
    def suppression_conditions(self) -> pulumi.Output[Sequence['outputs.AlarmSuppressionSuppressionCondition']]:
        """
        Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        return pulumi.get(self, "suppression_conditions")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> pulumi.Output[builtins.str]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> pulumi.Output[builtins.str]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

