# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectVersionsResult',
    'AwaitableGetObjectVersionsResult',
    'get_object_versions',
    'get_object_versions_output',
]

@pulumi.output_type
class GetObjectVersionsResult:
    """
    A collection of values returned by getObjectVersions.
    """
    def __init__(__self__, bucket=None, delimiter=None, end=None, fields=None, filters=None, id=None, items=None, namespace=None, prefix=None, prefixes=None, start=None, start_after=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if delimiter and not isinstance(delimiter, str):
            raise TypeError("Expected argument 'delimiter' to be a str")
        pulumi.set(__self__, "delimiter", delimiter)
        if end and not isinstance(end, str):
            raise TypeError("Expected argument 'end' to be a str")
        pulumi.set(__self__, "end", end)
        if fields and not isinstance(fields, str):
            raise TypeError("Expected argument 'fields' to be a str")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if prefixes and not isinstance(prefixes, list):
            raise TypeError("Expected argument 'prefixes' to be a list")
        pulumi.set(__self__, "prefixes", prefixes)
        if start and not isinstance(start, str):
            raise TypeError("Expected argument 'start' to be a str")
        pulumi.set(__self__, "start", start)
        if start_after and not isinstance(start_after, str):
            raise TypeError("Expected argument 'start_after' to be a str")
        pulumi.set(__self__, "start_after", start_after)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def end(self) -> Optional[builtins.str]:
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def fields(self) -> Optional[builtins.str]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetObjectVersionsItemResult']:
        """
        An array of object version summaries.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def prefixes(self) -> Sequence[builtins.str]:
        """
        Prefixes that are common to the results returned by the request if the request specified a delimiter.
        """
        return pulumi.get(self, "prefixes")

    @property
    @pulumi.getter
    def start(self) -> Optional[builtins.str]:
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="startAfter")
    def start_after(self) -> Optional[builtins.str]:
        return pulumi.get(self, "start_after")


class AwaitableGetObjectVersionsResult(GetObjectVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectVersionsResult(
            bucket=self.bucket,
            delimiter=self.delimiter,
            end=self.end,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            items=self.items,
            namespace=self.namespace,
            prefix=self.prefix,
            prefixes=self.prefixes,
            start=self.start,
            start_after=self.start_after)


def get_object_versions(bucket: Optional[builtins.str] = None,
                        delimiter: Optional[builtins.str] = None,
                        end: Optional[builtins.str] = None,
                        fields: Optional[builtins.str] = None,
                        filters: Optional[Sequence[Union['GetObjectVersionsFilterArgs', 'GetObjectVersionsFilterArgsDict']]] = None,
                        namespace: Optional[builtins.str] = None,
                        prefix: Optional[builtins.str] = None,
                        start: Optional[builtins.str] = None,
                        start_after: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectVersionsResult:
    """
    This data source provides the list of Object Versions in Oracle Cloud Infrastructure Object Storage service.

    Lists the object versions in a bucket.

    ListObjectVersions returns an ObjectVersionCollection containing at most 1000 object versions. To paginate through
    more object versions, use the returned `opc-next-page` value with the `page` request parameter.

    To use this and other API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_versions = oci.ObjectStorage.get_object_versions(bucket=object_version_bucket,
        namespace=object_version_namespace,
        delimiter=object_version_delimiter,
        end=object_version_end,
        fields=object_version_fields,
        prefix=object_version_prefix,
        start=object_version_start,
        start_after=object_version_start_after)
    ```


    :param builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param builtins.str delimiter: When this parameter is set, only objects whose names do not contain the delimiter character (after an optionally specified prefix) are returned in the objects key of the response body. Scanned objects whose names contain the delimiter have the part of their name up to the first occurrence of the delimiter (including the optional prefix) returned as a set of prefixes. Note that only '/' is a supported delimiter character at this time.
    :param builtins.str end: Returns object names which are lexicographically strictly less than this parameter.
    :param builtins.str fields: Object summary by default includes only the 'name' field. Use this parameter to also include 'size' (object size in bytes), 'etag', 'md5', 'timeCreated' (object creation date and time), 'timeModified' (object modification date and time), 'storageTier' and 'archivalState' fields. Specify the value of this parameter as a comma-separated, case-insensitive list of those field names.  For example 'name,etag,timeCreated,md5,timeModified,storageTier,archivalState'.
    :param builtins.str namespace: The Object Storage namespace used for the request.
    :param builtins.str prefix: The string to use for matching against the start of object names in a list query.
    :param builtins.str start: Returns object names which are lexicographically greater than or equal to this parameter.
    :param builtins.str start_after: Returns object names which are lexicographically strictly greater than this parameter.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['delimiter'] = delimiter
    __args__['end'] = end
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['prefix'] = prefix
    __args__['start'] = start
    __args__['startAfter'] = start_after
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getObjectVersions:getObjectVersions', __args__, opts=opts, typ=GetObjectVersionsResult).value

    return AwaitableGetObjectVersionsResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        delimiter=pulumi.get(__ret__, 'delimiter'),
        end=pulumi.get(__ret__, 'end'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        namespace=pulumi.get(__ret__, 'namespace'),
        prefix=pulumi.get(__ret__, 'prefix'),
        prefixes=pulumi.get(__ret__, 'prefixes'),
        start=pulumi.get(__ret__, 'start'),
        start_after=pulumi.get(__ret__, 'start_after'))
def get_object_versions_output(bucket: Optional[pulumi.Input[builtins.str]] = None,
                               delimiter: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               end: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               fields: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectVersionsFilterArgs', 'GetObjectVersionsFilterArgsDict']]]]] = None,
                               namespace: Optional[pulumi.Input[builtins.str]] = None,
                               prefix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               start: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               start_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectVersionsResult]:
    """
    This data source provides the list of Object Versions in Oracle Cloud Infrastructure Object Storage service.

    Lists the object versions in a bucket.

    ListObjectVersions returns an ObjectVersionCollection containing at most 1000 object versions. To paginate through
    more object versions, use the returned `opc-next-page` value with the `page` request parameter.

    To use this and other API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_versions = oci.ObjectStorage.get_object_versions(bucket=object_version_bucket,
        namespace=object_version_namespace,
        delimiter=object_version_delimiter,
        end=object_version_end,
        fields=object_version_fields,
        prefix=object_version_prefix,
        start=object_version_start,
        start_after=object_version_start_after)
    ```


    :param builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param builtins.str delimiter: When this parameter is set, only objects whose names do not contain the delimiter character (after an optionally specified prefix) are returned in the objects key of the response body. Scanned objects whose names contain the delimiter have the part of their name up to the first occurrence of the delimiter (including the optional prefix) returned as a set of prefixes. Note that only '/' is a supported delimiter character at this time.
    :param builtins.str end: Returns object names which are lexicographically strictly less than this parameter.
    :param builtins.str fields: Object summary by default includes only the 'name' field. Use this parameter to also include 'size' (object size in bytes), 'etag', 'md5', 'timeCreated' (object creation date and time), 'timeModified' (object modification date and time), 'storageTier' and 'archivalState' fields. Specify the value of this parameter as a comma-separated, case-insensitive list of those field names.  For example 'name,etag,timeCreated,md5,timeModified,storageTier,archivalState'.
    :param builtins.str namespace: The Object Storage namespace used for the request.
    :param builtins.str prefix: The string to use for matching against the start of object names in a list query.
    :param builtins.str start: Returns object names which are lexicographically greater than or equal to this parameter.
    :param builtins.str start_after: Returns object names which are lexicographically strictly greater than this parameter.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['delimiter'] = delimiter
    __args__['end'] = end
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['prefix'] = prefix
    __args__['start'] = start
    __args__['startAfter'] = start_after
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ObjectStorage/getObjectVersions:getObjectVersions', __args__, opts=opts, typ=GetObjectVersionsResult)
    return __ret__.apply(lambda __response__: GetObjectVersionsResult(
        bucket=pulumi.get(__response__, 'bucket'),
        delimiter=pulumi.get(__response__, 'delimiter'),
        end=pulumi.get(__response__, 'end'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        namespace=pulumi.get(__response__, 'namespace'),
        prefix=pulumi.get(__response__, 'prefix'),
        prefixes=pulumi.get(__response__, 'prefixes'),
        start=pulumi.get(__response__, 'start'),
        start_after=pulumi.get(__response__, 'start_after')))
