# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpensearchClusterPipelineArgs', 'OpensearchClusterPipeline']

@pulumi.input_type
class OpensearchClusterPipelineArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 data_prepper_configuration_body: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 memory_gb: pulumi.Input[builtins.int],
                 node_count: pulumi.Input[builtins.int],
                 ocpu_count: pulumi.Input[builtins.int],
                 pipeline_configuration_body: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 nsg_id: Optional[pulumi.Input[builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OpensearchClusterPipeline resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to create the pipeline in.
        :param pulumi.Input[builtins.str] data_prepper_configuration_body: (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        :param pulumi.Input[builtins.int] memory_gb: (Updatable) The amount of memory in GB, for each pipeline node.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of nodes configured for the pipeline.
        :param pulumi.Input[builtins.int] ocpu_count: (Updatable) The number of OCPUs configured for each pipeline node.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] nsg_id: (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        :param pulumi.Input[builtins.bool] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]] reverse_connection_endpoints: (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        :param pulumi.Input[builtins.str] subnet_compartment_id: (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) The OCID of the pipeline's subnet.
        :param pulumi.Input[builtins.str] vcn_compartment_id: (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        :param pulumi.Input[builtins.str] vcn_id: (Updatable) The OCID of the pipeline's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_prepper_configuration_body", data_prepper_configuration_body)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if nsg_id is not None:
            pulumi.set(__self__, "nsg_id", nsg_id)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if reverse_connection_endpoints is not None:
            pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        if subnet_compartment_id is not None:
            pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_compartment_id is not None:
            pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the compartment to create the pipeline in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataPrepperConfigurationBody")
    def data_prepper_configuration_body(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "data_prepper_configuration_body")

    @data_prepper_configuration_body.setter
    def data_prepper_configuration_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_prepper_configuration_body", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The amount of memory in GB, for each pipeline node.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The number of nodes configured for the pipeline.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The number of OCPUs configured for each pipeline node.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_configuration_body", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @nsg_id.setter
    def nsg_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nsg_id", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]]:
        """
        (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @reverse_connection_endpoints.setter
    def reverse_connection_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]]):
        pulumi.set(self, "reverse_connection_endpoints", value)

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the pipeline's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_compartment_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the pipeline's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


@pulumi.input_type
class _OpensearchClusterPipelineState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_prepper_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_gb: Optional[pulumi.Input[builtins.int]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 nsg_id: Optional[pulumi.Input[builtins.str]] = None,
                 ocpu_count: Optional[pulumi.Input[builtins.int]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 opensearch_pipeline_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 opensearch_pipeline_private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_mode: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OpensearchClusterPipeline resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to create the pipeline in.
        :param pulumi.Input[builtins.str] data_prepper_configuration_body: (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] memory_gb: (Updatable) The amount of memory in GB, for each pipeline node.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of nodes configured for the pipeline.
        :param pulumi.Input[builtins.str] nsg_id: (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        :param pulumi.Input[builtins.int] ocpu_count: (Updatable) The number of OCPUs configured for each pipeline node.
        :param pulumi.Input[builtins.bool] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[builtins.str] opensearch_pipeline_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[builtins.str] opensearch_pipeline_private_ip: The pipeline's private IP address.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[builtins.str] pipeline_mode: The current state of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]] reverse_connection_endpoints: (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        :param pulumi.Input[builtins.str] state: The current state of the cluster backup.
        :param pulumi.Input[builtins.str] subnet_compartment_id: (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) The OCID of the pipeline's subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The amount of time in milliseconds since the pipeline was updated.
        :param pulumi.Input[builtins.str] vcn_compartment_id: (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        :param pulumi.Input[builtins.str] vcn_id: (Updatable) The OCID of the pipeline's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_prepper_configuration_body is not None:
            pulumi.set(__self__, "data_prepper_configuration_body", data_prepper_configuration_body)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_id is not None:
            pulumi.set(__self__, "nsg_id", nsg_id)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if opensearch_pipeline_fqdn is not None:
            pulumi.set(__self__, "opensearch_pipeline_fqdn", opensearch_pipeline_fqdn)
        if opensearch_pipeline_private_ip is not None:
            pulumi.set(__self__, "opensearch_pipeline_private_ip", opensearch_pipeline_private_ip)
        if pipeline_configuration_body is not None:
            pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if pipeline_mode is not None:
            pulumi.set(__self__, "pipeline_mode", pipeline_mode)
        if reverse_connection_endpoints is not None:
            pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_compartment_id is not None:
            pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vcn_compartment_id is not None:
            pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment to create the pipeline in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataPrepperConfigurationBody")
    def data_prepper_configuration_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "data_prepper_configuration_body")

    @data_prepper_configuration_body.setter
    def data_prepper_configuration_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_prepper_configuration_body", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The amount of memory in GB, for each pipeline node.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of nodes configured for the pipeline.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @nsg_id.setter
    def nsg_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nsg_id", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of OCPUs configured for each pipeline node.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter(name="opensearchPipelineFqdn")
    def opensearch_pipeline_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_pipeline_fqdn")

    @opensearch_pipeline_fqdn.setter
    def opensearch_pipeline_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opensearch_pipeline_fqdn", value)

    @property
    @pulumi.getter(name="opensearchPipelinePrivateIp")
    def opensearch_pipeline_private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The pipeline's private IP address.
        """
        return pulumi.get(self, "opensearch_pipeline_private_ip")

    @opensearch_pipeline_private_ip.setter
    def opensearch_pipeline_private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opensearch_pipeline_private_ip", value)

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_configuration_body", value)

    @property
    @pulumi.getter(name="pipelineMode")
    def pipeline_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "pipeline_mode")

    @pipeline_mode.setter
    def pipeline_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_mode", value)

    @property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]]:
        """
        (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @reverse_connection_endpoints.setter
    def reverse_connection_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpensearchClusterPipelineReverseConnectionEndpointArgs']]]]):
        pulumi.set(self, "reverse_connection_endpoints", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the cluster backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the pipeline's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of time in milliseconds since the pipeline was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_compartment_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the pipeline's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


class OpensearchClusterPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_prepper_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_gb: Optional[pulumi.Input[builtins.int]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 nsg_id: Optional[pulumi.Input[builtins.str]] = None,
                 ocpu_count: Optional[pulumi.Input[builtins.int]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpensearchClusterPipelineReverseConnectionEndpointArgs', 'OpensearchClusterPipelineReverseConnectionEndpointArgsDict']]]]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Opensearch Cluster Pipeline resource in Oracle Cloud Infrastructure Opensearch service.

        Creates a new OpensearchCluster Pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opensearch_cluster_pipeline = oci.opensearch.OpensearchClusterPipeline("test_opensearch_cluster_pipeline",
            compartment_id=compartment_id,
            data_prepper_configuration_body=opensearch_cluster_pipeline_data_prepper_configuration_body,
            display_name=opensearch_cluster_pipeline_display_name,
            memory_gb=opensearch_cluster_pipeline_memory_gb,
            node_count=opensearch_cluster_pipeline_node_count,
            ocpu_count=opensearch_cluster_pipeline_ocpu_count,
            pipeline_configuration_body=opensearch_cluster_pipeline_pipeline_configuration_body,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            nsg_id=test_nsg["id"],
            opc_dry_run=opensearch_cluster_pipeline_opc_dry_run,
            reverse_connection_endpoints=[{
                "customer_fqdn": opensearch_cluster_pipeline_reverse_connection_endpoints_customer_fqdn,
                "customer_ip": opensearch_cluster_pipeline_reverse_connection_endpoints_customer_ip,
            }],
            subnet_compartment_id=test_compartment["id"],
            subnet_id=test_subnet["id"],
            vcn_compartment_id=test_compartment["id"],
            vcn_id=test_vcn["id"])
        ```

        ## Import

        OpensearchClusterPipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/opensearchClusterPipeline:OpensearchClusterPipeline test_opensearch_cluster_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to create the pipeline in.
        :param pulumi.Input[builtins.str] data_prepper_configuration_body: (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] memory_gb: (Updatable) The amount of memory in GB, for each pipeline node.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of nodes configured for the pipeline.
        :param pulumi.Input[builtins.str] nsg_id: (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        :param pulumi.Input[builtins.int] ocpu_count: (Updatable) The number of OCPUs configured for each pipeline node.
        :param pulumi.Input[builtins.bool] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpensearchClusterPipelineReverseConnectionEndpointArgs', 'OpensearchClusterPipelineReverseConnectionEndpointArgsDict']]]] reverse_connection_endpoints: (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        :param pulumi.Input[builtins.str] subnet_compartment_id: (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) The OCID of the pipeline's subnet.
        :param pulumi.Input[builtins.str] vcn_compartment_id: (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        :param pulumi.Input[builtins.str] vcn_id: (Updatable) The OCID of the pipeline's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpensearchClusterPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Opensearch Cluster Pipeline resource in Oracle Cloud Infrastructure Opensearch service.

        Creates a new OpensearchCluster Pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opensearch_cluster_pipeline = oci.opensearch.OpensearchClusterPipeline("test_opensearch_cluster_pipeline",
            compartment_id=compartment_id,
            data_prepper_configuration_body=opensearch_cluster_pipeline_data_prepper_configuration_body,
            display_name=opensearch_cluster_pipeline_display_name,
            memory_gb=opensearch_cluster_pipeline_memory_gb,
            node_count=opensearch_cluster_pipeline_node_count,
            ocpu_count=opensearch_cluster_pipeline_ocpu_count,
            pipeline_configuration_body=opensearch_cluster_pipeline_pipeline_configuration_body,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            nsg_id=test_nsg["id"],
            opc_dry_run=opensearch_cluster_pipeline_opc_dry_run,
            reverse_connection_endpoints=[{
                "customer_fqdn": opensearch_cluster_pipeline_reverse_connection_endpoints_customer_fqdn,
                "customer_ip": opensearch_cluster_pipeline_reverse_connection_endpoints_customer_ip,
            }],
            subnet_compartment_id=test_compartment["id"],
            subnet_id=test_subnet["id"],
            vcn_compartment_id=test_compartment["id"],
            vcn_id=test_vcn["id"])
        ```

        ## Import

        OpensearchClusterPipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/opensearchClusterPipeline:OpensearchClusterPipeline test_opensearch_cluster_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param OpensearchClusterPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpensearchClusterPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_prepper_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_gb: Optional[pulumi.Input[builtins.int]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 nsg_id: Optional[pulumi.Input[builtins.str]] = None,
                 ocpu_count: Optional[pulumi.Input[builtins.int]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpensearchClusterPipelineReverseConnectionEndpointArgs', 'OpensearchClusterPipelineReverseConnectionEndpointArgsDict']]]]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpensearchClusterPipelineArgs.__new__(OpensearchClusterPipelineArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if data_prepper_configuration_body is None and not opts.urn:
                raise TypeError("Missing required property 'data_prepper_configuration_body'")
            __props__.__dict__["data_prepper_configuration_body"] = data_prepper_configuration_body
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'memory_gb'")
            __props__.__dict__["memory_gb"] = memory_gb
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["nsg_id"] = nsg_id
            if ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'ocpu_count'")
            __props__.__dict__["ocpu_count"] = ocpu_count
            __props__.__dict__["opc_dry_run"] = opc_dry_run
            if pipeline_configuration_body is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_configuration_body'")
            __props__.__dict__["pipeline_configuration_body"] = pipeline_configuration_body
            __props__.__dict__["reverse_connection_endpoints"] = reverse_connection_endpoints
            __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["opensearch_pipeline_fqdn"] = None
            __props__.__dict__["opensearch_pipeline_private_ip"] = None
            __props__.__dict__["pipeline_mode"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OpensearchClusterPipeline, __self__).__init__(
            'oci:Opensearch/opensearchClusterPipeline:OpensearchClusterPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            data_prepper_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            memory_gb: Optional[pulumi.Input[builtins.int]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            nsg_id: Optional[pulumi.Input[builtins.str]] = None,
            ocpu_count: Optional[pulumi.Input[builtins.int]] = None,
            opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            opensearch_pipeline_fqdn: Optional[pulumi.Input[builtins.str]] = None,
            opensearch_pipeline_private_ip: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_mode: Optional[pulumi.Input[builtins.str]] = None,
            reverse_connection_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpensearchClusterPipelineReverseConnectionEndpointArgs', 'OpensearchClusterPipelineReverseConnectionEndpointArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            vcn_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            vcn_id: Optional[pulumi.Input[builtins.str]] = None) -> 'OpensearchClusterPipeline':
        """
        Get an existing OpensearchClusterPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment to create the pipeline in.
        :param pulumi.Input[builtins.str] data_prepper_configuration_body: (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] memory_gb: (Updatable) The amount of memory in GB, for each pipeline node.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of nodes configured for the pipeline.
        :param pulumi.Input[builtins.str] nsg_id: (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        :param pulumi.Input[builtins.int] ocpu_count: (Updatable) The number of OCPUs configured for each pipeline node.
        :param pulumi.Input[builtins.bool] opc_dry_run: (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[builtins.str] opensearch_pipeline_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[builtins.str] opensearch_pipeline_private_ip: The pipeline's private IP address.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param pulumi.Input[builtins.str] pipeline_mode: The current state of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpensearchClusterPipelineReverseConnectionEndpointArgs', 'OpensearchClusterPipelineReverseConnectionEndpointArgsDict']]]] reverse_connection_endpoints: (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        :param pulumi.Input[builtins.str] state: The current state of the cluster backup.
        :param pulumi.Input[builtins.str] subnet_compartment_id: (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) The OCID of the pipeline's subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The amount of time in milliseconds since the pipeline was updated.
        :param pulumi.Input[builtins.str] vcn_compartment_id: (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        :param pulumi.Input[builtins.str] vcn_id: (Updatable) The OCID of the pipeline's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpensearchClusterPipelineState.__new__(_OpensearchClusterPipelineState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_prepper_configuration_body"] = data_prepper_configuration_body
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["memory_gb"] = memory_gb
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nsg_id"] = nsg_id
        __props__.__dict__["ocpu_count"] = ocpu_count
        __props__.__dict__["opc_dry_run"] = opc_dry_run
        __props__.__dict__["opensearch_pipeline_fqdn"] = opensearch_pipeline_fqdn
        __props__.__dict__["opensearch_pipeline_private_ip"] = opensearch_pipeline_private_ip
        __props__.__dict__["pipeline_configuration_body"] = pipeline_configuration_body
        __props__.__dict__["pipeline_mode"] = pipeline_mode
        __props__.__dict__["reverse_connection_endpoints"] = reverse_connection_endpoints
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
        __props__.__dict__["vcn_id"] = vcn_id
        return OpensearchClusterPipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment to create the pipeline in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataPrepperConfigurationBody")
    def data_prepper_configuration_body(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "data_prepper_configuration_body")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the cluster pipeline. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The amount of memory in GB, for each pipeline node.
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of nodes configured for the pipeline.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of OCPUs configured for each pipeline node.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Indicates that the request is a dry run, if set to "true". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="opensearchPipelineFqdn")
    def opensearch_pipeline_fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_pipeline_fqdn")

    @property
    @pulumi.getter(name="opensearchPipelinePrivateIp")
    def opensearch_pipeline_private_ip(self) -> pulumi.Output[builtins.str]:
        """
        The pipeline's private IP address.
        """
        return pulumi.get(self, "opensearch_pipeline_private_ip")

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @property
    @pulumi.getter(name="pipelineMode")
    def pipeline_mode(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "pipeline_mode")

    @property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> pulumi.Output[Sequence['outputs.OpensearchClusterPipelineReverseConnectionEndpoint']]:
        """
        (Updatable) The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the cluster backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID for the compartment where the pipeline's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the pipeline's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The amount of time in milliseconds since the pipeline was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID for the compartment where the pipeline's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the pipeline's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

