# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImportableComputeEntityResult',
    'AwaitableGetImportableComputeEntityResult',
    'get_importable_compute_entity',
    'get_importable_compute_entity_output',
]

@pulumi.output_type
class GetImportableComputeEntityResult:
    """
    A collection of values returned by getImportableComputeEntity.
    """
    def __init__(__self__, compartment_id=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetImportableComputeEntityItemResult']:
        """
        Array of importable compute entity objects.
        """
        return pulumi.get(self, "items")


class AwaitableGetImportableComputeEntityResult(GetImportableComputeEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImportableComputeEntityResult(
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items)


def get_importable_compute_entity(compartment_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImportableComputeEntityResult:
    """
    This data source provides details about a specific Importable Compute Entity resource in Oracle Cloud Infrastructure Opsi service.

    Gets a list of available compute intances running cloud agent to add a new hostInsight.  An Compute entity is "available"
    and will be shown if all the following conditions are true:
       1. Compute is running OCA
       2. Oracle Cloud Infrastructure Management Agent is not enabled or If Oracle Cloud Infrastructure Management Agent is enabled
          2.1 The agent OCID is not already being used for an existing hostInsight.
          2.2 The agent availabilityStatus = 'ACTIVE'
          2.3 The agent lifecycleState = 'ACTIVE'

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_importable_compute_entity = oci.Opsi.get_importable_compute_entity(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getImportableComputeEntity:getImportableComputeEntity', __args__, opts=opts, typ=GetImportableComputeEntityResult).value

    return AwaitableGetImportableComputeEntityResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_importable_compute_entity_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImportableComputeEntityResult]:
    """
    This data source provides details about a specific Importable Compute Entity resource in Oracle Cloud Infrastructure Opsi service.

    Gets a list of available compute intances running cloud agent to add a new hostInsight.  An Compute entity is "available"
    and will be shown if all the following conditions are true:
       1. Compute is running OCA
       2. Oracle Cloud Infrastructure Management Agent is not enabled or If Oracle Cloud Infrastructure Management Agent is enabled
          2.1 The agent OCID is not already being used for an existing hostInsight.
          2.2 The agent availabilityStatus = 'ACTIVE'
          2.3 The agent lifecycleState = 'ACTIVE'

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_importable_compute_entity = oci.Opsi.get_importable_compute_entity(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getImportableComputeEntity:getImportableComputeEntity', __args__, opts=opts, typ=GetImportableComputeEntityResult)
    return __ret__.apply(lambda __response__: GetImportableComputeEntityResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
