# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceCatalogsResult',
    'AwaitableGetServiceCatalogsResult',
    'get_service_catalogs',
    'get_service_catalogs_output',
]

@pulumi.output_type
class GetServiceCatalogsResult:
    """
    A collection of values returned by getServiceCatalogs.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, service_catalog_collections=None, service_catalog_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_catalog_collections and not isinstance(service_catalog_collections, list):
            raise TypeError("Expected argument 'service_catalog_collections' to be a list")
        pulumi.set(__self__, "service_catalog_collections", service_catalog_collections)
        if service_catalog_id and not isinstance(service_catalog_id, str):
            raise TypeError("Expected argument 'service_catalog_id' to be a str")
        pulumi.set(__self__, "service_catalog_id", service_catalog_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The Compartment id where the service catalog exists
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of the service catalog.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceCatalogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceCatalogCollections")
    def service_catalog_collections(self) -> Sequence['outputs.GetServiceCatalogsServiceCatalogCollectionResult']:
        """
        The list of service_catalog_collection.
        """
        return pulumi.get(self, "service_catalog_collections")

    @property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "service_catalog_id")


class AwaitableGetServiceCatalogsResult(GetServiceCatalogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceCatalogsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            service_catalog_collections=self.service_catalog_collections,
            service_catalog_id=self.service_catalog_id)


def get_service_catalogs(compartment_id: Optional[builtins.str] = None,
                         display_name: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetServiceCatalogsFilterArgs', 'GetServiceCatalogsFilterArgsDict']]] = None,
                         service_catalog_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceCatalogsResult:
    """
    This data source provides the list of Service Catalogs in Oracle Cloud Infrastructure Service Catalog service.

    Lists all the service catalogs in the given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalogs = oci.ServiceCatalog.get_service_catalogs(compartment_id=compartment_id,
        display_name=service_catalog_display_name,
        service_catalog_id=test_service_catalog["id"])
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    :param builtins.str display_name: Exact match name filter.
    :param builtins.str service_catalog_id: The unique identifier for the service catalog.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['serviceCatalogId'] = service_catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getServiceCatalogs:getServiceCatalogs', __args__, opts=opts, typ=GetServiceCatalogsResult).value

    return AwaitableGetServiceCatalogsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_catalog_collections=pulumi.get(__ret__, 'service_catalog_collections'),
        service_catalog_id=pulumi.get(__ret__, 'service_catalog_id'))
def get_service_catalogs_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServiceCatalogsFilterArgs', 'GetServiceCatalogsFilterArgsDict']]]]] = None,
                                service_catalog_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceCatalogsResult]:
    """
    This data source provides the list of Service Catalogs in Oracle Cloud Infrastructure Service Catalog service.

    Lists all the service catalogs in the given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalogs = oci.ServiceCatalog.get_service_catalogs(compartment_id=compartment_id,
        display_name=service_catalog_display_name,
        service_catalog_id=test_service_catalog["id"])
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    :param builtins.str display_name: Exact match name filter.
    :param builtins.str service_catalog_id: The unique identifier for the service catalog.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['serviceCatalogId'] = service_catalog_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ServiceCatalog/getServiceCatalogs:getServiceCatalogs', __args__, opts=opts, typ=GetServiceCatalogsResult)
    return __ret__.apply(lambda __response__: GetServiceCatalogsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        service_catalog_collections=pulumi.get(__response__, 'service_catalog_collections'),
        service_catalog_id=pulumi.get(__response__, 'service_catalog_id')))
