# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBaselineableMetricsEvaluateResult',
    'AwaitableGetBaselineableMetricsEvaluateResult',
    'get_baselineable_metrics_evaluate',
    'get_baselineable_metrics_evaluate_output',
]

@pulumi.output_type
class GetBaselineableMetricsEvaluateResult:
    """
    A collection of values returned by getBaselineableMetricsEvaluate.
    """
    def __init__(__self__, baselineable_metric_id=None, data_points=None, id=None, items=None, resource_id=None):
        if baselineable_metric_id and not isinstance(baselineable_metric_id, str):
            raise TypeError("Expected argument 'baselineable_metric_id' to be a str")
        pulumi.set(__self__, "baselineable_metric_id", baselineable_metric_id)
        if data_points and not isinstance(data_points, list):
            raise TypeError("Expected argument 'data_points' to be a list")
        pulumi.set(__self__, "data_points", data_points)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="baselineableMetricId")
    def baselineable_metric_id(self) -> builtins.str:
        return pulumi.get(self, "baselineable_metric_id")

    @property
    @pulumi.getter(name="dataPoints")
    def data_points(self) -> Sequence['outputs.GetBaselineableMetricsEvaluateDataPointResult']:
        """
        list of anomaly data points for the metric
        """
        return pulumi.get(self, "data_points")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBaselineableMetricsEvaluateItemResult']:
        """
        List of Metric data
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        OCID of the resource
        """
        return pulumi.get(self, "resource_id")


class AwaitableGetBaselineableMetricsEvaluateResult(GetBaselineableMetricsEvaluateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBaselineableMetricsEvaluateResult(
            baselineable_metric_id=self.baselineable_metric_id,
            data_points=self.data_points,
            id=self.id,
            items=self.items,
            resource_id=self.resource_id)


def get_baselineable_metrics_evaluate(baselineable_metric_id: Optional[builtins.str] = None,
                                      items: Optional[Sequence[Union['GetBaselineableMetricsEvaluateItemArgs', 'GetBaselineableMetricsEvaluateItemArgsDict']]] = None,
                                      resource_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBaselineableMetricsEvaluateResult:
    """
    This data source provides details about a specific Baselineable Metrics Evaluate resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Evaluates metric for anomalies for the given data points

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_baselineable_metrics_evaluate = oci.StackMonitoring.get_baselineable_metrics_evaluate(baselineable_metric_id=test_baselineable_metric["id"],
        items=[{
            "evaluation_data_points": [{
                "timestamp": baselineable_metrics_evaluate_items_evaluation_data_points_timestamp,
                "value": baselineable_metrics_evaluate_items_evaluation_data_points_value,
            }],
            "training_data_points": [{
                "timestamp": baselineable_metrics_evaluate_items_training_data_points_timestamp,
                "value": baselineable_metrics_evaluate_items_training_data_points_value,
            }],
            "dimensions": baselineable_metrics_evaluate_items_dimensions,
        }],
        resource_id=test_resource["id"])
    ```


    :param builtins.str baselineable_metric_id: Identifier for the metric
    :param Sequence[Union['GetBaselineableMetricsEvaluateItemArgs', 'GetBaselineableMetricsEvaluateItemArgsDict']] items: List of Metric data
    :param builtins.str resource_id: OCID of the resource
    """
    __args__ = dict()
    __args__['baselineableMetricId'] = baselineable_metric_id
    __args__['items'] = items
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getBaselineableMetricsEvaluate:getBaselineableMetricsEvaluate', __args__, opts=opts, typ=GetBaselineableMetricsEvaluateResult).value

    return AwaitableGetBaselineableMetricsEvaluateResult(
        baselineable_metric_id=pulumi.get(__ret__, 'baselineable_metric_id'),
        data_points=pulumi.get(__ret__, 'data_points'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        resource_id=pulumi.get(__ret__, 'resource_id'))
def get_baselineable_metrics_evaluate_output(baselineable_metric_id: Optional[pulumi.Input[builtins.str]] = None,
                                             items: Optional[pulumi.Input[Sequence[Union['GetBaselineableMetricsEvaluateItemArgs', 'GetBaselineableMetricsEvaluateItemArgsDict']]]] = None,
                                             resource_id: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBaselineableMetricsEvaluateResult]:
    """
    This data source provides details about a specific Baselineable Metrics Evaluate resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Evaluates metric for anomalies for the given data points

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_baselineable_metrics_evaluate = oci.StackMonitoring.get_baselineable_metrics_evaluate(baselineable_metric_id=test_baselineable_metric["id"],
        items=[{
            "evaluation_data_points": [{
                "timestamp": baselineable_metrics_evaluate_items_evaluation_data_points_timestamp,
                "value": baselineable_metrics_evaluate_items_evaluation_data_points_value,
            }],
            "training_data_points": [{
                "timestamp": baselineable_metrics_evaluate_items_training_data_points_timestamp,
                "value": baselineable_metrics_evaluate_items_training_data_points_value,
            }],
            "dimensions": baselineable_metrics_evaluate_items_dimensions,
        }],
        resource_id=test_resource["id"])
    ```


    :param builtins.str baselineable_metric_id: Identifier for the metric
    :param Sequence[Union['GetBaselineableMetricsEvaluateItemArgs', 'GetBaselineableMetricsEvaluateItemArgsDict']] items: List of Metric data
    :param builtins.str resource_id: OCID of the resource
    """
    __args__ = dict()
    __args__['baselineableMetricId'] = baselineable_metric_id
    __args__['items'] = items
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getBaselineableMetricsEvaluate:getBaselineableMetricsEvaluate', __args__, opts=opts, typ=GetBaselineableMetricsEvaluateResult)
    return __ret__.apply(lambda __response__: GetBaselineableMetricsEvaluateResult(
        baselineable_metric_id=pulumi.get(__response__, 'baselineable_metric_id'),
        data_points=pulumi.get(__response__, 'data_points'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        resource_id=pulumi.get(__response__, 'resource_id')))
