# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitoringTemplatesResult',
    'AwaitableGetMonitoringTemplatesResult',
    'get_monitoring_templates',
    'get_monitoring_templates_output',
]

@pulumi.output_type
class GetMonitoringTemplatesResult:
    """
    A collection of values returned by getMonitoringTemplates.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, metric_names=None, monitoring_template_collections=None, monitoring_template_id=None, namespaces=None, resource_types=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metric_names and not isinstance(metric_names, list):
            raise TypeError("Expected argument 'metric_names' to be a list")
        pulumi.set(__self__, "metric_names", metric_names)
        if monitoring_template_collections and not isinstance(monitoring_template_collections, list):
            raise TypeError("Expected argument 'monitoring_template_collections' to be a list")
        pulumi.set(__self__, "monitoring_template_collections", monitoring_template_collections)
        if monitoring_template_id and not isinstance(monitoring_template_id, str):
            raise TypeError("Expected argument 'monitoring_template_id' to be a str")
        pulumi.set(__self__, "monitoring_template_id", monitoring_template_id)
        if namespaces and not isinstance(namespaces, list):
            raise TypeError("Expected argument 'namespaces' to be a list")
        pulumi.set(__self__, "namespaces", namespaces)
        if resource_types and not isinstance(resource_types, list):
            raise TypeError("Expected argument 'resource_types' to be a list")
        pulumi.set(__self__, "resource_types", resource_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment containing the monitoringTemplate.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name for the monitoring template. It should be unique, and it's mutable in nature. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitoringTemplatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "metric_names")

    @property
    @pulumi.getter(name="monitoringTemplateCollections")
    def monitoring_template_collections(self) -> Sequence['outputs.GetMonitoringTemplatesMonitoringTemplateCollectionResult']:
        """
        The list of monitoring_template_collection.
        """
        return pulumi.get(self, "monitoring_template_collections")

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "monitoring_template_id")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the monitoring template.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        """
        return pulumi.get(self, "status")


class AwaitableGetMonitoringTemplatesResult(GetMonitoringTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoringTemplatesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            metric_names=self.metric_names,
            monitoring_template_collections=self.monitoring_template_collections,
            monitoring_template_id=self.monitoring_template_id,
            namespaces=self.namespaces,
            resource_types=self.resource_types,
            state=self.state,
            status=self.status)


def get_monitoring_templates(compartment_id: Optional[builtins.str] = None,
                             display_name: Optional[builtins.str] = None,
                             filters: Optional[Sequence[Union['GetMonitoringTemplatesFilterArgs', 'GetMonitoringTemplatesFilterArgsDict']]] = None,
                             metric_names: Optional[Sequence[builtins.str]] = None,
                             monitoring_template_id: Optional[builtins.str] = None,
                             namespaces: Optional[Sequence[builtins.str]] = None,
                             resource_types: Optional[Sequence[builtins.str]] = None,
                             state: Optional[builtins.str] = None,
                             status: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoringTemplatesResult:
    """
    This data source provides the list of Monitoring Templates in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of Monitoring Templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_templates = oci.StackMonitoring.get_monitoring_templates(compartment_id=compartment_id,
        display_name=monitoring_template_display_name,
        metric_names=test_metric["name"],
        monitoring_template_id=test_monitoring_template["id"],
        namespaces=monitoring_template_namespace,
        resource_types=monitoring_template_resource_types,
        state=monitoring_template_state,
        status=monitoring_template_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param builtins.str display_name: A filter to return monitoring template based on name.
    :param Sequence[builtins.str] metric_names: metricName filter.
    :param builtins.str monitoring_template_id: A filter to return monitoring template based on input monitoringTemplateId
    :param Sequence[builtins.str] namespaces: namespace filter.
    :param Sequence[builtins.str] resource_types: Multiple resource types filter.
    :param builtins.str state: A filter to return monitoring template based on Lifecycle State
    :param builtins.str status: A filter to return monitoring template based on input status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['metricNames'] = metric_names
    __args__['monitoringTemplateId'] = monitoring_template_id
    __args__['namespaces'] = namespaces
    __args__['resourceTypes'] = resource_types
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoringTemplates:getMonitoringTemplates', __args__, opts=opts, typ=GetMonitoringTemplatesResult).value

    return AwaitableGetMonitoringTemplatesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        metric_names=pulumi.get(__ret__, 'metric_names'),
        monitoring_template_collections=pulumi.get(__ret__, 'monitoring_template_collections'),
        monitoring_template_id=pulumi.get(__ret__, 'monitoring_template_id'),
        namespaces=pulumi.get(__ret__, 'namespaces'),
        resource_types=pulumi.get(__ret__, 'resource_types'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_monitoring_templates_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMonitoringTemplatesFilterArgs', 'GetMonitoringTemplatesFilterArgsDict']]]]] = None,
                                    metric_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                    monitoring_template_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    namespaces: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                    resource_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                    state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoringTemplatesResult]:
    """
    This data source provides the list of Monitoring Templates in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of Monitoring Templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_templates = oci.StackMonitoring.get_monitoring_templates(compartment_id=compartment_id,
        display_name=monitoring_template_display_name,
        metric_names=test_metric["name"],
        monitoring_template_id=test_monitoring_template["id"],
        namespaces=monitoring_template_namespace,
        resource_types=monitoring_template_resource_types,
        state=monitoring_template_state,
        status=monitoring_template_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param builtins.str display_name: A filter to return monitoring template based on name.
    :param Sequence[builtins.str] metric_names: metricName filter.
    :param builtins.str monitoring_template_id: A filter to return monitoring template based on input monitoringTemplateId
    :param Sequence[builtins.str] namespaces: namespace filter.
    :param Sequence[builtins.str] resource_types: Multiple resource types filter.
    :param builtins.str state: A filter to return monitoring template based on Lifecycle State
    :param builtins.str status: A filter to return monitoring template based on input status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['metricNames'] = metric_names
    __args__['monitoringTemplateId'] = monitoring_template_id
    __args__['namespaces'] = namespaces
    __args__['resourceTypes'] = resource_types
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMonitoringTemplates:getMonitoringTemplates', __args__, opts=opts, typ=GetMonitoringTemplatesResult)
    return __ret__.apply(lambda __response__: GetMonitoringTemplatesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        metric_names=pulumi.get(__response__, 'metric_names'),
        monitoring_template_collections=pulumi.get(__response__, 'monitoring_template_collections'),
        monitoring_template_id=pulumi.get(__response__, 'monitoring_template_id'),
        namespaces=pulumi.get(__response__, 'namespaces'),
        resource_types=pulumi.get(__response__, 'resource_types'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
