# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoringTemplateAlarmConditionArgs', 'MonitoringTemplateAlarmCondition']

@pulumi.input_type
class MonitoringTemplateAlarmConditionArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[builtins.str],
                 conditions: pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]],
                 metric_name: pulumi.Input[builtins.str],
                 monitoring_template_id: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 resource_type: pulumi.Input[builtins.str],
                 composite_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a MonitoringTemplateAlarmCondition resource.
        :param pulumi.Input[builtins.str] condition_type: (Updatable) Type of defined monitoring template.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]] conditions: (Updatable) Monitoring template conditions.
        :param pulumi.Input[builtins.str] metric_name: (Updatable) The metric name.
        :param pulumi.Input[builtins.str] monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        :param pulumi.Input[builtins.str] namespace: (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        :param pulumi.Input[builtins.str] resource_type: (Updatable) The resource group OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] composite_type: (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "monitoring_template_id", monitoring_template_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_type", resource_type)
        if composite_type is not None:
            pulumi.set(__self__, "composite_type", composite_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Type of defined monitoring template.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]]:
        """
        (Updatable) Monitoring template conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The metric name.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        """
        return pulumi.get(self, "monitoring_template_id")

    @monitoring_template_id.setter
    def monitoring_template_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "monitoring_template_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The resource group OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="compositeType")
    def composite_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        """
        return pulumi.get(self, "composite_type")

    @composite_type.setter
    def composite_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "composite_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _MonitoringTemplateAlarmConditionState:
    def __init__(__self__, *,
                 composite_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoringTemplateAlarmCondition resources.
        :param pulumi.Input[builtins.str] composite_type: (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        :param pulumi.Input[builtins.str] condition_type: (Updatable) Type of defined monitoring template.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]] conditions: (Updatable) Monitoring template conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] metric_name: (Updatable) The metric name.
        :param pulumi.Input[builtins.str] monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        :param pulumi.Input[builtins.str] namespace: (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        :param pulumi.Input[builtins.str] resource_type: (Updatable) The resource group OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the monitoring template
        :param pulumi.Input[builtins.str] status: The current status of the monitoring template i.e. whether it is Published or Unpublished
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the alarm condition was created. Format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the alarm condition was updated. Format defined by RFC3339.
        """
        if composite_type is not None:
            pulumi.set(__self__, "composite_type", composite_type)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if monitoring_template_id is not None:
            pulumi.set(__self__, "monitoring_template_id", monitoring_template_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compositeType")
    def composite_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        """
        return pulumi.get(self, "composite_type")

    @composite_type.setter
    def composite_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "composite_type", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Type of defined monitoring template.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]]]:
        """
        (Updatable) Monitoring template conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateAlarmConditionConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The metric name.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        """
        return pulumi.get(self, "monitoring_template_id")

    @monitoring_template_id.setter
    def monitoring_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitoring_template_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The resource group OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the monitoring template
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the monitoring template i.e. whether it is Published or Unpublished
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the alarm condition was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the alarm condition was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class MonitoringTemplateAlarmCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composite_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateAlarmConditionConditionArgs', 'MonitoringTemplateAlarmConditionConditionArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Monitoring Template Alarm Condition resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Create a new alarm condition in same monitoringTemplate compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitoring_template_alarm_condition = oci.stack_monitoring.MonitoringTemplateAlarmCondition("test_monitoring_template_alarm_condition",
            condition_type=monitoring_template_alarm_condition_condition_type,
            conditions=[{
                "query": monitoring_template_alarm_condition_conditions_query,
                "severity": monitoring_template_alarm_condition_conditions_severity,
                "body": monitoring_template_alarm_condition_conditions_body,
                "should_append_note": monitoring_template_alarm_condition_conditions_should_append_note,
                "should_append_url": monitoring_template_alarm_condition_conditions_should_append_url,
                "trigger_delay": monitoring_template_alarm_condition_conditions_trigger_delay,
            }],
            metric_name=test_metric["name"],
            monitoring_template_id=test_monitoring_template["id"],
            namespace=monitoring_template_alarm_condition_namespace,
            resource_type=monitoring_template_alarm_condition_resource_type,
            composite_type=monitoring_template_alarm_condition_composite_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        MonitoringTemplateAlarmConditions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoringTemplateAlarmCondition:MonitoringTemplateAlarmCondition test_monitoring_template_alarm_condition "monitoringTemplates/{monitoringTemplateId}/alarmConditions/{alarmConditionId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] composite_type: (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        :param pulumi.Input[builtins.str] condition_type: (Updatable) Type of defined monitoring template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateAlarmConditionConditionArgs', 'MonitoringTemplateAlarmConditionConditionArgsDict']]]] conditions: (Updatable) Monitoring template conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] metric_name: (Updatable) The metric name.
        :param pulumi.Input[builtins.str] monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        :param pulumi.Input[builtins.str] namespace: (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        :param pulumi.Input[builtins.str] resource_type: (Updatable) The resource group OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoringTemplateAlarmConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitoring Template Alarm Condition resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Create a new alarm condition in same monitoringTemplate compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitoring_template_alarm_condition = oci.stack_monitoring.MonitoringTemplateAlarmCondition("test_monitoring_template_alarm_condition",
            condition_type=monitoring_template_alarm_condition_condition_type,
            conditions=[{
                "query": monitoring_template_alarm_condition_conditions_query,
                "severity": monitoring_template_alarm_condition_conditions_severity,
                "body": monitoring_template_alarm_condition_conditions_body,
                "should_append_note": monitoring_template_alarm_condition_conditions_should_append_note,
                "should_append_url": monitoring_template_alarm_condition_conditions_should_append_url,
                "trigger_delay": monitoring_template_alarm_condition_conditions_trigger_delay,
            }],
            metric_name=test_metric["name"],
            monitoring_template_id=test_monitoring_template["id"],
            namespace=monitoring_template_alarm_condition_namespace,
            resource_type=monitoring_template_alarm_condition_resource_type,
            composite_type=monitoring_template_alarm_condition_composite_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        MonitoringTemplateAlarmConditions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoringTemplateAlarmCondition:MonitoringTemplateAlarmCondition test_monitoring_template_alarm_condition "monitoringTemplates/{monitoringTemplateId}/alarmConditions/{alarmConditionId}"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoringTemplateAlarmConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoringTemplateAlarmConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composite_type: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateAlarmConditionConditionArgs', 'MonitoringTemplateAlarmConditionConditionArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoringTemplateAlarmConditionArgs.__new__(MonitoringTemplateAlarmConditionArgs)

            __props__.__dict__["composite_type"] = composite_type
            if condition_type is None and not opts.urn:
                raise TypeError("Missing required property 'condition_type'")
            __props__.__dict__["condition_type"] = condition_type
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            if monitoring_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'monitoring_template_id'")
            __props__.__dict__["monitoring_template_id"] = monitoring_template_id
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MonitoringTemplateAlarmCondition, __self__).__init__(
            'oci:StackMonitoring/monitoringTemplateAlarmCondition:MonitoringTemplateAlarmCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            composite_type: Optional[pulumi.Input[builtins.str]] = None,
            condition_type: Optional[pulumi.Input[builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateAlarmConditionConditionArgs', 'MonitoringTemplateAlarmConditionConditionArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            metric_name: Optional[pulumi.Input[builtins.str]] = None,
            monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'MonitoringTemplateAlarmCondition':
        """
        Get an existing MonitoringTemplateAlarmCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] composite_type: (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        :param pulumi.Input[builtins.str] condition_type: (Updatable) Type of defined monitoring template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateAlarmConditionConditionArgs', 'MonitoringTemplateAlarmConditionConditionArgsDict']]]] conditions: (Updatable) Monitoring template conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] metric_name: (Updatable) The metric name.
        :param pulumi.Input[builtins.str] monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        :param pulumi.Input[builtins.str] namespace: (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        :param pulumi.Input[builtins.str] resource_type: (Updatable) The resource group OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the monitoring template
        :param pulumi.Input[builtins.str] status: The current status of the monitoring template i.e. whether it is Published or Unpublished
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the alarm condition was created. Format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the alarm condition was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoringTemplateAlarmConditionState.__new__(_MonitoringTemplateAlarmConditionState)

        __props__.__dict__["composite_type"] = composite_type
        __props__.__dict__["condition_type"] = condition_type
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["monitoring_template_id"] = monitoring_template_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MonitoringTemplateAlarmCondition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compositeType")
    def composite_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the composite resource type like EBS/PEOPLE_SOFT.
        """
        return pulumi.get(self, "composite_type")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Type of defined monitoring template.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.MonitoringTemplateAlarmConditionCondition']]:
        """
        (Updatable) Monitoring template conditions.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The metric name.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
        """
        return pulumi.get(self, "monitoring_template_id")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The stack monitoring service or application emitting the metric that is evaluated by the alarm.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The resource group OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the monitoring template
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the monitoring template i.e. whether it is Published or Unpublished
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the alarm condition was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the alarm condition was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

