# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVbInstanceResult',
    'AwaitableGetVbInstanceResult',
    'get_vb_instance',
    'get_vb_instance_output',
]

@pulumi.output_type
class GetVbInstanceResult:
    """
    A collection of values returned by getVbInstance.
    """
    def __init__(__self__, alternate_custom_endpoints=None, compartment_id=None, consumption_model=None, custom_endpoints=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, idcs_open_id=None, instance_url=None, is_visual_builder_enabled=None, management_nat_gateway_ip=None, management_vcn_id=None, network_endpoint_details=None, node_count=None, service_nat_gateway_ip=None, service_vcn_id=None, state=None, state_message=None, system_tags=None, time_created=None, time_updated=None, vb_instance_id=None):
        if alternate_custom_endpoints and not isinstance(alternate_custom_endpoints, list):
            raise TypeError("Expected argument 'alternate_custom_endpoints' to be a list")
        pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if consumption_model and not isinstance(consumption_model, str):
            raise TypeError("Expected argument 'consumption_model' to be a str")
        pulumi.set(__self__, "consumption_model", consumption_model)
        if custom_endpoints and not isinstance(custom_endpoints, list):
            raise TypeError("Expected argument 'custom_endpoints' to be a list")
        pulumi.set(__self__, "custom_endpoints", custom_endpoints)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_open_id and not isinstance(idcs_open_id, str):
            raise TypeError("Expected argument 'idcs_open_id' to be a str")
        pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        if instance_url and not isinstance(instance_url, str):
            raise TypeError("Expected argument 'instance_url' to be a str")
        pulumi.set(__self__, "instance_url", instance_url)
        if is_visual_builder_enabled and not isinstance(is_visual_builder_enabled, bool):
            raise TypeError("Expected argument 'is_visual_builder_enabled' to be a bool")
        pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        if management_nat_gateway_ip and not isinstance(management_nat_gateway_ip, str):
            raise TypeError("Expected argument 'management_nat_gateway_ip' to be a str")
        pulumi.set(__self__, "management_nat_gateway_ip", management_nat_gateway_ip)
        if management_vcn_id and not isinstance(management_vcn_id, str):
            raise TypeError("Expected argument 'management_vcn_id' to be a str")
        pulumi.set(__self__, "management_vcn_id", management_vcn_id)
        if network_endpoint_details and not isinstance(network_endpoint_details, list):
            raise TypeError("Expected argument 'network_endpoint_details' to be a list")
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if service_nat_gateway_ip and not isinstance(service_nat_gateway_ip, str):
            raise TypeError("Expected argument 'service_nat_gateway_ip' to be a str")
        pulumi.set(__self__, "service_nat_gateway_ip", service_nat_gateway_ip)
        if service_vcn_id and not isinstance(service_vcn_id, str):
            raise TypeError("Expected argument 'service_vcn_id' to be a str")
        pulumi.set(__self__, "service_vcn_id", service_vcn_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vb_instance_id and not isinstance(vb_instance_id, str):
            raise TypeError("Expected argument 'vb_instance_id' to be a str")
        pulumi.set(__self__, "vb_instance_id", vb_instance_id)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetVbInstanceAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the vb instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> builtins.str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetVbInstanceCustomEndpointResult']:
        """
        Details for a custom endpoint for the vb instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Vb Instance Identifier, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> builtins.str:
        return pulumi.get(self, "idcs_open_id")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> builtins.str:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> builtins.bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> builtins.str:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetVbInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of Nodes
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> builtins.str:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the vb instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vbInstanceId")
    def vb_instance_id(self) -> builtins.str:
        return pulumi.get(self, "vb_instance_id")


class AwaitableGetVbInstanceResult(GetVbInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVbInstanceResult(
            alternate_custom_endpoints=self.alternate_custom_endpoints,
            compartment_id=self.compartment_id,
            consumption_model=self.consumption_model,
            custom_endpoints=self.custom_endpoints,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            idcs_open_id=self.idcs_open_id,
            instance_url=self.instance_url,
            is_visual_builder_enabled=self.is_visual_builder_enabled,
            management_nat_gateway_ip=self.management_nat_gateway_ip,
            management_vcn_id=self.management_vcn_id,
            network_endpoint_details=self.network_endpoint_details,
            node_count=self.node_count,
            service_nat_gateway_ip=self.service_nat_gateway_ip,
            service_vcn_id=self.service_vcn_id,
            state=self.state,
            state_message=self.state_message,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vb_instance_id=self.vb_instance_id)


def get_vb_instance(vb_instance_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVbInstanceResult:
    """
    This data source provides details about a specific Vb Instance resource in Oracle Cloud Infrastructure Visual Builder service.

    Gets a VbInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instance = oci.VisualBuilder.get_vb_instance(vb_instance_id=test_vb_instance_oci_visual_builder_vb_instance["id"])
    ```


    :param builtins.str vb_instance_id: Unique Vb Instance identifier.
    """
    __args__ = dict()
    __args__['vbInstanceId'] = vb_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VisualBuilder/getVbInstance:getVbInstance', __args__, opts=opts, typ=GetVbInstanceResult).value

    return AwaitableGetVbInstanceResult(
        alternate_custom_endpoints=pulumi.get(__ret__, 'alternate_custom_endpoints'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        consumption_model=pulumi.get(__ret__, 'consumption_model'),
        custom_endpoints=pulumi.get(__ret__, 'custom_endpoints'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        idcs_open_id=pulumi.get(__ret__, 'idcs_open_id'),
        instance_url=pulumi.get(__ret__, 'instance_url'),
        is_visual_builder_enabled=pulumi.get(__ret__, 'is_visual_builder_enabled'),
        management_nat_gateway_ip=pulumi.get(__ret__, 'management_nat_gateway_ip'),
        management_vcn_id=pulumi.get(__ret__, 'management_vcn_id'),
        network_endpoint_details=pulumi.get(__ret__, 'network_endpoint_details'),
        node_count=pulumi.get(__ret__, 'node_count'),
        service_nat_gateway_ip=pulumi.get(__ret__, 'service_nat_gateway_ip'),
        service_vcn_id=pulumi.get(__ret__, 'service_vcn_id'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vb_instance_id=pulumi.get(__ret__, 'vb_instance_id'))
def get_vb_instance_output(vb_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVbInstanceResult]:
    """
    This data source provides details about a specific Vb Instance resource in Oracle Cloud Infrastructure Visual Builder service.

    Gets a VbInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instance = oci.VisualBuilder.get_vb_instance(vb_instance_id=test_vb_instance_oci_visual_builder_vb_instance["id"])
    ```


    :param builtins.str vb_instance_id: Unique Vb Instance identifier.
    """
    __args__ = dict()
    __args__['vbInstanceId'] = vb_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VisualBuilder/getVbInstance:getVbInstance', __args__, opts=opts, typ=GetVbInstanceResult)
    return __ret__.apply(lambda __response__: GetVbInstanceResult(
        alternate_custom_endpoints=pulumi.get(__response__, 'alternate_custom_endpoints'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        consumption_model=pulumi.get(__response__, 'consumption_model'),
        custom_endpoints=pulumi.get(__response__, 'custom_endpoints'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        idcs_open_id=pulumi.get(__response__, 'idcs_open_id'),
        instance_url=pulumi.get(__response__, 'instance_url'),
        is_visual_builder_enabled=pulumi.get(__response__, 'is_visual_builder_enabled'),
        management_nat_gateway_ip=pulumi.get(__response__, 'management_nat_gateway_ip'),
        management_vcn_id=pulumi.get(__response__, 'management_vcn_id'),
        network_endpoint_details=pulumi.get(__response__, 'network_endpoint_details'),
        node_count=pulumi.get(__response__, 'node_count'),
        service_nat_gateway_ip=pulumi.get(__response__, 'service_nat_gateway_ip'),
        service_vcn_id=pulumi.get(__response__, 'service_vcn_id'),
        state=pulumi.get(__response__, 'state'),
        state_message=pulumi.get(__response__, 'state_message'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        vb_instance_id=pulumi.get(__response__, 'vb_instance_id')))
