# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerScanTargetsResult',
    'AwaitableGetContainerScanTargetsResult',
    'get_container_scan_targets',
    'get_container_scan_targets_output',
]

@pulumi.output_type
class GetContainerScanTargetsResult:
    """
    A collection of values returned by getContainerScanTargets.
    """
    def __init__(__self__, compartment_id=None, container_scan_target_summary_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if container_scan_target_summary_collections and not isinstance(container_scan_target_summary_collections, list):
            raise TypeError("Expected argument 'container_scan_target_summary_collections' to be a list")
        pulumi.set(__self__, "container_scan_target_summary_collections", container_scan_target_summary_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to perform the scans in. All listed repositories must be in the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerScanTargetSummaryCollections")
    def container_scan_target_summary_collections(self) -> Sequence['outputs.GetContainerScanTargetsContainerScanTargetSummaryCollectionResult']:
        """
        The list of container_scan_target_summary_collection.
        """
        return pulumi.get(self, "container_scan_target_summary_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        User friendly name of container scan target
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerScanTargetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")


class AwaitableGetContainerScanTargetsResult(GetContainerScanTargetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerScanTargetsResult(
            compartment_id=self.compartment_id,
            container_scan_target_summary_collections=self.container_scan_target_summary_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_container_scan_targets(compartment_id: Optional[builtins.str] = None,
                               display_name: Optional[builtins.str] = None,
                               filters: Optional[Sequence[Union['GetContainerScanTargetsFilterArgs', 'GetContainerScanTargetsFilterArgsDict']]] = None,
                               state: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerScanTargetsResult:
    """
    This data source provides the list of Container Scan Targets in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of ContainerScanTargetSummary objects in a compartment. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_targets = oci.VulnerabilityScanning.get_container_scan_targets(compartment_id=compartment_id,
        display_name=container_scan_target_display_name,
        state=container_scan_target_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getContainerScanTargets:getContainerScanTargets', __args__, opts=opts, typ=GetContainerScanTargetsResult).value

    return AwaitableGetContainerScanTargetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        container_scan_target_summary_collections=pulumi.get(__ret__, 'container_scan_target_summary_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_container_scan_targets_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetContainerScanTargetsFilterArgs', 'GetContainerScanTargetsFilterArgsDict']]]]] = None,
                                      state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerScanTargetsResult]:
    """
    This data source provides the list of Container Scan Targets in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of ContainerScanTargetSummary objects in a compartment. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_targets = oci.VulnerabilityScanning.get_container_scan_targets(compartment_id=compartment_id,
        display_name=container_scan_target_display_name,
        state=container_scan_target_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VulnerabilityScanning/getContainerScanTargets:getContainerScanTargets', __args__, opts=opts, typ=GetContainerScanTargetsResult)
    return __ret__.apply(lambda __response__: GetContainerScanTargetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        container_scan_target_summary_collections=pulumi.get(__response__, 'container_scan_target_summary_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
