# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProtectionRuleResult',
    'AwaitableGetProtectionRuleResult',
    'get_protection_rule',
    'get_protection_rule_output',
]

@pulumi.output_type
class GetProtectionRuleResult:
    """
    A collection of values returned by getProtectionRule.
    """
    def __init__(__self__, action=None, description=None, exclusions=None, id=None, key=None, labels=None, mod_security_rule_ids=None, name=None, protection_rule_key=None, waas_policy_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if exclusions and not isinstance(exclusions, list):
            raise TypeError("Expected argument 'exclusions' to be a list")
        pulumi.set(__self__, "exclusions", exclusions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if labels and not isinstance(labels, list):
            raise TypeError("Expected argument 'labels' to be a list")
        pulumi.set(__self__, "labels", labels)
        if mod_security_rule_ids and not isinstance(mod_security_rule_ids, list):
            raise TypeError("Expected argument 'mod_security_rule_ids' to be a list")
        pulumi.set(__self__, "mod_security_rule_ids", mod_security_rule_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protection_rule_key and not isinstance(protection_rule_key, str):
            raise TypeError("Expected argument 'protection_rule_key' to be a str")
        pulumi.set(__self__, "protection_rule_key", protection_rule_key)
        if waas_policy_id and not isinstance(waas_policy_id, str):
            raise TypeError("Expected argument 'waas_policy_id' to be a str")
        pulumi.set(__self__, "waas_policy_id", waas_policy_id)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to take when the traffic is detected as malicious. If unspecified, defaults to `OFF`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the protection rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def exclusions(self) -> Sequence['outputs.GetProtectionRuleExclusionResult']:
        """
        An array of The target property of a request that would allow it to bypass the protection rule. For example, when `target` is `REQUEST_COOKIE_NAMES`, the list may include names of cookies to exclude from the protection rule. When the target is `ARGS`, the list may include strings of URL query parameters and values from form-urlencoded XML, JSON, AMP, or POST payloads to exclude from the protection rule. `Exclusions` properties must not contain whitespace, comma or |. **Note:** If protection rules have been enabled that utilize the `maxArgumentCount` or `maxTotalNameLengthOfArguments` properties, and the `target` property has been set to `ARGS`, it is important that the `exclusions` properties be defined to honor those protection rule settings in a consistent manner.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The unique key of the protection rule.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[builtins.str]:
        """
        The list of labels for the protection rule.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="modSecurityRuleIds")
    def mod_security_rule_ids(self) -> Sequence[builtins.str]:
        """
        The list of the ModSecurity rule IDs that apply to this protection rule. For more information about ModSecurity's open source WAF rules, see [Mod Security's documentation](https://www.modsecurity.org/CRS/Documentation/index.html).
        """
        return pulumi.get(self, "mod_security_rule_ids")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the protection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionRuleKey")
    def protection_rule_key(self) -> builtins.str:
        return pulumi.get(self, "protection_rule_key")

    @property
    @pulumi.getter(name="waasPolicyId")
    def waas_policy_id(self) -> builtins.str:
        return pulumi.get(self, "waas_policy_id")


class AwaitableGetProtectionRuleResult(GetProtectionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionRuleResult(
            action=self.action,
            description=self.description,
            exclusions=self.exclusions,
            id=self.id,
            key=self.key,
            labels=self.labels,
            mod_security_rule_ids=self.mod_security_rule_ids,
            name=self.name,
            protection_rule_key=self.protection_rule_key,
            waas_policy_id=self.waas_policy_id)


def get_protection_rule(protection_rule_key: Optional[builtins.str] = None,
                        waas_policy_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionRuleResult:
    """
    This data source provides details about a specific Protection Rule resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of a protection rule in the Web Application Firewall configuration for a WAAS policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protection_rule = oci.Waas.get_protection_rule(protection_rule_key=protection_rule_protection_rule_key,
        waas_policy_id=test_waas_policy["id"])
    ```


    :param builtins.str protection_rule_key: The protection rule key.
    :param builtins.str waas_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WAAS policy.
    """
    __args__ = dict()
    __args__['protectionRuleKey'] = protection_rule_key
    __args__['waasPolicyId'] = waas_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getProtectionRule:getProtectionRule', __args__, opts=opts, typ=GetProtectionRuleResult).value

    return AwaitableGetProtectionRuleResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        exclusions=pulumi.get(__ret__, 'exclusions'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        labels=pulumi.get(__ret__, 'labels'),
        mod_security_rule_ids=pulumi.get(__ret__, 'mod_security_rule_ids'),
        name=pulumi.get(__ret__, 'name'),
        protection_rule_key=pulumi.get(__ret__, 'protection_rule_key'),
        waas_policy_id=pulumi.get(__ret__, 'waas_policy_id'))
def get_protection_rule_output(protection_rule_key: Optional[pulumi.Input[builtins.str]] = None,
                               waas_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionRuleResult]:
    """
    This data source provides details about a specific Protection Rule resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of a protection rule in the Web Application Firewall configuration for a WAAS policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protection_rule = oci.Waas.get_protection_rule(protection_rule_key=protection_rule_protection_rule_key,
        waas_policy_id=test_waas_policy["id"])
    ```


    :param builtins.str protection_rule_key: The protection rule key.
    :param builtins.str waas_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WAAS policy.
    """
    __args__ = dict()
    __args__['protectionRuleKey'] = protection_rule_key
    __args__['waasPolicyId'] = waas_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waas/getProtectionRule:getProtectionRule', __args__, opts=opts, typ=GetProtectionRuleResult)
    return __ret__.apply(lambda __response__: GetProtectionRuleResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        exclusions=pulumi.get(__response__, 'exclusions'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        labels=pulumi.get(__response__, 'labels'),
        mod_security_rule_ids=pulumi.get(__response__, 'mod_security_rule_ids'),
        name=pulumi.get(__response__, 'name'),
        protection_rule_key=pulumi.get(__response__, 'protection_rule_key'),
        waas_policy_id=pulumi.get(__response__, 'waas_policy_id')))
