# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProtectionCapabilityGroupTagsResult',
    'AwaitableGetProtectionCapabilityGroupTagsResult',
    'get_protection_capability_group_tags',
    'get_protection_capability_group_tags_output',
]

@pulumi.output_type
class GetProtectionCapabilityGroupTagsResult:
    """
    A collection of values returned by getProtectionCapabilityGroupTags.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, protection_capability_group_tag_collections=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protection_capability_group_tag_collections and not isinstance(protection_capability_group_tag_collections, list):
            raise TypeError("Expected argument 'protection_capability_group_tag_collections' to be a list")
        pulumi.set(__self__, "protection_capability_group_tag_collections", protection_capability_group_tag_collections)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProtectionCapabilityGroupTagsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Unique name of protection capability group tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionCapabilityGroupTagCollections")
    def protection_capability_group_tag_collections(self) -> Sequence['outputs.GetProtectionCapabilityGroupTagsProtectionCapabilityGroupTagCollectionResult']:
        """
        The list of protection_capability_group_tag_collection.
        """
        return pulumi.get(self, "protection_capability_group_tag_collections")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetProtectionCapabilityGroupTagsResult(GetProtectionCapabilityGroupTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionCapabilityGroupTagsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            protection_capability_group_tag_collections=self.protection_capability_group_tag_collections,
            type=self.type)


def get_protection_capability_group_tags(compartment_id: Optional[builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetProtectionCapabilityGroupTagsFilterArgs', 'GetProtectionCapabilityGroupTagsFilterArgsDict']]] = None,
                                         name: Optional[builtins.str] = None,
                                         type: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionCapabilityGroupTagsResult:
    """
    This data source provides the list of Protection Capability Group Tags in Oracle Cloud Infrastructure Waf service.

    Lists of available group tags filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protection_capability_group_tags = oci.Waf.get_protection_capability_group_tags(compartment_id=compartment_id,
        name=protection_capability_group_tag_name,
        type=protection_capability_group_tag_type)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str type: A filter to return only resources that matches given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waf/getProtectionCapabilityGroupTags:getProtectionCapabilityGroupTags', __args__, opts=opts, typ=GetProtectionCapabilityGroupTagsResult).value

    return AwaitableGetProtectionCapabilityGroupTagsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        protection_capability_group_tag_collections=pulumi.get(__ret__, 'protection_capability_group_tag_collections'),
        type=pulumi.get(__ret__, 'type'))
def get_protection_capability_group_tags_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProtectionCapabilityGroupTagsFilterArgs', 'GetProtectionCapabilityGroupTagsFilterArgsDict']]]]] = None,
                                                name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionCapabilityGroupTagsResult]:
    """
    This data source provides the list of Protection Capability Group Tags in Oracle Cloud Infrastructure Waf service.

    Lists of available group tags filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protection_capability_group_tags = oci.Waf.get_protection_capability_group_tags(compartment_id=compartment_id,
        name=protection_capability_group_tag_name,
        type=protection_capability_group_tag_type)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str type: A filter to return only resources that matches given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waf/getProtectionCapabilityGroupTags:getProtectionCapabilityGroupTags', __args__, opts=opts, typ=GetProtectionCapabilityGroupTagsResult)
    return __ret__.apply(lambda __response__: GetProtectionCapabilityGroupTagsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        protection_capability_group_tag_collections=pulumi.get(__response__, 'protection_capability_group_tag_collections'),
        type=pulumi.get(__response__, 'type')))
