# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataAssetDataSourceDetails',
    'DataAssetDataSourceDetailsVersionSpecificDetails',
    'DetectAnomalyJobInputDetails',
    'DetectAnomalyJobInputDetailsData',
    'DetectAnomalyJobInputDetailsObjectLocation',
    'DetectAnomalyJobOutputDetails',
    'ModelModelTrainingDetails',
    'ModelModelTrainingResult',
    'ModelModelTrainingResultRowReductionDetail',
    'ModelModelTrainingResultSignalDetail',
    'GetAiPrivateEndpointsAiPrivateEndpointCollectionResult',
    'GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult',
    'GetAiPrivateEndpointsFilterResult',
    'GetDetectAnomalyJobInputDetailResult',
    'GetDetectAnomalyJobInputDetailDataResult',
    'GetDetectAnomalyJobInputDetailObjectLocationResult',
    'GetDetectAnomalyJobOutputDetailResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult',
    'GetDetectAnomalyJobsFilterResult',
    'GetDetectionDataAssetDataSourceDetailResult',
    'GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult',
    'GetDetectionDataAssetsDataAssetCollectionResult',
    'GetDetectionDataAssetsDataAssetCollectionItemResult',
    'GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult',
    'GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult',
    'GetDetectionDataAssetsFilterResult',
    'GetDetectionModelModelTrainingDetailResult',
    'GetDetectionModelModelTrainingResultResult',
    'GetDetectionModelModelTrainingResultRowReductionDetailResult',
    'GetDetectionModelModelTrainingResultSignalDetailResult',
    'GetDetectionModelsFilterResult',
    'GetDetectionModelsModelCollectionResult',
    'GetDetectionModelsModelCollectionItemResult',
    'GetDetectionModelsModelCollectionItemModelTrainingDetailResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult',
    'GetDetectionProjectsFilterResult',
    'GetDetectionProjectsProjectCollectionResult',
    'GetDetectionProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class DataAssetDataSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceType":
            suggest = "data_source_type"
        elif key == "atpPasswordSecretId":
            suggest = "atp_password_secret_id"
        elif key == "atpUserName":
            suggest = "atp_user_name"
        elif key == "cwalletFileSecretId":
            suggest = "cwallet_file_secret_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "ewalletFileSecretId":
            suggest = "ewallet_file_secret_id"
        elif key == "keyStoreFileSecretId":
            suggest = "key_store_file_secret_id"
        elif key == "measurementName":
            suggest = "measurement_name"
        elif key == "ojdbcFileSecretId":
            suggest = "ojdbc_file_secret_id"
        elif key == "passwordSecretId":
            suggest = "password_secret_id"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "tnsnamesFileSecretId":
            suggest = "tnsnames_file_secret_id"
        elif key == "truststoreFileSecretId":
            suggest = "truststore_file_secret_id"
        elif key == "userName":
            suggest = "user_name"
        elif key == "versionSpecificDetails":
            suggest = "version_specific_details"
        elif key == "walletPasswordSecretId":
            suggest = "wallet_password_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataAssetDataSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataAssetDataSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataAssetDataSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_type: builtins.str,
                 atp_password_secret_id: Optional[builtins.str] = None,
                 atp_user_name: Optional[builtins.str] = None,
                 bucket: Optional[builtins.str] = None,
                 cwallet_file_secret_id: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 ewallet_file_secret_id: Optional[builtins.str] = None,
                 key_store_file_secret_id: Optional[builtins.str] = None,
                 measurement_name: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None,
                 ojdbc_file_secret_id: Optional[builtins.str] = None,
                 password_secret_id: Optional[builtins.str] = None,
                 table_name: Optional[builtins.str] = None,
                 tnsnames_file_secret_id: Optional[builtins.str] = None,
                 truststore_file_secret_id: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None,
                 user_name: Optional[builtins.str] = None,
                 version_specific_details: Optional['outputs.DataAssetDataSourceDetailsVersionSpecificDetails'] = None,
                 wallet_password_secret_id: Optional[builtins.str] = None):
        """
        :param builtins.str data_source_type: Data source type where actually data asset is being stored
        :param builtins.str atp_password_secret_id: atp db password Secret Id
        :param builtins.str atp_user_name: atp db user name
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param builtins.str database_name: atp database name
        :param builtins.str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param builtins.str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param builtins.str measurement_name: Measurement name for influx
        :param builtins.str namespace: Object storage namespace
        :param builtins.str object: File name
        :param builtins.str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param builtins.str password_secret_id: Password Secret Id for the influx connection
        :param builtins.str table_name: atp database table name
        :param builtins.str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param builtins.str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param builtins.str url: public IP address and port to influx DB
        :param builtins.str user_name: Username for connection to Influx
        :param 'DataAssetDataSourceDetailsVersionSpecificDetailsArgs' version_specific_details: Possible data sources
        :param builtins.str wallet_password_secret_id: wallet password Secret ID in String format
        """
        pulumi.set(__self__, "data_source_type", data_source_type)
        if atp_password_secret_id is not None:
            pulumi.set(__self__, "atp_password_secret_id", atp_password_secret_id)
        if atp_user_name is not None:
            pulumi.set(__self__, "atp_user_name", atp_user_name)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cwallet_file_secret_id is not None:
            pulumi.set(__self__, "cwallet_file_secret_id", cwallet_file_secret_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if ewallet_file_secret_id is not None:
            pulumi.set(__self__, "ewallet_file_secret_id", ewallet_file_secret_id)
        if key_store_file_secret_id is not None:
            pulumi.set(__self__, "key_store_file_secret_id", key_store_file_secret_id)
        if measurement_name is not None:
            pulumi.set(__self__, "measurement_name", measurement_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if ojdbc_file_secret_id is not None:
            pulumi.set(__self__, "ojdbc_file_secret_id", ojdbc_file_secret_id)
        if password_secret_id is not None:
            pulumi.set(__self__, "password_secret_id", password_secret_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if tnsnames_file_secret_id is not None:
            pulumi.set(__self__, "tnsnames_file_secret_id", tnsnames_file_secret_id)
        if truststore_file_secret_id is not None:
            pulumi.set(__self__, "truststore_file_secret_id", truststore_file_secret_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version_specific_details is not None:
            pulumi.set(__self__, "version_specific_details", version_specific_details)
        if wallet_password_secret_id is not None:
            pulumi.set(__self__, "wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> Optional[builtins.str]:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> Optional[builtins.str]:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        atp database name
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> Optional[builtins.str]:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[builtins.str]:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[builtins.str]:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> Optional[builtins.str]:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[builtins.str]:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Optional['outputs.DataAssetDataSourceDetailsVersionSpecificDetails']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> Optional[builtins.str]:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class DataAssetDataSourceDetailsVersionSpecificDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "influxVersion":
            suggest = "influx_version"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "retentionPolicyName":
            suggest = "retention_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataAssetDataSourceDetailsVersionSpecificDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataAssetDataSourceDetailsVersionSpecificDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataAssetDataSourceDetailsVersionSpecificDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 influx_version: builtins.str,
                 bucket: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 retention_policy_name: Optional[builtins.str] = None):
        """
        :param builtins.str influx_version: Data source type where actually data asset is being stored
        :param builtins.str bucket: Bucket Name for influx connection
        :param builtins.str database_name: DB Name for influx connection
        :param builtins.str organization_name: Org name for the influx db
        :param builtins.str retention_policy_name: retention policy is how long the bucket would last
        """
        pulumi.set(__self__, "influx_version", influx_version)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if retention_policy_name is not None:
            pulumi.set(__self__, "retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> Optional[builtins.str]:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class DetectAnomalyJobInputDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputType":
            suggest = "input_type"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "objectLocations":
            suggest = "object_locations"
        elif key == "signalNames":
            suggest = "signal_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectAnomalyJobInputDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectAnomalyJobInputDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectAnomalyJobInputDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_type: builtins.str,
                 content: Optional[builtins.str] = None,
                 content_type: Optional[builtins.str] = None,
                 datas: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsData']] = None,
                 message: Optional[builtins.str] = None,
                 object_locations: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsObjectLocation']] = None,
                 signal_names: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str input_type: Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        :param Sequence['DetectAnomalyJobInputDetailsDataArgs'] datas: Array containing data.
        :param builtins.str message: Inline input details.
        :param Sequence['DetectAnomalyJobInputDetailsObjectLocationArgs'] object_locations: List of ObjectLocations.
        :param Sequence[builtins.str] signal_names: List of signal names.
        """
        pulumi.set(__self__, "input_type", input_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)
        if signal_names is not None:
            pulumi.set(__self__, "signal_names", signal_names)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> builtins.str:
        """
        Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.DetectAnomalyJobInputDetailsData']]:
        """
        Array containing data.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[Sequence['outputs.DetectAnomalyJobInputDetailsObjectLocation']]:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of signal names.
        """
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class DetectAnomalyJobInputDetailsData(dict):
    def __init__(__self__, *,
                 timestamp: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.float]] = None):
        """
        :param builtins.str timestamp: Nullable string representing timestamp.
        :param Sequence[builtins.float] values: Array of double precision values.
        """
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[builtins.str]:
        """
        Nullable string representing timestamp.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.float]]:
        """
        Array of double precision values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DetectAnomalyJobInputDetailsObjectLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace name.
        :param builtins.str object: Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DetectAnomalyJobOutputDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectAnomalyJobOutputDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectAnomalyJobOutputDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectAnomalyJobOutputDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 output_type: builtins.str,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace.
        :param builtins.str output_type: The type of output location. Allowed values are:
               * `OBJECT_STORAGE`: Object store output location.
        :param builtins.str prefix: Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "output_type", output_type)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> builtins.str:
        """
        The type of output location. Allowed values are:
        * `OBJECT_STORAGE`: Object store output location.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ModelModelTrainingDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataAssetIds":
            suggest = "data_asset_ids"
        elif key == "algorithmHint":
            suggest = "algorithm_hint"
        elif key == "targetFap":
            suggest = "target_fap"
        elif key == "trainingFraction":
            suggest = "training_fraction"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_asset_ids: Sequence[builtins.str],
                 algorithm_hint: Optional[builtins.str] = None,
                 target_fap: Optional[builtins.float] = None,
                 training_fraction: Optional[builtins.float] = None,
                 window_size: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param builtins.str algorithm_hint: User can choose specific algorithm for training.
        :param builtins.float target_fap: A target model accuracy metric user provides as their requirement
        :param builtins.float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param builtins.int window_size: This value would determine the window size of the training algorithm.
        """
        pulumi.set(__self__, "data_asset_ids", data_asset_ids)
        if algorithm_hint is not None:
            pulumi.set(__self__, "algorithm_hint", algorithm_hint)
        if target_fap is not None:
            pulumi.set(__self__, "target_fap", target_fap)
        if training_fraction is not None:
            pulumi.set(__self__, "training_fraction", training_fraction)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[builtins.str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> Optional[builtins.str]:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> Optional[builtins.float]:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> Optional[builtins.float]:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[builtins.int]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ModelModelTrainingResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isTrainingGoalAchieved":
            suggest = "is_training_goal_achieved"
        elif key == "maxInferenceSyncRows":
            suggest = "max_inference_sync_rows"
        elif key == "multivariateFap":
            suggest = "multivariate_fap"
        elif key == "rowReductionDetails":
            suggest = "row_reduction_details"
        elif key == "signalDetails":
            suggest = "signal_details"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fap: Optional[builtins.float] = None,
                 is_training_goal_achieved: Optional[builtins.bool] = None,
                 mae: Optional[builtins.float] = None,
                 max_inference_sync_rows: Optional[builtins.int] = None,
                 multivariate_fap: Optional[builtins.float] = None,
                 rmse: Optional[builtins.float] = None,
                 row_reduction_details: Optional[Sequence['outputs.ModelModelTrainingResultRowReductionDetail']] = None,
                 signal_details: Optional[Sequence['outputs.ModelModelTrainingResultSignalDetail']] = None,
                 warning: Optional[builtins.str] = None,
                 window_size: Optional[builtins.int] = None):
        """
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param builtins.float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['ModelModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['ModelModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param builtins.str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param builtins.int window_size: Window size defined during training or deduced by the algorithm.
        """
        if fap is not None:
            pulumi.set(__self__, "fap", fap)
        if is_training_goal_achieved is not None:
            pulumi.set(__self__, "is_training_goal_achieved", is_training_goal_achieved)
        if mae is not None:
            pulumi.set(__self__, "mae", mae)
        if max_inference_sync_rows is not None:
            pulumi.set(__self__, "max_inference_sync_rows", max_inference_sync_rows)
        if multivariate_fap is not None:
            pulumi.set(__self__, "multivariate_fap", multivariate_fap)
        if rmse is not None:
            pulumi.set(__self__, "rmse", rmse)
        if row_reduction_details is not None:
            pulumi.set(__self__, "row_reduction_details", row_reduction_details)
        if signal_details is not None:
            pulumi.set(__self__, "signal_details", signal_details)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> Optional[builtins.float]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> Optional[builtins.bool]:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> Optional[builtins.float]:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> Optional[builtins.float]:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> Optional[builtins.float]:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Optional[Sequence['outputs.ModelModelTrainingResultRowReductionDetail']]:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Optional[Sequence['outputs.ModelModelTrainingResultSignalDetail']]:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> Optional[builtins.str]:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[builtins.int]:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ModelModelTrainingResultRowReductionDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isReductionEnabled":
            suggest = "is_reduction_enabled"
        elif key == "reductionMethod":
            suggest = "reduction_method"
        elif key == "reductionPercentage":
            suggest = "reduction_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResultRowReductionDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResultRowReductionDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResultRowReductionDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_reduction_enabled: Optional[builtins.bool] = None,
                 reduction_method: Optional[builtins.str] = None,
                 reduction_percentage: Optional[builtins.float] = None):
        """
        :param builtins.bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param builtins.str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param builtins.float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        if is_reduction_enabled is not None:
            pulumi.set(__self__, "is_reduction_enabled", is_reduction_enabled)
        if reduction_method is not None:
            pulumi.set(__self__, "reduction_method", reduction_method)
        if reduction_percentage is not None:
            pulumi.set(__self__, "reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> Optional[builtins.bool]:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> Optional[builtins.str]:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> Optional[builtins.float]:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class ModelModelTrainingResultSignalDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isQuantized":
            suggest = "is_quantized"
        elif key == "mviRatio":
            suggest = "mvi_ratio"
        elif key == "signalName":
            suggest = "signal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResultSignalDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResultSignalDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResultSignalDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Optional[builtins.str] = None,
                 fap: Optional[builtins.float] = None,
                 is_quantized: Optional[builtins.bool] = None,
                 max: Optional[builtins.float] = None,
                 min: Optional[builtins.float] = None,
                 mvi_ratio: Optional[builtins.float] = None,
                 signal_name: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 std: Optional[builtins.float] = None):
        """
        :param builtins.str details: detailed information for a signal.
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param builtins.float max: Max value within a signal.
        :param builtins.float min: Min value within a signal.
        :param builtins.float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param builtins.str signal_name: The name of a signal.
        :param builtins.str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param builtins.float std: Standard deviation of values within a signal.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if fap is not None:
            pulumi.set(__self__, "fap", fap)
        if is_quantized is not None:
            pulumi.set(__self__, "is_quantized", is_quantized)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if mvi_ratio is not None:
            pulumi.set(__self__, "mvi_ratio", mvi_ratio)
        if signal_name is not None:
            pulumi.set(__self__, "signal_name", signal_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if std is not None:
            pulumi.set(__self__, "std", std)

    @property
    @pulumi.getter
    def details(self) -> Optional[builtins.str]:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> Optional[builtins.float]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> Optional[builtins.bool]:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> Optional[builtins.float]:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[builtins.float]:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> Optional[builtins.float]:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> Optional[builtins.str]:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> Optional[builtins.float]:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetAiPrivateEndpointsAiPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 attached_data_assets: Sequence[builtins.str],
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 dns_zones: Sequence[builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param Sequence[builtins.str] attached_data_assets: The list of dataAssets using the private reverse connection endpoint.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence[builtins.str] dns_zones: List of DNS zones to be used by the data assets. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: unique AiPrivateEndpoint identifier
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param builtins.str subnet_id: Subnet Identifier
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param builtins.str time_updated: The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "attached_data_assets", attached_data_assets)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_zones", dns_zones)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedDataAssets")
    def attached_data_assets(self) -> Sequence[builtins.str]:
        """
        The list of dataAssets using the private reverse connection endpoint.
        """
        return pulumi.get(self, "attached_data_assets")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[builtins.str]:
        """
        List of DNS zones to be used by the data assets. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        unique AiPrivateEndpoint identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAiPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: builtins.str,
                 datas: Sequence['outputs.GetDetectAnomalyJobInputDetailDataResult'],
                 input_type: builtins.str,
                 message: builtins.str,
                 object_locations: Sequence['outputs.GetDetectAnomalyJobInputDetailObjectLocationResult'],
                 signal_names: Sequence[builtins.str]):
        """
        :param builtins.str input_type: The type of input location Allowed values are:
               * `INLINE`: Inline input data.
               * `OBJECT_LIST`: Object store output location.
        :param builtins.str message: Inline input details.
        :param Sequence['GetDetectAnomalyJobInputDetailObjectLocationArgs'] object_locations: List of ObjectLocations.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "input_type", input_type)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "object_locations", object_locations)
        pulumi.set(__self__, "signal_names", signal_names)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetDetectAnomalyJobInputDetailDataResult']:
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> builtins.str:
        """
        The type of input location Allowed values are:
        * `INLINE`: Inline input data.
        * `OBJECT_LIST`: Object store output location.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetDetectAnomalyJobInputDetailObjectLocationResult']:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailDataResult(dict):
    def __init__(__self__, *,
                 timestamp: builtins.str,
                 values: Sequence[builtins.float]):
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace.
        :param builtins.str object: Object Storage object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDetectAnomalyJobOutputDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 output_type: builtins.str,
                 prefix: builtins.str):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace.
        :param builtins.str output_type: The type of output location Allowed values are:
               * `OBJECT_STORAGE`: Object store output location.
        :param builtins.str prefix: Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "output_type", output_type)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> builtins.str:
        """
        The type of output location Allowed values are:
        * `OBJECT_STORAGE`: Object store output location.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 input_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult'],
                 lifecycle_state_details: builtins.str,
                 model_id: builtins.str,
                 output_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult'],
                 project_id: builtins.str,
                 sensitivity: builtins.float,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_accepted: builtins.str,
                 time_finished: builtins.str,
                 time_started: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: Detect anomaly job description.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Id of the job.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailArgs'] input_details: Input details for detect anomaly job.
        :param builtins.str lifecycle_state_details: The current state details of the batch document job.
        :param builtins.str model_id: The ID of the trained model for which to list the resources.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailArgs'] output_details: Output details for detect anomaly job.
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.float sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_accepted: Job accepted time
        :param builtins.str time_finished: Job finished time
        :param builtins.str time_started: Job started time
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "input_details", input_details)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "output_details", output_details)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "sensitivity", sensitivity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_accepted", time_accepted)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Detect anomaly job description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Id of the job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputDetails")
    def input_details(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult']:
        """
        Input details for detect anomaly job.
        """
        return pulumi.get(self, "input_details")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        The current state details of the batch document job.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The ID of the trained model for which to list the resources.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="outputDetails")
    def output_details(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult']:
        """
        Output details for detect anomaly job.
        """
        return pulumi.get(self, "output_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def sensitivity(self) -> builtins.float:
        """
        The value that customer can adjust to control the sensitivity of anomaly detection
        """
        return pulumi.get(self, "sensitivity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> builtins.str:
        """
        Job accepted time
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> builtins.str:
        """
        Job finished time
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> builtins.str:
        """
        Job started time
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: builtins.str,
                 datas: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult'],
                 input_type: builtins.str,
                 message: builtins.str,
                 object_locations: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult'],
                 signal_names: Sequence[builtins.str]):
        """
        :param builtins.str input_type: The type of input location Allowed values are:
               * `INLINE`: Inline input data.
               * `OBJECT_LIST`: Object store output location.
        :param builtins.str message: Inline input details.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationArgs'] object_locations: List of ObjectLocations.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "input_type", input_type)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "object_locations", object_locations)
        pulumi.set(__self__, "signal_names", signal_names)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult']:
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> builtins.str:
        """
        The type of input location Allowed values are:
        * `INLINE`: Inline input data.
        * `OBJECT_LIST`: Object store output location.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult']:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult(dict):
    def __init__(__self__, *,
                 timestamp: builtins.str,
                 values: Sequence[builtins.float]):
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.float]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace.
        :param builtins.str object: Object Storage object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 output_type: builtins.str,
                 prefix: builtins.str):
        """
        :param builtins.str bucket: Object Storage bucket name.
        :param builtins.str namespace: Object Storage namespace.
        :param builtins.str output_type: The type of output location Allowed values are:
               * `OBJECT_STORAGE`: Object store output location.
        :param builtins.str prefix: Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "output_type", output_type)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> builtins.str:
        """
        The type of output location Allowed values are:
        * `OBJECT_STORAGE`: Object store output location.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetDetectAnomalyJobsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionDataAssetDataSourceDetailResult(dict):
    def __init__(__self__, *,
                 atp_password_secret_id: builtins.str,
                 atp_user_name: builtins.str,
                 bucket: builtins.str,
                 cwallet_file_secret_id: builtins.str,
                 data_source_type: builtins.str,
                 database_name: builtins.str,
                 ewallet_file_secret_id: builtins.str,
                 key_store_file_secret_id: builtins.str,
                 measurement_name: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str,
                 ojdbc_file_secret_id: builtins.str,
                 password_secret_id: builtins.str,
                 table_name: builtins.str,
                 tnsnames_file_secret_id: builtins.str,
                 truststore_file_secret_id: builtins.str,
                 url: builtins.str,
                 user_name: builtins.str,
                 version_specific_details: Sequence['outputs.GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult'],
                 wallet_password_secret_id: builtins.str):
        """
        :param builtins.str atp_password_secret_id: atp db password Secret Id
        :param builtins.str atp_user_name: atp db user name
        :param builtins.str bucket: Bucket Name for influx connection
        :param builtins.str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param builtins.str data_source_type: Data source type where actually data asset is being stored
        :param builtins.str database_name: DB Name for influx connection
        :param builtins.str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param builtins.str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param builtins.str measurement_name: Measurement name for influx
        :param builtins.str namespace: Object storage namespace
        :param builtins.str object: File name
        :param builtins.str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param builtins.str password_secret_id: Password Secret Id for the influx connection
        :param builtins.str table_name: atp database table name
        :param builtins.str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param builtins.str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param builtins.str url: public IP address and port to influx DB
        :param builtins.str user_name: Username for connection to Influx
        :param Sequence['GetDetectionDataAssetDataSourceDetailVersionSpecificDetailArgs'] version_specific_details: Possible data sources
        :param builtins.str wallet_password_secret_id: wallet password Secret ID in String format
        """
        pulumi.set(__self__, "atp_password_secret_id", atp_password_secret_id)
        pulumi.set(__self__, "atp_user_name", atp_user_name)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "cwallet_file_secret_id", cwallet_file_secret_id)
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ewallet_file_secret_id", ewallet_file_secret_id)
        pulumi.set(__self__, "key_store_file_secret_id", key_store_file_secret_id)
        pulumi.set(__self__, "measurement_name", measurement_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "ojdbc_file_secret_id", ojdbc_file_secret_id)
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "tnsnames_file_secret_id", tnsnames_file_secret_id)
        pulumi.set(__self__, "truststore_file_secret_id", truststore_file_secret_id)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version_specific_details", version_specific_details)
        pulumi.set(__self__, "wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> builtins.str:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> builtins.str:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> builtins.str:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> builtins.str:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Sequence['outputs.GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> builtins.str:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 database_name: builtins.str,
                 influx_version: builtins.str,
                 organization_name: builtins.str,
                 retention_policy_name: builtins.str):
        """
        :param builtins.str bucket: Bucket Name for influx connection
        :param builtins.str database_name: DB Name for influx connection
        :param builtins.str influx_version: Data source type where actually data asset is being stored
        :param builtins.str organization_name: Org name for the influx db
        :param builtins.str retention_policy_name: retention policy is how long the bucket would last
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "influx_version", influx_version)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> builtins.str:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> builtins.str:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 data_source_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult'],
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 private_endpoint_id: builtins.str,
                 project_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailArgs'] data_source_details: Possible data sources
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of the data asset.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The Unique Oracle ID (OCID) that is immutable on creation.
        :param builtins.str private_endpoint_id: OCID of Private Endpoint.
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the DataAsset was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_source_details", data_source_details)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of the data asset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Unique Oracle ID (OCID) that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> builtins.str:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the DataAsset was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult(dict):
    def __init__(__self__, *,
                 atp_password_secret_id: builtins.str,
                 atp_user_name: builtins.str,
                 bucket: builtins.str,
                 cwallet_file_secret_id: builtins.str,
                 data_source_type: builtins.str,
                 database_name: builtins.str,
                 ewallet_file_secret_id: builtins.str,
                 key_store_file_secret_id: builtins.str,
                 measurement_name: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str,
                 ojdbc_file_secret_id: builtins.str,
                 password_secret_id: builtins.str,
                 table_name: builtins.str,
                 tnsnames_file_secret_id: builtins.str,
                 truststore_file_secret_id: builtins.str,
                 url: builtins.str,
                 user_name: builtins.str,
                 version_specific_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult'],
                 wallet_password_secret_id: builtins.str):
        """
        :param builtins.str atp_password_secret_id: atp db password Secret Id
        :param builtins.str atp_user_name: atp db user name
        :param builtins.str bucket: Bucket Name for influx connection
        :param builtins.str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param builtins.str data_source_type: Data source type where actually data asset is being stored
        :param builtins.str database_name: DB Name for influx connection
        :param builtins.str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param builtins.str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param builtins.str measurement_name: Measurement name for influx
        :param builtins.str namespace: Object storage namespace
        :param builtins.str object: File name
        :param builtins.str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param builtins.str password_secret_id: Password Secret Id for the influx connection
        :param builtins.str table_name: atp database table name
        :param builtins.str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param builtins.str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param builtins.str url: public IP address and port to influx DB
        :param builtins.str user_name: Username for connection to Influx
        :param Sequence['GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailArgs'] version_specific_details: Possible data sources
        :param builtins.str wallet_password_secret_id: wallet password Secret ID in String format
        """
        pulumi.set(__self__, "atp_password_secret_id", atp_password_secret_id)
        pulumi.set(__self__, "atp_user_name", atp_user_name)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "cwallet_file_secret_id", cwallet_file_secret_id)
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "ewallet_file_secret_id", ewallet_file_secret_id)
        pulumi.set(__self__, "key_store_file_secret_id", key_store_file_secret_id)
        pulumi.set(__self__, "measurement_name", measurement_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "ojdbc_file_secret_id", ojdbc_file_secret_id)
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "tnsnames_file_secret_id", tnsnames_file_secret_id)
        pulumi.set(__self__, "truststore_file_secret_id", truststore_file_secret_id)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version_specific_details", version_specific_details)
        pulumi.set(__self__, "wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> builtins.str:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> builtins.str:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> builtins.str:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> builtins.str:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> builtins.str:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> builtins.str:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 database_name: builtins.str,
                 influx_version: builtins.str,
                 organization_name: builtins.str,
                 retention_policy_name: builtins.str):
        """
        :param builtins.str bucket: Bucket Name for influx connection
        :param builtins.str database_name: DB Name for influx connection
        :param builtins.str influx_version: Data source type where actually data asset is being stored
        :param builtins.str organization_name: Org name for the influx db
        :param builtins.str retention_policy_name: retention policy is how long the bucket would last
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "influx_version", influx_version)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> builtins.str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> builtins.str:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> builtins.str:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class GetDetectionDataAssetsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionModelModelTrainingDetailResult(dict):
    def __init__(__self__, *,
                 algorithm_hint: builtins.str,
                 data_asset_ids: Sequence[builtins.str],
                 target_fap: builtins.float,
                 training_fraction: builtins.float,
                 window_size: builtins.int):
        """
        :param builtins.str algorithm_hint: User can choose specific algorithm for training.
        :param Sequence[builtins.str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param builtins.float target_fap: A target model accuracy metric user provides as their requirement
        :param builtins.float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param builtins.int window_size: Window size defined during training or deduced by the algorithm.
        """
        pulumi.set(__self__, "algorithm_hint", algorithm_hint)
        pulumi.set(__self__, "data_asset_ids", data_asset_ids)
        pulumi.set(__self__, "target_fap", target_fap)
        pulumi.set(__self__, "training_fraction", training_fraction)
        pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> builtins.str:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[builtins.str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> builtins.float:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> builtins.float:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> builtins.int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelModelTrainingResultResult(dict):
    def __init__(__self__, *,
                 fap: builtins.float,
                 is_training_goal_achieved: builtins.bool,
                 mae: builtins.float,
                 max_inference_sync_rows: builtins.int,
                 multivariate_fap: builtins.float,
                 rmse: builtins.float,
                 row_reduction_details: Sequence['outputs.GetDetectionModelModelTrainingResultRowReductionDetailResult'],
                 signal_details: Sequence['outputs.GetDetectionModelModelTrainingResultSignalDetailResult'],
                 warning: builtins.str,
                 window_size: builtins.int):
        """
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param builtins.float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['GetDetectionModelModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['GetDetectionModelModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param builtins.str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param builtins.int window_size: Window size defined during training or deduced by the algorithm.
        """
        pulumi.set(__self__, "fap", fap)
        pulumi.set(__self__, "is_training_goal_achieved", is_training_goal_achieved)
        pulumi.set(__self__, "mae", mae)
        pulumi.set(__self__, "max_inference_sync_rows", max_inference_sync_rows)
        pulumi.set(__self__, "multivariate_fap", multivariate_fap)
        pulumi.set(__self__, "rmse", rmse)
        pulumi.set(__self__, "row_reduction_details", row_reduction_details)
        pulumi.set(__self__, "signal_details", signal_details)
        pulumi.set(__self__, "warning", warning)
        pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> builtins.float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> builtins.bool:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> builtins.float:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> builtins.int:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> builtins.float:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> builtins.float:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Sequence['outputs.GetDetectionModelModelTrainingResultRowReductionDetailResult']:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Sequence['outputs.GetDetectionModelModelTrainingResultSignalDetailResult']:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> builtins.str:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> builtins.int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelModelTrainingResultRowReductionDetailResult(dict):
    def __init__(__self__, *,
                 is_reduction_enabled: builtins.bool,
                 reduction_method: builtins.str,
                 reduction_percentage: builtins.float):
        """
        :param builtins.bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param builtins.str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param builtins.float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        pulumi.set(__self__, "is_reduction_enabled", is_reduction_enabled)
        pulumi.set(__self__, "reduction_method", reduction_method)
        pulumi.set(__self__, "reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> builtins.bool:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> builtins.str:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> builtins.float:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class GetDetectionModelModelTrainingResultSignalDetailResult(dict):
    def __init__(__self__, *,
                 details: builtins.str,
                 fap: builtins.float,
                 is_quantized: builtins.bool,
                 max: builtins.float,
                 min: builtins.float,
                 mvi_ratio: builtins.float,
                 signal_name: builtins.str,
                 status: builtins.str,
                 std: builtins.float):
        """
        :param builtins.str details: detailed information for a signal.
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param builtins.float max: Max value within a signal.
        :param builtins.float min: Min value within a signal.
        :param builtins.float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param builtins.str signal_name: The name of a signal.
        :param builtins.str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param builtins.float std: Standard deviation of values within a signal.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "fap", fap)
        pulumi.set(__self__, "is_quantized", is_quantized)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "mvi_ratio", mvi_ratio)
        pulumi.set(__self__, "signal_name", signal_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "std", std)

    @property
    @pulumi.getter
    def details(self) -> builtins.str:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> builtins.float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> builtins.bool:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> builtins.float:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.float:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> builtins.float:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> builtins.str:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> builtins.float:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetDetectionModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 model_training_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingDetailResult'],
                 model_training_results: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultResult'],
                 project_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of the Model.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The OCID of the model that is immutable on creation.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingDetailArgs'] model_training_details: Specifies the details of the MSET model during the create call.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultArgs'] model_training_results: Specifies the details for an Anomaly Detection model trained with MSET.
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the Model was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the Model was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "model_training_details", model_training_details)
        pulumi.set(__self__, "model_training_results", model_training_results)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of the Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the model that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelTrainingDetails")
    def model_training_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingDetailResult']:
        """
        Specifies the details of the MSET model during the create call.
        """
        return pulumi.get(self, "model_training_details")

    @property
    @pulumi.getter(name="modelTrainingResults")
    def model_training_results(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultResult']:
        """
        Specifies the details for an Anomaly Detection model trained with MSET.
        """
        return pulumi.get(self, "model_training_results")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingDetailResult(dict):
    def __init__(__self__, *,
                 algorithm_hint: builtins.str,
                 data_asset_ids: Sequence[builtins.str],
                 target_fap: builtins.float,
                 training_fraction: builtins.float,
                 window_size: builtins.int):
        """
        :param builtins.str algorithm_hint: User can choose specific algorithm for training.
        :param Sequence[builtins.str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param builtins.float target_fap: A target model accuracy metric user provides as their requirement
        :param builtins.float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param builtins.int window_size: Window size defined during training or deduced by the algorithm.
        """
        pulumi.set(__self__, "algorithm_hint", algorithm_hint)
        pulumi.set(__self__, "data_asset_ids", data_asset_ids)
        pulumi.set(__self__, "target_fap", target_fap)
        pulumi.set(__self__, "training_fraction", training_fraction)
        pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> builtins.str:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[builtins.str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> builtins.float:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> builtins.float:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> builtins.int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultResult(dict):
    def __init__(__self__, *,
                 fap: builtins.float,
                 is_training_goal_achieved: builtins.bool,
                 mae: builtins.float,
                 max_inference_sync_rows: builtins.int,
                 multivariate_fap: builtins.float,
                 rmse: builtins.float,
                 row_reduction_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult'],
                 signal_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult'],
                 warning: builtins.str,
                 window_size: builtins.int):
        """
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param builtins.float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param builtins.str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param builtins.int window_size: Window size defined during training or deduced by the algorithm.
        """
        pulumi.set(__self__, "fap", fap)
        pulumi.set(__self__, "is_training_goal_achieved", is_training_goal_achieved)
        pulumi.set(__self__, "mae", mae)
        pulumi.set(__self__, "max_inference_sync_rows", max_inference_sync_rows)
        pulumi.set(__self__, "multivariate_fap", multivariate_fap)
        pulumi.set(__self__, "rmse", rmse)
        pulumi.set(__self__, "row_reduction_details", row_reduction_details)
        pulumi.set(__self__, "signal_details", signal_details)
        pulumi.set(__self__, "warning", warning)
        pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> builtins.float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> builtins.bool:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> builtins.float:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> builtins.int:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> builtins.float:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> builtins.float:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult']:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult']:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> builtins.str:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> builtins.int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult(dict):
    def __init__(__self__, *,
                 is_reduction_enabled: builtins.bool,
                 reduction_method: builtins.str,
                 reduction_percentage: builtins.float):
        """
        :param builtins.bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param builtins.str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param builtins.float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        pulumi.set(__self__, "is_reduction_enabled", is_reduction_enabled)
        pulumi.set(__self__, "reduction_method", reduction_method)
        pulumi.set(__self__, "reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> builtins.bool:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> builtins.str:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> builtins.float:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult(dict):
    def __init__(__self__, *,
                 details: builtins.str,
                 fap: builtins.float,
                 is_quantized: builtins.bool,
                 max: builtins.float,
                 min: builtins.float,
                 mvi_ratio: builtins.float,
                 signal_name: builtins.str,
                 status: builtins.str,
                 std: builtins.float):
        """
        :param builtins.str details: detailed information for a signal.
        :param builtins.float fap: Accuracy metric for a signal.
        :param builtins.bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param builtins.float max: Max value within a signal.
        :param builtins.float min: Min value within a signal.
        :param builtins.float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param builtins.str signal_name: The name of a signal.
        :param builtins.str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param builtins.float std: Standard deviation of values within a signal.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "fap", fap)
        pulumi.set(__self__, "is_quantized", is_quantized)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "mvi_ratio", mvi_ratio)
        pulumi.set(__self__, "signal_name", signal_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "std", std)

    @property
    @pulumi.getter
    def details(self) -> builtins.str:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> builtins.float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> builtins.bool:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> builtins.float:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.float:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> builtins.float:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> builtins.str:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> builtins.float:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetDetectionProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionProjectsProjectCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of the project.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The OCID of the project that is immutable on creation.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param builtins.str time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the project that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


