# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProcessorJobResult',
    'AwaitableGetProcessorJobResult',
    'get_processor_job',
    'get_processor_job_output',
]

@pulumi.output_type
class GetProcessorJobResult:
    """
    A collection of values returned by getProcessorJob.
    """
    def __init__(__self__, compartment_id=None, display_name=None, id=None, input_locations=None, lifecycle_details=None, output_locations=None, percent_complete=None, processor_configs=None, processor_job_id=None, state=None, time_accepted=None, time_finished=None, time_started=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input_locations and not isinstance(input_locations, list):
            raise TypeError("Expected argument 'input_locations' to be a list")
        pulumi.set(__self__, "input_locations", input_locations)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if output_locations and not isinstance(output_locations, list):
            raise TypeError("Expected argument 'output_locations' to be a list")
        pulumi.set(__self__, "output_locations", output_locations)
        if percent_complete and not isinstance(percent_complete, float):
            raise TypeError("Expected argument 'percent_complete' to be a float")
        pulumi.set(__self__, "percent_complete", percent_complete)
        if processor_configs and not isinstance(processor_configs, list):
            raise TypeError("Expected argument 'processor_configs' to be a list")
        pulumi.set(__self__, "processor_configs", processor_configs)
        if processor_job_id and not isinstance(processor_job_id, str):
            raise TypeError("Expected argument 'processor_job_id' to be a str")
        pulumi.set(__self__, "processor_job_id", processor_job_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the processor job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputLocations")
    def input_locations(self) -> Sequence['outputs.GetProcessorJobInputLocationResult']:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_locations")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The detailed status of FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="outputLocations")
    def output_locations(self) -> Sequence['outputs.GetProcessorJobOutputLocationResult']:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_locations")

    @property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> builtins.float:
        """
        How much progress the operation has made, compared to the total amount of work to be performed.
        """
        return pulumi.get(self, "percent_complete")

    @property
    @pulumi.getter(name="processorConfigs")
    def processor_configs(self) -> Sequence['outputs.GetProcessorJobProcessorConfigResult']:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_configs")

    @property
    @pulumi.getter(name="processorJobId")
    def processor_job_id(self) -> builtins.str:
        return pulumi.get(self, "processor_job_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the processor job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> builtins.str:
        """
        The job acceptance time.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> builtins.str:
        """
        The job finish time.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> builtins.str:
        """
        The job start time.
        """
        return pulumi.get(self, "time_started")


class AwaitableGetProcessorJobResult(GetProcessorJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProcessorJobResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            id=self.id,
            input_locations=self.input_locations,
            lifecycle_details=self.lifecycle_details,
            output_locations=self.output_locations,
            percent_complete=self.percent_complete,
            processor_configs=self.processor_configs,
            processor_job_id=self.processor_job_id,
            state=self.state,
            time_accepted=self.time_accepted,
            time_finished=self.time_finished,
            time_started=self.time_started)


def get_processor_job(processor_job_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProcessorJobResult:
    """
    This data source provides details about a specific Processor Job resource in Oracle Cloud Infrastructure Ai Document service.

    Get the details of a processor job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_processor_job = oci.AiDocument.get_processor_job(processor_job_id=test_processor_job_oci_ai_document_processor_job["id"])
    ```


    :param builtins.str processor_job_id: Processor job id.
    """
    __args__ = dict()
    __args__['processorJobId'] = processor_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiDocument/getProcessorJob:getProcessorJob', __args__, opts=opts, typ=GetProcessorJobResult).value

    return AwaitableGetProcessorJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        input_locations=pulumi.get(__ret__, 'input_locations'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        output_locations=pulumi.get(__ret__, 'output_locations'),
        percent_complete=pulumi.get(__ret__, 'percent_complete'),
        processor_configs=pulumi.get(__ret__, 'processor_configs'),
        processor_job_id=pulumi.get(__ret__, 'processor_job_id'),
        state=pulumi.get(__ret__, 'state'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'))
def get_processor_job_output(processor_job_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProcessorJobResult]:
    """
    This data source provides details about a specific Processor Job resource in Oracle Cloud Infrastructure Ai Document service.

    Get the details of a processor job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_processor_job = oci.AiDocument.get_processor_job(processor_job_id=test_processor_job_oci_ai_document_processor_job["id"])
    ```


    :param builtins.str processor_job_id: Processor job id.
    """
    __args__ = dict()
    __args__['processorJobId'] = processor_job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiDocument/getProcessorJob:getProcessorJob', __args__, opts=opts, typ=GetProcessorJobResult)
    return __ret__.apply(lambda __response__: GetProcessorJobResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        input_locations=pulumi.get(__response__, 'input_locations'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        output_locations=pulumi.get(__response__, 'output_locations'),
        percent_complete=pulumi.get(__response__, 'percent_complete'),
        processor_configs=pulumi.get(__response__, 'processor_configs'),
        processor_job_id=pulumi.get(__response__, 'processor_job_id'),
        state=pulumi.get(__response__, 'state'),
        time_accepted=pulumi.get(__response__, 'time_accepted'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started')))
