# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetModelEvaluationResultsResult',
    'AwaitableGetModelEvaluationResultsResult',
    'get_model_evaluation_results',
    'get_model_evaluation_results_output',
]

@pulumi.output_type
class GetModelEvaluationResultsResult:
    """
    A collection of values returned by getModelEvaluationResults.
    """
    def __init__(__self__, evaluation_result_collections=None, filters=None, id=None, model_id=None):
        if evaluation_result_collections and not isinstance(evaluation_result_collections, list):
            raise TypeError("Expected argument 'evaluation_result_collections' to be a list")
        pulumi.set(__self__, "evaluation_result_collections", evaluation_result_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="evaluationResultCollections")
    def evaluation_result_collections(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionResult']:
        """
        The list of evaluation_result_collection.
        """
        return pulumi.get(self, "evaluation_result_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetModelEvaluationResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        return pulumi.get(self, "model_id")


class AwaitableGetModelEvaluationResultsResult(GetModelEvaluationResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelEvaluationResultsResult(
            evaluation_result_collections=self.evaluation_result_collections,
            filters=self.filters,
            id=self.id,
            model_id=self.model_id)


def get_model_evaluation_results(filters: Optional[Sequence[Union['GetModelEvaluationResultsFilterArgs', 'GetModelEvaluationResultsFilterArgsDict']]] = None,
                                 model_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelEvaluationResultsResult:
    """
    This data source provides the list of Model Evaluation Results in Oracle Cloud Infrastructure Ai Language service.

    Get a (paginated) list of evaluation results for a given model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_evaluation_results = oci.AiLanguage.get_model_evaluation_results(model_id=test_model["id"])
    ```


    :param builtins.str model_id: unique model OCID.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiLanguage/getModelEvaluationResults:getModelEvaluationResults', __args__, opts=opts, typ=GetModelEvaluationResultsResult).value

    return AwaitableGetModelEvaluationResultsResult(
        evaluation_result_collections=pulumi.get(__ret__, 'evaluation_result_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        model_id=pulumi.get(__ret__, 'model_id'))
def get_model_evaluation_results_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetModelEvaluationResultsFilterArgs', 'GetModelEvaluationResultsFilterArgsDict']]]]] = None,
                                        model_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelEvaluationResultsResult]:
    """
    This data source provides the list of Model Evaluation Results in Oracle Cloud Infrastructure Ai Language service.

    Get a (paginated) list of evaluation results for a given model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_evaluation_results = oci.AiLanguage.get_model_evaluation_results(model_id=test_model["id"])
    ```


    :param builtins.str model_id: unique model OCID.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiLanguage/getModelEvaluationResults:getModelEvaluationResults', __args__, opts=opts, typ=GetModelEvaluationResultsResult)
    return __ret__.apply(lambda __response__: GetModelEvaluationResultsResult(
        evaluation_result_collections=pulumi.get(__response__, 'evaluation_result_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        model_id=pulumi.get(__response__, 'model_id')))
