# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceListOsPatchesResult',
    'AwaitableGetBdsInstanceListOsPatchesResult',
    'get_bds_instance_list_os_patches',
    'get_bds_instance_list_os_patches_output',
]

@pulumi.output_type
class GetBdsInstanceListOsPatchesResult:
    """
    A collection of values returned by getBdsInstanceListOsPatches.
    """
    def __init__(__self__, bds_instance_id=None, filters=None, id=None, os_patches=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if os_patches and not isinstance(os_patches, list):
            raise TypeError("Expected argument 'os_patches' to be a list")
        pulumi.set(__self__, "os_patches", os_patches)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceListOsPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osPatches")
    def os_patches(self) -> Sequence['outputs.GetBdsInstanceListOsPatchesOsPatchResult']:
        """
        The list of os_patches.
        """
        return pulumi.get(self, "os_patches")


class AwaitableGetBdsInstanceListOsPatchesResult(GetBdsInstanceListOsPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceListOsPatchesResult(
            bds_instance_id=self.bds_instance_id,
            filters=self.filters,
            id=self.id,
            os_patches=self.os_patches)


def get_bds_instance_list_os_patches(bds_instance_id: Optional[builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetBdsInstanceListOsPatchesFilterArgs', 'GetBdsInstanceListOsPatchesFilterArgsDict']]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceListOsPatchesResult:
    """
    This data source provides the list of Bds Instance List Os Patches in Oracle Cloud Infrastructure Big Data Service service.

    List all available os patches for a given cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_list_os_patches = oci.BigDataService.get_bds_instance_list_os_patches(bds_instance_id=test_bds_instance["id"])
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceListOsPatches:getBdsInstanceListOsPatches', __args__, opts=opts, typ=GetBdsInstanceListOsPatchesResult).value

    return AwaitableGetBdsInstanceListOsPatchesResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        os_patches=pulumi.get(__ret__, 'os_patches'))
def get_bds_instance_list_os_patches_output(bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceListOsPatchesFilterArgs', 'GetBdsInstanceListOsPatchesFilterArgsDict']]]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceListOsPatchesResult]:
    """
    This data source provides the list of Bds Instance List Os Patches in Oracle Cloud Infrastructure Big Data Service service.

    List all available os patches for a given cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_list_os_patches = oci.BigDataService.get_bds_instance_list_os_patches(bds_instance_id=test_bds_instance["id"])
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceListOsPatches:getBdsInstanceListOsPatches', __args__, opts=opts, typ=GetBdsInstanceListOsPatchesResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceListOsPatchesResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        os_patches=pulumi.get(__response__, 'os_patches')))
