# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternalNamespaceOccOverviewsResult',
    'AwaitableGetInternalNamespaceOccOverviewsResult',
    'get_internal_namespace_occ_overviews',
    'get_internal_namespace_occ_overviews_output',
]

@pulumi.output_type
class GetInternalNamespaceOccOverviewsResult:
    """
    A collection of values returned by getInternalNamespaceOccOverviews.
    """
    def __init__(__self__, compartment_id=None, filters=None, from_=None, id=None, namespace=None, occ_customer_group_id=None, occ_overview_collections=None, to=None, workload_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if from_ and not isinstance(from_, str):
            raise TypeError("Expected argument 'from_' to be a str")
        pulumi.set(__self__, "from_", from_)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if occ_overview_collections and not isinstance(occ_overview_collections, list):
            raise TypeError("Expected argument 'occ_overview_collections' to be a list")
        pulumi.set(__self__, "occ_overview_collections", occ_overview_collections)
        if to and not isinstance(to, str):
            raise TypeError("Expected argument 'to' to be a str")
        pulumi.set(__self__, "to", to)
        if workload_type and not isinstance(workload_type, str):
            raise TypeError("Expected argument 'workload_type' to be a str")
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment from which the api call is made. This will be used for authorizing the request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternalNamespaceOccOverviewsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[builtins.str]:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> builtins.str:
        return pulumi.get(self, "occ_customer_group_id")

    @property
    @pulumi.getter(name="occOverviewCollections")
    def occ_overview_collections(self) -> Sequence['outputs.GetInternalNamespaceOccOverviewsOccOverviewCollectionResult']:
        """
        The list of occ_overview_collection.
        """
        return pulumi.get(self, "occ_overview_collections")

    @property
    @pulumi.getter
    def to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "to")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "workload_type")


class AwaitableGetInternalNamespaceOccOverviewsResult(GetInternalNamespaceOccOverviewsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalNamespaceOccOverviewsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            from_=self.from_,
            id=self.id,
            namespace=self.namespace,
            occ_customer_group_id=self.occ_customer_group_id,
            occ_overview_collections=self.occ_overview_collections,
            to=self.to,
            workload_type=self.workload_type)


def get_internal_namespace_occ_overviews(compartment_id: Optional[builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetInternalNamespaceOccOverviewsFilterArgs', 'GetInternalNamespaceOccOverviewsFilterArgsDict']]] = None,
                                         from_: Optional[builtins.str] = None,
                                         namespace: Optional[builtins.str] = None,
                                         occ_customer_group_id: Optional[builtins.str] = None,
                                         to: Optional[builtins.str] = None,
                                         workload_type: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalNamespaceOccOverviewsResult:
    """
    This data source provides the list of Internal Namespace Occ Overviews in Oracle Cloud Infrastructure Capacity Management service.

    Lists an overview of all resources in that namespace in a given time interval.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_namespace_occ_overviews = oci.CapacityManagement.get_internal_namespace_occ_overviews(compartment_id=compartment_id,
        namespace=internal_namespace_occ_overview_namespace,
        occ_customer_group_id=test_occ_customer_group["id"],
        from_=internal_namespace_occ_overview_from,
        to=internal_namespace_occ_overview_to,
        workload_type=internal_namespace_occ_overview_workload_type)
    ```


    :param builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param builtins.str from_: The month corresponding to this date would be considered as the starting point of the time period against which we would like to perform an aggregation.
    :param builtins.str namespace: The namespace by which we would filter the list.
    :param builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param builtins.str to: The month corresponding to this date would be considered as the ending point of the time period against which we would like to perform an aggregation.
    :param builtins.str workload_type: Workload type using the resources in an availability catalog can be filtered.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['from'] = from_
    __args__['namespace'] = namespace
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['to'] = to
    __args__['workloadType'] = workload_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getInternalNamespaceOccOverviews:getInternalNamespaceOccOverviews', __args__, opts=opts, typ=GetInternalNamespaceOccOverviewsResult).value

    return AwaitableGetInternalNamespaceOccOverviewsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        from_=pulumi.get(__ret__, 'from_'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        occ_overview_collections=pulumi.get(__ret__, 'occ_overview_collections'),
        to=pulumi.get(__ret__, 'to'),
        workload_type=pulumi.get(__ret__, 'workload_type'))
def get_internal_namespace_occ_overviews_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInternalNamespaceOccOverviewsFilterArgs', 'GetInternalNamespaceOccOverviewsFilterArgsDict']]]]] = None,
                                                from_: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                namespace: Optional[pulumi.Input[builtins.str]] = None,
                                                occ_customer_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                                to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                workload_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInternalNamespaceOccOverviewsResult]:
    """
    This data source provides the list of Internal Namespace Occ Overviews in Oracle Cloud Infrastructure Capacity Management service.

    Lists an overview of all resources in that namespace in a given time interval.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_namespace_occ_overviews = oci.CapacityManagement.get_internal_namespace_occ_overviews(compartment_id=compartment_id,
        namespace=internal_namespace_occ_overview_namespace,
        occ_customer_group_id=test_occ_customer_group["id"],
        from_=internal_namespace_occ_overview_from,
        to=internal_namespace_occ_overview_to,
        workload_type=internal_namespace_occ_overview_workload_type)
    ```


    :param builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param builtins.str from_: The month corresponding to this date would be considered as the starting point of the time period against which we would like to perform an aggregation.
    :param builtins.str namespace: The namespace by which we would filter the list.
    :param builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param builtins.str to: The month corresponding to this date would be considered as the ending point of the time period against which we would like to perform an aggregation.
    :param builtins.str workload_type: Workload type using the resources in an availability catalog can be filtered.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['from'] = from_
    __args__['namespace'] = namespace
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['to'] = to
    __args__['workloadType'] = workload_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getInternalNamespaceOccOverviews:getInternalNamespaceOccOverviews', __args__, opts=opts, typ=GetInternalNamespaceOccOverviewsResult)
    return __ret__.apply(lambda __response__: GetInternalNamespaceOccOverviewsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        from_=pulumi.get(__response__, 'from_'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        occ_overview_collections=pulumi.get(__response__, 'occ_overview_collections'),
        to=pulumi.get(__response__, 'to'),
        workload_type=pulumi.get(__response__, 'workload_type')))
