# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMigrationPlansResult',
    'AwaitableGetMigrationPlansResult',
    'get_migration_plans',
    'get_migration_plans_output',
]

@pulumi.output_type
class GetMigrationPlansResult:
    """
    A collection of values returned by getMigrationPlans.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, migration_id=None, migration_plan_collections=None, migration_plan_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if migration_id and not isinstance(migration_id, str):
            raise TypeError("Expected argument 'migration_id' to be a str")
        pulumi.set(__self__, "migration_id", migration_id)
        if migration_plan_collections and not isinstance(migration_plan_collections, list):
            raise TypeError("Expected argument 'migration_plan_collections' to be a list")
        pulumi.set(__self__, "migration_plan_collections", migration_plan_collections)
        if migration_plan_id and not isinstance(migration_plan_id, str):
            raise TypeError("Expected argument 'migration_plan_id' to be a str")
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment containing the migration plan.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMigrationPlansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[builtins.str]:
        """
        The OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="migrationPlanCollections")
    def migration_plan_collections(self) -> Sequence['outputs.GetMigrationPlansMigrationPlanCollectionResult']:
        """
        The list of migration_plan_collection.
        """
        return pulumi.get(self, "migration_plan_collections")

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "migration_plan_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the migration plan.
        """
        return pulumi.get(self, "state")


class AwaitableGetMigrationPlansResult(GetMigrationPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationPlansResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            migration_id=self.migration_id,
            migration_plan_collections=self.migration_plan_collections,
            migration_plan_id=self.migration_plan_id,
            state=self.state)


def get_migration_plans(compartment_id: Optional[builtins.str] = None,
                        display_name: Optional[builtins.str] = None,
                        filters: Optional[Sequence[Union['GetMigrationPlansFilterArgs', 'GetMigrationPlansFilterArgsDict']]] = None,
                        migration_id: Optional[builtins.str] = None,
                        migration_plan_id: Optional[builtins.str] = None,
                        state: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationPlansResult:
    """
    This data source provides the list of Migration Plans in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migration plans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plans = oci.CloudMigrations.get_migration_plans(compartment_id=compartment_id,
        display_name=migration_plan_display_name,
        migration_id=test_migration["id"],
        migration_plan_id=test_migration_plan["id"],
        state=migration_plan_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire given display name.
    :param builtins.str migration_id: Unique migration identifier
    :param builtins.str migration_plan_id: Unique migration plan identifier
    :param builtins.str state: The current state of the migration plan.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationId'] = migration_id
    __args__['migrationPlanId'] = migration_plan_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getMigrationPlans:getMigrationPlans', __args__, opts=opts, typ=GetMigrationPlansResult).value

    return AwaitableGetMigrationPlansResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        migration_id=pulumi.get(__ret__, 'migration_id'),
        migration_plan_collections=pulumi.get(__ret__, 'migration_plan_collections'),
        migration_plan_id=pulumi.get(__ret__, 'migration_plan_id'),
        state=pulumi.get(__ret__, 'state'))
def get_migration_plans_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMigrationPlansFilterArgs', 'GetMigrationPlansFilterArgsDict']]]]] = None,
                               migration_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               migration_plan_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMigrationPlansResult]:
    """
    This data source provides the list of Migration Plans in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migration plans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plans = oci.CloudMigrations.get_migration_plans(compartment_id=compartment_id,
        display_name=migration_plan_display_name,
        migration_id=test_migration["id"],
        migration_plan_id=test_migration_plan["id"],
        state=migration_plan_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire given display name.
    :param builtins.str migration_id: Unique migration identifier
    :param builtins.str migration_plan_id: Unique migration plan identifier
    :param builtins.str state: The current state of the migration plan.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationId'] = migration_id
    __args__['migrationPlanId'] = migration_plan_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudMigrations/getMigrationPlans:getMigrationPlans', __args__, opts=opts, typ=GetMigrationPlansResult)
    return __ret__.apply(lambda __response__: GetMigrationPlansResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        migration_id=pulumi.get(__response__, 'migration_id'),
        migration_plan_collections=pulumi.get(__response__, 'migration_plan_collections'),
        migration_plan_id=pulumi.get(__response__, 'migration_plan_id'),
        state=pulumi.get(__response__, 'state')))
