# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkRequestsResult',
    'AwaitableGetWorkRequestsResult',
    'get_work_requests',
    'get_work_requests_output',
]

@pulumi.output_type
class GetWorkRequestsResult:
    """
    A collection of values returned by getWorkRequests.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, filters=None, id=None, resource_id=None, resource_type=None, statuses=None, work_requests=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if work_requests and not isinstance(work_requests, list):
            raise TypeError("Expected argument 'work_requests' to be a list")
        pulumi.set(__self__, "work_requests", work_requests)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment in which the work request exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWorkRequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[builtins.str]]:
        """
        The current status of the work request.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="workRequests")
    def work_requests(self) -> Sequence['outputs.GetWorkRequestsWorkRequestResult']:
        """
        The list of work_requests.
        """
        return pulumi.get(self, "work_requests")


class AwaitableGetWorkRequestsResult(GetWorkRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkRequestsResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            resource_id=self.resource_id,
            resource_type=self.resource_type,
            statuses=self.statuses,
            work_requests=self.work_requests)


def get_work_requests(cluster_id: Optional[builtins.str] = None,
                      compartment_id: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetWorkRequestsFilterArgs', 'GetWorkRequestsFilterArgsDict']]] = None,
                      resource_id: Optional[builtins.str] = None,
                      resource_type: Optional[builtins.str] = None,
                      statuses: Optional[Sequence[builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkRequestsResult:
    """
    This data source provides the list of Work Requests in Oracle Cloud Infrastructure Container Engine service.

    List all work requests in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_work_requests = oci.ContainerEngine.get_work_requests(compartment_id=compartment_id,
        cluster_id=test_cluster["id"],
        resource_id=test_resource["id"],
        resource_type=work_request_resource_type,
        statuses=work_request_status)
    ```


    :param builtins.str cluster_id: The OCID of the cluster.
    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str resource_id: The OCID of the resource associated with a work request
    :param builtins.str resource_type: Type of the resource associated with a work request
    :param Sequence[builtins.str] statuses: A work request status to filter on. Can have multiple parameters of this name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getWorkRequests:getWorkRequests', __args__, opts=opts, typ=GetWorkRequestsResult).value

    return AwaitableGetWorkRequestsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        statuses=pulumi.get(__ret__, 'statuses'),
        work_requests=pulumi.get(__ret__, 'work_requests'))
def get_work_requests_output(cluster_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkRequestsFilterArgs', 'GetWorkRequestsFilterArgsDict']]]]] = None,
                             resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             resource_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             statuses: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkRequestsResult]:
    """
    This data source provides the list of Work Requests in Oracle Cloud Infrastructure Container Engine service.

    List all work requests in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_work_requests = oci.ContainerEngine.get_work_requests(compartment_id=compartment_id,
        cluster_id=test_cluster["id"],
        resource_id=test_resource["id"],
        resource_type=work_request_resource_type,
        statuses=work_request_status)
    ```


    :param builtins.str cluster_id: The OCID of the cluster.
    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str resource_id: The OCID of the resource associated with a work request
    :param builtins.str resource_type: Type of the resource associated with a work request
    :param Sequence[builtins.str] statuses: A work request status to filter on. Can have multiple parameters of this name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getWorkRequests:getWorkRequests', __args__, opts=opts, typ=GetWorkRequestsResult)
    return __ret__.apply(lambda __response__: GetWorkRequestsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        statuses=pulumi.get(__response__, 'statuses'),
        work_requests=pulumi.get(__response__, 'work_requests')))
